// ==UserScript==
// @name         Bilibili Evolved
// @version      1.10.12
// @description  强大的哔哩哔哩增强脚本: 下载视频, 音乐, 封面, 弹幕 / 简化直播间, 评论区, 首页 / 自定义顶栏, 删除广告, 夜间模式 / 触屏设备支持
// @author       Grant Howard, Coulomb-G
// @copyright    2020, Grant Howard (https://github.com/the1812) & Coulomb-G (https://github.com/Coulomb-G)
// @license      MIT
// @match        *://*.bilibili.com/*
// @run-at       document-start
// @supportURL   https://github.com/the1812/Bilibili-Evolved/issues
// @homepage     https://github.com/the1812/Bilibili-Evolved
// @grant        unsafeWindow
// @grant        GM_getValue
// @grant        GM_setValue
// @grant        GM_setClipboard
// @grant        GM_info
// @grant        GM_xmlhttpRequest
// @grant        GM.getValue
// @grant        GM.setValue
// @grant        GM.setClipboard
// @grant        GM.info
// @grant        GM.xmlHttpRequest
// @connect      raw.githubusercontent.com
// @connect      cdn.jsdelivr.net
// @connect      cn.bing.com
// @connect      www.bing.com
// @connect      translate.google.cn
// @connect      translate.google.com
// @connect      *
// @require      https://code.jquery.com/jquery-3.4.0.min.js
// @require      https://cdn.jsdelivr.net/npm/lodash@4.17.15/lodash.min.js
// @require      https://cdn.bootcss.com/jszip/3.1.5/jszip.min.js
// @require      https://cdn.jsdelivr.net/npm/vue@2.6.10/dist/vue.js
// @require      https://unpkg.com/vuex@3.1.2/dist/vuex.js
// @icon         https://cdn.jsdelivr.net/gh/the1812/Bilibili-Evolved@preview/images/logo-small.png
// @icon64       https://cdn.jsdelivr.net/gh/the1812/Bilibili-Evolved@preview/images/logo.png
// @namespace https://greasyfork.org/users/221184
// ==/UserScript==
Vue.config.productionTip = false
Vue.config.devtools = false
// if (unsafeWindow.Vue === undefined) {
//   unsafeWindow.Vue = Vue
// }

// GM4 polyfill start
if (typeof GM == 'undefined') {
  this.GM = {}
}
Object.entries({
  'log': console.log.bind(console),
  'info': GM_info,
}).forEach(([newKey, old]) => {
  if (old && (typeof GM[newKey] == 'undefined')) {
    GM[newKey] = old
  }
})
Object.entries({
  'GM_getValue': 'getValue',
  'GM_setClipboard': 'setClipboard',
  'GM_setValue': 'setValue',
  'GM_xmlhttpRequest': 'xmlHttpRequest',
}).forEach(([oldKey, newKey]) => {
  let old = this[oldKey]
  if (old && (typeof GM[newKey] == 'undefined')) {
    GM[newKey] = function (...args) {
      return new Promise((resolve, reject) => {
        try {
          resolve(old.apply(this, args))
        } catch (e) {
          reject(e)
        }
      })
    }
  }
})
// GM4 polyfill end

// Safari EventTarget polyfill
window.EventTarget = class EventTarget {
  constructor() {
    this.listeners = {}
  }
  addEventListener(type, callback) {
    if (!(type in this.listeners)) {
      this.listeners[type] = []
    }
    this.listeners[type].push(callback)
  }
  removeEventListener(type, callback) {
    if (!(type in this.listeners)) {
      return
    }
    let stack = this.listeners[type]
    for (let i = 0, l = stack.length; i < l; i++) {
      if (stack[i] === callback) {
        stack.splice(i, 1)
        return
      }
    }
  }
  dispatchEvent(event) {
    if (!(event.type in this.listeners)) {
      return true
    }
    let stack = this.listeners[event.type].slice()
    for (let i = 0, l = stack.length; i < l; i++) {
      stack[i].call(this, event)
    }
    return !event.defaultPrevented
  }
}
// Safari EventTarget polyfill end

function logError (error) {
  let finalMessage = error
  if (typeof error === 'object' && 'stack' in error) {
    if (settings.toastInternalError) {
      finalMessage = `${error.message}\n${error.stack}`
    } else {
      finalMessage = error.message
    }
  }
  Toast.error(finalMessage, '错误')
  console.error(error)
}
function raiseEvent (element, eventName) {
  const event = document.createEvent('HTMLEvents')
  event.initEvent(eventName, true, true)
  element.dispatchEvent(event)
}
async function loadLazyPanel (selector) {
  await SpinQuery.unsafeJquery()
  const panel = await SpinQuery.any(() => unsafeWindow.$(selector))
  if (!panel) {
    throw new Error(`Panel not found: ${selector}`)
  }
  panel.mouseover()
  // 懒加载面板带有 300ms 的 denounce
  return new Promise(resolve => {
    setTimeout(() => {
      panel.mouseout()
      resolve()
    }, 310)
  })
}
async function loadLazyPlayerSettingsPanel (buttonSelector, panelSelector) {
  // 暂时隐藏面板
  const style = document.createElement('style')
  style.innerText = `${panelSelector} { display: none !important; }`
  document.body.insertAdjacentElement('beforeend', style)
  await loadLazyPanel(buttonSelector)
  // 有些面板有 300ms 的 transition delay
  setTimeout(() => style.remove(), 300)
  return dq(panelSelector)
}
async function loadDanmakuSettingsPanel () {
  return await loadLazyPlayerSettingsPanel('.bilibili-player-video-danmaku-setting', '.bilibili-player-video-danmaku-setting-wrap')
}
async function loadSubtitleSettingsPanel () {
  return await loadLazyPlayerSettingsPanel('.bilibili-player-video-btn-subtitle', '.bilibili-player-video-subtitle-setting-wrap')
}
function contentLoaded (callback) {
  if (/complete|interactive|loaded/.test(document.readyState)) {
    callback()
  } else {
    document.addEventListener('DOMContentLoaded', () => callback())
  }
}
function fullyLoaded (callback) {
  if (document.readyState === 'complete') {
    callback()
  } else {
    unsafeWindow.addEventListener('load', () => callback())
  }
}
function fixed (number, precision = 1) {
  const str = number.toString()
  const index = str.indexOf('.')
  if (index !== -1) {
    if (str.length - index > precision + 1) {
      return str.substring(0, index + precision + 1)
    } else {
      return str
    }
  } else {
    return str + '.0'
  }
}
function isEmbeddedPlayer () {
  return location.host === 'player.bilibili.com' || document.URL.startsWith('https://www.bilibili.com/html/player.html')
}
function isIframe () {
  return document.body && unsafeWindow.parent.window !== unsafeWindow
}
const languageNameToCode = {
  '日本語': 'ja-JP',
  'English': 'en-US',
  'Deutsch': 'de-DE'
}
const languageCodeToName = {
  'ja-JP': '日本語',
  'en-US': 'English',
  'de-DE': 'Deutsch'
}
function getI18nKey () {
  return settings.i18n ? languageNameToCode[settings.i18nLanguage] : 'zh-CN'
}
const dq = (selector, scopedSelector) => {
  if (!scopedSelector) {
    return document.querySelector(selector)
  }
  return selector.querySelector(scopedSelector)
}
const dqa = (selector, scopedSelector) => {
  if (!scopedSelector) {
    return [...document.querySelectorAll(selector)]
  }
  return [...selector.querySelectorAll(scopedSelector)]
}
const UserAgent = `Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:67.0) Gecko/20100101 Firefox/67.0`
const EmptyImageUrl = 'data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1"></svg>'
const ascendingSort = (itemProp) => {
  return (a, b) => itemProp(a) - itemProp(b)
}
const descendingSort = (itemProp) => {
  return (a, b) => itemProp(b) - itemProp(a)
}
const formatFileSize = (bytes, fixed = 1) => {
  const units = ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB']
  let number = bytes
  let unitIndex = 0
  while (number >= 1024) {
    number /= 1024
    unitIndex++
  }
  return `${Math.round(number * (10 ** fixed)) / (10 ** fixed)}${units[unitIndex]}`
}
const formatDuration = (time, fixed = 0) => {
  const second = (time % 60).toFixed(fixed)
  const minute = (Math.trunc(time / 60) % 60).toString()
  const hour = Math.trunc(time / 3600).toString()
  if (hour === '0') {
    return `${minute.padStart(2, '0')}:${second.padStart(2, '0')}`
  }
  return `${hour}:${minute.padStart(2, '0')}:${second.padStart(2, '0')}`
}
const getDpiSourceSet = (src, baseSize, extension = 'jpg') => {
  const dpis = [1, 1.25, 1.5, 1.75, 2, 2.25, 2.5, 2.75, 3, 3.25, 3.5, 3.75, 4]
  if (extension.startsWith('.')) {
    extension = extension.substring(1)
  }
  return dpis.map(dpi => {
    if (typeof baseSize === 'object') {
      if ('width' in baseSize && 'height' in baseSize) {
        return `${src}@${Math.trunc(baseSize.width * dpi)}w_${Math.trunc(baseSize.height * dpi)}h.${extension} ${dpi}x`
      } else if ('width' in baseSize) {
        return `${src}@${Math.trunc(baseSize.width * dpi)}w.${extension} ${dpi}x`
      } else if ('height' in baseSize) {
        return `${src}@${Math.trunc(baseSize.height * dpi)}h.${extension} ${dpi}x`
      }
    } else {
      return `${src}@${Math.trunc(baseSize * dpi)}w_${Math.trunc(baseSize * dpi)}h.${extension} ${dpi}x`
    }
  }).join(",")
}
const isOffline = () => typeof offlineData !== 'undefined'
const getUID = () => document.cookie.replace(/(?:(?:^|.*;\s*)DedeUserID\s*\=\s*([^;]*).*$)|^.*$/, '$1')
const scriptVersion = (() => {
  const match = GM.info.script.name.match(/Bilibili Evolved \((.*)\)/)
  return match ? match[1] : 'Stable'
})()
const getCsrf = () => document.cookie.replace(/(?:(?:^|.*;\s*)bili_jct\s*\=\s*([^;]*).*$)|^.*$/, '$1')
const formatCount = (count) => {
  if (typeof count === 'string') {
    count = parseInt(count)
  }
  if (count > 100000000) {
    return Math.round(count / 10000000) / 10 + '亿'
  }
  if (count > 10000) {
    return Math.round(count / 1000) / 10 + '万'
  }
  return count + ''
}
const escapeFilename = (filename, replacement = '') => {
  return filename.replace(/[\/\\:\*\?"<>\|]/g, replacement)
}
function html (strings, ...values) {
  return [...strings].reduce((previous, current, index) => {
    const value = values[index]
    return previous + current + (value === undefined ? '' : value)
  }, '')
}
const dashExtensions = ['.mp4', '.m4a']
const dashFragmentExtension = 'm4s'
const videoCondition = async () => {
  let cid = await SpinQuery.select(() => (unsafeWindow || window).cid)
  return Boolean(cid)
}

const customNavbarDefaultOrders = {
  blank1: 0,
  logo: 1,
  category: 2,
  rankingLink: 3,
  drawingLink: 4,
  musicLink: 5,
  gamesIframe: 6,
  livesIframe: 7,
  shopLink: 8,
  mangaLink: 9,
  blank2: 10,
  search: 11,
  blank3: 12,
  userInfo: 13,
  messages: 14,
  activities: 15,
  bangumi: 16,
  watchlaterList: 17,
  favoritesList: 18,
  historyList: 19,
  upload: 20,
}
const simpleHomeCategoryDefaultOrders = {
  anime: 0,
  bangumi: 1,
  china: 2,
  manga: 3,
  music: 4,
  dance: 5,
  game: 6,
  tech: 7,
  digital: 8,
  life: 9,
  kichiku: 10,
  fashion: 11,
  ads: 12,
  entertainment: 13,
  column: 14,
  movie: 15,
  tv: 16,
  film: 17,
  documentary: 18,
}
const aria2RpcDefaultOption = {
  secretKey: '',
  dir: '',
  host: '127.0.0.1',
  port: '6800',
  method: 'get',
  skipByDefault: false,
  maxDownloadLimit: '',
  baseDir: '',
}
const settings = {
  useDarkStyle: false,
  compactLayout: false,
  // showBanner: true,
  hideBanner: false,
  expandDanmakuList: true,
  expandDescription: true,
  watchLaterRedirect: true,
  touchNavBar: false,
  touchVideoPlayer: false,
  customControlBackgroundOpacity: 0.64,
  customControlBackground: false,
  darkScheduleStart: '18:00',
  darkScheduleEnd: '6:00',
  darkSchedule: false,
  toast: true,
  fullTweetsTitle: true,
  fullPageTitle: false,
  removeVideoTopMask: false,
  removeLiveWatermark: true,
  harunaScale: true,
  removeAds: true,
  showBlockedAdsTip: false,
  hideTopSearch: false,
  touchVideoPlayerDoubleTapControl: false,
  customStyleColor: '#00A0D8',
  preserveRank: true,
  blurBackgroundOpacity: 0.382,
  useDefaultPlayerMode: false,
  applyPlayerModeOnPlay: true,
  defaultPlayerMode: '常规',
  useDefaultVideoQuality: false,
  defaultVideoQuality: '自动',
  useDefaultDanmakuSettings: false,
  enableDanmaku: true,
  rememberDanmakuSettings: false,
  danmakuSettings: {
    subtitlesPreserve: false,
    smartMask: false,
  },
  defaultPlayerLayout: '新版',
  defaultBangumiLayout: '新版',
  skipChargeList: false,
  comboLike: false,
  autoLightOff: false,
  useCache: true,
  autoContinue: false,
  allowJumpContinue: false,
  autoPlay: false,
  deadVideoTitleProvider: '稍后再看',
  useBiliplusRedirect: false,
  biliplusRedirect: false,
  framePlayback: true,
  useCommentStyle: true,
  imageResolution: false,
  imageResolutionScale: 'auto',
  toastInternalError: false,
  i18n: false,
  i18nLanguage: '日本語',
  playerFocus: false,
  playerFocusOffset: -10,
  simplifyLiveroom: false,
  simplifyLiveroomSettings: {
    vip: true,
    fansMedal: true,
    title: true,
    userLevel: true,
    guard: true,
    systemMessage: true,
    welcomeMessage: true,
    giftMessage: true,
    guardPurchase: true,
    giftPanel: true,
    kanban: true,
    userEffect: true,
    eventsBanner: false,
    rankList: false,
    popup: false,
    skin: false,
  },
  customNavbar: true,
  customNavbarFill: false,
  customNavbarTransparent: true,
  customNavbarShadow: true,
  customNavbarCompact: false,
  customNavbarBlur: false,
  customNavbarBlurOpacity: 0.7,
  customNavbarOrder: { ...customNavbarDefaultOrders },
  customNavbarHidden: ['blank1', 'drawingLink', 'musicLink', 'gamesIframe'],
  customNavbarBoundsPadding: 10,
  playerShadow: false,
  narrowDanmaku: true,
  favoritesRedirect: true,
  outerWatchlater: true,
  hideOldEntry: true,
  videoScreenshot: false,
  hideBangumiReviews: false,
  filenameFormat: '[title][ - ep]',
  batchFilenameFormat: '[n - ][ep]',
  sideBarOffset: 0,
  noLiveAutoplay: false,
  hideHomeLive: false,
  noMiniVideoAutoplay: false,
  useDefaultVideoSpeed: false,
  defaultVideoSpeed: '1.0',
  hideCategory: false,
  foldComment: true,
  downloadVideoDefaultDanmaku: '无',
  aria2RpcOption: { ...aria2RpcDefaultOption },
  aria2RpcOptionSelectedProfile: '',
  aria2RpcOptionProfiles: [],
  searchHistory: [],
  seedsToCoins: true,
  autoSeedsToCoins: true,
  lastSeedsToCoinsDate: 0,
  autoDraw: false,
  keymap: false,
  doubleClickFullscreen: false,
  doubleClickFullscreenPreventSingleClick: false,
  simplifyHome: false,
  simplifyHomeStyle: '清爽',
  minimalHomeSettings: {
    showSearch: true,
    backgroundImage: '',
  },
  ajaxHook: false,
  scriptLoadingMode: '延后(自动)',
  scriptDownloadMode: 'bundle',
  guiSettingsDockSide: '左侧',
  fullActivityContent: true,
  feedsFilter: false,
  feedsFilterPatterns: [],
  feedsFilterTypes: [],
  feedsFilterSideCards: [],
  activityImageSaver: false,
  scriptBlockPatterns: [],
  customNavbarSeasonLogo: false,
  selectableColumnText: true,
  downloadVideoFormat: 'flv',
  downloadVideoDashCodec: 'AVC/H.264',
  watchlaterExpireWarningDays: 14,
  superchatTranslate: false,
  miniPlayerTouchMove: false,
  hideBangumiSponsors: false,
  hideRecommendLive: false,
  hideRelatedVideos: false,
  defaultMedalID: 0,
  autoMatchMedal: false,
  customStyles: [],
  simpleHomeCategoryOrders: { ...simpleHomeCategoryDefaultOrders },
  simpleHomeBangumiLayout: '时间表',
  keymapJumpSeconds: 85,
  urlParamsClean: true,
  collapseLiveSideBar: true,
  removeGameMatchModule: false,
  noDarkOnMember: true,
  feedsTranslate: false,
  feedsTranslateProvider: 'Bing',
  feedsTranslateLanguage: '',
  downloadVideoQuality: 120,
  defaultLiveQuality: '原画',
  useDefaultLiveQuality: false,
  recordLiveDanmaku: false,
  foregroundColorMode: '自动',
  preserveEventBanner: false,
  about: true,
  bvidConvert: true,
  cache: {},
}
const fixedSettings = {
  guiSettings: true,
  viewCover: true,
  notifyNewVersion: true,
  clearCache: true,
  downloadVideo: true,
  enableDashDownload: true,
  downloadDanmaku: true,
  downloadSubtitle: true,
  downloadAudio: true,
  downloadLiveRecords: true,
  medalHelper: true,
  playerLayout: false,
  forceWide: false,
  useNewStyle: false,
  overrideNavBar: false,
  touchVideoPlayerAnimation: false,
  allNavbarFill: false,
  showDeadVideoTitle: false,
  blurVideoControl: false,
  oldTweets: false,
  watchlaterExpireWarnings: false,
  latestVersionLink: 'https://cdn.jsdelivr.net/gh/the1812/Bilibili-Evolved@master/bilibili-evolved.user.js',
  currentVersion: GM.info.script.version,
}
const settingsChangeHandlers = {}
function addSettingsListener (key, handler, initCall) {
  if (!settingsChangeHandlers[key]) {
    settingsChangeHandlers[key] = [handler]
  } else {
    settingsChangeHandlers[key].push(handler)
  }
  if (initCall) {
    const value = settings[key]
    handler(value, value)
  }
}
function removeSettingsListener (key, handler) {
  const handlers = settingsChangeHandlers[key]
  if (!handlers) {
    return
  }
  handlers.splice(handlers.indexOf(handler), 1)
}
async function loadSettings () {
  for (const key in fixedSettings) {
    settings[key] = fixedSettings[key]
    await GM.setValue(key, fixedSettings[key])
  }
  if (Object.keys(languageCodeToName).includes(navigator.language)) {
    settings.i18n = true
    settings.i18nLanguage = languageCodeToName[navigator.language]
  }
  for (const key in settings) {
    let value = await GM.getValue(key)
    if (key === 'batchFilenameFormat' && value === '[n - ][title]') {
      value = '[n - ][ep]'
      GM.setValue(key, value)
    }
    if (value === undefined) {
      value = settings[key]
      GM.setValue(key, settings[key])
    } else if (settings[key] !== undefined && value.constructor === Object) {
      value = Object.assign(settings[key], value)
    }
    Object.defineProperty(settings, key, {
      get () {
        return value
      },
      set (newValue) {
        value = newValue
        GM.setValue(key, newValue)

        const handlers = settingsChangeHandlers[key]
        if (handlers) {
          if (key === 'useDarkStyle') {
            setTimeout(() => handlers.forEach(h => h(newValue, value)), 200)
          } else {
            handlers.forEach(h => h(newValue, value))
          }
        }
        const input = document.querySelector(`input[key=${key}]`)
        if (input !== null) {
          if (input.type === 'checkbox') {
            input.checked = newValue
          } else if (input.type === 'text' && !input.parentElement.classList.contains('gui-settings-dropdown')) {
            input.value = newValue
          }
        }
      }
    })
  }
}

class Ajax {
  static send (xhr, body, text = true) {
    return new Promise((resolve, reject) => {
      xhr.addEventListener('load', () => {
        // if (xhr.status.toString().match(/^[45]/)) {
        //   reject(xhr.status)
        // } else {
        resolve(text ? xhr.responseText : xhr.response)
        // }
      })
      xhr.addEventListener('error', () => reject(xhr.status))
      xhr.send(body)
    })
  }
  static getBlob (url) {
    const xhr = new XMLHttpRequest()
    xhr.responseType = 'blob'
    xhr.open('GET', url)
    return this.send(xhr, undefined, false)
  }
  static getBlobWithCredentials (url) {
    const xhr = new XMLHttpRequest()
    xhr.responseType = 'blob'
    xhr.open('GET', url)
    xhr.withCredentials = true
    return this.send(xhr, undefined, false)
  }
  static async getJson (url) {
    return JSON.parse(await this.getText(url))
  }
  static async getJsonWithCredentials (url) {
    return JSON.parse(await this.getTextWithCredentials(url))
  }
  static getText (url) {
    const xhr = new XMLHttpRequest()
    xhr.open('GET', url)
    return this.send(xhr)
  }
  static getTextWithCredentials (url) {
    const xhr = new XMLHttpRequest()
    xhr.open('GET', url)
    xhr.withCredentials = true
    return this.send(xhr)
  }
  static postText (url, body) {
    const xhr = new XMLHttpRequest()
    xhr.open('POST', url)
    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded')
    return this.send(xhr, body)
  }
  static postTextWithCredentials (url, body) {
    const xhr = new XMLHttpRequest()
    xhr.open('POST', url)
    xhr.withCredentials = true
    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded')
    return this.send(xhr, body)
  }
  static postJson (url, json) {
    const xhr = new XMLHttpRequest()
    xhr.open('POST', url)
    xhr.setRequestHeader('Content-Type', 'application/json')
    return this.send(xhr, JSON.stringify(json), false)
  }
  static postJsonWithCredentials (url, json) {
    const xhr = new XMLHttpRequest()
    xhr.open('POST', url)
    xhr.withCredentials = true
    xhr.setRequestHeader('Content-Type', 'application/json')
    return this.send(xhr, JSON.stringify(json), false)
  }
  static getHandlers (name) {
    name = name.toLowerCase()
    let handlers = Ajax[name]
    if (handlers === undefined) {
      handlers = Ajax[name] = []
    }
    return handlers
  }
  static addEventListener (type, handler) {
    const handlers = Ajax.getHandlers(type)
    handlers.push(handler)
  }
  static removeEventListener (type, handler) {
    const handlers = Ajax.getHandlers(type)
    handlers.splice(handlers.indexOf(handler), 1)
  }
  static monkey (details) {
    return new Promise((resolve, reject) => {
      const fullDetails = {
        ...details,
        onload: r => resolve(r.response),
        onerror: r => reject(r),
      }
      if (!('method' in fullDetails)) {
        fullDetails.method = 'GET'
      }
      GM.xmlHttpRequest(fullDetails)
    })
  }
}
// https://github.com/the1812/Bilibili-Evolved/issues/84
let ajaxHooked = false
function setupAjaxHook () {
  if (ajaxHooked) {
    return
  }
  ajaxHooked = true
  const original = {
    open: XMLHttpRequest.prototype.open,
    send: XMLHttpRequest.prototype.send
  }
  const fireHandlers = (name, thisArg, ...args) => Ajax.getHandlers(name).forEach(it => it.call(thisArg, ...args))
  const hook = (name, thisArgs, ...args) => {
    fireHandlers('before' + name, thisArgs, ...args)
    const returnValue = original[name].call(thisArgs, ...args)
    fireHandlers('after' + name, thisArgs, ...args)
    return returnValue
  }
  const hookOnEvent = (name, thisArg) => {
    if (thisArg[name]) {
      const originalHandler = thisArg[name]
      thisArg[name] = (...args) => {
        fireHandlers('before' + name, thisArg, ...args)
        originalHandler.apply(thisArg, args)
        fireHandlers('after' + name, thisArg, ...args)
      }
    } else {
      thisArg[name] = (...args) => {
        fireHandlers('before' + name, thisArg, ...args)
        fireHandlers('after' + name, thisArg, ...args)
      }
    }
  }
  XMLHttpRequest.prototype.open = function (...args) { return hook('open', this, ...args) }
  XMLHttpRequest.prototype.send = function (...args) {
    hookOnEvent('onreadystatechange', this)
    hookOnEvent('onload', this)
    return hook('send', this, ...args)
  }
}

function loadResources () {
  Resource.root = 'https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/'
  Resource.cdnRoot = 'https://cdn.jsdelivr.net/gh/the1812/Bilibili-Evolved@preview/'
  Resource.all = {}
  Resource.displayNames = {}
  Resource.reloadables = []
  for (const [key, data] of Object.entries(Resource.manifest)) {
    const resource = new Resource(data.path, { styles: data.styles, alwaysPreview: data.alwaysPreview })
    resource.key = key
    resource.dropdown = data.dropdown
    if (data.reloadable) {
      Resource.reloadables.push(key)
    }
    if (data.displayNames) {
      resource.displayName = data.displayNames[key]
      Object.assign(Resource.displayNames, data.displayNames)
    }
    if (data.style) {
      const styleKey = key + 'Style'
      const style = Resource.all[styleKey] = new Resource(data.path.replace('.js', '.css'), { alwaysPreview: data.alwaysPreview })
      style.key = styleKey
      switch (data.style) {
        case 'instant':
        {
          resource.styles.push(styleKey)
          break
        }
        case true:
        {
          resource.dependencies.push(style)
          break
        }
        case 'important':
        {
          resource.styles.push({
            key: styleKey,
            important: true
          })
          break
        }
        default:
        {
          if (typeof data.style === 'object') {
            resource.styles.push(Object.assign({ key: styleKey }, data.style))
          }
          break
        }
      }
    }
    if (data.html === true) {
      const htmlKey = key + 'Html'
      const html = Resource.all[htmlKey] = new Resource(data.path.replace('.js', '.html'), { alwaysPreview: data.alwaysPreview })
      html.key = htmlKey
      resource.dependencies.push(html)
    }
    Resource.all[key] = resource
  }
  for (const [key, data] of Object.entries(Resource.manifest)) {
    if (data.dependencies) {
      Resource.all[key].dependencies.push(...data.dependencies.map(name => Resource.all[name]))
    }
  }
}

// Placeholder class for Toast
class Toast {
  show () { }
  dismiss () { }
  static show () { }
  static info () { }
  static success () { }
  static error () { }
}

class DoubleClickEvent {
  constructor (handler, singleClickHandler = null) {
    this.handler = handler
    this.singleClickHandler = singleClickHandler
    this.elements = []
    this.clickedOnce = false
    this.doubleClickHandler = e => {
      if (!this.clickedOnce) {
        this.clickedOnce = true
        setTimeout(() => {
          if (this.clickedOnce) {
            this.clickedOnce = false
            this.singleClickHandler && this.singleClickHandler(e)
          }
        }, 200)
      } else {
        this.clickedOnce = false
        this.handler && this.handler(e)
      }
    }
  }
  bind (element) {
    if (this.elements.indexOf(element) === -1) {
      this.elements.push(element)
      element.addEventListener('click', this.doubleClickHandler)
    }
  }
  unbind (element) {
    const index = this.elements.indexOf(element)
    if (index === -1) {
      return
    }
    this.elements.splice(index, 1)
    element.removeEventListener('click', this.doubleClickHandler)
  }
}

let cidHooked = false
const videoChangeCallbacks = []
class Observer {
  constructor (elements, callback) {
    this.elements = elements || []
    this.callback = callback
    this.observer = null
    this.options = undefined
  }
  start () {
    this.elements.forEach(element => {
      this.observer = new MutationObserver(this.callback)
      this.observer.observe(element, this.options)
    })
    return this
  }
  add (element) {
    this.elements.push(element)
    this.observer.observe(element, this.options)
    return this
  }
  stop () {
    this.observer && this.observer.disconnect()
    return this
  }
  // 向后兼容的接口, 实际并没有什么遍历
  forEach (callback) {
    callback(this)
  }
  static observe (selector, callback, options) {
    callback([])
    let elements = selector
    if (typeof selector === 'string') {
      elements = [...document.querySelectorAll(selector)]
    } else if (!Array.isArray(selector)) {
      elements = [selector]
    }
    const observer = new Observer(elements, callback)
    observer.options = options
    return observer.start()
  }
  static childList (selector, callback) {
    return Observer.observe(selector, callback, {
      childList: true,
      subtree: false,
      attributes: false
    })
  }
  static childListSubtree (selector, callback) {
    return Observer.observe(selector, callback, {
      childList: true,
      subtree: true,
      attributes: false
    })
  }
  static attributes (selector, callback) {
    return Observer.observe(selector, callback, {
      childList: false,
      subtree: false,
      attributes: true
    })
  }
  static attributesSubtree (selector, callback) {
    return Observer.observe(selector, callback, {
      childList: false,
      subtree: true,
      attributes: true
    })
  }
  static all (selector, callback) {
    return Observer.observe(selector, callback, {
      childList: true,
      subtree: true,
      attributes: true
    })
  }
  static async videoChange (callback) {
    const cid = await SpinQuery.select(() => unsafeWindow.cid)
    if (cid === null) {
      return
    }
    if (!cidHooked) {
      let hookedCid = cid
      Object.defineProperty(unsafeWindow, 'cid', {
        get () {
          return hookedCid
        },
        set (newId) {
          hookedCid = newId
          if (!Array.isArray(newId)) {
            videoChangeCallbacks.forEach(it => it())
          }
        }
      })
      cidHooked = true
    }
    // callback();
    const videoContainer = await SpinQuery.select('#bofqi video')
    if (videoContainer) {
      Observer.childList(videoContainer, callback)
    } else {
      callback()
    }
    videoChangeCallbacks.push(callback)
  }
}

class SpinQuery {
  constructor (query, condition, action, failed) {
    this.maxRetry = 15
    this.retry = 0
    this.queryInterval = 1000
    this.query = query
    this.condition = condition
    this.action = action
    this.failed = failed
  }
  start () {
    this.tryQuery(this.query, this.condition, this.action, this.failed)
  }
  tryQuery (query, condition, action, failed) {
    if (this.retry < this.maxRetry) {
      const result = query()
      if (condition(result)) {
        action(result)
      } else {
        if (document.hasFocus()) {
          this.retry++
        }
        setTimeout(() => this.tryQuery(query, condition, action, failed), this.queryInterval)
      }
    } else {
      typeof failed === 'function' && failed()
    }
  }
  static condition (query, condition, action, failed) {
    if (action !== undefined) {
      new SpinQuery(query, condition, action, failed).start()
    } else {
      return new Promise((resolve) => {
        new SpinQuery(query, condition, it => resolve(it), () => resolve(null)).start()
      })
    }
  }
  static select (query, action, failed) {
    if (typeof query === 'string') {
      const selector = query
      query = () => document.querySelector(selector)
    }
    return SpinQuery.condition(query, it => it !== null && it !== undefined, action, failed)
  }
  static any (query, action, failed) {
    if (typeof query === 'string') {
      const selector = query
      query = () => $(selector)
    }
    return SpinQuery.condition(query, it => it.length > 0, action, failed)
  }
  static count (query, count, action, failed) {
    if (typeof query === 'string') {
      const selector = query
      query = () => document.querySelectorAll(selector)
    }
    return SpinQuery.condition(query, it => it.length === count, action, failed)
  }
  static unsafeJquery (action, failed) {
    return SpinQuery.condition(() => unsafeWindow.$, jquery => jquery !== undefined, action, failed)
  }
}

class ColorProcessor {
  constructor (hex) {
    this.hex = hex
  }
  get rgb () {
    return this.hexToRgb(this.hex)
  }
  get rgba () {
    return this.hexToRgba(this.hex)
  }
  getHexRegex (alpha, shorthand) {
    const repeat = shorthand ? '' : '{2}'
    const part = `([a-f\\d]${repeat})`
    const count = alpha ? 4 : 3
    const pattern = `#?${part.repeat(count)}`
    return new RegExp(pattern, 'ig')
  }
  hexToRgbOrRgba (hex, alpha) {
    const isShortHand = hex.length < 6
    if (isShortHand) {
      const shorthandRegex = this.getHexRegex(alpha, true)
      hex = hex.replace(shorthandRegex, function (...args) {
        let result = ''
        let i = 1
        while (args[i]) {
          result += args[i].repeat(2)
          i++
        }
        return result
      })
    }

    const regex = this.getHexRegex(alpha, false)
    const regexResult = regex.exec(hex)
    if (regexResult) {
      const color = {
        r: parseInt(regexResult[1], 16),
        g: parseInt(regexResult[2], 16),
        b: parseInt(regexResult[3], 16)
      }
      if (regexResult[4]) {
        color.a = parseInt(regexResult[4], 16) / 255
      }
      return color
    } else if (alpha) {
      const rgb = this.hexToRgbOrRgba(hex, false)
      if (rgb) {
        rgb.a = 1
        return rgb
      }
    }
    return null
  }
  hexToRgb (hex) {
    return this.hexToRgbOrRgba(hex, false)
  }
  hexToRgba (hex) {
    return this.hexToRgbOrRgba(hex, true)
  }
  rgbToString (color) {
    if (color.a) {
      return `rgba(${color.r},${color.g},${color.b},${color.a})`
    }
    return `rgb(${color.r},${color.g},${color.b})`
  }
  rgbToHsb (rgb) {
    const { r, g, b } = rgb
    const max = Math.max(r, g, b)
    const min = Math.min(r, g, b)
    const delta = max - min
    const s = Math.round((max === 0 ? 0 : delta / max) * 100)
    const v = Math.round(max / 255 * 100)

    let h
    if (delta === 0) {
      h = 0
    } else if (r === max) {
      h = (g - b) / delta % 6
    } else if (g === max) {
      h = (b - r) / delta + 2
    } else if (b === max) {
      h = (r - g) / delta + 4
    }
    h = Math.round(h * 60)
    if (h < 0) {
      h += 360
    }

    return { h: h, s: s, b: v }
  }
  get hsb () {
    return this.rgbToHsb(this.rgb)
  }
  get grey () {
    const color = this.rgb
    return 1 - (0.299 * color.r + 0.587 * color.g + 0.114 * color.b) / 255
  }
  get foreground () {
    const color = this.rgb
    const mode = settings.foregroundColorMode
    if (mode === '自动' || mode === undefined) {
      if (color && this.grey < 0.35) {
        return '#000'
      }
      return '#fff'
    } else if (mode === '黑色') {
      return '#000'
    } else if (mode === '白色') {
      return '#fff'
    }
  }
  makeImageFilter (originalRgb) {
    const { h, s } = this.rgbToHsb(originalRgb)
    const targetColor = this.hsb

    const hue = targetColor.h - h
    const saturate = ((targetColor.s - s) / 100 + 1) * 100
    // const brightness = ((targetColor.b - b) / 100 + 1) * 100;
    const filter = `hue-rotate(${hue}deg) saturate(${saturate}%)`
    return filter
  }
  get blueImageFilter () {
    const blueColor = {
      r: 0,
      g: 160,
      b: 213
    }
    return this.makeImageFilter(blueColor)
  }
  get pinkImageFilter () {
    const pinkColor = {
      r: 251,
      g: 113,
      b: 152
    }
    return this.makeImageFilter(pinkColor)
  }
  get brightness () {
    return `${this.foreground === '#000' ? '100' : '0'}%`
  }
  get filterInvert () {
    return this.foreground === '#000' ? 'invert(0)' : 'invert(1)'
  }
}

const onlineData = {};
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/about.min.css"] = `.bilibili-evolved-about{height:100%;width:450px;background:#fff;color:#000;position:fixed;top:0;left:0;z-index:100000;transform:translateX(-101%);transition:.3s cubic-bezier(0,.86,.58,1);display:flex;flex-direction:column;box-shadow:4px 0 16px 0 #0000}.gui-settings-dock-right .bilibili-evolved-about{right:0;left:unset;transform:translateX(101%)}body.dark .bilibili-evolved-about{background:#222;color:#eee}.bilibili-evolved-about.opened,.gui-settings-dock-right .bilibili-evolved-about.opened{transform:translateX(0);box-shadow:4px 0 16px 0 #0005}.about-header{padding:32px;display:flex;align-items:center;justify-content:flex-start}.about-header i{margin-right:8px;display:flex}.about-title{font-size:16pt}.about-content{padding:16px 36px 0;margin-bottom:36px;display:flex;flex-direction:column;overflow:auto}.about-content .name{font-size:24pt;display:none;align-items:center}.about-content .name svg{width:100%}body.dark .about-content .name.dark,body:not(.dark) .about-content .name.light{display:flex}.about-content .version{font-size:10pt;font-weight:700;opacity:.6;margin-top:6px;margin-bottom:6px;align-self:center}.about-content .love{font-size:10pt;margin-bottom:24px;align-self:center}.about-content .love a{color:inherit!important}.about-content section{font-size:10pt;margin-top:16px}.about-content section .title{display:flex;justify-content:center;text-transform:uppercase;font-weight:700;font-size:13pt;letter-spacing:3px;margin:8px 0 16px}.about-content section .supporter,.about-content section a{color:var(--theme-color)!important;margin-right:8px;display:inline-flex}.about-content section .supporter{user-select:none}.about-content section .supporter:not(:last-child)::after,.about-content section a:not(:last-child)::after{content:","}@keyframes spinner{to{transform:translate(-50%,-50%) rotate(360deg)}}.about-content section.participants .fetching{margin-right:8px;position:relative;display:inline-flex}.about-content section.participants .fetching::before{content:"Loading..."}`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/about.min.html"] = `<div class=bilibili-evolved-about><div class=about-header><i class="mdi mdi-information-outline mdi-24px"></i><span class=about-title>关于</span></div><div class=about-content><p v-if=branch class="name light"v-html=logoImage></p><p v-if=branch class="name dark"v-html=logoImageDark></p><p class=version>v{{version}} · {{clientType}}</p><p class=love><a target=_blank href=https://github.com/the1812/Bilibili-Evolved/ >Made with ❤　　</a><a target=_blank href=https://github.com/the1812/Bilibili-Evolved/blob/master/donate.md>Buy me a coffee ☕</a></p><section class=authors><span class=title>Authors</span><a class=author target=_blank v-for="author of authors"v-bind:href=author.link>{{author.name}}</a></section><section class=contributors><span class=title>Contributors</span><a class=contributor target=_blank v-for="contributor of contributors"v-bind:href=contributor.link>{{contributor.name}}</a></section><section class=supporters><a class=title target=_blank href=https://github.com/the1812/Bilibili-Evolved/blob/preview/donate.md#历史>View Supporters</a></section><section class=participants><span class=title>Community Power</span><span class=fetching v-if=fetching></span><a class=participant target=_blank v-for="participant of participants"v-bind:href=participant.link>{{participant.name}}</a></section><section class=websites><span class=title>Websites</span><a class=website target=_blank v-for="website of websites"v-bind:href=website.link>{{website.name}}</a></section><section class=components><span class=title>Components</span><a class=component target=_blank v-for="component of components"v-bind:href=component.link>{{component.name}}</a></section></div></div>`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/about.min.js"] = (()=>{return(t,e)=>{(async()=>{const i=await e.importAsync("aboutHtml");document.body.insertAdjacentHTML("beforeend",i);dq(".bilibili-evolved-about").addEventListener("be:about-load",()=>{const e=(t,e)=>t.charCodeAt(0)-e.charCodeAt(0);const i=(t,i)=>e(t.name,i.name);const o=GM.info.script.name.match(/Bilibili Evolved \((.*)\)/);const n=o?o[1]:"Stable";new Vue({el:".bilibili-evolved-about",data:{version:t.currentVersion,clientType:n,logoImage:null,logoImageDark:null,branch:null,authors:[{name:"Grant Howard",link:"https://github.com/the1812"},{name:"Coulomb-G",link:"https://github.com/Coulomb-G"}],contributors:[{name:"PleiadeSubaru",link:"https://github.com/Etherrrr"},{name:"Lets-Halloween",link:"https://github.com/Lets-Halloween"}].sort(i),fetching:true,participants:[],websites:[{name:"GitHub",link:"https://github.com/the1812/Bilibili-Evolved/"},{name:"Greasy Fork",link:"https://greasyfork.org/zh-CN/scripts/373563-bilibili-evolved"}],components:[{name:"Vue.js",link:"https://cn.vuejs.org/index.html"},{name:"Vuex",link:"https://vuex.vuejs.org/zh/"},{name:"JSZip",link:"https://stuk.github.io/jszip/"},{name:"jQuery",link:"http://jquery.com/"},{name:"debounce",link:"https://github.com/component/debounce/"},{name:"Slip.js",link:"https://github.com/kornelski/slip"},{name:"MDI",link:"https://materialdesignicons.com"},{name:"Lodash",link:"https://lodash.com/"}]},mounted(){dq(".bilibili-evolved-about").addEventListener("be:about-load-community",()=>{this.init()},{once:true})},methods:{async getLogos(){this.logoImage=await Ajax.getText(`https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/images/bilibili-evolved-wide.svg`);this.logoImageDark=await Ajax.getText(`https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/images/bilibili-evolved-wide-dark.svg`)},async init(){this.branch=/Preview|Local/.test(n)?"preview":"master";this.getLogos();const t=new Set;let e=[];let o=1;do{e=await Ajax.getJson(`https://api.github.com/repos/the1812/Bilibili-Evolved/issues?state=all&direction=asc&per_page=100&page=${o}`).catch(()=>{e=[{name:"电波无法到达(´･_･`)",link:null}]});o++;for(const i of e){t.add(i.user.login)}}while(e.length>0);this.participants=[...t].map(t=>{return{name:t,link:`https://github.com/${t}`}}).filter(({link:t})=>{return!this.authors.some(e=>e.link===t)&&!this.contributors.some(e=>e.link===t)}).sort(i);this.fetching=false}}})},{once:true})})()}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/activity-apis.min.js"] = (()=>{return(t,e)=>{class s extends EventTarget{constructor(){super(...arguments);this.cards=[]}addCard(t){if(t instanceof Element&&t.classList.contains("card")){if(t.querySelector(".skeleton")!==null){const e=Observer.childList(t,()=>{if(t.querySelector(".skeleton")===null){e.forEach(t=>t.stop());this.addCard(t)}})}else{const e=this.parseCard(t);this.cards.push(e);const s=new CustomEvent("addCard",{detail:e});this.dispatchEvent(s)}}}removeCard(t){if(t instanceof Element&&t.classList.contains("card")){const e=this.parseCard(t).id;const s=this.cards.findIndex(t=>t.id===e);const r=this.cards[s];this.cards.splice(s,1);const n=new CustomEvent("removeCard",{detail:r});this.dispatchEvent(n)}}parseCard(t){const e=e=>{if(t.querySelector(e)===null){return""}return t.querySelector(e).innerText};const s=t=>{const s=parseInt(e(t));if(isNaN(s)){return 0}return s};const r={id:t.getAttribute("data-did"),username:e(".main-content .user-name"),text:e(".card-content .text.description"),reposts:s(".button-bar .single-button:nth-child(1) .text-offset"),comments:s(".button-bar .single-button:nth-child(2) .text-offset"),likes:s(".button-bar .single-button:nth-child(3) .text-offset")};return r}async startWatching(){const t=await SpinQuery.select(".card-list .content");if(!t){return false}const e=[...t.querySelectorAll(".content>.card")];e.forEach(t=>this.addCard(t));Observer.childList(t,t=>{t.forEach(t=>{t.addedNodes.forEach(t=>this.addCard(t));t.removedNodes.forEach(t=>this.removeCard(t))})});return true}}const r=new s;return{export:{activityCardsManager:r}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/activity-image-saver.min.js"] = (()=>{return(t,e)=>{(async()=>{if(!document.URL.startsWith("https://t.bilibili.com")&&!document.URL.startsWith("space.bilibili.com")){return}const t=t=>{const e=t.querySelector(".image-viewer");if(e===null){console.log(t)}else{e.addEventListener("contextmenu",()=>{setTimeout(()=>{const t=dq(".pop-message .toast-text");if(t&&t.innerHTML.includes("作者设置了禁止保存")){Toast.success(`<img src="${e.src}" width="200">`,"解除动态存图限制")}},200)})}};[...document.body.children].filter(t=>t.classList.contains("photo-imager-container")).forEach(t);Observer.childList(document.body,e=>{e.forEach(e=>{const s=[...e.addedNodes].filter(t=>t instanceof Element&&t.classList.contains("photo-imager-container"));s.forEach(t)})})})()}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/aria2-rpc.min.js"] = (()=>{return(t,e)=>{function o(){const e=t.aria2RpcOption;const o=e.host.match(/^http[s]?:\/\//)?e.host:"http://"+e.host;const r="aria2.addUri";return{option:e,host:o,methodName:r}}async function r(t,e=false){try{let o=await t();if(typeof o==="string"){o=JSON.parse(o)}if(o.error!==undefined){if(o.error.code===1){logError(`请求遭到拒绝, 请检查您的密钥相关设置.`)}else{logError(`请求发生错误, code = ${o.error.code}, message = ${o.error.message}`)}return false}if(!e){Toast.success(`成功发送了请求, GID = ${o.result}`,"aria2 RPC",5e3)}return true}catch(t){logError(`无法连接到RPC主机.`);return false}}async function s(t,e=false){const{option:s,host:n,methodName:a}=o();return await r(async()=>{const e=window.btoa(unescape(encodeURIComponent(JSON.stringify(t.params))));const o=`${n}:${s.port}/jsonrpc?method=${a}&id=${t.id}&params=${e}`;console.log(`RPC request:`,o);if(o.startsWith("http:")){return await new Promise((t,e)=>{GM.xmlHttpRequest({method:"GET",url:o,responseType:"json",onload:e=>t(e.response),onerror:t=>e(t)})})}else{return await Ajax.getJson(o)}},e)}async function n(t,e=false){const{option:s,host:n,methodName:a}=o();return await r(async()=>{const e=`${n}:${s.port}/jsonrpc`;const o={method:a,id:t.id,params:t.params};if(e.startsWith("http:")){return await new Promise((t,r)=>{GM.xmlHttpRequest({method:"POST",url:e,responseType:"json",data:JSON.stringify(o),onload:e=>t(e.response),onerror:t=>r(t)})})}else{return await Ajax.postJson(e,o)}},e)}async function a(e,o=false){const r=t.aria2RpcOption;for(const t of e){let e;if(r.method==="get"){e=await s(t,o)}else{e=await n(t,o)}if(o===true&&e===false){logError(`${decodeURIComponent(t.id)} 导出失败`)}}}return{export:{sendRpc:a}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/aria2-rpc-profile-item.vue.min.js"] = (()=>{return(e,i)=>{const t=`<div class=profile-item :class="{duplicate: duplicateName, selected}"><template v-if=!editing>{{profile.name}}</template><template v-else><input type=text v-model=name @keydown.enter=saveProfile()></template><icon v-if=!editing style="transform: scale(0.9)"type=mdi icon=pencil-outline title=重命名 @click.native="editing = true"></icon><icon v-if=editing type=mdi icon=check title=确定 @click.native=saveProfile()></icon></div>`;i.applyStyleFromText(`.profile-item{display:flex;align-items:center;padding:4px 8px;background-color:#8882;border-radius:4px;border:2px solid transparent;flex-shrink:0;cursor:pointer}.profile-item:not(:last-child){margin-right:8px}.profile-item.duplicate{border-color:red}.profile-item.selected:not(.duplicate){border-color:var(--theme-color)}.profile-item input[type=text]{width:5em;border:none!important;padding:0!important;margin:0!important;line-height:normal}`,"aria2-rpc-profile-item-style");return{export:Object.assign({template:t},{components:{Icon:()=>i.importAsync("icon.vue")},props:["profile","deletable","selected"],data(){return{name:this.profile.name,editing:false,duplicateName:false}},methods:{saveProfile(){if(this.name===this.profile.name){this.duplicateName=false;this.editing=false;return}if(this.name===""||e.aria2RpcOptionProfiles.some(e=>e.name===this.name)){this.duplicateName=true;return}else{this.duplicateName=false;if(e.aria2RpcOptionSelectedProfile===this.profile.name){e.aria2RpcOptionSelectedProfile=this.name}this.profile.name=this.name;this.editing=false;this.$emit("profile-update")}}}})}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/aria2-rpc-profiles.vue.min.js"] = (()=>{return(e,i)=>{const r=`<div class=aria2-rpc-profiles><div class=profiles-header><h2>预设</h2><div class=profile-operations><div v-if="profiles.length > 1"class="operation delete-profile"@click=deleteProfile() title=删除预设><icon type=mdi icon=trash-can-outline></icon></div><div class="operation new-profile"@click=addProfile() title=新增预设><icon type=mdi icon=plus></icon></div></div></div><div class=profiles-list><profile-item v-for="(profile, index) of profiles":key="profile.name + index"@profile-update=profileUpdate() @click.native=changeProfile(profile) :profile=profile :deletable="profiles.length > 1":selected="profile.name === selectedProfile"></profile-item></div></div>`;i.applyStyleFromText(`.aria2-rpc-profiles .profiles-header{display:flex;justify-content:space-between;align-items:center;margin-bottom:8px}.aria2-rpc-profiles .profiles-header .profile-operations{display:flex;align-items:center}.aria2-rpc-profiles .profiles-header .profile-operations .operation{padding:4px;background-color:#8882;border-radius:50%;display:flex;align-items:center;justify-content:center;cursor:pointer}.aria2-rpc-profiles .profiles-header .profile-operations .operation:not(:last-child){margin-right:8px}.aria2-rpc-profiles .profiles-header .profile-operations .operation:hover{background-color:#8884}.aria2-rpc-profiles .profiles-header .profile-operations .operation .mdi{margin:0}.aria2-rpc-profiles .profiles-list{display:flex;overflow:auto;scrollbar-width:none!important}.aria2-rpc-profiles .profiles-list::-webkit-scrollbar{height:0!important}`,"aria2-rpc-profiles-style");const o={name:"未命名",...e.aria2RpcOption};return{export:Object.assign({template:r},{components:{ProfileItem:()=>i.importAsync("aria2-rpc-profile-item.vue"),Icon:()=>i.importAsync("icon.vue")},data(){this.migrateOldProfiles();const i=[...e.aria2RpcOptionProfiles];if(i.length===0){i.push(o);e.aria2RpcOptionProfiles=i}return{profiles:i,selectedProfile:e.aria2RpcOptionSelectedProfile||o.name}},watch:{selectedProfile(i){if(e.aria2RpcOptionSelectedProfile!==i){e.aria2RpcOptionSelectedProfile=i}}},methods:{migrateOldProfiles(){const i=Object.getOwnPropertyNames(e.aria2RpcOption).filter(e=>!e.startsWith("_"));i.push("name");let r=false;for(const o of e.aria2RpcOptionProfiles){i.filter(e=>!(e in o)).forEach(i=>{o[i]=e.aria2RpcOption[i];console.log(`migrated profile property '${i}'`);r=true})}if(r){e.aria2RpcOptionProfiles=e.aria2RpcOptionProfiles}},profileUpdate(){e.aria2RpcOptionProfiles=this.profiles;this.selectedProfile=e.aria2RpcOptionSelectedProfile},changeProfile(e){this.selectedProfile=e.name;this.$emit("profile-change",e)},addProfile(){const i={...this.profiles.find(e=>e.name===this.selectedProfile)};i.name=i.name.replace(/[\d]+$/,"");if(this.profiles.some(e=>e.name===i.name)){let e=1;while(this.profiles.some(r=>r.name===i.name+e.toString())){e++}i.name=i.name+e.toString()}this.profiles.push(i);e.aria2RpcOptionProfiles=this.profiles;this.changeProfile(i)},deleteProfile(){const i=this.profiles.findIndex(e=>e.name===this.selectedProfile);const r=i===0?0:i-1;const o=this.profiles[r];this.profiles.splice(i,1);e.aria2RpcOptionProfiles=this.profiles;this.changeProfile(o)}}})}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/ass-utils.min.js"] = (()=>{return(t,r)=>{const e=t=>{if(t.startsWith("#")){t=t.substring(1)}const r=t.substring(0,2);const e=t.substring(2,4);const n=t.substring(4,6);return{red:r,green:e,blue:n}};const n=t=>{const{red:r,green:n,blue:o}=e(t);return`\\c&H${o}${n}${r}&`.toUpperCase()};const o=(t,r=1)=>{const{red:n,green:o,blue:s}=e(t);const c=Math.round(255*(1-r)).toString(16);return`&H${c}${s}${o}${n}`.toUpperCase()};const s=t=>{const[r,e="00"]=String(t).split(".");return`${r.padStart(2,"0")}.${e.substr(0,2).padEnd(2,"0")}`};const c=t=>{let r=0;let e=0;while(t>=60){t-=60;e++}while(e>=60){e-=60;r++}return`${r}:${String(e).padStart(2,"0")}:${s(t)}`};const u=(t,r)=>{return[c(t),c(t+r)]};const i=(t,r)=>{return[c(t),c(r)]};const a=t=>{const r={"{":"｛","}":"｝","&amp;":"&","&lt;":"<","&gt;":">","&quot;":'"',"&apos;":"'","\n":"\\N"};for(const[e,n]of Object.entries(r)){t=t.replace(new RegExp(e,"g"),n)}return t};return{export:{convertHexColorForDialogue:n,convertHexColorForStyle:o,convertTimeByDuration:u,convertTimeByEndTime:i,normalizeContent:a}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/auto-continue.min.js"] = (()=>{return(e,i)=>{if(typeof isEmbeddedPlayer!=="undefined"&&isEmbeddedPlayer()){return}function t(i){const t=i.text();if(/第(\d+)话/.test(t)){if(e.allowJumpContinue){i.parent().find(".bilibili-player-video-toast-item-jump").click()}return}const n=/((\d)*:)?(\d)*:(\d)*/g;const r=t.match(n);if(!r){return}const o=r[0].split(":");const l=(()=>{if(o.length===3){const[e,i,t]=o.map(e=>parseInt(e));return e*60*60+i*60+t}else if(o.length===2){const[e,i]=o.map(e=>parseInt(e));return e*60+i}else{logError(`解析历史时间发生错误: historyTime=${JSON.stringify(o)}`);return NaN}})();const s=i.parent();const a=document.querySelector("video");if(l<a.duration){a.currentTime=l;a.play();s.find(".bilibili-player-video-toast-item-jump").remove();const e=$(`<div class="bilibili-player-video-toast-item-jump">从头开始</div>`);e.appendTo(s).on("click",()=>{a.currentTime=0;s.find(".bilibili-player-video-toast-item-close").get(0).click()});i.html(`<span>已跳转到上次历史记录</span><span>${r[0]}</span>`)}else{s.find(".bilibili-player-video-toast-item-close").get(0).click()}}function n(){SpinQuery.condition(()=>$(".bilibili-player-video-toast-item-text"),e=>e.text().indexOf("上次看到")!==-1,e=>t(e.filter((e,i)=>i.innerText.indexOf("上次看到")!==-1)))}Observer.videoChange(n)}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/auto-draw.min.js"] = (()=>{return(t,n)=>{(async()=>{if(!/^https:\/\/live\.bilibili\.com\/[\d]+/.test(document.URL)){return}const t=await SpinQuery.condition(()=>dq(".chat-popups-section"),t=>t.querySelector("chat-draw-area")===null);if(!t){console.warn("[自动领奖] 未能找到弹窗容器");return}Observer.childListSubtree(t,()=>{let t;console.log("draw button = ",dq(".chat-popups-section .draw>span:nth-child(3)"));t=dq(".chat-popups-section .draw>span:nth-child(3)");if(t===null){const t=dq(".chat-popups-section .function-bar>span:nth-child(3)");if(t!==null){const n=Observer.attributes(t,()=>{if(t.style.display!=="none"){n.forEach(t=>t.stop());t.click()}})}}if(t!==null){t.click()}})})()}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/auto-play.min.js"] = (()=>{return(e,d)=>{if(typeof isEmbeddedPlayer!=="undefined"&&isEmbeddedPlayer()){return}SpinQuery.condition(()=>document.querySelector(".bilibili-player-video video"),e=>e&&e.paused===true,e=>e.play())}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/bangumi-timeline.vue.min.js"] = (()=>{return(e,i)=>{const t=`<div class=bangumi-timeline-container><div class=area-header>时间表</div><div class=bangumi-timeline><div class=timeline-day v-for="t of timeline":key=t.date><div class=date-container :class="{today: t.isToday}"@click=moveTimeline><div class=icon :class="['day-of-week-' + t.dayOfWeek]"></div><div class=date>{{t.date}}</div><div class=day-of-week>{{t.dayOfWeekText}}</div></div><div class=empty-day :class="{alt: t.isToday}"v-if="Object.entries(t.bangumis).length === 0"></div><div class=time-container v-for="[time, bangumis] of Object.entries(t.bangumis)":key=time><div class=time :class="{'recent': t.isToday && recentTime.includes(time)}"><icon type=mdi icon=clock-fast></icon>{{time}}</div><a class=bangumi-item v-for="b of bangumis":key=b.url :class="{delay: b.delay}":href=b.url target=_blank><div class=cover-container><dpi-img :size=72 :src=b.squareCoverUrl></dpi-img></div><div class=title>{{b.title}}</div><div class=ep-title><icon type=mdi icon=heart-outline title=已追番 v-if=b.follow></icon>{{b.epTitle}}</div></a></div></div></div></div>`;i.applyStyleFromText(`.simple-home .bangumi-timeline-container{width:100%}.simple-home .bangumi-timeline-container .bangumi-timeline{display:flex;align-items:flex-start;overflow:auto;scrollbar-width:none!important;scroll-behavior:smooth;--column-count:1;--column-width:250px;--column-gap:24px;width:calc(var(--column-count) * (var(--column-width) + var(--column-gap)) - .5 * var(--column-gap))}.simple-home .bangumi-timeline-container .bangumi-timeline::-webkit-scrollbar{height:0!important;width:0!important}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day{scroll-snap-align:start;width:var(--column-width);max-height:calc(var(--total-height) - 32px);overflow:auto;flex:0 0 auto;padding-bottom:16px;scroll-behavior:smooth;scrollbar-width:none!important}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day::-webkit-scrollbar{height:0!important;width:0!important}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container{display:grid;grid-template:"icon date" 1fr "icon dow" 1fr/auto 1fr;grid-column-gap:8px;column-gap:8px;height:60px;padding-bottom:12px;cursor:pointer;position:sticky;top:0;z-index:1;background-color:#f4f4f4}body.dark .simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container{background-color:#181818}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container .icon{grid-area:icon;justify-self:center;align-self:center;background-image:url(//s1.hdslb.com/bfs/static/bangumi-timeline/asserts/icons.png);background-size:247px 663px;width:38px;height:36px;background-position-x:-146px;filter:brightness(.5)}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container .icon.day-of-week-1{background-position-y:-36px}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container .icon.day-of-week-2{background-position-y:-108px}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container .icon.day-of-week-3{background-position-y:-180px}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container .icon.day-of-week-4{background-position-y:-252px}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container .icon.day-of-week-5{background-position-y:-324px}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container .icon.day-of-week-6{background-position-y:-396px}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container .icon.day-of-week-7{background-position-y:-468px}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container .date{grid-area:date;align-self:end;opacity:.75}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container .day-of-week{grid-area:dow;align-self:start;font-weight:700;font-size:15px;opacity:.75}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container.today .icon{width:50px;height:48px;background-position-x:-56px;filter:none}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container.today .date{font-size:14px;opacity:1}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container.today .day-of-week{font-size:18px;opacity:1}body.dark .simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container .icon{filter:brightness(.8)}body.dark .simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container.today .icon{filter:invert(1)}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .empty-day{margin-top:26px;width:246px;height:469px;background:url(//s1.hdslb.com/bfs/static/bangumi-timeline/asserts/empty-1.png) no-repeat}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .empty-day.alt{background:url(//s1.hdslb.com/bfs/static/bangumi-timeline/asserts/empty-2.png) no-repeat}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container{margin-top:18px}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container>:not(:last-child){margin-bottom:8px}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .time{display:flex;align-items:center;font-weight:700}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .time.recent{color:var(--theme-color)}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .time.recent~.bangumi-item{box-shadow:0 4px 8px 0 #0001,inset 0 0 0 2px var(--theme-color)}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .time.recent~.bangumi-item .cover-container{margin:2px;border-radius:6px 0 0 6px}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .time .be-icon{margin-right:6px;font-size:18px}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .bangumi-item{display:grid;height:72px;grid-template:"cover title" auto "cover ep" auto/72px 1fr;background-color:#fff;color:inherit;box-shadow:0 4px 8px 0 #0001;border-radius:8px;grid-row-gap:8px;row-gap:8px}body.dark .simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .bangumi-item{background-color:#282828}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .bangumi-item .cover-container{grid-area:cover;overflow:hidden;border-radius:8px 0 0 8px}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .bangumi-item .cover-container img{width:100%;height:100%}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .bangumi-item.delay{opacity:.4}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .bangumi-item.delay:hover{opacity:1}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .bangumi-item:hover{color:var(--theme-color)!important}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .bangumi-item:hover .cover-container img{transform:scale(1.05)}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .bangumi-item .title{grid-area:title;align-self:end;font-size:13px;font-weight:700;margin:0 12px;display:-webkit-box;-webkit-line-clamp:2;-webkit-box-orient:vertical;max-height:2.6em;word-break:break-all;line-height:1.3;overflow:hidden}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .bangumi-item .ep-title{grid-area:ep;align-self:start;margin:0 12px;display:flex;align-items:center}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .bangumi-item .ep-title .be-icon{color:var(--theme-color);margin-right:4px;font-size:18px;line-height:1}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day:not(:last-child){margin-right:var(--column-gap)}@media screen and (min-width:1000px){.simple-home .bangumi-timeline-container .bangumi-timeline{--column-count:2}}@media screen and (min-width:1300px){.simple-home .bangumi-timeline-container .bangumi-timeline{--column-count:3}}@media screen and (min-width:1550px){.simple-home .bangumi-timeline-container .bangumi-timeline{--column-count:4}}`,"bangumi-timeline-style");const n={global:"https://bangumi.bilibili.com/web_api/timeline_global",chinese:"https://bangumi.bilibili.com/web_api/timeline_cn"};return{export:Object.assign({template:t},{components:{Icon:()=>i.importAsync("icon.vue"),DpiImg:()=>i.importAsync("dpi-img.vue")},props:{type:{type:String,default:"global",required:false}},data(){return{timeline:[],recentTime:""}},computed:{apiUrl(){return n[this.type]||n.global}},watch:{type(){this.updateTimeline()}},methods:{calculateRecentTime(){const e=this.timeline.find(e=>e.isToday);const i=Number(new Date);const t=Object.entries(e.bangumis).map(([e,i])=>{return{time:e,timestamp:i[0].timestamp,bangumis:i}});if(t.length===0){return}const n=t.filter(e=>e.timestamp<i);if(n.length===0){this.recentTime=[t[0].time]}else{this.recentTime=n.map(e=>e.time)}},moveTimeline(e){const i=e.currentTarget;const t=i.parentElement;const n=t.parentElement;const a=getComputedStyle(n);const m=parseInt(a.getPropertyValue("--column-width").match(/(.+)px/)[1])+parseInt(a.getPropertyValue("--column-gap").match(/(.+)px/)[1]);const o=t.offsetLeft-n.scrollLeft;if(o<m){n.scrollLeft-=m}else if(o>=m*2){n.scrollLeft+=m}console.log(e,i,t,n);console.log(m,m*2,t.offsetLeft,n.scrollLeft,o)},async updateTimeline(){try{const e=await Ajax.getJsonWithCredentials(this.apiUrl);if(e.code!==0){throw new Error(e.message)}const i=e.result.map(e=>{return{date:e.date,dayOfWeek:e.day_of_week,dayOfWeekText:"周"+[,"一","二","三","四","五","六","日"][e.day_of_week],isToday:Boolean(e.is_today),bangumis:_.groupBy(e.seasons.map(e=>{return{coverUrl:e.cover.replace("http:","https:"),squareCoverUrl:e.square_cover.replace("http:","https:"),time:e.pub_time,timestamp:e.pub_ts*1e3,url:e.url,follow:Boolean(e.follow),epTitle:e.pub_index||e.delay_reason+" "+e.delay_index,title:e.title,delay:Boolean(e.delay),published:Boolean(e.is_published)}}),e=>e.time)}});this.timeline=i;this.calculateRecentTime();setInterval(()=>{if(document.hasFocus()){this.calculateRecentTime()}},60*1e3);await this.$nextTick();const t=this.$el;const n=this.$el.querySelector(".bangumi-timeline");const a=getComputedStyle(n);const m=parseInt(a.getPropertyValue("--column-width").match(/(.+)px/)[1]);const o=parseInt(a.getPropertyValue("--column-gap").match(/(.+)px/)[1]);n.scrollLeft=5*(m+o)}catch(e){logError(e);this.$emit("error")}finally{this.$emit("load")}}},async mounted(){await this.updateTimeline()}})}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/batch-download.min.js"] = (()=>{return(t,e)=>{const{formatTitle:i}=e.import("title");const s=12;const a=[".mp4",".m4a"];class n{constructor(t){this.config=t;this.itemList=[]}static formatTitle(e){const s=t.batchFilenameFormat;const a=i(s,true,e);return escapeFilename(a," ")}async getRawItems(t){return JSON.parse(await this.collectData(t))}extension(t,e){const i=[".flv",".mp4"].find(e=>t.includes(e));if(i){return i}else if(t.includes(".m4s")){return a[e]}else{return".flv"}}async collectAria2(i,a){const n=await this.getRawItems(i);if(a){const i=t.aria2RpcOption;const{sendRpc:a}=await e.importAsync("aria2-rpc");for(const t of n){const e=t.fragments.map((e,a)=>{let n="";if(t.fragments.length>1&&!e.url.includes(".m4s")){n=" - "+(a+1)}const r=[];if(i.secretKey!==""){r.push(`token:${i.secretKey}`)}r.push([e.url]);r.push({referer:document.URL.replace(window.location.search,""),"user-agent":UserAgent,out:`${t.title}${n}${this.extension(e.url,a)}`,split:s,dir:i.baseDir+i.dir||undefined,"max-download-limit":i.maxDownloadLimit||undefined});const o=encodeURIComponent(`${t.title}${n}`);return{params:r,id:o}});await a(e,true)}}else{return`\n# Generated by Bilibili Evolved Video Export\n# https://github.com/the1812/Bilibili-Evolved/\n${n.map(t=>{return t.fragments.map((e,i)=>{let a="";if(t.fragments.length>1&&!e.url.includes(".m4s")){a=` - ${i+1}`}return`\n${e.url}\n  referer=${t.referer}\n  user-agent=${UserAgent}\n  out=${t.title}${a}${this.extension(e.url,i)}\n  split=${s}\n`.trim()}).join("\n")}).join("\n")}\n`.trim()}}}class r extends n{constructor(){super(...arguments);this.aid=unsafeWindow.aid}static async test(){if(document.URL.startsWith("https://www.bilibili.com/video/")){return await SpinQuery.select("#multi_page")!==null}return false}async getItemList(){if(this.itemList.length>0){return this.itemList}const t=`https://api.bilibili.com/x/web-interface/view?aid=${this.aid}`;const e=await Ajax.getJson(t);if(e.code!==0){Toast.error(`获取视频选集列表失败, message=${e.message}`,"批量下载");return[]}const i=e.data.pages;if(i===undefined){Toast.error(`获取视频选集列表失败, 没有找到选集信息.`,"批量下载");return[]}this.itemList=i.map(t=>{return{title:`P${t.page} ${t.part}`,titleParameters:{n:t.page,ep:t.part},cid:t.cid,aid:this.aid}});return this.itemList}async collectData(t){const i=[];for(const s of(await this.getItemList()).filter(this.config.itemFilter)){const a=this.config.api?this.config.api(s.aid,s.cid,t):`https://api.bilibili.com/x/player/playurl?avid=${s.aid}&cid=${s.cid}&qn=${t}&otype=json`;const r=await Ajax.getJsonWithCredentials(a);const o=r.data||r.result||r;if(o.quality!==t){console.warn(`${s.title} 不支持所选画质, 已回退到较低画质. (quality=${o.quality})`)}let c;if(o.durl){c=o.durl.map(t=>{return{length:t.length,size:t.size,url:t.url}})}else{const{getDashInfo:i,dashToFragments:s}=await e.importAsync("video-dash");const n=await i(a,typeof t==="string"?parseInt(t):t,true);c=s(n)}i.push({fragments:c,title:n.formatTitle(s.titleParameters),totalSize:c.map(t=>t.size).reduce((t,e)=>t+e),cid:s.cid,referer:document.URL.replace(window.location.search,"")})}return JSON.stringify(i)}}class o extends n{constructor(t){super(t);this.mainVideo=new r(t);this.mainVideo.aid="78976165";this.spVideo=new r(t);this.spVideo.aid="78979124"}static async test(){return document.URL.includes("//www.bilibili.com/blackboard/bnj2020.html")}async getItemList(){return(await this.mainVideo.getItemList()).concat(await this.spVideo.getItemList())}async collectData(t){return(await this.mainVideo.collectData(t)).concat(await this.spVideo.collectData(t))}}class c extends n{static async test(){return document.URL.includes("/www.bilibili.com/bangumi")}async getItemList(){if(this.itemList.length>0){return this.itemList}const t=document.querySelector("meta[property='og:url']");if(t===null){Toast.error("获取番剧数据失败: 无法找到 Season ID","批量下载");return[]}const e=t.getAttribute("content").match(/play\/ss(\d+)/)[1];if(e===undefined){Toast.error("获取番剧数据失败: 无法解析 Season ID","批量下载");return[]}const i=await Ajax.getJson(`https://api.bilibili.com/pgc/web/season/section?season_id=${e}`);if(i.code!==0){Toast.error(`获取番剧数据失败: 无法获取番剧集数列表, message=${i.message}`,"批量下载");return[]}this.itemList=i.result.main_section.episodes.map((t,e)=>{const i=t.long_title?t.title:(e+1).toString();const s=t.long_title?t.long_title:t.title;return{aid:t.aid,cid:t.cid,title:`${i} - ${s}`,titleParameters:{n:i,ep:s}}});return this.itemList}async collectData(t){const i=[];for(const s of(await this.getItemList()).filter(this.config.itemFilter)){const a=this.config.api?this.config.api(s.aid,s.cid,t):`https://api.bilibili.com/pgc/player/web/playurl?avid=${s.aid}&cid=${s.cid}&qn=${t}&otype=json`;const r=await Ajax.getJsonWithCredentials(a);const o=r.data||r.result||r;if(o.quality!==t){console.warn(`${s.title} 不支持所选画质, 已回退到较低画质. (quality=${o.quality})`)}let c;if(o.durl){c=o.durl.map(t=>{return{length:t.length,size:t.size,url:t.url}})}else{const{getDashInfo:i,dashToFragments:s}=await e.importAsync("video-dash");const n=await i(a,typeof t==="string"?parseInt(t):t);c=s(n)}i.push({fragments:c,title:n.formatTitle(s.titleParameters),totalSize:c.map(t=>t.size).reduce((t,e)=>t+e),cid:s.cid,referer:document.URL.replace(window.location.search,"")})}return JSON.stringify(i)}}class l extends r{constructor(){super(...arguments);this.items=[]}async getItemList(){const{VideoInfo:t}=await e.importAsync("video-info");const i=await Promise.all(this.items.map(async e=>{const i=new t(e);await i.fetchInfo();return i.pages.map((t,i)=>{return{aid:e,cid:t.cid,titleParameters:{n:(i+1).toString(),ep:t.title},title:`P${i+1} ${t.title}`}})}));return _.flatten(i)}}const u=[c,r,o];let d;class m{constructor(t){this.config=Object.assign({itemFilter:()=>true},t)}static async test(){for(const t of u){if(await t.test()===true){d=t;return true}}return false}getExtractor(){if(d===null){logError("[批量下载] 未找到合适的解析模块.");throw new Error(`[Batch Download] module not found.`)}const t=new d(this.config);return t}async getItemList(){const t=this.getExtractor();return await t.getItemList()}async getRawItems(t){const e=this.getExtractor();return await e.getRawItems(t.quality)}async collectData(t,e){const i=this.getExtractor();const s=await i.collectData(t.quality);e.dismiss();return s}async collectAria2(t,e,i=false){const s=this.getExtractor();const a=await s.collectAria2(t.quality,i);e.dismiss();return a}formatTitle(t){return n.formatTitle(t)}}return{export:{BatchExtractor:m,ManualInputBatch:l}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/biliplus-redirect.min.js"] = (()=>{return(i,e)=>{const n=`hd.biliplus.com`;const c=["bilibili.com/video/av","bilibili.com/bangumi/play","bilibili.com/bangumi/media","space.bilibili.com"];return{widget:{condition:()=>{return c.some(i=>document.URL.includes(i))},content:`\n<button class="gui-settings-flat-button" id="biliplus-redirect">\n<i class="icon-biliplus"></i>\n<span>转到BiliPlus</span>\n</button>`,success:()=>{const i=document.querySelector("#biliplus-redirect");i.addEventListener("click",()=>{if(location.host==="space.bilibili.com"){location.assign(document.URL.replace("space.bilibili.com/",`${n}/space/`))}else if(document.URL.includes("/bangumi/")){const i=unsafeWindow.aid||document.querySelector(".av-link,.info-sec-av").innerText.replace(/[aAvV]/g,"");location.assign(`https://${n}/video/av${i}/`)}else{location.host=n}})}}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/blackboard.min.js"] = (()=>{return(e,t)=>{const r=async()=>{if(dq(".international-home")){const e=await SpinQuery.condition(()=>unsafeWindow["__INITIAL_STATE__"],e=>e!==undefined);return dqa(".home-slide .item").slice(0,5).map((t,r)=>{const i=t.querySelector("a").getAttribute("data-loc-id");return{url:e.locsData[i][r].url,title:t.querySelector(".title").innerText.trim(),isAd:Boolean(t.querySelector(".gg-icon")),imageUrl:t.querySelector("img").getAttribute("src").replace(/@.+$/,"")}})}else{const e=dq(".chief-recommend-module .panel");const t=e.querySelector(".pic");const r=e.querySelectorAll(".title > a");return[...t.querySelectorAll("li")].map((e,t)=>{const i=r[t];return{url:i.getAttribute("href"),title:i.innerText.trim(),isAd:Boolean(i.querySelector(".gg-pic")),imageUrl:e.querySelector("img").getAttribute("src").replace(/@.+$/,"")}})}};return{export:{getBlackboards:r}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/blackboard.vue.min.js"] = (()=>{return(a,r)=>{const i=`<div class=blackboards><div class=header><div class=title>活动</div><a class=more href=https://www.bilibili.com/blackboard/x/act_list/ target=_blank><icon type=mdi icon=dots-horizontal></icon>更多</a></div><input class="hidden-input blackboard-radio"type=radio name=blackboard v-for="(b, i) of blackboards":checked="i === 0":id="'blackboard' + i":data-index=i :key=i><div class=jump-dots><label v-for="(b, i) of blackboards":for="'blackboard' + i":key=i><div class=jump-dot></div></label></div><div class=blackboard-cards><a class=blackboard-card target=_blank v-for="(b, i) of blackboards":key=i :href=b.url :title=b.title><dpi-img :src=b.imageUrl :alt=b.title :size="{width: 500, height: 250}":root=cardsContainer></dpi-img><div class=title>{{b.title}}</div></a></div></div>`;r.applyStyleFromText(`.simple-home .blackboards{display:grid;grid-template-areas:"header header" "dots cards";grid-template-columns:8px 1fr;grid-template-rows:1fr 250px;row-gap:16px;column-gap:16px;align-self:start}.simple-home .blackboards .blackboard-cards{grid-area:cards;--blackboard-width:568.5px;--blackboard-height:250px;width:var(--blackboard-width);height:var(--blackboard-height);border-radius:16px;overflow:hidden}.simple-home .blackboards .blackboard-cards .blackboard-card{width:100%;height:100%;position:relative;display:block;transition:.3s cubic-bezier(.65,.05,.36,1)}.simple-home .blackboards .blackboard-cards .blackboard-card img{width:100%;height:100%;object-fit:fill;display:block}.simple-home .blackboards .blackboard-cards .blackboard-card .title{position:absolute;bottom:8px;left:50%;transform:translateX(-50%);padding:4px 16px;color:#fff;background-color:#000a;font-size:14px;font-weight:700;border-radius:14px;white-space:nowrap;opacity:0}.simple-home .blackboards .blackboard-cards .blackboard-card:hover .title{opacity:1}`,"blackboard-style");return{export:Object.assign({template:i},{components:{Icon:()=>r.importAsync("icon.vue"),"dpi-img":()=>r.importAsync("dpi-img.vue")},data(){return{blackboards:[],interval:0}},destroyed(){if(this.interval){clearInterval(this.interval)}},computed:{cardsContainer(){return this.$el.querySelector(".blackboard-cards")}},async mounted(){const{getBlackboards:a}=await r.importAsync("blackboard");this.blackboards=(await a()).filter(a=>!a.isAd);const i=dq(".blackboards");this.interval=setInterval(()=>{if(!document.hasFocus()||i.matches(".blackboards:hover")){return}const a=parseInt(dq(`.blackboard-radio:checked`).getAttribute("data-index"));let r;if(a===this.blackboards.length-1){r=0}else{r=a+1}dq(`.blackboard-radio[data-index='${r}']`).checked=true},5e3)}})}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/blur-video-control.min.css"] = `.video-control-blur-layer{width:100%;height:100%;position:absolute;-webkit-backdrop-filter:blur(48px);backdrop-filter:blur(48px);z-index:-1;top:0}.bilibili-player-video-control-mask{background:0 0!important}.bilibili-player-video-control-bottom,.bui-slider .bui-track.bui-track-video-progress .bui-bar-wrap{background-color:transparent!important}.bilibili-player-video-control-bottom{position:relative}.bilibili-player-area .bilibili-player-video-control-bottom,.bilibili-player-area .bilibili-player-video-control-wrap{transition:none!important}`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/blur-video-control.min.js"] = (()=>{return(o,e)=>{const l=async()=>{const o=await SpinQuery.count(".bui-slider .bui-track.bui-track-video-progress,.bilibili-player-video-control-bottom",2);o.forEach(o=>{if(!o.classList.contains("video-control-blur-container")){o.classList.add("video-control-blur-container");o.insertAdjacentHTML("afterbegin",`<div class="video-control-blur-layer"></div>`)}})};e.applyStyle("blurVideoControlStyle");Observer.videoChange(l);return{reload:()=>{document.querySelectorAll(".video-control-blur-layer").forEach(o=>o.style.display="block");e.applyStyle("blurVideoControlStyle")},unload:()=>{document.querySelectorAll(".video-control-blur-layer").forEach(o=>o.style.display="none");e.removeStyle("blurVideoControlStyle")}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/bvid-convert.min.css"] = `.bvid-convert{border:2px solid #8882;border-radius:8px;padding:6px 8px;margin:4px 0;order:-1;width:100%;box-sizing:border-box}.bvid-convert-item{font-size:14px}`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/bvid-convert.min.js"] = (()=>{return(i,n)=>{return{widget:{content:`<div class="bvid-convert"></div>`,condition:async()=>{if(["https://www.bilibili.com/video/","https://www.bilibili.com/bangumi/"].some(i=>document.URL.startsWith(i))){return Boolean(await SpinQuery.select(()=>unsafeWindow.aid||unsafeWindow.bvid))}else{return false}},success:()=>{n.applyStyle("bvidConvertStyle");const i=dq(".bvid-convert");const e=(()=>{if(unsafeWindow.bvid){return unsafeWindow.bvid}const i=dq(".av-link,.bv-link,.bvid-link");return i.innerHTML||"未找到BV号"})();i.innerHTML=`\n<div class="bvid-convert-item">av${unsafeWindow.aid}</div>\n<div class="bvid-convert-item">${e}</div>\n`}}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/category-regions.min.js"] = (()=>{return(i,n)=>{const e={anime:1,bangumi:13,china:167,manga:-1,music:3,dance:129,game:4,tech:36,digital:188,life:160,kichiku:119,fashion:155,ads:165,entertainment:5,column:-1,movie:23,tv:11,film:181,documentary:177};const a={anime:"v/douga",bangumi:"anime",china:"guochuang",manga:"",music:"v/music",dance:"v/dance",game:"v/game",tech:"v/technology",digital:"v/digital",life:"v/life",kichiku:"v/kichiku",fashion:"v/fashion",ads:"v/ad/ad",entertainment:"v/ent",column:"",movie:"v/cinephile",tv:"tv",film:"cinema",documentary:"documentary"};return{export:{RegionCodes:e,RegionLinks:a}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/clear-cache.min.js"] = (()=>{return(n,c)=>{return{widget:{content:`\n<button\n                class="gui-settings-flat-button"\n                id="clear-cache">\n<i class="icon-clear"></i>\n<span>清除缓存</span>\n</button>`,condition:()=>typeof offlineData==="undefined",success:()=>{$("#clear-cache").on("click",()=>{n.cache={};Toast.success("已删除全部缓存.","清除缓存",5e3)})}}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/collapse-live-side-bar.min.css"] = `.side-bar-cntr{transition:.24s ease-out!important;overflow:visible!important;transform:translateZ(0) translateX(100%)!important}.side-bar-cntr:hover{transform:translateZ(0)!important}.side-bar-cntr::after{right:calc(100% + 4px);transform:translateY(-50%) rotate(45deg);width:8px;height:8px;border-radius:2px;box-sizing:border-box;border:4px solid #aaa;border-top-color:transparent;border-right-color:transparent}body.dark .side-bar-cntr::after{border:4px solid #eee;border-top-color:transparent;border-right-color:transparent}.side-bar-cntr::before{right:calc(100% - 8px);transform:translateY(-50%);width:32px;height:48px;border-radius:8px 0 0 8px;background-color:#fff;border:1px solid #e9eaec}body.dark .side-bar-cntr::before{background-color:#222;border-color:transparent}.side-bar-cntr::after,.side-bar-cntr::before{content:"";transition:.24s ease-out;cursor:pointer;position:fixed;top:50%}.side-bar-cntr:hover::after,.side-bar-cntr:hover::before{opacity:0}`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/collapse-live-side-bar.min.js"] = (()=>{return(e,l)=>{return l.toggleStyle("collapseLiveSideBarStyle")}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/combo-like.min.js"] = (()=>{return(e,t)=>{(async()=>{const e=await SpinQuery.select(()=>document.querySelector(".ops span.like"));if(!e){return}e.style.userSelect="none";function t(t,n){const s=new CustomEvent(t,n);e.dispatchEvent(s)}const n=200;let s=true;e.addEventListener("touchstart",e=>{e.preventDefault();s=true;setTimeout(()=>s=false,n);t("mousedown",e)});e.addEventListener("touchend",e=>{e.preventDefault();t("mouseup",e);if(s){t("click",e)}})})()}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/comment.min.css"] = `.comment-list .list-item{position:relative}.bb-comment .comment-list .list-item .info,.dynamic-list-item-wrap .reply-item>.info{display:flex}.bb-comment .comment-list .list-item .info .floor,.dynamic-list-item-wrap .reply-item>.info .floor{order:1}.bb-comment .comment-list .list-item .info .reply,.dynamic-list-item-wrap .reply-item>.info .reply{order:2}.bb-comment .comment-list .list-item .info .operation,.dynamic-list-item-wrap .reply-item>.info .operation{order:3;flex-grow:1;display:flex!important;justify-content:flex-end}.bb-comment .comment-list .list-item>.con>.reply-box{transform:translateX(0)}.bb-comment .comment-list .list-item>.con>.info{margin-top:4px}.bb-comment .comment-list .list-item>.con>.info>.time,.reply-item>.info>.time{position:absolute;right:8px;top:24px;margin:0!important;line-height:normal;color:#000}.reply-item>.info>.time{top:12px;opacity:1}.reply-box .item-user>a{margin-right:8px}.bb-comment .comment-header .tabs-order li.on:after,.bb-comment .comment-list .list-item .con .vote-container,.bb-comment .comment-list .list-item .user-face .hot-follow,.bb-comment .comment-list .list-item>.con>.info>.plad,.bb-comment .nameplate,.bb-comment .reply-notice,.bb-comment .true-love,.comment-area .dynamic-level,.dynamic-list-item-wrap .info .plat{display:none!important}.bb-comment .comment-list .reply-con,.bb-comment .reply-item{position:relative}.bb-comment .comment-list .reply-con>.info>.time,.dynamic-list-item-wrap .reply-box .time{position:absolute;right:8px;top:0;margin:0;opacity:.5;line-height:normal;color:#000}.dynamic-list-item-wrap .reply-box .time{top:10px;opacity:.7}.bb-comment .comment-list .list-item .user{margin-right:120px}.reply-box .item-user .text{display:block}.bb-comment .comment-list .list-item .user .level{visibility:hidden;width:0;margin:0}.bb-comment .comment-list .list-item .info .hate>*,.bb-comment .comment-list .list-item .info .like>*,.bb-comment .comment-list .list-item .info .operation .spot,.bb-comment .comment-send .comment-emoji>*,.dynamic-hate i,.dynamic-like i{transition:.2s ease-out}.bb-comment .comment-list .list-item .info .hate i,.bb-comment .comment-list .list-item .info .like i,.bb-comment .comment-list .list-item .info .operation .spot,.bb-comment .comment-send .comment-emoji .face,.dynamic-hate i,.dynamic-like i,.dynamic-spot,.textarea-container .comm-tool .comm-emoji .icon-face{height:16px!important;width:16px!important;opacity:.5}.bb-comment .comment-list .list-item .info .hate span,.bb-comment .comment-list .list-item .info .like span,.bb-comment .comment-send .comment-emoji span{opacity:.5}.bb-comment .comment-list .list-item .info .hate span,.bb-comment .comment-list .list-item .info .hate.hated span,.bb-comment .comment-list .list-item .info .hate:hover span,.bb-comment .comment-list .list-item .info .like span,.bb-comment .comment-list .list-item .info .like.liked span,.bb-comment .comment-list .list-item .info .like:hover span,.bb-comment .comment-send .comment-emoji span{color:#000}.bb-comment .comment-list .list-item .info .hate:hover>*,.bb-comment .comment-list .list-item .info .like.hated:hover>*,.bb-comment .comment-list .list-item .info .like.hated>*,.bb-comment .comment-list .list-item .info .like.liked:hover>*,.bb-comment .comment-list .list-item .info .like.liked>*,.bb-comment .comment-list .list-item .info .like:hover>*,.bb-comment .comment-list .list-item .info .operation .spot:hover,.bb-comment .comment-send .comment-emoji.open .face,.bb-comment .comment-send .comment-emoji:hover .face,.bb-comment .comment-send .comment-emoji:hover span{opacity:.7}.bb-comment .comment-list .list-item .info .like i,.dynamic-like i{background:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="16" height="16" viewBox="0 0 24 24"><path fill="black" d="M5,9V21H1V9H5M9,21A2,2 0 0,1 7,19V9C7,8.45 7.22,7.95 7.59,7.59L14.17,1L15.23,2.06C15.5,2.33 15.67,2.7 15.67,3.11L15.64,3.43L14.69,8H21C22.11,8 23,8.9 23,10V12C23,12.26 22.95,12.5 22.86,12.73L19.84,19.78C19.54,20.5 18.83,21 18,21H9M9,19H18.03L21,12V10H12.21L13.34,4.68L9,9.03V19Z" /></svg>')!important}.bb-comment .comment-list .list-item .info .like.liked i,.bb-comment .comment-list .list-item .info .like.liked:hover i,.dynamic-like:hover i,.dynamic-liked i{background:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="16" height="16" viewBox="0 0 24 24"><path fill="black" d="M23,10C23,8.89 22.1,8 21,8H14.68L15.64,3.43C15.66,3.33 15.67,3.22 15.67,3.11C15.67,2.7 15.5,2.32 15.23,2.05L14.17,1L7.59,7.58C7.22,7.95 7,8.45 7,9V19A2,2 0 0,0 9,21H18C18.83,21 19.54,20.5 19.84,19.78L22.86,12.73C22.95,12.5 23,12.26 23,12V10M1,21H5V9H1V21Z" /></svg>')!important}.bb-comment .comment-list .list-item .info .hate i,.dynamic-hate i{background:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="16" height="16" viewBox="0 0 24 24"><path fill="black" d="M19,15V3H23V15H19M15,3A2,2 0 0,1 17,5V15C17,15.55 16.78,16.05 16.41,16.41L9.83,23L8.77,21.94C8.5,21.67 8.33,21.3 8.33,20.88L8.36,20.57L9.31,16H3C1.89,16 1,15.1 1,14V12C1,11.74 1.05,11.5 1.14,11.27L4.16,4.22C4.46,3.5 5.17,3 6,3H15M15,5H5.97L3,12V14H11.78L10.65,19.32L15,14.97V5Z" /></svg>')!important}.bb-comment .comment-list .list-item .info .hate.hated i,.bb-comment .comment-list .list-item .info .hate.hated:hover i,.dynamic-hate:hover i,.dynamic-hated i{background:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="16" height="16" viewBox="0 0 24 24"><path fill="black" d="M19,15H23V3H19M15,3H6C5.17,3 4.46,3.5 4.16,4.22L1.14,11.27C1.05,11.5 1,11.74 1,12V14A2,2 0 0,0 3,16H9.31L8.36,20.57C8.34,20.67 8.33,20.77 8.33,20.88C8.33,21.3 8.5,21.67 8.77,21.94L9.83,23L16.41,16.41C16.78,16.05 17,15.55 17,15V5C17,3.89 16.1,3 15,3Z" /></svg>')!important}.bb-comment .comment-list .list-item .info .operation .spot,.dynamic-spot{background:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="16" height="16" viewBox="0 0 24 24"><path fill="black" d="M12,16A2,2 0 0,1 14,18A2,2 0 0,1 12,20A2,2 0 0,1 10,18A2,2 0 0,1 12,16M12,10A2,2 0 0,1 14,12A2,2 0 0,1 12,14A2,2 0 0,1 10,12A2,2 0 0,1 12,10M12,4A2,2 0 0,1 14,6A2,2 0 0,1 12,8A2,2 0 0,1 10,6A2,2 0 0,1 12,4Z" /></svg>')!important}.bb-comment .comment-send .comment-emoji .face,.textarea-container .comm-tool .comm-emoji .icon-face{background:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="16" height="16" viewBox="0 0 24 24"><path fill="black" d="M12,17.5C14.33,17.5 16.3,16.04 17.11,14H6.89C7.69,16.04 9.67,17.5 12,17.5M8.5,11A1.5,1.5 0 0,0 10,9.5A1.5,1.5 0 0,0 8.5,8A1.5,1.5 0 0,0 7,9.5A1.5,1.5 0 0,0 8.5,11M15.5,11A1.5,1.5 0 0,0 17,9.5A1.5,1.5 0 0,0 15.5,8A1.5,1.5 0 0,0 14,9.5A1.5,1.5 0 0,0 15.5,11M12,20A8,8 0 0,1 4,12A8,8 0 0,1 12,4A8,8 0 0,1 20,12A8,8 0 0,1 12,20M12,2C6.47,2 2,6.5 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12A10,10 0 0,0 12,2Z" /></svg>')!important}.bb-comment .reply-notice .notice-item{background-color:#0001!important;border:none!important;display:flex!important;align-items:center;padding:10px 14px!important}.dark .bb-comment .reply-notice .notice-item{background-color:#333!important}.bb-comment .reply-notice .notice-item .icon-notice{order:0;position:static!important;margin-right:12px;background:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="18" height="18" viewBox="0 0 24 24"><path fill="black" d="M20,11H4V8H20M20,15H13V13H20M20,19H13V17H20M11,19H4V13H11M20.33,4.67L18.67,3L17,4.67L15.33,3L13.67,4.67L12,3L10.33,4.67L8.67,3L7,4.67L5.33,3L3.67,4.67L2,3V19A2,2 0 0,0 4,21H20A2,2 0 0,0 22,19V3L20.33,4.67Z" /></svg>')!important}.bb-comment .reply-notice .notice-item a{order:1;flex-grow:1;color:#000!important}.dark .bb-comment .reply-notice .notice-item a{color:#eee!important}.bb-comment .reply-notice .notice-item .icon-close-notice{order:2;position:static!important;background:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="18" height="18" viewBox="0 0 24 24"><path fill="black" d="M19,6.41L17.59,5L12,10.59L6.41,5L5,6.41L10.59,12L5,17.59L6.41,19L12,13.41L17.59,19L19,17.59L13.41,12L19,6.41Z" /></svg>')!important}.bb-comment .reply-notice .notice-item .icon-close-notice,.bb-comment .reply-notice .notice-item .icon-notice{height:18px;width:18px;opacity:.7}.bb-comment .comment-list .list-item .user .text-con{white-space:pre-wrap;display:block}.bb-comment .comment-list .list-item .text{white-space:pre-wrap}body.dark .bb-comment .comment-list .list-item .info .hate.hated>i,body.dark .bb-comment .comment-list .list-item .info .hate>i,body.dark .bb-comment .comment-list .list-item .info .like.liked>i,body.dark .bb-comment .comment-list .list-item .info .like>i,body.dark .bb-comment .comment-list .list-item .info .operation .spot,body.dark .bb-comment .comment-list .list-item>.con>.info>.floor,body.dark .bb-comment .comment-list .list-item>.con>.info>.time,body.dark .bb-comment .comment-list .reply-con>.info>.time,body.dark .bb-comment .comment-send .comment-emoji .text,body.dark .dynamic-hate i,body.dark .dynamic-hate:hover i,body.dark .dynamic-hated i,body.dark .dynamic-hated:hover i,body.dark .dynamic-like i,body.dark .dynamic-like:hover i,body.dark .dynamic-liked i,body.dark .dynamic-liked:hover i,body.dark .dynamic-spot,body.dark .textarea-container .comm-tool .comm-emoji .icon-face{filter:brightness(0) invert(1)!important}body.dark .bb-comment .comment-list .list-item .info .hate span,body.dark .bb-comment .comment-list .list-item .info .hate.hated span,body.dark .bb-comment .comment-list .list-item .info .hate:hover span,body.dark .bb-comment .comment-list .list-item .info .like span,body.dark .bb-comment .comment-list .list-item .info .like.liked span,body.dark .bb-comment .comment-list .list-item .info .like:hover span,body.dark .bb-comment .reply-item>.info>.time{color:#eee!important}`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/comment.min.js"] = (()=>{return(e,t)=>{t.applyImportantStyle("useCommentStyleStyle");return{reload:()=>t.applyImportantStyle("useCommentStyleStyle"),unload:()=>t.removeStyle("useCommentStyleStyle")}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/comment-dark.min.css"] = `.bb-comment .comment-list .list-item .info .hate.hated>i,.bb-comment .comment-list .list-item .info .hate>i,.bb-comment .comment-list .list-item .info .like.liked>i,.bb-comment .comment-list .list-item .info .like>i,.bb-comment .comment-list .list-item .info .operation .spot,.bb-comment .comment-list .list-item>.con>.info>.floor,.bb-comment .comment-list .list-item>.con>.info>.time,.bb-comment .comment-list .reply-con>.info>.time,.bb-comment .comment-send .comment-emoji .text,.dynamic-hate i,.dynamic-hate:hover i,.dynamic-hated i,.dynamic-hated:hover i,.dynamic-like i,.dynamic-like:hover i,.dynamic-liked i,.dynamic-liked:hover i,.dynamic-spot,.textarea-container .comm-tool .comm-emoji .icon-face{filter:brightness(0) invert(1)!important}.bb-comment .comment-list .list-item .info .hate span,.bb-comment .comment-list .list-item .info .hate.hated span,.bb-comment .comment-list .list-item .info .hate:hover span,.bb-comment .comment-list .list-item .info .like span,.bb-comment .comment-list .list-item .info .like.liked span,.bb-comment .comment-list .list-item .info .like:hover span{color:#eee!important}`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/compact-layout.min.css"] = `.groom-module{margin:0!important;width:192px!important;height:120px!important}.primary-menu .nav-menu .side-nav .side-link i,.primary-menu .nav-menu>li.home>a{opacity:.4}body.dark .primary-menu .nav-menu .side-nav .side-link i,body.dark .primary-menu .nav-menu>li.home>a{opacity:1}.bangumi-timing-module .card-timing,.groom-module{-webkit-tap-highlight-color:transparent}.chief-recommend-module .recommend-module,.groom-box-m,.nominate-m .video-card-box{height:240px!important}.groom-module .lazy-img,.groom-module .pic{width:100%!important;height:100%!important}.groom-module:hover .lazy-img,.groom-module:hover .pic{filter:blur(8px)}.groom-module .card-mark{width:calc(100% - 20px)!important;top:88px;padding:10px!important}.groom-module:hover .card-mark{top:0!important}.chief-recommend-module .carousel-box,.chief-recommend-module .carousel-box img{height:240px!important;width:480px!important}.nominate-m .carousel-box,.nominate-m .carousel-box img{height:240px!important;width:672px!important}.live-module .storey-box .card-live-module,.special-module,.storey-box .spread-module,.video-item-biref{margin:0!important;width:192px!important;height:168px!important;-webkit-tap-highlight-color:transparent}.special-module{height:192px!important}.special-module .pic .title{line-height:unset!important;height:auto!important}.special-recommend-module .storey-box{height:180px!important}.special-module .user{transform:translatey(24px)}.live-module .storey-box .card-live-module .pic,.mod-1 .l .spread-module,.mod-2 .spread-module,.mod-2 li .l,.mod-3 .l .spread-module,.mod-3 .l-item .l,.special-module .pic-box,.spread-module .pic,.video-item-biref .biref-img{width:192px!important;height:120px!important}.mod-2 li .l-item{height:auto}.mod-3 .l-item,.mod-3 li{width:192px!important}.mod-3 .l .spread-module{margin:0!important}.mod-1 .r,.mod-1 li,.mod-2 li .l-item,.mod-3 li{padding:0!important}.mod-3 .r .title,.mod-3 .r .up-info,.mod-3 .r .v-info{padding-top:4px!important;margin-top:0!important}.mod-2 li .r .v-desc{padding:0!important;margin:10px 0!important}.live-module .storey-box .card-live-module .num,.spread-module .num{padding-left:8px;padding-right:8px;bottom:6px}.live-module .storey-box .card-live-module .t,.special-module .pic .title,.spread-module .t,.video-item-biref .biref-info .biref-title{padding-left:4px;padding-right:4px;padding-top:4px}.sec-rank .rank-list-wrap .rank-list{min-height:288px}.hot-recom-module{height:auto!important}.game-groom-box-m,.game-groom-box-m .game-groom-m{height:100%!important}.article-card .article-cover,.article-card .article-cover img,.card-live-module .pic .mask,.carousel-box .carousel-module .panel,.carousel-wrapper,.game-groom-box-m .game-groom-m,.groom-module,.live-module .storey-box .card-live-module .pic,.mod-3 .l-item,.rank-item .content .img .cover img,.special-module .pic-box,.spread-module .pic,.video-item-biref .biref-img{border-radius:8px!important}.article-rank-list .rank-item .ri-num,.card-timing-module .pic,.rank-list .rank-item .ri-num,.timeline-box .timeline-item .preview,.timeline-box .timeline-item .preview img{border-radius:50%!important}.cover-preview-module .cover{width:160px;transform-origin:left top 0;transform:scale(1.3)}.bangumi-timing-module .card-timing{width:205px}.card-timing-module .r-text{width:120px}.recommend-module .rec-btn.prev{left:0!important}.primary-menu{display:flex;align-items:center;margin:0;width:100%}.primary-menu .nav-menu{flex:1 0 auto;display:flex;justify-content:space-between;align-items:center;margin-right:28px}.primary-menu .nav-menu>li .num-wrap span{padding:2.5px;line-height:unset;height:auto;min-width:30px}.primary-menu .nav-menu .side-nav .side-link i.blackroom,.primary-menu .nav-menu .side-nav .side-link i.live,.primary-menu .nav-menu .side-nav .side-link i.square,.primary-menu .nav-menu .side-nav .side-link i.zhuanlan,.primary-menu .nav-menu>li.home>a{background-size:contain;background-repeat:no-repeat;background-position:initial}.primary-menu .nav-menu>li .num-wrap{top:0;position:static;height:auto}.primary-menu .nav-menu li .nav-name{line-height:unset;height:auto}.primary-menu .nav-menu>li:not(.home) .nav-name{height:auto;padding:0}.nav-gif{position:static;flex:0 0 auto}.primary-menu .nav-menu li.home>a .nav-name{visibility:hidden;display:block;position:static}.primary-menu .nav-menu .sub-nav{top:36px;padding-top:4px}.main-inner{width:1160px}.rank-item .content .img .cover{width:180px;height:110px}.rank-item .content{padding:0 0 0 70px;height:110px}.rank-item .content .info{padding-top:8px;margin-left:192px}.rank-item .content .info .pts{bottom:50px}@media screen and (min-width:1300px){.bili-wrapper,.cinema-home-wrapper{width:1248px!important}.block-area .block-left{width:960px!important}.timeline-box .timeline-item{padding-right:32px!important}.elevator-module{margin-left:630px!important}.bili-wrapper .l-con{width:988px!important}.bangumi-timing-module .card-timing{padding:36px 30px 0 0}.bangumi-timing-module .card-timing:nth-child(4):nth-child(4){padding-top:0}.mod-1 li .r{width:750px!important}.mod-2 li .r{width:245px!important}.mod-2 li .r .up-info .v-author,.mod-2 li .r .v-info .v-info-i{width:70px!important}.bangumi-timing-module .headline .bili-tab{width:700px;display:flex;justify-content:space-evenly}}@media screen and (max-width:1300px){.bili-wrapper,.cinema-home-wrapper{width:1056px!important}.block-area .block-left{width:768px!important}.elevator-module{margin-left:540px!important}.bili-wrapper .l-con{width:768px!important}.bangumi-timing-module .card-timing{padding:36px 36px 0 0}#ranking_guochuang{width:260px!important;transform:translatex(28px)}.mod-1 li .r{width:530px!important}.mod-2 li .r{width:160px!important}.mod-2 li .r .up-info .v-author,.mod-2 li .r .v-info .v-info-i{width:50px!important}}.article-card .article-info{width:304px!important}.article-card .article-cover,.article-card .article-cover img{width:116px!important;height:87px!important}.article-card{margin-bottom:0!important}.article-card .article-info .data>.comment,.article-card .article-info .data>.view{display:inline-flex!important;align-items:center!important}.article-card .article-info .data{display:flex!important;align-items:center!important}@media screen and (max-width:1300px){.article-card .article-info{width:220px!important}}`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/compact-layout.min.js"] = (()=>{return(t,c)=>{const o=["https://www.bilibili.com/","https://www.bilibili.com/watchlater/#/list","https://www.bilibili.com/ranking"];if(o.includes(location.href.replace(location.search,""))){document.body.classList.add("compact");c.applyImportantStyle("compactLayoutStyle")}return{reload:()=>{if(o.includes(location.href.replace(location.search,""))){document.body.classList.add("compact");c.applyImportantStyle("compactLayoutStyle")}},unload:()=>{document.body.classList.remove("compact");c.removeStyle("compactLayoutStyle")}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-control-background.min.css"] = `.bilibili-player-video-control-mask{background:0 0!important}.bilibili-player-video-control .bilibili-player-video-control-bottom,.bilibili-player-video-control .bui-slider .bui-track.bui-track-video-progress .bui-bar-wrap{background:rgba(0,0,0,var(--custom-control-background-opacity))!important}`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-control-background.min.js"] = (()=>{return(o,t)=>{document.body.style.setProperty("--custom-control-background-opacity",o.customControlBackgroundOpacity);addSettingsListener("customControlBackgroundOpacity",o=>{document.body.style.setProperty("--custom-control-background-opacity",o)});const n=()=>{t.applyStyle("customControlBackgroundStyle");if(!o.touchVideoPlayer){t.applyImportantStyleFromText(`\n<style id="control-background-non-touch">\n            .bilibili-player-video-control-bottom\n            {\n                margin: 7px 0 0 0 !important;\n                padding: 8px 0 0 !important;\n            }\n</style>\n`)}};n();return{reload:n,unload:()=>{t.removeStyle("customControlBackgroundStyle");const o=document.getElementById("control-background-non-touch");o&&o.remove()}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar.min.css"] = `@font-face{font-family:custom-navbar-font;src:url(//s1.hdslb.com/bfs/seed/jinkela/header/asserts/iconfont.ttf) format("truetype")}@font-face{font-family:custom-navbar-font-extended;src:url(//s1.hdslb.com/bfs/static/jinkela/video/asserts/iconfont.4bab144.ttf) format("truetype")}@font-face{font-family:custom-navbar-font-new-home;src:url(//s1.hdslb.com/bfs/seed/jinkela/header-v2/asserts/iconfont.ttf) format("truetype")}.custom-navbar-iconfont,.custom-navbar-iconfont-extended,.custom-navbar-iconfont-new-home{color:inherit;font-family:custom-navbar-font!important;font-size:24px;font-style:normal}.custom-navbar-iconfont-extended{font-family:custom-navbar-font-extended!important}.custom-navbar-iconfont-new-home{font-family:custom-navbar-font-new-home!important}.custom-navbar-icon-logo::before{content:""}.custom-navbar-icon-lv0::before{content:"";color:#9a9a9a}.custom-navbar-icon-lv1::before{content:"";color:#646464}.custom-navbar.dark .custom-navbar-icon-lv0::before{color:#777}.custom-navbar.dark .custom-navbar-icon-lv1::before{color:#ddd}.custom-navbar-icon-lv2::before{content:"";color:#1bc861}.custom-navbar-icon-lv3::before{content:"";color:#22baea}.custom-navbar-icon-lv4::before{content:"";color:#eaa722}.custom-navbar-icon-lv5::before{content:"";color:#ff7631}.custom-navbar-icon-lv6::before{content:"";color:#ff3131}.custom-navbar-icon-profile::before{content:""}.custom-navbar-icon-posts::before{content:""}.custom-navbar-icon-wallet::before{content:""}.custom-navbar-icon-live-center::before{content:""}.custom-navbar-icon-order-center::before{content:""}.custom-navbar-icon-logout::before{content:""}.custom-navbar-icon-ok::before{content:""}.custom-navbar-icon-cancel::before{content:""}.custom-navbar-icon-bind-phone::before{content:""}.custom-navbar-icon-bind-email::before{content:""}.custom-navbar-icon-coin::before{content:""}.custom-navbar-icon-b-coin::before{content:""}.custom-navbar-icon-activity::before{content:""}.custom-navbar-icon-message::before{content:""}.custom-navbar-icon-favorite::before{content:""}.custom-navbar-icon-history::before{content:""}.custom-navbar-icon-vip::before{content:""}.custom-navbar-icon-course::before{content:""}[class^=custom-navbar-icon-lv]::before{font-size:24px}body{--navbar-height:50px;--navbar-foreground:#555;--navbar-background:white;--navbar-bounds-padding:0 5%;--navbar-blur-opacity:0.7;--navbar-icon-size:24px}body.custom-navbar-loading::after{content:"";height:var(--navbar-height);width:100%;position:absolute;top:0;left:0;background-color:#fff;z-index:10001}body.dark.custom-navbar-loading::after{background-color:#333}.bili-banner .taper-line,.bili-header-m .head-banner .head-content .head-logo,.bili-header-m>#banner_link .search,.i_menu_login,.international-header .b-logo,.international-header .mini-header,.z-top-container>.header .search,body.no-banner #banner_link,body.no-banner .z-top-container.has-banner>.header,li.nav-item[report-id=playpage_dynamic] .i-frame,li.nav-item[report-id=playpage_dynamic] iframe{display:none!important}.van-popover{z-index:10002!important}:not(.international-home)>.international-header{min-height:var(--navbar-height)!important}.bili-header-m .head-banner{margin-top:calc(-1 * var(--navbar-height))!important}.bili-header-m>.nav-menu,.z_top{visibility:hidden!important;height:var(--navbar-height)!important}.link-top-container#tab-container{top:var(--navbar-height)!important}.custom-navbar,.custom-navbar *,.custom-navbar-settings,.custom-navbar-settings *{transition:.2s ease-out;-webkit-tap-highlight-color:transparent;outline:0!important;margin-inline-start:0;margin-inline-end:0;padding-inline-start:0;padding-inline-end:0}.custom-navbar{position:absolute;top:0;left:0;height:var(--navbar-height);width:100%;background-color:var(--navbar-background);color:var(--navbar-foreground);z-index:10001;display:flex;justify-content:center}.custom-navbar:not(.fill) .custom-navbar-iconfont{color:var(--theme-color)}.custom-navbar path{fill:var(--navbar-foreground)}.custom-navbar.fill:not(.transparent) path{fill:var(--foreground-color-d)}.custom-navbar.shadow:not(.transparent){box-shadow:#0002 0 1px 10px 1px}.custom-navbar.dark.shadow:not(.transparent){box-shadow:#0004 0 2px 10px 1px}.custom-navbar.dark:not(.fill):not(.transparent){--navbar-background:#222;--navbar-foreground:#eee}.custom-navbar.transparent{--navbar-background:transparent;--navbar-foreground:#eee}.custom-navbar.transparent::before{content:"";position:absolute;top:0;left:0;width:100%;height:calc(2 * var(--navbar-height));background-image:linear-gradient(to bottom,#000a 0,#0004 65%,transparent 100%)}.custom-navbar .popup{color:#000;background:#fff;transition:.2s ease-out .2s}.custom-navbar.dark .popup{color:#eee;background:#222}.custom-navbar.dark .popup iframe{box-shadow:rgba(0,0,0,.2) 0 4px 8px 0}.custom-navbar.fill:not(.transparent){--navbar-background:var(--theme-color);--navbar-foreground:var(--foreground-color-d);height:var(--navbar-height);width:100%}.custom-navbar.fill.shadow:not(.transparent){box-shadow:var(--theme-color-30) 0 2px 10px 1px}.custom-navbar>ul{display:flex;align-items:center;justify-content:space-between;margin:var(--navbar-bounds-padding);height:100%;flex-grow:1}.custom-navbar ul{list-style:none;color:inherit}.custom-navbar li{color:inherit;list-style:none}.custom-navbar>ul>li{position:relative;height:100%;display:flex;align-items:center;color:inherit}.custom-navbar li .active-bar{position:absolute;left:0;bottom:0;background-color:var(--theme-color);width:100%;height:3px;border-radius:1.5px;display:none}.custom-navbar.fill li .active-bar,.custom-navbar.transparent li .active-bar{background-color:rgba(0,0,0,.3)}.custom-navbar li.active .active-bar{display:flex}.custom-navbar>ul>li.view-border::before{content:"";width:94%;height:94%;border:2px dashed var(--navbar-foreground);position:absolute;top:3%;left:3%;box-sizing:border-box}.custom-navbar>ul>li:not(.disabled){cursor:pointer}.custom-navbar>ul>li.disabled a{cursor:default}.custom-navbar>ul>li:not(.disabled):hover{background:rgba(0,0,0,.1)}.custom-navbar .main-content{font-size:10pt;height:100%;display:flex;align-items:center;padding:0 10px;color:var(--navbar-foreground);user-select:none}.custom-navbar .active .main-content{font-weight:700;font-size:11pt}.custom-navbar .main-content:hover{color:var(--navbar-foreground)!important}.custom-navbar .popup{position:absolute;top:100%;left:50%;padding:8px;box-shadow:rgba(0,0,0,.2) 0 4px 8px 0;pointer-events:none;opacity:0;transform:translateY(-6px) translateX(-50%);cursor:default}.custom-navbar .popup.no-padding{padding:0}.custom-navbar .popup.transparent{background-color:transparent!important;box-shadow:none}.custom-navbar li.left-side .popup{left:0;transform:translateY(-6px) translateX(10%)}.custom-navbar li.right-side .popup{left:100%;transform:translateY(-6px) translateX(-90%)}.custom-navbar.dark .popup{box-shadow:rgba(0,0,0,.3) 0 4px 8px 0}.custom-navbar a,.custom-navbar a:hover{color:inherit!important;text-decoration:none}.custom-navbar form{height:100%;display:flex;align-items:center;position:relative;--submit-button-size:30px;opacity:.4;margin:0}.custom-navbar.fill:not(.transparent) form{opacity:.8}.custom-navbar form:focus-within,.custom-navbar form:hover,.custom-navbar.fill form:focus-within,.custom-navbar.fill form:hover{opacity:1}.custom-navbar form input{border:none;height:60%;background:0 0;border-bottom:1.5px solid!important;color:var(--navbar-foreground);box-sizing:border-box;width:250px;padding-right:var(--submit-button-size);padding-left:4px}.custom-navbar form input:focus{border-bottom-color:var(--navbar-foreground)!important;outline:0!important}.custom-navbar form button[type=submit]{background:0 0;border:none;padding:4px;cursor:pointer;height:var(--submit-button-size);width:var(--submit-button-size);position:absolute;right:0;top:50%;transform:translateY(-50%)}.custom-navbar form input[type=text]::placeholder{color:var(--navbar-foreground)!important;opacity:.9}.custom-navbar .user-face-container{position:relative;height:calc(var(--navbar-height) - 16px);width:calc(var(--navbar-height) - 16px)}.custom-navbar .user-face,.custom-navbar .user-pendant{position:absolute;width:100%;height:100%}.custom-navbar .user-face{background-color:transparent;background-size:contain;border-radius:50%}.custom-navbar .user-pendant{background-color:transparent;background-size:cover;width:170%;height:170%;top:-12px;left:-12px;opacity:0;pointer-events:none}.custom-navbar .user-info-panel{width:240px;font-size:12px}.custom-navbar .user-info-panel .circle{position:relative;width:var(--navbar-icon-size);height:var(--navbar-icon-size);opacity:.7}.custom-navbar .user-info-panel .circle .mdi{position:absolute;top:0;left:0}.custom-navbar .user-info-panel .mdi-circle~.mdi{filter:invert(1);font-size:calc(var(--navbar-icon-size) - 10px);line-height:calc(var(--navbar-icon-size) - 10px);transform:translate(5px,5px)}.custom-navbar .user-info-panel i{font-size:var(--navbar-icon-size);font-style:normal;line-height:var(--navbar-icon-size)}.custom-navbar .user-info-panel .logged-in{display:flex;flex-direction:column;align-items:center;justify-content:space-between}.custom-navbar .user-info-panel .items,.custom-navbar .user-info-panel .row{align-self:stretch;display:flex;justify-content:space-between;align-items:center}.custom-navbar .user-info-panel .row{margin:0 10px;width:auto!important}.custom-navbar .user-info-panel .row::after{content:none!important}.custom-navbar .user-info-panel .row.level-info{margin-bottom:-5px}.custom-navbar .user-info-panel .privileges{justify-content:center}.custom-navbar .user-info-panel .privileges>*{font-size:11px;background-color:#8882;padding:2px 4px;margin:0 2px;border-radius:4px;line-height:normal;cursor:pointer}.custom-navbar .user-info-panel .privileges>.received{cursor:default;opacity:.5}.custom-navbar .user-info-panel .privileges>:not(.received):hover{background-color:#8884}.custom-navbar .user-info-panel .operation{height:36px;display:flex;align-items:center;justify-content:center;position:relative;align-self:stretch}.custom-navbar .user-info-panel .operation:hover{background-color:rgba(0,0,0,.1)}.custom-navbar .user-info-panel .operation .icon{position:absolute;left:10px;top:50%;transform:translateY(-50%);background:0 0}.custom-navbar .user-info-panel .item>i{opacity:.7;font-size:14pt}.custom-navbar .user-info-panel .item{display:flex;flex-direction:column;justify-content:space-around;align-items:center;height:48px;flex:1}.custom-navbar .user-info-panel .item span{font-size:14px;font-weight:700;opacity:.7}.custom-navbar .user-info-panel .item>i:nth-child(2){font-size:18px;line-height:18px}.custom-navbar .user-info-panel .name,.custom-navbar .user-info-panel .welcome{font-size:16px;font-weight:700;margin:46px 0 16px;text-align:center;color:inherit}.custom-navbar .user-info-panel .name{margin:62px 0 0}.custom-navbar .user-info-panel .type{font-size:11px;opacity:.5;margin:6px 0}.custom-navbar .user-info-panel .separator{height:1px;align-self:stretch;margin:5px 10px;background:rgba(0,0,0,.1)}.custom-navbar .user-info-panel .logout{margin-top:5px}.custom-navbar .user-info-panel .logout:hover{color:inherit!important}.custom-navbar .user-info-panel .level-progress-thumb{width:100%;height:100%;background:var(--theme-color);transform-origin:left}.custom-navbar .user-info-panel .level-progress-label{font-size:11px}.custom-navbar .user-info-panel .stats{display:flex;align-items:center;align-self:stretch;margin:0 10px;line-height:normal}.custom-navbar .user-info-panel .stats-item{padding:6px 0;flex:1;display:flex;flex-direction:column;align-items:center;transition:none}.custom-navbar .user-info-panel .stats-item:hover{color:var(--theme-color)!important}.custom-navbar .user-info-panel .stats-item .stats-number{font-weight:700;margin-bottom:4px;font-size:14px;transition:none}.custom-navbar.dark .user-info-panel .separator{background:rgba(255,255,255,.1)}.custom-navbar .grey-button,.custom-navbar .theme-button{align-self:stretch;height:36px;display:flex;align-items:center;justify-content:center}.custom-navbar .grey-button{background:#ededed;color:inherit!important}.custom-navbar .grey-button:hover{background:#ddd}.custom-navbar.dark .grey-button{background:#383838}.custom-navbar.dark .grey-button:hover{background:#333}.custom-navbar .theme-button{background:var(--theme-color);color:var(--foreground-color)!important}.custom-navbar .theme-button:hover{background:var(--theme-color-90);color:var(--foreground-color)!important}.custom-navbar li:hover .user-face,.custom-navbar li:hover .user-pendant{transform:scale(2) translateY(10px);z-index:100;opacity:1}.custom-navbar .video-list{width:280px;font-size:12px}.custom-navbar .video-list li:not(.history-item):not(.more):not(.loading)::after,.custom-navbar .video-list li:not(.history-item):not(.more):not(.loading)::before{content:"";transition:.3s cubic-bezier(.22,.61,.36,1) .1s;width:calc(100% - 16px);height:2px;border-radius:1px;background:linear-gradient(to right,var(--theme-color),var(--theme-color-50));opacity:1;position:absolute;bottom:0;left:8px;pointer-events:none}.custom-navbar .video-list li:not(.history-item):not(.more):not(.loading)::after{width:0;background:linear-gradient(to right,var(--theme-color),var(--theme-color-50))}.custom-navbar .video-list li:not(.history-item):not(.more):not(.loading):hover::after{width:calc(100% - 16px)}.custom-navbar.dark .video-list li:not(.history-item):not(.more):not(.loading)::after{background:linear-gradient(to right,var(--theme-color-60),var(--theme-color))}.custom-navbar .video-list li:not(.history-item):not(.more):not(.loading)::before{background:#8882}.custom-navbar .video-list li{position:relative}.custom-navbar .video-list li:not(.more) a{padding:12px 16px;margin:0;box-sizing:border-box;transition:.2s ease-out .1s;display:block;width:100%;height:100%;line-height:1.5}.custom-navbar.compact .video-list li:not(.more) a{padding:6px 8px}.custom-navbar .video-list li:not(.loading):hover .title{color:var(--theme-color)}.custom-navbar .video-list li.more a{width:100%;padding:8px 0;display:flex;justify-content:center;font-weight:700}.custom-navbar.compact .video-list li.more a{padding:6px 0}.custom-navbar .video-list li.more:hover{border-color:var(--theme-color);color:var(--theme-color)!important}.custom-navbar .video-list .loading{display:flex;justify-content:center;padding:8px;cursor:default}.custom-navbar .video-list.loaded .loading:not(.empty){display:none}.custom-navbar .video-list.history .history-item{border:none!important}.custom-navbar.compact .video-list li:not(.more) a,.custom-navbar.compact .video-list.history .history-item .title{white-space:nowrap;text-overflow:ellipsis;overflow:hidden}.custom-navbar .video-list li:not(.history-item):not(.more):hover a{color:var(--theme-color)!important}.custom-navbar .video-list.history li:not(.more) a{justify-content:space-between;position:relative;display:flex;padding:13px 16px!important}.custom-navbar.compact .video-list.history li:not(.more) a{padding:7px 8px!important}.custom-navbar .video-list.history a .description{opacity:.6;margin-left:4px;white-space:nowrap}.custom-navbar .video-list.history a .progress.foreground{height:2px;border-radius:1px;background:linear-gradient(to right,var(--theme-color),var(--theme-color-50));width:0;transition:.3s cubic-bezier(.22,.61,.36,1) .1s}.custom-navbar .video-list.history a:hover .progress.foreground{width:var(--progress)}.custom-navbar.dark .video-list.history a .progress.foreground{background:linear-gradient(to right,var(--theme-color-60),var(--theme-color))}.custom-navbar .video-list.history a .progress.background{position:absolute;bottom:0;left:8px;height:2px;width:calc(100% - 16px);transform-origin:left;border-radius:1px;background:#8882}.custom-navbar .notify-count{position:absolute;left:50%;top:0;background-color:var(--theme-color);padding:0 8px;display:flex;justify-content:center;font-size:11px;transform:translateX(-50%);opacity:0;line-height:14px;white-space:nowrap;color:var(--foreground-color);border-radius:0 0 8px 8px}.custom-navbar .notify-count:not(:empty):not(.hidden){opacity:1}.custom-navbar .notify-count.dot{color:transparent;border-radius:50%;width:8px;height:8px;padding:0;top:2px}.custom-navbar.fill .notify-count{background-color:rgba(0,0,0,.3)}.custom-navbar .blur-layer-container{overflow:hidden;display:none;width:100%;height:100%;position:absolute;top:0;left:0}.custom-navbar.blur:not(.transparent) .blur-layer-container{display:flex}.custom-navbar .blur-layer{width:100%;height:100%;background-position:center 0;background-repeat:no-repeat;filter:blur(36px);opacity:var(--navbar-blur-opacity)}.custom-navbar .blur-layer.left-pad{position:absolute;left:0;top:0;transform:translateX(-100%) scaleX(-1);width:100%;height:100%}.custom-navbar .blur-layer.right-pad{position:absolute;left:0;top:0;transform:translateX(100%) scaleX(-1);width:100%;height:100%}.custom-navbar.dark .blur-layer{filter:blur(54px)}.custom-navbar ol{color:#000}.custom-navbar.dark ol{color:#eee}.custom-navbar em.suggest-highlight{color:var(--theme-color);font-style:normal}.custom-navbar .copy-tip{position:absolute;top:calc(100% + 4px);left:50%;pointer-events:none;opacity:0;transform:translateX(-50%) translateY(-8px);border-radius:4px;background-color:#000a;color:#fff;padding:6px 8px}.custom-navbar .copy-tip.show{transform:translateX(-50%) translateY(0);opacity:1}.custom-navbar .search-list-item{white-space:nowrap;text-overflow:ellipsis;overflow:hidden;cursor:pointer;display:flex;align-items:center}.custom-navbar .search-list-item-text{white-space:nowrap;text-overflow:ellipsis;overflow:hidden;flex:1;padding:6px 0 6px 6px}.custom-navbar .search-list-item .delete-history{opacity:.5;padding:6px 6px 6px 0;line-height:1}.custom-navbar .search-list-item .delete-history:hover{opacity:1}.custom-navbar .search-list-item:focus-within,.custom-navbar .search-list-item:hover{background-color:#8883}.custom-navbar .search-list-item.clear-history{text-align:center;font-weight:700;background-color:#8881;margin-top:8px;display:flex;align-items:center;justify-content:center;padding:6px}.custom-navbar .search-list-item.clear-history .mdi{line-height:1;margin-right:6px}.custom-navbar .search-list-item.clear-history:focus-within,.custom-navbar .search-list-item.clear-history:hover{color:var(--theme-color);background-color:#8883}.custom-navbar .search-list{width:250px}.custom-navbar .activity-popup{width:380px;font-size:9pt}.custom-navbar .activity-tabs{display:flex;padding:12px 12px 16px 18px;justify-content:space-between;align-items:center}.custom-navbar .activity-tabs .view-all,.custom-navbar .subscriptions-tabs .view-all{background-color:#8882;padding:4px 6px 4px 10px;height:28px;box-sizing:border-box;border-radius:14px;display:flex;align-items:center}.custom-navbar .activity-tabs .view-all i{font-size:14pt;margin-left:4px}.custom-navbar .subscriptions-tabs .view-all i{font-size:12pt;margin-left:4px}.custom-navbar .activity-tabs .view-all:hover,.custom-navbar .subscriptions-tabs .view-all:hover{background-color:#8884}.custom-navbar .activity-tab{position:relative;cursor:pointer}.custom-navbar .activity-tab.selected{opacity:1;transform:scale(1.2)}.custom-navbar .activity-tab .tab-name{line-height:normal;opacity:.5}.custom-navbar .activity-tab.selected .tab-name{opacity:1;font-weight:700}.custom-navbar .activity-tab[data-count]::before{content:attr(data-count);position:absolute;top:0;left:50%;transform:translateX(-50%) translateY(-100%);font-size:10px;font-weight:400;line-height:1;background-color:#8884;padding:2px 4px;border-radius:10px;white-space:nowrap}.custom-navbar .activity-tab::after,.custom-navbar .subscriptions .tab::after{content:"";width:calc(80%);height:2px;border-radius:1px;position:absolute;background-color:var(--theme-color);left:10%;bottom:-4px;transform:scaleX(0);transition:.2s ease-out}.custom-navbar .activity-tab.selected::after,.custom-navbar .subscriptions .tab.selected::after{transform:scaleX(1)}.custom-navbar .activity-popup-content{overflow:auto;overscroll-behavior:contain;height:500px;position:relative;display:flex;flex-direction:column;align-items:center;justify-content:space-between;scrollbar-width:none!important}.custom-navbar .activity-popup-content::-webkit-scrollbar,.custom-navbar .subscriptions .content::-webkit-scrollbar{width:0!important}.custom-navbar .activity-popup-content .view-more{display:flex;align-items:center;flex-shrink:0;position:-webkit-sticky;position:sticky;bottom:0;left:0;justify-content:center;padding:6px 12px;background-color:#fffe;transform:translateY(-6px);box-shadow:rgba(0,0,0,.12) 0 4px 8px 0;cursor:pointer;height:28px;border-radius:14px;box-sizing:border-box;z-index:2}.custom-navbar .activity-popup-content .view-more:hover{background-color:#fff}.custom-navbar.dark .activity-popup-content .view-more:hover{background-color:#333}.custom-navbar .activity-popup-content .view-more .mdi{line-height:1;margin-left:8px;font-size:12pt}.custom-navbar .activity-popup-content .loading,.custom-navbar .bangumi-subscriptions .empty,.custom-navbar .bangumi-subscriptions .loading{height:100%;align-self:center;display:flex;align-items:center;justify-content:center}.custom-navbar .activity-popup-content .loading .mdi,.custom-navbar .bangumi-subscriptions .loading .mdi{line-height:1;margin-right:6px}.custom-navbar .video-activity{padding:0 12px;display:flex;justify-content:space-between;align-self:stretch}.custom-navbar .video-activity.center{height:100%;flex-direction:column;justify-content:center;align-items:center}.custom-navbar .video-activity-card{--card-width:172px;width:var(--card-width);display:flex;flex-direction:column;box-shadow:rgba(0,0,0,.12) 0 4px 8px 0;margin-bottom:12px;break-inside:avoid;flex-shrink:0}.custom-navbar.dark .activity-popup-content .view-more,.custom-navbar.dark .column-card,.custom-navbar.dark .video-activity-card{box-shadow:rgba(0,0,0,.3) 0 4px 8px 0;background-color:#2d2d2d}.custom-navbar .video-activity-card .cover{width:var(--card-width);background-color:#8884;height:calc(var(--card-width)/ 16 * 10);object-fit:cover;display:block;min-height:100px}.custom-navbar .video-activity-card .title{font-size:10pt;font-weight:700;margin:8px 8px 2px;color:inherit;overflow:hidden;text-overflow:ellipsis;display:-webkit-box;-webkit-line-clamp:2;-webkit-box-orient:vertical;line-height:1.5;max-height:3em;word-break:break-all}.custom-navbar .video-activity-card .title:hover,.custom-navbar .video-activity-card .up:hover .name{color:var(--theme-color)}.custom-navbar .video-activity-card .up{display:flex;justify-content:space-between;align-items:center;margin:6px 8px;border-radius:13px;padding:2px}.custom-navbar .video-activity-card .up:hover{background-color:#8882}.custom-navbar .video-activity-card .up .face{width:24px;border-radius:50%;background-color:#8884}.custom-navbar .video-activity-card .up .name{padding:0 8px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis}.custom-navbar .video-activity-card .cover-container{position:relative}.custom-navbar .video-activity-card .time,.custom-navbar .video-activity-card .watchlater{position:absolute;bottom:4px;display:flex;align-items:center;background-color:#000a;color:#fff;padding:0 8px;height:20px;border-radius:10px;box-sizing:border-box;opacity:0}.custom-navbar .video-activity-card:hover .time,.custom-navbar .video-activity-card:hover .watchlater{opacity:1}.custom-navbar .video-activity-card .time{left:4px}.custom-navbar .video-activity-card .watchlater{padding:0 8px 0 3px;right:4px;font-size:11px}.custom-navbar .video-activity-card .watchlater .mdi{line-height:1;margin-right:4px;font-size:16px}.custom-navbar .bangumi-activity{display:flex;flex-direction:column;padding-top:4px;width:100%}.custom-navbar .bangumi-activity.center{height:100%;justify-content:center;align-items:center}.custom-navbar .bangumi-card{--cover-width:100px;margin:0 12px 12px;box-shadow:rgba(0,0,0,.12) 0 2px 8px 0;display:grid;grid-template-areas:"cover epTitle" "cover title";grid-template-columns:var(--cover-width) 1fr;grid-template-rows:6fr 5fr;position:relative;flex-shrink:0}.custom-navbar.dark .bangumi-card,.custom-navbar.dark .live-card{box-shadow:rgba(0,0,0,.3) 0 2px 8px 0;background-color:#2d2d2d}.custom-navbar .bangumi-card .up{grid-area:title;display:flex;align-items:center;padding:0 12px;align-self:start;overflow:hidden}.custom-navbar .bangumi-card .up .cover{height:18px;border-radius:50%}.custom-navbar .bangumi-card .up .title{white-space:nowrap;overflow:hidden;text-overflow:ellipsis;margin:0 6px;line-height:normal}.custom-navbar .bangumi-card .ep-title{grid-area:epTitle;font-size:11pt;font-weight:700;padding:0 12px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;align-self:center;color:inherit;line-height:normal}.custom-navbar .bangumi-card:hover .ep-title{color:var(--theme-color)}.custom-navbar .bangumi-card .ep-cover{width:var(--cover-width);min-height:62.5px;background-color:#8884;grid-area:cover}.custom-navbar .column-activity{display:flex;flex-direction:column;align-items:stretch;padding:0 12px}.custom-navbar .column-activity.center{height:100%;align-items:center;justify-content:center}.custom-navbar .column-card{display:flex;flex-direction:column;margin-bottom:12px;box-shadow:rgba(0,0,0,.12) 0 4px 8px 0;position:relative;flex-shrink:0}.custom-navbar .column-card .up{position:absolute;left:8px;bottom:6px;padding:2px;display:flex;align-items:center;background-color:#000a;border-radius:14px;height:28px;box-sizing:border-box}.custom-navbar .column-card .face{border-radius:50%;height:24px}.custom-navbar .column-card .up .name{margin:0 6px;color:#fff}.custom-navbar .column-card .title{padding:10px 10px 0;font-size:11pt;font-weight:700;color:inherit;line-height:normal}.custom-navbar .column-card:hover .title{color:var(--theme-color)}.custom-navbar .column-card .description{margin:8px 10px;max-height:3em;overflow:hidden;text-overflow:ellipsis;word-break:break-all;line-height:1.5;-webkit-line-clamp:2;-webkit-box-orient:vertical;display:-webkit-box}.custom-navbar .column-card .covers{position:relative;display:flex}.custom-navbar .column-card .cover{width:0;flex-grow:1;object-fit:cover}.custom-navbar .live-activity{display:flex;flex-direction:column;align-items:stretch;width:100%;padding-top:4px}.custom-navbar .live-activity.center{height:100%;align-items:center;justify-content:center}.custom-navbar .live-card{margin:0 12px 12px;box-shadow:rgba(0,0,0,.12) 0 2px 8px 0;display:grid;grid-template-areas:"face title" "face name";grid-template-columns:48px 1fr;grid-template-rows:6fr 5fr;height:52px;border-radius:26px;box-sizing:border-box;padding:2px;width:auto;flex-shrink:0}.custom-navbar .live-card .face{grid-area:face;border-radius:50%;height:48px}.custom-navbar .live-card .live-title{grid-area:title;font-size:11pt;font-weight:700;align-self:center;padding:0 12px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;color:inherit;line-height:normal}.custom-navbar .live-card:hover .live-title{color:var(--theme-color)}.custom-navbar .live-card .name{grid-area:name;align-self:start;padding:0 12px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;line-height:normal}.custom-navbar .activity-content-enter-active,.custom-navbar .activity-content-leave-active,.custom-navbar .subscriptions-content-enter-active,.custom-navbar .subscriptions-content-leave-active{transition:.2s ease-out}.custom-navbar .activity-content-enter,.custom-navbar .activity-content-leave-to,.custom-navbar .subscriptions-content-enter,.custom-navbar .subscriptions-content-leave-to{opacity:0;transform:translateY(12px)}.custom-navbar .bangumi-card.new::before,.custom-navbar .column-card.new::before,.custom-navbar .video-activity-card.new .cover-container::before{content:"NEW";position:absolute;top:4px;left:4px;background-color:var(--theme-color);color:var(--foreground-color);padding:0 6px;height:18px;border-radius:9px;font-weight:700;font-size:11px;line-height:18px;z-index:1}.custom-navbar .column-card.new::before{left:unset;right:8px;top:8px;height:20px;border-radius:10px;line-height:20px;font-size:12px;padding:0 8px}.custom-navbar .subscriptions{width:380px;font-size:9pt}.custom-navbar .subscriptions .tab-placeholder{flex-grow:1}.custom-navbar .subscriptions .tab{opacity:.5;margin-right:24px;position:relative;line-height:1.4;cursor:pointer}.custom-navbar .subscriptions .tab.selected{opacity:1;font-weight:700;transform:scale(1.2)}.custom-navbar .subscriptions .content{padding:8px 12px;height:500px;overflow:auto;overscroll-behavior:contain;scrollbar-width:none!important}.custom-navbar .subscriptions-tabs{margin:12px 12px 8px 18px;display:flex;align-items:center}.custom-navbar .bangumi-subscriptions{display:flex;flex-direction:column}.custom-navbar .bangumi-subscriptions.center{height:100%}.custom-navbar .bangumi-subscriptions-card{position:relative;display:flex;margin-bottom:12px;flex-shrink:0}body.dark .custom-navbar .bangumi-subscriptions-card{background-color:#2d2d2d}.custom-navbar .bangumi-subscriptions-card .cover{height:64px;width:64px}.custom-navbar .bangumi-subscriptions-card .card-info{flex-grow:1;display:flex;flex-direction:column;align-items:flex-start;padding:0 12px;max-width:calc(100% - 24px - 64px);box-sizing:content-box}.custom-navbar .bangumi-subscriptions-card .info{padding:2px;background-color:#8882;font-size:12pt;border-radius:14px;line-height:1}.custom-navbar .bangumi-subscriptions-card .info:hover{background-color:#8884}.custom-navbar .bangumi-subscriptions-card .progress-row{flex-grow:1;display:flex;justify-content:space-between;align-self:stretch;align-items:center}.custom-navbar .bangumi-subscriptions-card .progress{white-space:nowrap;width:80%;overflow:hidden;text-overflow:ellipsis}.custom-navbar .bangumi-subscriptions-card .title{font-size:11pt;font-weight:700;padding-top:8px;color:inherit;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;width:100%;margin:0}.custom-navbar .bangumi-subscriptions-card:hover .title{color:var(--theme-color)}.round-corner .custom-navbar .popup,.round-corner .custom-navbar .popup iframe{border-radius:var(--large-corner-radius)}.round-corner #custom-navbar-home-popup .category-item,.round-corner #custom-navbar-home-popup .category-item .popup{border-radius:var(--corner-radius)}.round-corner .custom-navbar .video-list li.more,.round-corner .user-info-panel .login,.round-corner .user-info-panel .logout{border-radius:0 0 var(--corner-radius) var(--corner-radius)}.round-corner .custom-navbar-settings{border-radius:var(--large-corner-radius)}.round-corner .custom-navbar .search-list-item{border-radius:var(--corner-radius)}.round-corner .custom-navbar .bangumi-subscriptions-card{border-radius:var(--large-corner-radius);box-shadow:rgba(0,0,0,.12) 0 2px 8px 0}.round-corner .custom-navbar .bangumi-subscriptions-card .cover{border-radius:var(--large-corner-radius) 0 0 var(--large-corner-radius)}.round-corner .custom-navbar .column-card .cover:first-child{border-top-left-radius:var(--large-corner-radius)}.round-corner .custom-navbar .column-card .cover:nth-last-child(2){border-top-right-radius:var(--large-corner-radius)}.round-corner .custom-navbar .bangumi-card,.round-corner .custom-navbar .column-card,.round-corner .custom-navbar .video-activity-card{border-radius:var(--large-corner-radius)}.round-corner .custom-navbar .video-activity-card .cover{border-radius:var(--large-corner-radius) var(--large-corner-radius) 0 0}.round-corner .custom-navbar .bangumi-activity .ep-cover{border-radius:var(--large-corner-radius) 0 0 var(--large-corner-radius)}.custom-navbar-settings{display:flex;flex-direction:column;pointer-events:none;opacity:0;width:370px;position:fixed;top:50%;left:50%;transform:translate(-50%,-46%) scale(.95);z-index:10001;background:var(--navbar-background);padding-top:16px;box-shadow:#0002 0 1px 10px 1px;font-size:16px;line-height:1.5}.custom-navbar-settings.dark{--navbar-background:#222;--navbar-foreground:#eee;box-shadow:#0004 0 2px 10px 1px}.custom-navbar-settings h1{color:var(--navbar-foreground);font-size:16pt;font-weight:700}.custom-navbar-settings.show{pointer-events:initial;transform:translate(-50%,-46%) scale(1);opacity:1}.custom-navbar-settings .header,.custom-navbar-settings .orders{display:flex;justify-content:space-between;align-items:center}.custom-navbar-settings .header{padding:0 24px;font-size:9pt}.custom-navbar-settings .header .header-blank,.custom-navbar-settings .orders{flex-grow:1}.custom-navbar-settings .order-list{padding:0 24px;max-height:60vh;overflow:auto;overscroll-behavior:contain;list-style:none;width:100%;margin:16px 0}.custom-navbar-settings button{border:none;background-color:transparent;color:var(--navbar-foreground);padding:8px;cursor:pointer;font-size:14pt}.custom-navbar-settings button:hover{color:var(--theme-color)}.custom-navbar-settings .order-list li .mdi-menu{padding:8px}.custom-navbar-settings .order-list i{font-size:14pt}.custom-navbar-settings .order-list i.mdi-menu{cursor:move}.custom-navbar-settings .order-list li{color:var(--navbar-foreground);font-size:12pt;display:flex!important;justify-content:space-between;align-items:center;user-select:none;transition:opacity .2s ease-out}.custom-navbar-settings .order-list li.hidden{opacity:.5}.custom-navbar-settings .paddings{display:flex;align-items:center;justify-content:space-between;padding:16px 32px;color:var(--navbar-foreground)}.custom-navbar-settings .paddings span{min-width:40px}.custom-navbar-settings .paddings input{flex-grow:1;margin-right:16px;-webkit-appearance:none;background:0 0;width:100%}.custom-navbar-settings .paddings input::-webkit-slider-thumb{-webkit-appearance:none;height:18px;width:18px;background:var(--theme-color);border-radius:50%;box-shadow:0 2px 8px 0 var(--theme-color-50);cursor:pointer;border:none;transform:translateY(-7px)}.custom-navbar-settings .paddings input::-moz-range-thumb{-webkit-appearance:none;height:18px;width:18px;background:var(--theme-color);border-radius:50%;box-shadow:0 2px 8px 0 var(--theme-color-50);cursor:pointer;border:none}.custom-navbar-settings .paddings input::-webkit-slider-runnable-track{width:100%;background:#8884;height:4px}.custom-navbar-settings .paddings input::-moz-range-track{width:100%;background:#8884;height:4px}#custom-navbar-home-popup{max-height:80vh;display:flex;flex-direction:column;flex-wrap:wrap;width:350px}#custom-navbar-home-popup .category-item{font-size:12pt;padding:8px 16px;cursor:pointer;position:relative}#custom-navbar-home-popup .category-item.loading{font-size:10pt;cursor:initial;display:flex;align-items:center;justify-content:center}#custom-navbar-home-popup .category-item:not(.loading):hover{background-color:#0001}#custom-navbar-home-popup .category-item a{display:flex;justify-content:space-between;align-items:center}#custom-navbar-home-popup .category-item svg{width:25px;height:25px;fill:currentColor;margin-right:10px}#custom-navbar-home-popup .category-item div{flex:1 0 auto}#custom-navbar-home-popup .category-item.main{min-width:150px}#custom-navbar-home-popup .category-item .popup{z-index:10002;width:max-content;transform:scaleX(0);transform-origin:left;padding:8px;left:100%;top:0;transition-delay:.3s;pointer-events:initial}#custom-navbar-home-popup .category-item span{opacity:.5}@media screen and (min-height:1000px){#custom-navbar-home-popup{flex-wrap:nowrap;width:250px}}.custom-navbar .popup .watchlater-list{min-height:200px;max-height:600px;width:380px;font-size:12px;display:flex;flex-flow:column nowrap;justify-content:space-between}.custom-navbar .popup .watchlater-list .empty-tip,.custom-navbar .popup .watchlater-list .loading-tip{opacity:0;pointer-events:none;position:absolute;top:50%;left:50%;transform:translateX(-50%) translateY(-50%);display:flex;align-items:center}.custom-navbar .popup .watchlater-list .empty-tip .mdi,.custom-navbar .popup .watchlater-list .loading-tip .mdi{margin-right:6px}.custom-navbar .popup .watchlater-list .empty-tip,.custom-navbar .popup .watchlater-list.loading .loading-tip{opacity:1}.custom-navbar .popup .watchlater-list.loading>:not(.loading-tip){opacity:0}.custom-navbar .popup .watchlater-list .mdi{line-height:1;font-size:18px}.custom-navbar .popup .watchlater-list .round-button{box-sizing:border-box;height:28px;border-radius:14px;display:flex;align-items:center;background-color:#8882;justify-content:center;cursor:pointer;width:28px}.custom-navbar .popup .watchlater-list .round-button:hover{background-color:#8884}.custom-navbar .popup .watchlater-list .floating{box-sizing:border-box;height:20px;border-radius:10px;display:flex;align-items:center;background-color:#000C;color:#fff;justify-content:center;cursor:pointer}.custom-navbar .popup .watchlater-list .header{display:flex;align-items:center;justify-content:space-between;margin:16px 12px}.custom-navbar .popup .watchlater-list .header .search{position:relative;flex-grow:1;margin-right:16px}.custom-navbar .popup .watchlater-list .header .search input{width:100%;padding:4px;border:none;outline:0!important;color:inherit;background-color:transparent;border-radius:4px}.custom-navbar .popup .watchlater-list .header .search::after{content:"";position:absolute;top:calc(100%);left:0;width:100%;height:2px;border-radius:2px;transition:.24s ease-out;background-color:#8882}.custom-navbar .popup .watchlater-list .header .search.not-empty::after,.custom-navbar .popup .watchlater-list .header .search:focus-within::after{background-color:var(--theme-color)}.custom-navbar .popup .watchlater-list .header .operations{display:flex;align-items:center}.custom-navbar .popup .watchlater-list .header .operations .round-button:not(:last-child){margin-right:4px}.custom-navbar .popup .watchlater-list .header .more-info{display:flex;align-items:center;box-sizing:border-box;height:28px;border-radius:14px;padding:4px 6px 4px 10px;background-color:#8882}.custom-navbar .popup .watchlater-list .header .more-info:hover{background-color:#8884}.custom-navbar .popup .watchlater-list .header .more-info .mdi{margin-left:8px}.custom-navbar .popup .watchlater-list .cards{flex:1;overflow:auto;overscroll-behavior:contain;scroll-behavior:smooth;position:relative;scrollbar-width:none!important;padding:0 12px 12px}.custom-navbar .popup .watchlater-list .cards::-webkit-scrollbar{height:0!important;width:0!important}.custom-navbar .popup .watchlater-list .cards-enter,.custom-navbar .popup .watchlater-list .cards-leave-to{opacity:0;transform:translateY(-16px) scale(.9)}.custom-navbar .popup .watchlater-list .cards-leave-active{transition:.24s cubic-bezier(.22,.61,.36,1);position:absolute}.custom-navbar .popup .watchlater-list .cards .watchlater-card{cursor:pointer;flex-shrink:0;border-radius:8px;box-shadow:0 4px 8px 0 #0001;color:#000;background-color:#fff;display:grid;grid-template:"cover title" 2fr "cover info" 1fr/130px 1fr;height:85px}body.dark .custom-navbar .popup .watchlater-list .cards .watchlater-card{background-color:#282828;color:#eee}.custom-navbar .popup .watchlater-list .cards .watchlater-card:not(:last-child){margin-bottom:12px}.custom-navbar .popup .watchlater-list .cards .watchlater-card:hover .cover{transform:scale(1.05)}.custom-navbar .popup .watchlater-list .cards .watchlater-card .cover-container{grid-area:cover;overflow:hidden;border-radius:8px 0 0 8px;position:relative}.custom-navbar .popup .watchlater-list .cards .watchlater-card .cover-container .remove{top:6px;left:6px;width:20px}.custom-navbar .popup .watchlater-list .cards .watchlater-card .cover-container .remove .mdi{font-size:16px}.custom-navbar .popup .watchlater-list .cards .watchlater-card .cover-container .duration{left:6px;bottom:6px;padding:0 6px}.custom-navbar .popup .watchlater-list .cards .watchlater-card .cover-container .viewed{white-space:nowrap;right:6px;top:6px;padding:0 6px}.custom-navbar .popup .watchlater-list .cards .watchlater-card .cover-container .floating{position:absolute;opacity:0;font-size:11px}.custom-navbar .popup .watchlater-list .cards .watchlater-card .cover-container .cover{object-fit:cover}.custom-navbar .popup .watchlater-list .cards .watchlater-card:hover .floating{opacity:1}.custom-navbar .popup .watchlater-list .cards .watchlater-card .title{grid-area:title;font-size:13px;font-weight:700;display:-webkit-box;-webkit-line-clamp:2;-webkit-box-orient:vertical;max-height:3em;word-break:break-all;line-height:1.5;overflow:hidden;margin-top:8px;padding:0 10px}.custom-navbar .popup .watchlater-list .cards .watchlater-card .title:hover{color:var(--theme-color)!important}.custom-navbar .popup .watchlater-list .cards .watchlater-card .up{flex:0 1 auto;padding:2px 10px 2px 2px;margin:0 8px 6px;justify-self:start;align-self:center;max-width:calc(100% - 16px);display:flex;align-items:center;background-color:#8882;box-sizing:border-box;height:24px;border-radius:12px}.custom-navbar .popup .watchlater-list .cards .watchlater-card .up:hover{background-color:#8884}.custom-navbar .popup .watchlater-list .cards .watchlater-card .up .face{border-radius:50%;margin-right:6px;height:20px;width:20px}.custom-navbar .popup .watchlater-list .cards .watchlater-card .up .name{overflow:hidden;white-space:nowrap;text-overflow:ellipsis;font-size:11px}.custom-navbar .popup .watchlater-list .cards .watchlater-card .up:hover .name{color:var(--theme-color)}.custom-navbar .popup .watchlater-list .undo{position:absolute;bottom:16px;left:50%;opacity:0;transform:translateX(-50%) translateY(8px)}.custom-navbar .popup .watchlater-list .undo.show{opacity:1;transform:translateX(-50%) translateY(0)}.custom-navbar .favorites-list{width:380px;height:600px;font-size:12px;display:flex;align-items:stretch;flex-direction:column;justify-content:center}.custom-navbar .favorites-list .dropdown-menu{max-height:500px;overflow:auto}.custom-navbar .favorites-list .empty-tip,.custom-navbar .favorites-list .loading-tip{display:flex;justify-content:center;width:100%}.custom-navbar .favorites-list>.loading-tip{display:none}.custom-navbar .favorites-list .mdi{line-height:1;font-size:18px}.custom-navbar .favorites-list.loading>.loading-tip{display:flex}.custom-navbar .favorites-list.loading>:not(.loading-tip){display:none}.custom-navbar .favorites-list .content{display:flex;align-items:stretch;flex-direction:column;scrollbar-width:none!important;justify-content:space-between;flex-grow:1;overflow:auto}.custom-navbar .favorites-list .content::-webkit-scrollbar{height:0!important;width:0!important}.custom-navbar .favorites-list .content .floating{box-sizing:border-box;height:20px;border-radius:10px;display:flex;align-items:center;background-color:#000c;color:#fff;justify-content:center;cursor:pointer}.custom-navbar .favorites-list .content .header{display:flex;align-items:center;justify-content:space-between;margin:16px 12px}.custom-navbar .favorites-list .content .header .list-select{height:26px}.custom-navbar .favorites-list .content .header .more-info{display:flex;align-items:center;box-sizing:border-box;height:26px;border-radius:13px;padding:4px 6px 4px 10px;background-color:#8882}.custom-navbar .favorites-list .content .header .more-info:hover{background-color:#8884}.custom-navbar .favorites-list .content .header .more-info .mdi{margin-left:8px}.custom-navbar .favorites-list .content .header .play-all-container{flex-grow:1;padding:0 6px;display:flex;align-items:center;justify-content:flex-start}.custom-navbar .favorites-list .content .header .play-all-container .play-all{display:flex;align-items:center;box-sizing:border-box;height:26px;border-radius:13px;padding:4px;background-color:#8882}.custom-navbar .favorites-list .content .header .play-all-container .play-all:hover{background-color:#8884}.custom-navbar .favorites-list .content .cards{flex:1;overflow:auto;overscroll-behavior:contain;scroll-behavior:smooth;position:relative;scrollbar-width:none!important;padding:0 12px 12px}.custom-navbar .favorites-list .content .cards::-webkit-scrollbar{height:0!important;width:0!important}.custom-navbar .favorites-list .content .cards-enter,.custom-navbar .favorites-list .content .cards-leave-to{opacity:0;transform:translateY(-16px) scale(.9)}.custom-navbar .favorites-list .content .cards-leave-active{transition:.24s cubic-bezier(.22,.61,.36,1);position:absolute}.custom-navbar .favorites-list .content .cards .favorite-card{cursor:pointer;flex-shrink:0;border-radius:8px;box-shadow:0 4px 8px 0 #0001;color:#000;background-color:#fff;display:grid;grid-template:"cover title" 2fr "cover info" 1fr/130px 1fr;height:85px}body.dark .custom-navbar .favorites-list .content .cards .favorite-card{background-color:#282828;color:#eee}.custom-navbar .favorites-list .content .cards .favorite-card:not(:last-child){margin-bottom:12px}.custom-navbar .favorites-list .content .cards .favorite-card:hover .cover{transform:scale(1.05)}.custom-navbar .favorites-list .content .cards .favorite-card .cover-container{grid-area:cover;overflow:hidden;border-radius:8px 0 0 8px;position:relative}.custom-navbar .favorites-list .content .cards .favorite-card .cover-container .favorite-time{top:6px;left:6px;padding:0 6px}.custom-navbar .favorites-list .content .cards .favorite-card .cover-container .duration{left:6px;bottom:6px;padding:0 6px}.custom-navbar .favorites-list .content .cards .favorite-card .cover-container .floating{position:absolute;opacity:0;font-size:11px}.custom-navbar .favorites-list .content .cards .favorite-card .cover-container .cover{object-fit:cover}.custom-navbar .favorites-list .content .cards .favorite-card:hover .floating{opacity:1}.custom-navbar .favorites-list .content .cards .favorite-card .title{grid-area:title;font-size:13px;font-weight:700;display:-webkit-box;-webkit-line-clamp:2;-webkit-box-orient:vertical;max-height:3em;word-break:break-all;line-height:1.5;overflow:hidden;margin-top:8px;padding:0 10px}.custom-navbar .favorites-list .content .cards .favorite-card .title:hover{color:var(--theme-color)!important}.custom-navbar .favorites-list .content .cards .favorite-card .up{flex:0 1 auto;padding:2px 10px 2px 2px;margin:0 8px 6px;justify-self:start;align-self:center;max-width:calc(100% - 16px);display:flex;align-items:center;box-sizing:border-box;height:24px;border-radius:12px;background-color:#8882}.custom-navbar .favorites-list .content .cards .favorite-card .up:hover{background-color:#8884}.custom-navbar .favorites-list .content .cards .favorite-card .up .face{border-radius:50%;margin-right:6px;height:20px;width:20px}.custom-navbar .favorites-list .content .cards .favorite-card .up .name{overflow:hidden;white-space:nowrap;text-overflow:ellipsis;font-size:11px}.custom-navbar .favorites-list .content .cards .favorite-card .up:hover .name{color:var(--theme-color)}.custom-navbar .history-list{width:350px;height:600px;font-size:12px;display:flex;align-items:stretch;flex-direction:column;justify-content:center}.custom-navbar .history-list .loading-tip{display:flex;justify-content:center;width:100%}.custom-navbar .history-list>.loading-tip{display:none}.custom-navbar .history-list .mdi{line-height:1;font-size:18px}.custom-navbar .history-list.loading>.loading-tip{display:flex}.custom-navbar .history-list.loading>:not(.loading-tip){display:none}.custom-navbar .history-list .content{display:flex;align-items:stretch;flex-direction:column;scrollbar-width:none!important;justify-content:space-between;flex-grow:1;overflow:auto}.custom-navbar .history-list .content::-webkit-scrollbar{height:0!important;width:0!important}.custom-navbar .history-list .content .header{display:flex;align-items:center;justify-content:space-between;margin:16px 12px}.custom-navbar .history-list .content .header .tabs{flex-grow:1;margin-right:48px;padding:0 6px;display:flex;align-items:center;justify-content:flex-start}.custom-navbar .history-list .content .header .tabs .tab{cursor:pointer;position:relative;white-space:nowrap}.custom-navbar .history-list .content .header .tabs .tab:not(:last-child){margin-right:24px}.custom-navbar .history-list .content .header .tabs .tab::after{content:"";width:calc(80%);height:2px;border-radius:1px;position:absolute;background-color:var(--theme-color);left:10%;bottom:-4px;transform:scaleX(0);transition:.2s ease-out}.custom-navbar .history-list .content .header .tabs .tab.active::after{transform:scaleX(1)}.custom-navbar .history-list .content .header .tabs .tab .tab-name{opacity:.5;line-height:normal}.custom-navbar .history-list .content .header .tabs .tab.active{transform:scale(1.2)}.custom-navbar .history-list .content .header .tabs .tab.active .tab-name{font-weight:700;opacity:1}.custom-navbar .history-list .content .header .more-info{display:flex;align-items:center;box-sizing:border-box;height:26px;border-radius:13px;padding:4px 6px 4px 10px;background-color:#8882;border:none;cursor:pointer;color:inherit;font-size:inherit}.custom-navbar .history-list .content .header .more-info:disabled{opacity:.3;cursor:not-allowed}.custom-navbar .history-list .content .header .more-info:hover:not(:disabled){background-color:#8884}.custom-navbar .history-list .content .header .more-info .mdi{margin-left:8px}.custom-navbar .history-list .content .history-content{flex:1;overflow:auto;overscroll-behavior:contain;scroll-behavior:smooth;position:relative;scrollbar-width:none!important;padding:0 12px 12px}.custom-navbar .history-list .content .history-content-enter,.custom-navbar .history-list .content .history-content-leave-to{opacity:0;transform:translateY(-16px) scale(.9)}.custom-navbar .history-list .content .history-content-leave-active{transition:.24s cubic-bezier(.22,.61,.36,1);position:absolute}.custom-navbar .history-list .content .history-content::-webkit-scrollbar{height:0!important;width:0!important}.custom-navbar .history-list .content .history-content .time-group{padding-bottom:16px}.custom-navbar .history-list .content .history-content .time-group-enter,.custom-navbar .history-list .content .history-content .time-group-leave-to{opacity:0;transform:translateY(-16px) scale(.9)}.custom-navbar .history-list .content .history-content .time-group-leave-active{transition:.24s cubic-bezier(.22,.61,.36,1);position:absolute}.custom-navbar .history-list .content .history-content .time-group-name{padding-bottom:4px;margin-bottom:4px}.custom-navbar .history-list .content .history-content .time-group-items .floating{box-sizing:border-box;height:20px;border-radius:10px;display:flex;align-items:center;background-color:#000c;color:#fff;justify-content:center;position:absolute;opacity:0;font-size:11px}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item{display:grid;grid-template:"cover title title" 3fr "cover up time" 2fr/80px 1fr auto;border-radius:4px 8px 8px 4px;color:#000;background-color:#fff;box-shadow:0 4px 8px 0 #0001}body.dark .custom-navbar .history-list .content .history-content .time-group-items .time-group-item{background-color:#282828;color:#eee}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item:not(:last-child){margin-bottom:8px}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item:hover .cover{transform:scale(1.05)}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item:hover .floating{opacity:1}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .cover-container{grid-area:cover;position:relative;height:55px;overflow:hidden;border-radius:4px 0 0 4px}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .cover-container .cover{object-fit:cover;width:80px;height:55px}body.dark .custom-navbar .history-list .content .history-content .time-group-items .time-group-item .cover-container .cover.placeholder{filter:invert(.9)}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .cover-container .duration{left:2px;bottom:2px;padding:0 6px}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .cover-container .progress-number{left:2px;top:2px;padding:0 6px}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .cover-container .progress{position:absolute;bottom:0;left:0;height:2px;border-radius:1px;background-color:var(--theme-color)}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .title{grid-area:title;font-weight:700;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;align-self:center;padding-left:8px;padding-right:6px;font-size:13px}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .title:hover{color:var(--theme-color)!important}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .time,.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .up{font-size:11px;opacity:.75;align-self:start}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .up{grid-area:up;display:flex;align-items:center;padding-left:8px}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .up:hover{opacity:1}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .up .be-icon{margin-right:4px;font-size:14px}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .up-name{white-space:nowrap;max-width:160px;overflow:hidden;text-overflow:ellipsis}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .time{font-size:11px;grid-area:time;padding-right:6px}.custom-navbar>ul>li:not(.disabled) .popup-container{position:absolute;top:100%;left:50%}#custom-navbar-home-popup .category-item:hover .popup,#custom-navbar-search:focus-within~.search-list:not(.empty),.custom-navbar .search-list:not(.empty):focus-within,.custom-navbar>ul>li:not(.disabled):hover .popup-container>.popup{transform:translateY(0) translateX(-50%);pointer-events:initial;opacity:1}.custom-navbar>ul>li:not(.disabled).right-side:hover .popup-container>.popup{transform:translateY(0) translateX(-90%);left:100%}.custom-navbar>ul>li:not(.disabled).left-side:hover .popup-container>.popup{transform:translateY(0) translateX(10%);left:0}#custom-navbar-home-popup .category-item:hover .popup{transform:scaleX(1)}.custom-navbar.compact #custom-navbar-home-popup .category-item{padding:6px}.custom-navbar.compact #custom-navbar-home-popup .category-item.main{min-width:110px}#custom-navbar-home-popup .category-item .popup a,#message-list a,#upload-actions a{position:relative;padding:8px;display:flex;justify-content:start;border-bottom:2px solid transparent;font-size:11pt;line-height:16pt}#custom-navbar-home-popup .category-item .popup a::before,#message-list a::before,#upload-actions a::before{content:"";position:absolute;top:calc(100% - 4px);left:8px;width:calc(100% - 16px);height:2px;border-radius:2px;background-color:var(--theme-color);transition:.16s ease-out .1s;transform:scaleX(0)}.custom-navbar.compact #custom-navbar-home-popup .category-item .popup a{padding:6px}#custom-navbar-home-popup .category-item .popup a:hover::before,#message-list a:hover::before,#upload-actions a:hover::before{transform:scaleX(1)}.im-list-box{border-radius:0!important}#upload-button{padding-left:4px;font-size:12pt;font-weight:700}#message-list,#upload-actions{width:max-content}#message-list a[data-count]::after{content:attr(data-count);position:absolute;left:100%;top:50%;transform:translateY(-50%);background-color:var(--theme-color);color:var(--foreground-color);padding:0 6px;display:flex;justify-content:center;font-size:9pt;border-radius:6px}@media screen and (max-width:1300px){.custom-navbar form input{width:200px}}`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar.min.html"] = `<svg aria-hidden=true style="position: absolute; width: 0px; height: 0px; overflow: hidden;"><symbol id=header-icon-music viewBox="0 0 1024 1024"><path d="M881.92 460.8A335.36 335.36 0 0 0 547.584 125.696h-73.216A335.616 335.616 0 0 0 139.776 460.8v313.6a18.688 18.688 0 0 0 18.432 18.688h41.984c13.568 46.336 37.888 80.384 88.576 80.384h98.304a37.376 37.376 0 0 0 37.376-36.864l1.28-284.672a36.864 36.864 0 0 0-37.12-37.12h-99.84a111.616 111.616 0 0 0-51.2 12.8v-73.216a242.432 242.432 0 0 1 241.664-241.664h67.328a242.176 242.176 0 0 1 241.408 241.664v74.496a110.592 110.592 0 0 0-54.272-14.08h-99.84a36.864 36.864 0 0 0-37.12 37.12v284.672a37.376 37.376 0 0 0 37.376 36.864h98.304c51.2 0 75.008-34.048 88.576-80.384h41.984a18.688 18.688 0 0 0 18.432-18.688z"fill=#45C7DD></path><path d="M646.141043 825.220963m0.045396-32.511969l0.273801-196.095809q0.045395-32.511968 32.557364-32.466573l1.023999 0.00143q32.511968 0.045395 32.466573 32.557364l-0.273802 196.095809q-0.045395 32.511968-32.557363 32.466573l-1.023999-0.00143q-32.511968-0.045395-32.466573-32.557364Z"fill=#FF5C7A></path><path d="M307.222608 825.246563m0.045395-32.511969l0.273801-196.095809q0.045395-32.511968 32.557364-32.466573l1.023999 0.00143q32.511968 0.045395 32.466573 32.557364l-0.273801 196.095809q-0.045395 32.511968-32.557364 32.466573l-1.023999-0.00143q-32.511968-0.045395-32.466573-32.557364Z"fill=#FF5C7A></path></symbol><symbol id=header-icon-game viewBox="0 0 1024 1024"><path d="M166.4 166.144m90.112 0l510.976 0q90.112 0 90.112 90.112l0 510.976q0 90.112-90.112 90.112l-510.976 0q-90.112 0-90.112-90.112l0-510.976q0-90.112 90.112-90.112Z"fill=#58D598></path><path d="M307.2 325.632h136.448v136.448H307.2zM580.096 325.632h136.448v136.448h-136.448z"fill=#17AD8A></path><path d="M443.648 462.336v75.776h-64.256v204.544h59.392v-68.096H585.216v68.096h59.136v-204.544h-64.256v-75.776h-136.448z"fill=#17AD8A></path></symbol><symbol id=header-icon-dance viewBox="0 0 1024 1024"><path d="M956.672 513.792a476.416 476.416 0 0 0-890.368 0L512 727.296l-95.232 45.568a117.76 117.76 0 0 0 192.256 0L512 727.04z"fill=#FC6B8A></path><path d="M512 727.296l208.64-99.84a222.976 222.976 0 0 0-416.768 0z"fill=#FFFFFF></path><path d="M405.4528 751.5392l541.184-258.5856 14.0288 29.312-541.184 258.6112z"fill=#FF5C7A></path><path d="M666.624 545.792l-18.688-15.36-112.64 135.424 40.192-173.056-23.552-5.632-40.192 172.544-40.448-172.544-23.808 5.632 40.704 173.056-112.896-135.424-18.688 15.36 111.616 134.144-391.68-186.88-13.824 29.184 541.184 258.56 14.08-29.44-87.552-41.728 136.192-163.84z"fill=#F14767></path></symbol><symbol id=header-icon-zhibo viewBox="0 0 1024 1024"><path d="M392.448 332.8a92.416 92.416 0 1 1-92.416-92.416A92.416 92.416 0 0 1 392.448 332.8"fill=#23ADE5></path><path d="M572.928 426.24A143.872 143.872 0 1 0 429.312 281.6a143.872 143.872 0 0 0 143.616 144.64zM826.624 521.472l-63.744 36.864v-48.64A72.192 72.192 0 0 0 691.2 437.76H190.72a72.192 72.192 0 0 0-71.936 71.936v295.424a71.936 71.936 0 0 0 71.936 71.936H691.2a71.936 71.936 0 0 0 71.936-71.936v-23.808L826.624 819.2a51.2 51.2 0 0 0 76.8-44.544V565.76a51.2 51.2 0 0 0-76.8-44.288z"fill=#48CFE5></path><path d="M425.216 569.856l124.16 71.936a25.6 25.6 0 0 1 0 42.496l-124.16 71.68a25.6 25.6 0 0 1-37.12-21.248v-143.36a25.6 25.6 0 0 1 37.12-21.504"fill=#FDDE80></path></symbol><symbol id=header-icon-ent viewBox="0 0 1024 1024"><path d="M534.442796 378.982175m36.203867 36.203867l30.592268 30.592268q36.203867 36.203867 0 72.407734l-360.590518 360.590518q-36.203867 36.203867-72.407734 0l-30.592268-30.592268q-36.203867-36.203867 0-72.407735l360.590518-360.590517q36.203867-36.203867 72.407734 0Z"fill=#FF8693></path><path d="M369.92 543.744l137.472-137.472a38.912 38.912 0 0 1 54.528 0l48.384 48.64a38.4 38.4 0 0 1 0 54.528l-137.984 137.984z"fill=#FC6376></path><path d="M286.133941 631.021801m12.854616 12.85013l72.601422 72.576083q12.854616 12.850129 0.004486 25.704746l-1.62889 1.629458q-12.850129 12.854616-25.704745 0.004486l-72.601422-72.576083q-12.854616-12.850129-0.004486-25.704745l1.62889-1.629459q12.850129-12.854616 25.704745-0.004486Z"fill=#FFA9B1></path><path d="M737.024 547.584a99.328 99.328 0 0 1 62.72-62.72l51.2-13.568a27.136 27.136 0 0 0 13.056-49.664L826.624 384a98.816 98.816 0 0 1-22.784-85.76l16.896-63.232c7.168-27.136-8.96-43.52-36.096-36.096l-63.232 16.896a98.816 98.816 0 0 1-85.76-23.04l-37.376-36.864a27.136 27.136 0 0 0-49.408 13.312l-13.824 51.2a97.792 97.792 0 0 1-62.464 62.72l-51.2 13.824a27.136 27.136 0 0 0-13.312 49.408L445.44 384a97.536 97.536 0 0 1 23.04 85.504l-16.896 63.232c-7.424 27.392 8.96 43.52 36.096 36.352l63.232-16.896a97.792 97.792 0 0 1 85.76 22.784l37.376 37.376a26.88 26.88 0 0 0 49.408-13.312z"fill=#FDDE80></path><path d="M886.272 417.536l-74.752-75.008 30.464-114.432a41.216 41.216 0 0 0-8.704-41.472A41.728 41.728 0 0 0 791.808 179.2l-114.432 30.72-74.752-76.032A41.728 41.728 0 0 0 563.2 120.576a41.216 41.216 0 0 0-28.416 31.488l-27.392 102.4L404.48 281.6a42.24 42.24 0 0 0-31.744 28.16 42.24 42.24 0 0 0 13.312 40.448L460.8 425.216l-30.72 114.432a41.728 41.728 0 0 0 8.96 41.472 37.888 37.888 0 0 0 27.392 10.752 56.832 56.832 0 0 0 14.08-2.048l114.432-30.72 74.752 75.008a45.824 45.824 0 0 0 31.232 14.336 34.304 34.304 0 0 0 8.96 0 41.216 41.216 0 0 0 28.416-31.488l27.392-102.4 102.4-27.392a41.984 41.984 0 0 0 31.488-28.416 40.96 40.96 0 0 0-13.312-41.216z m-84.736-203.52h5.12a16.896 16.896 0 0 1 0 5.12l-25.6 93.696-72.96-73.728z m-32 139.776l-34.56 128-128 34.56-102.4-102.4 34.56-128 128-34.56z m-199.424-192c0-2.56 1.792-4.096 1.792-4.608a9.984 9.984 0 0 1 4.096 3.072l59.648 59.648-87.296 23.296z m-157.696 162.048L409.6 320a12.8 12.8 0 0 1 4.864-2.048l81.152-21.76-23.552 87.808z m58.368 230.4a18.944 18.944 0 0 1-5.12 0 17.92 17.92 0 0 1 0-5.12l25.6-93.696L563.2 528.64z m230.4 51.2c0 2.816-1.536 4.096-1.536 4.864a20.992 20.992 0 0 1-4.352-3.328l-59.392-59.392 87.296-23.552z m156.16-156.16l-81.152 21.76 23.296-87.04 59.392 59.392a40.96 40.96 0 0 1 3.328 3.84 12.8 12.8 0 0 1-4.096 2.56z"fill=#FCC029></path></symbol><symbol id=header-icon-life viewBox="0 0 1024 1024"><path d="M881.408 664.064V504.32a168.192 168.192 0 0 0-128-162.56l-7.936-1.792v144.896a12.288 12.288 0 0 1-14.592 11.776 170.752 170.752 0 0 0-30.464-2.816h-138.752v-27.648a37.632 37.632 0 0 1 11.776-27.648 175.872 175.872 0 0 0 57.856-135.68A179.2 179.2 0 0 0 460.8 132.352a175.872 175.872 0 0 0-180.992 176.128V409.6h32.256a225.536 225.536 0 0 0 15.872 19.2 36.608 36.608 0 0 1 9.472 25.6v42.496A193.792 193.792 0 0 0 179.2 712.96a197.12 197.12 0 0 0 197.12 166.656h325.12a148.48 148.48 0 0 0 45.568-6.144 217.088 217.088 0 0 0 64.256-31.744 176.896 176.896 0 0 0 18.176-15.616l4.608-4.352a156.16 156.16 0 0 0 47.36-111.872v-35.84c0.512-3.072 0.256-6.656 0-9.984z"fill=#FFD778></path><path d="M468.736 238.592a40.192 40.192 0 1 0 40.192 40.192 40.192 40.192 0 0 0-40.192-40.192zM323.584 362.752H217.6a34.816 34.816 0 1 0 0 69.376h106.24a34.816 34.816 0 1 0 0-69.376z"fill=#FB813A></path></symbol><symbol id=header-icon-kichiku viewBox="0 0 1024 1024"><path d="M918.784 510.208a187.904 187.904 0 0 0-88.832-159.488 156.416 156.416 0 0 0 1.792-22.016 150.784 150.784 0 0 0-210.944-138.496 151.04 151.04 0 0 0-216.32 0 150.784 150.784 0 0 0-210.944 138.496 156.416 156.416 0 0 0 1.792 22.016 187.648 187.648 0 0 0-13.824 309.504v1.536a215.296 215.296 0 0 0 332.8 179.2 215.04 215.04 0 0 0 332.8-179.2v-2.56a187.904 187.904 0 0 0 71.68-148.992z"fill=#FC6B8A></path><path d="M680.704 479.744A150.528 150.528 0 0 1 572.672 435.2a150.016 150.016 0 0 1-120.064 0 150.528 150.528 0 0 1-108.032 45.824h-11.264v167.168a166.4 166.4 0 0 0 165.888 165.888h33.536a166.4 166.4 0 0 0 165.888-165.888v-169.728a137.216 137.216 0 0 1-17.92 1.28z"fill=#FFFFFF></path><path d="M510.464 651.264m-33.536 0a33.536 33.536 0 1 0 67.072 0 33.536 33.536 0 1 0-67.072 0Z"fill=#E2006C></path><path d="M635.904 554.496H614.4v-21.504a12.032 12.032 0 0 0-11.776-11.776h-4.864a12.032 12.032 0 0 0-11.776 11.776v21.504h-21.248a11.776 11.776 0 0 0-11.776 11.52v5.12a11.776 11.776 0 0 0 11.776 11.52h21.248v21.504a12.032 12.032 0 0 0 11.776 11.776h4.864a12.032 12.032 0 0 0 11.776-11.776v-21.504h21.248a11.776 11.776 0 0 0 11.776-11.52v-5.12a11.776 11.776 0 0 0-11.52-11.52zM455.936 554.496H435.2v-21.504a12.032 12.032 0 0 0-11.776-11.776h-4.864a12.032 12.032 0 0 0-11.776 11.776v21.504H384a11.776 11.776 0 0 0-11.776 11.52v5.12a11.776 11.776 0 0 0 11.776 11.52h21.248v21.504a12.032 12.032 0 0 0 11.776 11.776h4.864a12.032 12.032 0 0 0 13.312-11.776v-21.504h21.248a11.52 11.52 0 0 0 11.776-11.52v-5.12a11.52 11.52 0 0 0-12.288-11.52z"fill=#FF5C7A></path><path d="M600.32 651.008a12.288 12.288 0 0 0-12.288 12.544c0 34.048-34.816 61.696-76.8 61.696s-76.8-27.648-76.8-61.696a12.544 12.544 0 1 0-25.6 0c0 47.616 45.824 86.528 102.4 86.528s102.4-38.912 102.4-86.528a12.544 12.544 0 0 0-13.312-12.544z"fill=#EB53A8></path></symbol><symbol id=header-icon-guochuang viewBox="0 0 1024 1024"><path d="M873.472 321.792c-46.08-46.592-102.4-73.472-161.536-40.192a177.152 177.152 0 0 0-51.2-161.536s-83.456 107.52-15.104 219.648c-12.288 13.568-24.32 27.136-36.352 39.424-26.88 27.136 14.592 69.12 41.216 41.984l68.608-69.632c40.704-40.96 76.8-23.808 112.896 12.288 26.624 26.88 68.096-15.104 41.472-41.984z"fill=#58D598></path><path d="M705.024 344.576a189.696 189.696 0 0 0-270.848 0 195.072 195.072 0 0 0-41.216 62.464 249.088 249.088 0 0 0-177.664 74.496 256 256 0 0 0 0 359.68 248.576 248.576 0 0 0 354.816 0 256 256 0 0 0 73.472-179.2 190.976 190.976 0 0 0 61.44-41.728 195.84 195.84 0 0 0 0-275.712z"fill=#FF5C7A></path><path d="M514.304 808.704a187.136 187.136 0 0 1-267.264-5.12 193.536 193.536 0 0 1 5.12-271.104s-45.056 120.832 43.776 214.272a210.176 210.176 0 0 0 218.368 61.952"fill=#F14767></path></symbol><symbol id=header-icon-fashion viewBox="0 0 1024 1024"><path d="M691.2 204.8a44.032 44.032 0 0 1 29.952 34.048 117.76 117.76 0 0 1-13.056 76.8s-19.2 29.952-24.32 39.936a235.008 235.008 0 0 0-25.6 107.008v40.704H365.312v-39.424a235.008 235.008 0 0 0-25.6-107.008c-5.12-9.984-24.32-39.936-24.32-39.936a117.76 117.76 0 0 1-13.056-76.8A44.544 44.544 0 0 1 336.896 204.8V147.712a29.952 29.952 0 0 1 27.136-31.744 29.952 29.952 0 0 1 27.648 31.744v73.728A237.056 237.056 0 0 0 512 253.952a241.408 241.408 0 0 0 125.184-35.072V147.712a27.136 27.136 0 1 1 53.76 0z"fill=#FF6A9B></path><path d="M658.432 487.936H365.312L204.8 780.288a36.352 36.352 0 0 0 10.24 46.592 492.288 492.288 0 0 0 595.456 0 36.608 36.608 0 0 0 8.704-47.36z"fill=#FF9DC6></path><path d="M409.6 537.6a9.984 9.984 0 0 0-13.568 4.608l-124.16 250.624a10.496 10.496 0 0 0 4.608 13.568 14.848 14.848 0 0 0 4.608 0 9.984 9.984 0 0 0 8.96-5.632l124.16-250.88A10.24 10.24 0 0 0 409.6 537.6zM455.936 643.072a9.984 9.984 0 0 0-12.032 7.424l-40.448 170.752a10.24 10.24 0 0 0 7.424 12.288h2.304a9.728 9.728 0 0 0 9.728-7.936l40.448-170.752a9.984 9.984 0 0 0-7.424-11.776zM750.848 791.808l-124.16-250.624A9.984 9.984 0 0 0 614.4 537.6a10.24 10.24 0 0 0-4.608 13.312l124.16 250.88a9.984 9.984 0 0 0 8.96 5.632 14.848 14.848 0 0 0 4.608 0 10.496 10.496 0 0 0 3.328-15.616zM579.84 650.496a9.984 9.984 0 0 0-19.456 4.608l40.448 170.752a9.728 9.728 0 0 0 9.728 7.936h2.304a10.24 10.24 0 0 0 7.424-12.288z"fill=#FF6A9B></path></symbol><symbol id=header-icon-ad viewBox="0 0 1024 1024"><path d="M576.768 153.6c32.768-32.512 132.096 13.824 221.952 103.68s136.448 189.184 103.68 221.952a27.648 27.648 0 0 1-6.144 4.608c-37.632 22.784-640 377.6-640 377.6a110.592 110.592 0 0 1-48.384-30.976 140.288 140.288 0 0 1-34.56-49.152s381.184-588.8 399.36-620.8a34.56 34.56 0 0 1 4.096-6.912z"fill=#9796ED></path><path d="M172.288 780.032c-4.864 3.328-35.328 19.968-51.2 28.928a18.688 18.688 0 0 0-9.728 19.456 104.192 104.192 0 0 0 31.488 58.368 117.504 117.504 0 0 0 59.392 33.024 19.2 19.2 0 0 0 19.968-8.448c10.752-17.152 32-51.2 33.024-51.2a110.592 110.592 0 0 1-48.384-30.976 140.288 140.288 0 0 1-34.56-49.152z"fill=#9289F0></path><path d="M576.768 153.6c32.768-32.512 132.096 13.824 221.952 103.68s136.448 189.184 103.68 221.952a27.648 27.648 0 0 1-6.144 4.608c-37.632 22.784-102.4 60.16-102.4 60.16s-64-4.096-173.312-113.664c-102.4-102.4-112.128-171.008-112.128-171.008s39.936-61.696 62.464-98.816a34.56 34.56 0 0 1 5.888-6.912z"fill=#F7DF88></path><path d="M680.45816 374.49224a230.144 83.712 45 1 0 118.386645-118.386645 230.144 83.712 45 1 0-118.386645 118.386645Z"fill=#8683EA></path></symbol><symbol id=header-icon-anime viewBox="0 0 1024 1024"><path d="M588.8 359.68l-12.032-7.424 150.272-206.592a30.976 30.976 0 0 0-51.2-36.352l-153.6 210.176L281.6 170.24a30.976 30.976 0 1 0-33.024 52.736L486.4 369.92l-22.784 31.488a30.976 30.976 0 1 0 51.2 36.352l25.6-35.072 16.128 9.728A30.976 30.976 0 1 0 588.8 359.68z"fill=#FB813A></path><path d="M763.648 850.688m-53.248 0a53.248 53.248 0 1 0 106.496 0 53.248 53.248 0 1 0-106.496 0Z"fill=#FB813A></path><path d="M261.12 797.44a53.248 53.248 0 1 0 53.504 53.248 53.248 53.248 0 0 0-53.504-53.248z"fill=#FB813A></path><path d="M141.312 314.368m92.928 0l556.288 0q92.928 0 92.928 92.928l0 360.704q0 92.928-92.928 92.928l-556.288 0q-92.928 0-92.928-92.928l0-360.704q0-92.928 92.928-92.928Z"fill=#FDDE80></path><path d="M520.448 575.232m-128.256 0a128.256 128.256 0 1 0 256.512 0 128.256 128.256 0 1 0-256.512 0Z"fill=#FFFFFF></path><path d="M476.928 546.56c0-26.88 19.2-37.632 42.24-25.6l49.664 28.672a25.6 25.6 0 0 1 0 48.64l-49.664 28.672c-23.04 13.568-42.24 2.56-42.24-24.32z"fill=#FB813A></path></symbol><symbol id=header-icon-guochandonghuatuijian viewBox="0 0 1024 1024"><path d="M873.472 321.792c-46.08-46.592-102.4-73.472-161.536-40.192a177.152 177.152 0 0 0-51.2-161.536s-83.456 107.52-15.104 219.648c-12.288 13.568-24.32 27.136-36.352 39.424-26.88 27.136 14.592 69.12 41.216 41.984l68.608-69.632c40.704-40.96 76.8-23.808 112.896 12.288 26.624 26.88 68.096-15.104 41.472-41.984z"fill=#58D598></path><path d="M705.024 344.576a189.696 189.696 0 0 0-270.848 0 195.072 195.072 0 0 0-41.216 62.464 249.088 249.088 0 0 0-177.664 74.496 256 256 0 0 0 0 359.68 248.576 248.576 0 0 0 354.816 0 256 256 0 0 0 73.472-179.2 190.976 190.976 0 0 0 61.44-41.728 195.84 195.84 0 0 0 0-275.712z"fill=#FF5C7A></path><path d="M514.304 808.704a187.136 187.136 0 0 1-267.264-5.12 193.536 193.536 0 0 1 5.12-271.104s-45.056 120.832 43.776 214.272a210.176 210.176 0 0 0 218.368 61.952"fill=#F14767></path></symbol><symbol id=header-icon-technology viewBox="0 0 1024 1024"><path d="M510.208 683.264h-114.176l-50.688 209.408H674.816l-50.688-209.408h-113.92z"fill=#FFD778></path><path d="M535.552 150.528v-28.16a25.6 25.6 0 1 0-51.2 0v28.16a271.872 271.872 0 0 0-244.992 269.568v97.28a25.6 25.6 0 0 0 26.88 26.88h487.936a25.6 25.6 0 0 0 25.6-26.88v-97.28a271.616 271.616 0 0 0-244.224-269.568z"fill=#48CFE5></path><path d="M125.696 464.64m103.168 0l562.432 0q103.168 0 103.168 103.168l0 15.36q0 103.168-103.168 103.168l-562.432 0q-103.168 0-103.168-103.168l0-15.36q0-103.168 103.168-103.168Z"fill=#2CBAE5></path><path d="M742.4 537.6a37.632 37.632 0 1 0 37.632 37.632A37.376 37.376 0 0 0 742.4 537.6zM276.736 537.6a37.632 37.632 0 1 0 37.632 37.632A37.632 37.632 0 0 0 276.736 537.6z"fill=#FFD778></path></symbol><symbol id=header-icon-general_pullup_s viewBox="0 0 1024 1024"><path d="M511.936 455.808l214.976 214.976a48 48 0 1 0 67.904-67.904L545.92 353.984a48 48 0 0 0-67.904 0L229.12 602.88a48 48 0 1 0 67.904 67.904l214.912-214.976z"></path></symbol><symbol id=header-icon-Navbar_mobile viewBox="0 0 1024 1024"><path d="M256 64h512a64 64 0 0 1 64 64v768a64 64 0 0 1-64 64H256a64 64 0 0 1-64-64V128a64 64 0 0 1 64-64z m0 128v576h512V192H256z m192 640v64h128v-64H448z"></path></symbol><symbol id=header-icon-Navbar_logo viewBox="0 0 2240 1024"><path d="M2079.810048 913.566175c-10.01309 0-18.554608 0.799768-26.936172-0.159954-16.987063-1.951433-33.974126-1.567544-50.99318-2.079395-10.972811-0.287916-10.652904-0.287916-11.580634-10.90883-2.71921-32.406582-5.694345-64.781173-8.605499-97.155764-2.527266-28.439735-4.926568-56.91146-7.70976-85.319204-2.527266-26.040432-5.566382-52.016883-8.317583-78.025324-2.623238-24.440897-5.054531-48.913784-7.77374-73.322691a12681.114551 12681.114551 0 0 0-10.684895-92.133223c-3.295042-27.128116-6.558094-54.320213-10.205034-81.416339a20559.272961 20559.272961 0 0 0-17.530905-125.979387c-6.398141-44.723002-14.075909-89.22207-22.105576-133.657156-1.439582-7.965685-1.247637-8.253601 6.36615-9.533229 31.670796-5.406429 63.501545-10.01309 95.716183-9.309295 3.486987 0.095972 7.005964 0.159954 10.460959 0.607823 5.662354 0.703795 8.605499 3.454996 8.925406 10.045081 1.119675 22.969325 2.71921 45.938649 4.414717 68.875983 2.71921 37.589076 5.662354 75.178151 8.477537 112.735236 1.791479 24.184971 3.327033 48.305961 5.150503 72.426951 2.911154 38.772732 5.982261 77.513473 8.925406 116.286205 1.791479 23.705111 3.359024 47.474203 5.182494 71.179313 2.783191 34.805885 5.822308 69.579778 8.637489 104.353672 1.791479 22.137566 3.391014 44.307123 5.278466 66.44469 2.783191 32.79047 5.790317 65.580941 8.63749 98.371411 2.143377 25.592562 4.09481 51.249106 6.270178 77.673426zM853.670395 114.918282c4.638652 0 11.644616-0.511851 18.554607 0.127963 8.797443 0.799768 10.49295 3.071107 11.036793 11.900541 2.527266 40.372267 4.894578 80.776524 7.581796 121.180782 2.943145 43.571337 6.174206 87.078693 9.405267 130.586048 2.975135 39.956388 5.950271 79.912775 9.149341 119.869163 3.486987 43.891244 7.357862 87.718507 10.876839 131.609751 2.655228 33.622229 4.926568 67.244457 7.677768 100.898677 2.623238 31.222926 5.694345 62.38187 8.509527 93.572805 2.399303 26.8402 4.830596 53.71239 7.165918 80.58458 0.735786 8.509527 0.127963 9.053369-9.053369 8.829434-24.025018-0.575833-47.922073-3.391014-71.947091-2.71921-5.502401 0.159954-7.101936-2.367312-8.029666-7.581796-1.983424-11.356699-1.663517-22.905343-2.879163-34.390006-3.295042-30.359177-5.182494-60.846317-7.965685-91.269474-2.495275-27.639967-5.502401-55.215953-8.349574-82.82393-2.527266-25.240664-5.02254-50.481329-7.709759-75.753984-2.687219-24.792795-5.534392-49.61758-8.349573-74.442365-2.591247-22.841362-5.118512-45.682723-7.869713-68.524085-4.062819-33.462275-8.093648-66.92455-12.508365-100.322844-4.062819-30.647093-8.66948-61.198214-12.988225-91.813317-5.886289-41.587914-12.508365-83.079855-19.834236-124.411842a1393.96288 1393.96288 0 0 0-5.310457-28.023856c-0.959721-4.702633-0.095972-7.421843 5.278466-8.157629 14.139891-1.887451 28.24779-4.830596 42.451663-6.206196 14.203872-1.311619 28.407744-3.966847 45.106891-2.71921z m1006.075609 403.33878c27.064134 0 27.703949 0.191944 32.054684 24.536869 5.342447 30.03927 9.08536 60.334465 12.636328 90.62966 3.742912 32.278619 7.517815 64.557238 10.972811 96.867848 2.783191 26.008441 5.118512 52.080864 7.74175 78.089305 2.7512 27.256079 5.662354 54.416185 8.509527 81.640274 1.567544 15.387528 3.039117 30.775056 4.798605 46.130593 0.511851 4.446708-0.831758 6.81402-5.214485 7.325871-9.245313 1.055693-18.426645 2.27134-27.639967 3.263052-16.891091 1.82347-33.814173 3.614949-50.737254 5.182493-8.733462 0.799768-9.309294 0.319907-10.940821-8.125638-14.843686-76.617733-29.719363-153.171485-44.435086-229.821208-9.789155-50.961189-19.322384-101.95437-28.919595-152.915559a805.525894 805.525894 0 0 1-3.582959-21.081873c-0.639814-4.030829 0.44787-6.622075 5.022541-7.70976 30.48714-7.133927 61.294186-12.636328 89.733921-14.011927z m-1137.077537 0c28.951586 0 28.823623 0.095972 33.302322 26.360339 6.909992 40.660183 11.804569 81.544301 16.187295 122.556382 4.286754 39.796434 8.957397 79.560878 13.148179 119.357311 2.847173 27.224088 5.086522 54.512157 7.74175 81.704255 1.887451 19.354375 4.126801 38.644769 6.174206 57.967153 0.255926 2.367312 0.383888 4.734624 0.543842 7.133927 0.415879 9.469248 0 10.237025-9.117351 11.164755-18.074747 1.887451-36.181485 3.454996-54.256232 5.246476-6.558094 0.639814-13.084197 1.599535-19.57831 2.239349-8.63749 0.799768-8.925406 0.767777-10.620913-7.965685-6.078234-30.679084-11.964523-61.422149-17.914793-92.101233-14.267853-73.898523-28.69566-147.733065-42.867542-221.631589-5.662354-29.559409-10.524941-59.246781-16.091323-88.838181-1.023702-5.406429-0.255926-7.933694 5.342447-9.245313 30.199223-7.037955 60.590391-12.540355 88.006423-13.947946z m382.128944 309.861946v124.027954c0 1.183656-0.127963 2.399303 0.03199 3.582959 0.607823 6.014252-1.599535 8.66948-7.805731 8.413555-8.157629-0.351898-16.251277-0.127963-24.408906 0.063981-17.019054 0.319907-34.070098-0.351898-51.057162 1.599535-9.405267 1.087684-9.213322 0.511851-10.141052-9.405266-2.783191-31.222926-5.822308-62.413861-8.669481-93.636787-2.623238-28.823623-4.99055-57.711228-7.677768-86.534851-2.71921-29.655381-5.758326-59.214791-8.509527-88.838181-1.887451-19.770254-3.550968-39.508518-5.214485-59.278772-2.175368-25.720525-4.190782-51.409059-6.462122-77.129585-0.959721-10.844848-0.159954-12.380402 10.588923-13.500076a531.877423 531.877423 0 0 1 83.527724-2.591247c6.941982 0.383888 13.851974 1.727498 20.570022 3.359024 8.477536 2.015414 9.405267 3.263052 9.853137 12.124476 0.92773 17.850812 1.855461 35.701624 2.335321 53.584427 0.543842 19.866226 0.095972 39.764443 0.831758 59.63067 1.855461 54.800074 1.567544 109.664129 2.207359 164.528184z m1134.806197 5.630364v117.437869c0 1.983424-0.063981 3.966847 0.03199 5.982262 0.415879 5.150503-1.983424 6.973973-6.878001 6.941982-12.028504-0.095972-24.025018 0-36.021531 0.159954-13.564058 0.127963-27.096125 0.063981-40.628192 1.535553-8.925406 1.023702-8.989387 0.351898-9.789155-8.509527-3.678931-40.660183-7.549806-81.320366-11.260728-122.04453-3.391014-37.525094-6.526103-75.082179-9.981099-112.639265-3.550968-38.740741-7.421843-77.38551-10.90883-116.09426-1.727498-19.386366-3.16708-38.772732-4.606661-58.159097-0.575833-8.445546 0.351898-9.949109 9.885127-10.716886 16.571184-1.311619 33.078387-3.550968 49.777534-3.263051 16.635165 0.319907 33.302322-0.607823 49.841515 2.559256 14.011928 2.687219 14.715723 3.486987 15.547481 18.458635 2.399303 44.051198 1.663517 88.230358 3.231061 132.281556 1.599535 46.89837 0.479861 93.79674 1.759489 146.069549zM1831.498213 305.135c9.789155 0.575833 17.498914 0.095972 25.176683 1.791479 4.894578 1.119675 7.357862 3.327033 7.837723 8.573509 2.303331 25.240664 4.798605 50.51332 7.32587 75.785975 2.015414 20.50604 4.158791 41.012081 6.238188 61.518121l0.191944 1.183656c1.663517 12.924244 1.279628 13.276142-11.292718 13.979937-11.196746 0.607823-22.361501 1.599535-33.558247 2.27134-7.357862 0.44787-9.693183 1.695507-10.90883-9.021378-4.190782-37.813011-9.053369-75.530049-13.692021-113.311069a1185.0316 1185.0316 0 0 0-4.286754-31.798759c-0.92773-5.982261 1.407591-9.277304 7.005964-9.757164 7.357862-0.671805 14.715723-0.863749 19.962198-1.215647z m-1133.398606 0.159954c7.549806 0.415879 15.323547-0.159954 22.937334 1.599535 4.350736 0.991712 6.558094 2.815182 6.973973 7.773741 0.92773 11.83656 2.7512 23.641129 3.870875 35.477689 3.550968 36.309448 6.909992 72.650886 10.237025 108.992324 0.703795 7.901704 0.543842 8.061657-6.84601 8.605499-13.116188 0.959721-26.264367 1.919442-39.412546 2.463284-7.645778 0.351898-8.605499-0.575833-9.56522-8.381564-3.327033-26.744227-6.462122-53.520446-9.661192-80.296664-2.591247-22.073585-4.766615-44.14717-7.901704-66.156773-0.863749-6.078234 1.119675-7.74175 5.982262-8.733462 7.709759-1.567544 15.451509-1.055693 23.385203-1.343609z m399.147998 100.002936c0 23.001315 0.063981 45.97064-0.031991 69.003946 0 10.332997-0.127963 10.396978-10.396978 10.269016a324.289753 324.289753 0 0 1-36.981252-1.919443c-7.933694-0.991712-8.093648-0.735786-8.317583-9.149341-0.799768-28.119828-1.631526-56.239655-2.207359-84.359483-0.415879-19.034468-0.639814-38.004955-1.791479-57.039422-0.607823-9.821146-0.063981-9.917118 9.373276-10.045081 13.915956-0.159954 27.799921 0.479861 41.619904 2.591247 8.317583 1.279628 8.701471 1.279628 8.733462 10.49295 0.063981 23.385204 0.063981 46.770407 0.063981 70.187602h-0.063981z m1135.38203 0.607824c0 23.033306 0.063981 46.034621-0.031991 69.035936 0 9.661192-0.159954 9.725174-9.853137 9.661192a505.32514 505.32514 0 0 1-38.132917-1.791479c-6.302168-0.479861-8.157629-3.135089-7.74175-8.861425 0.063981-0.799768 0-1.599535 0-2.399302-0.959721-44.403095-1.919442-88.7742-2.815182-133.177296-0.031991-2.367312-0.159954-4.734624-0.063982-7.133926 0.127963-8.957397 0.159954-9.181332 9.149341-9.117351 12.380402 0.063981 24.664832 0.703795 37.013243 1.919442 15.067621 1.503563 12.412393 3.359024 12.476375 15.259566 0.063981 22.169557 0.031991 44.403095 0 66.604643z m-1565.593 54.000306c0.287916 12.636328 0.287916 12.604337-11.804569 15.547481-8.221611 2.015414-16.443221 4.222773-24.728813 6.046243-7.069945 1.599535-8.317583 0.703795-9.53323-6.238187-8.445546-47.090314-16.8591-94.212619-25.240664-141.334924-1.695507-9.757164-1.247637-10.364988 8.349573-12.060495 11.804569-2.079396 23.577148-4.126801 35.381717-5.950271 7.517815-1.183656 8.477536-0.767777 9.9811 7.517815 2.975135 16.731138 5.790317 33.526256 7.997675 50.385357 3.423005 26.680246 6.238187 53.456464 9.309295 80.168701 0.255926 1.951433 0.191944 3.966847 0.287916 5.91828z m1064.138735-136.696273c15.451509-2.527266 31.030982-5.086522 46.610454-7.549806 5.598373-0.863749 7.29388 2.655228 8.029666 7.645778 2.655228 18.426645 5.982261 36.725327 8.157629 55.183962 3.19907 26.744227 7.581797 53.360492 8.413555 80.328655 0.063981 2.7512 0.031991 5.566382 0.095972 8.317583 0.159954 4.286754-1.983424 6.494113-5.950271 7.421843-10.556932 2.367312-21.113864 4.734624-31.638805 7.261889-5.054531 1.215647-6.750038-0.92773-7.581796-5.854298-3.16708-18.746552-6.81402-37.397131-10.045081-56.079702-5.47041-30.775056-10.780867-61.582103-16.091323-92.38915-0.127963-1.119675 0-2.303331 0-4.286754z m-710.64147 108.032603c-0.44787 16.37924 0.543842 30.647093-1.695507 44.914947-0.671805 4.510689-1.983424 7.421843-6.846011 7.837722-10.428969 0.863749-20.825947 1.695507-31.190935 2.7512-5.02254 0.543842-6.430131-1.631526-7.261889-6.558094-2.335321-14.55577-1.919442-29.303484-3.327033-43.923234-2.655228-27.607976-3.774903-55.407897-5.566383-83.111846-0.44787-6.750038-1.119675-13.436095-1.663516-20.186134-0.287916-3.774903 1.215647-5.886289 5.246475-6.046242 13.500077-0.543842 26.936172-3.007126 40.50023-2.527266 7.933694 0.287916 8.605499 0.799768 9.181331 8.797443 0.351898 5.534392 0.255926 11.132765 0.383889 16.699147l2.239349 81.352357z m1134.902169-15.867388c0 19.066459 0.223935 38.132918-0.031991 57.199376-0.159954 9.917118-1.279628 10.780867-10.652904 11.644616-9.277304 0.863749-18.490626 1.567544-27.735939 2.559256-5.214485 0.543842-7.645778-0.991712-7.965685-6.973973-1.34361-25.336637-3.16708-50.673273-4.926568-75.977919-1.3756-20.985901-2.943145-41.939811-4.414717-62.893722-0.159954-2.399303-0.031991-4.798605-0.191944-7.165917-0.223935-4.190782 1.055693-6.654066 5.758326-6.81402 13.116188-0.44787 26.136404-2.975135 39.348564-2.495274 8.061657 0.287916 8.18962 0.415879 8.797444 8.797443 1.951433 27.32006 2.143377 54.704102 2.015414 82.120134zM628.295894 756.171918c16.571184 18.234701 17.402942 39.828425 11.932532 62.413861-5.502401 22.585436-18.042756 41.204025-33.23834 57.903171-25.49659 27.895893-56.303637 48.497905-89.062116 65.99682-56.399609 30.135242-116.190232 50.161422-178.572103 61.997982-44.882956 8.477536-90.053828 15.00364-135.704561 17.498914-13.915956 0.767777-27.799921 1.407591-41.715876 1.311619-10.077071 0-20.186133 0.287916-30.231214-0.063981-8.541518-0.319907-9.789155-1.791479-10.49295-10.716886-2.591247-32.022693-4.798605-64.077378-7.645778-96.100071-3.327033-37.109215-7.229899-74.18644-10.812858-111.295654-2.623238-26.8402-4.894578-53.744381-7.773741-80.520599-3.327033-31.542833-7.069945-63.021684-10.716885-94.564517-3.327033-29.111539-6.526103-58.28706-10.045081-87.430591-3.934856-32.278619-7.997676-64.493257-12.31642-96.707894a8228.968456 8228.968456 0 0 0-13.212161-92.996973 5984.500754 5984.500754 0 0 0-24.312934-152.627642 3243.825263 3243.825263 0 0 0-23.67312-123.740038c-1.151665-5.502401 0.511851-7.709759 5.342448-9.725174C52.335283 47.609843 98.465876 28.063524 144.724432 8.77313c8.605499-3.582959 17.434933-6.590085 26.584274-8.285592 6.334159-1.183656 7.965685 0.127963 7.773741 6.494113-0.479861 16.283268 0.191944 32.630517-1.407591 48.849803a161.393095 161.393095 0 0 0-0.639814 13.084197c-0.735786 58.383032-1.439582 116.798056 0.095972 175.213079 1.34361 51.185124 4.030829 102.338258 7.005964 153.491392 2.335321 40.372267 5.694345 80.744534 9.149341 121.052819 3.391014 39.508518 7.517815 78.953054 11.38869 118.461572 0.735786 7.517815 1.407591 8.221611 9.949108 7.069945a381.329176 381.329176 0 0 1 50.833227-4.190782c52.880632-0.127963 104.897514 7.133927 156.338564 19.322384 45.010919 10.684895 88.806191 24.920757 130.777993 44.818975 20.793957 9.853136 40.692174 21.241827 58.830902 35.701624 6.174206 4.862587 11.676606 10.46096 16.891091 16.315259z m1126.840512-9.597211c20.47405 17.946784 27.927883 39.924397 22.105576 67.116494-4.830596 22.425483-15.771416 41.268006-30.359177 58.127107-23.417194 27.096125-51.856929 47.698138-82.631985 64.909136-60.334465 33.782182-124.603787 55.727804-192.168151 68.396122a1151.089465 1151.089465 0 0 1-111.455609 15.547481c-21.177845 1.82347-42.451662 4.09481-66.220754 2.623238h-27.76793c-5.406429 0-8.477536-1.695507-8.925406-8.125638-2.047405-28.087837-4.414717-56.143683-6.941983-84.19953-2.687219-29.623391-5.662354-59.246781-8.477536-88.870172-2.559256-27.224088-4.926568-54.512157-7.709759-81.736245-2.559256-25.656544-5.502401-51.249106-8.285592-76.873659-2.591247-24.057008-5.086522-48.114017-7.933695-72.139035-3.423005-29.111539-7.037955-58.223079-10.652904-87.334618-3.391014-27.160107-6.750038-54.288222-10.364987-81.416338a6133.577429 6133.577429 0 0 0-12.156467-87.142675c-5.694345-37.653057-11.804569-75.178151-17.818822-112.767227a3259.14881 3259.14881 0 0 0-29.111539-158.993792c-0.44787-2.335321-0.671805-4.734624-1.3756-7.005964-1.663517-5.118512-0.063981-7.837722 4.958559-9.821146C1191.012355 47.641834 1238.61452 24.448575 1288.2321 6.149893c6.494113-2.431293 13.052207-5.150503 20.058171-5.854299 6.302168-0.639814 7.901704 0.383888 7.29388 7.101936-3.327033 36.43741-1.407591 73.066765-3.135089 109.536166-1.407591 29.751354-1.247637 59.598679 0.255926 89.382023 0.351898 7.549806 0.639814 15.131602 0.575832 22.649418-0.383888 35.765606 1.503563 71.499221 3.327033 107.200845 2.335321 47.186286 5.758326 94.276601 9.245313 141.398906 2.527266 34.006117 5.822308 67.948253 9.021379 101.922379 1.695507 18.586598 3.518977 37.141206 5.822308 55.631832 1.247637 10.205034 1.759489 10.301006 11.772578 8.957396 17.658868-2.399303 35.349726-4.350736 53.200539-4.09481 62.637796 0.799768 124.027954 10.684895 184.266447 27.863902 40.788146 11.580634 80.488608 26.040432 117.981712 46.290547a253.55831 253.55831 0 0 1 47.218277 32.438573zM308.676783 922.811488c23.161269-11.068783 135.608589-98.947243 144.533995-113.279078-54.576139-23.513166-109.344222-45.362816-168.239105-63.24562l23.70511 176.524698z m1277.196815-107.520752c2.879163-3.103098 2.559256-5.502401-1.343609-7.229899-7.773741-3.550968-15.4835-7.325871-23.353213-10.556932-42.003793-17.179007-84.19953-33.814173-127.482951-47.37823-3.774903-1.151665-7.645778-3.774903-12.476374-1.535554l23.321222 173.45359c3.454996 0.767777 4.798605-0.831758 6.33416-1.919442 39.316574-28.855614 78.889073-57.35933 116.638102-88.390312 6.36615-5.182494 12.668318-10.396978 18.362663-16.443221z"fill=#23ADE5></path></symbol><symbol id=header-icon-bilibili-tv viewBox="0 0 1024 1024"><path d="M800.768 237.216h-51.264l44.832-44.832c19.232-19.232 19.232-57.664 0-76.864s-57.664-19.232-76.864 0l-128.128 121.728h-153.76L307.456 115.52c-19.232-19.232-57.664-19.232-76.864 0s-19.232 57.664 0 76.864l44.832 44.832H224.16C134.464 237.216 64 307.68 64 397.376v345.952c0 96.096 70.464 166.56 160.16 166.56h570.144c89.696 0 160.16-70.464 160.16-160.16V397.376c6.4-89.696-64.064-160.16-153.76-160.16z m44.864 506.112a57.44 57.44 0 0 1-57.664 57.664H230.624a57.44 57.44 0 0 1-57.664-57.664v-339.52c0-32.032 25.632-57.664 57.664-57.664h557.344c32.032 0 57.664 25.632 57.664 57.664v339.52zM345.952 461.44a57.44 57.44 0 0 0-57.664 57.664v57.664c0 32.032 25.632 57.664 57.664 57.664s57.664-25.632 57.664-57.664v-57.664a57.44 57.44 0 0 0-57.664-57.664z m333.12 0a57.44 57.44 0 0 0-57.664 57.664v57.664c0 32.032 25.632 57.664 57.664 57.664s57.664-25.632 57.664-57.664v-57.664a57.44 57.44 0 0 0-57.664-57.664z"></path></symbol><symbol id=header-icon-general_upload viewBox="0 0 1024 1024"><path d="M704 448v192c0 38.4-25.6 64-64 64H384c-38.4 0-64-25.6-64-64V448H153.6c-19.2 0-32-12.8-32-32 0-6.4 6.4-19.2 12.8-25.6l358.4-307.2c12.8-12.8 32-12.8 44.8 0L896 390.4c12.8 12.8 12.8 32 6.4 44.8-12.8 6.4-19.2 12.8-32 12.8H704zM192 832h640c38.4 0 64 25.6 64 64s-25.6 64-64 64H192c-38.4 0-64-25.6-64-64s25.6-64 64-64z"></path></symbol><symbol id=header-icon-general_search viewBox="0 0 1024 1024"><path d="M659.2 736c-140.8 115.2-345.6 108.8-473.6-19.2C44.8 576 44.8 352 179.2 211.2s358.4-134.4 499.2 0c121.6 121.6 134.4 313.6 38.4 448l198.4 198.4c19.2 19.2 19.2 51.2 0 70.4-19.2 19.2-51.2 19.2-70.4 0l-185.6-192z m-44.8-89.6c102.4-102.4 102.4-262.4 0-364.8s-262.4-102.4-364.8 0-102.4 262.4 0 364.8 262.4 96 364.8 0z"></path></symbol><symbol id=header-icon-activit viewBox="0 0 1024 1024"><path d="M518.656 475.904a223.488 223.488 0 0 1-23.296-75.52 366.08 366.08 0 0 1 81.408 14.592 623.104 623.104 0 0 1-58.112 60.928m-69.888-119.04c-11.52-58.112-8.704-55.296-25.6-156.928a265.984 265.984 0 0 0-78.336 46.592c51.2 104.448 60.928 165.376 92.928 290.304 51.2-5.632 211.968-40.704 226.56-130.56 8.704-64-142.336-64-215.04-49.408M486.4 624.128a263.424 263.424 0 0 0-107.52 69.632l43.52 153.6a47.872 47.872 0 0 1-92.928 23.296L216.576 473.088l-72.704-204.8c2.816-5.632 5.888-8.704 8.704-14.336l-14.592-51.2a46.08 46.08 0 0 1 32-57.856A47.616 47.616 0 0 1 228.096 179.2v2.816a334.848 334.848 0 0 1 98.816-43.52c177.152-46.592 203.264 55.04 429.824 23.296L890.368 588.8c-171.52 90.112-232.448-11.52-403.712 35.072"fill=#F39800></path></symbol><symbol id=header-icon-blackroom viewBox="0 0 1024 1024"><path d="M139.264 529.152a27.136 27.136 0 0 1-14.592-2.816A32 32 0 0 1 113.152 486.4l130.816-236.032a28.416 28.416 0 1 1 49.152 28.928l-130.56 235.52a25.6 25.6 0 0 1-23.296 14.336"fill=#F99E4A></path><path d="M380.416 529.152a34.56 34.56 0 0 1-25.6-14.592l-131.328-235.264a30.208 30.208 0 0 1 11.52-37.632 25.6 25.6 0 0 1 37.888 11.52l130.816 235.264a25.6 25.6 0 0 1-11.776 37.888c-2.816 0-8.704 2.816-11.52 2.816m261.376 0a25.6 25.6 0 0 1-14.336-2.816 29.44 29.44 0 0 1-11.776-37.888l130.816-235.264a28.928 28.928 0 0 1 37.632-11.52 29.44 29.44 0 0 1 11.776 37.632L665.6 514.56a25.6 25.6 0 0 1-23.296 14.592"fill=#F99E4A></path><path d="M883.968 529.152a34.56 34.56 0 0 1-25.6-14.336l-130.56-235.52a27.392 27.392 0 0 1 11.52-37.632 25.6 25.6 0 0 1 37.888 11.52l130.56 235.52a25.6 25.6 0 0 1-11.776 37.632c-2.816 0-8.704 2.816-11.776 2.816"fill=#F99E4A></path><path d="M801.536 241.664l-130.56-51.2A129.536 129.536 0 0 0 640 183.552H380.416a153.6 153.6 0 0 0-32 5.632L217.6 241.664A21.248 21.248 0 0 0 226.304 281.6h569.6a21.248 21.248 0 0 0 5.632-40.704M458.752 281.6v520.704a51.2 51.2 0 0 0 104.704 0V281.6z"fill=#FFD043></path><path d="M561.152 183.296A51.2 51.2 0 0 0 512 139.776a52.992 52.992 0 0 0-51.2 46.336h102.4z"fill=#FFD043></path><path d="M755.2 877.824H267.008A41.472 41.472 0 0 1 230.4 816.896l55.04-122.112a44.8 44.8 0 0 1 37.888-25.6h373.76a37.12 37.12 0 0 1 37.632 25.6L790.016 819.2a37.888 37.888 0 0 1-34.816 58.112"fill=#F99E4A></path><path d="M900.352 494.336a9.216 9.216 0 0 1 8.704 8.704 148.48 148.48 0 0 1-296.192 0 7.68 7.68 0 0 1 8.704-8.704z m-502.528 0a9.216 9.216 0 0 1 8.704 8.704 151.808 151.808 0 0 1-148.224 142.336 150.016 150.016 0 0 1-148.224-142.336 7.68 7.68 0 0 1 8.704-8.704z"fill=#FFD043></path></symbol><symbol id=header-icon-read viewBox="0 0 1024 1024"><path d="M778.496 142.08h-537.6a56.832 56.832 0 0 0-60.16 54.016v630.528a56.832 56.832 0 0 0 59.136 54.016h537.6a56.832 56.832 0 0 0 59.136-54.016V196.096a56.832 56.832 0 0 0-59.136-54.016z"fill=#54E2E2></path><path d="M298.496 679.168h421.376a25.6 25.6 0 0 0 0-52.736H298.496a25.6 25.6 0 1 0 0 52.736zM719.872 732.928H298.496a25.6 25.6 0 1 0 0 52.736h421.376a25.6 25.6 0 0 0 0-52.736z"fill=#23ADE5></path><path d="M272.128 237.056m80.128 0l314.112 0q80.128 0 80.128 80.128l0 154.368q0 80.128-80.128 80.128l-314.112 0q-80.128 0-80.128-80.128l0-154.368q0-80.128 80.128-80.128Z"fill=#23ADE5></path><path d="M404.992 361.472m-49.408 0a49.408 49.408 0 1 0 98.816 0 49.408 49.408 0 1 0-98.816 0Z"fill=#2EC3E5></path><path d="M375.552 551.936l120.832-144.384a44.544 44.544 0 0 1 68.352 0l120.832 144.384z"fill=#2EC3E5></path></symbol><symbol id=header-icon-ic_partition_broadca viewBox="0 0 1024 1024"><path d="M665.6 852.48H194.56c-38.4 0-66.56-30.72-66.56-69.12v-281.6c0-38.4 30.72-69.12 66.56-69.12H665.6c38.4 0 66.56 30.72 66.56 69.12v284.16c0 35.84-30.72 66.56-66.56 66.56"fill=#FE6998></path><path d="M688.768 282.1376c0 76.8-61.44 138.24-135.68 138.24S419.968 358.9376 419.968 282.1376 481.408 143.8976 555.648 143.8976s133.12 64 133.12 138.24"fill=#FE6998></path><path d="M384 332.8c0 48.64-38.4 89.6-87.04 89.6S209.92 384 209.92 332.8s38.4-89.6 87.04-89.6S384 284.16 384 332.8"fill=#FF5B61></path><path d="M414.72 558.08l115.2 69.12c15.36 10.24 15.36 30.72 0 40.96l-115.2 69.12c-15.36 10.24-35.84-2.56-35.84-20.48v-138.24c2.56-17.92 20.48-28.16 35.84-20.48"fill=#FDDE80></path><path d="M790.912 511.5904L621.952 611.4304C591.232 629.3504 591.232 677.9904 621.952 695.9104l168.96 99.84c30.72 17.92 71.68-5.12 71.68-43.52V555.1104C862.592 516.7104 824.192 493.6704 790.912 511.5904"fill=#FE6998></path></symbol><symbol id=header-icon-cinephile viewBox="0 0 1024 1024"><path d="M147.2 201.728m79.616 0l571.136 0q79.616 0 79.616 79.616l0 458.24q0 79.616-79.616 79.616l-571.136 0q-79.616 0-79.616-79.616l0-458.24q0-79.616 79.616-79.616Z"fill=#9796ED></path><path d="M222.976 269.312h77.056v57.856H222.976zM390.144 269.312h77.056v57.856h-77.056zM557.312 269.312h77.056v57.856h-77.056zM724.48 269.312h77.056v57.856H724.48zM222.976 693.76h77.056v57.856H222.976zM390.144 693.76h77.056v57.856h-77.056zM557.312 693.76h77.056v57.856h-77.056zM147.2 375.296h730.368v270.08H147.2z"fill=#7B78EA></path><path d="M521.369822 529.707066m23.351494-23.351495l2.534271-2.53427q23.351494-23.351494 46.702989 0l199.664327 199.664327q23.351494 23.351494 0 46.702989l-2.534271 2.534271q-23.351494 23.351494-46.702988 0l-199.664328-199.664328q-23.351494-23.351494 0-46.702989Z"fill=#FFD043></path><path d="M708.352 418.816h-25.6v-24.32a13.568 13.568 0 0 0-13.568-13.568H665.6a13.312 13.312 0 0 0-13.312 13.568v24.32h-25.6a13.568 13.568 0 0 0-13.568 13.568v5.632a13.568 13.568 0 0 0 13.568 13.568h25.6v24.32a13.312 13.312 0 0 0 13.312 13.568h5.632a13.568 13.568 0 0 0 13.568-13.568v-24.32h25.6a13.312 13.312 0 0 0 13.312-13.568v-5.632a13.312 13.312 0 0 0-15.36-13.568zM517.888 418.816h-25.6v-24.32a13.312 13.312 0 0 0-13.312-13.568h-5.632a13.568 13.568 0 0 0-13.568 13.568v24.32H435.2a13.312 13.312 0 0 0-13.312 13.568v5.632a13.312 13.312 0 0 0 13.312 13.568h25.6v24.32a13.568 13.568 0 0 0 13.568 13.568h5.632a13.312 13.312 0 0 0 13.312-13.568v-24.32h25.6a13.312 13.312 0 0 0 13.312-13.568v-5.632a13.312 13.312 0 0 0-14.336-13.568zM493.568 572.16h-18.432v-18.432a10.24 10.24 0 0 0-10.24-10.24H460.8a10.24 10.24 0 0 0-10.24 10.24v18.432h-18.432a10.24 10.24 0 0 0-10.24 10.24v4.352a10.24 10.24 0 0 0 10.24 10.24h18.432V614.4a10.24 10.24 0 0 0 10.24 10.24h4.352a10.24 10.24 0 0 0 10.24-10.24v-18.432h18.432a10.24 10.24 0 0 0 10.24-10.24v-4.352a10.24 10.24 0 0 0-10.496-9.216z"fill=#FFD778></path></symbol><symbol id=header-icon-cinema viewBox="0 0 1024 1024"><path d="M682.24 716.8c34.56 0 71.936-2.56 106.496 0 61.184 0 74.752 39.936 76.8 93.184a32 32 0 0 0 64 0c0-71.936-25.6-143.872-106.752-157.184a807.168 807.168 0 0 0-138.496 0 32 32 0 0 0-2.56 64"fill=#FB813A></path><path d="M860.672 489.472A354.304 354.304 0 1 0 506.368 844.8a358.4 358.4 0 0 0 354.304-355.328"fill=#FB813A></path><path d="M695.552 566.528A79.872 79.872 0 1 1 775.424 486.4a79.872 79.872 0 0 1-79.872 79.872M508.928 384a79.872 79.872 0 0 1-79.872-79.872 80.128 80.128 0 0 1 160 0A80.128 80.128 0 0 1 508.928 384m0 372.992a79.872 79.872 0 0 1-79.872-79.872 81.92 81.92 0 0 1 79.872-79.872A80.128 80.128 0 0 1 588.8 675.84a78.592 78.592 0 0 1-80.128 79.872m-186.112-189.184A79.872 79.872 0 1 1 402.432 486.4a79.872 79.872 0 0 1-79.872 79.872M512 128a372.992 372.992 0 1 0 372.736 371.968A374.016 374.016 0 0 0 512 128"fill=#FFBA7B></path><path d="M567.552 489.472a58.624 58.624 0 1 0-58.624 58.624 59.136 59.136 0 0 0 58.624-58.624"fill=#FB952C></path></symbol><symbol id=header-icon-topic viewBox="0 0 1024 1024"><path d="M880.64 520.448C880.64 642.56 768 742.4 627.712 742.4H409.6l-165.632 74.496-92.928-258.56a146.688 146.688 0 0 1-3.072-37.888v-37.888c0-122.112 110.592-226.56 250.112-226.56h232.704c136.448 0 249.856 104.448 249.856 226.56v37.888zM642.304 209.408h-256a280.064 280.064 0 0 0-279.04 273.152v43.776a250.88 250.88 0 0 0 3.072 46.336L215.04 878.08l183.04-90.112h244.224c153.6 0 279.04-116.48 279.04-261.632v-43.776a279.808 279.808 0 0 0-279.04-273.152z m58.112 351.744a51.2 51.2 0 0 1-51.2-51.2 55.552 55.552 0 0 1 58.112-52.48 54.528 54.528 0 0 1 51.2 55.296 57.088 57.088 0 0 1-58.112 49.408m-179.2 0a51.2 51.2 0 0 1-51.2-51.2 55.552 55.552 0 0 1 58.112-52.48 54.528 54.528 0 0 1 51.2 55.296A59.392 59.392 0 0 1 521.216 563.2m-179.2 0a51.2 51.2 0 0 1-51.2-51.2 55.552 55.552 0 0 1 58.112-52.48 54.528 54.528 0 0 1 51.2 55.296 59.648 59.648 0 0 1-58.112 49.408m279.04-270.336h-208.384c-122.112 0-224 87.296-224 188.928V512a111.36 111.36 0 0 0 3.072 31.744L267.264 768l110.592-58.112H645.12A194.048 194.048 0 0 0 842.752 512v-29.44c-2.816-104.448-102.4-191.744-223.744-191.744"fill=#8FC31F></path></symbol><symbol id=header-icon-douga viewBox="0 0 1024 1024"><path d="M273.408 166.912h477.696c58.368 0 105.984 47.616 105.984 105.984v477.696c0 58.368-47.616 105.984-105.984 105.984H273.408c-58.368 0-105.984-47.616-105.984-105.984V273.408C166.912 215.04 215.04 166.912 273.408 166.912z"fill=#7B78EB></path><path d="M512 525.312v98.816c33.28-14.848 72.704 0.512 87.552 33.792 14.848 33.28-0.512 72.704-33.792 87.552-16.896 7.68-35.84 7.68-53.248 0v111.616H273.408c-58.368 0-105.984-47.616-105.984-105.984V512h137.216c-21.504 19.456-24.064 53.248-4.608 74.752 19.456 21.504 53.248 24.064 74.752 4.608 21.504-18.944 24.064-53.248 4.608-74.752l-4.608-4.608H512v-40.96c-4.096 0.512-9.216 0.512-13.312 0-51.2 0-86.016-47.616-86.016-105.984s20.992-108.032 86.016-108.032h13.312V166.912h238.592c58.368 0 105.984 47.616 105.984 105.984v251.904h-120.832c20.992-23.552 19.456-59.392-3.584-80.896-23.552-20.992-59.392-19.456-80.896 3.584-19.968 21.504-19.968 55.296 0 76.8H512z"fill=#9796ED></path><path d="M512 525.312v98.816l13.312-4.096c35.84-7.68 72.704 15.872 79.872 52.224 7.68 35.84-18.432 72.192-54.272 78.848-4.096 1.024-8.704 1.024-13.312 1.024-9.216 0-16.384-3.072-25.088-6.144v111.616h-14.336v-132.608l18.432 8.192c27.136 11.776 58.368-0.512 70.144-27.648 11.776-27.136-0.512-58.368-27.648-70.144-13.312-5.632-28.672-5.632-42.496 0l-18.432 8.192v-117.76H399.872c14.848 33.28-0.512 72.704-33.792 87.552-33.28 14.848-72.704-0.512-87.552-33.792-7.68-16.896-7.68-35.84 0-53.248H166.912V512h137.216c-21.504 19.456-24.064 53.248-4.608 74.752 19.456 21.504 53.248 24.064 74.752 4.608 21.504-19.456 24.064-53.248 4.608-74.752l-4.608-4.608H512v-39.936h-13.312c-51.2 0-86.016-47.104-86.016-105.984s20.992-109.568 86.016-109.568h13.312V166.912h13.312v105.984h-26.624c-49.664 0-73.216 33.28-73.216 94.208 0 53.248 30.72 92.672 73.216 92.672 3.584 0.512 7.68 0.512 11.264 0l15.36-2.048V512h102.912c-13.824-35.84 4.096-76.8 40.448-90.624 35.84-13.824 76.8 4.096 90.624 40.448 6.144 15.872 6.144 33.792 0 50.176h97.792v13.312h-120.832c20.992-23.552 19.456-59.392-3.584-80.896-23.552-20.992-59.392-19.456-80.896 3.584-19.968 21.504-19.968 55.296 0 76.8H512z"fill=#6A68C6></path><path d="M444.928 693.248c-23.04 13.312-52.224 5.12-65.024-17.408-4.096-7.68-6.144-15.36-6.144-24.064V392.192c0-26.624 20.992-47.616 47.616-47.616 8.704 0 16.896 2.048 24.576 6.656l221.696 132.608c23.04 13.312 30.208 42.496 16.896 65.024-4.096 6.656-10.24 12.8-16.896 16.896"fill=#FDDE80></path></symbol><symbol id=header-icon-digital viewBox="0 0 1024 1024"><path d="M298.496 284.928l17.664-51.2a36.608 36.608 0 0 1 33.28-22.016h325.376a37.12 37.12 0 0 1 34.304 22.016l17.408 51.2h88.576a69.376 69.376 0 0 1 66.56 70.656v377.344a69.12 69.12 0 0 1-67.84 70.144H209.92a69.12 69.12 0 0 1-68.352-70.144V355.584a69.376 69.376 0 0 1 68.352-70.656z"fill=#FFBA7B></path><path d="M141.568 457.728h740.096v271.36a69.632 69.632 0 0 1-73.728 73.984H210.688a69.12 69.12 0 0 1-69.12-69.376z"fill=#FB952C></path><path d="M512 358.4a197.376 197.376 0 1 1-197.376 197.376A197.632 197.632 0 0 1 512 358.4z"fill=#FB952C></path><path d="M512 409.6a148.224 148.224 0 1 1-147.968 147.968A147.968 147.968 0 0 1 512 409.6z"fill=#FFFFFF></path><path d="M512 457.728a98.816 98.816 0 1 1-98.56 98.56A98.56 98.56 0 0 1 512 457.728z"fill=#FB952C></path><path d="M733.696 358.4h73.984a25.6 25.6 0 0 1 25.6 25.6 25.6 25.6 0 0 1-25.6 25.6h-73.984a25.6 25.6 0 0 1-25.6-25.6 25.6 25.6 0 0 1 25.6-25.6z"fill=#FFFFFF></path></symbol></svg><div class=custom-navbar><div class=blur-layer-container><div class="blur-layer left-pad"></div><div class=blur-layer></div><div class="blur-layer right-pad"></div></div><ul><li v-for="c of components":key=c.name :data-name=c.name v-show=!c.hidden :class="{disabled: c.disabled || c.active, active: c.active}":style="{flex: c.flex, order: c.order}"@mouseover=requestPopup(c)><a class=main-content v-if=c.href :href="!c.active && !c.touch && c.href"v-html=c.html></a><div class=main-content v-else v-html=c.html></div><div class=notify-count v-show=!c.active></div><div class=popup-container><div class=popup v-if=c.popupHtml :class="{'no-padding': c.noPadding, 'transparent': c.transparent }"><div v-if=c.requestedPopup v-html=c.popupHtml></div></div></div><div class=active-bar></div></li></ul></div><div class=custom-navbar-settings><div class=header><h1>顶栏布局</h1><div class=header-blank></div><button class=close title=关闭 @click=close><i class="mdi mdi-close mdi-24px"></i></button></div><div class="header paddings-desc">边缘间距: 设定两侧边缘处的间距, 单位为百分比, 100%为整个顶栏的宽度. 允许设置的范围为 0% ~ 40%</div><div class=paddings><input type=range min=0 max=40 step=0.5 v-model=boundsPadding><span>{{boundsPadding}}%</span></div><div class="header orders-desc">顺序与显示: 在左侧的条状图标上拖动可以改变它们的顺序, 或者按住名字一会再拖动也可以调顺序. 点击右侧的眼睛图标可以显示/隐藏它们.</div><div class=orders><ul class=order-list><order-item v-for="item of orderList":key=item.name :item=item></order-item></ul></div></div>`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar.min.js"] = (()=>{return(t,i)=>{const a=["//www.bilibili.com","//t.bilibili.com","//search.bilibili.com","//space.bilibili.com","//account.bilibili.com","//pay.bilibili.com","//member.bilibili.com","//big.bilibili.com","//message.bilibili.com","//app.bilibili.com","//passport.bilibili.com","//game.bilibili.com","//live.bilibili.com/blackboard/"];const s=["//t.bilibili.com/vote/h5/index/#/result","//t.bilibili.com/lottery/h5/index/#/result","//member.bilibili.com/video/upload","//space.bilibili.com/ajax/","//www.bilibili.com/h5/comment/","//www.bilibili.com/blackboard/","//member.bilibili.com/v2"];const n=()=>{document.body.style.setProperty("--navbar-bounds-padding",`0 ${t.customNavbarBoundsPadding}%`);document.body.style.setProperty("--navbar-blur-opacity",(t.customNavbarBlurOpacity||.7).toString());addSettingsListener("customNavbarBlurOpacity",t=>{document.body.style.setProperty("--navbar-blur-opacity",t)})};const e=(t,i,a)=>{a.classList.toggle(t,i)};const o=t=>{dq(".custom-navbar").classList.toggle("dark",t);dq(".custom-navbar-settings").classList.toggle("dark",t)};return(()=>{if(isIframe()){return}n();const c=!(!a.some(t=>document.URL.includes(t))||s.some(t=>document.URL.includes(t)))||document.URL.includes("//www.bilibili.com/blackboard/bnj2020.html");if(c){document.body.classList.add("custom-navbar-loading");(async()=>{const a=await i.importAsync((()=>"customNavbarHtml")());document.body.insertAdjacentHTML("beforeend",a);addSettingsListener("useDarkStyle",o,true);const s=()=>dq(".custom-navbar");["Fill","Shadow","Compact","Blur"].forEach(t=>{const i="customNavbar"+t;addSettingsListener(i,i=>e(t.toLowerCase(),i,s()),true)});SpinQuery.condition(()=>dq("#banner_link,.international-header .bili-banner"),t=>t===null?false:Boolean(t.style.backgroundImage),i=>{Observer.attributes(i,()=>{const a=dqa(".custom-navbar .blur-layer");a.forEach(t=>{t.style.backgroundImage=i.style.backgroundImage;t.setAttribute("data-image",i.style.backgroundImage)});addSettingsListener("customNavbarTransparent",i=>{if(!t.hideBanner){s().classList.toggle("transparent",i)}},true);addSettingsListener("hideBanner",i=>{if(t.customNavbarTransparent){s().classList.toggle("transparent",!i)}})})});const{Blank:n}=await i.importAsync("custom-navbar-blank");const{Logo:c}=await i.importAsync("custom-navbar-logo");const{Category:r}=await i.importAsync("custom-navbar-category");const{SimpleLink:l}=await i.importAsync("custom-navbar-simple-link");const{UserInfo:m}=await i.importAsync("custom-navbar-user-info");const{SearchBox:b}=await i.importAsync("custom-navbar-search-box");const{Iframe:u}=await i.importAsync("custom-navbar-iframe");const d=[new n(1),new c,new r,new l("排行","https://www.bilibili.com/ranking","ranking"),new l("相簿","https://h.bilibili.com","drawing"),new l("音频","https://www.bilibili.com/audio/home/","music"),new u("游戏中心","https://game.bilibili.com/",{src:`https://www.bilibili.com/page-proxy/game-nav.html`,width:`680px`,height:`260px`,lazy:true,iframeName:"games"}),new u("直播","https://live.bilibili.com",{src:`https://live.bilibili.com/blackboard/dropdown-menu.html`,width:`528px`,height:`266px`,lazy:true,iframeName:"lives"}),new l("会员购","https://show.bilibili.com","shop"),new l("漫画","https://manga.bilibili.com","manga"),new n(2),new b,new m];if(getUID()){const{WatchlaterList:t}=await i.importAsync("custom-navbar-watchlater-list");const{Messages:a}=await i.importAsync("custom-navbar-messages");const{Activities:s}=await i.importAsync("custom-navbar-activities");const{Subscriptions:n}=await i.importAsync("custom-navbar-subscriptions");const{FavoritesList:e}=await i.importAsync("custom-navbar-favorites-list");const{HistoryList:o}=await i.importAsync("custom-navbar-history-list");d.push(new a,new n,new s,new t,new e,new o)}const{Upload:p}=await i.importAsync("custom-navbar-upload");d.push(new p,new n(3));new Vue({el:".custom-navbar",data:{components:d},methods:{async requestPopup(t){if(!t.requestedPopup&&!t.disabled&&!t.active){this.$set(t,`requestedPopup`,true);if(t.initialPopup){t.initialPopup()}}if(t.onPopup){t.onPopup()}}},mounted(){document.body.classList.remove("custom-navbar-loading");const t=()=>{d.forEach(t=>t.checkPosition())};addSettingsListener("customNavbarOrder",t,true);addSettingsListener("customNavbarHidden",t);addSettingsListener("customNavbarBoundsPadding",t);window.addEventListener("resize",t)}})})()}return{widget:{content:`\n<div class="gui-settings-flat-button" id="custom-navbar-settings">\n<i class="mdi mdi-24px mdi-auto-fix"></i>\n<span>顶栏布局</span>\n</div>`,condition:()=>c,success:async()=>{const{initSettingsPanel:t}=await i.importAsync("custom-navbar-settings");await t()}},unload:()=>{const t=dqa(".custom-navbar,.custom-navbar-settings");t.forEach(t=>t.style.display="none");i.removeStyle("customNavbarStyle")},reload:()=>{const t=dqa(".custom-navbar,.custom-navbar-settings");t.forEach(t=>t.style.display="flex");i.applyImportantStyle("customNavbarStyle")}}})()}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-activities.min.js"] = (()=>{return(t,i)=>{const{NavbarComponent:a}=i.import("custom-navbar-component");let e=async()=>{};let n=async()=>{};let c;const s=({dataObject:t,apiUrl:a,name:n,handleJson:c,template:s})=>{return{template:s,components:{"dpi-img":()=>i.importAsync("dpi-img.vue")},methods:{handleJson:c,async fetchData(t=false){try{const i=await Ajax.getJsonWithCredentials(a);if(i.code!==0){throw new Error(i.message)}await this.handleJson(i)}catch(i){if(t===true){return}logError(`加载${n}动态失败, error = ${i}`)}finally{this.loading=false}}},data(){return Object.assign({loading:true},t)},mounted(){this.fetchData();e=(async()=>await this.fetchData(true))},destroyed(){e=(async()=>{})}}};class r extends a{constructor(){super();this.boundingWidth=380;this.noPadding=true;this.href=t.oldTweets?"https://www.bilibili.com/account/dynamic":"https://t.bilibili.com/";this.html="动态";this.popupHtml=`\n<div class="activity-popup">\n<activity-tabs :tab.sync="selectedTab" :items="tabs"></activity-tabs>\n<div class="activity-popup-content">\n<transition name="activity-content" mode="out-in">\n<component :is="content"></component>\n</transition>\n          \x3c!-- <a class="view-more" target="_blank" :href="viewMoreUrl">查看更多<i class="mdi mdi-dots-horizontal-circle-outline"></i></a> --\x3e\n</div>\n</div>\n`;this.active=document.URL.replace(/\?.*$/,"")===this.href;this.initialPopup=(()=>{this.init()});this.onPopup=(()=>{this.setNotifyCount(0)});this.getNotifyCount();setInterval(async()=>{await this.getNotifyCount();await n();await e()},r.updateInterval)}static get updateInterval(){return 5*60*1e3}static getLatestID(){return document.cookie.replace(new RegExp(`(?:(?:^|.*;\\s*)bp_t_offset_${getUID()}\\s*\\=\\s*([^;]*).*$)|^.*$`),"$1")}static setLatestID(t){const i=r.getLatestID();if(r.compareID(t,i)<0){return}document.cookie=`bp_t_offset_${getUID()}=${t};path=/;domain=.bilibili.com;max-age=${60*60*24*30}`}static compareID(t,i){if(t===i){return 0}if(t.length>i.length){return 1}if(i.length>t.length){return-1}return t>i===true?1:-1}static isNewID(t){return r.compareID(t,c)>0}static updateLatestID(t){const[i]=[...t.map(t=>t.id)].sort(r.compareID).reverse();r.setLatestID(i)}async getNotifyCount(){const t=`https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_num?rsp_type=1&uid=${getUID()}&update_num_dy_id=${r.getLatestID()}&type_list=8,64,512`;const i=await Ajax.getJsonWithCredentials(t);if(i.code!==0){return}this.setNotifyCount(i.data.update_num)}async init(){Vue.component("activity-loading",{template:`\n<div v-if="loading" class="loading">\n<i class="mdi mdi-18px mdi-loading mdi-spin"></i>加载中...\n</div>`,props:["loading"]});Vue.component("activity-empty",{template:`\n<div class="empty">空空如也哦 =￣ω￣=</div>`});new Vue({el:await SpinQuery.select(".activity-popup"),data:{tabs:[{name:"视频",component:"video-activity",moreUrl:"https://t.bilibili.com/?tab=8",get notifyApi(){return`https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_num?rsp_type=1&uid=${getUID()}&update_num_dy_id=${r.getLatestID()}&type_list=8`},notifyCount:null},{name:"番剧",component:"bangumi-activity",moreUrl:"https://t.bilibili.com/?tab=512",get notifyApi(){return`https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_num?rsp_type=1&uid=${getUID()}&update_num_dy_id=${r.getLatestID()}&type_list=512`},notifyCount:null},{name:"专栏",component:"column-activity",moreUrl:"https://t.bilibili.com/?tab=64",get notifyApi(){return`https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_num?rsp_type=1&uid=${getUID()}&update_num_dy_id=${r.getLatestID()}&type_list=64`},notifyCount:null},{name:"直播",component:"live-activity",moreUrl:"https://link.bilibili.com/p/center/index#/user-center/follow/1",notifyCount:null}],selectedTab:"视频"},components:{"activity-tabs":{props:["items","tab"],template:`\n<ul class="activity-tabs">\n<li v-for="item of items" class="activity-tab" :data-count="item.notifyCount" :class="{selected: item.name === tab}" @click="changeTab(item)">\n<div class="tab-name">{{item.name}}</div>\n</li>\n<a class="view-all" target="_blank" href="${t.oldTweets?"https://www.bilibili.com/account/dynamic":"https://t.bilibili.com/"}">\n                全部动态\n<i class="custom-navbar-iconfont-new-home custom-navbar-icon-activity"></i>\n</a>\n</ul>\n`,methods:{changeTab(t){if(this.tab===t.name){window.open(t.moreUrl,"_blank")}this.$emit("update:tab",t.name)}}},"video-activity":Object.assign(s({dataObject:{leftCards:[],rightCards:[]},apiUrl:`https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=${getUID()}&type_list=8`,name:"视频",template:`\n<div class="video-activity" :class="{center: loading || (leftCards.length + rightCards.length) === 0}">\n<activity-loading :loading="loading"></activity-loading>\n<activity-empty v-if="!loading && leftCards.length + rightCards.length === 0"></activity-empty>\n<div v-if="!loading" class="video-activity-column">\n<video-card v-for="card of leftCards" :key="card.id" :card="card" :watchlaterInit="card.watchlater"></video-card>\n</div>\n<div v-if="!loading" class="video-activity-column">\n<video-card v-for="card of rightCards" :key="card.id" :card="card" :watchlaterInit="card.watchlater"></video-card>\n</div>\n</div>\n`,handleJson:async function(t){const i=t.data.cards.filter(t=>{return t.desc.orig_dy_id===0}).map(t=>{const i=JSON.parse(t.card);return{coverUrl:i.pic,title:i.title,timeNumber:i.duration,time:formatDuration(i.duration),description:i.desc,aid:i.aid,videoUrl:`https://www.bilibili.com/av${i.aid}`,faceUrl:t.desc.user_profile.info.face,upName:t.desc.user_profile.info.uname,upUrl:`https://space.bilibili.com/${t.desc.user_profile.info.uid}`,id:t.desc.dynamic_id_str,watchlater:true,get new(){return r.isNewID(this.id)}}});this.leftCards=i.filter((t,i)=>i%2===0);this.rightCards=i.filter((t,i)=>i%2===1);if(this.leftCards.length!==this.rightCards.length){this.leftCards.pop()}r.updateLatestID(i)}}),{components:{"video-card":{props:["card","watchlaterInit"],store:store,data(){return{}},computed:{...Vuex.mapState(["watchlaterList"]),watchlater(){if(this.watchlaterInit!==null){return this.watchlaterList.includes(this.card.aid)}else{return null}}},components:{"dpi-img":()=>i.importAsync("dpi-img.vue")},methods:{...Vuex.mapActions(["toggleWatchlater"])},async mounted(){},template:`\n<a class="video-activity-card" :class="{new: card.new}" target="_blank" :href="card.videoUrl">\n<div class="cover-container">\n<dpi-img class="cover" :size="{width: 172}" :src="card.coverUrl"></dpi-img>\n<div class="time">{{card.time}}</div>\n<div @click.stop.prevent="toggleWatchlater(card.aid)" class="watchlater"><i class="mdi" :class="{'mdi-clock-outline': !watchlater, 'mdi-check-circle': watchlater}"></i>{{watchlater ? '已添加' : '稍后再看'}}</div>\n</div>\n<h1 class="title" :title="card.title">{{card.title}}</h1>\n<a class="up" target="_blank" :href="card.upUrl" :title="card.upName">\n<dpi-img class="face" :size="24" :src="card.faceUrl"></dpi-img>\n<span class="name">{{card.upName}}</span>\n</a>\n</a>\n`}}}),"bangumi-activity":s({dataObject:{cards:[]},apiUrl:`https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=${getUID()}&type_list=512`,name:"番剧",template:`\n<div class="bangumi-activity" :class="{center: loading || cards.length === 0}">\n<activity-loading :loading="loading"></activity-loading>\n<activity-empty v-if="!loading && cards.length === 0"></activity-empty>\n<a v-if="!loading" class="bangumi-card" :class="{new: card.new}" v-for="card of cards" :key="card.id" target="_blank" :href="card.url">\n<dpi-img class="ep-cover" :size="{width: 100}" :src="card.epCoverUrl"></dpi-img>\n<h1 class="ep-title" :title="card.epTitle">{{card.epTitle}}</h1>\n<div class="up" :title="card.title">\n<dpi-img class="cover" :size="24" :src="card.coverUrl"></dpi-img>\n<div class="title">{{card.title}}</div>\n</div>\n</a>\n</div>\n`,handleJson:async function(t){this.cards=t.data.cards.map(t=>{const i=JSON.parse(t.card);return{title:i.apiSeasonInfo.title,coverUrl:i.apiSeasonInfo.cover,epCoverUrl:i.cover,epTitle:i.new_desc,url:i.url,id:t.desc.dynamic_id_str,get new(){return r.isNewID(this.id)}}});r.updateLatestID(this.cards)}}),"column-activity":s({dataObject:{cards:[]},apiUrl:`https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=${getUID()}&type_list=64`,name:"专栏",template:`\n<div class="column-activity" :class="{center: loading || cards.length === 0}">\n<activity-loading :loading="loading"></activity-loading>\n<activity-empty v-if="!loading && cards.length === 0"></activity-empty>\n<a v-if="!loading" class="column-card" :class="{new: card.new}" v-for="card of cards" :key="card.id" target="_blank" :href="card.url">\n<div class="covers">\n<dpi-img class="cover" v-for="cover of card.covers" :key="cover" :size="{height: 120}" :src="cover"></dpi-img>\n<a class="up" target="_blank" :href="card.upUrl">\n<dpi-img class="face" :size="24" :src="card.faceUrl"></dpi-img>\n<div class="name">{{card.upName}}</div>\n</a>\n</div>\n<h1 class="title" :title="card.title">{{card.title}}</h1>\n<div class="description" :title="card.description">{{card.description}}</div>\n</a>\n</div>\n`,handleJson:async function(t){this.cards=t.data.cards.map(t=>{const i=JSON.parse(t.card);return{covers:i.image_urls,originalCovers:i.origin_image_urls,upName:i.author.name,faceUrl:i.author.face,upUrl:`https://space.bilibili.com/${i.author.mid}`,title:i.title,description:i.summary,url:`https://www.bilibili.com/read/cv${i.id}`,id:t.desc.dynamic_id_str,get new(){return r.isNewID(this.id)}}});r.updateLatestID(this.cards)}}),"live-activity":s({dataObject:{cards:[]},apiUrl:`https://api.live.bilibili.com/relation/v1/feed/feed_list?page=1&pagesize=24`,name:"直播",template:`\n<div class="live-activity" :class="{center: loading || cards.length === 0}">\n<activity-loading :loading="loading"></activity-loading>\n<activity-empty v-if="!loading && cards.length === 0"></activity-empty>\n<a v-if="!loading" class="live-card" v-for="card of cards" :key="card.id" target="_blank" :href="card.url">\n<dpi-img class="face" :size="{width: 48}" :src="card.faceUrl"></dpi-img>\n<h1 class="live-title" :title="card.title">{{card.title}}</h1>\n<div class="name" :title="card.name">{{card.name}}</div>\n</a>\n</div>\n`,handleJson:async function(t){this.cards=t.data.list.map(t=>{return{faceUrl:t.face,title:t.title,name:t.uname,id:t.roomid,url:t.link}})}})},computed:{content(){return this.tabs.find(t=>t.name===this.selectedTab).component},viewMoreUrl(){return this.tabs.find(t=>t.name===this.selectedTab).moreUrl}},mounted(){n=(async()=>{for(const t of this.tabs){if(t.notifyApi){const i=await Ajax.getJsonWithCredentials(t.notifyApi);if(i.code!==0||!i.data.update_num||this.selectedTab===t.name){continue}t.notifyCount=i.data.update_num}}});n()},destroyed(){n=(async()=>{})},watch:{selectedTab(t){this.tabs.find(i=>i.name===t).notifyCount=null}}})}get name(){return"activities"}}c=r.getLatestID();return{export:{Activities:r}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-blank.min.js"] = (()=>{return(t,e)=>{const{NavbarComponent:n}=e.import("custom-navbar-component");class r extends n{constructor(t){super();this.number=t;this.flex="1 0 auto";this.disabled=true}get name(){return"blank"+this.number}}return{export:{Blank:r}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-category.min.js"] = (()=>{return(i,t)=>{const{NavbarComponent:l}=t.import("custom-navbar-component");class o extends l{constructor(){super();this.boundingWidth=366;this.href=`https://www.bilibili.com`;this.html=`主站`;this.popupHtml=`\n<ul id="custom-navbar-home-popup">\n<li class="category-item loading" v-if="loading">\n          加载中...\n</li>\n<li class="category-item" style="display: none" :style="{display: loading ? 'none' : 'list-item'}" v-for="item of info" :class="{ main: item[1].count }">\n<a :href="item[1].link">\n<svg aria-hidden="true">\n<use :href="'#header-icon-' + item[1].icon" :xlink:href="'#header-icon-' + item[1].icon"></use>\n</svg>\n<div>{{item[0]}}</div>\n<span>{{item[1].count}}</span>\n</a>\n<div class="popup" v-if="item[1].subRegions">\n<a v-for="region of Object.entries(item[1].subRegions)" :href="region[1]">\n              {{region[0]}}\n</a>\n</div>\n</li>\n</ul>\n`;const i=async()=>{const i=await Ajax.getJson("https://api.bilibili.com/x/web-interface/online");if(parseInt(i.code)!==0){throw new Error(`[自定义顶栏] 分区投稿信息获取失败: ${i.message}`)}const t=i.data.region_count;await SpinQuery.select("#custom-navbar-home-popup");return{"动画":{icon:"douga",count:t[1],link:`https://www.bilibili.com/v/douga/`,subRegions:{"MAD·AMV":`https://www.bilibili.com/v/douga/mad/`,"MMD·3D":`https://www.bilibili.com/v/douga/mmd/`,"短片·手书·配音":`https://www.bilibili.com/v/douga/voice/`,"综合":`https://www.bilibili.com/v/douga/other/`}},"番剧":{icon:"anime",count:t[13],link:`https://www.bilibili.com/anime/`,subRegions:{"连载动画":`https://www.bilibili.com/v/anime/serial/`,"完结动画":`https://www.bilibili.com/v/anime/finish/`,"资讯":`https://www.bilibili.com/v/anime/information/`,"官方延伸":`https://www.bilibili.com/v/anime/offical/`,"新番时间表":`https://www.bilibili.com/anime/timeline/`}},"国创":{icon:"guochuang",count:t[167],link:`https://www.bilibili.com/guochuang/`,subRegions:{"国产动画":`https://www.bilibili.com/v/guochuang/chinese/`,"国产原创相关":`https://www.bilibili.com/v/guochuang/original/`,"布袋戏":`https://www.bilibili.com/v/guochuang/puppetry/`,"资讯":`https://www.bilibili.com/v/guochuang/information/`,"新番时间表":`https://www.bilibili.com/guochuang/timeline/`,"国产动画索引":`https://www.bilibili.com/guochuang/index/`}},"音乐":{icon:"music",count:t[3],link:`https://www.bilibili.com/v/music/`,subRegions:{"原创音乐":"https://www.bilibili.com/v/music/original/","翻唱":"https://www.bilibili.com/v/music/cover/","VOCALOID·UTAU":"https://www.bilibili.com/v/music/vocaloid/","电音":"https://www.bilibili.com/v/music/electronic/","演奏":"https://www.bilibili.com/v/music/perform/",MV:"https://www.bilibili.com/v/music/mv/","音乐现场":"https://www.bilibili.com/v/music/live/","音乐综合":"https://www.bilibili.com/v/music/other/","音频":"https://www.bilibili.com/audio/home?musicType=music"}},"舞蹈":{icon:"dance",count:t[129],link:`https://www.bilibili.com/v/dance/`,subRegions:{"宅舞":"https://www.bilibili.com/v/dance/otaku/","三次元舞蹈":"https://www.bilibili.com/v/dance/three_d/","舞蹈教程":"https://www.bilibili.com/v/dance/demo/"}},"游戏":{icon:"game",count:t[4],link:`https://www.bilibili.com/v/game/`,subRegions:{"单机游戏":"https://www.bilibili.com/v/game/stand_alone/","电子竞技":"https://www.bilibili.com/v/game/esports/","手机游戏":"https://www.bilibili.com/v/game/mobile/","网络游戏":"https://www.bilibili.com/v/game/online/","桌游棋牌":"https://www.bilibili.com/v/game/board/",GMV:"https://www.bilibili.com/v/game/gmv/","音游":"https://www.bilibili.com/v/game/music/",Mugen:"https://www.bilibili.com/v/game/mugen/","游戏赛事":"https://www.bilibili.com/v/game/match/"}},"科技":{icon:"technology",count:t[36],link:`https://www.bilibili.com/v/technology/`,subRegions:{"趣味科普人文":"https://www.bilibili.com/v/technology/fun/","野生技术协会":"https://www.bilibili.com/v/technology/wild/","演讲·公开课":"https://www.bilibili.com/v/technology/speech_course/","星海":"https://www.bilibili.com/v/technology/military/","机械":"https://www.bilibili.com/v/technology/mechanical/","汽车":"https://www.bilibili.com/v/technology/automobile/"}},"数码":{icon:"digital",count:t[188],link:`https://www.bilibili.com/v/digital/`,subRegions:{"手机平板":"https://www.bilibili.com/v/digital/mobile/","电脑装机":"https://www.bilibili.com/v/digital/pc/","摄影摄像":"https://www.bilibili.com/v/digital/photography/","影音智能":"https://www.bilibili.com/v/digital/intelligence_av/"}},"生活":{icon:"life",count:t[160],link:`https://www.bilibili.com/v/life/`,subRegions:{"搞笑":"https://www.bilibili.com/v/life/funny/","日常":"https://www.bilibili.com/v/life/daily/","美食圈":"https://www.bilibili.com/v/life/food/","动物圈":"https://www.bilibili.com/v/life/animal/","手工":"https://www.bilibili.com/v/life/handmake/","绘画":"https://www.bilibili.com/v/life/painting/","运动":"https://www.bilibili.com/v/life/sports/","其他":"https://www.bilibili.com/v/life/other/"}},"鬼畜":{icon:"kichiku",count:t[119],link:`https://www.bilibili.com/v/kichiku/`,subRegions:{"鬼畜调教":"https://www.bilibili.com/v/kichiku/guide/","音MAD":"https://www.bilibili.com/v/kichiku/mad/","人力VOCALOID":"https://www.bilibili.com/v/kichiku/manual_vocaloid/","教程演示":"https://www.bilibili.com/v/kichiku/course/"}},"时尚":{icon:"fashion",count:t[155],link:`https://www.bilibili.com/v/fashion/`,subRegions:{"美妆":"https://www.bilibili.com/v/fashion/makeup/","服饰":"https://www.bilibili.com/v/fashion/clothing/","健身":"https://www.bilibili.com/v/fashion/aerobics/","T台":"https://www.bilibili.com/v/fashion/catwalk/","风尚标":"https://www.bilibili.com/v/fashion/trends/"}},"广告":{icon:"ad",count:t[165],link:`https://www.bilibili.com/v/ad/ad/`},"娱乐":{icon:"ent",count:t[5],link:`https://www.bilibili.com/v/ent/`,subRegions:{"综艺":"https://www.bilibili.com/v/ent/variety/","明星":"https://www.bilibili.com/v/ent/star/","Korea相关":"https://www.bilibili.com/v/ent/korea/"}},"影视":{icon:"cinephile",count:t[181],link:`https://www.bilibili.com/v/cinephile/`,subRegions:{"影视杂谈":"https://www.bilibili.com/v/cinephile/cinecism/","影视剪辑":"https://www.bilibili.com/v/cinephile/montage/","短片":"https://www.bilibili.com/v/cinephile/shortfilm/","预告·资讯":"https://www.bilibili.com/v/cinephile/trailer_info/","特摄":"https://www.bilibili.com/v/cinephile/tokusatsu/"}},"放映厅":{icon:"cinema",count:t[177]+t[23]+t[11],link:`https://www.bilibili.com/cinema/`,subRegions:{"纪录片":"https://www.bilibili.com/documentary/","电影":"https://www.bilibili.com/movie/","电视剧":"https://www.bilibili.com/tv/"}},"专栏":{icon:"read",count:``,link:`https://www.bilibili.com/read/home`},"直播":{icon:"zhibo",count:``,link:`https://live.bilibili.com`,subRegions:{"全部直播":"https://live.bilibili.com/all?visit_id=5icxsa0kmts0","游戏直播":"https://live.bilibili.com/p/eden/area-tags?parentAreaId=2&areaId=0&visit_id=5icxsa0kmts0#/2/0","手游直播":"https://live.bilibili.com/p/eden/area-tags?parentAreaId=3&areaId=0&visit_id=5icxsa0kmts0#/3/0","娱乐直播":"https://live.bilibili.com/p/eden/area-tags?parentAreaId=1&areaId=0&visit_id=5icxsa0kmts0#/1/0","电台直播":"https://live.bilibili.com/p/eden/area-tags?parentAreaId=5&areaId=0&visit_id=5icxsa0kmts0#/5/0","绘画直播":"https://live.bilibili.com/p/eden/area-tags?parentAreaId=4&areaId=0&visit_id=5icxsa0kmts0#/4/0"}},"小黑屋":{icon:"blackroom",count:``,link:`https://www.bilibili.com/blackroom/`},"专题":{icon:"topic",count:``,link:`https://www.bilibili.com/blackboard/topic_list.html`},"活动":{icon:"activit",count:``,link:`https://www.bilibili.com/blackboard/x/act_list`}}};this.initialPopup=(async()=>{new Vue({el:await SpinQuery.select("#custom-navbar-home-popup"),data:{info:[],loading:true},async mounted(){try{this.info=Object.entries(await i())}finally{this.loading=false}}})})}get name(){return"category"}}return{export:{Category:o}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-component.min.js"] = (()=>{return(t,n)=>{class e{constructor(n="",e="",s="0 0 auto",i=false,a=false,o=null,r=null,u=null,l=0,c=t.touchNavBar,h=false){this.html=n;this.popupHtml=e;this.flex=s;this.disabled=i;this.requestedPopup=a;this.initialPopup=o;this.onPopup=r;this.href=u;this.notifyCount=l;this.touch=c;this.active=h;this.noPadding=false;this.transparent=false;this.boundingWidth=0}get name(){return"blank1"}get order(){return t.customNavbarOrder[this.name]}get hidden(){return t.customNavbarHidden.includes(this.name)}get element(){return dq(`.custom-navbar li[data-name='${this.name}']`)}async setNotifyCount(t){const n=await SpinQuery.select(`.custom-navbar li[data-name='${this.name}'] .notify-count`);if(!n||!t){n.innerHTML="";return}n.innerHTML=t.toString()}async setNotifyStyle(t){const n=await SpinQuery.select(`.custom-navbar li[data-name='${this.name}'] .notify-count`);if(!n){return}const e={1:"number",2:"dot",3:"hidden"};n.classList.remove(...Object.values(e));n.classList.add(e[t])}async checkPosition(){if(this.boundingWidth===0){return}const t=this.element;const n=t.querySelector(".main-content ~ .popup-container");if(!n){return}const e=t.getBoundingClientRect();const s=e.left+e.width/2;const i=document.documentElement.clientWidth;const a=s-this.boundingWidth/2;const o=s+this.boundingWidth/2;if(a<0){n.style.transform=`translateX(${Math.abs(a)}px)`}else if(o>i){n.style.transform=`translateX(${-(o-i)}px)`}else{n.style.transform=""}}}return{export:{NavbarComponent:e}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-favorites-list.min.js"] = (()=>{return(t,i)=>{const{NavbarComponent:a}=i.import("custom-navbar-component");class e extends a{constructor(){super();this.boundingWidth=380;this.noPadding=true;this.href=`https://space.bilibili.com/${getUID()}/favlist`;this.html=`收藏`;this.active=document.URL.replace(/\?.*$/,"")===this.href;this.popupHtml=`\n<div class="favorites-list loading">\n<div class="loading-tip">\n          加载中...\n</div>\n<div class="content">\n<div class="header">\n<v-dropdown class="list-select" @change="changeList()" :round="true" :items="listNames" :value.sync="selectedListName">\n</v-dropdown>\n<div class="play-all-container">\n<a class="play-all" :href="playLink" title="播放全部" target="_blank">\n<i class="mdi mdi-play"></i>\n</a>\n</div>\n<a class="more-info" :href="moreLink" title="查看更多" target="_blank">\n              查看更多\n<i class="mdi mdi-dots-horizontal"></i>\n</a>\n</div>\n<transition-group name="cards" tag="div" class="cards">\n<div class="empty-tip" v-if="!cardsLoading && cards.length === 0" key="empty-tip">\n              空空如也哦 =￣ω￣=\n</div>\n<div class="favorite-card" v-for="card of cards" :key="card.id">\n<a class="cover-container" target="_blank" :href="'https://www.bilibili.com/video/av' + card.aid">\n<dpi-img class="cover" :src="card.coverUrl" :size="{width: 130, height: 85}"></dpi-img>\n<div class="floating duration">{{card.durationText}}</div>\n<div class="floating favorite-time">{{card.favoriteTime | formatDate}}</div>\n</a>\n<a class="title" target="_blank" :href="'https://www.bilibili.com/video/av' + card.aid" :title="card.title">{{card.title}}</a>\n<a class="up" target="_blank" :href="'https://space.bilibili.com/' + card.upID" :title="card.upName">\n<dpi-img class="face" :src="card.upFaceUrl" :size="20"></dpi-img>\n<div class="name">{{card.upName}}</div>\n</a>\n</div>\n<div class="loading-tip" v-if="cardsLoading" key="loading-tip">\n              加载中...\n</div>\n</transition-group>\n</div>\n</div>\n`;this.initialPopup=(()=>this.init())}get name(){return"favoritesList"}async init(){new Vue({el:await SpinQuery.select(`.custom-navbar [data-name="${this.name}"] .favorites-list`),store:store,filters:{formatDate(t){return`${t.getFullYear()}-${(t.getMonth()+1).toString().padStart(2,"0")}-${t.getDate().toString().padStart(2,"0")}`}},components:{DpiImg:()=>i.importAsync("dpi-img.vue"),VDropdown:()=>i.importAsync("v-dropdown.vue")},data:{list:[],cards:[],selectedListName:"",cardsLoading:true,cardsPage:1},computed:{listNames(){return this.list.map(t=>t.name)},selectedListId(){const t=this.list.find(t=>t.name===this.selectedListName);return t?t.id:0},moreLink(){const t=this.selectedListId;if(t===0){return`https://space.bilibili.com/${getUID()}/favlist`}return`https://space.bilibili.com/${getUID()}/favlist?fid=${t}`},playLink(){const t=this.selectedListId;if(t===0){return undefined}return`https://www.bilibili.com/medialist/play/ml${t}`}},methods:{async getCards(){const t=`https://api.bilibili.com/medialist/gateway/base/spaceDetail?media_id=${this.selectedListId}&pn=${this.cardsPage}&ps=20`;const i=await Ajax.getJsonWithCredentials(t);if(i.code!==0){throw new Error(`加载收藏夹内容失败: ${i.message}`)}if(!i.data.medias){return[]}return i.data.medias.filter(t=>{return t.attr!==9}).map(t=>{return{id:t.id,aid:t.id,coverUrl:t.cover.replace("http:","https:"),favoriteTimestamp:t.fav_time*1e3,favoriteTime:new Date(t.fav_time*1e3),title:t.title,description:t.intro,duration:t.duration,durationText:formatDuration(t.duration),playCount:t.cnt_info.play,danmakuCount:t.cnt_info.danmaku,upName:t.upper.name,upFaceUrl:t.upper.face.replace("http:","https:"),upID:t.upper.mid}})},async changeList(){try{this.cards=[];this.cardsPage=1;this.cardsLoading=true;this.cards=await this.getCards();this.setInfiniteScroll()}catch(t){logError(t)}finally{this.cardsLoading=false}},async loadNextPage(){try{this.cardsLoading=true;this.cardsPage++;const t=await this.getCards();this.cards.push(...t);if(t.length>0){this.setInfiniteScroll()}}catch(t){logError(t)}finally{this.cardsLoading=false}},setInfiniteScroll(){const t=this.$el.querySelector(".cards");const i=_.debounce(()=>{if(t.scrollTop+t.clientHeight>=t.scrollHeight-48){t.removeEventListener("scroll",i);this.loadNextPage()}},200);t.addEventListener("scroll",i)}},async mounted(){try{const t=`https://api.bilibili.com/medialist/gateway/base/created?pn=1&ps=100&up_mid=${getUID()}&is_space=0`;const i=await Ajax.getJsonWithCredentials(t);if(i.code!==0){throw new Error(`获取收藏夹列表失败: ${i.message}`)}this.list=i.data.list.map(t=>{return{id:t.id,name:t.title,count:t.media_count}});if(this.list.length>0){this.selectedListName=this.list[0].name;this.changeList()}}catch(t){logError(t)}finally{this.$el.classList.remove("loading")}}})}}return{export:{FavoritesList:e}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-history-list.min.js"] = (()=>{return(t,e)=>{const{NavbarComponent:i}=e.import("custom-navbar-component");const n=()=>{const t=new Date;const e=Number(new Date(t.getFullYear(),t.getMonth(),t.getDate()));const i=24*36e5;const n=e-i;const s=e-7*i;return{now:t,today:e,oneDay:i,yesterday:n,lastWeek:s}};const s=t=>{const{today:e,yesterday:i,lastWeek:s}=n();const a=_.groupBy(t,t=>{if(t.timestamp>=e){return"今天"}if(t.timestamp>=i){return"昨天"}if(t.timestamp>=s){return"本周"}return"更早"});return Object.entries(a).map(([t,e])=>{return{name:t,items:e}})};const a=t=>{const{yesterday:e}=n();const i=Number(t);if(i>=e){return`${t.getHours().toString().padStart(2,"0")}:${t.getMinutes().toString().padStart(2,"0")}`}return`${(t.getMonth()+1).toString().padStart(2,"0")}-${t.getDate().toString().padStart(2,"0")} ${t.getHours().toString().padStart(2,"0")}:${t.getMinutes().toString().padStart(2,"0")}`};const r=[{name:"视频",type:"video",api:"https://api.bilibili.com/x/web-interface/history/cursor?type=archive&ps=30",moreLink:"https://www.bilibili.com/account/history",getTimeline:t=>{const e=t.data.list;const i=e.map(t=>{const e=t.view_at*1e3;const i=Boolean(t.uri);const n=t.progress>0?`t=${t.progress}`:"t=0";const s=t.progress===-1?1:t.progress/t.duration;const r={isBangumi:i,id:t.kid,title:t.title,coverUrl:t.cover,upName:t.author_name||t.show_title,upID:t.author_mid||t.kid,href:i?t.uri+`?${n}`:`https://www.bilibili.com/video/av${t.kid}?p=${t.history.page}&${n}`,duration:t.duration,durationText:formatDuration(t.duration),progress:s,progressText:fixed(s*100,1)+"%",timestamp:e,time:new Date(e)};r.timeText=a(r.time);return r});return s(i)}},{name:"专栏",type:"article",api:"https://api.bilibili.com/x/web-interface/history/cursor?type=article&ps=30",moreLink:"",getTimeline:t=>{const e=t.data.list;const i=e.map(t=>{const e=t.view_at*1e3;const i=t.history.cid||t.kid;const n={id:i,title:t.title,coverUrl:t.covers[0],upName:t.author_name,upID:t.author_mid,href:`https://www.bilibili.com/read/cv${i}`,timestamp:e,time:new Date(e)};n.timeText=a(n.time);return n});return s(i)}},{name:"直播",type:"live",api:"https://api.live.bilibili.com/xlive/web-ucenter/v1/history/get_history_by_uid",moreLink:"https://link.bilibili.com/p/center/index#/user-center/view-history/live",getTimeline:t=>{const e=t.data.list;const i=e.map(t=>{return{id:t.roomid,href:`https://live.bilibili.com/${t.roomid}`,upID:t.uid,upName:t.uname,coverUrl:t.user_cover,title:t.title}});return[{name:"最近观看",items:i}]}}];class o extends i{constructor(){super();this.boundingWidth=350;this.noPadding=true;this.href=`https://www.bilibili.com/account/history`;this.html=`历史`;this.active=document.URL.replace(/\?.*$/,"")===this.href;this.popupHtml=`\n<div class="history-list loading">\n<div class="loading-tip">\n          加载中...\n</div>\n<div class="content">\n<div class="header">\n<div class="tabs">\n<div class="tab" v-for="tab of tabs" :class="{active: selectedTab === tab}" @click="selectedTab = tab">\n<div class="tab-name">{{tab.name}}</div>\n</div>\n</div>\n<button class="more-info" :disabled="!selectedTab.moreLink || null" @click="viewMore()" title="查看更多">\n              查看更多\n<i class="mdi mdi-dots-horizontal"></i>\n</button>\n</div>\n<transition-group name="history-content" tag="div" class="history-content">\n<div class="empty-tip" v-if="!timelineLoading && timeline.length === 0" key="empty-tip">\n              空空如也哦 =￣ω￣=\n</div>\n<div class="loading-tip" v-if="timelineLoading" key="loading-tip">\n              加载中...\n</div>\n<div class="time-group" v-for="t of timeline" :key="t.name">\n<div class="time-group-name">{{t.name}}</div>\n<transition-group name="time-group" tag="div" class="time-group-items">\n<div class="time-group-item" v-for="h of t.items" :key="h.id">\n<a class="cover-container" target="_blank" :href="h.href">\n<dpi-img class="cover" :src="h.coverUrl" :size="{width: 160, height: 110}" placeholder-image></dpi-img>\n<div v-if="h.progress" class="progress" :style="{width: h.progress * 100 + '%'}"></div>\n<div v-if="h.progressText" class="floating progress-number">{{h.progress >= 1 ? '已看完' : h.progressText}}</div>\n<div v-if="h.durationText" class="floating duration">{{h.durationText}}</div>\n</a>\n<a class="title" target="_blank" :href="h.href" :title="h.title">\n                    {{h.title || h.upName + '的直播间'}}\n</a>\n<a class="up" target="_blank" :href="h.isBangumi ? h.href : 'https://space.bilibili.com/' + h.upID" :title="h.upName">\n                    \x3c!--<icon type="extended" icon="up"></icon>--\x3e\n<div class="up-name">{{h.upName}}</div>\n</a>\n<div v-if="h.timeText" class="time" :title="h.time.toLocaleString()">\n                    {{h.timeText}}\n</div>\n</div>\n</transition-group>\n</div>\n</transition-group>\n</div>\n</div>\n`;this.initialPopup=(()=>this.init())}get name(){return"historyList"}async init(){new Vue({el:await SpinQuery.select(`.custom-navbar [data-name="${this.name}"] .history-list`),store:store,components:{DpiImg:()=>e.importAsync("dpi-img.vue"),Icon:()=>e.importAsync("icon.vue")},data:{tabs:r,selectedTab:r[0],timeline:[],timelineLoading:true},methods:{async updateTimeline(){try{this.timelineLoading=true;this.timeline=[];const t=this.selectedTab;const e=await Ajax.getJsonWithCredentials(t.api);if(e.code!==0){throw new Error(`加载历史记录失败: ${e.message}`)}this.timeline=t.getTimeline(e)}catch(t){logError(t)}finally{this.timelineLoading=false}},viewMore(){const t=this.selectedTab;if(t.moreLink){open(t.moreLink,"_blank")}}},watch:{selectedTab(){this.updateTimeline()}},async created(){this.updateTimeline()},async mounted(){this.$el.classList.remove("loading")}})}}return{export:{HistoryList:o}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-iframe.min.js"] = (()=>{return(t,e)=>{const{NavbarComponent:r}=e.import("custom-navbar-component");class s extends r{constructor(t,e,r){super();const{src:s,width:a,height:i,lazy:n,iframeName:h}=r;this.boundingWidth=parseInt(a);this.iframeName=h;this.html=t;this.href=e;this.popupHtml=`\n<iframe src='${s}' frameborder='0' width='${a}' height='${i}'></iframe>\n`;this.noPadding=true;this.requestedPopup=n?false:true;this.touch=false;this.transparent=true}get name(){return this.iframeName+"Iframe"}}return{export:{Iframe:s}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-logo.min.js"] = (()=>{return(t,o)=>{const{NavbarComponent:s}=o.import("custom-navbar-component");class e extends s{constructor(){super();this.href=`https://www.bilibili.com/`;this.touch=false;addSettingsListener("customNavbarSeasonLogo",()=>this.getLogo(),true)}async getLogo(){if(t.customNavbarSeasonLogo){const t=await Ajax.getJson("https://api.bilibili.com/x/web-show/res/locs?pf=0&ids=142");if(t.code===0){this.html=`<img height="38" src="${t.data[142][0].litpic.replace("http:","https:")}">`;return}}this.html=`<i class="custom-navbar-iconfont custom-navbar-icon-logo"></i>`}get name(){return"logo"}}return{export:{Logo:e}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-messages.min.js"] = (()=>{return(t,e)=>{const{NavbarComponent:a}=e.import("custom-navbar-component");class i extends a{constructor(){super();this.href="https://message.bilibili.com/";this.html="消息";this.popupHtml=`\n<ul id="message-list">\n<li><a data-name="reply" target="_blank" href="https://message.bilibili.com/#/reply">回复我的</a></li>\n<li><a data-name="at" target="_blank" href="https://message.bilibili.com/#/at">@我的</a></li>\n<li><a data-name="like" target="_blank" href="https://message.bilibili.com/#/love">收到的赞</a></li>\n<li><a data-name="user_msg" target="_blank" href="https://message.bilibili.com/#/whisper">我的消息</a></li>\n<li><a data-name="sys_msg" target="_blank" href="https://message.bilibili.com/#/system">系统通知</a></li>\n</ul>\n`;this.requestedPopup=true;this.active=document.URL.startsWith("https://message.bilibili.com/");this.fetchSettings().then(t=>{if(t){this.init()}})}get name(){return"messages"}async fetchSettings(){const t=await Ajax.getJsonWithCredentials(`https://api.vc.bilibili.com/link_setting/v1/link_setting/get?msg_notify=1`);if(t.code!==0){return}await this.setNotifyStyle(t.data.msg_notify);return t.data.msg_notify!==3}async init(){const t=await Ajax.getJsonWithCredentials(`https://api.bilibili.com/x/msgfeed/unread`);const e=await Ajax.getJsonWithCredentials(`https://api.vc.bilibili.com/session_svr/v1/session_svr/single_unread`);const a=await SpinQuery.select("#message-list");const i=[...a.querySelectorAll("a[data-name]")];const s=i.map(t=>t.getAttribute("data-name"));if(t.code!==0||e.code!==0){return}t.data["user_msg"]=e.data.unfollow_unread+e.data.follow_unread;let n=s.reduce((e,a)=>e+t.data[a],0);if(!n){return}await this.setNotifyCount(n);s.forEach((e,a)=>{const s=t.data[e];if(s>0){i[a].setAttribute("data-count",s.toString())}else{i[a].removeAttribute("data-count")}});i.forEach(t=>{t.addEventListener("click",()=>{const e=parseInt(t.getAttribute("data-count"));t.removeAttribute("data-count");n-=e;this.setNotifyCount(n)})})}}return{export:{Messages:i}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-search-box.min.js"] = (()=>{return(e,t)=>{const{NavbarComponent:i}=t.import("custom-navbar-component");const s=new class{getAll(){const e=localStorage.getItem("search_history");if(!e){return[]}return JSON.parse(e).map(e=>{return{keyword:e.value,date:new Date(e.timestamp).toJSON(),count:1}})}saveAll(e){localStorage.setItem("search_history",JSON.stringify(e))}clear(){localStorage.setItem("search_history","[]")}merge(e){const t=this.getAll();return _.uniqBy(e.concat(t),e=>e.keyword).slice(0,10)}add(e){const t=this.getAll();const i=t.find(t=>t.keyword===e.keyword);if(i){Object.assign(i,e)}else{t.push(e)}this.saveAll(t)}remove(e){const t=this.getAll();const i=t.findIndex(t=>t.keyword===e.keyword);if(i>-1){t.splice(i,1);this.saveAll(t)}}};const n=e=>{const t=e.match(/^av([\d]+)$/i);if(t){return{success:true,text:e,link:`https://www.bilibili.com/av${t[1]}`,aid:t[1],bvid:""}}const i=e.match(/^bv[\da-zA-Z]+$/i);if(i){return{success:true,text:e,link:`https://www.bilibili.com/${e.replace(/^bv/i,"BV")}`,aid:"",bvid:e.replace(/^bv/i,"BV")}}return{success:false,text:e,link:"",aid:"",bvid:""}};class a extends i{constructor(){super();this.disabled=true;this.html=`\n<form id="custom-navbar-search" autocomplete="off" target="_blank" method="get" action="https://search.bilibili.com/all">\n<input type="text" placeholder="搜索" name="keyword">\n<input type="hidden" name="from_source" value="banner_search">\n<a style="display: none" target="_blank" class="recommended-target"></a>\n<button type="submit" title="搜索" tabindex="-1">\n<svg style="width:22px;height:22px" viewBox="0 0 24 24">\n<path d="M9.5,3A6.5,6.5 0 0,1 16,9.5C16,11.11 15.41,12.59 14.44,13.73L14.71,14H15.5L20.5,19L19,20.5L14,15.5V14.71L13.73,14.44C12.59,15.41 11.11,16 9.5,16A6.5,6.5 0 0,1 3,9.5A6.5,6.5 0 0,1 9.5,3M9.5,5C7,5 5,7 5,9.5C5,12 7,14 9.5,14C12,14 14,12 14,9.5C14,7 12,5 9.5,5Z" />\n</svg>\n</button>\n</form>\n<div class="popup search-list" :class="{empty: items.length === 0}">\n<div\n          class="search-list-item"\n          tabindex="0"\n          v-for="(item, index) of items"\n          :title="isHistory ? item.html : ''"\n          @keydown.enter="submit(item.value)"\n          @keydown.shift.delete="deleteItem(item, index)"\n          @keydown.down.prevent="nextItem(index)"\n          @keydown.up.prevent="previousItem(index)">\n<div\n            @click.self="submit(item.value)"\n            class="search-list-item-text"\n            :title="item.value"\n            v-html="item.html"></div>\n<div\n            class="delete-history"\n            v-if="isHistory"\n            title="删除此项"\n            @click="deleteItem(item, index)">\n<i class="mdi mdi-18px mdi-close"></i>\n</div>\n</div>\n<div\n          class="search-list-item clear-history"\n          tabindex="0"\n          v-if="items.length > 0 && isHistory"\n          @click="clearSearchHistory()"\n          @keydown.enter="clearSearchHistory()"\n          @keydown.down.prevent="nextItem(items.length)"\n          @keydown.up.prevent="previousItem(items.length)">\n<i class="mdi mdi-18px mdi-delete-sweep"></i>\n          清除搜索历史\n</div>\n<div class="copy-tip" :class="{show: showCopyTip}">\n          已复制\n</div>\n</div>\n`;this.init()}async init(){const t=await SpinQuery.select("#custom-navbar-search");const i=t.querySelector("input[name='keyword']");t.addEventListener("submit",s=>{if(i.value===""){if(!e.hideTopSearch){t.querySelector(".recommended-target").click()}s.preventDefault();return false}const a=n(i.value);if(a.success){window.open(a.link,"_blank");s.preventDefault();return false}const r=e.searchHistory.find(e=>e.keyword===i.value);if(r){r.count++;r.date=(new Date).toJSON()}else{const t={count:1,keyword:i.value,date:(new Date).toJSON()};e.searchHistory.unshift(t)}e.searchHistory=e.searchHistory.slice(0,10);return true});if(!e.hideTopSearch){const e=await Ajax.getJson("https://api.bilibili.com/x/web-interface/search/default");if(e.code===0){i.setAttribute("placeholder",e.data.show_name);let s;if(e.data.url!==""){s=e.data.url}else if(e.data.name.startsWith("av")){s=`https://www.bilibili.com/${e.data.name}`}else{s=`https://search.bilibili.com/all?keyword=${e.data.name}`}t.querySelector(".recommended-target").setAttribute("href",s)}else{console.error("[自定义顶栏] 获取搜索推荐词失败")}}const s=new Vue({el:dq(".popup.search-list"),data:{items:[],isHistory:true,showCopyTip:false},methods:{closeCopyTip:_.debounce(function(){this.showCopyTip=false},2e3),copy(e){GM.setClipboard(e,"text");this.showCopyTip=true;this.closeCopyTip()},submit(e){if(n(e).success){this.copy(e)}else{i.value=e;t.submit();raiseEvent(t,"submit")}},nextItem(e){const t=dq(`.custom-navbar .search-list-item:nth-child(${e+2})`);if(t){t.focus()}},previousItem(e){const t=dq(`.custom-navbar .search-list-item:nth-child(${e})`);if(t){t.focus()}else{i.focus();return}},deleteItem(t,s){if(i.value!==""){return}const n=e.searchHistory.findIndex(e=>e.keyword===t.value);const[a]=e.searchHistory.splice(n,1);e.searchHistory=e.searchHistory;this.items.splice(s,1)},clearSearchHistory(){e.searchHistory=[];this.items=[]}}});let a="";const r=async()=>{const t=i.value;s.isHistory=t==="";const r=n(t);if(s.isHistory){s.items=e.searchHistory.sort((e,t)=>{const i=e.date?new Date(e.date):new Date(0);const s=t.date?new Date(t.date):new Date(0);return Number(s)-Number(i)}).map(e=>{return{value:e.keyword,html:e.keyword}}).slice(0,10)}else if(r.success){s.items=[];const e=r.aid?`https://api.bilibili.com/x/web-interface/view?aid=${r.aid}`:`https://api.bilibili.com/x/web-interface/view?bvid=${r.bvid}`;const t=await Ajax.getJson(e);if(r.aid){const e=_.get(t,"data.bvid",null);if(e!==null){s.items=[{value:e,html:`复制BV号: ${e}`}]}}else if(r.bvid){const e=_.get(t,"data.aid",null);if(e!==null){s.items=[{value:"av"+e,html:`复制AV号: av${e}`}]}}}else{const e=`https://s.search.bilibili.com/main/suggest?func=suggest&suggest_type=accurate&sub_type=tag&main_ver=v1&highlight=&userid=${getUID()}&bangumi_acc_num=1&special_acc_num=1&topic_acc_num=1&upuser_acc_num=3&tag_num=10&special_num=10&bangumi_num=10&upuser_num=3&term=${t}`;a=e;const i=await Ajax.getJson(e);if(i.code!==0||a!==e){return}const n=i.result.tag;if(n===undefined){s.items=[];return}s.items=n.map(e=>{return{value:e.value,html:e.name.replace(/suggest_high_light/g,"suggest-highlight")}})}};r();const c=_.debounce(r,200);let o=false;i.addEventListener("compositionstart",()=>o=true);i.addEventListener("compositionend",()=>{o=false;raiseEvent(i,"input")});i.addEventListener("input",()=>{if(!o){c()}});i.addEventListener("keydown",e=>{if(e.key==="ArrowDown"&&s.items.length>0){e.preventDefault();dq(".custom-navbar .search-list-item:first-child").focus()}})}get name(){return"search"}}return{export:{SearchBox:a}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-settings.min.js"] = (()=>{return(e,t)=>{const s=async()=>{await SpinQuery.select(".custom-navbar-settings");const{Slip:s}=await t.importAsync("slip");const r=dq("#custom-navbar-settings");r.addEventListener("click",async()=>{const e=dq(".custom-navbar-settings");if(e){e.classList.toggle("show");dq(".gui-settings-mask").click()}});r.addEventListener("mouseover",()=>{const t={blank1:"弹性空白1",logo:"Logo",category:"主站",rankingLink:"排行",drawingLink:"相簿",musicLink:"音频",gamesIframe:"游戏中心",livesIframe:"直播",shopLink:"会员购",mangaLink:"漫画",blank2:"弹性空白2",search:"搜索框",userInfo:"用户信息",messages:"消息",activities:"动态",bangumi:"订阅",watchlaterList:"稍后再看",favoritesList:"收藏",historyList:"历史",upload:"投稿入口",blank3:"弹性空白3"};Vue.component("order-item",{props:["item"],template:`\n<li @mouseenter="viewBorder(true)"\n            @mouseleave="viewBorder(false)"\n            :class="{hidden: hidden()}">\n<i class="mdi mdi-menu"></i>\n          {{item.displayName}}\n<button @click="toggleHidden()">\n<i v-if="hidden()" class="mdi mdi-eye-off"></i>\n<i v-else class="mdi mdi-eye"></i>\n</button>\n</li>\n`,methods:{hidden(){return e.customNavbarHidden.includes(this.item.name)},viewBorder(e){const t=dq(`.custom-navbar li[data-name='${this.item.name}']`);if(t!==null){t.classList.toggle("view-border",e)}},toggleHidden(){const t=this.hidden();if(t===false){e.customNavbarHidden.push(this.item.name)}else{const t=e.customNavbarHidden.indexOf(this.item.name);if(t===-1){return}e.customNavbarHidden.splice(t,1)}this.$forceUpdate();const s=dq(`.custom-navbar li[data-name='${this.item.name}']`);if(s!==null){s.style.display=t?"flex":"none"}e.customNavbarHidden=e.customNavbarHidden}}});const r=_.debounce(t=>{document.body.style.setProperty("--navbar-bounds-padding",`0 ${t}%`);e.customNavbarBoundsPadding=t},200);new Vue({el:".custom-navbar-settings",mounted(){const t=dq(".custom-navbar-settings .order-list");const r=({sourceItem:s,targetItem:r,orderBefore:a,orderAfter:n})=>{if(a===n){return}const i=Object.entries(e.customNavbarOrder).filter(([e])=>e in customNavbarDefaultOrders);const o=i.sort((e,t)=>e[1]-t[1]).map(e=>e[0]);if(a<n){for(let t=a+1;t<=n;t++){const s=o[t];e.customNavbarOrder[s]=t-1;const r=dq(`.custom-navbar li[data-name='${s}']`);r.style.order=(t-1).toString()}}else{for(let t=a-1;t>=n;t--){const s=o[t];e.customNavbarOrder[s]=t+1;const r=dq(`.custom-navbar li[data-name='${s}']`);r.style.order=(t+1).toString()}}e.customNavbarOrder[o[a]]=n;const d=dq(`.custom-navbar li[data-name='${o[a]}']`);d.style.order=n.toString();t.insertBefore(s,r);e.customNavbarOrder=e.customNavbarOrder};new s(t);t.addEventListener("slip:beforewait",e=>{if(e.target.classList.contains("mdi-menu")){e.preventDefault()}},false);t.addEventListener("slip:beforeswipe",e=>e.preventDefault(),false);t.addEventListener("slip:reorder",e=>{r({sourceItem:e.target,targetItem:e.detail.insertBefore,orderBefore:e.detail.originalIndex,orderAfter:e.detail.spliceIndex});return false},false)},computed:{orderList(){const s=Object.entries(e.customNavbarOrder);return s.filter(e=>e[0]in t).sort((e,t)=>e[1]-t[1]).map(e=>{return{displayName:t[e[0]],name:e[0],order:e[1]}})}},data:{boundsPadding:e.customNavbarBoundsPadding},watch:{boundsPadding(e){r(e)}},methods:{close(){dq(".custom-navbar-settings").classList.remove("show")},restoreDefault(){if(typeof customNavbarDefaultOrders==="undefined"){Toast.error("未找到默认值设定, 请更新您的脚本.","自定义顶栏",3e3);return}if(confirm("确定要恢复默认顶栏布局吗? 恢复后页面将刷新.")){this.boundsPadding=5;e.customNavbarOrder=customNavbarDefaultOrders;location.reload()}}}})},{once:true})};return{export:{initSettingsPanel:s}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-simple-link.min.js"] = (()=>{return(t,e)=>{const{NavbarComponent:n}=e.import("custom-navbar-component");class s extends n{constructor(t,e,n){super();this.linkName=n;this.html=t;this.href=e;this.touch=false;this.active=document.URL.startsWith(e)}get name(){return this.linkName+"Link"}}return{export:{SimpleLink:s}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-subscriptions.min.js"] = (()=>{return(i,s)=>{const{NavbarComponent:a}=s.import("custom-navbar-component");class t extends a{constructor(){super();this.boundingWidth=380;this.noPadding=true;const i=getUID();this.href=`https://space.bilibili.com/${i}/bangumi`;this.html="订阅";this.active=[`https://space.bilibili.com/${i}/bangumi`,`https://space.bilibili.com/${i}/cinema`,`https://space.bilibili.com/${i}/subs`].includes(document.URL.replace(/\?.*$/,""));this.popupHtml=`\n<div class="subscriptions">\n<ul class="subscriptions-tabs">\n<li class="tab" :class="{selected: bangumi}" @click="bangumi = true">追番</li>\n<li class="tab" :class="{selected: !bangumi}" @click="bangumi = false">追剧</li>\n<div class="tab-placeholder"></div>\n<a class="view-all" target="_blank" :href="'https://space.bilibili.com/${i}/' + (bangumi ? 'bangumi' : 'cinema')">\n          查看更多\n<i class="mdi mdi-dots-horizontal"></i>\n</a>\n</ul>\n<div class="content">\n<transition name="subscriptions-content" mode="out-in">\n<bangumi-subscriptions v-if="bangumi" type="bangumi" :key="'bangumi'"></bangumi-subscriptions>\n<bangumi-subscriptions v-else type="cinema" :key="'cinema'"></bangumi-subscriptions>\n</transition>\n</div>\n</div>`;this.initialPopup=(()=>{this.init()})}async init(){new Vue({el:await SpinQuery.select(".custom-navbar .subscriptions"),data:{bangumi:true},components:{"bangumi-subscriptions":{props:["type"],components:{"dpi-img":()=>s.importAsync("dpi-img.vue")},template:`\n<div class="bangumi-subscriptions" :class="{center: loading || !loading && cards.length === 0}">\n<div v-if="loading" class="loading">\n<i class="mdi mdi-18px mdi-loading mdi-spin"></i>\n                加载中...\n</div>\n<div v-if="!loading && cards.length === 0" class="empty">空空如也哦 =￣ω￣=</div>\n<a v-if="!loading" v-for="card of cards" :key="card.id" :href="card.playUrl" target="_blank" class="bangumi-subscriptions-card">\n<dpi-img class="cover" :src="card.coverUrl" :size="{height: 64}"></dpi-img>\n<div class="card-info">\n<h1 class="title" :title="card.title">{{card.title}}</h1>\n<div class="progress-row">\n<div v-if="card.progress" class="progress" :title="card.progress + ' | ' + card.latest">{{card.progress}} | {{card.latest}}</div>\n<div v-else class="progress" :title="card.latest">{{card.latest}}</div>\n<a class="info" :href="card.mediaUrl" target="_blank" title="详细信息">\n<i class="mdi mdi-information-outline"></i>\n</a>\n</div>\n</div>\n</a>\n</div>\n`,data(){return{loading:true,cards:[]}},async mounted(){try{const i=await Ajax.getJsonWithCredentials(`https://api.bilibili.com/x/space/bangumi/follow/list?type=${this.type!=="bangumi"?"2":"1"}&pn=1&ps=16&vmid=${getUID()}`);if(i.code!==0){logError(`加载订阅信息失败: ${i.message}`);return}this.cards=i.data.list.map(i=>{return{title:i.title,coverUrl:i.square_cover.replace("http:","https:"),latest:i.new_ep.index_show,progress:i.progress,id:i.season_id,playUrl:`https://www.bilibili.com/bangumi/play/ss${i.season_id}`,mediaUrl:`https://www.bilibili.com/bangumi/media/md${i.media_id}`}})}finally{this.loading=false}}}}})}get name(){return"bangumi"}}return{export:{Subscriptions:t}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-upload.min.js"] = (()=>{return(i,t)=>{const{NavbarComponent:e}=t.import("custom-navbar-component");class a extends e{constructor(){super();this.href="https://member.bilibili.com/v2#/upload/video/frame";this.html=`\n<svg style="width:16px;height:16px;padding:3px;box-sizing:content-box;" viewBox="0 0 785 886">\n<path d="M582,374L582,566C582,585.333 576.167,600.833 564.5,612.5C552.833,624.167 537.333,630 518,630L262,630C242.667,630 227.167,624.167 215.5,612.5C203.833,600.833 198,585.333 198,566L198,374L32,374C22,374 14.1667,371.167 8.5,365.5C2.83333,359.833 0,352 0,342C0,338.667 1.16666,334.5 3.5,329.5C5.83333,324.5 8.66666,320 12,316L371,9C377.667,3.00006 385.167,6.10352e-005 393.5,0C401.833,6.10352e-005 409.333,3.00006 416,9L774,316C780,322.667 783.333,330.167 784,338.5C784.667,346.833 783.333,354.333 780,361L764,370C760,372.667 754.667,374 748,374ZM70,758L710,758C729.333,758 744.833,763.833 756.5,775.5C768.167,787.167 774,802.667 774,822C774,841.333 768.167,856.833 756.5,868.5C744.833,880.167 729.333,886 710,886L70,886C50.6667,886 35.1667,880.167 23.5,868.5C11.8333,856.833 6,841.333 6,822C6,802.667 11.8333,787.167 23.5,775.5C35.1667,763.833 50.6667,758 70,758Z" />\n</svg>\n<div id="upload-button">投稿</div>`;this.popupHtml=`\n<ul id="upload-actions">\n<li><a target="_blank" href="https://member.bilibili.com/v2#/upload/text/apply">专栏投稿</a></li>\n<li><a target="_blank" href="https://member.bilibili.com/v2#/upload/audio/">音频投稿</a></li>\n<li><a target="_blank" href="https://member.bilibili.com/v2#/upload/video/frame">视频投稿</a></li>\n<li><a target="_blank" href="https://member.bilibili.com/v2#/upload-manager/article">投稿管理</a></li>\n<li><a target="_blank" href="https://member.bilibili.com/v2#/home">创作中心</a></li>\n</ul>\n`}get name(){return"upload"}}return{export:{Upload:a}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-user-info.min.js"] = (()=>{return(e,i)=>{const{NavbarComponent:n}=i.import("custom-navbar-component");class t extends n{constructor(){super();this.userInfo={mid:getUID(),isLogin:Boolean(getUID())};this.boundingWidth=240;this.noPadding=true;this.href="https://space.bilibili.com";this.html=`\n<div class="user-face-container">\n<img src='${EmptyImageUrl}' class="user-face"></img>\n<img src='${EmptyImageUrl}' class="user-pendant"></img>\n</div>\n`;this.popupHtml=`\n<div class="user-info-panel">\n<div v-if="isLogin" class="logged-in">\n<a class="name" target="_blank" href="https://space.bilibili.com/">{{uname}}</a>\n<a class="type" target="_blank" href="https://account.bilibili.com/account/big">{{userType}}</a>\n<div class="privileges row" v-if="this.vipType === 2">\n<div class="b-coin" :class="{received: privileges.bCoin.received}" @click="privilegeReceive(1)" :title="'有效期限: ' + privileges.bCoin.expire">\n              {{privileges.bCoin.received ? '已领取B币' : '领取B币'}}\n</div>\n<div class="coupons" :class="{received: privileges.coupons.received}" @click="privilegeReceive(2)" :title="'有效期限: ' + privileges.coupons.expire">\n              {{privileges.coupons.received ? '已领取优惠券' : '领取优惠券'}}\n</div>\n</div>\n<div class="level-info row">\n<a target="_blank" title="等级" href="https://account.bilibili.com/account/record"\n              class="level">\n<i class="custom-navbar-iconfont-extended" :class="'custom-navbar-icon-lv' + level_info.current_level"></i>\n</a>\n<span class="level-progress-label">{{level_info.current_exp}} / {{level_info.next_exp}}</span>\n</div>\n<div class="level-progress separator">\n<div class="level-progress-thumb" :style="levelProgressStyle"></div>\n</div>\n<div class="items">\n<a class="item" target="_blank" title="手机验证"\n              href="https://passport.bilibili.com/account/security#/bindphone">\n<i class="custom-navbar-iconfont-new-home custom-navbar-icon-bind-phone"></i>\n<i v-if="mobile_verified" class="custom-navbar-iconfont-new-home custom-navbar-icon-ok"></i>\n<i v-else class="custom-navbar-iconfont-new-home custom-navbar-icon-cancel"></i>\n</a>\n<a class="item" target="_blank" title="邮箱验证"\n              href="https://passport.bilibili.com/account/security#/bindmail">\n<i class="custom-navbar-iconfont-new-home custom-navbar-icon-bind-email"></i>\n<i v-if="email_verified" class="custom-navbar-iconfont-new-home custom-navbar-icon-ok"></i>\n<i v-else class="custom-navbar-iconfont-new-home custom-navbar-icon-cancel"></i>\n</a>\n<a class="item" target="_blank" href="https://account.bilibili.com/site/coin" title="硬币">\n<i class="custom-navbar-iconfont-new-home custom-navbar-icon-coin"></i>\n<span>{{money}}</span>\n</a>\n<a class="item" target="_blank" href="https://pay.bilibili.com/bb_balance.html" title="B币">\n<i class="custom-navbar-iconfont-new-home custom-navbar-icon-b-coin"></i>\n<span>{{wallet.bcoin_balance}}</span>\n</a>\n</div>\n<div class="separator"></div>\n<div class="stats">\n<a class="stats-item" :href="'https://space.bilibili.com/' + mid + '/fans/follow'" target="_blank">\n<div class="stats-number">{{following | count}}</div>\n              关注\n</a>\n<a class="stats-item" :href="'https://space.bilibili.com/' + mid + '/fans/fans'" target="_blank">\n<div class="stats-number">{{follower | count}}</div>\n              粉丝\n</a>\n<a class="stats-item" :href="'https://space.bilibili.com/' + mid + '/dynamic'" target="_blank">\n<div class="stats-number">{{dynamic_count | count}}</div>\n              动态\n</a>\n</div>\n<div class="separator"></div>\n<a class="operation" target="_blank" href="https://account.bilibili.com/account/home">\n<i class="icon custom-navbar-icon-profile custom-navbar-iconfont-new-home"></i>\n            个人中心\n</a>\n<a class="operation" target="_blank" href="https://member.bilibili.com/v2#/upload-manager/article">\n<i class="icon custom-navbar-icon-posts custom-navbar-iconfont-new-home"></i>\n            投稿管理\n</a>\n<a class="operation" target="_blank" href="https://pay.bilibili.com/">\n<i class="icon custom-navbar-icon-wallet custom-navbar-iconfont-new-home"></i>\n            B币钱包\n</a>\n<a class="operation" target="_blank" href="https://link.bilibili.com/p/center/index">\n<i class="icon custom-navbar-icon-live-center custom-navbar-iconfont-new-home"></i>\n            直播中心\n</a>\n<a class="operation" target="_blank" href="https://show.bilibili.com/orderlist">\n<i class="icon custom-navbar-icon-order-center custom-navbar-iconfont-new-home"></i>\n            订单中心\n</a>\n<a class="operation" target="_blank" href="https://www.bilibili.com/v/cheese/mine">\n<i class="icon custom-navbar-icon-course custom-navbar-iconfont-new-home"></i>\n            我的课程\n</a>\n<a class="logout grey-button" href="https://account.bilibili.com/login?act=exit">\n            退出登录\n</a>\n</div>\n<div v-else class="not-logged-in">\n<h1 class="welcome">欢迎来到 bilibili</h1>\n<a href="https://passport.bilibili.com/register/phone.html" class="signup grey-button">注册</a>\n<a href="https://passport.bilibili.com/login" class="login theme-button">登录</a>\n</div>\n</div>\n`;this.requestedPopup=true;this.init()}get name(){return"userInfo"}async init(){const e=await SpinQuery.select(".custom-navbar .user-info-panel");const i=await SpinQuery.select(".custom-navbar .user-face-container .user-face");const n=await Ajax.getJsonWithCredentials("https://api.bilibili.com/x/web-interface/nav");const t=await Ajax.getJsonWithCredentials("https://api.bilibili.com/x/web-interface/nav/stat");Object.assign(this.userInfo,n.data);Object.assign(this.userInfo,t.data);const s=new Vue({el:e,data:{...this.userInfo,privileges:{bCoin:{received:false,expire:""},coupons:{received:false,expire:""}}},filters:{count(e){return formatCount(e)}},computed:{userType(){if(!this.isLogin){return"未登录"}if(this.level_info.current_level===0){return"注册会员"}if(this.vipStatus===1){if(this.vipType===1){return this.vip_theme_type?"小会员":"大会员"}else if(this.vipType===2){return this.vip_theme_type?"年度小会员":"年度大会员"}}return"正式会员"},levelProgressStyle(){const e=(this.level_info.current_exp-this.level_info.current_min)/(this.level_info.next_exp-this.level_info.current_min);return{transform:`scaleX(${e})`}}},methods:{async privilegeReceive(e){const i={1:"bCoin",2:"coupons"};if(this.privileges[i[e]].received){return}this.privileges[i[e]].received=true;const n=getCsrf();const t=await(await fetch("https://api.bilibili.com/x/vip/privilege/receive",{credentials:"include",headers:{"content-type":"application/x-www-form-urlencoded"},body:`type=${e}&csrf=${n}`,method:"POST"})).json();console.log(t);if(t.code===0){if(i[e]==="bCoin"){this.wallet.bcoin_balance+=5}}else if(t.code===69801){return}else{this.privileges[i[e]].received=false;logError(t.message)}}}});if(this.userInfo.isLogin){const e=this.userInfo.face.replace("http","https");const n="//static.hdslb.com/images/member/noface.gif";if(!e.includes(n)){const n=68;i.setAttribute("srcset",getDpiSourceSet(e,n))}else{i.setAttribute("src",n)}if(this.userInfo.pendant.image){const e=await SpinQuery.select(".custom-navbar .user-face-container .user-pendant");const i=this.userInfo.pendant.image.replace("http","https");const n=116;e.setAttribute("srcset",getDpiSourceSet(i,n,"png"))}if(this.userInfo.vipType===2){const e=await Ajax.getJsonWithCredentials("https://api.bilibili.com/x/vip/privilege/my");if(e.code===0){const i=e.data.list.find(e=>e.type===1);s.privileges.bCoin.received=i.state===1;s.privileges.bCoin.expire=new Date(i.expire_time*1e3).toLocaleDateString();const n=e.data.list.find(e=>e.type===2);s.privileges.coupons.received=n.state===1;s.privileges.coupons.expire=new Date(n.expire_time*1e3).toLocaleDateString()}}}else{i.setAttribute("src","https://static.hdslb.com/images/akari.jpg")}}}return{export:{UserInfo:t}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-video-list.min.js"] = (()=>{return(t,i)=>{const{NavbarComponent:s}=i.import("custom-navbar-component");class e extends s{constructor({mainUrl:t,name:i,apiUrl:s,listName:e,listMap:a}){super();this.href=t;this.listName=e;this.html=i;this.noPadding=true;this.requestedPopup=false;this.popupHtml=`\n<ol class="video-list ${e}">\n<li class="loading">加载中...</li>\n</ol>\n`;this.initialPopup=(async()=>{if(!a){return}const l=await SpinQuery.select(`.video-list.${e}`);if(l===null){return}const r=await Ajax.getJsonWithCredentials(s);let n="";if(r.code!==0){logError(`加载${i}信息失败. 错误码: ${r.code} ${r.message}`)}else{n=a(r).join("")}l.insertAdjacentHTML("beforeend",n+`\n<li class="more"><a target="_blank" href="${t}">查看更多</a></li>\n`);l.classList.add("loaded")})}get name(){return this.listName+"List"}}class a extends e{constructor(){super({name:"收藏",mainUrl:`https://space.bilibili.com/${getUID()}/favlist`,apiUrl:"https://api.bilibili.com/medialist/gateway/coll/resource/recent",listName:"favorites",listMap:t=>{if(!t.data||t.data.length===0){return[`<li class="loading empty">空空如也哦 =￣ω￣=</li>`]}return t.data.map(t=>{return`\n<li>\n<a target="_blank" href="https://www.bilibili.com/video/av${t.id}">${t.title}</a>\n</li>`})}});this.active=document.URL.replace(/\?.*$/,"")===`https://space.bilibili.com/${getUID()}/favlist`}}class l extends e{constructor(){super({name:"历史",mainUrl:"https://www.bilibili.com/account/history",apiUrl:"https://api.bilibili.com/x/v2/history?pn=1&ps=6",listName:"history",listMap:t=>{if(!t.data||t.data.length===0){return[`<li class="loading empty">空空如也哦 =￣ω￣=</li>`]}return t.data.map(t=>{let i=[];let s="";const e=t.page?t.page.page:1;let a=t.progress>=0?t.progress/t.duration:1;if(isNaN(a)){a=0}if(e!==1){i.push(`p=${e}`);s+=`看到第${e}话`}if(t.progress>0&&t.progress<t.duration){i.push(`t=${t.progress}`);s+=` ${Math.floor(a*100)}%`}else if(t.progress===0){s+=` 刚开始看`}else{s+=" 100%"}return`\n<li class="history-item">\n<a target="_blank" href="https://www.bilibili.com/video/av${t.aid}?${i.join("&")}">\n<span class="title">${t.title}</span>\n<span class="description">${s}</span>\n<div class="progress background">\n<div class="progress foreground" style="--progress: ${a*100}%"></div>\n</div>\n</a>\n</li>`})}});this.active=document.URL.replace(/\?.*$/,"")==="https://www.bilibili.com/account/history"}}return{export:{FavoritesList:a,HistoryList:l}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-watchlater-list.min.js"] = (()=>{return(t,i)=>{const{NavbarComponent:a}=i.import("custom-navbar-component");class e extends a{constructor(){super();this.boundingWidth=380;this.noPadding=true;this.href="https://www.bilibili.com/watchlater/#/list";this.html="稍后再看";this.active=document.URL.startsWith("https://www.bilibili.com/watchlater/");this.popupHtml=`\n<div class="watchlater-list loading">\n<div class="loading-tip">\n          加载中...\n</div>\n<div class="empty-tip" v-if="filteredCards.length === 0">\n          空空如也哦 =￣ω￣=\n</div>\n<div class="header">\n          \x3c!--<div class="operations">\n<div v-if="!redirect" class="round-button" title="播放全部"><i class="mdi mdi-play-circle-outline"></i></div>\n<div class="round-button" title="移除已观看"><i class="mdi mdi-eye-check-outline"></i></div>\n<div class="round-button" title="清空全部"><i class="mdi mdi-trash-can-outline"></i></div>\n</div>--\x3e\n<div class="search">\n<input type="text" placeholder="搜索" v-model="search">\n</div>\n<a class="more-info" href="https://www.bilibili.com/watchlater/#/list" title="查看更多" target="_blank">\n            查看更多\n<i class="mdi mdi-dots-horizontal"></i>\n</a>\n</div>\n<transition-group name="cards" tag="div" class="cards">\n<div class="watchlater-card" v-for="(card, index) of filteredCards" :key="card.aid">\n<a class="cover-container" target="_blank" :href="card.href">\n<dpi-img class="cover" :src="card.coverUrl" :size="{width: 130, height: 85}"></dpi-img>\n<div class="floating remove" title="移除" @click.prevent="remove(card.aid, index)"><i class="mdi mdi-close"></i></div>\n<div class="floating duration">{{card.durationText}}</div>\n<div class="floating viewed" v-if="card.complete">\n                已观看\n</div>\n</a>\n<a class="title" target="_blank" :href="card.href" :title="card.title">{{card.title}}</a>\n<a class="up" target="_blank" :href="'https://space.bilibili.com/' + card.upID" :title="card.upName">\n<dpi-img class="face" :src="card.upFaceUrl" :size="20"></dpi-img>\n<div class="name">{{card.upName}}</div>\n</a>\n</div>\n</transition-group>\n        \x3c!--<div class="undo round-button">\n<i class="mdi mdi-undo-variant"></i>\n          撤销\n</div>--\x3e\n</div>\n`;this.initialPopup=(()=>{this.init()})}async init(){new Vue({el:await SpinQuery.select(`.custom-navbar [data-name="${this.name}"] .watchlater-list`),store:store,components:{DpiImg:()=>i.importAsync("dpi-img.vue")},data:{cards:[],filteredCards:[],search:"",lastRemovedAid:0},computed:{...Vuex.mapState(["watchlaterList"])},watch:{watchlaterList(){this.updateList()},search(){this.updateFilteredCards()}},methods:{...Vuex.mapActions(["toggleWatchlater"]),async updateList(){const{getWatchlaterList:a}=await i.importAsync("watchlater-api");const e=await a(true);if(!e){this.cards=[];return}const s=e.map(i=>{const a=(()=>{if(i.pages===undefined){return t.watchLaterRedirect?`https://www.bilibili.com/video/av${i.aid}`:`https://www.bilibili.com/watchlater/#/av${i.aid}`}const a=i.pages.map(t=>t.cid);const e=i.cid===0?1:a.indexOf(i.cid)+1;return t.watchLaterRedirect?`https://www.bilibili.com/video/av${i.aid}?p=${e}`:`https://www.bilibili.com/watchlater/#/av${i.aid}/p${e}`})();const e=Math.round(1e3*i.progress/i.duration)/1e3;return{aid:i.aid,href:a,coverUrl:i.pic.replace("http:","https:"),durationText:formatDuration(i.duration),duration:i.duration,complete:i.progress<0||e>.95,title:i.title,upName:i.owner.name,upFaceUrl:i.owner.face.replace("http:","https:"),upID:i.owner.mid}});this.cards=s;if(this.search){this.updateFilteredCards()}else{this.filteredCards=s}},async remove(t,i){this.cards.splice(i,1);await this.toggleWatchlater(t);this.lastRemovedAid=t},async undo(){const t=this.lastRemovedAid;if(t!==0){await this.toggleWatchlater(t)}},updateFilteredCards:_.debounce(function(){const t=this.search.toLowerCase();const i=this.$el.querySelector(".cards");i.scrollTo(0,0);this.filteredCards=this.cards.filter(i=>{return i.title.toLowerCase().includes(t)||i.upName.toLowerCase().includes(t)})},200)},async mounted(){try{await this.updateList()}finally{this.$el.classList.remove("loading")}}})}get name(){return"watchlaterList"}}return{export:{WatchlaterList:e}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/danmaku-converter.min.js"] = (()=>{return(t,e)=>{class r{constructor({content:t,time:e,type:r,fontSize:i,color:n}){this.content=t;this.time=e;this.startTime=parseFloat(e);this.type=parseInt(r);this.fontSize=parseFloat(i);this.color=parseInt(n)}}class i extends r{constructor({content:t,time:e,type:r,fontSize:i,color:n,timeStamp:a,pool:s,userHash:o,rowId:l}){super({content:t,time:e,type:r,fontSize:i,color:n});this.timeStamp=parseInt(a);this.pool=parseInt(s);this.userHash=o;this.rowId=parseInt(l);this.pDataArray=[e,r,i,n,a,s,o,l]}text(){const t=this.pDataArray.join(",");return`<d p="${t}">${this.content}</d>`}static parse(t){const e=t.getAttribute("p");const[r,n,a,s,o,l,c,h]=e.split(",");const u=t.innerHTML;return new i({content:u,time:r,type:n,fontSize:a,color:s,timeStamp:o,pool:l,userHash:c,rowId:h})}}class n{constructor(t){this.xml=t;const e=(new DOMParser).parseFromString(t,"application/xml").documentElement;this.danmakus=[...e.querySelectorAll("d[p]")].map(t=>i.parse(t))}}var a;(function(t){t[t["Normal"]=1]="Normal";t[t["Normal2"]=2]="Normal2";t[t["Normal3"]=3]="Normal3";t[t["Bottom"]=4]="Bottom";t[t["Top"]=5]="Top";t[t["Reversed"]=6]="Reversed";t[t["Special"]=7]="Special";t[t["Special2"]=8]="Special2"})(a||(a={}));class s extends r{constructor({content:t,time:e,type:r,fontSize:i,color:n,typeTag:a,colorTag:s,endTime:o}){super({content:t,time:e,type:r,fontSize:i,color:n});this.typeTag=a;this.colorTag=s;this.endTime=o}text(t){let e=t[this.fontSize];if(!e){e=t[25]}const r=t[this.fontSize].match(/Style:(.*?),/)[1].trim();return`Dialogue: 0,${this.time},${this.endTime},${r},,0,0,0,,{${this.typeTag}${this.colorTag}}${this.content}`}}class o{constructor(t,e,r,i,n){this.danmakus=t;this.title=e;this.fontStyles=r;this.blockTypes=i;this.resolution=n}generateAss(){const t=`\n[Script Info]\n; Script generated by Bilibili Evolved Danmaku Converter\n; https://github.com/the1812/Bilibili-Evolved/\nTitle: ${this.title}\nScriptType: v4.00+\nPlayResX: ${this.resolution.x}\nPlayResY: ${this.resolution.y}\nTimer: 10.0000\nWrapStyle: 2\nScaledBorderAndShadow: no\n\n[V4+ Styles]\nFormat: Name, Fontname, Fontsize, PrimaryColour, SecondaryColour, OutlineColour, BackColour, Bold, Italic, Underline, StrikeOut, ScaleX, ScaleY, Spacing, Angle, BorderStyle, Outline, Shadow, Alignment, MarginL, MarginR, MarginV, Encoding\n${Object.values(this.fontStyles).join("\n")}\n\n[Events]\nFormat: Layer, Start, End, Style, Name, MarginL, MarginR, MarginV, Effect, Text\n`.trim();return t+"\n"+this.danmakus.map(t=>t.text(this.fontStyles)).filter(t=>t!=="").join("\n")}}class l{constructor(t,e,r,i){this.horizontalStack=[];this.horizontalTrack=[];this.verticalStack=[];this.verticalTrack=[];this.resolution=e;this.duration=r;this.canvas=document.createElement("canvas");this.context=this.canvas.getContext("2d");this.fontSizes={30:`64px ${t}`,25:`52px ${t}`,18:`36px ${t}`,45:`90px ${t}`};this.bottomMarginPercent=i;this.generateTracks()}generateTracks(){const t=52;this.danmakuHeight=t;this.trackHeight=l.margin*2+t;this.trackCount=parseInt(fixed(this.resolution.y*(1-this.bottomMarginPercent)/this.trackHeight,0))}getTextSize(t){this.context.font=this.fontSizes[t.fontSize];const e=this.context.measureText(t.content);const r=e.width/2;return[r,this.danmakuHeight/2]}getTags(t,{targetTrack:e,initTrackNumber:r,nextTrackNumber:i,willOverlay:n,getTrackItem:a,getTag:s}){const[o,c]=this.getTextSize(t);const h=o*2;const u=this.duration(t)*h/(this.resolution.x+h)+l.nextDanmakuDelay;let m=r;let p=null;do{p=e.find(t=>n(t,m,h));m+=i}while(p&&m<=this.trackCount&&m>=0);if(m>this.trackCount||m<0){return`\\pos(0,-999)`}m-=i;e.push(a(m,h,u));return s({trackNumber:m,x:o,y:c})}getHorizontalTags(t){return this.getTags(t,{targetTrack:this.horizontalTrack,initTrackNumber:0,nextTrackNumber:1,willOverlay:(e,r,i)=>{if(e.trackNumber!==r){return false}if(e.width<i){return this.duration(t)*this.resolution.x/(this.resolution.x+i)<=e.end-t.startTime}else{return e.visible>t.startTime}},getTrackItem:(e,r,i)=>{return{width:r,start:t.startTime,visible:t.startTime+i,end:t.startTime+this.duration(t),trackNumber:e}},getTag:({trackNumber:e,x:r,y:i})=>{return`\\move(${this.resolution.x+r},${e*this.trackHeight+l.margin+i},${-r},${e*this.trackHeight+l.margin+i},0,${this.duration(t)*1e3})`}})}getVerticalTags(t){const e=l.danmakuType[t.type]==="top";return this.getTags(t,{targetTrack:this.verticalTrack,initTrackNumber:e?0:this.trackCount-1,nextTrackNumber:e?1:-1,willOverlay:(e,r)=>{if(e.trackNumber!==r){return false}return e.end>t.startTime},getTrackItem:e=>{return{start:t.startTime,end:t.startTime+this.duration(t),trackNumber:e}},getTag:({trackNumber:t,y:r})=>{if(e){return`\\pos(${this.resolution.x/2},${t*this.trackHeight+l.margin+r})`}else{return`\\pos(${this.resolution.x/2},${this.resolution.y-l.margin-r-(this.trackCount-1-t)*this.trackHeight})`}}})}push(t){let e="";let r=[];switch(l.danmakuType[t.type]){case"normal":case"reversed":{e=this.getHorizontalTags(t);r=this.horizontalStack;break}case"top":case"bottom":{e=this.getVerticalTags(t);r=this.verticalStack;break}case"special":default:{return{tags:`\\pos(0,-999)`}}}const i={tags:e};r.push(i);return i}}l.danmakuType={[a.Normal]:"normal",[a.Normal2]:"normal",[a.Normal3]:"normal",[a.Bottom]:"bottom",[a.Top]:"top",[a.Reversed]:"reversed",[a.Special]:"special",[a.Special2]:"special"};l.margin=4;l.nextDanmakuDelay=.05;class c{constructor({title:t,font:e,alpha:r,duration:i,blockTypes:n,resolution:a,bottomMarginPercent:s,bold:o}){this.title=t;this.font=e;this.alpha=Math.round(r*255).toString(16).toUpperCase().padStart(2,"0");this.duration=i;this.blockTypes=n;this.resolution=a;this.bold=o;this.danmakuStack=new l(e,a,i,s)}get fontStyles(){return{30:`Style: Large,${this.font},64,&H${this.alpha}FFFFFF,&H${this.alpha}FFFFFF,&H${this.alpha}000000,&H${this.alpha}000000,${this.bold?"1":"0"},0,0,0,100,100,0,0,1,1.2,0,5,0,0,0,0`,25:`Style: Medium,${this.font},52,&H${this.alpha}FFFFFF,&H${this.alpha}FFFFFF,&H${this.alpha}000000,&H${this.alpha}000000,${this.bold?"1":"0"},0,0,0,100,100,0,0,1,1.2,0,5,0,0,0,0`,18:`Style: Small,${this.font},36,&H${this.alpha}FFFFFF,&H${this.alpha}FFFFFF,&H${this.alpha}000000,&H${this.alpha}000000,${this.bold?"1":"0"},0,0,0,100,100,0,0,1,1.2,0,5,0,0,0,0`,45:`Style: ExtraLarge,${this.font},90,&H${this.alpha}FFFFFF,&H${this.alpha}FFFFFF,&H${this.alpha}000000,&H${this.alpha}000000,${this.bold?"1":"0"},0,0,0,100,100,0,0,1,1.2,0,5,0,0,0,0`}}convertToAssDocument(t){const e=new n(t);const r=[];for(const t of e.danmakus.sort((t,e)=>t.startTime-e.startTime)){if(this.blockTypes.indexOf(t.type)!==-1||this.blockTypes.indexOf("color")!==-1&&t.color!==c.white){continue}const[e,i]=this.convertTime(t.startTime,this.duration(t));r.push(new s({content:this.convertText(t.content),time:e,endTime:i,type:t.type.valueOf().toString(),fontSize:t.fontSize.toString(),color:t.color.toString(),typeTag:this.convertType(t),colorTag:this.convertColor(t.color)}))}return new o(r,this.title,this.fontStyles,this.blockTypes,this.resolution)}convertText(t){const e={"{":"｛","}":"｝","&amp;":"&","&lt;":"<","&gt;":">","&quot;":'"',"&apos;":"'"};for(const[r,i]of Object.entries(e)){t=t.replace(new RegExp(r,"g"),i)}return t}convertType(t){return this.danmakuStack.push(t).tags}convertColor(t){if(t===c.white){return""}const e=t.toString(16);const r=e.substring(0,2);const i=e.substring(2,4);const n=e.substring(4,6);return`\\c&H${n}${i}${r}&`}convertTime(t,e){function r(t){const[e,r="00"]=String(t).split(".");return`${e.padStart(2,"0")}.${r.substr(0,2).padEnd(2,"0")}`}function i(t){let e=0;let i=0;while(t>=60){t-=60;i++}while(i>=60){i-=60;e++}return`${e}:${String(i).padStart(2,"0")}:${r(t)}`}return[i(t),i(t+e)]}}c.white=16777215;return{export:{AssDanmaku:s,AssDanmakuDocument:o,Danmaku:r,DanmakuConverter:c,DanmakuStack:l,XmlDanmaku:i,XmlDanmakuDocument:n}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/dark.min.css"] = `#app,#app .header,#app .submit,#id-card,#page-fav .fav-sidenav .fav-item:hover,#page-fav .fav-sidenav .icon-cursor,#page-setting #setting-new-tag,#page-setting .setting-tag-list a,#page-video #submit-video-type-filter,#pin-wrapper #pin-layer,#sections-vm .section-block,.action-menu .menu-list,.action-menu .menu-list:before,.activity-item-ctnr .user-avatar,.activity-item-loading-ctnr .info-ctnr .first-line,.activity-item-loading-ctnr .info-ctnr .second-line,.activity-item-loading-ctnr .user-avatar,.advanced-danmaku-group .adv-danmaku-btn-span,.advanced-danmaku-group .adv-danmaku-btn-span.bpui-button-type-small,.app-watch,.appeal-box,.article-container,.attention-btn-ctnr .right-part,.audio-info-module,.audio-list .song-list .song-li .content .text,.audiolist-list .song-list .song-li .content .text,.awarding-panel,.b-line>p>span,.backdrop .title-box,.backdrop iframe,.ban-app,.bangumi-container,.bangumi-info-module,.base-bubble,.base-bubble .content-ctnr:before,.bb-comment .nameplate .nameplate-card,.be-dropdown-menu,.be-pager-item,.be-pager-next,.be-pager-options-elevator input[type=text],.be-pager-prev,.bili-footer,.bilibili-live-player-loading-panel,.bilibili-player-block-line,.bilibili-player-block-string-short,.bilibili-player-block-tabpanel .bilibili-player-block-tabpanel-row.bilibili-player-border,.bilibili-player-color-picker-color-code,.bilibili-player-color-picker-container,.bilibili-player-danmaku-date-picker-container,.bilibili-player-modal-container,.bilibili-player-mode-selection-container,.bilibili-player-video-btn-setting-panel,.bilibili-player-video-danmaku-setting-box,.bilibili-player-video-danmaku-setting-left,.bilibili-player-video-danmaku-setting-right,.bilibili-player-video-inputbar,.bilibili-player-video-panel,.bilibili-player-video-progress-detail-time,.bilibili-player-video-volumebar-wrp,.bl-button--ghost,.bottom .content,.bpm-btn,.bpui-selectmenu-list,.bpui-selectmenu-list-row[data-selected],.bui-input-input,.bui-input-wrap-disabled,.bui-select .bui-select-border,.bui-select-list,.calendar-checkin .checkin-btn:active,.card .focus-btn .focus,.card .focus-btn .unfocus,.card .more-panel,.card .more-panel:after,.chat-history-panel .chat-history-list .chat-item.system-msg,.choice-item,.choice-item.active,.choice-item:hover,.coin-operated-m,.collection-m,.comment-bilibili-con,.comment-wrap,.common-popup-wrap,.contribution-sidenav .contribution-item:hover,.count-choice,.deleted,.download-panel-ctnr .download-item:hover,.dynamic-btn.pink.disabled,.dynamic-link-hover-bg:hover,.dynamic-m,.emoji,.emoji-box,.emoji-box:after,.emoji-tabs,.emotion-box,.emotion-box:after,.error-wrap,.fans-action-btn,.fans-action-follow,.fixed-top,.fixed-top .search-block .input-wrap,.follow-dialog-window,.follow-sidenav .follow-list-container .follow-item:hover,.footer-wrp,.g-search input,.gift-item.buy.hover,.gift-presets .gift-panel-switch,.gift-sender-panel,.guard-rank-cntr .rank-cntr .btn-box .buy:hover,.gui-settings-box,.h5share-container .text-area,.history-list .r-info,.history-tag,.home-wrap .home-input .list li:hover,.home-wrap .home-suggest .hotlist .num,.hover-panel,.imagesbox .boost-control,.imagesbox .boost-img,.img-content,.info-model,.link-footer,.link-input,.list-create,.list-item.active,.list-item:hover,.live-container,.live-player-ctnr.minimal,.modal-wrapper,.mode .selection-span,.multi-page .cur-list li.on,.multi-page .cur-list li.on:hover,.multi-page .more-box,.music-container .image-area .share-img,.music-container .text-area,.my-album .tab-list,.not-support,.page-container,.page-jump>input,.page-wrap .pager,.pagination,.predefined-colors,.radio-icon.selected,.rank.rank-10,.rank.rank-4,.rank.rank-5,.rank.rank-6,.rank.rank-7,.rank.rank-8,.rank.rank-9,.repost,.result,.result .row,.right-side-bar .to-comment .comment-num,.select-wrap .select-option,.select-wrap .select-txt,.small-item .cover,.space-right,.sticky-bar,.sub-nav,.suggest-wrap .horizontal .hz-text,.suggest-wrap .vt-text:hover,.tab-contain,.tag-info-pane,.textarea-container .comm-tool .comm-emoji,.user-card,.user-card-m,.user-item-loading .avatar,.user-item-loading .username,.user-level-detail .detail-link:active,.user-level-detail .detail-link:hover,.user-panel .level-progress,.user-panel .logout-btn:active,.userinfo-content,.video-container,.video-info-module,.video-model,.video-toolbar .share .share-pos .share-address ul li input,.vote-container .image-area .share-img,.vote-container.pointer,.vote-user-face,.voted-result,.watch-later-list header .d-btn,.wrapper .content,.wrapper .modal-body .choice-wrp .battery,.wrapper .modal-body .choice-wrp .battery-desp input,.wrapper .pay-qrcode-wrp .pay-way-wrp .pay-btn,body,div.bilibili-player-auxiliary-area,div.box,div.bubble-traditional,div.con,div.danmaku-wrap,div.dd-bubble,div.desc-tips,div.dyn_list_wrapper,div.i-frame,div.im-list-box,div.live-box,div.member-bottom,div.stardust-player,div.ver span.tips,form.ipt,html,p.num,span.date,textarea,ul.bilibili-suggest,ul.dyn_list,ul.up-nav,ul.up-nav li{background-color:#222!important}#app .submit .cancel,#page-channel-index .channel-option.no-channel,#page-dynamic .col-2 .section,#page-fav .fav-main .search-input input,#page-follows .follow-main .follow-action-bottom .follow-action-fixtop,#page-index .album .content .album-wrapper .album-item .album-top,#page-index .col-1,#page-index .col-2 .section,#page-setting .setting-index-module,#pin-wrapper #pin-layer-search,.activity-pushing-out,.add-btn,.app-look,.area-list-panel,.article-list-holder-block .article-list-plane,.back-top.icon,.ban-detail .content-box .info-wrap,.ban-detail .content-box .major-content,.ban-detail .content-box .vote-cnt,.ban-modal,.ban-modal-h5,.bb-comment .comment-list .quote,.be-dropdown-item:hover,.be-input_inner,.bg-white,.bili-dropdown,.bili-header-m .mini-wnd-nav .list li:hover,.bili-header-m .profile-m .grade .bar,.bilibili-live-player-ending-panel-recommend-card-pic,.bilibili-player-adv-danmaku,.bilibili-player-block-line:hover,.bilibili-player-context-menu-container,.bilibili-player-danmaku-btn-danmaku,.bilibili-player-danmaku-btn-date,.bilibili-player-danmaku-btn-history,.bilibili-player-danmaku-btn-time,.bilibili-player-danmaku-function,.bilibili-player-danmaku-wrap,.bilibili-player-filter-wrap.bilibili-player-block,.bilibili-player-modal-btns .bpm-btn,.bilibili-player-setting-menu-list,.bilibili-player-setting-menu-wrap,.bilibili-player-video-progress-buffer,.bl-switch,.bp-popup-panel,.bpui-button.bpui-button-type-small,.bpui-selectmenu-list-row:hover,.bpui-slider-tracker,.btn-box .like,.btn-box .liked,.btn-box .message,.btn-cancel,.btn.default,.btn.followed .b-gz,.btn.ghost,.bui-button.bui-button-transparent,.bui-radio .bui-radio-button .bui-radio-label,.c-clink,.calendar-checkin,.calendar-checkin .calendar-wrapper,.calendar-checkin .checkin-btn,.calendar-checkin .checkin-rewards,.calendar-checkin .checkin-rewards .query,.calendar-checkin .content-ctnr.ie-fix,.calendar-checkin .title,.calendar-checkin:hover,.card,.card .box,.checkbox,.col-full,.collection-m .bottom .btn.disable,.comment-area,.comment-area .comm-main .comm-list .hot-line>span,.comment-area .comm-more a.more:hover,.content-box .watermark-wrap .watermark,.download-panel-ctnr,.dropdown-list,.dyn_list li .preview,.elec .elec-status,.ema-wishing,.emoji-box .emoji-item:hover,.emoji-cover.selected,.emoji-text:hover,.emoji:hover,.emotion-item:hover .img,.fans-info .fans-progress,.feed-card .empty-content,.feed-tag .publish-panel-container,.fjw-point,.float-nav .nav-menu .item,.follow-btn,.fontsize .selection-span,.forw-area,.gift-presets .gift-panel-box,.go-top .tag-panel .more-button .more:hover,.go-top-m .go-top,.history-btn>.btn,.home-wrap .home-input .content,.home-wrap .home-input .list,.home-wrap .home-input .type,.home-wrap .home-input .type.selected,.home-wrap .home-input .type:hover,.home-wrap .home-suggest .history,.home-wrap .home-suggest .hot-search,.left-container .gift-control-section,.left-container .head-info-section,.link-more,.link-panel-ctnr,.live-panel,.load-error-panel,.load-more-btn,.mCSB_draggerRail,.message-list,.more-link,.more-ops-list,.multi-page,.n .n-inner,.nav-list,.notice-item,.notice-panel,.num-tip,.opera-list,.page-controller .next:hover,.page-controller .prev:hover,.pager .pages .page-item button,.paginator .paging-box .result,.paging-box-big .dian,.paging-box-big .next,.paging-box-big .tcd-number,.percentage-bar,.photo-list .photo,.player-and-aside-area .aside-area,.player-and-aside-area .aside-area .rank-list-section,.process-bar,.ps.ps--in-scrolling.ps--x>.ps__scrollbar-x-rail,.ps.ps--in-scrolling.ps--y>.ps__scrollbar-y-rail,.ps:hover.ps--in-scrolling.ps--x>.ps__scrollbar-x-rail,.ps:hover.ps--in-scrolling.ps--y>.ps__scrollbar-y-rail,.ps:hover>.ps__scrollbar-x-rail:hover,.ps:hover>.ps__scrollbar-y-rail:hover,.publish-panel,.radio-icon,.rank-cntr .item.own,.rank-item>.ri-num,.rank-list-ctnr .own,.rank-list-ctnr .tabs,.read-push,.recommend-list .rec-footer,.right-side-bar .to-comment,.right-side-bar .to-top,.room-info-ctnr .content-wrapper,.s-space .wrapper .content,.score-progress-bar,.search-wrap .search-block .input-wrap,.search-wrap .search-block .input-wrap input,.section-block,.select-wrap .select-option p:hover,.selector,.selector .data-list,.selector .data-list>li:hover,.send-box,.slim-video-card .video-info,.sortable,.space-left,.space-right .space-right-top .title,.sub-nav li:hover,.suggest-wrap,.suggest-wrap .title span,.synthetical .play-btn,.tab-bar,.tab-link.on,.tag-info-pane .tag-header .btn-subscribe,.tag-info-pane .tag-header .btn-unsubscribe,.tag-panel,.totally-empty-hint,.up-article-list-block .more-article,.up-info .btn .b-cd,.up-info-holder .fixed-box .rightside-article-list-btn,.user-level-detail,.user-list .up-item .attention-btn.followed,.user-list .up-item .attention-btn.followed:hover,.user-panel,.user-panel .logout-btn,.user-panel-ctnr .user-panel .lens-ctnr,.video-page-card .card-box .info .pre-mask,.video-page-card .card-box .pic-box,.video-toolbar .share .share-pos,.video.list .type,.video.matrix,.what-ban .text-con,.wrapper .elec-btn.disabled,.wrapper .modal-header .u-info,.wrapper .pay-qrcode-wrp .pay-way-wrp .pay-btn.active,a.im-list:hover,a.more,a.more.tc-slate:hover,a.read-more,a.s-btn,button.submit-button.disabled,div.drag-bar,li.d-data:hover,li.suggest-item.focus,li.suggest-item:hover,li.tag,p.update>span>a,ul.up-nav li:hover{background-color:#444!important}.article-list-holder-block .article-list-plane .button:hover,.be-switch,.bilibili-player-filter,.bpui-selecting,.bpui-unselecting,.brief a:hover,.btn-box .message:hover,.btn-cancel:hover,.btn.default:hover,.bui-collapse-header,.bui-select .bui-select-item:hover,.bui-switch .bui-body,.context-menu-a:hover,.danmaku-info-block-btn,.danmaku-info-report-btn,.live-lr .banner a:hover,.multi-page .cur-list li:hover,div.all>a:hover,div.brief>a:hover,li.context-menu-descipline a{background-color:#555!important}.bui-bar-wrap,.bui-step-dot,.ps>.ps__scrollbar-x-rail>.ps__scrollbar-x,.ps>.ps__scrollbar-y-rail>.ps__scrollbar-y{background-color:#aaa!important}.bpui-slider-handle{background-color:#eee!important}#app,.bilibili-player-video-inputbar,.large-item .cover,.wrapper .modal-header,body{background-image:none!important}.bilibili-player-advanced-danmaku-control-container.mask:after,.bilibili-player-color-picker-mask,.elevator-module .nav-bg{background-color:#222e!important}.article-holder .cover-default,.article-holder img,.back-top,.bb-comment,.divider,.fans-medal-item .level,.fjw-point .line,.list-item .close .close-icon,.my-info .info-modal .integral li .num,.right-part .user-panel,.shortcut-item .list-item:hover,.side-bar-cntr,.wrapper.clearfix .content,font>span{background-color:transparent!important}.bilibili-player-video-sendbar .bilibili-player-video-inputbar{background:#fff1!important}.gui-settings-content-top-mask{background:linear-gradient(to bottom,#222,transparent)}.gui-settings-content-bottom-mask{background:linear-gradient(to top,#222,transparent)}.room-bg::after,.user-panel .level-progress .progress-bar{background:0 0!important}#id-card .idc-auth-description,#page-fav .fav-main .fav-meta,#page-fav .fav-main .filter-item .filter-type .be-dropdown-item i,#page-fav .fav-sidenav .nav-title .text,#page-index .channel .empty-state p,#page-index .col-2 .section .user-auth.no-auth .no-auth-title span,#page-index .section.empty:after,.anonymous,.area-link,.article-action .coin-btn .info-block span,.article-action .fav-btn .info-block span,.article-action .like-btn .info-block span,.article-action .share-btn .info-block span,.article-con,.article-list-holder-block .article-list-plane .button .title,.article-list-holder-block .article-list-plane .button.off .label,.article-wrap .article .desc,.attention-btn-ctnr .right-part,.ban-detail .content-box .bk-user-info .time,.ban-detail .content-box .link-box,.bangumi-rank-list .rank-item .ri-total,.bb-comment .comment-list .list-item .info .plad a,.bb-comment .nameplate .nameplate-card .nameplate-text .n-type,.be-pager-item a,.be-pager-item-jump-next,.be-pager-item-jump-prev,.be-pager-next,.be-pager-next a,.be-pager-options-elevator,.be-pager-prev,.be-pager-prev a,.be-pager-total,.bili-footer,.bili-footer a,.bilibili-player-block-empty,.bilibili-player-block-filter-image,.bilibili-player-block-filter-label,.bilibili-player-block-line-delete,.bilibili-player-block-line.block-state-disabled,.bilibili-player-block-list-function>div,.bilibili-player-danmaku-btn-danmaku,.bilibili-player-danmaku-btn-date,.bilibili-player-danmaku-btn-time,.bilibili-player-danmaku-date-picker-btn,.bilibili-player-danmaku-date-picker-header,.bilibili-player-video-info,.block-setting-ctnr .sub-title,.boost-control li,.boost-control li i,.bottom .text,.btn-box .liked,.btn.followed .b-gz,.card-live-module .num,.case-list .info .type .bk-title,.case-list .info dl dt,.chat-item.danmaku-item .user-name,.cm-model .report-detail .detail .name,.collection-m .bottom .btn.disable,.comment-area .comm-main .comm-list .hot-line>span,.comment-bilibili-con .reason-box dl dt,.comment-list .list-item .reply-box .view-more,.comment-m .b-head .del-log,.content-box .origin-text,.content-box .punish-title .rule-content,.danmaku-info-row,.day-span,.dynamic-list-item-wrap .info>span,.dynamic-list-item-wrap .item-user a.user-name,.dynamic-list-item-wrap .item-user a.user-name.vip,.dynamic-list-item-wrap .view-more,.elec .elec-status,.emoji-box .emoji-title,.fans-action-follow,.filter-wrap .fold,.fjw-point .point-wrap .user-point .info .usr-zan-cai span,.float-nav .nav-menu .item,.follow-main .follow-action-bottom .select-counter,.follow-sidenav .num,.forw-area .forw-more a,.gift-info-desc,.gift-info-expScore,.history-list .l-info .lastplay-time .lastplay-t,.history-list .r-info .w-info .name,.history-list .r-info .w-info .pro-txt,.i-live .i-live-fo-count,.i-live .i-live-unfo-btn,.i-pin-desc,.i-pin-meta,.info .sign,.is-max .option-vote,.jury-graph-wrap .canvas-txt h4,.jury-graph-wrap .graph-status .illegal b,.jury-graph-wrap .graph-status .legal b,.lightgray,.list .list-title,.list-content-candidate,.list-item .auth-description,.list-item .desc,.live-module .zone-title .headline .fire,.live-module .zone-title .headline .online,.live-player-ctnr.minimal::before,.live-status-label.preparing,.live-wrap .headline .user-more,.looked,.medal-box,.mode .selection-span,.more-button,.msg-more,.multi-page .head-con .range-box .paging li,.multi-page .head-con .range-box i,.multi-page .more-box li,.n .n-data .n-data-k,.n .n-num,.nav-wrap .wrap>.sub>span,.no-more,.page-controller .next.disabled,.page-controller .prev.disabled,.pgc-list .synthetical .score .user-count,.pophover>p:last-child,.private-hint,.pub-list .info .comment,.pub-list .info .type .bk-title,.pub-list .info dl dt,.rank-cntr .tip,.rank-list-ctnr .tabs .item,.recommend-list .rec-footer,.report-con dl dt,.right-action-ctnr,.right-side-bar .to-comment .comment-num,.room-feed .tabs .item,.room-info-down-row .icon-label,.room-owner-username,.sec-empty-hint,.section .operation,.section-title h2,.share-to-dynamic,.side-bar .list .item,.slim-video-card .video-info .col,.slim-video-card .video-info .col-2,.so-icon,.spread-module .num,.submit-button.disabled,.suggest-wrap .title span,.synthetical .des,.tab-candidate,.tab-list .tb-item,.tabs a,.tag-info-pane .tag-footer .btn-left-box>a,.tag-info-pane .tag-header .btn-unsubscribe,.tc-slate,.textarea-container .comm-tool .comm-transpond,.top .time,.total-wrap .total-text,.up-info-block .up-info-right-block .fans-num,.up-info-block .up-info-right-block .row-2,.up-info-block .up-info-right-block .view-num,.up-info-holder .fixed-box .rightside-article-list-btn .title,.user-list .up-item .attention-btn.followed,.user-list .up-item .attention-btn.followed:hover,.user-list .up-item .up-videos .ptime,.user-panel .ctrl-btn,.video-desc .btn span,.video-toolbar,.video-toolbar .ops .share-btn i,.video-toolbar .ops .share-pos,.video-toolbar .ops>span,.video-toolbar .share .share-btn,.video.list .des,.vote-introduction,.vote-user-name,.watch-later-list header .d-btn,.what-ban .text-con .txt,.wrapper .edit-video-modal .edit-video-subtitle,.wrapper .edit-video-modal .target-favlist .target-fav-count,.wrapper .edit-video-modal .target-favlist .target-favitem.disabled span,.wrapper .modal-body .elec-bcoin,.wrapper .modal-body .elec-protocol,.wrapper .modal-body .elec-protocol a,.wrapper .pay-qrcode-wrp .pay-way-wrp .pay-btn,.wrapper .pay-qrcode-wrp .refresh-btn,a.message,a.pic>p.title,body,div.desc,div.desc-tips,div.drag-bar,div.r.p>div.info,span.copyright,span.disabled,span.hate span,span.like span{color:#aaa!important}#app .container,#app .header,#app .submit .cancel,#id-card .idc-meta-item,#id-card .idc-uname,#page-article .row .breadcrumb .item,#page-channel-index .channel-item .channel-name,#page-channel-index .channel-option.no-channel p,#page-fav .fav-main .filter-item,#page-fav .fav-main .filter-item .filter-type .be-dropdown-item span,#page-fav .fav-main .search-input input,#page-fav .fav-main .search-types,#page-fav .fav-sidenav .text,#page-index .album .content .album-wrapper .album-item .album-title,#page-index .channel.guest .channel-item .channel-title .channel-name,#page-index .col-2 .section .user-auth .auth-description,#page-setting #setting-new-tag,#page-setting .setting-privacy-item .setting-privacy-name,#page-video #submit-video-type-filter a,#pin-wrapper #pin-layer-search,#pin-wrapper .pin-layer-header,#pin-wrapper .pin-layer-order-tip,.action-menu .menu-list a,.activity-rank-cntr .rank-cntr .item,.add-btn,.advanced-danmaku-group .adv-danmaku-btn-span,.advanced-danmaku-group .adv-danmaku-pos-row .axias-span,.advanced-danmaku-group .adv-danmaku-pos-row .pos-span,.advanced-danmaku-group .content-span,.app-look,.app-watch .title,.article-action .coin-btn .info-block label,.article-action .fav-btn .info-block label,.article-action .like-btn .info-block label,.article-action .share-btn .info-block label,.article-container .text-area .title,.article-holder,.article-holder .color-default,.article-holder .video-holder .title,.article-holder h1,.article-info-container .desc,.article-info-container .title,.article-list-holder-block .article-list-plane .button .label,.article-title,.article-wrap .article .title,.audio-list .song-list .song-li .content .text,.audio-list .song-list .song-li .content .text a,.audiolist-list .song-list .song-li .content .text a,.awarding-panel,.ban-detail .content-box .bk-text-con,.ban-detail .content-box .bk-user-info .name,.ban-detail .content-box .punish-title,.bangumi-container .text-area .title,.bangumi-info-module .v-preview .title,.bangumi-list .synthetical .des .type-s,.base-bubble,.bb-comment .comment-header .tabs-order li,.bb-comment .hot-line span,.bb-comment .reply-notice .notice-item a,.be-dropdown-item,.be-input_inner,.be-pager-options-elevator input[type=text],.be-tab-item,.bili-dropdown,.bili-header-m .mini-wnd-nav a,.bilibili-player-block-label,.bilibili-player-block-line,.bilibili-player-block-string-short,.bilibili-player-block-tabpanel-row .bilibili-player-block-type-keyword,.bilibili-player-block-tabpanel-row .bilibili-player-block-type-regex,.bilibili-player-block-tabpanel-row .bilibili-player-block-type-user,.bilibili-player-color-picker-color-code,.bilibili-player-danmaku-btn-history,.bilibili-player-filter-menu,.bilibili-player-filter-title,.bilibili-player-modal-btns .bpm-btn,.bilibili-player-modal-info,.bilibili-player-modal-title,.bilibili-player-setting-menu-list,.bilibili-player-video-btn-setting-panel-playtype-title,.bilibili-player-video-btn:hover,.bilibili-player-video-btn:hover .bilibili-player-iconfont,.bilibili-player-video-danmaku-input,.bilibili-player-video-danmaku-setting-left-area-title,.bilibili-player-video-danmaku-setting-left-block-title,.bilibili-player-video-danmaku-setting-left-fontsize-title,.bilibili-player-video-danmaku-setting-left-more-text,.bilibili-player-video-danmaku-setting-left-opacity-title,.bilibili-player-video-danmaku-setting-left-speedplus-title,.bilibili-player-video-danmaku-setting-right,.bilibili-player-video-danmaku-setting-right-more,.bilibili-player-video-progress-detail-time,.bilibili-player-video-time-seek,.bl-button--ghost,.block-content,.block-setting-row .setting-label,.block-setting-row .setting-value,.bpui-button.bpui-button-type-small,.bpui-selectmenu-list-row,.breadcrumb .batch,.breadcrumb .item.cur,.btn-box .like,.btn-cancel,.btn.default,.btn.ghost,.btns-profile span,.bui-button.bui-button-transparent,.bui-checkbox-name,.bui-collapse-arrow,.bui-input-input,.bui-input-wrap-disabled,.bui-radio-label .bui-radio-text,.bui-select .bui-select-border,.c-clink,.calendar-checkin .calendar-wrapper,.calendar-checkin .checkin-btn,.card .focus-btn .unfocus .unfocus-text,.card .more-panel,.card.config,.case-list .info .type .jc-black,.case-list .voted-user-info .name,.chat-history-list .chat-item.danmaku-item,.chat-history-panel .gift-item,.chat-history-panel .penury-gift-msg,.choice-item,.cm-model .report-detail .detail .report-cnt,.coin-operated-m .coin-title,.collection-m .title,.comment-area .comm-main .comm-tabs>ul>li,.comment-bilibili-con .other p,.comment-bilibili-con .reason-box dl dd,.comment-bilibili-con .t,.comment-content .link,.comment-emoji,.config-row,.content,.content .group-list li,.content .group-list li label .count,.content-box .origin-text a,.content-box .watermark-wrap .bk-text-con,.context-menu-a,.contribution-sidenav,.crumbs,.crumbs a,.customize,.danmaku-adjust-label,.danmaku-adjust-value,.danmaku-info-block-btn,.danmaku-info-danmaku,.danmaku-info-report-btn,.danmaku-position-item .danmaku-position-text,.danmaku-position-item .icon-font,.darkgray,.day-span.day-enable,.desc-title,.dialog .title,.download-panel-ctnr a,.dropdown-list,.dynamic-list-item-wrap .item-detail .text,.dynamic-m a,.elec .elec-count,.elec .elec-monthly-c,.ema-wishing .title,.emoji,.emoji-box .emoji-item,.emoji-box .title,.emoji-cover,.emoji-cover.selected,.emoji-text,.error-wrap,.fans-action-btn,.feed-tag .separater-line,.filter-wrap .filter-item a,.follow-btn,.follow-dialog-window .title,.follow-main .follow-action-bottom li,.follow-main .follow-action-top .back-to-info,.follow-sidenav .follow-list-container .follow-item,.follow-sidenav .follow-list-container .follow-item.cur .num,.follow-sidenav .nav-title .text,.fontsize .selection-span,.g-search input,.gift-info-title,.gift-item .label,.guard-rank-cntr .rank-cntr .page-box,.guard-rank-cntr .rank-cntr .rank-list-box a,.gui-settings,.gui-settings-box,.gui-settings-textbox-container input,.history-btn>.btn,.history-list .r-info .title,.history-list .r-info .w-info .username,.history-wrap .b-head .b-head-t,.home-wrap .home-input .list,.home-wrap .home-input .type,.home-wrap .home-suggest .history,.home-wrap .home-suggest .history .list .item a,.home-wrap .home-suggest .hot-search,.hover-description,.hover-panel,.i-live .i-live-text,.i-m-btn,.i-m-title,.i-pin-v .be-tab-item,.icon-bls2018-rank.side-bar-icon+.size-bar-text,.im-popup .bp-popup-panel .title-ctnr .popup-title,.info .social a,.is-max .option-text,.jury-graph-wrap .canvas-txt p,.jury-graph-wrap .graph-status .illegal,.jury-graph-wrap .graph-status .legal,.large-item .title,.level-hint-text,.lf-item p,.link-input,.link-more,.link-panel-ctnr,.link-radio-button-label,.list-content-candidate.active,.list-create .text,.list-item .name,.live-room-list .room-item .item-title,.live-user .user-item .item-right .uname,.live-wrap .live-room .headline .filter a,.live-wrap .live-tabs a,.load-more-btn,.member-menu a,.message .message-content.not-img,.modal-container li,.modal-wrapper .modal-header-close,.modal-wrapper .modal-title,.more-link,.more-ops-list,.multi-page .cur-list li a,.multi-page .cur-list li:hover,.my-album .tab-list .tab .name,.my-album .title,.n .n-btn,.n .n-data .n-data-v,.nav-name,.nav-tab-bar .tab-item span,.nav-wrap .wrap,.nav-wrap .wrap>.sub,.next,.no-glory,.opera-list,.page-controller .next,.page-controller .prev,.page-jump>input,.pager .pages .page-item button,.paging-box .current,.paging-box .dian,.paging-box .next,.paging-box .prev,.paging-box .tcd-number,.paging-box-big .dian,.paging-box-big .next,.paging-box-big .tcd-number,.pgc-list .synthetical .des .type-s,.photo-list .photo .title,.pop-live .pl__head,.pop-live .pl__title,.pophover>p:first-child,.pub-list .info .name,.rank-list-ctnr .normal-list .item,.rank-list-ctnr .tabs .item.active,.rank-text-ctnr,.read-push,.report-con dl dd,.report-other,.report-popup .content-text,.result,.room-introduction-scroll-wrapper,.room-introduction-tags .room-introduction-tag,.room-title,.row-title,.search-wrap .search-block .input-wrap input,.section-right-options .operation,.seeds-wrap,.select-wrap .select-option,.select-wrap .select-option p:hover,.select-wrap .select-txt,.selector .current,.selector .data-list>li,.selector .data-list>li:hover,.selector-box,.setting.item a,.side-bar .title,.slide-item-wrp .slide-item-info .slide-item-title,.slim-video-card .video-info .title,.small-item.disabled .title,.sortable,.space-right .space-right-top .title,.special-module .user a,.sponsor-rank .sponsor-rank-header .show-sponsor-rank,.sticky-bar .bar-content .title,.sub-nav span,.suggest-item a,.suggest-wrap .horizontal .hz-text,.suggest-wrap .vt-text,.synthetical .play-btn,.synthetical .title,.t-over-hidden,.tag-info-pane .btn-right-box a,.tag-info-pane .tag-header .btn-subscribe,.tag-info-pane .text,.tag-list a,.tag-title>a,.tc-black,.tc-dark-slate,.tcd-number,.text-con,.title-container .title,.top .title,.up-article-list-block .more-article,.up-info .btn .b-cd,.up-info-holder .fixed-box .more .help .title,.up-info-holder .fixed-box .more .link .title,.up-info-holder .fixed-box .more .top-bar,.up-info-holder .fixed-box .rightside-article-list-btn .label,.up-info-holder .fixed-box .up-article-list-block .block-title,.up-level-icon,.user .info .meta .item,.user-auth.no-auth .no-auth-title .goto-auth,.user-level-detail .detail-link,.user-level-icon,.user-list .up-item .title,.user-list .up-item .up-videos .video-item .video-desc,.user-name a,.user-panel .logout-btn,.user-type-hint,.user-wrap .dropdown-wrap .select-wrap .bili-dropdown .selected,.userinfo-content,.v-title,.video-container .text-area .title,.video-page-card .card-box .info .title,.video-title,.video-toolbar .share .share-pos .share-address ul li input,.video.list .title,.video.list .type,.video.matrix .title,.vote-title,.voted-result,.watch-later-list .list-box .av-item .av-about .t,.watch-later-list header .t,.welcome-msg .action,.welcome-msg .username,.welcome-msg .vip-icon,.what-ban .text-con .title,.wrapper .edit-video-modal .edit-video-title,.wrapper .edit-video-modal .target-favlist .target-fav-name,.wrapper .elec-main-title,.wrapper .elec-sub-title,.wrapper .modal-body .choice-wrp .battery-desp,.wrapper .modal-body .choice-wrp .battery-desp input,.wrapper .modal-body .pay-info,.wrapper .modal-header .title,.wrapper .pay-qrcode-wrp .pay-way-wrp .pay-btn.active,.yan-item,a.im-list,a.logout,a.more,a.name,a.read-more,a.recommand-link,a.router-link-active,a.router-link-exact-active,a.s-btn,a.side-link>span,a.up-name,a.username,div.all>a>span,div.b-head,div.bar>div.num>div,div.bili-tab-item,div.brief>a>span,div.con header,div.con>div.txt,div.grade span,div.info,div.lv-row>strong,div.r-text>.t,div.rec-title,div.title a,font,form.ipt>input,h3,li.tag,li.tag>a,p.ri-title,p.t,p.text,span.key,textarea{color:#eee!important}.bilibili-player.mode-fullscreen .bilibili-player-area .bilibili-player-video-btn-widescreen,.bilibili-player.mode-fullscreen .bilibili-player-area .bilibili-player-video-btn-widescreen .bilibili-player-iconfont{color:#99a2aa!important}.nav-tab-bar .tab-item.on span{color:#00a1d6!important}.calendar .day-item,.calendar .day-item.cur-day,.content-box .watermark-wrap .watermark,.fans-medal-item .label{color:#222!important}.ban-detail .content-box .bk-text-con,.ban-detail .content-box .link-box,.bilibili-player-color-picker-color-code,.case-list .info dl,.history-list .l-info,.history-list .l-info .lastplay-time .history-red-round,.home-wrap .home-suggest .history .list .item,.home-wrap .home-suggest .hotlist .item,.live-status-label.preparing,.pub-list .info dl,.radio-icon,.report-con label:before,.suggest-wrap .title,.up-info-holder .fixed-box .rightside-article-list-btn .label,form.ipt,li.tag{border-color:#aaa!important}#id-card .idc-avatar,#page-setting #setting-new-tag,#page-setting #setting-new-tag-btn,#page-setting .setting-tag-list a,.action-menu .menu-list,.action-menu .menu-list:before,.article-container,.audio-info-module,.bangumi-info-module,.be-pager-options-elevator input[type=text],.bilibili-player-block-string-short,.bilibili-player-color-picker-container,.bilibili-player-danmaku-date-picker-container,.bilibili-player-modal-container,.bilibili-player-mode-selection-container,.bilibili-player-video-btn-setting-panel,.bilibili-player-video-control,.bilibili-player-video-danmaku-setting-box,.bilibili-player-video-inputbar,.bilibili-player-video-volumebar-wrp,.bl-button--ghost,.bpui-selectmenu-list,.card .focus-btn .focus,.card .focus-btn .unfocus,.card .more-panel,.card .more-panel:after,.common-popup-wrap .arrow,.emoji-box,.face,.h5share-container,.live-container,.multi-page .more-box,.music-container,.select-wrap .select-option,.slim-border:after,.textarea-container .comm-tool .comm-emoji,.user-card,.user-card-m,.video-container,.video-info-module,.video-toolbar .share .share-pos .share-address ul li input,.watch-later-list header .d-btn,div.dd-bubble,ul.bilibili-suggest{border-color:#222!important}#app .header,#app .submit,#app .submit .cancel,#article-list-btn .label,#article-list-btn .title,#page-fav .fav-main .fav-header.fav-header-info,#page-fav .fav-main .search-types,#page-fav .fav-main .small-item,#page-fav .fav-sidenav .nav-container,#page-index .channel .channel-item,#page-index .col-2 .section-title,#page-index .fav-covers,#page-setting .setting-index-container,#page-setting .setting-index-module,#page-subs .mini-item,#pin-wrapper .pin-layer-header,#primary_menu,.add-btn,.advanced-danmaku-group,.app-watch,.app-watch .title,.article-action,.article-content,.article-holder .slim-video-card,.attention-btn-ctnr .right-part,.awarding-panel,.bb-comment .nameplate .nameplate-card,.bb-comment .nameplate .nameplate-card .nameplate-text,.be-dropdown-item.be-dropdown-item-delimiter,.be-dropdown-menu,.be-pager-item,.be-pager-next,.be-pager-prev,.bili-dropdown,.bili-tab,.bili-tab-item,.bilibili-player-video-inputbar .bilibili-player-video-inputbar-wrap,.bilibili-player-video-time-seek,.border-b,.btn-box .message:hover,.btn-cancel,.btn-send,.btn.default,.btn.ghost,.calendar-checkin .divider,.chat-history-panel .chat-history-list .chat-item.system-msg,.checkbox,.choice-item,.comment-area .comm-main .comm-tabs,.comment-area .comm-more,.comment-bilibili-con .t,.comment-header,.common-popup-wrap,.common-popup-wrap::after,.common-popup-wrap::before,.count-choice,.customize,.danmaku-info-block-btn,.danmaku-info-report-btn,.day-span,.dialog .title,.divided-line,.dropdown-list,.dynamic-list-item-wrap,.dynamic-m,.ema-wishing,.error-wrap,.fans-action-btn,.filter-wrap,.fjw-case-detail .ban-detail .content-box .jury-status,.fjw-point header,.follow-main,.follow-main .follow-action-top,.follow-main .follow-action-top .back-to-info,.follow-main .follow-header.follow-header-info,.follow-sidenav,.follow-sidenav .nav-container.follow-container,.forw-area .forw-more,.g-search input,.gift-presets .gift-panel-switch,.gift-sender-panel::before,.guard-rank-cntr .rank-cntr .btn-box,.history-wrap .time-label:before,.home-wrap .home-input .content,.home-wrap .home-input .list,.home-wrap .home-input .type,.home-wrap .home-suggest .history,.home-wrap .home-suggest .hot-search,.hover-panel,.hover-panel:before,.i-live .i-live-fo-count,.i-live .i-live-unfo-btn,.i-m-r2,.i-m-upload,.iScrollIndicator,.image-box,.info-item-ctnr,.left-container .gift-control-section,.left-container .head-info-section,.link-footer,.list .list-title,.list-item,.looked,.member-menu,.modal-container .modal-body .target-followlist,.modal-wrapper .modal-title,.multi-page .head-con .range-box .paging li,.multi-page .more-box li,.nav-list,.nav-wrap,.pager .pages .page-item button,.photo-list .photo,.pl__card,.player-and-aside-area .aside-area,.prize-item .prize-img,.rank-list-ctnr,.rank-list-ctnr .tabs .item,.report-con,.room-info-ctnr .content-wrapper,.room-introduction-tags,.s-content,.search-wrap .search-block .input-wrap input,.section .operation,.selector,.selector .data-list,.send-box,.side-bar-cntr,.song-list .song-li .content .num,.suggest-wrap,.suggest-wrap .horizontal .hz-text,.synthetical .play-btn,.user .info .meta .row,.user .tags,.user-level-detail,.user-level-detail hr,.user-level-detail::after,.user-level-detail::before,.userinfo-wrapper,.video.list .type,.video.matrix,.vote-container,.whisper .list,.wrapper .pay-qrcode-wrp,.wrapper .pay-qrcode-wrp .pay-way-wrp .pay-btn,.wrapper .pay-qrcode-wrp .pay-way-wrp .pay-btn.active,div.bar>div.num,li.tag{border-color:transparent!important}#arc_toolbar_report,#page-index .col-1,#page-index .col-2 .section,#page-index .col-2 .section:last-child,#page-myalbum .album-content,#pin-wrapper #pin-layer-search,#v_desc,.all-class,.app-look,.article-list-holder-block .article-list-plane,.article-wrap .article,.back-top.icon,.backdrop .title-box,.bb-comment .comment-list .quote,.be-input_inner,.bilibili-player-adv-danmaku,.bilibili-player-block-string-short-btn,.bilibili-player-context-menu-container,.bilibili-player-modal-btns .bpm-btn,.bilibili-player-modal-header,.bilibili-player-setting-menu-wrap,.bilibili-player-video-danmaku-setting-right-separator,.bpui-button.bpui-button-type-small,.btn-box .like,.btn-box .liked,.btn-box .message,.btn.followed .b-gz,.bui-button.bui-button-transparent,.bui-input .bui-input-stepper-up,.bui-input-input,.bui-input-stepper,.bui-input-wrap-disabled,.bui-select .bui-select-border,.c-clink,.collection-m .bottom,.collection-m .title,.comment-emoji,.contribution-sidenav,.contribution-sidenav~.main-content,.danmaku-wrap .bilibili-player-block-wrap,.elec .elec-avatar,.fixed-top .search-block .input-wrap input,.float-nav .nav-menu .item,.follow-dialog-window .bottom,.follow-dialog-window .title,.go-top,.history-btn>.btn,.history-list .r-info .r-txt,.history-list .r-info .w-info .username,.i-pin-v .be-tab,.lf-list,.link-more,.list-create,.live-field.fl,.modal-wrapper .modal-title,.more-link,.more-ops-list,.notice-item,.opera-list,.option-li,.page-jump>input,.paging-box-big .dian,.paging-box-big .next,.paging-box-big .tcd-number,.read-push,.result .row.top-border:before,.result .row:after,.result .row:first-child:before,.right-side-bar .to-comment,.right-side-bar .to-comment .comment-num,.right-side-bar .to-top,.section,.square-field,.synthetical,.up-info .btn .b-cd,.up-info-holder .fixed-box .rightside-article-list-btn,.up-info:before,.user-list .up-item,.user-wrap .dropdown-wrap .select-wrap,.v-data,.v-preview,.v-wrap .s_tag,.video-toolbar .share .share-pos,.video.list,.vote-number,.watch-later-list .list-box .av-item .av-about,.wrapper .edit-video-modal .modal-body,.wrapper .modal-body .choice-wrp .battery,.wrapper .modal-body .choice-wrp .battery-desp input,.wrapper .modal-body .elec-protocol .checkbox,.wrapper .modal-header .u-info,a.more,a.read-more,a.s-btn,div.con,div.con header,textarea,ul.boston-postcards>li{border-color:#444!important}.b-line,.b-line:hover,.bilibili-player-danmaku-date-picker-header,.btn-right-box,.video-toolbar .share .share-pos .box-b,li.history,li.history:hover,li.timeline,li.timeline:hover{border-color:#99a2aa!important}.bili-header-m .mini-wnd-nav a,.dropdown-item,.elevator-module .nav-list .item,.history-btn>.btn,.link-more,.member-menu a,.more-link,.read-push,.video-desc .btn span,a.im-list,a.logout,li.tag,p.ri-title{transition:.2s!important}.bili-dropdown>.icon,.c-clink>.icon,.filter-wrap .fold .arrow-down,.filter-wrap .fold .arrow-up,.fixed-top .search-block .search-loupe .icon-loupe,.gift-presets .gift-panel-switch>.arrow,.home-wrap .home-input .type .arrow-down,.i-live-arrow,.i-live-icon,.i-m-ra,.i-m-u-icon,.i-m-v-icon,.icon-arrow,.icon-close-notice,.icon-notice,.link-footer .footer-linker .footer-linker-bili .logo,.link-more>.icon,.list-create:hover .icon,.member-menu i,.more-link>.icon,.primary-menu .nav-menu li.home>a,.read-push>.icon,.select-wrap .select-txt i,.setting:before,.side-bar .icon,.tag-info-pane .btn-right-box a i,.up-info-holder .fixed-box .rightside-article-list-btn .icon-list,a.more>.b-icon,a.read-more>.b-icon,form.ipt>a,i.btn-del,i.face,img[src^='//static.hdslb.com/images/base']{filter:brightness(0) invert(1)!important}ul.up-nav li{filter:grayscale(1) brightness(1.3)!important}#app .container .options .option img,.bb-comment .comment-list .list-item .info .operation .spot,.bp-svg-icon.lottery-btn,.bp-svg-icon.radio-Selected,.bp-svg-icon.radio-default,.bp-svg-icon.vote-btn,.calendar .day-item.checked,.carousel-box .carousel-module .panel .trig span.on,.carousel-box .carousel-module .panel .trig span:hover,.check-icon,.comment-list .list-item .info .hate.hated i,.comment-list .list-item .info .hate.hated:hover i,.comment-list .list-item .info .hate:hover i,.comment-list .list-item .info .like.liked i,.comment-list .list-item .info .like.liked:hover i,.comment-list .list-item .info .like:hover i,.comment-wrap .header .title-h2 .head-icon,.dynamic-comm-icon,.dynamic-hate:hover i,.dynamic-hated i,.dynamic-hated:hover i,.dynamic-like:hover i,.dynamic-liked i,.dynamic-liked:hover i,.emoji-btn-box.opened,.emoji-btn-box:hover,.emoji-tab-slider .next.on:hover,.emoji-tab-slider .prev.on:hover,.emotion-btn-box.opened,.emotion-btn-box:hover,.fjw-point header h2 .head-icon,.follow-main .follow-action-bottom .icon-copy,.follow-select .icon-follow-selected,.group-list li input[type=checkbox]:checked+i,.group-list li input[type=checkbox]:checked:hover+i,.group-list li input[type=checkbox]:hover+i,.home-wrap .home-logo,.home-wrap .home-tips .tips-link .tip-item>a,.is-web .checked,.is-web .is-max .percentage-bar,.link-range-ctnr,.live-wrap .live-room .headline .filter .cover-btn.active .icon-live-face,.live-wrap .live-room .headline .filter .cover-btn:hover .icon-live-face,.live-wrap .live-room .headline .filter .frame-btn.active .icon-live-frame,.live-wrap .live-room .headline .filter .frame-btn:hover .icon-live-frame,.nav-tab-bar .logo,.nav-tab-bar .tab-item.on,.primary-menu .nav-menu .sub-nav li>a,.primary-menu .nav-menu .sub-nav li>a span::after,.search-wrap .search-logo,.type.active .icon-aver,.type.active .icon-imgleft,.user-type-icon .svg-icon.not-member-1,.user-type-icon .svg-icon.phone-1,.video-container .image-area .see-later.done,.vote-container .image-area .share-img,.watch-later-trigger.added{filter:var(--blue-image-filter)!important}.calendar .day-item.gift-checked,.home-wrap .home-tips .tips-link .tip-item>a:hover,.is-max .percentage-bar,.single-button .text-bar.selected{filter:var(--pink-image-filter)!important}.elevator-module .nav-list .customize .icon,.fjw-point .point-wrap .user-point .info .usr-zan-cai .cai,.fjw-point .point-wrap .user-point .info .usr-zan-cai .zan,.spread-module .num .danmu .icon,.spread-module .num .play .icon,.switch-wrap i.icon-aver,.switch-wrap i.icon-imgleft,ul.filter-disable .icon-copy{filter:grayscale(1)!important}.room-bg{filter:brightness(.16) blur(10px)!important}.bottom-actions .left-action{filter:brightness(.8)!important}.box-slide-item.expired .box-img,.box-slide-item:not(.in-countdown) .box-img,.user-type-icon .svg-icon.not-member-2,.user-type-icon .svg-icon.phone-2{filter:brightness(.3)!important}#page-follows .follow-main .follow-action-top .back-to-info,#page-index .col-1 .section .more,.article-holder .slim-video-card-error,.elec .elec-status,.elec .elec-status-bg,.small-item .cover{background-image:none!important}.bilibili-player-block-tabpanel-row.bilibili-player-border,.dropdown-item,.g-search input{border-radius:4px!important}.back-top.icon:hover,.go-top:hover{background-position:-713px -72px!important}.list-create:hover .icon{background-position:-716px -332px!important}.switch-wrap .imgleft:hover i{background-position:-148px -376px!important}.switch-wrap .aver:hover i{background-position:-194px -376px!important}.action-menu .menu-list,.article-container:hover .text-area,.ban-detail .content-box .info-wrap,.bpui-selectmenu-list,.bpui-slider-handle,.card,.col-full,.comment-wrap,.dynamic-m,.elec .elec-trigger,.h5share-container:hover .text-area,.i-pin-c,.large-item .cover img,.list-item .cover img,.mini-item .cover img,.music-container:hover .text-area,.n .n-inner,.side-bar-cntr,.space-right .space-right-top .title,.sticky-bar .bar-content .send-button,.vote-container:hover .text-area,div.box,div.im-list-box,div.live-box{box-shadow:none!important}#gift-package-item-box .panel-wrapper,.audio-info-module,.bangumi-info-module,.bb-comment .nameplate .nameplate-card,.bilibili-player-context-menu-container,.blpui-slider-container .slider-handle,.common-popup-wrap,.emoji-box,.emotion-box,.gift-sender-panel,.link-navbar .panel-shadow,.live-player-ctnr.minimal,.tag-info-pane,.user-card,.user-card-m,.user-level-detail,.user-panel-ctnr .user-avatar.active,.userinfo-wrapper,.video-info-module,div.dd-bubble,div.desc-tips,div.drag-bar,div.i-frame,ul.bilibili-suggest,ul.up-nav{box-shadow:rgba(0,0,0,.3) 0 4px 8px 0!important}.sticky-bar{box-shadow:0 1px 10px 0 #0003!important}#bofqi.mini-player::before{box-shadow:0 4px 8px 0 #0004!important}.bilibili-player-context-menu-container{text-shadow:none!important}.bb-comment .comment-header .tabs-order li.on:after,.bb-comment .nameplate .nameplate-card .nameplate-arrow,.emoji-box:before,.g-search .search-btn,.load-more .icon,.loading .icon,.up-info-holder .fixed-box .more .help .icon,.up-info-holder .fixed-box .more .link .icon,.wrapper .elec-message-wrp .elec-triangle,canvas.cliper.is-img,div.desc-tips>span.arrow-left,img.source-img{display:none!important}.article-action i.animation{opacity:0!important}.bilibili-player-video-progress-buffer-range,.bui-bar.bui-bar-buffer{opacity:.382!important}.vote-user-face.opacity{opacity:1!important}.advanced-danmaku-group .content-span,.bilibili-player-block-label{font-weight:400!important}.bilibili-player-video-progress-detail-sign-down{border-top-color:var(--theme-color)!important}.bilibili-player-video-progress-detail-sign-up{border-bottom-color:var(--theme-color)!important}.bilibili-player-video-control{border-bottom-color:#333!important}.coin-operated-m .mc-box{border:2px dashed #444!important;background-color:#fff!important}.coin-operated-m .mc-box.on{border-style:solid!important}.go-top-m .go-top,.page-box .num{border:none!important}.music-container .image-area .icon{filter:brightness(0)!important}.g-search input{padding:0 8px!important}.up-info-holder .fixed-box .more .help,.up-info-holder .fixed-box .more .link{padding:0!important}#page-fav .fav-main .filter-item .filter-type .be-dropdown-item{padding:0 16px!important}.cliper{filter:brightness(16%)!important}#page-setting #setting-new-tag-btn{background:var(--theme-color)!important}.bilibili-player-video-panel-image-detail{filter:invert(70%)!important}.home-wrap .home-input .content:focus,.search-wrap .search-block .input-wrap input,textarea:focus{outline:0!important;outline-offset:0!important}.bangumi-list .synthetical .cardBangumibox .modal-box .lazy-img,.pgc-list .synthetical .cardPgcbox .modal-box .lazy-img{z-index:inherit!important}.base-bubble,.base-bubble .content-ctnr:before,.bb-comment .comment-header .tabs-order li.on,.bb-comment .stick,.bb-comment .stick.assist,.be-pager-item-active,.be-tab-cursor,.be-tab-cursor:after,.bi-btn,.bili-tab-item.on,.bilibili-player-block-tabpanel-row.active-1 .bilibili-player-block-type-keyword,.bilibili-player-block-tabpanel-row.active-2 .bilibili-player-block-type-regex,.bilibili-player-block-tabpanel-row.active-3 .bilibili-player-block-type-user,.bilibili-player-video-btn-send,.bl-button--primary,.bpui-button.bpui-button-type-small:hover,.btn-box .like:hover,.btn-submit,.btn.primary,.bui-button.bui-button-transparent:hover,.c-clink:hover,.calendar-checkin .checkin-rewards .query:hover,.calendar-checkin .title .month:hover.cur-month:after,.calendar-checkin .title .month:hover.cur-month:before,.calendar-checkin .title .month:hover.last-month:after,.calendar-checkin .title .month:hover.last-month:before,.card .focus-btn .unfocus:hover,.choice-item.active,.choice-item:hover,.coin-operated-m .mc-box.on,.coin-operated-m .mc-box.on .coin-operated-m .mc-box:hover,.comment-area .comm-main .comm-tabs>ul>li.active,.comment-submit,.count-choice .count-input:focus,.day-span.day-enable.active,.elevator-module .back-top:hover,.elevator-module .nav-list .item.on,.elevator-module .nav-list .item:hover,.filter-wrap .filter-item.active a,.float-nav .nav-menu .item:hover,.go-top,.history-btn>.btn:hover,.history-wrap .active:before,.history-wrap .time-label,.history-wrap .time-label:after,.home-wrap .home-input .searchBtn,.link-more:hover,.list-create:hover,.live-panel .more-button .more:hover::after,.live-status-label,.live-wrap .live-tabs a.active,.more-link:hover,.multi-page .more-box li.on,.page-jump>input:focus,.paging-box-big .current,.paging-box-big .next:hover,.paging-box-big .tcd-number:hover,.radio-icon.selected,.read-push:hover,.report-con input[type=radio]:checked+label:before,.right-side-bar .to-comment:hover,.right-side-bar .to-top:hover,.send-btn,.suggest-wrap .horizontal .hz-text:hover,.tab-list .tb-item.active,.tag-panel .more-button .more:hover::after,.top-title .concern,.up-info .btn .b-cd:hover,.up-info .up-focus-btn,.up-info-holder .fixed-box .follow-btn-holder .follow-btn,.up-info-holder .fixed-box .follow-btn-holder .follow-btn:hover,.wrapper .modal-back:hover,.wrapper .modal-body .choice-wrp.selected .battery,.wrapper .modal-body .choice-wrp.selected .elec-input,a.more:hover,a.read-more:hover,a.s-btn:hover,input[type=text]:focus,textarea:focus{border-color:var(--theme-color)!important}#app .submit .confirm,#page-channel-index .channel-option.no-channel .create-channel,#page-fav .fav-sidenav .fav-item.cur,#page-setting #setting-new-tag-btn,.advanced-danmaku-group .adv-danmaku-btn-span:hover,.area-link:active,.attention-btn-ctnr .left-part,.bb-comment .hot-line a:hover,.be-pager-item-active,.be-switch-container.is-checked .be-switch,.bi-btn,.bilibili-player-block-string-short-btn,.bilibili-player-setting-menu-list:hover,.bilibili-player-video-btn-send,.bilibili-player-video-progress-buffer-range,.bl-button--primary,.bl-switch-checked,.blpui-slider-container .slider-handle,.blpui-slider-container .slider-process,.blpui-slider-span.slider-span-active:after,.blpui-slider-span>span,.bpui-button.bpui-button-type-small:hover,.bpui-slider-progress,.btn-box .like:hover,.btn-send,.btn-submit,.btn.primary,.bui-bar,.bui-button.bui-button-transparent:hover,.bui-radio-input:checked+.bui-radio-label,.bui-switch .bui-checkbox:checked+.bui-body,.bui-thumb-dot,.c-clink:hover,.card .focus-btn .unfocus:hover,.cases-wrap .fjw-user .b-right button,.close-icon,.collection-m .bottom .btn,.comment-submit,.contribution-sidenav .contribution-item.cur,.count-choice .send-button,.danmaku-info-block-btn:hover,.danmaku-info-report-btn:hover,.dropdown-item:hover,.dyn_list span.sp,.dynamic-btn.pink,.dynamic-m .dyn_menu .line,.elec .elec-trigger,.elevator-module .back-top:hover,.elevator-module .nav-list .item.on,.elevator-module .nav-list .item:hover,.filter-wrap .filter-item.active,.filter-wrap .fold:hover,.fjw-point .focus-btn,.float-nav .nav-menu .item:hover,.follow-btn,.follow-sidenav .follow-list-container .follow-item.cur,.fontsize .selection-span.active,.gift-item .corner-mark,.gift-package,.go-top:hover,.history-btn>.btn:hover,.history-list .cover-contain .progress,.history-wrap .time-label.active,.home-wrap .home-input .searchBtn,.home-wrap .home-suggest .hot-search .item .num.special,.hour-rank,.link-more:hover,.live-container .status,.more-link:hover,.more-ops-list li:hover,.multi-page .more-box li.on,.n .n-cursor,.nav-wrap .hover-bar,.new-notice-bar,.notify,.num-wrap>span,.opera-list li:hover,.pager .pages .page-item button:hover,.pager .pages .page-item.active button,.paging-box-big .current,.paging-box-big .next:hover,.paging-box-big .tcd-number:hover,.process-bar .process-receive,.radio-icon:after,.rank-item.highlight>.ri-num,.rank.rank-1,.rank.rank-2,.rank.rank-3,.read-push:hover,.report-con label:after,.right-side-bar .to-comment:hover,.right-side-bar .to-top:hover,.s_tag .btn-add:hover span,.search-wrap .search-block .search-button,.send-btn,.sortable:hover,.sticky-bar .bar-content .send-button,.submit-button,.synthetical .play-btn:hover,.tab-bar .line,.tab-candidate>span:after,.tag-info-pane .tag-footer .btn-left-box>a:hover,.tag-info-pane .tag-header .btn-subscribe:hover,.text-con .title i,.textarea-container .comm-tool .comm-submit,.top-title .concern,.type-label,.up-info .btn .b-cd:hover,.user-list .up-item .attention-btn,.user-panel .level-progress .progress-bar,.user-panel-ctnr .user-avatar.active::before,.video-container .types,.video-info .video-title .activity,.video-toolbar .share .share-pos .share-address ul li .btn,.vote-btn-box .vote-btn,.wrapper .edit-video-modal .target-favlist .target-favitem.selected,.wrapper .elec-btn,.yan-item:active,a.btn-more:hover,a.more:hover,a.read-more:hover,a.s-btn:hover,li.tag:hover,p.on>span>a,span.reply:hover{background-color:var(--theme-color)!important}#app .header .close:hover,#id-card .idc-uname:hover,#page-channel-index .no-channel-container em,#page-fav .fav-main .filter-item .filter-type .be-dropdown-item:hover i,#page-fav .fav-main .filter-item .filter-type .be-dropdown-item:hover span,#page-fav .fav-main .filter-item .text:hover,#page-fav .fav-main .search-types:hover,#page-follows .follow-main .follow-action-bottom .select-cancel,#page-index .album .content .album-wrapper .album-item .album-title:hover,#page-index .channel.guest .channel-item .channel-title .channel-name:hover,#page-subs .action .sub-action,#page-subs .detail a:hover,#page-video #submit-video-type-filter a.active,.action-menu .menu-list a:hover,.album-card .title:hover,.app-watch .app-look .foot-txt a,.area-link:hover,.article-holder a,.article-title a:hover,.awarding-panel .countdown-text .with-color,.awarding-panel .info-section .slide-btn:hover,.awarding-panel .title,.ban-detail .content-box .link-box .box-right a,.bangumi-container .text-area .title:hover,.bb-comment .comment-header .tabs-order li.on,.bb-comment .comment-header .tabs-order li:hover,.bb-comment .comment-list .list-item .info .plad a:hover,.bb-comment .stick,.bb-comment .stick.assist,.bb-comment a,.be-dropdown-item a:hover,.be-pager-item:hover a,.be-pager-next:hover a,.be-pager-prev:hover a,.be-tab-item.is-active,.bili-footer a:hover,.bili-header-m .bubble-traditional .recommand .title,.bili-header-m .mini-wnd-nav a:hover,.bili-link,.bili-tab-item.on,.bilibili-player-block-filter-type.disabled .bilibili-player-block-filter-label,.bilibili-player-block-filter-type.disabled .bp-icon,.bilibili-player-block-filter-type:hover .bilibili-player-block-filter-label,.bilibili-player-block-filter-type:hover .bp-icon,.bilibili-player-block-line-delete:hover,.bilibili-player-block-line-state,.bilibili-player-block-tabpanel-row.active-1 .bilibili-player-block-type-keyword,.bilibili-player-block-tabpanel-row.active-2 .bilibili-player-block-type-regex,.bilibili-player-block-tabpanel-row.active-3 .bilibili-player-block-type-user,.bilibili-player-block-tabpanel-row>div:hover,.bilibili-player-danmaku-btn-history.bpui-state-hover,.bilibili-player-video-danmaku-setting-left-block .bilibili-player-video-danmaku-setting-left-block-content .bilibili-player-block-filter-type.disabled .bilibili-player-block-filter-label,.bilibili-player-video-danmaku-setting-left-more:hover,.bilibili-player-video-danmaku-setting-left-more:hover .bilibili-player-video-danmaku-setting-left-more-text,.bilibili-player-video-danmaku-setting-left-more:hover i,.bilibili-player-video-danmaku-setting-right-more:hover,.bilibili-player-video-danmaku-setting-right-more:hover i,.bilibili-player-video-danmaku-setting:hover,.bilibili-player-video-toast-item-close:hover i,.bilibili-player-video-toast-item-jump,.block-setting-ctnr .title,.block-user-type.active .user-type-hint,.blpui-btn.icon-btn:hover>i,.blpui-btn.text-btn.active,.blpui-btn.text-btn:hover,.boost-control li:hover,.boost-control li:hover i,.bottom .link,.box-slide-item.box-open,.box-slide-item.in-countdown,.box-toggle.active,.box-toggle:focus,.box-toggle:hover,.bpui-selectmenu-list-row[data-selected],.breadcrumb .item:hover,.bui-checkbox:hover .bui-checkbox-name,.bui-select.bui-select-quality-menu .bui-select-item.bui-select-item-active,.bui-switch .bui-checkbox:checked+.bui-body .bui-dot,.calendar-checkin .checkin-btn:hover,.calendar-checkin .checkin-rewards .query:hover,.calendar-checkin .title .month:hover,.captcha-widget .refresh-captcha:hover,.card-live-module .num,.chat-history-panel .penury-gift-msg .penury-gift-item .username,.chat-item.danmaku-item .danmaku-content:hover,.choice-item.active,.choice-item:hover,.clearall a,.clock-time,.coin-operated-m .coin-title span,.collection-m .content .group-list li:hover,.comment-area .comm-main .comm-tabs>ul>li.active,.comment-area .comm-more a.more:hover,.content-ctnr .activity-item-ctnr:hover .username.f-left,.contribution-sidenav .contribution-item a:hover,.control-panel-icon-row .icon-item.active,.control-panel-icon-row .icon-item:hover,.day-span.day-enable.active,.day-span.day-enable:hover,.download-panel-ctnr .download-item:hover,.dynamic-link-hover-bg,.dynamic-m .dyn_menu li.on,.expand-btn,.filter-wrap .filter-item a:hover,.follow-dialog-window .content .info .uname,.follow-sidenav .text:hover,.guard-rank-cntr .rank-cntr .btn-box .buy,.guard-rank-cntr .rank-cntr .rank-list-box a:hover,.history-list .r-info .title:hover,.history-list .r-info .w-info .username:hover,.history-wrap .time-label,.i-live .i-live-link:hover,.i-live .i-live-off-guest a,.i-m-title:hover,.info-ctnr .time .blue,.joined-number,.keyword,.large-item .title:hover,.list .item.active a,.list .item.active:before,.list .item:hover a,.list .item:hover:before,.list-item a.title:hover,.live-box .title,.live-module .zone-title .headline .fire:hover,.live-panel .more-button .more:hover,.live-status-label,.live-wrap .live-room .headline .filter a.active,.live-wrap .live-room .headline .filter a:hover,.live-wrap .live-tabs a.active,.live-wrap .live-tabs a:hover,.load-error-panel .request-link,.load-more-btn:hover,.member-menu a:hover,.minimal-control-panel .control-btn .btn-icon:hover,.modal-wrapper .modal-header-close:hover,.mode .selection-span.active,.mode .selection-span:hover,.more-button:hover,.multi-page .cur-list li a:hover,.multi-page .cur-list li.on i,.multi-page .head-con .range-box .paging li.on,.multi-page .head-con .range-box i:hover,.multi-page .more-box li:hover,.my-album .tab-list .tab.active .name,.n .n-btn:hover,.n .n-fs:hover p,.n .n-gz:hover p,.nav-wrap .wrap>.sub.active,.nav-wrap .wrap>.sub:hover,.player-setting-ctnr .title,.right-action-ctnr:hover,.room-introduction-tags .room-introduction-tag a:hover,.room-introduction-tags .room-introduction-tag:hover,.room-introduction-tags .room-introduction-tag:hover .icon-label,.room-owner-username:hover,.sec-empty-hint a,.section .operation:hover,.section-title,.section-title .t:hover,.seeds-wrap>.item.btn,.small-item .title:hover,.small-item.disabled .title:hover,.song-list .song-li:hover .content .text a,.special-module .user a:hover,.sticky-bar .bar-content .title:hover,.suggest-wrap .horizontal .hz-text:hover,.suggest-wrap .keyword-wrap .keyword .suggest_high_light,.tab-candidate.active,.tab-candidate:hover,.tab-text.selected,.tab-text:hover,.tabs a:hover,.tag-info-pane .tag-header .btn-unsubscribe:hover,.tag-panel .more-button .more:hover,.tag-panel .tag-list a,.tc-blue,.tc-blue-hover,.time .detail-link:hover,.up-info-holder .fixed-box .more .help .title:hover,.up-info-holder .fixed-box .more .link .title:hover,.user-level-detail .detail-link:active,.user-level-detail .detail-link:hover,.user-list .up-item .up-videos .video-item .video-desc:hover,.user-list .up-item .up-videos .video-more,.user-name:hover,.user-panel .ctrl-btn.colored,.user-panel .ctrl-btn:hover,.user-panel .logout-btn:active,.user-panel .logout-btn:hover,.user-panel .user-level,.video-desc .btn span:hover,.video-toolbar .ops .app .app-look .foot-txt a,.video-toolbar .ops>span.on,.video-toolbar .ops>span.on>i,.video-toolbar .ops>span:hover,.video-toolbar .ops>span:hover>i,.video-toolbar .share-btn:hover,.video-toolbar .share-btn:hover i,.watch-later-list .list-box .av-item .av-about .t:hover,.welcome-msg .close-vip-hint,.wish-box-cntr .title,.wrapper .elec-sub-title .up-name,.wrapper .modal-back,.wrapper .modal-body .choice-wrp.selected .battery-desp,.wrapper .modal-body .elec-pay .elec-coin,.wrapper .modal-body .elec-pay .elec-count,.wrapper .modal-body .elec-pay .elec-exp,.wrapper .modal-body .elec-protocol a:hover,.wrapper .modal-body .pay-info .balance,.wrapper .modal-body .pay-info .pay-tip .em-text,.wrapper .modal-header .u-name,.yan-item:hover,a.bbs,a.btn-more,a.help-link,a.im-list:hover,a.logout:hover,a.more-hot,a.name:hover,a.pic>p.title:hover,a.tcd-number:hover,a.up-name:hover,div.all>a>span:hover,div.bili-tab-item:hover,div.brief>a>span:hover,div.info>a,div.r-text>.t:hover,div.spread-module:hover,div.title a:hover,p.ri-title:hover,p.t:hover,span.current,ul.nav-menu>li:hover{color:var(--theme-color)!important}#app .submit .confirm,#page-setting #setting-new-tag-btn,.advanced-danmaku-group .adv-danmaku-btn-span:hover,.area-link:active,.attention-btn-ctnr .left-part,.bb-comment .comment-list .quote,.bb-comment .hot-line a:hover,.be-pager-item-active a,.be-pager-item.be-pager-item-active:hover a,.bili-header-m .mini-wnd-nav a:hover,.bilibili-player-block-string-short-btn,.bilibili-player-setting-menu-list:hover,.bilibili-player-video-btn-send,.bl-button--primary,.bpui-button.bpui-button-type-small:hover,.btn-box .like:hover,.btn-send,.btn-submit,.btn.primary,.bui-button.bui-button-transparent:hover,.bui-radio-input:checked+.bui-radio-label .bui-radio-text,.calendar .day-item.checked,.card .focus-btn .unfocus .unfocus-text:hover,.cases-wrap .fjw-user .b-right button,.collection-m .bottom .btn,.comment-submit,.contribution-item.cur a,.contribution-sidenav .contribution-item.cur .text:hover,.count-choice .send-button,.danmaku-info-block-btn:hover,.danmaku-info-report-btn:hover,.dropdown-item:hover,.dyn_list span.sp,.dynamic-btn.pink,.filter-wrap .filter-item.active,.filter-wrap .filter-item.active a,.filter-wrap .fold:hover,.fjw-point .focus-btn,.float-nav .nav-menu .item:hover,.follow-btn,.follow-sidenav .follow-list-container .follow-item.cur,.follow-sidenav .follow-list-container .follow-item.cur .num,.follow-sidenav .follow-list-container .follow-item.cur .text,.fontsize .selection-span.active,.gift-item .corner-mark,.gift-package,.gift-package>span,.history-btn>.btn:hover,.history-wrap .time-label.active,.home-wrap .home-input .searchBtn,.home-wrap .home-suggest .hot-search .item .num.special,.hour-rank .hour-rank-content,.link-more:hover,.live-container .status,.more-link:hover,.more-ops-list li:hover,.multi-page .more-box li.on,.new-notice-bar .message,.num-wrap>span,.opera-list li:hover,.pager .pages .page-item button:hover,.pager .pages .page-item.active button,.paging-box-big .current,.paging-box-big .next:hover,.paging-box-big .tcd-number:hover,.rank.rank-1,.rank.rank-2,.rank.rank-3,.read-push:hover,.search-wrap .search-block .search-button,.section-right-options .operation:hover,.send-btn,.sortable:hover,.sticky-bar .bar-content .send-button,.submit-button,.synthetical .play-btn:hover,.tab-list .tb-item.active,.tag-info-pane .tag-footer .btn-left-box>a:hover,.tag-info-pane .tag-header .btn-subscribe:hover,.textarea-container .comm-tool .comm-submit,.top-title .concern,.type-label,.up-info .btn .b-cd:hover,.user-list .up-item .attention-btn,.video-container .types,.video-info .video-title .activity,.vote-btn-box .vote-btn,.wrapper .elec-btn,.yan-item:active,a.btn-more:hover,a.more:hover,a.s-btn:hover,div.title a.more:hover,li.tag>a:hover,span.reply:hover{color:var(--foreground-color)!important}#page-follows .follow-main .follow-action-top .back-to-info:hover,.bilibili-player-block-filter-type:hover .bilibili-player-block-filter-image,.bilibili-player-mode-selection-container .bilibili-player-mode-selection-panel .bilibili-player-mode-selection-row.mode .selection-span.active,.bilibili-player-mode-selection-container .bilibili-player-mode-selection-panel .bilibili-player-mode-selection-row.mode .selection-span.active:hover,.bilibili-player-mode-selection-container .bilibili-player-mode-selection-panel .bilibili-player-mode-selection-row.mode .selection-span:hover,.bilibili-player-video-danmaku-setting-left-block .bilibili-player-video-danmaku-setting-left-block-content .bilibili-player-block-filter-type.disabled .bilibili-player-block-filter-image,.bilibili-player-video-danmaku-setting:hover,.bilibili-player-video-sendbar .bilibili-player-video-btn:hover,.bui-checkbox .bui-checkbox-input:checked+.bui-checkbox-label .bui-checkbox-icon svg,.bui-checkbox:hover .bui-checkbox-icon svg,.bui-switch .bui-checkbox:checked+.bui-body .bui-dot{fill:var(--theme-color)!important}.gui-settings-close path{fill:#eee}.history-list .l-info .lastplay-time .history-red-round,.history-wrap .active:before,.history-wrap .time-label:after{border-top-color:transparent!important;border-bottom-color:transparent!important}.tag-panel .more-button .more::after .tag-panel .more-button .more:hover::after{border-top-color:transparent!important;border-right-color:transparent!important}.be-tab-cursor:after,.bili-tab-item:before,.dynamic-m .dyn_menu .line:before{border-color:var(--theme-color)!important}.be-tab-cursor:after,.bili-tab-item:before,.common-popup-wrap .arrow,.dynamic-m .dyn_menu .line:before{border-left-color:transparent!important;border-right-color:transparent!important}.chat-history-panel .chat-history-list::-webkit-scrollbar-track,.multi-page .cur-list ul::-webkit-scrollbar-track{background:#444!important}.chat-history-panel .chat-history-list::-webkit-scrollbar-thumb,.multi-page .cur-list ul::-webkit-scrollbar-thumb{background:#222!important}.chat-history-panel .chat-history-list::-webkit-scrollbar-thumb:hover,.multi-page .cur-list ul::-webkit-scrollbar-thumb:hover{background:#333!important}.chat-history-panel .chat-history-list,.multi-page .cur-list ul{scrollbar-color:#444 #222!important}::-webkit-scrollbar{width:5px!important;height:5px!important}::-webkit-scrollbar-corner,::-webkit-scrollbar-track{background:0 0!important}::-webkit-resizer,::-webkit-scrollbar-thumb{background:#444!important;border-radius:3px}::-webkit-scrollbar-thumb:hover{background:#555!important}*{scrollbar-color:#444 transparent!important;scrollbar-width:thin!important}.coverNews-item .coverNews-item-title{color:#eee!important}.coverNews-item .coverNews-item-time{color:#aaa!important}.vote-backdrop .extension-wrapper .title-box{background-color:#222!important;border-color:transparent!important}.vote-backdrop .extension-wrapper iframe{background-color:#222!important}.action-menu .menu-list a,.dialog-ctnr.bottom-left,.pay-note-panel,.suggest-wrap .keyword-wrap .keyword.focus{background-color:#333!important}.pay-note-panel .arrow-left,.pay-note-panel .arrow-right{filter:invert(.7)!important}.chat-history-panel .card-item-middle-top,.vote-result-comment{background-color:transparent!important}.chaos-pk-rank .link-to-history{color:#aaa!important}.bl-button--primary:disabled,.chaos-pk-rank .rank .rank-name,.chasing-frame-cntr .chasing,.chat-history-panel .chat-history-list .chat-item.superChat-card-detail .card-item-middle-top .card-item-middle-top-right,.ep-item.v4.cursor .ep-pub,.notice-info-wrapper .notice-info-title{color:#eee!important}.primary-menu-itnl,.vote-pc-container .card,.vote-result-comment .reply-item{border-color:transparent!important}.bi-btn,.channel-menu-itnl .item .name em,.ep-list-wrapper .ep-item .badge,.live-room-app .guard-rank-cntr .rank-cntr .btn-box .buy:hover,.pgc-space-follow-item a.pgc-item-cover .badge,.ss-list-wrapper .ss-item .ss-cover .ss-badge{color:var(--foreground-color)!important}.extension-wrapper .vote-left-time{color:#aaa!important}.extension-wrapper input{color:#eee!important}.extension-wrapper .checked{filter:var(--pink-image-filter)!important}.app-layout .search-bar .search-bar-bg,.app-layout .vertical-block-card{background-color:#444!important}.app-layout .rank-item-wrapper{background-image:none!important}.app-layout .manga-navbar-favourite-manga .drop-list .more-btn-container,.app-layout .manga-navbar-history-list .drop-list .more-btn-container{background-color:transparent!important}.app-layout .manga-title,.app-layout .ranking-jump,.app-layout .show-status-text{color:#eee!important}.app-layout .manga-title:hover,.app-layout .ranking-jump:hover,.app-layout .show-status-text:hover{color:var(--theme-color)!important}.app-layout .sidebar-item,.app-layout .time-selector-ctnr{color:#eee!important}.app-layout .sidebar-item.activated,.app-layout .sidebar-item:hover,.app-layout .time-selector-ctnr.activated,.app-layout .time-selector-ctnr:hover{color:var(--theme-color)!important}.app-layout .sidebar-item .arrow,.app-layout .time-selector-ctnr .arrow{filter:var(--blue-image-filter)!important}.app-layout .banner-manga-container .tab-item{color:#eee!important}.app-layout .banner-manga-container .tab-item.activated{color:var(--theme-color)!important}.app-layout .banner-manga-container .tab-item.activated:after{background-color:var(--theme-color)!important}.app-layout .nav-list .nav-item .item-icon{filter:var(--blue-image-filter)!important}.app-layout .list-item,.app-layout .rank-title{color:#eee!important}.app-layout .list-item .title-tooltip,.app-layout .rank-title .title-tooltip{background-color:#555!important}.app-layout .list-item .title-tooltip:before,.app-layout .rank-title .title-tooltip:before{background-color:transparent!important}.app-layout .item-title,.app-layout .list-item .title-tooltip .tooltip-text,.app-layout .rank-title .title-tooltip .tooltip-text{color:#eee!important}.app-layout .item-title:hover{color:var(--theme-color)!important}.app-layout .manga-info-ctnr,.app-layout .meta-ctnr,.app-layout .rank-hint{color:#aaa!important}.app-layout .section-navigator{border-color:transparent!important}.card-detail .card-item-middle-top{background-color:#333!important}.card-detail .card-item-middle-top .card-item-middle-top-right .content-bottom .price,.card-detail .card-item-middle-top .card-item-middle-top-right .name{color:#eee!important}.super-chat-bubble-main .super-chat-bubble .content-top{background-color:#333!important}.super-chat-bubble-main .super-chat-bubble .content-top .content-price .sub-price{color:#aaa!important}.super-chat-bubble-main .super-chat-bubble .content-top .content-name,.super-chat-bubble-main .super-chat-bubble .content-top .content-price{color:#eee!important}.wrapper .edit-video-modal .target-favlist .target-favitem.disabled .target-fav-title .fav-meta .fav-name,.wrapper .edit-video-modal .target-favlist .target-favitem.full .target-fav-title .fav-meta .fav-name{color:#aaa!important}.wrapper .edit-video-modal .target-favlist .target-favitem .target-fav-title .fav-meta .fav-name{color:#eee!important}.wrapper .edit-video-modal .target-favlist .target-favitem .target-fav-title .fav-select{border-color:#aaa!important}.wrapper .edit-video-modal .target-favlist .target-favitem .target-fav-title .fav-select.selected{filter:var(--blue-image-filter)!important}.wrapper .edit-video-modal .target-favlist .target-favitem:hover{background-color:transparent!important}.wrapper .edit-video-modal .target-favlist .target-favitem:hover .target-fav-title .fav-meta .fav-name{color:var(--theme-color)!important}.wrapper .edit-video-modal .target-favlist .collection-mask{background-color:transparent!important}.wrapper .edit-video-modal .addfav-container .fake-fav-input{background-color:#444!important;border-color:transparent!important}.wrapper .edit-video-modal .addfav-container .fake-fav-input:hover{border-color:transparent!important}.wrapper .edit-video-modal .addfav-container .fav-add-tip{background-color:var(--theme-color)!important;color:#eee!important}.wrapper .edit-video-modal .addfav-container .fav-add-tip .blue-arrow{filter:var(--blue-image-filter)!important}.wrapper .edit-video-modal .addfav-container .fav-container{border-color:var(--theme-color)!important}.wrapper .edit-video-modal .addfav-container .fav-container .add-fav-input,.wrapper .edit-video-modal .addfav-container .fav-container .fav-add-btn{background-color:transparent!important;color:#eee!important;border-color:transparent!important}.wrapper .edit-video-modal .favlist-body:after{background-color:#aaa!important}#all-list .video-item.list{border-color:#444!important}#all-list .video-item.list .type{background-color:#444!important;color:#eee!important;border-color:transparent!important}#all-list .video-item.list .headline.singleav .avid{background-color:var(--theme-color)!important;color:var(--foreground-color)!important;border-color:transparent!important}#all-list .video-item.list .headline.singleav .title{color:var(--theme-color)!important}#all-list .video-item.list .title{color:#eee!important}#all-list .video-item.list .title:hover{color:var(--theme-color)!important}#all-list .video-item.list .des{color:#aaa!important}#all-list .game-item .info .title{color:#eee!important}#all-list .game-item .info .title:hover{color:var(--theme-color)!important}#all-list .game-item .info .type{background-color:#444!important;color:#eee!important;border-color:transparent!important}#all-list .game-item .info .desc{color:#aaa!important}#all-list .pgc-item .v-switcher-header-wrap:before{background-color:transparent!important}#all-list .pgc-item .v-switcher-header-item{color:#eee!important}#all-list .pgc-item .v-switcher-header-item.is-active,#all-list .pgc-item .v-switcher-header-item:hover{color:var(--theme-color)!important;border-color:var(--theme-color)!important}#all-list .pgc-item .v-switcher-header-item.is-active:after{filter:var(--blue-image-filter)!important}.cc-album-manage .article-card{background-color:#444!important;border-color:transparent!important}.cc-album-manage .article-card .cover-wrp{background-color:#444!important}.cc-album-manage .article-card .meta-footer .view-stat,.cc-album-manage .article-card .meta-status .description,.cc-album-manage .article-card .meta-status .pubdate{color:#aaa!important}.cc-album-manage .article-card .meta-view .delete{background-color:#333!important;color:#aaa!important}.cc-album-manage .article-card .meta-view .delete:hover{background-color:#222!important}.game-content .score-contain .page-btn{background-color:#444!important;color:#aaa!important;border-color:transparent!important}.game-content .score-contain .allmatch{background-color:#444!important;color:#eee!important;border-color:transparent!important}.game-content .score-contain .allmatch .more-match{background:0 0!important}.game-content .card-score .score-wrap{border-color:#444!important}.game-content .card-score .score-wrap .title .title-text{color:#aaa!important}.game-content .card-score .score-wrap .time-wrap{color:#eee!important}.game-content .card-score .score-wrap .time-wrap .text.state.nobegin{color:var(--theme-color)!important}.game-content .card-score .score-wrap .default-btn,.game-content .card-score .score-wrap .primary-btn{background-color:#444!important;color:#eee!important;border-color:transparent!important}.game-content .card-score .score-wrap .default-btn:hover,.game-content .card-score .score-wrap .primary-btn:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.game-content .match-box .card-video .video-wrap .video-info .title a,.game-content .match-box .main-title,.game-content .match-box .sub-title{color:#eee!important}.game-content .match-box .card-video .video-wrap .video-info .title a:hover{color:var(--theme-color)!important}.game-content .match-box .card-video .video-wrap .video-info .detail{color:#aaa!important}.game-content .match-box .matchlist-contain .match-wrap .matchlist-title a{color:#eee!important}.game-content .match-box .matchlist-contain .match-wrap .matchlist-title a:hover{color:var(--theme-color)!important}.game-content .match-box .matchlist-contain .match-wrap .match-time{color:#aaa!important}.game-content .match-box .matchlist-contain .more-match{background-color:#444!important;color:#eee!important;border-color:transparent!important}.game-content .match-box .matchlist-contain .more-match:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.game-content .match-box .newslist-contain .news-wrap .news-title a{color:#eee!important}.game-content .match-box .newslist-contain .news-wrap .news-title a:hover{color:var(--theme-color)!important}.game-content .match-box .newslist-contain .news-wrap .news-title .hot-label{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.game-content .match-box .newslist-contain .news-wrap .news-time{color:#aaa!important}.game-content .match-box .user-contain .page-btn{background-color:#444!important;color:#aaa!important;border-color:transparent!important}.game-content .match-box .user-contain .primary-btn{background-color:#444!important;color:#eee!important}.game-content .match-box .user-contain .primary-btn:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.proxy-box .manga-panel .app-download-link,.proxy-box .manga-panel .manga-list-box .manga-card .manga-tag,.proxy-box .manga-panel .tab-switch{color:#aaa!important}.proxy-box .manga-panel .app-download-link .tab-switch-item.on,.proxy-box .manga-panel .manga-list-box .manga-card .manga-tag .tab-switch-item.on,.proxy-box .manga-panel .tab-switch .tab-switch-item.on,.proxy-box .manga-rank .tab-switch .tab-switch-item.on{color:var(--theme-color)!important;border-color:var(--theme-color)!important}.proxy-box .manga-rank .manga-rank-item .rank-number{background-color:#444!important;color:#eee!important}.proxy-box .manga-rank .manga-rank-item .rank-number.on{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.proxy-box .manga-rank .manga-rank-item a{color:#eee!important}.proxy-box .manga-rank .manga-rank-item a:hover{color:var(--theme-color)!important}.proxy-box .manga-rank .manga-rank-item .style,.proxy-box .manga-rank .manga-rank-item .update{color:#aaa!important}.buyticket .detail-info-wrapper .title{color:#eee!important}.buyticket .selectable-option{background-color:#444!important;border-color:transparent!important}.buyticket .selectable-option.unable{background-color:#111!important;color:#666!important}.buyticket .ticket-count{background-color:#444!important;border-color:transparent!important}.buyticket .product-buy-wrapper .unsale-btn{filter:var(--pink-image-filter)!important}.buyticket .product-buy-wrapper .promo-btn.remind-btn{background-color:#444!important;color:#eee!important;border-color:transparent!important}.buyticket .product-buy-wrapper .promo-btn.remind-btn:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.buyticket .modal-container .remind-title{color:#eee!important}.buyticket .modal-container .remind-tel input{background-color:#333!important;color:#eee!important;border-color:transparent!important;border-radius:4px}.buyticket .modal-container .modal-footer-btn div{background-color:#333!important;color:#eee!important;border-color:transparent!important}.buyticket .modal-container .modal-footer-btn div:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.detail-content .whole-guest-wrapper .guest-list-content .guest-left,.detail-content .whole-guest-wrapper .guest-list-content .guest-right{filter:invert(.8)!important}.detail-content .announcement-wrapper{background-color:#444!important;border-color:transparent!important}.detail-content .announcement-wrapper .announcement-icon,.detail-content .announcement-wrapper .announcement-item.active .circle{filter:var(--pink-image-filter)!important}.detail-content .activity-info-body .info-body p strong,.detail-content .activity-info-body .info-body ul li .title,.detail-content .announcement-wrapper .announcement-item-desc a,.detail-content .announcement-wrapper .announcement-item.active .announcement-item-time,.detail-content .announcement-wrapper .announcement-title{color:#eee!important}.bilibili-player .bilibili-player-video-control .bilibili-player-video-btn-menu-list.bilibili-player-active{color:var(--theme-color)!important}.bilibili-player .bilibili-player-video-control .bilibili-player-video-btn-menu-list.bilibili-player-active:before{filter:var(--blue-image-filter)!important}.bilibili-player .bilibili-player-video-control .bilibili-player-video-btn-menu-list.bilibili-player-active.bilibili-player-blink{color:var(--theme-color)!important}.bilibili-player .bilibili-player-video-control .bilibili-player-video-btn-menu-list.bilibili-player-blink{color:#eee!important}.bilibili-player .bilibili-player-video-control .bilibili-player-video-btn-menu-list.bilibili-player-blink .bilibili-player-tips{background-color:var(--theme-color)!important}.bilibili-player .bilibili-player-video-control .bilibili-player-video-btn-menu-list.bilibili-player-blink:active,.bilibili-player .bilibili-player-video-control .bilibili-player-video-btn-menu-list.bilibili-player-blink:hover{color:var(--theme-color)!important}.bilibili-player .bilibili-player-video-control .bilibili-player-video-btn .bilibili-player-video-quality-menu .bilibili-player-bigvip,.bilibili-player .bilibili-player-video-control .bilibili-player-video-btn-menu-list .bilibili-player-tips{color:var(--foreground-color)!important}.home-page .publish-panel .core-style{background-color:#222!important;color:#eee!important;border-color:transparent!important}.home-page .publish-panel .core-style:active,.home-page .publish-panel .core-style:focus-within,.home-page .publish-panel .core-style:hover{border-color:var(--theme-color)!important}.home-page .publish-panel .schedule-bar{background-color:#333!important}.home-page .publish-panel .schedule-bar .dp-label,.home-page .publish-panel .schedule-bar .s-label{color:#eee!important}.home-page .publish-panel .schedule-bar .scroll-input .s-input{background-color:#222!important;color:#eee!important;border-color:transparent!important}.home-page .publish-panel .schedule-bar .s-panel{background-color:#222!important;border-color:transparent!important}.home-page .publish-panel .schedule-bar .s-panel .s-item{color:#eee!important}.home-page .publish-panel .schedule-bar .s-panel .s-item:hover{color:var(--theme-color)!important}.home-page .publish-panel .toolbar .static-popup{background-color:#222!important;border-color:transparent!important}.home-page .publish-panel .toolbar .static-popup .title{color:#eee!important}.home-page .publish-panel .toolbar .static-popup .upload-image .upload-btn:hover{color:var(--theme-color)!important;border-color:var(--theme-color)!important}.home-page .publish-panel .toolbar .bp-vote-container .create-vote{background-color:#222!important;color:#eee!important;border-color:transparent!important}.home-page .publish-panel .toolbar .bp-vote-container .create-vote .title{color:#eee!important}.home-page .publish-panel .toolbar .bp-vote-container .create-vote .bp-button:nth-child(2){background:var(--theme-color)!important;color:var(--foreground-color)!important}.home-page .publish-panel .toolbar .publish-btn{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.home-page .publish-panel .toolbar .publish-btn.disabled{background-color:#222!important;color:#eee!important}.home-page .h5share-container:hover .text-area .text{color:var(--theme-color)!important}.up-info .u-info .name .live-status{color:var(--theme-color)!important;border-color:var(--theme-color)!important}.up-info .u-info .name .live-status:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.popover-video-card{background-color:#333!important}.popover-video-card .count{border-color:#444!important}.popover-video-card .content .info .subtitle,.popover-video-card .count ul li{color:#aaa!important}.popover-video-card .content .info .f-title{color:#eee!important}.v-wrap .season-info,.v-wrap .season-tabs .tabs,.v-wrap .video-toolbar{border-color:#444!important}.v-wrap .season-info .stat{color:#aaa!important}.v-wrap .season-info .desc,.v-wrap .season-info .title,.v-wrap .season-owner .info .desc,.v-wrap .season-owner .info h3 a{color:#eee!important}.v-wrap .season-detail .content-img,.v-wrap .season-detail .faq.faq,.v-wrap .season-detail .note.faq{border-color:#444!important}.message .message-content{background-color:#222!important}.message .context-menu{background-color:#444!important;color:#eee!important}.shop-panel .panel-desc{color:#eee!important}.shop-panel .panel-desc .shop-icon{filter:brightness(0) invert(1)!important}.shop-panel .shop-list{background-color:#222!important}.shop-panel .shop-list .shop-desc .desc-box .title{color:#eee!important}.shop-panel .shop-list .shop-desc .desc-box .sub-title{color:#aaa!important}.shop-panel .shop-list .shop-desc .desc-box .price-desc{color:var(--theme-color)!important}.shop-panel .shop-list .shop-desc .btn-box .jump-btn{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.link-navbar{background-image:none!important}.danmaku-wrap .player-auxiliary-area .player-auxiliary-danmaku-wrap .player-auxiliary-danmaku-list .danmaku-info-row-code{background:#ffa20011!important}.notice-item .notice-main .notice-title{color:#eee!important}.notice-item .notice-main .notice-title:before{background-color:var(--theme-color)!important}.notice-item .notice-main .notice-time{color:#aaa!important}.notice-item .notice-btn{color:#eee!important;background-color:#222!important}.recent-danmu-wrp .danmu-filter .left{border-color:#aaa!important}.recent-danmu-wrp .danmu-filter .left .plain{color:#eee!important;border-color:#aaa!important}.recent-danmu-wrp .danmu-filter .left .plain.disable{color:#aaa!important}.recent-danmu-wrp .danmu-filter .left .delete .option-wrp .act-btn{background-color:transparent!important}.recent-danmu-wrp .danmu-filter .left .option-menu{background-color:#444!important;border-color:transparent!important}.recent-danmu-wrp .danmu-filter .left .option-menu .menu-item{color:#eee!important}.recent-danmu-wrp .danmu-filter .left .option-menu .menu-item:hover{background-color:#333!important}.recent-danmu-wrp .danmu-filter .left .option-menu .option-arrow{border-color:transparent!important}.recent-danmu-wrp .danmu-filter .left .option-menu .option-arrow-border{border-color:transparent transparent #444!important}.recent-danmu-wrp .danmu-container .danmu-table{color:#eee!important}.recent-danmu-wrp .danmu-container .danmu-table .box-header{background-color:#444!important;border-color:transparent!important}.recent-danmu-wrp .danmu-container .danmu-table .box-header th{color:#eee!important}.recent-danmu-wrp .danmu-container .danmu-table tr:hover{background-color:#444!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item{background-color:#555!important;border-color:transparent!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item:nth-child(2n){background-color:#444!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item:hover{background-color:#333!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item .item-content,.recent-danmu-wrp .danmu-container .danmu-table .danmu-item .item-name a{color:#eee!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item .item-content a{color:#aaa!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item .item-content a:hover{color:var(--theme-color)!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item .item-act .option-wrp .act-btn{background-color:#333!important;color:#aaa!important;border-color:transparent!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item .item-act .option-wrp .act-btn:hover{color:var(--theme-color)!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item .item-act .option-wrp .menu-item{color:#eee!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item .item-act .option-wrp .menu-item:hover{background-color:#333!important}.recent-danmu-wrp .danmu-container .danmu-table .bili-checkbox:checked+span:before{background-color:var(--theme-color)!important;color:var(--foreground-color)!important;border-color:transparent!important}.s-space .v-search-result{color:#aaa!important}.s-space .article-con a:hover,.s-space .v-search-count{color:var(--theme-color)!important}#app .header .left-block .logo{color:var(--theme-color)!important}#app .header .left-block .main-site,#app .header .right-block{color:#eee!important}#app .cc-nav-wrp,#app .header .right-block .i-frame::before{background-color:transparent!important}#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-sub-menu a,#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-sub-menu>span{color:#eee!important}#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-sub-menu .router-item.active,#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-sub-menu .router-item.active i{color:var(--theme-color)!important}#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-sub-menu .router_wrap i{color:#aaa!important}#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-sub-menu .router_wrap.active,#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-sub-menu .router_wrap.active i{color:var(--theme-color)!important}#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-sub-menu:hover{background:0 0!important}#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-sub-menu__group .router-item,#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-sub-menu__group a{color:#aaa!important}#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-item__wrap .router-item.active,#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-item__wrap .router-item.active i{color:var(--theme-color)!important}#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-item__wrap .router_wrap i{color:#aaa!important}#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-item__wrap:hover{background:0 0!important}#app .cc-body{background-color:transparent!important}#app .cc-body .message-notice_wrap .tips-item_wrap{background-color:#444!important}#app .cc-body .chief-recommend-module .carousel-box,#app .cc-body .data-card{background-color:transparent!important}#app .cc-body .new-calendar-wrap{background-color:#222!important}#app .cc-body .new-calendar-wrap .calendarEntry_box .calendarEntry_content{color:#eee!important}#app .cc-body .new-calendar-wrap .calendarEntry_box .calendarEntry_content .luck_wrap .luck_title{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}#app .cc-body .new-calendar-wrap .headerClass{color:#eee!important}#app .cc-body .new-calendar-wrap .calendar-header{border-color:#444!important}#app .cc-body .new-calendar-wrap .calendar-body .date-wrap{color:#aaa!important}#app .cc-body .new-calendar-wrap .calendar-body .date-wrap .wrap-content .today{color:var(--theme-color)!important}#app .cc-body .new-calendar-wrap .calendar-body .date-desc_wrap{background:0 0!important}#app .cc-body .new-calendar-wrap .calendar-body .date-desc_wrap .item-desc_card{background-color:#333!important}#app .cc-body .new-calendar-wrap .calendar-body .date-desc_wrap .item-desc_card .item-desc_title .item-title{color:#eee!important}#app .cc-body .new-calendar-wrap .calendar-body .date-desc_wrap .item-desc_card .item-desc_body .item-desc__content{color:#eee!important;border-color:transparent!important}#app .cc-body .new-calendar-wrap .calendar-body .date-desc_wrap .item-desc_card .item-desc_body .item-desc__content .nothing-wrap{background:0 0!important}#app .cc-body .new-calendar-wrap .calendar-body .date-desc_wrap .item-desc_card .item-desc_body .item-desc__content .nothing-wrap .release-link{color:var(--theme-color)!important}#app .cc-body .new-calendar-wrap .calendar-body .calendar-box{border-color:transparent!important}#app .cc-body .notice_wrap{background-color:#444!important}#app .cc-body .notice_wrap .notice_title .notice-txt{color:#eee!important}#app .cc-body .notice_wrap .notice_body .hot-item .item-left p,#app .cc-body .notice_wrap .notice_body .hot-item .item-right{color:#aaa!important}#app .cc-body .academy-wrap{background-color:transparent!important}#app .cc-body .academy-wrap .header .academy-tag{color:#eee!important}#app .cc-body .academy-wrap .content .tabs .tabs__header{border-color:#444!important}#app .cc-body .academy-wrap .content .tabs .tabs__header .tabs__header-item{color:#aaa!important}#app .cc-body .academy-wrap .content .tabs .tabs__header .tabs__header-item.is-active{color:var(--theme-color)!important}#app .cc-body .academy-wrap .content .tabs .tabs__header .tabs__header-item.is-active:after{background-color:var(--theme-color)!important}#app .cc-body .academy-wrap .content .list-item .title{color:#eee!important}#app .cc-body .academy-wrap .content .list-item .view{color:#aaa!important}#app .cc-body .side-utils .feedback-container .item-desc{color:#eee!important}#app .cc-body .side-utils .feedback-container .bcc-popover{background-color:#444!important;color:#eee!important;border-color:transparent!important;box-shadow:0 7px 11px 0 rgba(0,0,0,.18)!important}#app .cc-body .side-utils .feedback-container .bcc-popover .help-wrap li .title,#app .cc-body .side-utils .feedback-container .bcc-popover .help-wrap li .title .bcc-icon-ic_enter{color:#eee!important}#app .cc-body .side-utils .feedback-container .bcc-popover .help-wrap li:hover{background-color:#333!important}#app .cc-body .side-utils .feedback-container .bcc-popover[x-placement^=left] .popper__arrow,#app .cc-body .side-utils .feedback-container .bcc-popover[x-placement^=left] .popper__arrow:after{border-color:transparent!important}#app .cc-body .dc-section1-body{background-color:transparent!important}#app .cc-body .dc-section1-body .dc-section-item1_title_name p{color:#eee!important}#app .cc-body .lab-wrap{background-color:transparent!important}#app .cc-body .lab-wrap .lab-guide img{filter:brightness(.5) contrast(3)!important}#app .cc-body .lab-wrap .lab-title{color:#aaa!important}#app .cc-body .lab-wrap .lab-item{border-color:#444!important}#app .cc-body .lab-wrap .lab-item .lab-item-header .item-info .item-title .title{color:#eee!important}#app .cc-body .lab-wrap .lab-item .lab-item-header .item-info .item-title .desc{color:#aaa!important}#app .cc-body .lab-wrap .lab-item .lab-item-header .item-operate span{color:#eee!important}#app .cc-body .lab-wrap .lab-item .lab-item-content{background-color:transparent!important}#app .cc-body .lab-wrap .lab-item .lab-item-content .divide-line{background-color:#444!important}#app .cc-body .lab-wrap .lab-item .lab-item-content .content-detail p{color:#eee!important}#app .cc-body .lab-wrap .lab-item .lab-item-content .content-detail .detail-desc,#app .cc-body .lab-wrap .lab-item .lab-item-content .content-detail .feedback{color:#aaa!important}#app .cc-body .lab-wrap .lab-item .lab-item-content .content-detail .detail-desc a,#app .cc-body .lab-wrap .lab-item .lab-item-content .content-detail .feedback a{color:var(--theme-color)!important}#app .cc-body .lab-wrap .lab-item .lab-item-content .content-detail .carousel-wrapper .panel .pic .card-img img{filter:brightness(.5) contrast(3)!important}#app .cc-body .cc-article-wrp .article-header .search-wrp{border-color:transparent!important}#app .cc-body .cc-article-wrp .article-card .meta-status .status{color:var(--theme-color)!important}#app .cc-body .cc-article-wrp .article-card .select-box .select-item.is-disabled,#app .detail{background-color:transparent!important}#app .category{background-color:#444!important}.el-popover{background-color:#222!important;border-color:transparent!important}.el-popover.header-popover-download .link div p:first-child{color:#eee!important}.el-popover.header-popover-download .link:hover{background-color:#444!important}.round-corner .international-header .mini-type{background-color:#222!important;box-shadow:rgba(0,0,0,.4) 0 2px 10px 1px!important}.round-corner .international-header .mini-type .nav-link .nav-link-ul .nav-link-item .link .bili-Navbar_logo,.round-corner .international-header .mini-type .nav-link .nav-link-ul.mini .bili-icon_dingdao_xiazaiapp,.round-corner .international-header .mini-type .nav-user-center .user-con .item .name{color:#eee!important}.round-corner .channel-menu-mini{background-color:#222!important;box-shadow:rgba(0,0,0,.3) 0 4px 8px 0!important}.round-corner .channel-menu-mini .r-box{border-color:#444!important}.round-corner .van-popper-avatar .level-info .grade{color:#eee!important}.round-corner .van-popper-avatar .coins,.round-corner .van-popper-avatar .counts{border-color:#444!important}.round-corner .van-popper-avatar .count-item .item-key,.round-corner .van-popper-avatar .count-item .item-value{color:#eee!important}.round-corner .van-popper-avatar .links{border-color:#444!important}.round-corner .van-popper-avatar .links .link-title{color:#eee!important}.round-corner .van-popper-avatar .links .link-item:hover{background-color:#333!important}.round-corner .van-popper-favorite .tab-item--normal,.round-corner .van-popper-favorite .video-info .line-2{color:#eee!important}.round-corner .van-popper-favorite .tab-item--active{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.round-corner .van-popper-favorite .tabs-panel{border-color:#444!important}.round-corner .van-popper-favorite .tab-item--normal:hover,.round-corner .van-popper-favorite .video-card:hover{background-color:#333!important}.round-corner .van-popper-favorite .play-all{background-color:transparent!important;border-color:#444!important}.round-corner .van-popper-history .tab-header{border-color:#444!important}.round-corner .van-popper-history .tab-header .tab-item{color:#eee!important}.round-corner .van-popper-history .tab-header .tab-item--active{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.round-corner .van-popper-history .panel .video-card:hover{background-color:#333!important}.round-corner .van-popper-history .panel .progress{background-color:var(--theme-color)!important}.round-corner .van-popper-history .panel .video-info span.date{background-color:transparent!important}.round-corner .van-popper-history .panel .video-info .line-2{color:#eee!important}.round-corner .page-container .bangumi-spoiler-container{background-color:#444!important;color:#eee!important}.round-corner .page-container .tag-container .tag-item span{color:#eee!important}.round-corner .page-container .tag-container .tag-item .tag-border .tag-border-inner{display:none}.round-corner .page-container .tag-container .tag-item .tag-content{background-color:#444!important;border-color:transparent!important}.round-corner .page-container .tag-container .tag-item:hover .tag-content{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.round-corner .page-container .publish-panel .core-style{background-color:#222!important;color:#eee!important;border-color:transparent!important}.round-corner .page-container .publish-panel .core-style:active,.round-corner .page-container .publish-panel .core-style:focus-within,.round-corner .page-container .publish-panel .core-style:hover{border-color:var(--theme-color)!important}.round-corner .page-container .publish-panel .publish-btn{background-color:#222!important;color:#eee!important}.round-corner .page-container .publish-panel .publish-btn:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.round-corner .container-body .b-head.topic{border-color:transparent!important}.round-corner .container-body .art_list li{background-color:transparent!important;border-color:transparent!important}.round-corner .container-body .art_list li h2 a{color:#eee!important}.round-corner .container-body .art_list li .artInfo,.round-corner .container-body .art_list li .info{color:#aaa!important}.canary-container .file-list-v2-container .fans-dynamic-v2-container .fans-dynamic-v2-title-wrp>h1,.canary-container .file-list-v2-container .file-title h1,.canary-container .file-list-v2-container .normal-v2-container .normal-title-wrp>h1{color:#eee!important}.canary-container .file-list-v2-container .upload-v2-sortable-chosen,.canary-container .file-list-v2-container .upload-v2-sortable-ghost{background-color:#444!important}.canary-container .file-list-v2-container .input-box-v2-3-container{background-color:#444!important;border-color:transparent!important}.canary-container .file-list-v2-container .input-box-v2-3-container>input{color:#eee!important}.canary-container .file-list-v2-container .input-box-v2-3-container.input-box-v2-3-active,.canary-container .file-list-v2-container .input-box-v2-3-container:hover{border-color:var(--theme-color)!important}.canary-container .file-content-v2-container .normal-v2-container .normal-title-wrp>h1{color:#eee!important}.canary-container .file-content-v2-container .cover-v2-detail-wrp .cover-v2-selector{border-color:#444!important}.canary-container .file-content-v2-container .cover-v2-detail-wrp .cover-v2-selector .cover-v2-selector-deg{background-color:#444!important;border-color:transparent!important}.canary-container .file-content-v2-container .cover-preview-modal-container .cover-preview-modal-content{background-color:#444!important}.canary-container .file-content-v2-container .cover-preview-modal-container .cover-preview-modal-content .cover-preview-modal-head{color:#eee!important;border-color:transparent!important}.canary-container .file-content-v2-container .cover-preview-modal-container .cover-preview-modal-content .cover-preview-modal-body .cover-preview-modal-body-item-selected{border-color:var(--theme-color)!important}.canary-container .file-content-v2-container .cover-preview-modal-container .cover-preview-modal-content .cover-preview-modal-body .cover-preview-modal-body-item-selected-icon{filter:var(--blue-image-filter)!important}.canary-container .file-content-v2-container .cover-preview-modal-container .cover-preview-modal-content .cover-preview-modal-foot div:first-child{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.canary-container .upload-step-3-container-v2{background-color:transparent!important}.canary-container .upload-step-3-container-v2 .step-controller-v2-container .step-ctrl-complete-content,.canary-container .upload-step-3-container-v2 .step-controller-v2-container .step-ctrl-wait-content{color:#aaa!important}.canary-container .upload-step-3-container-v2 .step-controller-v2-container .step-ctrl-active-content{color:#eee!important}.canary-container .upload-step-3-container-v2 .step-controller-v2-container .step-ctrl-complete-icon{color:var(--theme-color)!important;border-color:var(--theme-color)!important}.canary-container .upload-step-3-container-v2 .step-controller-v2-container .step-ctrl-line-active{background-color:var(--theme-color)!important}.canary-container .upload-step-3-container-v2 .step-controller-v2-container .step-ctrl-active-icon{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.canary-container .upload-step-3-container-v2 .step-controller-v2-container .step-ctrl-line.step-ctrl-line-wait{background-color:#444!important}.canary-container .upload-step-3-container-v2 .step-controller-v2-container .step-ctrl-wait-icon{color:#444!important;border-color:#444!important}.canary-container .upload-step-3-container-v2 .upload-3-v2-success-split{background-color:#444!important}.canary-container .upload-step-3-container-v2 .upload-3-v2-success-go-url a{background-color:#444!important;color:#eee!important;border-color:transparent!important}.canary-container .upload-step-3-container-v2 .upload-3-v2-success-go-url a:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important;border-color:transparent!important}.canary-container .upload-step-3-container-v2 .upload-3-v2-success-hint-2{color:#aaa!important}.canary-container .upload-step-3-container-v2 .upload-3-v2-follow{background-color:transparent!important}.canary-container .upload-step-3-container-v2 .upload-3-v2-follow-name,.canary-container .upload-step-3-container-v2 .upload-3-v2-follow-title{color:#aaa!important}.canary-container .upload-step-3-container-v2 .upload-3-v2-follow-btn.follow{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.room-feed .tabs .item>span:after{background-color:var(--theme-color)!important}.customer-service .panel-title,.customer-service .self-panel .scroll-container .item>span{color:#eee!important}.customer-service .customer-card{border-color:#444!important}.customer-service .customer-card .card-header{background-color:#444!important}.customer-service .customer-card .card-header .name{color:#eee!important}.customer-service .customer-card .card-content>a{color:#aaa!important}.customer-service .customer-card .card-content>a:hover{color:var(--theme-color)!important}.customer-service .guess-panel .panel-header .title{color:#eee!important}.customer-service .guess-panel .question-container{border-color:#444!important}.customer-service .guess-panel .question-container .title .circle{background-color:var(--theme-color)!important}.customer-service .guess-panel .question-container .title>p{color:#eee!important}.customer-service .guess-panel .question-container .answer{color:#aaa!important}.customer-service .guess-panel .question-container .answer>a{color:var(--theme-color)!important}.customer-service .other-panel .card .title{color:#eee!important;border-color:transparent!important}.customer-service .other-panel .card .detail p,.customer-service .other-panel .card .detail-text{color:#eee!important}.customer-service .other-panel .card .detail p>a,.customer-service .other-panel .card .detail-text>a{color:var(--theme-color)!important}.customer-service .other-panel .card .detail .ask-btn{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}#app-body #player-and-interaction-area #head-info,#app-body #player-and-interaction-area .aside-area,#app-body #player-and-interaction-area .gift-control-panel{background-color:#444!important}#app-body #player-and-interaction-area #gift-control-area{border-color:transparent!important}#app-body #section-ctnr .header{background-color:transparent!important}.imagesbox .boost-slider-wrap .boost-slider-border{border-color:var(--theme-color)!important}.superchat-content{background-color:#444!important}.superchat-content .home-page{background-image:none!important}.superchat-content .home-page .introduction{color:#eee!important}.superchat-content .home-page .close,.superchat-content .home-page .introduction:before{filter:brightness(0) invert(1)!important}.superchat-content .home-page .superchat-textarea .base-info{background-color:transparent!important}.superchat-content .home-page .superchat-textarea .base-info .duration-tip{color:#eee!important}.superchat-content .home-page .superchat-textarea .base-info .duration-tip .time-icon{filter:brightness(0) invert(1)!important}.superchat-content .home-page .superchat-textarea .user-info{color:#eee!important}.superchat-content .home-page .superchat-textarea .text-ctnr,.superchat-content .home-page .superchat-textarea .textarea,.superchat-content .home-page .superchat-textarea .textarea:hover{background-color:transparent!important}.superchat-content .home-page .trans-btn{color:var(--theme-color)!important;border-color:var(--theme-color)!important}.superchat-content .home-page .price-options .price-option{color:#eee!important}.superchat-content .home-page .price-options .price-option.selected{color:var(--theme-color)!important;border-color:var(--theme-color)!important}.superchat-content .home-page .price-options .other{color:#eee!important}.superchat-content .home-page .price-options .other .input{background-color:transparent!important;color:#eee!important}.superchat-content .buy-btn{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.superchat-content .super-rank{background-color:#444!important}.superchat-content .super-rank .top .header-title{color:#eee!important}.superchat-content .super-rank .top .nav{background-color:#222!important}.superchat-content .super-rank .top .nav .nav-item-1,.superchat-content .super-rank .top .nav .nav-item-2{color:#eee!important}.superchat-content .super-rank .top .nav .nav-item-1.active,.superchat-content .super-rank .top .nav .nav-item-2.active{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.superchat-content .super-rank .list-box .empty>.box{background-color:transparent!important}.superchat-content .super-rank .list-box .empty>.box .h2>.special{color:var(--theme-color)!important}.superchat-content .super-rank .list-box .message-item-info .rank-icon>.num{background-color:#222!important;color:#eee!important}.superchat-content .super-rank .list-box .message-item-info>.amount,.superchat-content .super-rank .list-box .message-item-info>.user-info .publish-date{color:#aaa!important}.superchat-content .super-rank .list-box .message-item-context{color:#eee!important}.superchat-content .super-rank .list-box .anchor-item-info>.user-info .amount,.superchat-content .super-rank .list-box .anchor-item-info>.user-info .message-info,.superchat-content .super-rank .list-box .anchor-item-info>.user-info .room{color:#aaa!important}.superchat-content .super-rank .list-box .anchor-item-info>.user-info .user-name{color:#eee!important}.superchat-content .super-rank .list-box .anchor-item-info .rank-icon>.num{background-color:#222!important;color:#eee!important}.superchat-content .super-rank .list-box .anchor-item-assists>.sub-tit{color:#eee!important}.superchat-content .super-rank .list-box .keep-text{color:#aaa!important}.superchat-content .super-rank .on-list-anchor>.right{color:var(--theme-color)!important}.superchat-content .super-rank .not-list>.left>.aside,.superchat-content .super-rank .not-list>.left>.rank{color:#aaa!important}.superchat-content .super-rank .not-list>.left>.aside .special,.superchat-content .super-rank .not-list>.left>.rank .special,.superchat-content .super-rank .not-list>.right{color:var(--theme-color)!important}.rank-item,.rank-item .other{border-color:#444!important}.rank-item .other span{color:#aaa!important}.rank-item .other .other-link .title{color:#eee!important}.rank-item .other .other-link:hover .title{color:var(--theme-color)!important}.card-content .tag{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.wide-members .avatar-list .van-icon-general_back_s:after{background:linear-gradient(-270deg,#444,rgba(255,255,255,0))!important}.wide-members .avatar-list .van-icon-general_enter_s:after{background:linear-gradient(270deg,#444,rgba(255,255,255,0))!important}.wide-members .avatar .tag{background-color:#222!important;color:#eee!important;border-color:var(--theme-color)!important}.router-view .config{background-color:#444!important;color:#eee!important}.router-view .config .css-o1815x{filter:var(--blue-image-filter)!important}.router-view .config .config-item:not(:first-child)::before{background-color:#555!important}.message-list .share-card .footer{color:#aaa!important;border-color:#444!important}.message-list .msg-push{background-color:#222!important}.message-list .msg-push hr{background-color:#444!important}.live-skin-coloration-area .rank-cntr .daily-text{color:#eee!important}.guard-rank-cntr .rank-cntr .btn-box.btn-hundreds{display:none!important}.guard-rank-cntr .rank-cntr .btn-box .daily-record-title{background-color:#222!important;color:#eee!important}.guard-rank-cntr .rank-cntr .btn-box .l-line,.guard-rank-cntr .rank-cntr .btn-box .r-line{border-color:transparent!important}.guard-rank-cntr .rank-cntr .btn-box .guard-daily-record .daily-text{color:#eee!important}.live-record-list .live-record-list-cntr{background-color:#444!important;border-color:transparent!important}.live-record-list .live-record-list-cntr .record-title{color:#eee!important}.live-record-list .live-record-list-cntr .pagination{background-color:transparent!important}.live-record-list .live-record-list-cntr .pagination .jumping-ctnr .jumping-input{background-color:#222!important}.bp-svg-icon.taobao-link{filter:var(--blue-image-filter)!important}#canvas-detail-comment-ctnr,.audioplayer,.audios-wrap #audios-box,.bangumi-collection-card .bangumi-funcs .btn-unfollow,.bangumi-collection-card .bangumi-funcs .btn-unfollow li,.bangumi-review-item,.big-gift-btn-home,.big-more-item-item,.big-more-item-list,.bili-header-m .i_menu_login,.bili-header-m .nav-menu .nav-con .nav-item .bml-box,.bilibili-player-context-menu-container.black,.bilibili-player-contextmenu-subwrapp>span.hover,.bilibili-player-danmaku-setting-lite-panel .bilibili-player-danmaku-setting-lite,.bpui-selectmenu.selectmenu-mode-absolute .bpui-selectmenu-list-row,.btn-confirm.disabled,.buy-info-box,.cc-nav-wrp,.coin-record .table-normal tbody tr:nth-child(odd),.comment-ctnr,.comment-wrap,.danmaku-menu,.el-input__inner,.el-picker-panel,.el-picker-panel [slot=sidebar],.el-picker-panel__sidebar,.el-select-dropdown,.emoji-box,.emoji-box .emoji-tabs,.face-g-action,.face-g-item-inner,.face-g-list .mp-block .right ul li .strip,.face-g-list[id=face-g-log] td,.face-g-list[id=face-g-log] th,.first-change-lb,.first-change-lb:hover,.follow-container .follow-right .follow-intro .follow-fold,.get-coin-more,.go-movie,.guard-desc-box,.gui-settings-box li.category,.h-safe-nobtn,.has-prize,.hold-list,.home-top-level-mask-warp,.home-top-level-up,.identmagBot,.identmagTop,.link-popup-panel,.link-top-container,.live-module .tab-box,.log-empty,.main-container .player-wrapper,.media-tab-nav,.media-tab-wrp,.misl-ep-item,.nav-upload-container,.news-list .news-item:hover,.pagelistbox .p,.player-auxiliary-block-list .player-auxiliary-block-line,.player-auxiliary-block-tabpanel-row.player-auxiliary-border,.player-auxiliary-context-menu-container,.player-auxiliary-danmaku-date-picker-container,.player-auxiliary-modal-container,.player-auxiliary-setting-menu-wrap .player-auxiliary-setting-menu-list:hover,.progress-bar-ctnr .bar-body,.publish-panel .publish-list .publish-item:hover,.re-exp-getexp,.recom-wrap .no-result,.result.is-web,.season-timer .current-timer:before,.section .count,.selector-wrapper .more-type-wrapper,.side-bar-popup-cntr,.slide-item-wrp .slide-item-img,.slot-ctnr .panel,.sort-type-wrp ul,.sponsor-pay-dialog-v2 .sp-pay-index .sponsor-btn-primary.disabled,.sponsor-rank-item.simple .sp-msg,.sponsor-rank-item.special .sp-right .sp-msg,.tab-box .item.active::after,.tab-box .item.active::before,.table-normal tbody tr:nth-child(odd),.timeline-header,.timeline-wrapper,.timer-wrap .quit,.tl-head .tl-day,.ui-btn.grey-radius,.user-info>.tag-flag,.user-my-sex .el-radio-button__inner,.viptable tr th,.viptable tr:nth-child(2n) td,.viptable tr:nth-child(odd) td,.wear-list li,.word-limit-h5 textarea,a.bp_box_bot_click,li.season-item .season-body .season-title span.follow{background-color:#222!important}#announcement-area .news-ctnr,#announcement-area .popular-section-ctnr,#announcement-area .rank-ctnr,#article-list-index,#bp_user_box,#page-fav .fav-main .fav-video-list.is-batch .small-item.selected,#page-fav .fav-main .fav-video-list.is-batch .small-item:hover,.announcement-cntr,.article-content-ctnr,.author-info,.b-info,.ban-app .case-tip,.bangumi-info .info-right .info-title .func-module .bangumi-btn .btn-follow.followed,.bangumi-list-wrapper .bottom-block .slider-contro span,.bangumi-nav-right .nav-goto-top,.bangumi-nav-right .nav-mini-switch,.bangumi-player.mini-player .mini-player-move,.bangumi-player.mini-player .mini-player-move i,.bangumi-player.mini-player .mini-player-move span,.bb-intro-top,.bb_box,.bgray-btn,.big-more-item-item:hover .big-more-item-txt,.bili-btn.ok,.bili-btn.plain,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-info,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-recommend,.bilibili-player .bilibili-player-panel,.bilibili-player .bilibili-player-panel-title,.bilibili-player-block-filter-image .bilibili-player-block-filter-disabled,.bilibili-player-context-menu-container.black ul>li a:hover,.bilibili-player-context-menu-container.black ul>li.hover,.bilibili-player-ending-panel-box-functions .bui-button.bui-button-disabled,.block-area .timeline-title .headline .timeline-more,.bp_box,.btn-disabled,.btn-pay-wrapper.is-vip a,.bui-button.bui-button-gray,.cc-nav-wrp .down-link:hover,.charge-participate,.cm-model,.coin-inner,.confirm-content,.container,.contri-condition .contri-search,.contri-condition .contri-sort .contri-sort-type,.danmaku-wrap .player-auxiliary-auxiliary-area .player-auxiliary-danmaku-wrap,.danmu-container,.danmu-container .empty-danmu:hover,.dashboard,.dialog .content-outer,.fav-main .fav-action-bottom .fav-action-fixtop,.favourite-card,.fjw-random,.follow-container .follow-right .unfollow-btn,.footer-content .qrcode-wrp,.groom-module,.info-model,.info-model .border-b,.info-model header,.intimacy-bar,.invtable tr th,.live-module .tab-item .r-item .number,.medal-progress,.media-info-card,.media-tab-detail-wrp .media-tab-detail,.media-tab-detail-wrp .media-tab-detail-l,.media-tab-module-content .spread-module .num,.more-btn-cntr,.new-stat-module .zone-title .headline .new-stat-more,.news-list .news-item,.news-notice-panel,.pager .jump-pager input[type=text],.paging-box-big .next,.paging-box-big .prev,.pgc-rank-dropdown,.player-auxiliary-auxiliary-area .player-auxiliary-adv-danmaku,.player-auxiliary-auxiliary-area .player-auxiliary-setting,.player-auxiliary-block-list .player-auxiliary-block-line.block-state-selected,.player-auxiliary-block-list .player-auxiliary-block-line:hover,.player-auxiliary-block-string,.player-auxiliary-block-string-short,.player-auxiliary-modal-btns .bpm-btn,.player-auxiliary-setting-menu-wrap,.player-auxiliary-setting-menu-wrap .player-auxiliary-setting-menu-list,.progress-bar-body,.project-list .project-list-item,.review-feed-wrapper,.season-slider-wrapper .slider-wrapper .season-slider-list li:after,.section-item,.security-list-jump:hover,.security-list:hover,.security-right,.security_content,.selector-wrapper,.selector-wrapper .wrapper,.share-module .share-list .weixin-share-modal,.side-bar,.side-utils .utils-box,.sidebar-canvas,.slot-ctnr .panel li:hover,.sort-type-wrp ul li:hover,.sponsor-pay-dialog-v2 .sp-pay-index,.sponsor-rank-dialog .sp-rank-body,.sponsor-rank-dialog .sponsor-rank-content .sp-rank-header .sp-list-nav,.tab-box,.table-normal thead tr td,.tabnav,.tag-list li.tag-item,.timeline-box .timeline-item .item-right p.num a,.timeline-box .timeline-item .item-right p.num span,.timer-wrap,.timer-wrap .vote-dialog-new .footer .b-disable,.toolbar-wrapper,.ui-calendar .calendar-wrap .flatpickr-calendar.static,.ui-calendar .main-wrap,.ui-calendar .main-wrap .shortmenus,.ui-checkbox input[type=checkbox]:disabled+.ui-checkbox-icon,.ui-input,.user-panel-ctnr .exit-btn,.video-model .border-b,.video-model header,.works-ctnr{background-color:#444!important}.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar,.mCSB_scrollTools .mCSB_dragger:hover .mCSB_dragger_bar{background-color:#555!important}.border-line,.count-wrapper div.danmu-count:after,.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar:hover,.mCSB_scrollTools .mCSB_dragger:hover .mCSB_dragger_bar:hover,.season-timeline .season-group .group-time:before,.tl-head .tl-day .indicator{background-color:#aaa!important}.coin-nav .on,.sponsor-rank-item.normal .sp-left .face-wrap{background-image:none!important}.bui-track.bui-track-video-progress .bui-bar-wrap{background-color:#2224!important}.disabled-cover{background-color:#2229!important}.mask::after{background-color:hsla(0,0%,0%,.7)!important}.article-content-ctnr>hr,.author-info .communicate-btn,.bilibili-player-area .bilibili-player-video-control .bilibili-player-video-btn.bilibili-player-video-btn-fullscreen .bilibili-player-video-web-fullscreen,.bilibili-player-area .bilibili-player-video-control .bilibili-player-video-btn:hover,.bilibili-player-auxiliary-area .bilibili-player-info .bilibili-player-setting-btn:hover,.bilibili-player-auxiliary-area .bilibili-player-info .bilibili-player-setting-menu:hover,.bilibili-player-block-tabpanel-row.active-1 .bilibili-player-block-type-keyword,.bilibili-player-block-tabpanel-row.active-2 .bilibili-player-block-type-user,.bilibili-player-video-control,.bilibili-player-video-sendbar .bilibili-player-video-btn:hover,.bilibili-player-video-sendbar .bilibili-player-video-btn>i,.bui-select.bui-select-quality-menu .bui-select-border,.chief-recommend-module .carousel-box .carousel-module .panel .trig span.on,.container .host-list-layout .hot-list-wrap .bg-wrap .hot-list-mask,.contri-condition .contri-sort .contri-sort-type li:hover,.empty-hint,.f-list-hover:hover,.line-circle,.live-sidebar-ctnr,.nav-upload-container .nav-upload-item:hover,.news-list .news-item .date,.player-auxiliary-adv-danmaku,.player-auxiliary-auxiliary-area,.player-auxiliary-auxiliary-area .player-auxiliary-filter,.prize-winner-block,.security-list .child-list li a:hover,.share-module,.sponsor-rank-item.simple .sp-rank i{background-color:transparent!important}.block-area .timeline-toggle-block .timeline-toggle-btn,.cc-nav-wrp .nav-cut-off-line,.fav-main .fav-action-top .back-to-info,.no-data,.section .count:before,.tag-more .b-toggle-btn{background:0 0!important}#page-index .fav-item .state,.act-info,.announce h3.title span,.announce h3.title span .fontvt,.announce li span,.audioplayer .ap-playlist .ap-playlist-header .ap-playlist-amount,.b-head-string,.b-info .balance-footer,.b-info .info-tip,.backdrop .title-box .close-button,.bangumi-collection-card .bangumi-info .bangumi-state,.bangumi-collection-card .bangumi-info .type-and-area,.bangumi-collection-card .bangumi-info .watch-state,.bangumi-collection-wrapper .bangumi-collection-count,.bangumi-home-crumb .fcname ul.n_num li,.bangumi-home-crumb .fcname ul.n_num li a,.bangumi-media .bangumi-media-header .btn-more-review,.bangumi-media .bangumi-media-header .rate-wrapper .rate-info .info-wrapper,.bangumi-nav-right .nav-mini-switch,.bangumi-review-item .item-header .author-name,.bangumi-review-item .item-header .media-name,.bangumi-review-item .item-header .pub-time,.bangumi-review-item .review-content.long,.bb-comment .no-more-reply,.bb-intro-top .b-question .b-question-title,.be-input-word-counter,.bgray-btn,.big-game-gift-money,.big-more-tool-item,.big-nane-bottom p,.bili-header-m .i_menu_login .reg,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-info .bilibili-player-watching .bilibili-player-watching-number,.bilibili-player-auxiliary-area .bilibili-player-info .bilibili-player-setting-btn:hover,.bilibili-player-auxiliary-area .bilibili-player-info .bilibili-player-setting-menu:hover,.bilibili-player-block-filter-function .bilibili-player-block-filter-image .bilibili-player-block-filter-disabled,.bilibili-player-block-filter-type .bilibili-player-block-filter-image .bilibili-player-block-filter-disabled,.bilibili-player-ending-panel-box-functions .bui-button.bui-button-disabled,.bilibili-player-filter .bilibili-player-filter-btn>span,.bilibili-player-mode-selection-container .bilibili-player-mode-selection-panel .bilibili-player-mode-selection-row .row-selection .selection-span .selection-icon,.bilibili-player-panel .bilibili-player-panel-content .bilibili-player-panel-label,.bilibili-player-recommend-right .bilibili-player-recommend-click,.bilibili-player-recommend-right .bilibili-player-recommend-danmaku,.bilibili-player-recommend-right .bilibili-player-recommend-scores,.bilibili-player-recommend-right .bilibili-player-recommend-stow,.bilibili-player-video-control .bilibili-player-video-btn,.bilibili-player-video-sendbar .bilibili-player-video-btn,.bilibili-player-video-sendbar .bilibili-player-video-inputbar .bilibili-player-video-hint,.bilibili-player-video-sendbar .bilibili-player-video-inputbar .bilibili-player-video-hint a,.bp-user-box .bp-user-box-bb,.bp-user-box .bp-user-box-bk,.bp-user-box-bottom p,.bread-crumb ul li a,.bread-crumbs,.bread-crumbs a,.btn-delete,.cc-nav-wrp .down-link .version,.cc-nav-wrp .nav-item i:first-child,.cc-nav-wrp .nav-item i:last-child,.charge-participate .benefit-item .long-desc,.cm-model .report-detail .child-comment .child-list .detail .report-cnt .rep-name,.cm-model .report-detail .detail .date,.cm-model .report-detail .more-list,.coin-left-nodata,.coin-operated-m .coin-bottom .tips,.coin-text-p,.compila-not-find .compila-not-find-tips,.container .host-list-layout .hot-list-wrap .hot-song-list .song-info .song-content .iconfont,.container .host-list-layout .hot-list-wrap .hot-song-list .song-info .song-num,.container .host-list-layout .hot-list-wrap .show-more-song,.container .musician-recommend .recommend-item .recommend-info .recommend-text,.container .song-list .song-li .content .num,.contri-condition .contri-right i,.contri-condition .contri-sort,.contri-not-find .contri-not-find-tips,.count-wrapper div,.data-card .data-box .tab .fan-tab,.data-card .data-box .tip p,.data-card .data-box .total,.data-card .fans-box .tab .fan-tab,.data-card .fans-box .tip p,.data-card .fans-box .total,.dc-section .section-tip,.dc-section-item_title_name small,.descript,.dynamic-m .title span:not(.sp),.el-date-table th,.el-input__icon,.el-picker-panel__icon-btn,.el-select-dropdown__item,.empty-wrp .text,.episode-item .ep-title,.face-g-expire-at,.face-g-list .mp-block .left .mp-info label,.face-g-list .mp-block .right ul li p.reach-tips,.face-g-list .mp-block .right ul li.base .tips,.fans-number,.fav-main .fav-action-bottom .select-counter,.first-change-lb span,.fjw-case-detail .ban-detail .content-box .jury-status .status-left .voted .graph .txt,.follow-container .follow-right .follow-intro .follow-content,.follow-container .follow-right .follow-num,.font24,.footer a,.footer-content .menu-item,.gotoSpace,.growup-participate .status_box .limited,.h-list-desc,.h-safe-desc,.history-list .r-info .history-mark,.history-list .r-info .subtitle,.history-tag,.hotsong-li .font24,.hotsong-li .hotsong-upname,.i-live .i-live-off-guest,.icon-star:not(.icon-star-light)::before,.identmagBot span,.income-card .income-box .empty-data p,.income-card .income-box .empty-data span,.info-second .info-sec-av,.info-second span,.introduction-text,.inv-record-right,.invitation-normal,.live-ctn .live-attch .host,.live-module .tab-item .r-item .r-i-st,.live-module .tab-item .r-item .r-i-t .u-online,.log-empty p,.m-tips,.main-content-title span.i,.medal .medal-form .page-tip,.medal .medal-form .section .mini,.medal header p,.media-info-card .mic-expand,.media-sponsor-wrapper .sponsor-rank-header .show-sponsor-rank,.media-sponsor-wrapper .sponsor-right-area .sponsor-count-info,.media-tab-module-wrp .media-tab-module-more,.media-tab-module-wrp .media-tab-module-write.type-btn,.member-list-item-subtext,.misl-ep-item .misl-ep-text .misl-ep-title,.mod-1 .r .up-info .v-author,.mod-1 .r .up-info .v-date,.mod-1 .r .v-desc,.mod-1 .r .v-info .v-info-i,.mod-2 li .r .up-info .v-author,.mod-2 li .r .v-info .v-info-i,.mod-3 .r .up-info .v-author,.mod-3 .r .v-info .v-info-i,.modal-head a,.modal-wrapper .modal-body,.nav-list li .list-description p,.no-data,.no-data-txt,.normal-empty,.notice-card .notice-list .notice-item .notice-time,.notice-card .notice-list .notice-item .notice-title,.pagelistbox .p,.pagelistbox strong,.pagination-wrapper .pagination .pageNum,.paging-box-big .page-jump,.pgc-rank-list .rank-item .ri-detail .ri-point,.player-auxiliary-auxiliary-area .player-auxiliary-filter-menu,.player-auxiliary-block-line.block-state-disabled,.player-auxiliary-block-list .player-auxiliary-block-line-delete,.player-auxiliary-block-list .player-auxiliary-block-line-sync,.player-auxiliary-block-list-function>div,.player-auxiliary-block-list-wrap .player-auxiliary-block-empty,.player-auxiliary-danmaku-date-picker-header,.player-auxiliary-danmaku-date-picker-header .player-auxiliary-danmaku-date-picker-btn,.player-auxiliary-danmaku-function [class*=player-auxiliary-danmaku-btn-],.player-auxiliary-danmaku-load-status.disabled,.points-faq-line body,.points-text,.pre-info,.rank-list .rank-item .ri-detail .ri-point,.rank-list-container .title,.re-exp-none,.recom-item a .recom-info .info-count>div span,.recom-item a .recom-info .info-title,.record-exp-title .i,.record-group,.record-login-descript,.results,.review-feed-item .feed-left .review-about,.review-feed-item .feed-left .review-about .author-info,.review-feed-item .feed-left .review-about .media-title,.review-feed-item .feed-right .likes,.review-feed-wrapper .feed-header span,.review-feed-wrapper .feed-header span .icon-refresh::before,.review-list-wrp li .review-author-info div.review-author-name,.review-list-wrp li .review-author-info div.review-author-time,.review-list-wrp li .review-contro div,.review-list-wrp li .review-data div,.review-list-wrp li .review-data div .icon-zan::before,.season-item,.season-timeline .season-group .group-time,.season-timeline .season-group.is-published .group-time,.section .count,.security-title,.select-month .tip,.selector-wrapper .city-list,.selector-wrapper .more-type-list .more-type-item,.selector-wrapper .more-type-wrapper,.selector-wrapper .order-list,.selector-wrapper .type-list,.share-board .song-share div,.share-module .share-list li.share-btn.btn-app,.song-content,.song-info .song-info-content .song-info-theme,.song-li .song-right .song-playnum,.song-lrc,.song-play-num,.song-time,.song-type,.sort-type-wrp div,.sort-type-wrp div i,.sponsor-pay-dialog-v2 .sp-pay-index .sponsor-hint .sponsor-point,.sponsor-rank-item.normal .sp-left .sp-rank,.sponsor-rank-item.simple .sp-msg,.sponsor-rank-v1 .sponsor-rank-header .show-sponsor-rank,.sub-nav-m ul li a,.tab-btn-link,.table-normal thead tr td,.tabnav-item,.tag-list-wrp .title .small,.timer-wrap .canvas-wrap .canvas-title,.timer-wrap .vote-dialog-new .header h2,.timer-wrap .vote-dialog-new .main .main-txt-2,.timer-wrap .vote-dialog-new .main h4,.title-container .info span,.ui-checkbox input[type=checkbox]:disabled+.ui-checkbox-icon,.ui-serch .run-serch,.up-info .up-info-tip,.user-box,.user-box .grade-dec,.user-info>.user-uid,.user-name,.vote-percentage,.wrapper .modal-body .pay-info-wrp{color:#aaa!important}#announcement-area .news-ctnr .news-item,#announcement-area .news-ctnr .title-row,#announcement-area .popular-section-ctnr .area-name,#announcement-area .popular-section-ctnr .title-row,#announcement-area .rank-ctnr .title-row,#app>.main .title,#audience-page .version-switch-section .bili-tab,.academy-card .academy-box .academy-item .academy-title,.all-hot-list-warp .all-hot-list .hot-list-content .list-name,.announce li>div a,.assist-wrap .assist-log header .tools .search-wrp input[type=text],.assist-wrap .assist-log header .tools .ui-calendar input[type=text],.audioplayer .ap-controller .ap-controller-center .ap-artist,.audioplayer .ap-controller .ap-controller-center .ap-current-time,.audioplayer .ap-controller .ap-controller-center .ap-name,.audioplayer .ap-controller .ap-controller-center .ap-playlist-button-amount,.audioplayer .ap-controller .ap-controller-center .ap-time,.b-head,.b-head-t,.b-info .balance-footer .balance-part .part-balance-price,.b-info .bb-quan,.b-info .button,.ban-detail .content-box .jury-status .status-left .voted .voted-tips p span,.ban-detail .content-box .jury-status .status-right .vote-success .success-txt p,.bangumi-collection-card .bangumi-funcs .btn-unfollow,.bangumi-collection-card .bangumi-info .bangumi-title,.bangumi-collection-wrapper .bangumi-collection-title,.bangumi-header .header-info h1,.bangumi-info .info-right .info-title h2,.bangumi-media .bangumi-media-header .rate-wrapper .btn-go-write,.bangumi-media .bangumi-media-header h4,.bangumi-recom .recom-title,.bangumi-review-item .long-title,.bangumi-review-item .review-content,.bb-comment .nameplate .nameplate-card .nameplate-text,.bb-intro-top .b-icon-title,.bgray-btn:hover,.big-game-gift-text,.big-gift-btn-home,.big-more-item-item,.big-more-item-list,.big-pendant-test,.big-privilege-title,.big-watch-title,.bili-btn.ok,.bili-header-m .i_menu_login .tip,.bili-tab,.bilibili-player-auxiliary-area .bilibili-player-recommend-title,.bilibili-player-block-tabpanel .bilibili-player-block-string-type,.bilibili-player-block-tabpanel .bilibili-player-block-tabpanel-title,.bilibili-player-danmaku-setting-lite .bilibili-player-danmaku-setting-lite-row .bpui-checkbox-text,.bilibili-player-danmaku-setting-lite-row .bilibili-player-danmaku-setting-lite-title,.bilibili-player-mode-selection-row .selection-span .selection-name:hover,.bilibili-player-mode-selection-row .selection-span.active .selection-name,.bilibili-player-panel-area .bilibili-player-panel-area-title,.bilibili-player-panel-content .bilibili-player-panel-setting .selectmenu-mode-absolute .bpui-selectmenu-txt,.bilibili-player-panel-title,.bilibili-player-video-btn-danmaku .bilibili-player-danmaku-setting-lite-panel .bilibili-player-danmaku-setting-lite,.block-area .timeline-title .headline .name,.block-area .timeline-title .headline .timeline-more,.block-area .timeline-toggle-block .timeline-toggle-btn,.bp-user-box i,.bp-user-box-top p,.bp_box_bot a,.bp_box_top p,.bpui-button-text-only[for],.bpui-tab-list-type-button .bpui-tab-list-row,.bread-crumbs span,.btn-confirm.disabled,.btn-disabled,.btn-pay-wrapper.is-vip a,.btn-sponsor-wrapper .sponsor-count span,.bui-button.bui-button-gray,.bui-button.bui-button-gray2,.bui-tabs .bui-tabs-header .bui-tabs-header-item,.buy-info-box .left-part,.carousel-wrapper .carou-info span a,.cc-album-manage .info-wrp .cc-btn,.cc-btn.is-main,.cc-nav-wrp .down-link .title,.cc-nav-wrp .nav-upload-btn>a,.channel-m,.charge-participate .benefit-item .short-desc,.charge-participate .part-btn,.chat-history-panel .chat-item,.chat-history-panel .gift-item .gift-count,.chat-history-panel .hover-panel>span,.cm-model h4,.coin-index-right-title,.coin-nav-item,.coin-next-day,.coin-record .coin-title,.coin-rest-info,.coin-rest-p,.coin-reward-info,.coin-time,.comment-con,.comment-title,.compila-condition .compila-right .compila-add.single,.compila-condition .compila-type,.compila-not-find .compila-not-find-ime,.confirm-content,.container .all-hot-list-warp .all-hot-list .hot-list-content .hover-mask .iconfont,.container .host-list-layout .hot-list-wrap .bg-wrap .top-info-content .right-info .right-btn .iconfont,.container .host-list-layout .hot-list-wrap .bg-wrap .top-info-content .right-info .right-btn .text,.container .musician-recommend .recommend-item .recommend-info .name,.content-panel .title,.contri-condition .contri-search,.contri-condition .contri-select,.contri-condition .contri-sort .contri-sort-type li,.contri-not-find .contri-not-find-ime,.curren-b-num,.danmu-container .empty-danmu,.dashboard li .text,.dashboard li.collection .text,.dashboard li.share .text,.data-card .data-box .tab .bili-btn,.data-card .data-box .title,.data-card .fans-box .tab .bili-btn,.data-card .fans-box .title,.data-card .tab .data-tab,.dc-section-item_title_name p,.dc-section-title,.el-form-item__label,.el-pager li.active,.el-pagination,.el-pagination button.disabled,.el-picker-panel,.el-picker-panel__shortcut,.el-radio-button__orig-radio:checked+.el-radio-button__inner,.emoji-box,.empty-hint .hint-text,.episode-item .ep-index,.face-g-action,.face-g-list .mp-block .left .mp-info .mp-descr,.face-g-list .mp-block .left .mp-info .mp-title,.face-g-list .mp-block .right ul li p.title,.face-g-list[id=face-g-log] td,.face-g-list[id=face-g-log] th,.face-g-name,.face-g-takedown,.face-g-title,.face-g-use,.face-g-xf,.fav-main .fav-action-bottom li,.fav-main .fav-action-bottom ul.filter-disable li:hover,.fav-main .fav-action-top .back-to-info,.favourite-card .anchor-info .anchor-name,.fjw-case-detail .ban-detail .content-box .jury-status .status-left .voted .graph .people,.fjw-random .point-wrap .cnt .no-data .title,.follow-container .follow-right .follow-up,.follow-container .follow-right .unfollow-btn,.get-coin-more,.go-movie:hover,.go-secuirty,.gui-settings-button:not(.save),.guide-card .title p,.h-list-name,.h-mp-space,.h-reward-info,.h-safe-nobtn,.h-safe-title,.head-wrap,.home-dialy-task-title,.home-level-tips,.home-to-space,.home-to-update,.home-top-level-mask-warp,.home-top-level-number,.home-userstatus,.home-wrap .card .title,.host-list-layout .hot-list-wrap .hot-song-list .song-info .song-content .song-title,.hot-box li .txt,.hotsong-li .hotsong-title a,.identmagTop,.inv-record-title,.invitation-btn,.invitation-info-title,.invtable tr th,.is-max .vote-percentage,.level-dia,.link-popup-panel,.link-top-container .link-top-item,.list-filter-bar .sort-box,.live-ctn .live-attch .title,.live-module .tab-item .r-item .r-i-t .u-name,.m-help,.main-container .sponsor-wrapper .sponsor-right-area .sponsor-count-info span,.main-container .title,.main-content-title span.t,.medal .medal-form .page-tip a,.medal .medal-form .section,.medal .medal-form .section .title-tip,.medal-message,.media-info-card,.media-info-card .mic-evaluate,.media-info-count .media-info-count-item *,.media-info-wrp .media-info-content .media-info-inner .media-info-r .media-info-btns .bangumi-btn .btn-follow,.media-info-wrp .media-info-content .media-info-inner .media-info-r .media-info-title .media-info-title-t,.media-info-wrp .media-info-content .media-info-inner .media-info-r .media-info-title .media-tag,.media-sponsor-wrapper .sponsor-right-area .sponsor-btn,.media-sponsor-wrapper .sponsor-right-area .sponsor-count-info span,.media-tab-module-wrp .media-tab-module-content .sl-ep-nav .sl-ep-nav-list,.media-tab-module-wrp .media-tab-module-title,.media-tab-nav ul li,.member-list-item-text,.middle-tip,.middle-tip .change-song,.misl-ep-item .misl-ep-text .misl-ep-index,.misl-ep-item .misl-ep-text .misl-ep-title,.mod-1 .r .title,.mod-2 li .r .title,.mod-3 .r .title,.more .icon-font,.more-btn-text,.more:hover .text,.mp-mine-takedown,.my-moral,.nav-bar .nav-wrapper .main-tab.active,.nav-item,.nav-list li .list-title .list-title-text p,.new-stat-module .zone-title .headline .name,.new-stat-module .zone-title .headline .new-stat-more,.now-num,.page-title,.pagelistbox .custom-right .custom-right-inner,.pager .jump-pager input[type=text],.paging-box-big .next,.paging-box-big .prev,.pendant-name,.pie-empty-wrapper,.pk-rank.side-bar-icon+.size-bar-text,.player-auxiliary-auxiliary-area .player-auxiliary-filter-title,.player-auxiliary-block-list .player-auxiliary-block-line,.player-auxiliary-block-string,.player-auxiliary-block-string-short,.player-auxiliary-block-tabpanel-row.special-title .player-auxiliary-block-label,.player-auxiliary-modal-btns .bpm-btn,.player-auxiliary-modal-info,.player-auxiliary-modal-title,.player-auxiliary-setting-menu-wrap .player-auxiliary-setting-menu-list,.points-btn,.points-exchange-title,.points-faq-info-list,.points-how-title,.points-info p,.points-pendant-title p,.points-record-title,.privilege-text,.project-list .project-list-item .project-list-item-detail .project-list-item-title,.rangeMode .flatpickr-day,.rank-menu li html,.re-exp-getexp,.re-exp-info,.record-exp-title .t,.record-nav-item,.review-feed-item .feed-left .review-info .review-content,.review-feed-item .feed-left .review-info .review-title,.review-feed-wrapper .feed-header h4,.review-list-wrp .review-detail .review-content,.review-list-wrp .review-detail .review-title,.right-more-btn,.room-list .list-item .uname,.safe-tips p,.season-slider-wrapper .slider-wrapper .season-slider-list li.cur,.section-item .data-name,.section-item .diff-wrp,.section-title>a.t,.section>.section-title,.security-list .first-level,.security-list li a span,.security-list-link-jump,.security-nav-name,.selector-wrapper .title,.setting .setting-title,.share-module .share-list .weixin-share-modal .share-name,.share-module .share-list .weixin-share-modal .share-tips,.side-utils .utils-item .item-desc,.slot-ctnr a,.song-info .song-info-content .song-info-detail,.song-li .song-right .song-intro a,.song-list .song-li .content .text a,.song-play-num span,.song-playbtn,.song-title,.sort-type-wrp ul li,.sponsor-pay-dialog-v2 .sp-pay-index .sponsor-agree a,.sponsor-pay-dialog-v2 .sp-pay-index .sponsor-btn-primary.disabled,.sponsor-pay-dialog-v2 .sp-pay-index .sponsor-hint,.sponsor-pay-dialog-v2 .sp-pay-index ul.sponsor-choice li span,.sponsor-pay-dialog-v2 .sponsor-pay-header.border .title,.sponsor-rank-dialog .sponsor-rank-content .sp-rank-header .sp-rank-title,.sponsor-rank-item.normal .sp-right .sp-msg,.sponsor-rank-item.normal .sp-right .sp-user .sp-name,.sponsor-rank-item.simple .sp-rank i,.sponsor-rank-item.simple .sp-user,.sponsor-rank-item.special .sp-right .sp-msg,.sponsor-rank-item.special .sp-right .sp-user:not(.vip) .sp-name,.sponsor-rank-tab li,.sub-pages-item,.tab-box .item,.tab-box .item .desc,.tab-box .item .title,.tab-box .item.active,.tab-mk2,.table-normal tbody tr td,.tabs-nav-item,.tag-list-wrp .title .name,.tag-more .b-toggle-btn,.timeline-box .timeline-item .item-right p.num a,.timeline-box .timeline-item .item-right p.num span,.timer-wrap .quit p,.timer-wrap .vote-dialog-new .footer .b-able,.timer-wrap .vote-dialog-new .footer .b-disable,.timer-wrap .vote-dialog-new .main .main-txt-1 label,.title .s-iconText-text,.tl-head .tl-day.today span,.to-review-btn,.ui-btn.grey-radius,.ui-calendar .flatpickr-day,.ui-calendar .flatpickr-day.inRange,.ui-calendar .flatpickr-month,.ui-calendar .main-wrap .shortmenus a,.user-box .num,.user-info-name,.user-info>.user-name,.user-jump,.user-my-sex .el-radio-button__inner,.user-panel-ctnr .exit-btn,.userinfo-username,.video-floor-m .dynamic-title .title .name,.video-item-biref .biref-info .biref-title,.video-list .vl-hd .tab-list li,.viptable,button.button.more,h2.title,li.season-item .season-body .season-title{color:#eee!important}#bp_user_box,#page-fav .fav-main .fav-video-list.is-batch .small-item.selected,#page-fav .fav-main .fav-video-list.is-batch .small-item:hover,.announce li,.announce li>div span,.announcement-cntr,.app-body .section-block.with-bottom-radius,.app-body .section-block.with-radius,.article-content-ctnr,.assist-wrap .assist-log header .tools .ui-calendar input[type=text],.author-info,.b-info,.backdrop .title-box,.bangumi-collection-card .bangumi-funcs .btn-unfollow,.bangumi-collection-wrapper .bangumi-collection-count,.bangumi-info .info-right .info-title .func-module .bangumi-btn .btn-follow.followed,.bangumi-list-wrapper .top-block,.bangumi-media,.bangumi-media .bangumi-media-header .btn-more-review,.bangumi-nav-right .nav-goto-top,.bangumi-nav-right .nav-mini-switch,.bb-intro-top,.bb_box,.bgray-btn,.big-game-gift-warp,.big-gift-btn-home,.big-more-item-list,.big-more-tool-btn,.big-name-warp,.big-pendant-warp,.big-privilege-warp,.big-watch-wrapper,.bili-btn.plain,.bili-header-m .i_menu_login,.bilibili-player .bilibili-player-auxiliary-area,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-filter,.bilibili-player .bilibili-player-block-filter-function .bilibili-player-block-filter-image .bilibili-player-block-filter-disabled,.bilibili-player .bilibili-player-block-filter-type .bilibili-player-block-filter-image .bilibili-player-block-filter-disabled,.bilibili-player .bilibili-player-panel-title,.bilibili-player-block-tabpanel,.bilibili-player-block-tabpanel .bilibili-player-block-tabpanel-row.bilibili-player-border,.bilibili-player-color-picker-container .bilibili-player-color-picker-input-group .bilibili-player-color-picker-color-code,.bilibili-player-color-picker-container .bilibili-player-color-picker-input-group .bilibili-player-color-picker-color-current,.bilibili-player-danmaku-setting-lite-panel .bilibili-player-danmaku-setting-lite,.bilibili-player-ending-panel-box-functions .bilibili-player-upinfo-electric,.bilibili-player-mode-selection-row .row-selection .selection-span.active .selection-name,.block-area .timeline-title .headline .timeline-more,.bp-user-box-top,.bp_box,.bp_box_top,.btn-confirm.disabled,.btn-disabled,.btn-dufault,.btn-pay-wrapper.is-vip a,.buy-info-box,.cc-nav-wrp,.coin-calendar-wrap,.coin-record .table-wrapper,.comment-ctnr,.container .host-list-layout .hot-list-wrap .hot-song-list,.container .host-list-layout .hot-list-wrap .show-more-song,.container .middle-tip .change-song,.container .musician-recommend .recommend-item,.container .tag,.contri-condition .contri-search,.danmaku-wrap .player-auxiliary-block-wrap,.danmu-container,.dashboard,.dashboard li.like,.data-card .tab .data-tab,.el-pager li.active,.el-pagination .btn-next,.el-pagination .btn-prev,.el-pagination button.disabled,.el-pagination__editor,.el-select-dropdown,.el-textarea__inner,.emoji-box,.episode-item,.face-g-action,.face-g-action[id=face-g-change],.face-g-item,.face-g-item-inner,.face-g-list .face-g-block,.face-g-list .mp-block .left .mp-img,.face-g-list[id=face-g-log] td,.face-g-preview,.fav-main .fav-action-top,.fav-main .fav-action-top .back-to-info,.first-change-lb,.follow-container .follow-right .unfollow-btn,.footer .border,.footer-content,.footer-content .menu-item,.footer-content .qrcode-wrp,.get-coin-more,.gift-item-wrap .num,.h-list-icon,.hold-list,.hold-list-width.details-list-t,.home-daily-task-warp,.home-mp,.home-top-level-mask-warp,.identmagTop,.income-card .income-box .empty-data,.index-info,.info-model .border-b,.integrity-table-wrapper,.invitation-top-warp,.invtable tr th,.link-top-container,.m-help,.main-container .bangumi-info-wrapper,.main-container .player-wrapper,.main-container .sponsor-wrapper,.main-content-title,.medal header,.medal-list .part .content,.medal-up-trueLove,.media-info-wrp .media-info-content .media-info-inner .media-info-r .media-info-title .media-tag,.media-sponsor-wrapper,.media-sponsor-wrapper .sponsor-rank-header .show-sponsor-rank,.media-tab-detail-wrp .media-tab-detail .media-tab-module-wrp,.media-tab-detail-wrp .media-tab-detail-l .media-tab-module-wrp,.media-tab-module-wrp .media-tab-module-content .sl-ep-nav,.media-tab-module-wrp .media-tab-module-content .sl-ep-nav .mode-select,.media-tab-module-wrp .media-tab-module-more,.media-tab-module-wrp .media-tab-module-write.type-btn,.misl-ep-item,.mod-1 .r,.mod-1 .r .up-info .v-date,.mod-2 li,.mod-3 .l-item,.modal-head,.mp-mine-avatar,.mp-mine-takedown,.nav-item-ctnr.expanded .nav-item,.nav-item-ctnr.expanded .sub-pages-item-ctnr,.nav-list li,.new-stat-module .zone-title .headline .new-stat-more,.notice-card .title,.pagelistbox .p,.pager .jump-pager input[type=text],.paging-box-big .next,.paging-box-big .prev,.pgc-rank-dropdown,.player-auxiliary-context-menu-container,.player-auxiliary-danmaku-date-picker-container,.player-auxiliary-modal-btns .bpm-btn,.player-auxiliary-modal-container,.player-auxiliary-setting-menu-wrap,.points-box,.points-faq-line,.points-how-warp,.points-pendant-warp,.points-record-warp,.prize-img,.record-exp-table-wrapper,.record-exp-title,.record-item,.record-nav,.review-feed-item,.review-list-wrp li,.section .count,.security-list .child-list,.security-list .first-level,.security-list-jump,.security-right-title,.security-title,.security-ul,.security_content,.selector-wrapper .city-selector-wrapper,.selector-wrapper .more-city-letter-list,.selector-wrapper .more-type-wrapper,.selector-wrapper .type-selector-wrapper,.setting .watermark-setting,.share-module .share-list .weixin-share-modal,.share-module .share-list li.share-btn.btn-app,.side-bar,.side-bar-popup-cntr,.song-comment,.song-title,.sort-type-wrp ul,.sponsor-pay-dialog-v2 .sp-pay-index .sponsor-btn-primary.disabled,.sponsor-pay-dialog-v2 .sp-pay-index ul.sponsor-choice li input,.sponsor-pay-dialog-v2 .sponsor-pay-header.border,.sponsor-rank-dialog .sponsor-rank-content .sp-rank-header .sp-list-nav,.sponsor-rank-item.simple .sp-msg,.sponsor-rank-item.simple .sp-rank i,.sponsor-rank-item.special .sp-right .sp-msg,.sponsor-rank-v1 .sponsor-rank-header .show-sponsor-rank,.sr-t,.table-normal tbody tr,.table-normal thead tr td,.table-wrapper,.tabnav,.tabs-mk2,.tabs-nav,.tag-list li.tag-item,.timeline-header .tl-weeks:after,.timer-wrap .vote-dialog-new .header,.ui-calendar .flatpickr-day.inRange,.ui-calendar .main-wrap .shortmenus,.ui-serch input[type=text].ui-input,.user,.user-hd,.user-my-sex .el-radio-button__inner,.user-setting-warp .padding-dom,.video-list .vl-hd,.video-model .border-b,.viptable tr th,.wear-list li,.word-limit-h5 textarea,.works-ctnr,button.button.more,table.invtable td,table.viptable td{border-color:transparent!important}.bp-user-box-bb,.bpui-button-text-only .bpui-button-text .bpui-flex-wrap,.container .host-list-layout .hot-list-wrap .hot-song-list .song-info .song-content .iconfont,.elec .elec-monthly-count,.go-secuirty,.h-list-item,.h-mp-space,.home-to-space,.home-to-update,.home-userstatus,.points-pendant-item,.right-more-btn,.season-timeline .season-group,.season-timeline .season-group .group-time:before,li.history{border-color:#aaa!important}.hot-live .room-list,.player-auxiliary-danmaku-date-picker-header,.player-auxiliary-modal-header,.table-normal tbody tr td,.table-normal thead tr td{border-color:#444!important}.player-auxiliary-block-tabpanel .player-auxiliary-block-string-short:not(:focus),.player-auxiliary-block-tabpanel .player-auxiliary-block-string:not(:focus){border-color:#666!important}.audioplayer svg:not(.ap-svg-exclude) path,.audioplayer svg:not(.ap-svg-exclude) polygon,.player-auxiliary-danmaku-date-picker-btn{fill:#aaa!important}.block-area .timeline-toggle-block .timeline-toggle-btn i,.go-secuirty .m-arrow,.growup-participate .status_box img,.h-mp-space .m-arrow,.home-to-space .m-arrow,.i-m-title .icon-i-title,.new-stat-module .zone-title .headline .new-stat-more .icon,.pgc-rank-dropdown .icon-arrow-down,.right-more-btn .m-arrow,.sec-rank .more-link .icon-arrow-r,.security-list-jump-icon,.svg-icon.top1,.tag-more .b-toggle-btn .b-icon-toggle-down,.tag-more .b-toggle-btn .b-icon-toggle-up,.tl-head .today .day-of-week{filter:brightness(0) invert(1)!important}#page-fav .fav-main .fav-action-bottom .icon,#page-fav .fav-main .small-item.selected .video-check,.bangumi-list-wrapper .top-block .mode-select li.detail-mode.selected,.bangumi-list-wrapper .top-block .mode-select li.detail-mode:hover,.bangumi-list-wrapper .top-block .mode-select li.simple-mode.selected,.bangumi-list-wrapper .top-block .mode-select li.simple-mode:hover,.big-banner-warp .swiper-pagination-bullet-active,.bili-header-m .bilibili-suggest .cancel:hover,.coin-icon,.coin-operated-m .close:hover,.comment-wrap header h2 .head-icon,.fans-question,.fjw-random header h2 .head-icon,.info-model header h2 .head-icon,.season-slider-wrapper .slider-wrapper .season-slider-list li.cur,.sl-ep-nav .mode-select li.detail-mode.selected,.sl-ep-nav .mode-select li.detail-mode:hover,.sl-ep-nav .mode-select li.simple-mode.selected,.sl-ep-nav .mode-select li.simple-mode:hover,.swiper-button-next:hover,.swiper-button-prev:hover,.timer-wrap .timer-top h2 .head-icon,.video-model header h2 .head-icon,.wrapper .modal-close:hover{filter:var(--blue-image-filter)!important}.block-area .timeline-title .headline .timeline-more i,.episode-item .mark-icon.badge-pink-first,.episode-item .mark-icon.badge-pink-vip,.publish-panel .publish-list .publish-item a,.season-timer .current-timer:before,.tag-list li.tag-item .hot,.toolbar-wrapper .scroll-icon,.toolbar-wrapper .service-icon,.user-panel-ctnr .ctrl-btn .svg-icon,li.season-item .season-body .season-title span.follow{filter:var(--pink-image-filter)!important}.coin-operated-m .close,.first-change-lb i,.history-list .r-info .device-i,.history-list .r-info .history-delete,.i-live .i-live-m,.i-live .i-live-off-guest a .i-live-arrow,.review-list-wrp li .review-data div.review-data-comment embed,.review-list-wrp li .review-data div.review-data-comment i,.tag-list .tag-icon,.wrapper .modal-body .elec-protocol .checkbox.checked,.wrapper .modal-close{filter:grayscale(1)!important}.cc-album-manage .info-wrp .no-img,.cc-article-wrp .info-wrp .img,.charge-participate .benefit-item .pic,.compila-not-find .compila-not-find-image,.contri-not-find .contri-not-find-image,.live-module .tab-item .r-item .r-i-t .u-online i,.log-empty img,.text-article-wrp .info-wrp .img{filter:brightness(.72)!important}.primary-menu .nav-menu .sub-nav li>a span:after{filter:none!important}.coin-icon-done,.h-safe-icon[class$=no]{filter:brightness(.5)!important}.i-live .i-live-fo-btn,.i-live .i-live-unfo-btn{border-radius:4px!important}.danmu-container,.timeline-header,.timeline-header .tl-weeks,.timeline-wrapper{box-shadow:none!important}.bili-header-m .i_menu_login,.link-popup-panel,.player-auxiliary-context-menu-container,.side-bar-popup-cntr{box-shadow:0 1px 10px 0 var(--theme-color-30)!important}.bangumi-coin-wrap .bangumi-coin,.bangumi-coin-wrap .bangumi-coin-d,.bangumi-collection-wrap .bangumi-order,.bangumi-collection-wrap .bangumi-order-d,.bangumi-list-wrapper .bottom-block .slider-contro i.slider-next-mask,.bangumi-list-wrapper .bottom-block .slider-contro i.slider-prev-mask,.bangumi-order-wrap .bangumi-order,.bangumi-order-wrap .bangumi-order-d,.empty-hint .hint-img,.home-level-mask-icon,.side-bar-popup-cntr>.arrow,.sponsor-rank-item.special .sp-right .sp-msg>span,.sponsor-rank-item.special .sp-right .sp-msg>span:before,.top-header,.top_bg{display:none!important}#audience-page .version-switch-section .bili-tab.current,#page-fav .fav-main .filter-item.search.focus,.bangumi-list-wrapper .top-block .ss-list-wrapper .slider-contro,.bili-tab.current,.bili-tab.current:after,.bilibili-player .bilibili-player-block .bilibili-player-block-tabpanel .bilibili-player-block-tabpanel-row.active-1 .bilibili-player-block-type-keyword,.bilibili-player .bilibili-player-block .bilibili-player-block-tabpanel .bilibili-player-block-tabpanel-row.active-2 .bilibili-player-block-type-user,.bpui-button-text-only.bpui-state-active .bpui-button-text .bpui-flex-wrap,.bpui-selectmenu,.bpui-tab-list-type-button .bpui-tab-list-row.bpui-state-selected,.btn-confirm,.bui-tabs .bui-tabs-header .bui-tabs-header-item.bui-tabs-header-item-active,.carousel-wrapper .carou-mini .thumb-cursor,.coin-nav .on,.container .host-list-layout .hot-list-wrap .hot-song-list .song-info .song-content .iconfont:hover,.container .musician-recommend .recommend-item .recommend-info .listen-btn,.container .song-list .song-li .song-shadow,.contri-condition .contri-select.active,.contri-condition .contri-select.active:after,.data-card .data-box .tab .fan-tab.current,.data-card .data-box .total .incr-num:before,.data-card .fans-box .tab .fan-tab.current,.data-card .fans-box .total .incr-num:before,.data-card .tab .data-tab.current,.dynamic-list-item-wrap .item-user a.stick,.face-g-item:hover,.face-g-list .mp-block .right ul li.base .round,.face-g-list .mp-block .right ul li.base.reach .round,.go-movie,.link-input:focus,.link-top-container .link-top-item.active,.media-tab-nav ul li.on,.media-tab-nav ul li:hover,.pagelistbox .p.active,.pagelistbox .p:hover,.points-btn,.project-list .project-list-item .promo-item,.record-nav .on,.review-list-wrp li .review-title .review-spoiler,.season-item.on,.season-item.on:after,.sl-ep-nav .sl-ep-nav-list .sl-ep-nav-item.on,.sl-ep-nav .sl-ep-nav-list .sl-ep-nav-item.on:after,.song-li .song-left .song-shadow,.sponsor-rank-tab .indicator,.sponsor-rank-tab .indicator:after,.tab-mk2.active,.tabnav-item.current .tabnav-content,.user-info>.tag-flag,.video-list .vl-hd .order-tab li.on{border-color:var(--theme-color)!important}.audioplayer .ap-controller .ap-controller-right .ap-volume-thumb-dot,.author-info .favourite-btn,.b-info .button,.ban-detail .content-box .vote-success .success-txt button,.big-member-btn,.big-member-btn .btn-confirm.disabled,.bili-btn.ok,.bili-header-m .i_menu_login .login-btn,.bilibili-player-ending-panel-box-functions .bilibili-player-pgcinfo-follow-binge-watching,.bilibili-player-ending-panel-box-functions .bilibili-player-upinfo-electric,.block-area .timeline-title .headline .timeline-more:hover,.bpui-button-text-only.bpui-state-active .bpui-button-text .bpui-flex-button,.btn-confirm,.btn-dufault:not(.btn-disabled),.bui-button.bui-button-blue,.bui-button.bui-button-gray3:hover,.carousel-module .panel .trig span.on,.cc-album-manage .info-wrp .cc-btn,.cc-btn.is-main,.cc-nav-wrp .nav-upload-btn>a,.charge-participate .part-btn,.coin-text-p .coin-i,.compila-condition .compila-right .compila-add.single,.compila-not-find .compila-not-find-ime,.contri-not-find .contri-not-find-ime,.el-pager li.active,.face-g-action[id=face-g-change],.face-g-list .mp-block .right ul li.reach .strip,.face-g-takedown,.face-g-takedown:hover,.face-g-use,.face-g-use:hover,.go-movie:hover,.h .h-follow,.h-safe-btn,.history-list .cover-contain .label,.host-list-layout .hot-list-wrap .bg-wrap .top-info-content .right-info .right-btn,.hot-box li .tag-type,.intimacy-bar>span,.invitation-btn,.live-module .tab-item .r-item:first-child .number,.live-module .tab-item .r-item:nth-child(2) .number,.live-module .tab-item .r-item:nth-child(3) .number,.live-status.on-live,.media-sponsor-wrapper .sponsor-right-area .sponsor-btn,.mp-mine-takedown,.new-stat-module .zone-title .headline .new-stat-more:hover,.news-list .news-item .type,.notice-card .academy-entry,.pagelistbox .p.active,.pagelistbox .p:hover,.paging-box-big .next:hover,.paging-box-big .prev:hover,.points-btn,.primary-menu .nav-menu .channel.on::after,.progress-bar-inner,.season-timeline .season-group.today .group-time:before,.section-item .diff-wrp .no-improve,.security-left .security-ul .security-list.on,.security-right-title-icon,.selector-wrapper .more-city-letter-list .more-city-letter-item .letter-item.active:after,.song-playbtn,.sponsor-rank-dialog .sponsor-rank-content .sp-rank-header .sp-rank-title,.timeline-box .timeline-item.new p.num a,.timer-wrap .vote-dialog-new .footer .b-able,.tit-b,.tl-head .tl-day.today .indicator,.wrapper .elec-message-wrp .elec-msg-btn{background-color:var(--theme-color)!important}#audience-page .version-switch-section .bili-tab.current,.acc-sec,.announce li .fontvt,.announce li>div span,.audioplayer .ap-controller .ap-controller-right .ap-playlist-button:hover .ap-playlist-button-amount,.author-info .communicate-btn,.author-info .link-pink:hover,.b-info .balance-name,.bangumi-home-crumb .fcname ul.n_num li.on a,.bangumi-media .bangumi-media-header .btn-more-review:hover,.bangumi-media .bangumi-media-header .rate-wrapper .btn-go-write:hover,.bangumi-review-item>a:hover .long-title,.bb-intro-top .b-question .b-question-title:hover,.big-more-item-item:hover .big-more-item-txt,.bili-tab.current,.bilibili-player-context-menu-container span.bppl-state-selected,.bilibili-player-ending-panel-box-functions div.active,.bilibili-player-ending-panel-box-recommend-add-watchlater .icon-22wait-choice,.bilibili-player-video-sendbar .bilibili-player-video-danmaku-wrap a,.bilibili-player-video-sendbar .bilibili-player-video-inputbar .bilibili-player-video-hint a:hover,.block-area .timeline-toggle-block .timeline-toggle-btn:hover,.bottom-help a,.bp_box_bot a:hover,.bpui-button-text-only.bpui-state-active .bpui-icon-checkbox.icon-12select,.bpui-button-text-only.bpui-state-active .bpui-icon-checkbox.icon-12select-round,.bread-crumb ul li.on a,.bread-crumb ul li:hover a,.btn-delete:hover,.bui-button.bui-button-text,.bui-tabs .bui-tabs-header .bui-tabs-header-item.bui-tabs-header-item-active,.buy-detail .rights,.charge-participate h1,.chat-history-panel .chat-item.welcome-guard .username,.cm-model .report-detail .more-list a,.coin-nav .on,.coin-num,.coin-operated-m .mc-box.on .c-num,.container .host-list-layout .hot-list-wrap .hot-song-list .song-info .song-content .iconfont:hover,.container .host-list-layout .hot-list-wrap .show-more-song:hover,.container .host-list-layout .hot-list-wrap .show-more-song:hover .iconfont,.container .musician-recommend .recommend-item .recommend-info .listen-btn,.container .tag .item-btn,.contri-condition .contri-select.active,.contri-condition .contri-sort .contri-sort-type li:hover,.control-panel-ctnr .title,.danmu-container .empty-danmu a,.data-card .data-box .tab .fan-tab.current,.data-card .fans-box .tab .fan-tab.current,.data-card .tab .data-tab.current,.dynamic-list-item-wrap .item-user a.stick,.episode-item.on .ep-index,.episode-item.on .ep-title,.episode-item.on:hover .ep-index,.episode-item.on:hover .ep-title,.follow-container .follow-right .follow-intro .follow-fold,.go-movie,.h-safe-a,.home-top-level-mask-warp a,.hot-box li:hover .txt,.hotsong-li .font24:hover,.hotsong-li .hotsong-title a:hover,.i-live .i-live-fo-btn,.i-live:hover .i-live-title,.icon-edit,.lh12 a,.link-footer a:hover,.link-popup-panel .title-ctnr .popup-title,.live-ctn .live-attch .host:hover,.live-ctn .live-attch .title:hover,.live-module .tab-item .r-item a:hover .u-name,.live-module .zone-title .headline .online span,.m-help:hover,.main-content-title a,.medal .medal-form .page-tip a:hover,.media-info-card .mic-expand:hover,.media-tab-module-wrp .media-tab-module-more:hover,.media-tab-nav ul li.on,.media-tab-nav ul li:hover,.mini-item .detail a:hover,.misl-ep-item:hover .misl-ep-text .misl-ep-index,.misl-ep-item:hover .misl-ep-text .misl-ep-title,.mod-1 .r .title:hover,.mod-1 .r .up-info .v-author:hover,.mod-2 li .r .title:hover,.mod-2 li .r .up-info .v-author:hover,.mod-3 .r .title:hover,.mod-3 .r .up-info .v-author:hover,.nav-upload-container .nav-upload-item>p,.out-link,.pagination-wrapper .pagination .pageNum.active,.pagination-wrapper .pagination .pageNum:hover,.player-auxiliary-auxiliary-area .player-auxiliary-filter-menu:hover,.player-auxiliary-block-list .player-auxiliary-block-line-state,.player-auxiliary-setting-menu-wrap .player-auxiliary-setting-menu-list:hover,.points-num,.project-list .project-list-item .promo-item,.record-exp-title .s,.review-feed-item .feed-left .review-about .author-info:hover,.review-feed-item .feed-left .review-about .media-title:hover,.review-feed-item .feed-left .review-info:hover .review-title,.review-list-wrp .review-detail:hover .review-title,.review-list-wrp li .review-author-info div.review-author-name:hover,.review-list-wrp li .review-title .review-spoiler,.room-introduction-content a,.season-timeline .season-group.today .group-time,.season-timer .current-timer,.season-timer .season-label,.section-item .text-content,.security-right-title-text,.selector-wrapper .city-list .city-item.active,.selector-wrapper .city-list .city-item:hover,.selector-wrapper .li-more .active,.selector-wrapper .more-city-list .more-city-item:hover,.selector-wrapper .order-list .city-item.active,.selector-wrapper .order-list .city-item:hover,.setting .section-edit,.share-module .share-list .weixin-share-modal .share-tips a,.sl-ep-nav .sl-ep-nav-list .sl-ep-nav-item.on,.sl-ep-nav .sl-ep-nav-list .sl-ep-nav-item:hover,.slot-ctnr .panel li:hover,.song-info .song-info-content a,.song-infoFold,.song-introText,.song-li .song-right .song-intro a:hover,.song-lrcFold,.song-title .font18,.sort-type-wrp ul li:hover,.sponsor-pay-dialog-v2 .sp-pay-index .sponsor-agree a:hover,.sponsor-rank-tab li.active,.sponsor-rank-tab li:hover,.sub-nav-m ul li a:hover,.sub-nav-m ul li.on a,.tab-mk2.active,.tab-mk2.tab-mk2-r,.tab-mk2:hover,.tabnav-item.current,.tag-more .b-toggle-btn:hover,.timeline-box .timeline-item .item-right a:hover,.title-link,.toolbar-wrapper,.toolbar-wrapper .toolbar-title,.ui-calendar .main-wrap .shortmenus a:hover,.union-cntr a,.user-box .btn,.user-box .btn:active,.user-box .vip-btn,.user-info-name.active,.user-info>.tag-flag,.user-panel-ctnr .exit-btn:hover,.video-list .vl-hd .order-tab li.on,.video-list .vl-hd .type-tab li.on,.wrapper .elec-sub-title .exp,.wrapper .elec-sub-title .vip-point,a.bp_box_bot_click,button.button.more:hover,li.season-item .season-body .season-desc.published,li.season-item .season-body .season-title:hover,span.flatpickr-weekday{color:var(--theme-color)!important}.author-info .favourite-btn,.big-member-btn,.bili-header-m .i_menu_login .login-btn,.bili-header-m .i_menu_login .reg a,.btn-confirm,.btn-dufault:not(.btn-disabled),.bui-button.bui-button-blue,.bui-button.bui-button-gray3:hover,.comment-video,.fav-main .fav-action-bottom .select-cancel,.h .h-follow,.h-safe-btn,.history-list .cover-contain .label,.hot-box li .tag-type,.live-module .tab-item .r-item .number,.live-module .tab-item .r-item:first-child .number,.live-module .tab-item .r-item:nth-child(2) .number,.live-module .tab-item .r-item:nth-child(3) .number,.live-status.on-live,.news-list .news-item .type,.pagelistbox .p.active,.pagelistbox .p:hover,.paging-box-big .next:hover,.paging-box-big .prev:hover,.wrapper .elec-message-wrp .elec-msg-btn{color:var(--foreground-color)!important}.bilibili-player-ending-panel-box-functions div.active .bp-svgicon,.bilibili-player-ending-panel-box-functions div.active:hover .bp-svgicon{fill:var(--theme-color)!important}.b-info,.bb-intro-top,.bili-footer .boston-postcards li,.container,.danmu-container,.el-picker-panel [slot=sidebar],.el-radio-button:first-child .el-radio-button__inner,.h-line,.media-info-count .media-info-count-item,.mod-2 li .l-item,.security-right,.sl-ep-nav .sl-ep-nav-list .sl-ep-nav-item.on:after,.sponsor-rank-tab .indicator:after,.video-list .vl-hd .s-line,a.bp_box_bot_click{border-left-color:transparent!important;border-right-color:transparent!important}#community_msg,#page-channel-detail .watch-later-btn,#rankList .list-wrap .list .switch-day .switch-list:hover,.academy-card.card,.app .module-card.comment,.area-item-ctnr .area-item:hover,.article-action .ops .share-container .weixin-holder,.audioplayer .ap-controller,.audioplayer .ap-playlist,.audioplayer .ap-playlist .ap-playlist-body,.banner-wrapper .swiper-pagination-bullet,.bb-comment .comment-emoji,.bili-header-m .head-banner,.bili-radio+span::before,.bili-switcher,.bilibili-evolved-about,.bilibili-player-video-sendbar,.bnj-comment .page-comment,.bui-sns-info a .bd,.cc-content-body .setting,.chatPanelBody .chatPanel,.chatPanelBody .chatPanel .chatPanelList,.coin-wrap,.data-card.card,.date-input .date-panel,.date-input>input,.dc-section-body,.download-video-panel,.el-date-table td,.el-date-table td.in-range:hover,.el-pager li,.el-pagination .btn-next,.el-pagination .btn-prev,.el-pagination button.disabled,.el-pagination__editor,.error-body,.footer .text-layout,.grid .banner,.gui-settings-dropdown>ul,.gui-settings-flat-button .popup,.gui-settings-widgets-box,.guide-card.card,.h5share-container .image-area .share-img,.income-card.card,.input-section .schedule-panel .s-input,.input-section .schedule-panel .s-panel,.js-evaluateArea .evaluateDialog,.leaveMsg .leaveMsgBody .classDropdown-menus li a:hover,.leaveMsg .leaveMsgBody .classDropdown-menus li:hover,.leaveMsg .leaveMsgHeader,.link-navbar-ctnr,.link-popover-ctnr .link-popover,.live-ctn .item-live,.live-status.offline,.main-container .plp-l .player-mask .bar-wrapper .left-bar,.main-container .plp-l .player-mask .bar-wrapper .right-bar,.mainBox .leaveMsg,.mainBox .sureWindow,.medal-get-box,.medal-message-box,.medal-popup,.medal-up-trueLove,.nav-guide-container .nav-guide-tip,.nav-header-wrapper .nav-header .nav-header-search-bar-wrapper .suggestion-list,.notice-card .notice-list .notice-item,.notice-card.card,.notice-panel .img-container .notice-img,.open-dialog-masker .open-dialog-content,.play-options .play-options-more .play-options-content .play-option,.play-options .share-box,.project-list .project-list-item .project-list-item-img,.rank-item .content,.rank-tab-wrap,.sch-pub-tips,.sch-pub-tips::after,.search-module .search-block .search-word-panel,.search-module .search-block .search-word-panel .panel-title p span,.setting .watermark-setting .watermark-wrp .watermark-modal,.toast-card,.twp-mask .twp-wrapper,.uns_box li .i_menu,.uploader-info .info .follow .num,.user-info .user-info-desc,.user-panel-ctnr .user-avatar,.withdraw-wrapper .withdraw-text,div#square.container{background-color:#222!important}.article-holder .error-card .video-holder .video-cover,.article-holder .error-card .video-holder p,.player-auxiliary-danmaku-function .player-auxiliary-danmaku-multiple-control{background-color:#333!important}#activeCenter .s-imgUnit .s-imgUnit-img,#rankList .list-wrap .list .switch-day,.act-card-wrap .act-card .type,.app .module-card,.article-item .item-holder .article-title-holder .list-mark,.audioplayer .ap-controller .ap-controller-center .ap-play-bar-wrap,.audioplayer .ap-controller .ap-controller-left .ap-cover,.audioplayer .ap-controller .ap-controller-right .ap-playlist-button-bg,.audioplayer .ap-controller .ap-controller-right .ap-volume-bar-wrap,.audioplayer .ap-playlist .ap-playlist-body li.ap-playlist-line-active,.audioplayer .ap-playlist .ap-playlist-body li:hover,.bili-share-pc,.bili-share-pc .share-weixin-qr,.bili-share-pc .weixin-hover .qr-before,.bilibili-live-player-ending-panel-recommend-card,.canvas-card dt .img-contain,.card .img-box,.card .user-face,.card-timing-module .r-text .update a,.container .host-list-layout .hot-list-wrap .bg-wrap,.container .song-list .song-li .song-img,.content-panel .title span,.dynamic-list-item-wrap .send-bg,.el-date-table td.in-range,.el-date-table td.next-month:hover,.el-date-table td.prev-month:hover,.el-date-table td:hover,.el-picker-panel__shortcut:hover,.el-select-dropdown.is-multiple .el-select-dropdown__item.selected.hover,.el-select-dropdown__item.hover,.el-select-dropdown__item:hover,.error-container,.evaluate .situation span,.evaluateWether .evaluate-btn,.face-g-list .mp-block .right ul li.base .round,.footer-content .social-item,.form-login .input-box .btn-box .btn,.form-login .input-box .item input,.gui-settings-checkbox::after,.guide .old-btn a,.guide-card .guide-box a,.index-nav .n-i.gotop .btn_gotop,.leaveMsg .leaveMsgBody .classDropdown-menus,.leaveMsg .leaveMsgBody .questionClassify .classDropdownAreaFixed,.leaveMsg .leaveMsgBody .questionClassify .classDropdownAreaFixed .router,.leaveMsg .leaveMsgBody .questionClassify .classIfyTitleArea,.list-wrap .s-showMore,.list.main_body .list_box .next_button,.magBox .msgDiv,.main-container .plp-l .player-mask .bar-wrapper,.main-container .title>span,.main_body .future .next_button,.nav-guide-container .guide-tip-btn .guide-tip-btn-right,.nav-panel-vc,.notify-v2-container>div,.open-dialog-masker .btn-normal,.page-content .right-side .rank-module .complete-rank,.page-content .right-side .up-list .fresh-btn,.pie-empty-wrapper,.play-options .play-options-more .play-options-content .play-option:hover,.play-up-info .play-up-intro .play-up-follow .play-up-followed,.player-auxiliary-area .player-auxiliary-collapse-playlist .bui-collapse-body,.progress-tv,.progress-tv .progress-img,.rank-module .rank-list .item .rank-index,.result-list .user-face,.s-lineMore-more,.s-rank.gray,.search-module .search-block .search-word-panel .history-item:hover,.search-module .search-block .search-word-panel .suggest-item:hover,.security-list .child-list li a:hover,.share-box .share-popup .share-address ul li input,.slide-controller .slide-btn,.sureWindow .btngroup span,.up-info .u-face .up-face,.upload-v2-step1-container .video-jam .video-jam-comment,.user-hd,.user-info .points-wrp .bar,body>div.to-top.on{background-color:#444!important}.bilibili-player-video-time-seek{background-color:#fff1!important}.blp-ui-slider-container{background-color:rgba(0,0,0,.1)!important}.mainBox .sureWindowlayer,.medal-mask,.qrcode-login .qrcode-con .qrcode-box .status{background-color:rgba(0,0,0,.5)!important}#mp-mine-header,#mp-mine-header.active,.fans-icon,.guide-card .guide-box a,.rank-list .canvas-card:nth-child(-n+3)::after{background-image:none!important}#announcement-area .more-link:hover,#app>div>.container,#app>div>div>div.container,#rankList .list-wrap .list .switch-day .switch-list,#song_detail_click_upper~div .pager .pages .page-item button,#song_detail_click_upper~div .pager .pages .page-item.active button,.area-section .card-ctnr .more,.area-section .card-ctnr .more:hover,.article-list-holder .article-item,.bb-comment .con,.bb-comment .hot-line span,.bb-comment .list-item:hover,.bb-comment .more-link:hover,.bb-comment .result,.bili-header-m.report-wrap-module,.bilibili-player-danmaku-report-panel .bui-radio-input:checked+.bui-radio-label,.bilibili-player-video-bottom-area::before,.chat-history-panel .chat-history-list .chat-item.system-msg .msg-icon,.create-vote .bg-color,.date-input,.filter-wrap .sub-filter,.i-frame,.idol-show .section-title .more,.idol-show .section-title .more:hover,.index-nav .n-i .name:hover,.input-section,.input-section .schedule-panel,.jumping-ctnr .jumping-input,.leaveMsg .leaveMsgBody .email,.leaveMsg .leaveMsgBody .telephone,.leaveMsg .submitArea,.link-panigation-ctnr .pagination,.link-progress-tv,.live-sidebar-ctnr,.main-container .review-module .module-title .more-link,.mode-fullscreen .bilibili-player-video-btn-widescreen,.mode-fullscreen .bilibili-player-video-sendbar,.mode-webfullscreen .bilibili-player-video-sendbar,.page-content .right-side .up-list,.pagelistbox .custom-right .custom-right-inner,.play-options .play-options-more .play-options-content,.player-auxiliary-area,.popularize-module .online,.rank-list-ctnr,.rank-module .rank-list .item,.result .card,.search-module .search-block input,.singlePage .mainBox,.title-line .tit{background-color:transparent!important}.coin-wrap .coin-nav .coin-checkbox{background:#fff!important}.chat-history-panel .chat-history-list .chat-item.danmaku-item .admin-icon,.chat-history-panel .chat-history-list .chat-item.danmaku-item .anchor-icon,.date-input .date-panel .day.disabled{color:#444!important}.announcement-cntr .header p .icon-edit,.announcement-cntr .header p span,.article-action .ops .share-container .weixin-holder p,.article-action .ops i,.article-holder .music-card .container,.article-item .item-holder .article-desc,.article-item .item-holder .article-info-bar .category,.article-item .item-holder .article-info-bar .like,.article-item .item-holder .article-info-bar .reply,.article-item .item-holder .article-info-bar .up-content .nick-name,.article-item .item-holder .article-info-bar .view,.bangumi-rating-container .bangumi-rating-subtitle,.bb-comment .bottom-page.center,.box .content .item,.bui-button.bui-button-gray3,.channel-info .meta,.chatPanel .historyTrigger,.chatPanelList .msgData,.coin-wrap .coin-tips,.container .hot-list .music-menu-list .menu-type,.container .left-container .play-options,.container .left-container .play-up-info .play-up-self-btn,.container a,.danmu-hot .tab-list .tab,.date-input .date-panel .week,.dc-section-item_title_time,.dynamic-m .dyn_list_wrapper .dyn_list li.loading,.elec .elec-monthly-count,.elec-message-wrp .elec-count-wrp,.evaluate .h2,.fans-no-data-wear::after,.fans-no-data::after,.footer-content .social-item,.form-login .input-box .sns .btn,.hot-list .card-ctnr .room-count .icon-font,.leaveMsg .leaveMsgBody .guide,.leaveMsg .leaveMsgBody .infoArea .infoAreaTitle,.leaveMsg .leaveMsgBody .questionClassify .classText,.leaveMsgUpload .btnarea span.btareatxt,.magBox .leftName,.more .help .info,.more .link .info,.nav-guide-container .nav-guide-tip .guide-tip-content-main h3 span,.nav-guide-container .nav-guide-tip .guide-tip-content-main p,.no-data-integrity,.open-dialog-masker .open-body ul li i,.open-dialog-masker .open-footer .open-agree,.page-container .article-action,.play-options .share-box .share-btn ul .bili-share,.play-up-introduction .play-up-sign,.qrcode-login .qrcode-footer .app-link,.qrcode-login .qrcode-footer .suc-txt,.questionClassify .classDropdownAreaFixed .router .routerDeep,.rank-item .content .info .bangumi-info,.rank-module .rank-tabs-bar .rank-tabs-list li,.record-item-line .comment-floor,.record-item-line .comment-location,.record-item-line .comment-time,.record-item-line .good,.room-card-item .info .s-info,.s-imgUnit-text p,.s_tag .nothing,.scroll-loading,.search-module .search-block .search-word-panel .panel-title p span,.setting .section-title span,.setting .watermark-setting .tooltip,.setting .watermark-switcher .switcher-tip,.small-item .meta,.twp-mask .twp-wrapper .twp-container .twp-text .twp-desc,.up-feedback .up-fb-btn,.up-list .up-item .info-holder .dynamic,.uploader-info .info .follow .num,.user-info .user-info-desc,.video-list-wrapper .title .text .num,.video-toolbar .appeal-text{color:#aaa!important}#announcement-area .news-ctnr .icon-arrow-right,#announcement-area .news-ctnr .more-link,#announcement-area .rank-ctnr .icon-arrow-right,#announcement-area .rank-ctnr .more-link,#community_msg .dyn_menu li a,#i_menu_profile .info .coin .outside,#i_menu_profile .info a.linkToCurrency,#mangoTv .mango-rank .text-list a,#page-channel-detail .watch-later-btn,#page-playlist-wrap .breadcrumb .item,#rankList .list-wrap .list .bar .text,#rankList .list-wrap .list .switch-day,#rankList .list-wrap .text-list a,.act-card-wrap .act-card .title,.act-card-wrap .act-card .type,.announcement-cntr .header p,.article-holder .bangumi-card a .container .title,.article-holder .music-card .container .title,.article-item .item-holder .article-title-holder .list-mark,.bangumi-rating-container .bangumi-rating-title,.banner-wrapper .swiper-pagination-bullet,.base-info .btn-wrapper,.bili-btn.plain,.bili-share-pc .share-weixin-qr h4,.bili-share-pc .title,.bilibili-player-video-control .bilibili-player-video-volume-num,.blink-qrcode .title,.block-effect-ctnr .item,.bottom-actions .action-item,.card-timing-module .r-text .update a,.channel-detail .content .breadcrumb .item,.coin-wrap .coin-title,.container .hot-list .menu-title,.content-panel .title span em,.danmu-hot .video-list .video-wrapper .video .title,.date-input,.date-input .date-panel .ym,.date-input>input,.details-up-name,.el-pager li.btn-quicknext,.el-pager li.btn-quickprev,.el-pagination .btn-next,.el-pagination .btn-prev,.el-pagination__editor,.error-container .error-text,.evaluate .situation span,.evaluateWether .evaluate-btn,.evaluateWether .evaluateTitle,.footer .boston-postcards li .tips,.form-login .input-box .btn-box .btn,.form-login .input-box .item input,.form-login .input-box .remember,.gift-box>.num,.gridview-sidebar .album-title,.gui-settings-dropdown input,.gui-settings-widgets-box,.gui-settings-widgets-box>.widgets-container>*,.guide .old-btn a,.guide-card .guide-box a,.history-dlg .hsbtn .cancel,.input-section .schedule-panel .dp-label,.input-section .schedule-panel .s-input,.input-section .schedule-panel .s-item,.input-section .schedule-panel .s-label,.jumping-ctnr .jumping-input,.leaveMsg .leaveMsgBody .classDropdown-menus li,.leaveMsg .leaveMsgBody .email,.leaveMsg .leaveMsgBody .questionClassify .classIfyTitleArea .classIfyTitle,.leaveMsg .leaveMsgBody .telephone,.leaveMsg .leaveMsgHeader .title,.link-popover-ctnr .link-popover,.link-progress-tv,.list-wrap .s-showMore,.list.main_body .list_box .next_button,.magBox .msgDiv .msgText,.main-container .title>span,.main-container .tool-bar .share-info i,.main_body .future .next_button,.medal-up-trueLove,.media-info .media-content .media-title a,.media-upper .media-upper-info .media-upper-name,.more .help .title,.more .link .title,.more .top-bar,.nav-guide-container .guide-tip-btn .guide-tip-btn-right,.nav-header-wrapper .nav-header .user-panel,.nav-header-wrapper .nav-header .user-panel a,.notify-v2-container>div .notify-v2-close,.notify-v2-container>div a,.notify-v2-container>div>span,.open-dialog-masker .__dialog-header p,.open-dialog-masker .btn-normal,.open-dialog-masker .open-body p,.open-dialog-masker .open-body ul li span,.page-content .left-side .partitio-name,.pgc-rank-dropdown .selected,.play-options .play-options-more .play-options-content .play-option,.play-title .play-title-location,.play-up-info .play-up-intro .play-up-follow .play-up-followed,.play-up-info .play-up-self .play-up-self-content,.play-up-introduction .play-up-name a,.player-auxiliary-danmaku-function .player-auxiliary-danmaku-multiple-control-title,.popularize-module .online a,.rank-item .content .info .title,.rank-module .complete-rank,.rank-module .rank-list .item .rank-index,.rank-module .rank-list .item a,.rank-module .rank-tabs-bar label,.rec-list .info .title,.s-imgUnit-text a,.s-lineMore-more,.s-rank.gray,.sch-pub-tips,.search-module .search-block input,.setting .watermark-switcher span,.share-box .share-popup .share-address ul li input,.similar-song-menu .similar-right .title,.super-gift-item .gift-info .user-name,.super-gift-item .gift-info .user-name:hover,.sureWindow .btngroup span,.sureWindow .title,.twp-mask .twp-wrapper .twp-container .twp-text .twp-title,.u-info .u-name,.up-list .fresh-btn,.up-list .title,.up-list .up-item .info-holder .dynamic .arc-title,.up-list .up-item .info-holder .head .nick-name,.upload-v2-step1-container .video-jam .video-jam-comment,.user-info .points-wrp .points-schedule .now-points,.user-info .user-info-hd .t,.video-list-wrapper .title .more .text,.video-list-wrapper .title .text{color:#eee!important}.list.main_body .right_box .select_box .select .option_block .option.selected,.toast-card .link,.toast-card span,.toast-card-message,.toast-card-title{color:#fff!important}#page-channel-detail .filter,#page-channel-detail .watch-later-btn,#rankList .list-wrap .list,#rankList .list-wrap .list .switch-day,.act-card-wrap .act-card .type,.announcement-cntr .content,.app .module-card,.article-action .ops .share-container .weixin-holder,.article-holder .bangumi-card a .container,.article-holder .music-card,.article-item .item-holder .article-title-holder .list-mark,.bb-comment .bottom-page.center,.bb-comment .hot-line,.bili-share-pc,.bilibili-live-player .bilibili-live-player-enter-tips,.bp-input .content-box::before,.coin-wrap .coin-sure,.container .left-container .media-comment,.container .left-container .play-up-info,.container .right-container .media-theme,.content-panel .title span,.danmu-hot .tab-list,.date-input .date-panel,.date-input>input,.detail-card .card,.el-autocomplete-suggestion__wrap,.el-pager li,.el-pager li:last-child,.el-picker-panel,.el-time-range-picker__body,.evaluate .situation span,.evaluateWether .evaluate-btn,.evaluateWether .noactive,.evaluateWether .okactive,.filter-wrap .sub-filter,.form-login .input-box .btn-box .btn,.form-login .input-box .btn-box .btn-login,.form-login .input-box .item input,.grid .banner,.guide .feedback-btn a,.guide .old-btn a,.hash-popup .topic-container .item.is-selected,.index-nav .n-i.gotop .btn_gotop,.input-section,.input-section .schedule-panel .s-input,.input-section .schedule-panel .s-panel,.leaveMsg .leaveMsgBody .questionClassify .classDropdownAreaFixed .router,.link-popover::after,.link-popover::before,.list-wrap .s-showMore,.list.main_body .list_box .block .cover,.medal-get-box,.medal-message-box,.medal-up-trueLove,.more .top-bar,.nav-guide-container .guide-tip-btn .guide-tip-btn-right,.nav-header-wrapper .nav-header .nav-header-search-bar-wrapper .suggestion-list,.open-dialog-masker .btn-normal,.play-options .play-options-more .play-options-content,.play-options .play-options-more .play-options-content .play-option,.play-options .share-box,.publish-panel .hash-popup,.rank-module .rank-tabs-bar,.review-module .review-list .empty-wrapper .btn-go-write,.s-lineMore-more,.search-module .search-block .search-word-panel,.share-box .share-popup .share-address ul li input,.title-line,.twp-mask .twp-wrapper .twp-container .twp-btns .twp-btn.confrim,.twp-mask .twp-wrapper .twp-container .twp-btns .twp-btn.ticket,.twp-mask .twp-wrapper .twp-container .twp-btns .twp-btn.vip,.up-list .fresh-btn,.up-list .title,.upload-v2-step1-container .upload-btn,.upload-v2-step1-container .video-jam .video-jam-comment,.uploader-info .info .follow .num,body>div.to-top.on{border-color:transparent!important}.bili-radio+span::before,.channel-info .c-count,.open-dialog-masker .open-body ul li i,.popularize-module .online em{border-color:#aaa!important}.act-card-wrap .act-card,.article-list-holder .article-item,.bili-switcher,.bui-sns-info a .bd,.chatPanelBody .footer,.date-input .date-panel .ym,.el-date-range-picker__content.is-left,.el-picker-panel [slot=sidebar],.el-picker-panel__sidebar,.leaveMsg .leaveMsgHeader,.leftMsg .msgDiv:before,.login-box .line,.medal-receive-title,.open-dialog-masker .__dialog-header,.pagelistbox .custom-right .custom-right-inner.custompage,.search-module .search-block,.search-module .search-block .search-word-panel .panel-title .split-line,.up-info-holder .fixed-box .more .top-bar,.up-info-holder .fixed-box .up-article-list-block .block-title{border-color:#444!important}.singlePage .mainBox{border:1px solid #444!important}.gui-settings-dropdown::after,i.settings-category-arrow::after{border-color:#fff!important}.bilibili-player-video-sendbar .bilibili-player-video-inputbar .bilibili-player-video-hint a,.player-auxiliary-btn-playlist-order path{fill:#aaa!important}.audioplayer .ap-play-button svg path,.toast-card-dismiss path{fill:#fff!important}#rankList .list-wrap .list .switch-day .icon-bottom,.breadcrumb .arrow,.change-push .icon,.compact .primary-menu .nav-menu .side-nav .side-link i.blackroom,.compact .primary-menu .nav-menu .side-nav .side-link i.live,.compact .primary-menu .nav-menu .side-nav .side-link i.square,.compact .primary-menu .nav-menu .side-nav .side-link i.zhuanlan,.compact .primary-menu .nav-menu>li.home>a,.error-container .error.split,.leaveMsg .leaveMsgBody .questionClassify .classIfyTitleArea .classIfyTitleIcn,.list-wrap .s-showMore .icon-right,.nav-header-wrapper .nav-header .user-panel .panel-list .icon,.page-content .right-side .up-list .fresh-btn:before,.s-lineMore-more .icon-right,.security-list .first-level .m-arrow,.slide-controller .slide-btn .icon,[class^=icon-]::after{filter:brightness(0) invert(1)!important}.funcPanel .addFace,.funcPanel .capture,.funcPanel .evaluate,.funcPanel .leaveMessage,.funcPanel .zhichiClose,.tool-box-v2-container .icon-download,.tool-box-v2-container .icon-tv{filter:brightness(0) invert(.7)!important}#article-list-index .index-holder .article-item.on .point,#article-list-index .title-holder .icon-close,#page-channel-detail .watch-later-btn:hover,.banner .slides-pagination li.selected,.block-effect-ctnr .item .cb-icon,.bp-svg-icon.link,.bui-radio-icon.bui-radio-icon-selected,.bui-sns-info>a>img,.carousel .indicator .indicator-btn-holder .indicator-btn.on,.cc-nav-wrp .logo,.coin-operated-m .like-checkbox input[type=checkbox]:checked+i,.el-carousel .el-carousel__indicators .el-carousel__indicator.is-active,.error-container .error-panel .error-msg .error-img img,.face-g-list .mp-block .right ul li.reach::after,.i-watchlater.has-select,.leaveMsgUpload .btnarea .btnareaIcon,.mainmenu ul.grid li a.lbzx:hover,.mainmenu ul.grid li a.yxlb:hover,.mainmenu ul.grid li.hover a.lbzx,.mainmenu ul.grid li.hover a.yxlb,.prize-item .prize-img,.slideshow .slides-next:hover,.slideshow .slides-pagination li.selected,.slideshow .slides-prev:hover,.small-item.new .new-icon,.video-list .vl-hd .display-tab li.on,.vote-create-btn.active,.vote-create-btn:hover{filter:var(--blue-image-filter)!important}.article-holder .music-card .container .col-3 .card-label,.svg-icon.good-6-click{filter:var(--pink-image-filter)!important}.article-item .item-holder .article-info-bar .like:before,.article-item .item-holder .article-info-bar .reply:before,.article-item .item-holder .article-info-bar .view:before,.evaluateWether .evaluateno i,.evaluateWether .evaluateok i,.evaluateWether .operateType .unsolveActive span,.leaveMsg .leaveMsgHeader .close,.rank-item .content .info .detail .b-icon.author,.rank-item .content .info .detail .b-icon.view,.rank-module .complete-rank::after,.search-module .search-block .search-icon,.search-module .search-block .search-word-panel .history-item .cancel,.sureWindow .close,.video-list .vl-hd .display-tab li,body>div.to-top.on{filter:grayscale(1)!important}#player-header .bg-image:hover,.player-area-ctnr .bg-image:hover{filter:brightness(.7)!important}#player-header .bg-image,.player-area-ctnr .bg-image{transition:.2s .5s!important;filter:brightness(.2)!important}.up-feedback .icon-beta{filter:brightness(.5)!important}.bangumi-player,.face-g-more,.m-help .m-arrow,.record-nav .on,.tab-mk2.active{background-image:none!important}.bangumi-player,.bui-sns-info a .bd,.canvas-card dd .icon-contain .support,.cc-article-wrp .info-wrp .cc-btn,.demo-app .detail .category,.el-picker-panel,.guide .old-btn a,.link-navbar-ctnr,.live-sidebar-ctnr,.main-container .entry-old .btn-old,.main_body .pick_up .pick_list .pick_block .pic,.media-sponsor-wrapper .sponsor-right-area .sponsor-btn,.nav-header-wrapper .nav-header .user-panel .panel-list,.nav-header-wrapper .nav-header .user-panel .user-uname,.rank-item:hover,.selector-wrapper,.singlePage .mainBox,body>.player #bilibiliPlayer{box-shadow:none!important}#app .toolbar-wrapper,#article-list-index,.article-action .ops .share-container .weixin-holder,.guide .feedback-btn a,.js-evaluateArea .evaluateDialog,.mainBox .leaveMsg,.project-list .project-list-item:hover,.publish-panel .hash-popup,.sch-pub-tips{box-shadow:0 1px 10px 0 var(--theme-color-30)!important}.bui-sns-info a .bd::after,.canvas-card dd .icon-contain .support::after,.date-input>img,.filter-wrap .icon-tid2-arr,.main-container .title span::before,.more .help .icon,.more .link .icon,.nav-bar .sub-nav::after,.nav-guide-container .nav-guide-tip .guide-tip-triangle,.side-bar-popup-cntr:after,.top-banner,.user-info .user-info-desc .arrow-left{display:none!important}@supports (backdrop-filter:blur(24px)) or (-webkit-backdrop-filter:blur(24px)){.gui-settings-box.blur .gui-settings-content,.gui-settings-box.blur .gui-settings-footer,.gui-settings-box.blur .gui-settings-header,.gui-settings-box.blur li.category{background:0 0!important}}.face-g-list .mp-block .right ul li.base .round{z-index:100!important}.more .help,.more .link{padding-left:0!important}body>div.to-top.on{background-repeat:no-repeat!important}.article-action .ops .share-container .weixin-holder p{margin-bottom:10px!important}#jfContent{filter:invert(1)}.input-section:focus-within{outline:0!important}.input-section .textarea{border-radius:4px!important;border:1px solid transparent!important}.input-section .textarea:focus-within{border:1px solid!important}.activity.topic-preview-wrapper .s-bottom{border-radius:0!important}.qrcode-login .qrcode-con .qrcode-box .qrcode-img{border:10px solid #fff!important}.qrcode-login .qrcode-con .qrcode-box .status{border:10px solid transparent!important}.card-list .card{border:none!important;border-radius:4px!important}#index-player-vm .item-border,#rankList .list-wrap .list .switch.active,#rankList .list-wrap .list .switch.active.active:after,#rankList .list-wrap .list .switch:hover,#rankList .list-wrap .list .switch:hover.active:after,.arrow-down.active,.audioplayer .ap-playlist .ap-playlist-body .ap-playlist-column-name-value:hover,.bili-radio:checked+span::before,.bili-switcher.checked,.container .hot-list .music-menu-list .choose-menu,.container .hot-list .music-menu-list .menu-type .type-triangle,.danmu-hot .tab-list .tab.active,.data-card .tab .data-tab.current:after,.date-input .date-panel .day.active,.date-input>input.active .date-input>input:focus,.input-section .s-input:focus,.input-section:focus,.list-filter-bar .sort-box .item.active,.list-filter-bar .sort-box .item:hover,.open-dialog-masker .open-body ul li i.icon-complete,.pagelistbox .custom-right .custom-right-inner.custompage:focus,.rank-module .rank-tabs-bar .rank-tabs-list li.on,.rightMsg .msgDiv::before,.sort-item.on i.active,.up-list .up-item .info-holder .head .follow{border-color:var(--theme-color)!important}.blp-ui-slider-hover-container::before{border-top-color:var(--theme-color)!important}.blp-ui-slider-hover-container::after{border-bottom-color:var(--theme-color)!important}#index-player-vm .aside-item:after{border-right-color:var(--theme-color)!important}.audioplayer .ap-controller,.audioplayer .ap-playlist,.form-login .input-box .item input:focus{border:1px solid!important}.audioplayer .ap-controller .ap-controller-center .ap-progress-bar,.audioplayer .ap-controller .ap-controller-right .ap-volume-bar,.banner-wrapper .swiper-pagination-bullet-active,.be-tags-container .tag.new-tag,.bili-radio:checked+span::after,.bili-switcher.checked,.bilibili-live-player .bilibili-live-player-enter-tips,.bilibili-live-player .blpui-btn.default-btn.btn-blue,.blp-ui-slider-process,.card-timing-module .r-text .update .published,.coin-wrap .coin-sure,.draft-holder-block .draft-holder .panel .btn.on,.el-date-table td.in-range.end-date,.el-date-table td.in-range.end-date:hover,.el-date-table td.in-range.start-date,.el-date-table td.in-range.start-date:hover,.error-container .big-btn,.evaluate .situation span.active,.evaluateSubmitArea .submit,.evaluateWether .noactive,.evaluateWether .okactive,.follow-dialog-wrap .follow-dialog-window .bottom .btn,.follow-dialog-wrap .follow-dialog-window .bottom .btn:hover,.form-login .input-box .btn-box .btn-login,.gift-item-wrap .expiration,.gift>.expires,.guide .feedback-btn a,.index-nav .n-i.gotop .btn_gotop:hover,.leaveMsg .submitArea .submit,.main-container .pay-bar .vip .btn-pay,.medal-progress>i,.nav-guide-container .guide-tip-btn .guide-tip-btn-left,.nav-header-wrapper .nav-header .profile-img.active::before,.open-dialog-masker .btn-normal.confirm,.play-up-intro .play-up-follow .play-up-not-follow,.progress-bar-ctnr .bar-body .progress-bar,.rank-list .canvas-card:nth-child(-n+3)::after,.rank-list .item:nth-child(-n+3) .rank-index,.receive-list-next i,.receive-list-page,.receive-list-prev i,.review-module .review-list .empty-wrapper .btn-go-write,.rightMsg .msgDiv,.s-lineMore-more:hover,.s-rank.pink,.sch-pub-btn,.share-box .share-popup .share-address ul li .btn,.sureWindow .btngroup .leavesure,.twp-mask .twp-wrapper .twp-container .twp-btns .twp-btn.confrim,.twp-mask .twp-wrapper .twp-container .twp-btns .twp-btn.ticket,.twp-mask .twp-wrapper .twp-container .twp-btns .twp-btn.vip,.up-feedback .up-fb-btn:hover,.upload-v2-step1-container .upload-btn,.uploader-info .info .follow .btn,.user-info>.uid,.zcChat .header{background-color:var(--theme-color)!important}.audioplayer .ap-controller .ap-controller-center .ap-buffer-bar,.audioplayer .ap-play-button svg,.blp-ui-slider-buffer-container{background-color:var(--theme-color-60)!important}.audioplayer .ap-play-button:hover svg{background-color:var(--theme-color-90)!important}#activeCenter .s-imgUnit-img .overlay .des,#community_msg .dyn_menu li a:hover,#mangoTv .mango-rank .text-list a:hover,#rankList .list-wrap .list .bar .text:hover,#rankList .list-wrap .list .switch.active,#rankList .list-wrap .list .switch:hover,#rankList .list-wrap .text-list a:hover,#song_detail_click_upper~div .pager .pages .page-item button:hover,#song_detail_click_upper~div .pager .pages .page-item.active button,.app-link a,.article-action .coin-btn.on,.article-action .coin-btn.on i,.article-action .coin-btn:hover,.article-action .coin-btn:hover i,.article-action .fav-btn.on,.article-action .fav-btn.on i,.article-action .fav-btn:hover,.article-action .fav-btn:hover i,.article-action .like-btn.on,.article-action .like-btn.on i,.article-action .like-btn:hover,.article-action .like-btn:hover i,.article-action .ops i:hover,.audioplayer .ap-button:hover,.audioplayer .ap-playlist .ap-playlist-body li.ap-playlist-line-active,.audioplayer .ap-playlist .ap-playlist-body li:hover,.base-info .btn-wrapper .btn:active,.base-info .btn-wrapper .btn:active .icon-font,.base-info .btn-wrapper .btn:hover,.base-info .btn-wrapper .btn:hover .icon-font,.base-info .desc .tag,.bb-comment .more-link:hover,.bilibili-player-context-menu-container.black ul>li a>.active,.bilibili-player-video-subtitle-setting-left-more:hover,.bilibili-player-video-subtitle-setting-left-more:hover .bp-svgicon,.bilibili-player-video-subtitle-setting-right-more:hover,.bilibili-player-video-subtitle-setting-right-more:hover .bp-svgicon,.bilibili-player-video-toast-top-lower-quality,.blp-ui-button:hover>i,.channel-detail .content .breadcrumb .item:hover,.coin-wrap .coin-nav .coin-checkbox.on .lable,.coin-wrap .coin-title i,.comment-list a,.common-popup-wrap header,.container .left-container .play-up-info .play-up-self-btn:hover,.content-panel .title span:hover,.content-panel .title span:hover em,.danmu-hot .tab-list .tab.active,.danmu-hot .video-list .video-wrapper .video:hover .title,.date-input .date-panel .day.active,.el-pager li:hover,.face-g-more,.form-login .remember a,.gift-box:hover>.num,.hot-list .card-ctnr .room-count .amount,.hot-list .card-ctnr .room-count:hover,.hot-list .card-ctnr .room-count:hover .amount,.hot-list .card-ctnr .room-count:hover .icon-font,.i-pin-reason,.input-section .schedule-panel .s-item:hover,.leaveMsgUpload .btnarea .btareatxt1,.list-filter-bar .pic-type-box .item.active,.list-filter-bar .pic-type-box .item:hover,.list-filter-bar .sort-box .item.active,.list-filter-bar .sort-box .item:hover,.list-link a,.list-wrap .s-showMore:hover,.main-container .review-module .module-title .more-link:hover,.medal-up-name>a,.more .help .title:hover,.more .link .title:hover,.my-moral i,.noHover-link,.open-dialog-masker .__dialog-header .mr-close:hover,.open-dialog-masker .open-body ul li i.icon-complete,.open-dialog-masker .open-footer .open-agree a,.open-dialog-masker .open-footer .open-agree i.icon-chk-full,.panel-list .order-center-item:hover a,.play-options .share-box .share-btn ul .bili-share:hover,.popularize-module .online a:hover,.rank-item .content .info .bangumi-num,.rank-item .content .info .title:hover,.rank-module .complete-rank:hover,.rank-module .rank-list .item:hover a,.rank-module .rank-tabs-bar .rank-tabs-list li.on,.record-nav .on,.room-card-item:hover .room-name,.s-imgUnit-text a:hover,.search-module .search-block .search-word-panel .suggest_high_light,.setting .watermark-setting .watermark-wrp .is-selected,.similar-song-menu .similar-right .title:hover,.up-list .up-item .info-holder .head .follow,.up-list .up-item .info-holder .head .nick-name:hover,.upload-agreement a,.video-list-wrapper .video-list .icon-font:hover,.video-toolbar .appeal-text:hover,.viphelp span{color:var(--theme-color)!important}.banner-wrapper .swiper-pagination-bullet-active,.be-tags-container .tag.new-tag,.bilibili-live-player .bilibili-live-player-enter-tips,.bilibili-live-player .blpui-btn.default-btn.btn-blue,.card-timing-module .r-text .update .published,.coin-wrap .coin-sure,.el-date-table td.in-range.end-date,.el-date-table td.in-range.end-date:hover,.el-date-table td.in-range.start-date,.el-date-table td.in-range.start-date:hover,.error-container .big-btn,.evaluate .situation span.active,.evaluateSubmitArea .submit,.evaluateWether .noactive,.evaluateWether .okactive,.form-login .input-box .btn-box .btn-login,.gift-item-wrap .expiration,.gift>.expires,.guide .feedback-btn a,.index-nav .n-i .name:hover,.infoBar .infoBarText,.infoBarName .inputIng,.infoBarName .titleName,.leaveMsg .submitArea .submit,.magBox .msgDiv .msgText,.main-container .pay-bar .vip .btn-pay,.nav-guide-container .guide-tip-btn .guide-tip-btn-left,.open-dialog-masker .btn-normal.confirm,.play-up-intro .play-up-follow .play-up-not-follow,.rank-list .item:nth-child(-n+3) .rank-index,.review-module .review-list .empty-wrapper .btn-go-write,.s-lineMore-more:hover,.s-rank.pink,.sch-pub-btn,.share-box .share-popup .share-address ul li .btn,.sureWindow .btngroup .leavesure,.twp-mask .twp-wrapper .twp-container .twp-btns .twp-btn.confrim,.twp-mask .twp-wrapper .twp-container .twp-btns .twp-btn.ticket,.twp-mask .twp-wrapper .twp-container .twp-btns .twp-btn.vip,.up-feedback .up-fb-btn:hover,.uploader-info .info .follow .btn,.user-info>.uid{color:var(--foreground-color)!important}.audioplayer .ap-progress-thumb svg path:first-child,.audioplayer .ap-progress-thumb svg path:nth-child(2),.bilibili-player-video-danmaku-setting-left-more:hover .bp-svgicon,.bilibili-player-video-danmaku-setting-right-more:hover .bp-svgicon,.bilibili-player-video-sendbar .bilibili-player-video-inputbar .bilibili-player-video-hint a:hover,.bilibili-player-video-subtitle-setting-left-more:hover,.bilibili-player-video-subtitle-setting-left-more:hover .bp-svgicon,.bilibili-player-video-subtitle-setting-right-more:hover,.bilibili-player-video-subtitle-setting-right-more:hover .bp-svgicon,.bilibili-player-video-toast-item-close:hover,.player-auxiliary-btn-playlist-order:hover path,.receive-list-page{fill:var(--theme-color)!important}.leftMsg .msgDiv:before,.rightMsg .msgDiv::before{border-top-color:transparent!important;border-bottom-color:transparent!important}.gui-settings-dropdown::after,i.settings-category-arrow::after{border-top-color:transparent!important;border-left-color:transparent!important}#rankList .list-wrap .list .switch.active.active:after,#rankList .list-wrap .list .switch:hover.active:after,.container .hot-list .music-menu-list .menu-type .type-triangle,.data-card .tab .data-tab.current:after,.sort-item.on i.active{border-left-color:transparent!important;border-right-color:transparent!important}#announcement-area .rank-ctnr .rank-icon,#bp_right .bb_intro_box,#edit-page .btn-group.main-active-btn .ui-btn.loading,#edit-page .btn-group.main-active-btn a.white:hover,#edit-page .btn-group.main-active-btn button.white:hover,#footer,#page .game,#page .game .game-box h4,.active-main .act-list ul li,.add-tag .edit .btn-hide,.add-tag .edit .input-wrapper input,.add-tag .tag-list .tag,.alert-container,.assist-wrap .addModal .modal-wrap,.bangumi-up-info,.bind-info .note-footer .btn-group .back-btn,.bind-info .note-footer .btn-group .unable-btn,.bl-search:hover,.buy-vip-panel .panel-ctnr,.buy-vip-panel .panel-ctnr .panel-aside .aside-item.active,.canvas-card dd .icon-contain .support,.cards-block .cards-list .card-item .card-case .image,.cards-block .cards-list .card-item .card-case .title:empty,.cards-block .cards-list .card-item .card-case.type-head .text .content .block,.cards-block .cards-list .card-item .card-case.type2 .content .block,.cc-content-body .medal,.checkbox.checked .radio-btn,.classify .classify-list .list-item .class-block,.classify .classify-list .list-item .class-block:hover,.classify .sub-list,.comment-manage-wrap .head .search .bili-input,.comment-manage-wrap .search input,.content .user-protocol,.dc-option:hover,.demo-app .detail,.faq-modal .modal-wrap .modal-content .text-content,.func-banner .btn-dislike,.func-banner .btn-like,.game-groom-m .type-name,.game-more,.history-card:hover,.invite-code .copy-btn,.member-list-item .member-list-img,.modal-wrap,.online-list .ebox,.online-list .ebox .ol,.order-header-wrapper,.order-list-wrapper,.orderdetail-container .orderdetail-content,.pay-points-way-btn-disable,.pay-points-way-content,.pay-points-way-next,.qrcode-active .qrcode-active-slider .close-btn,.recharge-store-box .cntr .store-content,.record-ctnr .areas,.review-reply-wrapper,.rhythm-storm .bl-button:disabled,.set-copyright .copyright-icon .icon-none-copyright,.set-copyright .copyright-select-box,.song-info .info-wrap .album-itro,.song-info .info-wrap .album-name,.sub-tab-box .item.active,.text-input input,.ticket-container,.title-factory-card .title-num .num-value,.title-level .title-level-bar-wrap .title-level-bar,.topic-main .act-list ul li,.total-container,.trade-customn input,.ui-btn.sub-btn,.ui-btn.white,.ui-radio .ui-radio-icon,.ui-select .ul-select-list,.ui-select.white .ui-select-show-box,.ui-select.white .ui-select-show-box:hover,.user-info>.tag-gray,li.user-wrapper .avatar .detail,li.user-wrapper .avatar .detail .logout{background-color:#222!important}.player-auxiliary-area .bui-collapse{background-color:#333!important}#edit-page,.achievement-card,.achievement-user,.activity-card,.apply-banner-table tr:nth-child(even),.article-wrapper,.assist-wrap .addModal .control-group.assist-rights .rights,.author-info-card,.avatar .detail .level a.total,.balance_bp_box,.bangumi-list .synthetical .headline .bangumi-label,.banner-text,.bb_intro_box_top,.bili-input,.bili-pay-box-wrapper,.bili-pay-payment-wrapper,.bili-payment-list,.bind-info,.bui-sns-info,.buy-vip-panel .panel-ctnr .panel-aside,.canvas-card,.center-grid,.center-grid tbody tr:nth-child(odd),.classify .sub-list .sub-item.active,.classify .sub-list .sub-item:hover,.cntr .category,.comment-manage-wrap .content .action-bar,.comment-manage-wrap .dropdown .dropdown-btn:hover,.comment-manage-wrap .dropdown.open .dropdown-btn,.comment-manage-wrap .head .dropdown-btn,.comment-manage-wrap .head .dropdown-btn .text,.comment-manage-wrap .no-content,.condition-btn-disable,.container .host-list-layout .hot-list-wrap .hot-song-list,.container .host-list-layout .hot-list-wrap .show-more-song,.cover-upload-box .no-img,.daily-task .task-item,.dc-select .dc-option-group,.demo-app .detail .category,.drawer-card,.dropdown .dropdown-menu,.el-table .el-table__header-wrapper th,.el-table th,.el-table tr,.el-table--enable-row-hover .el-table__body tr:hover>td,.el-upload--picture-card,.fast-amount-list .item.free-amount input.ipt-free-amount,.float-toolbar .toolbar-list li,.game-groom-m,.game-groom-m .title,.gold-seed-store,.history-card,.income-info .item,.infor-body-left ul li,.infor-news .news-body,.infor-news .news-top,.link-panigation .panigation,.nav-container .single-box .ep-item,.nav-notice li a,.official-submit-btn-disable,.official-title-input,.order-list-wrapper .order-list .order-item .order-item-body-wrapper,.pagelist .flip-left span,.pagelist .flip-left strong,.pagelist .flip-right input,.project-info table tr,.project-info table tr:first-child,.promote-m .headline .change-push,.qrcode-active .qrcode-active-slider,.rank-item-first,.rank-item-first .detail,.rank-list-container .rank-list-wrapper,.rank-list-container .rank-list-wrapper .rank-list,.rank-list-head .rank_tips,.read-list-component .creat-read-list-box .input-box button[disabled],.recent-danmu-wrp .head .dropdown-btn,.recharge-store-box dl.recharge-form .ipt-number,.record-ctnr,.record-ctnr .area-selection-cntr,.record-ctnr .areas .btn-cntr .btn,.record-ctnr .areas .btn-cntr .btn.normal,.rel.pl26.mb18 .bggr,.relate-work-wrapper,.sailors-ctnr,.section-block.with-bottom-radius.a-move-in-left .invite,.section-filter,.set-copyright .copyright-select-box .copyright:hover,.shell-intro-top,.spend-recode,.sponsor-pay-dialog-v2 .sponsor-pay-content,.table-ctnr,.tag .delete,.text-ctnr,.trade-list,.trade-wrapper,.u-btn-c,.u-btn-e,.u-btn-m,.ui-radio input[type=radio]:active+.ui-radio-icon,.ui-select .ul-select-list .select-item.active,.ui-select .ul-select-list .select-item:hover,.valid_box .button.ready,.valid_box .button.ready:active,.valid_box .button.ready:hover,body #app .category-wrapper .upload-content,body #app .marquee{background-color:#444!important}.player-auxiliary-area .bui-collapse,.player-auxiliary-area .player-auxiliary-danmaku-btn-footer,.v-wrap #multi_page{border-radius:2px!important}.add-tag .edit .input-wrapper .container.active .btn-add,.infor-news .news-top,.spend-recode .title-group .selected-title,div.cntr a.check-all{background-image:none!important}#text-contribute .fixed-header,.alert-container .alert-header:after,.app-ctnr,.bl-search,.buy-vip-panel .panel-ctnr .panel-aside .aside-item .item-img-ctnr,.container .main-btn.edit-btn:hover,.el-table,.el-table--border:after,.el-table--group:after,.el-table:before,.el-table__expanded-cell,.gui-settings-box.blur,.link-footer .footer-linker .footer-linker-line,.nav-notice li,.nav-notice li.hover,.player-auxiliary-area .player-auxiliary-filter,.player-auxiliary-collapse .player-auxiliary-wraplist{background-color:transparent!important}.preview-avatar-con,.preview-title,.read-list-component .mask,.recent-danmu-wrp .danmu-filter .left .line,.ui-checkbox input[type=checkbox]:checked+.ui-checkbox-icon{background:0 0!important}ul.a-fade-in.content li:nth-child(n+41):after{background-image:linear-gradient(#2221,#222)!important}#announcement-area .news-ctnr .news-date,#announcement-area .rank-ctnr .anchor-name,#dc-section_summary .follow-tool-box .follow-line-legend .legend-item .legend-text,#edit-page .block-wrap h3.block-title span.tips,#edit-page .copyright-hint,#page .game .game-box dl a,.achievement-card-centent>.header>.state-normal,.achievement-card-centent>.text a,.achievement-user-info>.info,.activity-card dd span,.add-tag .default .placeholder,.add-tag .edit .input-wrapper .count,.add-tag .edit .tip,.agreement,.area-section .card-ctnr .tag-ctnr .tags,.article-holder .shop-card a .container .disc,.author-info-card .data-area .data-block h4,.ava-name,.ava-text,.bangumi-index-crumb ul li a,.bangumi-item .pub-info,.banner-p a,.banner-p p,.bili-pay-panel-name,.bili-pay-panel-remark,.bili-pay-text,.bili-pay-vouche-name,.bili-pay-voucher-help-disable,.bili-payment-num i,.bili-payment-txt,.bind-info .note-content p,.block-left .headline .hot-link,.canvas-card dd h4 .user-container a,.canvas-card dd h4 .user-container span,.card-more,.cards-block .cards-list .card-item .card-case .image .empty-icon p,.category li a,.cc-album-create .info-wrp p,.center-grid thead tr,.checkbox .text,.cinema-home-crumb ul li a,.comment-manage-wrap .content .action-bar .dropdown .sort-btn,.comment-manage-wrap .dropdown .dropdown-menu li,.comment-manage-wrap .head .dropdown-menu .article-list .ac-link,.comment-manage-wrap .search .fontvt,.condition-sub-title,.condition-txt,.container .subtitle,.container .tip,.content .user-protocol,.cover-upload-box .no-img,.daily-task .task-item,.daily-task .task-item .desc,.daily-task .task-item .task-status,.danmu-wrp .black-tip,.danmu-wrp .section .label .second,.danmu-wrp .section .title-tip,.danmu-wrp .section .title-tip .sub,.dc-radio-button,.dc-radio-button_inner,.editor-box p.counter,.editor-wrap .article-title .count,.el-checkbox__label,.el-date-table td.next-month,.el-date-table td.prev-month,.el-pagination.is-background .btn-next,.el-pagination.is-background .btn-prev,.el-pagination.is-background .el-pager li,.error-panel.server-error .right-panel,.face-g-list#my-g-list .face-g-block .my-mp-block .mp-info .mp-descr,.face-g-list#my-g-list .face-g-block .my-mp-block .mp-info .mp-gettime,.faq-modal .modal-wrap .modal-content .text-content p,.filter-block .filter-item-wrapper,.float-toolbar .back-top .icon-block,.float-toolbar .toolbar-list .icon-block,.footer-text .record,.footer-text p,.form-title-info,.func-banner .right-btns a,.func-banner .right-btns span,.game-groom-m .num,.history-card,.hot-list .card-ctnr .room-count,.info-item-active p,.info-item-charge p,.info-item-medal p,.info-item-total p,.link-footer .footer-img-linker .footer-img-item,.link-footer .footer-img-linker .footer-img-text,.mn-ot-l-u-icon1,.mn-ot-l-u-icon2,.more-data,.music-clue,.music-tips .music-tip,.nav-bar .sub-nav .sub-tab,.news-text .news-date,.num-tip,.official-name-info,.online-list .ebox .dlo .author,.online-list .ebox .dlo span,.order-list-wrapper .order-list .order-item .order-item-body-wrapper .order-item-body .order-item-name-wrapper .time,.orderdetail-container .orderdetail-nav .orderdetail-nav-list li.order-center,.orderdetail-container .orderdetail-wrapper p,.pagelist .flip-right span,.pager .jump-pager,.pay-activation-txt,.pay-bottom-link,.pay-other p,.pay-points-way-title,.pay-points-way-txt,.pay-result-sub-title,.preview-avatar-con:after,.preview-title:after,.project-info table .project-content .content-right p,.promote-m .headline .sub-name,.qrcode-active .qrcode-container-item .qrcode .qrstatus .qrstatus-time,.qrcode-active .qrcode-container-item .qrcode .qrstatus .qrstatus-title,.qrcode-active .qrcode-tip,.rank-active-target,.rank-fans-medal,.rank-item .content .info .detail,.rank-item .content .info .detail a,.rank-item .content .info .pts,.rank-list-head .rank_tips,.rank-menu li,.rank-tab-wrap,.rank-vedio-target,.rank-vedio-view,.read-list-component .read-list-box li .count,.read-list-component .tips,.read-list-component .tips.input-tips,.recent-danmu-wrp .danmu-filter .left .delete .option-wrp .act-btn,.recent-danmu-wrp .head .dropdown-menu .article-list li,.recent-danmu-wrp .tips,.recharge-rule,.record-ctnr,.rel.pl122.mb20 .g3,.relate-work-wrapper .work-info .bread-crumb,.relate-work-wrapper .work-info .rate-info .tip,.room-card .sub-area,.set-copyright .copyright-select-box .copyright,.song-info .info-wrap .contact-us,.song-info .info-wrap .form-item-paper-input-wrapper .form-item-paper-total,.sort-item,.spend-recode .part-common .platformType,.sponsor-pay-dialog-v2 .sp-pay-success .sponsor-pay-body .sponsor-pay-result .sponsor-pay-result-body p,.stat-banner .author-name,.stat-banner .pub-time,.stat-banner .review-summary,.sub-tab-box .item,.tag-list-wrap .tag-list .add-item .tip,.text-input .text-length,.title-module,.tool-box-v2-container .tool-title,.tool-box-v2-container .tool-xiaowan a,.tool-box-v2-container .tool-xiaowan-bilibili a,.topic-main .act-list ul li .found-time,.trade-customn .tips,.trade-wrapper>div>div,.tv-m-crumb li a,.tv-m1 .colt,.tv-m1 .com,.tv-m1 .play,.tv-m1 .time,.tv-m1 .tv-m-desc,.tv-m1 .up,.tv-m2 .colt,.tv-m2 .com,.tv-m2 .play,.tv-m2 .time,.tv-m2 .tv-m-desc,.tv-m2 .up,.tv-m3 .colt,.tv-m3 .com,.tv-m3 .play,.tv-m3 .time,.tv-m3 .tv-m-desc,.tv-m3 .up,.ui-input-textarea .count,.upload-cover-wrapper .upload-cover-tips,.upload-image .tip,.upload-txt,.upload-v2-step1-container .upload-agreement .reg-1>div a,.upload-v2-step1-container .upload-agreement .reg-2,.value-length,.video-floor-m .zone-title .headline .tags li a,.video-item-biref .biref-info .biref-title-sec,li.user-wrapper .avatar .detail .level .progress span,ul.navigation li span{color:#aaa!important}#announcement-area .rank-ctnr .cover-ctnr,#announcement-area .rank-ctnr .rank-icon,#area-anchor .area-title-link,#area-anchor .icon-play,#edit-page .btn-group.main-active-btn a.white,#edit-page .btn-group.main-active-btn button.white,#page .game .game-box h4,.achievement-card-centent>.header,.achievement-card-centent>.header>.icon,.active-main .act-list ul li .event_status,.active-main .act-list ul li h2 a,.active-main .active-title .b-active-t,.activity-card .category-tab,.activity-card dd h4,.add-tag .edit .input-wrapper .btn-add,.add-tag .edit .input-wrapper input:focus,.add-tag .edit .input-wrapper input:hover,.agree-rule .text,.alert-container .alert-content .button,.alert-container .alert-header h2,.article-holder .shop-card a .container .title,.article-wrapper .review-content,.article-wrapper .review-title,.assist-wrap .addModal .control-group,.assist-wrap .addModal .control-group>label,.assist-wrap .assist-list header h1,.assist-wrap .assist-log header h1,.author-info-card .author-info .info-right .author-name,.author-info-card .author-info .info-right .btn-attention,.author-info-card .data-area .data-block p,.balance_bp_box,.balance_bp_box .button:active,.balance_bp_box .button:hover,.bangumi-info .info-right .info-title .func-module .bangumi-btn .btn-follow,.bangumi-item .bangumi-title,.bangumi-item .cover-wrapper .corner-tag,.bangumi-item .cover-wrapper .shadow,.bangumi-list .synthetical .headline .bangumi-label,.bangumi-up-info .func-btns .b-gz,.bb_intro_box .bb_intro_info,.bb_intro_box_top .b_icon_title,.bbgr.cl.h29 .g1,.bili-pay-price,.bili-pay-uname,.bili-payment-list,.bind-info .bind-sub-title,.bind-info .note-footer .btn-group .back-btn,.bind-info .note-footer .btn-group .unable-btn,.block-area .block-left .block-header .block-title,.block-left .headline h4,.bp_user_box i,.bp_user_box_top p,.btn-sponsor-wrapper a.sponsor-btn,.bui-sns-info a,.buy-vip-panel .panel-ctnr .panel-aside .aside-item .item-label,.canvas-card dd .icon-contain .support,.canvas-card dd h3 a,.card-info,.card-name,.cards-block .cards-list .card-item .card-case .user-info span,.cards-block .radio-list .radio-item .radio-label.active,.cards-block .radio-list .radio-item .radio-label:not([disabled=disabled]),.category-wrapper .tweet-title,.category-wrapper .upload-title-text,.center-grid tbody tr,.check-warp .el-checkbox,.cl.mb20 .g1,.classify .classify-list .list-item .class-block,.comment-manage-wrap .content .action-bar .action-btn span,.comment-manage-wrap .dropdown .dropdown-btn,.comment-manage-wrap .head .search .bili-input,.comment-manage-wrap .search input,.comment-wrap header h2,.condition-btn-disable,.condition-title,.container .main-btn,.create-compilations-btn .album-flex .album-bar-btn .album-bar-btn-text,.danmu-wrp .input-group,.danmu-wrp .section .bili-input,.danmu-wrp .section .title,.dc-option,.dc-section-item_title,.dc-section-item_title_custom .sectionTitle,.drawer-card dd,.el-button--primary,.el-pagination__jump,.el-pagination__total,.el-table .el-table__header-wrapper .el-table__header .cell,.el-table .el-table__row .cell,.ellipsis,.error-manga .change-img-btn,.error-panel .rollback-btn,.face-g-list#my-g-list .face-g-block .my-mp-block .mp-info .btn,.face-g-list#my-g-list .face-g-block .my-mp-block .mp-info .btn-white,.face-g-list#my-g-list .face-g-block .my-mp-block .mp-info .title,.faq-modal .modal-wrap .modal-content .text-content h1,.fast-amount-list .item.free-amount input.ipt-free-amount,.favourite-card .other-info-ctnr>div,.filter-block .filter-name,.filter-wrapper .filter-title,.fjw-point header h2,.fjw-random header h2,.footer-box a,.func-banner .btn-dislike,.func-banner .btn-like,.game-groom-m .type-name,.game-groom-m a .title,.game-more,.header .right li.order span a,.hot-activity a,.hot-content .title,.idol-show .section-title .title,.income-info .item .info-title,.info-model header h2,.infor-label .label-date,.infor-news .news-top,.item .live-status,.link-panigation .panigation,.link-panigation .panigation.selected,.live-btn.default,.main-container .sponsor-wrapper .sponsor-right-area .sponsor-btn,.music-upload-wrapper .upload-music-bar-wrapper .pload-music-bar-btn,.nav-container .single-box .ep-item,.nav-container .single-box .ep-item:hover,.nav-notice li a,.nav-notice li.hover,.news-body .news-1 .news-text p,.news-body .news-1 i,.news_block .text-name,.official-label,.official-submit-btn-disable,.official-title,.online-list .ebox .etitle,.order-header-wrapper,.order-header-wrapper .order-header-status,.order-list-wrapper .order-list .order-item .order-item-body-wrapper .order-item-body,.order-list-wrapper .order-list .order-item .order-item-body-wrapper .order-item-body .order-item-name-wrapper .name,.order-list-wrapper .order-list .order-item .order-item-body-wrapper .order-item-btn-group .btn.canceldetail,.order-list-wrapper .order-list .order-item .order-item-body-wrapper .order-item-btn-group .btn.checkdetail,.orderdetail-container .orderdetail-status .status-text,.orderdetail-container .orderdetail-wrapper h1,.other a,.other strong,.pagelist .flip-left .active,.pagelist .flip-left span,.pagelist .flip-left span:hover,.pagelist .flip-right input,.panigation .arrow-right i,.pay-activation-btn,.pay-other-way-link,.pay-points-way-btn,.pay-points-way-btn-disable,.pay-points-way-content,.pay-result-btn,.pay-result-title,.player-auxiliary-area .player-auxiliary-filter-menu,.player-auxiliary-area .player-auxiliary-filter-title,.preview-title-line1,.project-info table .project-content .content-right h1,.project-info table th,.project-info table tr,.protocol-block,.qrcode-active .qrcode-container-item .seat-info,.qrcode-active .qrcode-container-item .seat-info span,.qrpay-group .qrpay-content .pay-tips,.rank-item .content .info .pts div,.rank-item .detail .work-name,.rank-item .num,.rank-list .canvas-card:after,.rank-list .canvas-card:nth-child(-n+3):after,.rank-list-container .more .text,.read-list-component .creat-read-list-box .input-box button,.read-list-component .creat-read-list-box .input-box button[disabled],.read-list-component .create-btn,.read-list-component .read-list-box li label .title,.recent-danmu-wrp .danmu-filter .from-wrp .bili-input,.recent-danmu-wrp .dropdown .dropdown-btn,.recharge-store-box dl.recharge-form .ipt-number,.recharge-store-box dl.recharge-form dt,.record-ctnr .area-selection-cntr .tips,.record-ctnr .areas .btn-cntr .btn,.record-ctnr .areas .btn-cntr .btn.normal,.record-ctnr .areas .btn-cntr .btn.normal:hover,.record-ctnr .areas-tip-cntr .areas-tip,.rel.pl122.mb20 .g1,.rel.pl122.mb20 .rank,.rel.pl26.mb18 .g1,.rel.pl26.mb18 .rank,.relate-work-wrapper .work-info .work-title,.relate-work-wrapper .wrapper-title,.review-reply-wrapper .review-reply-title,.rhythm-storm .bl-button:disabled,.rhythm-storm label,.sailors-ctnr,.shell-intro-top .bind-card-title,.song-info .info-wrap .album-itro,.song-info .info-wrap .album-name,.song-info .info-wrap .submit-btn,.song-info .info-wrap .title,.spend-recode .title-group .selected-title,.sponsor-pay-dialog-v2 .sp-pay-success .sponsor-pay-body .sponsor-pay-result .sponsor-pay-result-body p.sponsor-pay-result-title,.sponsor-pay-dialog-v2 .sponsor-pay-header,.submit-btn,.tabnav-tip.plain,.tag .delete,.tag .text,.tag-list-wrap .tag-list .add-item .add-control,.text-input input,.timer-wrap .timer-top h2,.title .text,.title-factory-card .title-num .num-value,.topic-main .act-list ul li h2 a,.topic-main .nav-tab li,.topic-main .topic-title .b-topic-t,.total-container div,.trade-customn input,.trade-wrapper,.tv-m1 .tv-m-tt,.u-btn-c,.u-btn-e,.u-btn-e:hover,.u-btn-m,.ui-btn.blue-radius,.ui-input-text input,.ui-select .ui-select-show-box,.ui-select .ul-select-list .select-item,.upload-v2-step1-container .video-jam .video-jam-pretext,.user-info>.tag-gray,.valid_box .button.ready,.valid_box .button.ready:active,.valid_box .button.ready:hover,.video-model header h2,.w160.h48.ovh .g1,body #app .category-wrapper .upload-content .title,ul.navigation li.activated span{color:#eee!important}#announcement-area .news-ctnr .title-row,#bp_right .bb_intro_box,#bp_right .bb_intro_box_top,#edit-page .btn-group.main-active-btn a.white,#edit-page .btn-group.main-active-btn button.white,.achievement-card,.achievement-card-centent>.header>.state-normal,.achievement-user,.achievement-user-info>.info,.active-main .act-list ul li,.active-main .active-title,.add-tag .edit .input-wrapper input,.add-tag .edit .input-wrapper input:focus,.add-tag .edit .input-wrapper input:hover,.article-holder .shop-card,.author-info-card .data-area .split-line,.b-head.online,.b-info .dividing-line,.balance_bp_box,.bangumi-info .info-right .info-title .func-module .bangumi-btn .btn-follow,.bangumi-list .synthetical .headline .bangumi-label,.banner,.bb_intro_box .bb_intro_info,.bb_intro_box_top,.bili-input,.bili-pay-header-wrapper,.bili-pay-payment-wrapper,.bili-payment-list,.bilibili-player .bilibili-player-area-separator,.bind-info,.bind-info .dividing-line,.bind-info .note-footer .btn-group .back-btn,.bind-info .note-footer .btn-group .unable-btn,.bp_user_box_top,.buy-vip-panel .panel-ctnr,.canvas-card dd .icon-contain .support,.checkbox.checked .radio-btn,.cinema-home-crumb ul li,.classify .classify-list .list-item .class-block,.comment-manage-wrap .content .action-bar .action-btn span,.comment-manage-wrap .content .check-box.checked,.comment-manage-wrap .dropdown .dropdown-btn,.comment-manage-wrap .head .dropdown-btn .text,.comment-manage-wrap .no-content,.comment-manage-wrap .search input,.container .host-list-layout .hot-list-wrap .hot-song-list,.container .main-btn,.container .main-btn.edit-btn,.container .main-btn:hover,.daily-task .task-item,.dc-select .dc-option-group,.dc-select-label,.el-button--primary,.el-table td,.el-table th.is-leaf,.face-g-list#my-g-list .face-g-block .my-mp-block .mp-info,.face-g-list#my-g-list .face-g-block .my-mp-block .mp-info .btn,.face-g-list#my-g-list .face-g-block .my-mp-block .mp-info .btn:hover,.favourite-card,.favourite-card .anchor-info,.favourite-card .other-info-ctnr .anchor-live:before,.func-banner .btn-dislike,.func-banner .btn-like,.game-groom-m,.income-info .item,.infor-body-left ul li,.link-footer .footer-img-linker .footer-img-item,.link-panigation .panigation,.mg-l.w880.cl .bbgr,.nav-container .single-box .ep-item,.nav-notice li,.nav-notice li.hover,.news-body .news-1,.official-right-float .el-upload--picture-card,.official-title-input,.online-list .ebox,.order-list-wrapper .order-list .order-item,.order-list-wrapper .order-list .order-item .order-item-body-wrapper .order-item-btn-group .btn.canceldetail,.order-list-wrapper .order-list .order-item .order-item-body-wrapper .order-item-btn-group .btn.checkdetail,.orderdetail-container .orderdetail-status,.orderdetail-container .orderdetail-wrapper .wrapper-content,.other,.pagelist .flip-left .active,.pagelist .flip-left span,.pagelist .flip-left span:hover,.pagelist .flip-right input,.pay-points-way-content,.pay-points-way-select,.payment-active,.project-info table tr,.project-info table tr:last-child,.promote-m .headline .change-push,.rank-active-target,.rank-fans-medal,.rank-item div.num,.rank-vedio-target,.rank-vedio-view,.read-list-component .creat-read-list-box .input-box,.read-list-component .creat-read-list-box .input-box button,.read-list-component hr,.recent-danmu-wrp .danmu-filter .from-wrp .bili-input,.recent-danmu-wrp .dropdown .dropdown-btn,.recharge-store-box dl.recharge-form .ipt-number,.record-ctnr,.record-ctnr .area-selection-cntr,.record-ctnr .areas,.record-ctnr .areas .btn-cntr .btn.normal,.rhythm-storm .bl-button,.sailors-ctnr,.section-filter,.set-copyright .copyright-select-box,.shell-intro-top,.song-info .info-wrap .album-itro,.song-info .info-wrap .album-name,.spend-recode,.spend-recode .part-common .platformType,.sponsor-pay-dialog-v2 .sp-pay-success .sponsor-pay-msg,.text-input input,.title-factory-card .title-num .num-value.num-input,.topic-main .act-list ul li,.topic-main .nav-tab,.trade-list,.tv-m1 .tv-m-con,.u-btn-c,.u-btn-e,.u-btn-m,.ui-btn.sub-btn,.ui-btn.white,.ui-input-textarea,.ui-radio .ui-radio-icon,.ui-radio.active .ui-radio-icon,.ui-select.white .ui-select-show-box,.upload-image,.valid_box .button,.valid_box .button.ready,.valid_box .button.ready:active,.valid_box .button.ready:hover{border-color:transparent!important}.area-section .card-ctnr .tag-ctnr .tags,.banner-p a,.el-date-table th,.face-g-list#my-g-list .face-g-block .my-mp-block,.fjw-random .point-wrap .cnt,.fjw-random .point-wrap .cnt .list,.recharge-store-box ul.select-list .item,.set-copyright .copyright-icon .icon-none-copyright,.trade-wrapper,.ui-input,.user-info>.tag-gray{border-color:#aaa!important}#BilibiliVipDialog{border:none!important}.block-left.block-brand .headline .tab-wrap .pgc-brand-tab,.footer-logo,.icon-arrow-r,.mainmenu ul.grid li a.yxzx,.more-data i,.play-btn .icon-play,.qrcode-active .qrcode-active-slider .close-btn .close-btn-bg,.u-btn-e i,.u-btn-m i{filter:brightness(0) invert(1)!important}.infor-load-more{filter:invert(.75)!important}.bb_intro_box_top .b_question .b_question_icon{filter:brightness(.5) contrast(3)!important}.float-toolbar .back-top .icon-block.icon-back-top,.float-toolbar .toolbar-list .icon-block.icon-feedback,.float-toolbar .toolbar-list .icon-block.icon-help,.icon-slide-h,.icon-sort3-on,.on.u-btn-s3,.recharge-store-box ul.select-list .item.active:after,.timer-wrap .vote-dialog-new .main .checkbox,.timer-wrap .vote-dialog-new .main .main-txt-1 label .selected,.title-factory-card.selected:after,.u-btn-s3:hover{filter:var(--blue-image-filter)!important}.add-tag .default .btn-show,.article-holder .shop-card a .container .bottom-col .card-label,.episode-item .mark-icon,.project-info table .project-content .content-right .ticket-type span{filter:var(--pink-image-filter)!important}#edit-page,.orderdetail-container .orderdetail-content{box-shadow:none!important}div.cntr a.check-all{box-shadow:0 1px 10px 0 var(--theme-color-30)!important}.icon-home,.icon-hot,.icon-new{display:none!important}#page .game .game-box h4 span,.act.tv-u-btn-t,.area-section .card-ctnr .tag-ctnr .tags:hover,.author-info-card .author-info .info-right .btn-attention,.balance_bp_box .button,.bangumi-up-info .func-btns .b-gz,.banner-p a:hover,.banner-p h3,.bili-pay-panel-list-active,.blink-border.blue,.classify .classify-list .list-item .class-block:hover,.dc-radio-button.is-active,.dc-radio-button.is-active:after,.func-banner .btn-dislike.active,.func-banner .btn-dislike:hover,.func-banner .btn-like.active,.func-banner .btn-like:hover,.invite-code .copy-btn,.rank-menu li.active,.recharge-store-box ul.select-list .item.active,.recharge-store-box ul.select-list .item:hover,.record-ctnr .areas .all-area.checked,.sort-item.on i.active,.swiper-pagination-custom,.tabs-nav .active,.title-factory-card.selected,.trade-wrapper.is-selected,.ui-checkbox input[type=checkbox]:checked+.ui-checkbox-icon,.ui-radio input[type=radio]:hover+.ui-radio-icon,.ui-radio.active .ui-radio-icon,.ui-tabs .ui-tabs-head .tab-head-item.current a,.ui-tabs .ui-tabs-head .tab-head-item.current a:after,body #app .marquee{border-color:var(--theme-color)!important}#announcement-area .rank-ctnr .rank-icon.hot,.add-tag .default .btn-show,.alert-container .alert-content .button,.author-info-card .author-info .info-right .btn-attention,.balance_bp_box .button,.balance_bp_box .button:active,.balance_bp_box .button:hover,.bangumi-info .info-right .info-title .func-module .bangumi-btn .btn-follow,.bangumi-item .cover-wrapper .corner-tag.badge_0,.bangumi-up-info .func-btns .b-gz,.bili-header-m .bubble-traditional .renew-btn button,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-info .bilibili-player-setting-menu-wrap .bilibili-player-setting-menu-list .active-point,.btn-sponsor-wrapper a.sponsor-btn,.checkbox.checked .radio-btn:before,.comment-manage-wrap .content .check-box.checked,.error-manga .change-img-btn,.error-panel .rollback-btn,.face-g-list#my-g-list .face-g-block .my-mp-block .mp-info .btn,.face-g-list#my-g-list .face-g-block .my-mp-block .mp-info .btn:hover,.item .live-status.on,.link-panigation .panigation.selected,.live-btn.default,.live-btn.default:active,.live-btn.default:hover,.main-container .sponsor-wrapper .sponsor-right-area .sponsor-btn,.nav-bar .nav-wrapper .slide-block,.nav-container .single-box .ep-item:hover,.news-body .news-1 i,.pagelist .flip-left .active,.pagelist .flip-left span:hover,.pay-activation-btn,.pay-activation-btn:hover,.pay-other-way-link,.pay-other-way-link:hover,.pay-points-way-btn,.pay-result-btn,.promote-m .headline .change-push:hover,.read-list-component .creat-read-list-box .input-box button,.record-ctnr .areas .btn-cntr .btn.normal:hover,.record-ctnr .areas .btn-cntr .btn:hover,.rel.pl122.mb20 .bgre,.rhythm-storm .bl-button,.song-info .info-wrap .submit-btn,.tabnav-tip.plain,.u-btn-e:hover,.ui-btn.blue-radius,.ui-radio input[type=radio]:checked+.ui-radio-icon:after,body #app .category-wrapper .dot,div.cntr a.check-all,ul.navigation li:after{background-color:var(--theme-color)!important}.page-title .count,.pay-result-btn:hover,.valid_box .button{background:var(--theme-color)!important}#area-anchor .area-title-link:hover,#page .game .game-box dl a:hover,#page .game .game-box dl dt,.achievement-card-centent>.header>.state-normal.-success,.achievement-user-info>.a,.act.tv-u-btn-t,.active-main .act-list ul li .event_status .status-ing,.active-main .act-list ul li h2 a:hover,.activity-card dd h4 a:hover,.agree-rule .rule,.agreement a,.area-section .card-ctnr .tag-ctnr .tags:hover,.article-holder .shop-card a .container .bottom-col,.balance,.bangumi-index-crumb ul li.on a,.bangumi-index-crumb ul li:hover a,.bangumi-item .bangumi-title:hover,.banner .slides-pagination li a:hover,.banner-p a:hover,.bb_intro_box_top .b_question .b_question_title:hover,.bbgr.cl.h29 .g1:hover,.bili-pay-panel-list-active .bili-pay-price,.bili-payment-num,.bind-info .bind-sec-title,.bind-info .note-content a,.bind-info .note-footer .agree-group .submit-deal,.blink-border.blue,.blink.blue,.block-left .headline .hot-link:hover,.btn-recharge-bcoin,.canvas-card dd h4 .user-container a:hover,.card-more a,.category li a:hover,.center-grid td a:hover,.center-grid th a:hover,.check-warp a,.cinema-home-crumb ul li.on a,.cinema-home-crumb ul li:hover a,.cl.mb20 .g1:hover,.classify .classify-list .list-item .class-block:hover,.classify .position span,.comment-manage-wrap .content .action-bar .dropdown .sort-btn:hover,.comment-manage-wrap .dropdown .dropdown-menu .selected,.container .main-btn.edit-btn,.container .main-btn:hover,.content .user-protocol a,.dc-option:hover,.dc-radio-button.is-active,.drawer-card li a:hover dd,.faq-modal .modal-wrap .modal-content .text-content a,.faq-modal .modal-wrap .modal-content .text-content a:active,.faq-modal .modal-wrap .modal-content .text-content a:hover,.favourite-card .other-info-ctnr>div .anchor-status.on-live,.filter-block .filter-item-wrapper .filter-item.on,.footer-box .footer-text a:hover,.func-banner .btn-dislike.active,.func-banner .btn-dislike:hover,.func-banner .btn-like.active,.func-banner .btn-like:hover,.func-banner .right-btns a:hover,.func-banner .right-btns span:hover,.game-groom-box-m .game-groom-m:hover .title,.hot-activity a:hover,.idol-show .section-title .title:hover,.income-info .item.left .value,.income-info .item.right .value,.instructions,.invite-code .code,.invite-code .copy-btn,.link-panigation .panigation:hover,.link-panigation .panigation:not(.selected):hover,.music-clue .font-blue,.music-clue .iconfont,.music-tips .music-tip:hover,.nav-bar .nav-wrapper .main-tab:hover,.nav-bar .sub-nav .sub-tab.active,.news-body .news-1 .news-text:hover .n-text,.online-list .ebox .dlo .author:hover,.online-list .ebox a:hover .etitle,.online-list .ebox:hover .ol b,.orderdetail-container .orderdetail-status h1,.panigation .arrow-right:hover i,.pay-points-way-next,.player-auxiliary-area .player-auxiliary-filter-menu:hover,.project-info table .project-content .content-right .ticket-type,.project-info table .project-content .content-right h1:hover,.project-info table td.total,.project-list .project-list-item .project-list-item-detail .project-list-item-price,.protocol-block a,.protocol-block a:hover,.qrpay-group .qrpay-content .price,.rank-item .detail .work-name:hover,.rank-menu li.active,.rank-tab-wrap .rank-tab .active,.recharge-rule a,.recharge-store-box ul.select-list .item.active,.recharge-store-box ul.select-list .item:hover,.record-ctnr .areas .all-area.checked,.rel.pl122.mb20 .g1:hover,.rel.pl26.mb18 .g1:hover,.relate-work-wrapper .work-info .go-play,.selector-wrapper .city-list .li-more span:hover,.selector-wrapper .order-list .li-more span:hover,.selector-wrapper .type-list .current-type span.active,.selector-wrapper .type-list li:hover,.set-copyright .copyright-select-box .copyright.selected .text,.set-copyright .copyright-select-box .copyright:hover .text,.sort-item.on,.spend-recode .title-group .recode-title,.sub-tab-box .item.active,.swiper-pagination-custom,.task-info .task-bar .status-icon.active,.title-factory-card .title-num .ajust-btn,.title-factory-card .title-num .num-value,.tool-box-v2-container .tool-xiaowan a:hover,.tool-box-v2-container .tool-xiaowan-bilibili a:hover,.topic-main .nav-tab .on,.total-container div span.total,.trade-wrapper.is-selected,.tv-m-crumb li a:hover,.tv-m1 .tv-m-tt:hover,.ui-checkbox input[type=checkbox]:checked+.ui-checkbox-icon,.ui-select .ul-select-list .select-item.active,.ui-select .ul-select-list .select-item:hover,.ui-tabs .ui-tabs-head .tab-head-item.current a,.upload-tips,.video-floor-m .zone-title .headline .tags li a:hover,.w160.h48.ovh .g1:hover,body #app .category-wrapper .upload-tip,body #app .marquee a,ul.navigation li:hover{color:var(--theme-color)!important}.bili-header-m .bubble-traditional .renew-btn button,.rhythm-storm .bl-button,.valid_box .button,div.cntr a.check-all{color:var(--foreground-color)!important}#edit-page .block-hr,#page .game .game-box,.comment-manage-wrap .head .dropdown-menu .article-list{border-top-color:transparent!important;border-bottom-color:transparent!important}#page .game .game-box-1,#page .game .game-box-3,.bili-pay-payment-nav,.bili-payment-list-border,.bili-tab.current:after,.dc-radio-button.is-active:after,.footer-logo,.game-box-all,.season-item.on:after,.ui-tabs .ui-tabs-head .tab-head-item.current a:after{border-left-color:transparent!important;border-right-color:transparent!important}#app .player-box,#i_menu_msg_btn #dyn_wnd,.album-content .my-album .link-panigation .panigation,.album-popup .album-pop-bottom ul li.disable,.album-popup .album-pop-bottom ul li.disable:hover,.album-radio::before,.attention-live .switch-btn:active,.attention-live .switch-btn:hover,.bili-wrapper.clearfix .up-info-m,.biliPager .pager-jumper .pager-jumper-input,.biliPager .pager-jumper a,.black-list .black-btn,.bui-container .gift-all,.bui-container .gift-recommend,.cc-article-wrp .article-card .meta-view .appeal,.cc-article-wrp .article-card .meta-view .data,.cc-article-wrp .article-card .meta-view .delete,.cc-article-wrp .article-card .meta-view .option,.cc-body .setting,.channel-menu,.col-4-med.col-4 .song-change,.collapse-subitem--active,.comment-list-item .ci-action a:hover,.comment-manage-wrap .content .action-bar .dropdown .action-menu li:hover,.comment-manage-wrap .content .action-bar .dropdown .sort-menu li:hover,.common-modal-container .common-modal-content .common-modal-foot>div div:nth-child(2),.d-buttons .d-button,.d-buttons .d-state-highlight,.drop-cascader-container .drop-cascader-list-wrp .drop-cascader-list-item:hover,.drop-cascader-container .drop-cascader-pre-wrp .drop-cascader-pre-item:hover,.drop-list-v2-container .drop-list-v2-item:hover,.dropdown__content .dropdown__active,.dropdown__content .dropdown__item:hover,.el-input-group__append,.el-input-group__prepend,.elecrank-wrapper .elecrank-content .rank-item .item-num,.elecrank-wrapper .elecrank-content .rank-item .msg,.face-buy-footer .btn-mk2.primary,.face-g-list .mp-block .right ul li .mp-tips,.fjw-kpi-wrap,.groom-box-m.clearfix .groom-module .type-name,.hash-popup .topic-container .item.is-selected,.home-index .even,.home-index .odd,.invtable tr:nth-child(odd) td,.layout .layout-main .main-footer,.live-btn.default,.log-list li.log-item,.main-c .main-b .main-b-l .convert,.media-tab-module-wrp .media-tab-module-content .sl-ep-nav .slider-contro span,.media-tab-module-wrp .media-tab-module-content .sl-ep-nav .slider-contro span.disabled,.mini-progress,.mini-wnd,.mobile-kpi-head h2,.multi-page .cur-list .module-box li,.nameplate-card,.nav-item2 .nav-item2-title:hover,.nav-item3.active,.nav-item3:hover,.new_list .vd_list li.l1,.p-relative.gold-seed-store.over-hidden .content,.panel-block input,.player-limit-wrap .limit_not_start_wrap .not_start_btn .follow:hover,.popup-btn .btn-default,.privilege-box-right-btn,.stm-lst-item .share,.stm-ly .ct .stm-filter li.on,.stm-ly .sd-l a:hover,.tab-selector-wrap .tag-wrap .tag span,.tab-selector-wrap .tag-wrap .tag span.selected,.time-picker-v2-container .time-picker-body-wrp .time-picker-panel-select-wrp .time-picker-panel-select-item:hover,.title-factory-card,.title-list .title-list-item:hover .tips,.video-toolbar-module .share-box .share-popup .share-address ul li input,.widescreen .footer,.widescreen.footer .footer-box,.works-ctnr .header-ctnr .works-count{background-color:#222!important}#dyn_wnd .wnd_bottom a.btn-article-more,#dyn_wnd .wnd_bottom a.btn-ignore-all,#dyn_wnd .wnd_bottom a.btn-live-more,#dyn_wnd .wnd_bottom a.read-more,#newsDetail .news-detail-content,#newsList #list,.album-popup,.alert-v2-container-info,.anime-expo-container,.app-ctnr .live-helper .main-content,.app-ctnr .live-helper .main-content .anchor li,.app-download .qr-code-box .div.box,.article-data-wrp .video-box,.article-header .filter-wrp .article-type,.article-header .filter-wrp .article-type .bili-btn,.article-header .filter-wrp .filter-article-type,.article-header .filter-wrp .filter-article-type .bili-btn,.article-header .filter-wrp .filter-level,.article-header .filter-wrp .filter-level .bili-btn,.article-net-charts .area,.article-net-charts .content-box,.b-page-body .container-body .pagelistbox .p,.bangumi-collection-card .bangumi-funcs .btn-unfollow li:hover,.bangumi-detail .detail-evaluate p i,.bangumi-detail .detail-evaluate p i:before,.bili-wrapper .del-log-content,.bili-wrapper .online-list .ebox,.bili-wrapper .online-list .ebox .ol,.btn-primary,.cc-article-wrp .article-card,.channel-menu .box a:hover,.check-radio-v2-2-container,.clearfix .multi-page .item,.code-content,.col-full.clearfix .album-content .my-album .pagination,.comment-container,.comment-container .main-desc .goods-info,.comment-manage-wrap .content,.common-modal-container .common-modal-content,.content-tag-v2-container .content-tag-v2-edit-mod-wrp,.content-tag-v2-container .content-tag-v2-other-tag-error-wrp,.cover-v2-container .cover-v2-detail-wrp .cover-v2-selector .cover-v2-selector-items .selector-item,.d-outer.d-state-lock.d-state-visible.d-state-focus .d-outer,.d-time-v2-container .d-time-v2-date-picker-wrp .date-picker-date-wrp .date-picker-date,.d-time-v2-container .d-time-v2-date-picker-wrp .date-picker-date-wrp .date-picker-timer,.date-picker-v2-container,.dc-button.dc-button-text,.dc-progress-bar,.detail-box-wrap .content-box .video-model,.drawer-pop-ctn.pop-ctn-4 .drawer-pop,.drop-cascader-container,.drop-list-v2-container,.dropdown__content,.elecrank-header .name,.elecrank-wrapper .elecrank-content,.elecrank-wrapper.report-wrap-module.report-scroll-module .elecrank-header,.face-buy-header,.face-buy-step,.file-list-v2-container .file-add-btn,.file-list-v2-wrp .file-list-v2-item .file-list-v2-item-wrp .item-upload-progress,.fixed-nav-m .go-top,.fixed-nav-m .mini,.fjw-kpi-wrap .fjw-kpi-foot .fjw-kpi-presents,.fjw-kpi-wrap .fjw-kpi-mid .fjw-grade-wrap,.fjw-kpi-wrap .fjw-kpi-top,.gift-all .gift-box,.gift-recommend .gift-box .info,.goods-container,.guide .trynew-btn a,.h-none-btn,.head .dropdown-btn,.head .dropdown.open .dropdown-btn,.help-box,.help-list,.hot-goods-container,.infor-body .news-contents,.input-box-v2-1-container,.invitation-record-warp .invtable .inputdone,.invtable .codedone,.ivu-form-item-error .ivu-input-group-append,.ivu-form-item-error .ivu-input-group-prepend,.ivu-input-costom-width .ivu-input-wrapper .ivu-input-wrapper-default .ivu-input-type .ivu-input,.label-item-v2-2-container,.list.main_body .right_box .select_box .select .option_block .option:hover,.live-haruna .tab-body .item,.mask .popup-box,.media-tab-content .nav-tools .tool-item,.mini-wnd .play-all,.mini-wnd .read-all,.mycollect-info .mycollect-li.even,.mycollect-info .mycollect-li.odd,.nav-item1 .nav-item1-title,.nav-item2 .nav-item2-title,.nav-warp2 .nav-item3,.normal-v2-container .normal-title-wrp>.template-op,.pagelistbox clearfix .pagelistbox .p,.pager .jump-pager input[type=number],.pagination-container li.pagination-input-wrap .pagination-input,.privacy-panel,.privacy-panel-other,.privilege-box.clearfix .privilege-box-right,.privilege-warp .privilege-content-warp,.r-con .mobile-link-l,.right-action-ctnr.pointer.dp-i-block.primary.btn.p-relative .btn.primary,.s-paging .jump-to-page input[type=text],.s-paging>ul>a,.s-paging>ul>a.disabled,.s-paging>ul>a:not(.disabled):not(.current):not(a):hover,.s-paging>ul>span,.s-paging>ul>span.disabled,.s-paging>ul>span:not(.disabled):not(.current):not(a):hover,.scroll-container .main .article-container,.security-right .sr-b .box-inner,.select-box-v2-container .select-box-v2-controller,.share-addr-item .share-addr-wrapper,.song-complain-bg .song-complain,.stm-ly .stm-lst,.stm-ly .stm-lst li,.stm-ly .usr,.stm-ly .usr .info,.stm-ly .usr .status,.stm-ly>.ct,.stm-ly>.sd>.sec,.sub-nav-m.report-wrap-module .sub-nav-m .tips,.submit-button-group-v2-container .submit-btn-group-tpl,.tab-selector-wrap,.tag-modal,.tags-box .tag,.template-list-small-container,.time-picker-v2-container,.title-item,.video-toolbar-module,.video-toolbar-module .app-download .qr-code-box,.video-toolbar-module .app-download:after,.video-toolbar-module .app-download:hover,.video-toolbar-module .share-box .share-popup,.video-toolbar-module .share-box:after,.video-toolbar-module .share-box:hover,.videoCharts .stat .stat-wrp{background-color:#444!important}.album-radio.active::before,.album-radio::before,.attention-live .switch-btn:active,.attention-live .switch-btn:hover,.bangumi-collection-wrap .bangumi-collection,.bangumi-collection-wrap .bangumi-collection-d,.bangumi-collection-wrap .bangumi-order,.bangumi-collection-wrap .bangumi-order-d,.bangumi-order-wrap .bangumi-collection,.bangumi-order-wrap .bangumi-collection-d,.bangumi-order-wrap .bangumi-order,.bangumi-order-wrap .bangumi-order-d,.elecrank-header .rank-tab .arr-up,.elecrank-wrapper .elecrank-content .rank-item .msg .arrow,.gift-recommend .gift-box .hover-bg,.home-wrap .home-input .type.selected,.home-wrap .home-input .type:hover,.live-haruna .section-stage .stage-wrap,.nameplate-card .nameplate-arrow,.sr-record a.on,.sub-nav-m .tips .t-arrow,.tabs-nav .active{background-image:none!important}#app .player-box .multi-page,#app-news .comment-area,#page-subs .content,.album-report-ctn.ps.ps--active-y .ps__rail-x:focus,.album-report-ctn.ps.ps--active-y .ps__rail-x:hover,.album-report-ctn.ps.ps--active-y .ps__rail-y:focus,.album-report-ctn.ps.ps--active-y .ps__rail-y:hover,.biliPager .page-li,.cover-chop-modal-v2-body .cover-chop-modal-v2-body-split,.help-subcontent p,.my-album .line{background-color:transparent!important}.article-header .filter-wrp .article-type .line,.article-header .filter-wrp .filter-article-type .line,.article-header .filter-wrp .filter-level .line,.border-line,.setting .follow-setting .follow-wrp .follow-modal{background:0 0!important}#dyn_wnd .dyn_list li.loading,#page-fav .fav-main .fav-action-top .clearing-invalid-video,#page-fav .fav-main .fav-video-list .article-item .article-meta .meta-item,#page-fav .fav-main .fav-video-list.topic-list .large-item .desc,#page-fav .fav-main .fav-video-list.topic-list .large-item .pubdate,#page-fav .fav-main .filter-item.search ::-webkit-input-placeholder,#page-fav .search-empty-hint p,#page-follows .modal-container .content-tip,#page-index .col-2 .section .auth-detail,.add-cover,.album-report .tip,.announcement-cntr .tips,.article-data-wrp .menu-wrp .menu-tips,.article-holder .color-gray-03,.article-holder figcaption,.bangumi-detail .detail-evaluate,.bangumi-detail .detail-evaluate p.static,.bangumi-detail .detail-info,.biliPager .pager-jumper,.black-info .black-time,.btn-sponsor-wrapper .sponsor-count,.card-user,.cc-article-wrp .article-card .meta-title .typename,.cc-article-wrp .article-card .meta-view .appeal,.cc-article-wrp .article-card .meta-view .data,.cc-article-wrp .article-card .meta-view .delete,.cc-article-wrp .article-card .meta-view .option,.channel-menu .box .count,.comment-container .main-desc .comment-info .word-container .bottom .personal-info .nickname,.content-tag-v2-container .content-tag-v2-other-wrp .content-tag-v2-mission-tag-wrp .content-tag-v2-mission-tag-tip,.cover-chop-modal-v2-body .cover-chop-modal-v2-body-left .cover-chop-clip-reset-v2>span,.cover-chop-modal-v2-body .cover-chop-modal-v2-body-left .cover-chop-clip-warning-v2>span.chop-warning-normal,.cover-chop-modal-v2-body .cover-chop-modal-v2-body-right>p,.cover-v2-container .cover-v2-detail-wrp .cover-v2-selector .cover-v2-selector-title,.cover-v2-container .cover-v2-detail-wrp .cover-v2-selector .cover-v2-selector-title-more,.creation-li .creation-right .creation-publish,.date-picker-v2-container .date-picker-v2-body-wrp .date-wrp .date-item-disabled,.date-picker-v2-container .date-picker-v2-body-wrp .weekend-wrp .date-item-disabled,.date-picker-v2-container .date-picker-v2-nav-wrp .next-btn-day,.date-picker-v2-container .date-picker-v2-nav-wrp .next-btn-month,.date-picker-v2-container .date-picker-v2-nav-wrp .prev-btn-day,.date-picker-v2-container .date-picker-v2-nav-wrp .prev-btn-month,.del-log-content .del-log-header .block,.del-log-content .log-statictic,.edit-button>span,.elecrank-header .rank-tab,.elecrank-wrapper .elecrank-content.no-list .desc,.file-list-v2-container .file-title p,.file-list-v2-wrp .file-list-v2-item .file-list-v2-item-wrp .item-upload-info,.fjw-kpi-wrap .fjw-kpi-top .fjw-person-detail label.fjw-person-item,.footer-box .footer-text p,.footer-box a,.footer-text .record,.gift-all .gift-box .info .price-box .price-old,.gift-all .gift-box .info p,.gift-recommend .gift-box .info .price-box .price-old,.h .report-popup-tip,.h-none-msg,.help-footer-warp .foot_title,.help-footer-warp p,.invitation-subtitle,.item .brief-desc,.left-nav-childed-list,.list.main_body .list_box .block .info .text,.list.main_body .right_box .select_box .select .option_block .option,.live-haruna,.main-container .sponsor-wrapper .sponsor-right-area .sponsor-count-info,.main-footer .cp,.main-footer .link-item a,.main_body .future .future_list .future_block .info .loca,.more-selector-v2-container .more-selector-v2-title-wrp .more-selector-v2-drop-tip,.my-album .album-count,.my-album .error .text,.my-room.room-info .room-info-ctnr .san-num,.my-room.room-info .room-info-ctnr .timing-num,.mycollect-info .mycollect-li .song-title .song-float,.mycollect-padding .mycollect-publish,.mycollect-theme span,.new_list .vd_list li .up,.new_list .vd_list li .w_info i,.newlist_info.clearfix .b-head .b-head-s,.no-data-voucher,.notice .blink,.notice-ctnr .blink,.page_body .page_box .block .info .text,.play-num,.pop-live .pl__user,.privacy-panel .tip,.privilege-box-right-title .privilege-subtitle,.qrcode-box .tip,.record-ctnr .summary .s-item .title,.report-reason-pic-row .report-pic-description,.room-introduction-content.empty,.s_tag .btn-view-tag,.s_tag .btn-view-tag a,.sap-use-view,.section-title-v2-container .section-title-v2-content-sub,.security-right .vip-help p,.setting .follow-setting .follow-wrp .follow-modal .follow-show p,.share-qr-hint,.similar-song-menu .similar-right .song-num,.song-li .song-right .song-right-bottom .song-num,.sponsor-pay-dialog-v2 .sp-quick-pay .sponsor-pay-body .sponsor-control-group label,.sponsor-pay-dialog-v2 .sp-quick-pay .sponsor-pay-body .sponsor-control-group span,.stm-ly .sd-l a,.stm-ly .stm-lst .hint,.tab-selector-wrap .tag-wrap .tag span,.text-area-box-v2-container .text-area-box-v2-max-tip,.title-item,.type-rank-item-label,.up-info-m .number,.video-desc-m .reprint,.video-info-m .tm-info,.video-info-m .tm-info .btn-appeal,.video-info-m .tm-info a,.video-info-m .tm-info time,.video-toolbar-module .app-download .qr-code-box .box .txt,.video-toolbar-module .btn-item .num,.video-toolbar-module .share-box .s-text .num,.vippendant-descript,.viptable .history-remark,.voucher-bottom-txt,.voucher-left-money,.voucher-left-money:before,.voucher-left-txt,.voucher-right-condition,.voucher-right-order,.voucher-right-time,.water-mark-set-v2-copy-switch-wrp a,.widescreen .footer,.year-vip-user .vippendant-title,li.log-item .user-time{color:#aaa!important}#dc-section_summary .source-rank-list-item .video-info-title a,#dyn_wnd .dyn_menu,#fixnav_report .fixed-nav-m .mini,#fixnav_report .fixed-nav-m .mini:hover,#gameCenter .hot-list .s-imgUnit .rank.gray,#gameCenter .look-around .s-imgUnit .s-imgUnit-text,#page-follows .modal-container .content-text,#viewbox_report.video-info-m h1,.about-index .about-desc,.academy-left-name,.academy-right-link,.album-popup .album-pop-bottom ul li.disable,.album-popup .album-pop-bottom ul li.disable:hover,.album-popup .album-pop-bottom ul li.normal,.album-popup .album-pop-bottom ul li:hover,.album-report .report-title,.alert-v2-container-info div.alert-v2-btn:nth-child(2),.anime-expo-container .head .title,.app-ctnr .live-helper .main-content .anchor li,.app-ctnr .live-helper .main-content .menu-item .menu-title,.app-ctnr .live-helper .main-content .menu-item .menu-txt,.app-ctnr .live-helper .main-content .menu-item .menu-txt .download .down-item a:hover,.article-container .head .title,.article-header .dropdown-btn,.article-header .dropdown-btn .icon-ic_unfold,.article-header .dropdown-btn .icon-text,.article-header .filter-wrp .article-bread .main,.article-header .filter-wrp .article-type .bili-btn,.article-header .filter-wrp .category-wrp,.article-header .filter-wrp .filter-article-type .bili-btn,.article-header .filter-wrp .filter-level .bili-btn,.article-header .filter-wrp .order-wrp,.article-holder .ticket-card a .container .title,.bangumi-collection-card .bangumi-funcs .btn-unfollow li:hover,.bangumi-detail .detail-evaluate p i,.big-history-title,.big-user-name,.biliPager .current span,.biliPager .pager-jumper .pager-jumper-input,.biliPager .pager-jumper a,.biliPager .pager-jumper a:hover,.bind-info .note-footer .btn-group .active-btn,.black-info .black-name,.black-list .black-btn,.black-list .black-btn:hover,.bp_user_box .bp_user_box_bb,.bp_user_box .bp_user_box_bk,.btn-primary,.bui-content .g-title .btn,.bui-content .g-title .btn:hover,.bui-content .g-title h4,.c-top .name-top1,.card-txt,.categories-bar .tag-item,.cc-article-wrp .article-header .search-wrp input,.channel-menu .box a,.check-box-v2-container .check-box-v2-content,.check-radio-v2-container .check-radio-v2-name,.choices .album-radio,.clearfix .multi-page .item,.clearfix .multi-page .item.on,.clearfix .multi-page .item:hover,.code-btn,.coin-operated-m .coin-bottom .coin-btn,.coin-operated-m .like-checkbox,.col-4-med.col-4 .song-change,.collapse-item a,.collapse-subitem--active a,.comment-container .head .title,.common-modal-container .common-modal-content .common-modal-foot>div div:first-child,.common-modal-container .common-modal-content .common-modal-foot>div div:nth-child(2),.common-modal-container .common-modal-content .common-modal-foot>div div:nth-child(2):hover,.content-tag-v2-container .content-tag-v2-edit-mod-wrp,.content-tag-v2-container .content-tag-v2-other-tag-error-wrp,.creation-title,.d-buttons .d-button,.d-buttons .d-button:hover,.d-buttons .d-state-highlight,.d-buttons .d-state-highlight:active,.d-buttons .d-state-highlight:hover,.d-header .d-titleBar .d-title,.d-time-v2-container .d-time-v2-date-picker-wrp .date-picker-date-wrp .date-picker-date,.d-time-v2-container .d-time-v2-date-picker-wrp .date-picker-date-wrp .date-picker-timer,.d-time-v2-container .d-time-v2-switch-wrp p.d-time-v2-last,.d-time-v2-container .d-time-v2-switch-wrp p.d-time-v2-pre,.date-picker-v2-container .date-picker-v2-body-wrp .date-wrp .date-item,.date-picker-v2-container .date-picker-v2-body-wrp .date-wrp .date-item-selected,.date-picker-v2-container .date-picker-v2-body-wrp .date-wrp .weekend-item,.date-picker-v2-container .date-picker-v2-body-wrp .weekend-wrp .date-item,.date-picker-v2-container .date-picker-v2-body-wrp .weekend-wrp .date-item-selected,.date-picker-v2-container .date-picker-v2-body-wrp .weekend-wrp .weekend-item,.date-picker-v2-container .date-picker-v2-nav-wrp p.date-picker-nav-title,.dc-button.dc-button-text,.dc-button.dc-button-text a,.dc-button.dc-button-text:hover,.details-list-t div,.details-up-name a,.drop-cascader-container .drop-cascader-list-wrp .drop-cascader-list-item p.item-main,.drop-cascader-container .drop-cascader-pre-wrp .drop-cascader-pre-item .pre-item-content,.drop-list-v2-container .drop-list-v2-item .drop-list-v2-item-cont p.item-cont-main,.drop-menu-item,.dropdown__content .dropdown__item,.el-input-group__append,.el-input-group__prepend,.elecrank-header .title,.elecrank-wrapper .elecrank-content .rank-item .item-num,.elecrank-wrapper .elecrank-content .rank-item .msg,.elecrank-wrapper .elecrank-content.no-list .elec-btn,.elecrank-wrapper.no .elecrank-header.no-list .total-txt,.electron-set-v2-container .electron-set-v2-copy-switch-wrp .electron-set-v2-hint,.face-buy-footer .btn-mk2.primary,.face-buy-name,.face-g-list .mp-block .right ul li .mp-tips,.face-g-list .mp-block .right ul li .mp-tips .btn,.file-list-v2-container .file-add-btn,.file-list-v2-wrp .file-list-v2-item .file-list-v2-item-icon,.file-list-v2-wrp .file-list-v2-item .file-list-v2-item-wrp .item-status-wrp .item-status-op,.file-list-v2-wrp .file-list-v2-item .file-list-v2-item-wrp .item-status-wrp p.item-title,.fjw-kpi-wrap .fjw-kpi-foot .fjw-kpi-presents .kpi-presents-item .present-text,.fjw-kpi-wrap .fjw-kpi-mid .fjw-grade-wrap .fjw-grade .fjw-grade-text,.fjw-kpi-wrap .fjw-kpi-mid .fjw-grade-wrap .fjw-progress-title .description,.fjw-kpi-wrap .fjw-kpi-top .fjw-person-detail label.fjw-person-item .fjw-name,.fjw-kpi-wrap h2.fjw-kpi-h2,.gift-all .gift-box .info h5,.gift-all .gift-box:hover .info .btn,.gift-all .gift-box:hover .info h5,.gift-all .gift-box:hover .info p,.gift-recommend .gift-box .hover-bg .depict,.gift-recommend .gift-box .info h5,.go-back-link,.groom-box-m.clearfix .groom-module .type-name,.guide .trynew-btn a,.h .report-popup-item-text,.h-none-btn,.h-none-btn:hover,.head .dropdown-menu .search .bili-input,.help-subindex,.help-subtitle,.home-top-msg-name,.info-line a,.infor-body-left .news-contents .c-text,.input-box-v2-1-container .input-box-v2-1-instance .input-box-v2-1-val,.invitation-title,.invtable .codedone,.item .title-wrap,.ivu-btn-primary.active,.ivu-btn-primary:active,.ivu-btn-primary:hover,.ivu-form .ivu-form-item-label,.ivu-input-costom-width .ivu-input-wrapper .ivu-input-wrapper-default .ivu-input-type .ivu-input,.ivu-input-group-append,.ivu-input-group-prepend,.label-item-v2-2-container,.label-item-v2-2-container-selected,.left-nav-item,.left-nav-item .icon,.left-nav-item-child,.left-nav-wrapper .advice-btn,.list-wrap.hot-forum-lft-con .s-imgUnit a,.list.main_body .list_box .block .info .title,.list.main_body .right_box .select_box .select .title,.live-btn,.live-btn.default,.live-info .label,.live-setting-ctnr,.log-item li.log-item .txt-block,.main-c .main-b .main-b-l .convert,.main-c .main-b .main-b-l .info-l p,.main-t .main-title,.main_body .future .future_list .future_block .info .title,.main_body .pick_up .pick_list .pick_block .info .title,.mainly-automatic dl,.mainly-automatic h2,.mainly-question h2,.media-tab-content .nav-tools .tool-item:hover,.mini-wnd .play-all,.mini-wnd .read-all,.misl-ep-item .mark-icon,.mobile-kpi-head h2,.more-selector-v2-container .more-selector-v2-title-wrp>h1,.multi-page .cur-list .module-box li,.my-room.room-info .room-info-ctnr .room-id,.mycollect-info .mycollect-li .song-sort,.mycollect-info .mycollect-li .song-title .song-normal,.mycollect-info .mycollect-li .song-uname,.mycollect-padding .mycollect-board .mycollect-playbtn,.mycollect-padding .mycollect-title,.mycollect-padding .mycollect-upname,.mycollect-theme,.nameplate-card .nameplate-text .n-name,.nav-item2 .nav-item2-title,.nav-item3.active,.nav-warp2 .nav-item3,.new_list .vd_list li .title,.new_list .vd_list li .typename,.news-content a,.news-contents h2,.news-detail-content .news-title,.page_body .page_box .block .info .title,.pager .jump-pager input[type=number],.pagination-container li.pagination,.pagination-container li.pagination-input-wrap .pagination-input,.panel-block h4,.panel-block input,.player-limit-wrap .limit_not_start_wrap .not_start_btn span,.popup-btn .btn-default,.popup-content,.privacy-type .album-radio.bp-album-radio,.privilege-box-right-btn,.privilege-box-right-name,.privilege-content-warp .right-crumbs,.privilege-content-warp .right-crumbs a,.privilege-content-warp .right-crumbs i,.privilege-tabs .privilege-item,.privilege-tabs-title,.q-box .q-title a,.q-c-div dl,.reportImage-candidate-item.dp-i-block.bg-cover.bg-center.bg-no-repeat.ts-dot-3.pointer.p-relative .upload-hint,.room-id,.s-paging .jump-to-page input[type=text],.s-paging>ul>a,.s-paging>ul>a:not(.disabled):not(.current):hover,.s-paging>ul>a:not(.disabled):not(.current):not(a):hover,.s-paging>ul>span,.s-paging>ul>span:not(.disabled):not(.current):hover,.s-paging>ul>span:not(.disabled):not(.current):not(a):hover,.s-statusUnit-text .info a,.score-info span,.search-wrp .bili-input,.security-right .main-c .xts,.security-right .main-c .xts i,.security-right .vip-help a,.select-box-v2-container .select-box-v2-controller,.select-box-v2-container .select-box-v2-controller .select-item-cont-inserted,.share-addr-item .share-addr-name,.share-addr-item .share-addr-wrapper,.song-change .font12,.song-complain-bg .song-complain .complain-btn,.song-complain-bg .song-complain .complain-text,.song-complain-bg .song-complain .complain-title,.song-li .song-right .song-right-title,.song-li .song-right .song-theme,.song-right-title a,.spa-sub-title,.spa-use-type,.spa-user-info a,.sponsor-pay-dialog-v2 .sp-quick-pay .sponsor-pay-body .sponsor-control-group,.sr-record a,.start-live,.stm-ly .ct .stm-filter li,.stm-ly .stm-lst .name a,.sub-nav-m.report-wrap-module .sub-nav-m .tips,.submit-button-group-v2-container .submit-btn-group-add,.submit-button-group-v2-container .submit-btn-group-tpl,.t-gray-dark,.tab-selector-wrap .tab-wrap .tab a,.tabs-tab,.tag-default,.tag-default.current,.tag-default:active,.tag-default:hover,.tag-modal,.tag-modal .tag-item,.tag-modal .tag-title,.time-picker-v2-container .time-picker-body-wrp .time-picker-panel-select-wrp .time-picker-panel-select-item,.time-picker-v2-container .time-picker-head-wrp .time-picker-show,.title-name,.total-bt .t-date a,.tv-m2 .tv-m-tt,.tv-m3 .tv-m-tt,.video-toolbar-module .app-download,.video-toolbar-module .btn-item .t,.video-toolbar-module .share-box .s-text .t,.video-toolbar-module .share-box .share-popup .share-address ul li .btn,.video-toolbar-module .share-box .share-popup .share-address ul li .name,.video-toolbar-module .share-box .share-popup .share-address ul li input,.viptable .history-th,.voucher-right-name,.water-mark-set-v2-container .water-mark-set-v2-copy-switch-wrp>span,.works-ctnr .header-ctnr .works-count,table.invtable td,table.viptable td{color:#eee!important}#app .player-box,#dc-section_summary .source-rank-list-item,#dyn_wnd .wnd_bottom a.btn-article-more,#dyn_wnd .wnd_bottom a.btn-ignore-all,#dyn_wnd .wnd_bottom a.btn-live-more,#dyn_wnd .wnd_bottom a.read-more,#gameCenter .hot-list .s-imgUnit,#gameCenter .hot-list .s-imgUnit .rank,#gameCenter .hot-list .s-imgUnit:hover,#i_menu_msg_btn #dyn_wnd,.about-index .about-desc,.album-popup .album-pop-bottom ul li.disable,.album-popup .album-pop-bottom ul li.disable:hover,.album-popup .album-pop-bottom ul li.normal,.album-popup .album-pop-bottom ul li:hover,.apply-form .btn,.apply-form .btn:hover,.areas .area,.article-chart-wrp,.article-header .filter-wrp .article-type,.article-header .filter-wrp .category-wrp,.article-header .filter-wrp .filter-article-type,.article-header .filter-wrp .filter-level,.article-header .filter-wrp .order-wrp,.article-holder .ticket-card a,.biliPager .page-li,.biliPager .pager-jumper .pager-jumper-input,.biliPager .pager-jumper a,.biliPager .pager-jumper a:hover,.black-list .black-btn,.black-list .black-btn:hover,.black-ul.clearfix .black-list,.bp_user_box_bb,.bp_user_box_bottom p,.btn-primary,.btn-section .btn-item,.c-text .c-hd2,.channel-menu .r-box,.clearfix .multi-page .item,.clearfix .multi-page .item.on,.clearfix .multi-page .item:hover,.code-result,.coin-operated-m .coin-bottom .coin-btn,.coin-operated-m .coin-bottom .coin-btn:hover,.comment-list-item,.common-modal-container .common-modal-content .common-modal-foot>div div:nth-child(2),.common-modal-container .common-modal-content .common-modal-head,.container-body .newlist_info,.content-tag-v2-container .content-tag-v2-edit-mod-wrp,.content-tag-v2-container .content-tag-v2-other-tag-error-wrp,.d-buttons .d-button,.d-buttons .d-state-highlight,.d-header .d-titleBar .d-title,.d-time-v2-container .d-time-v2-date-picker-wrp .date-picker-date-wrp .date-picker-date,.d-time-v2-container .d-time-v2-date-picker-wrp .date-picker-date-wrp .date-picker-timer,.drawer-pop-ctn.pop-ctn-4 .draw-list,.drop-cascader-container,.drop-cascader-container .drop-cascader-list-wrp,.drop-list-v2-container,.dropdown .dropdown-menu,.el-input-group__append,.el-input-group__prepend,.elecrank-wrapper .elecrank-content,.elecrank-wrapper .elecrank-footer,.elecrank-wrapper.report-wrap-module.report-scroll-module .elecrank-header,.face-buy-footer .btn-mk2.primary,.face-g-list .mp-block .right ul li .mp-tips,.feed-card .content .card,.file-list-v2-container .dividing-line,.fixed-nav-m .go-top,.fixed-nav-m .mini,.footer-logo-list .footer-logo,.g-title .btn.btn-red,.g-title .btn.btn-red:hover,.gift-all .gift-box,.h .report-popup-item.checked .report-popup-item-checkbox,.head .dropdown-btn,.help-box,.help-list,.home-wrap .home-input .type.selected,.home-wrap .home-input .type:hover,.input-box-v2-1-container,.ivu-input-costom-width .ivu-input-wrapper .ivu-input-wrapper-default .ivu-input-type .ivu-input,.l-wrapper .y-layout,.label-item-v2-2-container,.left-side .categories-bar,.list.main_body .list_box .block,.list.main_body .right_box .select_box .select .title,.live-haruna .tab-body .item,.main-c .main-b .main-b-l,.main-c .main-b .main-b-l .convert,.main-footer .link-item,.media-tab-content .nav-tools .tool-item,.media-tab-content .nav-tools .tool-item:hover,.mini-wnd,.mini-wnd .play-all,.mini-wnd .read-all,.mobile-kpi-head,.multi-page .cur-list .module-box li,.my-room.room-info .room-info-ctnr .top,.mycollect-info,.nameplate-card,.nameplate-card .nameplate-text,.nav-item2 .nav-item2-title,.nav-warp1 .nav-item2,.nav-warp2 .nav-item3,.new_list .vd_list li .up,.new_list .vd_list li.l1,.news-detail-content .sepatator,.normal-v2-container .dividing-line,.normal-v2-container .normal-title-wrp>.template-op,.page-wrp.is-article.cc-article-wrp .article-card,.pager .jump-pager input[type=number],.pagination-container li.pagination,.pagination-container li.pagination-input-wrap .pagination-input,.panel-block input,.player-limit-wrap .limit_not_start_wrap .not_start_btn .follow,.player-limit-wrap .limit_not_start_wrap .not_start_btn .follow:hover,.popup-box .popup-title,.popup-btn .btn-default,.popup-btn .btn-default:hover,.popup-close-btn,.privacy-panel,.privacy-panel-other,.privilege-box.clearfix .privilege-box-right,.privilege-content-warp .privilege-box,.privilege-tabs-title,.r-con .mobile-link-l,.record-ctnr .summary,.s-paging .jump-to-page input[type=text],.s-paging>ul>a,.s-paging>ul>a.current,.s-paging>ul>a:not(.disabled):not(.current):hover,.s-paging>ul>a:not(.disabled):not(.current):not(a),.s-paging>ul>a:not(.disabled):not(.current):not(a):hover,.s-paging>ul>span,.s-paging>ul>span.current,.s-paging>ul>span:not(.disabled):not(.current):hover,.s-paging>ul>span:not(.disabled):not(.current):not(a),.s-paging>ul>span:not(.disabled):not(.current):not(a):hover,.security-right .faq-line,.security-right .sr-record,.security-right .vip-help,.security-right .vip-help p,.select-box-v2-container .select-box-v2-controller,.setting.cc-content-body .setting .follow-setting,.share-addr-item .share-addr-wrapper,.song-complain-bg .song-complain .complain-title,.stm-lst-item .share,.stm-ly .ct .stm-filter li.on,.stm-ly .stm-lst li+li,.stm-ly .usr,.stm-ly>.ct,.stm-ly>.sd>.sec,.sub-nav-m.report-wrap-module .sub-nav-m .tips,.submit-button-group-v2-container .submit-btn-group-tpl,.tab-selector-wrap .tab-wrap,.tab-selector-wrap .tag-wrap .tag span.selected,.tag-default,.tag-default.current,.tag-default:active,.tag-input,.template-list-small-container,.title-factory-card,.title-factory-card .title-num,.title-item,.title-list .title-list-item:hover .tips .tips-title,.tv-m2,.tv-m2:nth-child(odd),.tv-m3,.user-avatar,.user-ctnr .top,.video-info-m .number .line,.video-toolbar-module .app-download:hover,.video-toolbar-module .app-download:hover .qr-code-box,.video-toolbar-module .share-box .share-popup .or-code,.video-toolbar-module .share-box .share-popup .share-address ul li input,.video-toolbar-module .share-box:hover,.video-toolbar-module .share-box:hover .share-popup,.videoCharts .stat .stat-wrp .stat-card{border-color:transparent!important}.add-cover,.cc-article-wrp .article-card .meta-title .typename,.check-radio-v2-container .check-radio-v2-box,.text-area-box-v2-container,.voucher-content-outside .voucher-list-wrapper,.voucher-list-wrapper.voucher-ing .voucher-right{border-color:#aaa!important}#page-fav .fav-main .filter-item.search{border-color:#666!important}#arc_toolbar_report .elec-btn .bili-icon,#arc_toolbar_report .elec-btn .icon,#playpage_share .share-btn .clearfix .bili-icon,#playpage_share .share-btn .clearfix .icon,.footer-logo-list .footer-logo,.icon-back,.left-nav-logo,.nav-item1 .nav-item1-title i.item0,.nav-item1 .nav-item1-title i.item1,.nav-item1 .nav-item1-title.arrow:after,.video-toolbar-module .b-icon,.video-toolbar-module .fav-box .btn-item .f-icon-move{filter:brightness(0) invert(1)!important}.main-c .main-head{filter:brightness(.5) contrast(3)!important}.article-data-wrp .video-box,.article-net-charts .content-box,.el-radio-button__orig-radio:checked+.el-radio-button__inner,.face-g-list .mp-block .right ul li .mp-tips,.guide .trynew-btn a,.videoCharts .stat .stat-wrp{box-shadow:none!important}#dyn_wnd .dyn_menu .line:before,.add-cover:hover,.app-ctnr .live-helper .main-content .menu-item .menu-title,.app-ctnr .live-helper .main-content .menu-item .menu-txt .download .down-item a,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-filter .bilibili-player-filter-btn.active>span,.bind-info .note-footer .btn-group .active-btn,.creation-li .creation-left .creation-shadow,.d-time-v2-container .d-time-v2-date-picker-wrp .date-picker-date-wrp .date-picker-date:hover,.d-time-v2-container .d-time-v2-date-picker-wrp .date-picker-date-wrp .date-picker-timer:hover,.data-card .data-box .tab .fan-tab.current:after,.data-card .fans-box .tab .fan-tab.current:after,.date-picker-v2-container .date-picker-v2-body-wrp .date-wrp .date-item:hover,.el-checkbox__inner:hover,.el-checkbox__input.is-checked .el-checkbox__inner,.el-checkbox__input.is-indeterminate .el-checkbox__inner,.elecrank-header .rank-tab.active,.input-box-v2-1-container.input-box-v2-1-container-active,.input-box-v2-1-container:hover,.ivu-input:focus,.ivu-input:hover,.left-side .categories-bar .tag-item.on,.multi-page .cur-list .module-box li.on,.multi-page .cur-list .module-box li:hover,.nav-item3.active,.s_tag .btn-add:hover,.section-item .diff-wrp .diff-text:before,.security-right .sr-record a.on,.select-box-v2-container .select-box-v2-controller:hover,.slider-ad-m .carousel-module .panel .trig span.on,.tab-selector-wrap .tab-wrap .tab span.active,.tab-selector-wrap .tag-wrap .tag span.selected,.tabs-tab-active:before,.text-area-box-v2-container.text-area-box-v2-container-active,.text-area-box-v2-container:hover,.voucher-content-outside .voucher-ing,.voucher-content-outside .voucher-no-used{border-color:var(--theme-color)!important}#dyn_wnd .dyn_menu .line,#dyn_wnd .wnd_bottom a.btn-article-more:hover,#dyn_wnd .wnd_bottom a.btn-ignore-all:hover,#dyn_wnd .wnd_bottom a.btn-live-more:hover,#dyn_wnd .wnd_bottom a.read-more:hover,.ac-artilce-tabs .tabs-nav .active,.album-popup .album-pop-bottom ul li.normal,.album-popup .album-pop-bottom ul li:hover,.album-radio.active::before,.alert-v2-container-info div.alert-v2-btn:nth-child(2),.app-ctnr .live-helper .main-content .menu-item .menu-txt .download .down-item a:hover,.apply-form .btn,.apply-form .btn:hover,.biliPager .current span,.biliPager .pager-jumper a:hover,.bind-info .note-footer .btn-group .active-btn,.black-list .black-btn:hover,.bui-content .g-title .btn:hover,.cc-article-wrp .article-card .meta-view .appeal:hover,.cc-article-wrp .article-card .meta-view .data:hover,.cc-article-wrp .article-card .meta-view .delete:hover,.cc-article-wrp .article-card .meta-view .option:hover,.check-radio-v2-2-container.check-radio-v2-2-container-active,.check-radio-v2-container .check-radio-v2-box.check-radio-v2-box-checked:after,.clearfix .multi-page .item.on,.clearfix .multi-page .item:hover,.code-btn,.code-btn:hover,.coin-operated-m .coin-bottom .coin-btn,.coin-operated-m .coin-bottom .coin-btn:hover,.col-4-med.col-4 .song-change:hover,.common-modal-container .common-modal-content .common-modal-foot>div div:first-child,.common-modal-container .common-modal-content .common-modal-foot>div div:first-child:hover,.common-modal-container .common-modal-content .common-modal-foot>div div:nth-child(2):hover,.d-buttons .d-button:hover,.d-buttons .d-state-highlight:active,.d-buttons .d-state-highlight:hover,.date-picker-v2-container .date-picker-v2-body-wrp .date-wrp .date-item-selected,.date-picker-v2-container .date-picker-v2-body-wrp .weekend-wrp .date-item-selected,.dc-button.dc-button-text:hover,.el-checkbox__input.is-checked .el-checkbox__inner,.el-checkbox__input.is-indeterminate .el-checkbox__inner,.elecrank-wrapper .elecrank-content.no-list .elec-btn,.face-buy-footer .btn-mk2.primary:hover,.face-g-list .mp-block .right ul li .mp-tips .btn,.face-g-list .mp-block .right ul li .mp-tips .btn:hover,.file-list-v2-container .file-add-btn:hover,.file-list-v2-wrp .file-list-v2-item .file-list-v2-item-wrp .item-upload-progress .item-upload-progress-loading,.fixed-nav-m .mini:hover,.gift-all .g-title:before,.gift-all .gift-box:hover,.gift-recommend .g-title h4:before,.gift-recommend .gift-box .hover-bg,.guide .trynew-btn a:hover,.h .report-popup-item.checked .report-popup-item-checkbox,.h-none-btn:hover,.head .dropdown-btn:hover,.helper-icon-dots,.item .title-wrap .activity,.label-item-v2-2-container-selected,.label-item-v2-2-container:hover,.label-item-v2-container,.live-btn,.live-btn.default:active,.live-btn.default:hover,.live-btn:active,.live-btn:hover,.main-c .main-b .main-b-l .convert:hover,.media-info-wrp .media-info-content .media-info-inner .media-info-r .media-info-btns .bangumi-btn .btn-follow,.media-info-wrp .media-info-content .media-info-inner .media-info-r .media-info-btns .bangumi-btn .btn-follow:hover,.media-tab-content .nav-tools .tool-item:hover,.media-tab-module-wrp .media-tab-module-content .sl-ep-nav .slider-contro span.disabled:hover,.media-tab-module-wrp .media-tab-module-content .sl-ep-nav .slider-contro span:hover,.mini-wnd .play-all:hover,.mini-wnd .read-all:hover,.misl-ep-item .mark-icon.badge-pink,.mycollect-padding .mycollect-board .mycollect-playbtn,.mycollect-padding .mycollect-board .mycollect-playbtn:hover,.player-limit-wrap .limit_not_start_wrap .not_start_btn .follow,.pop-live .pl__mask .pl__icon--live,.popup-btn .btn-default:hover,.popup-close-btn,.privilege-box-right-btn:hover,.qa-index .help-list .collapse-item.collapse-item-active .collapse-title-icon,.s-paging>ul>a.current,.s-paging>ul>a:not(.disabled):not(.current):hover,.s-paging>ul>span.current,.s-paging>ul>span:not(.disabled):not(.current):hover,.song-complain-bg .song-complain .complain-btn,.submit-button-group-v2-container .submit-btn-group-add,.submit-button-group-v2-container .submit-btn-group-add-img:hover,.submit-button-group-v2-container .submit-btn-group-add:hover,.submit-button-group-v2-container .submit-btn-group-tpl:hover,.tabs_active-bar,.tag-default.current,.tag-default:active,.tag-default:hover,.video-toolbar-module .share-box .share-popup .share-address ul li .btn{background-color:var(--theme-color)!important}#bp_right .balance_bp_box .button{background:var(--theme-color)!important}#dyn_wnd .dyn_menu li.on,#dyn_wnd .dyn_menu li:hover,#gameCenter .hot-list .s-imgUnit .rank.pink,#page-follows .modal-container .content-text em,#status .s-statusUnit .s-statusUnit-text .info .game-name,.academy-right-link:hover,.add-cover:hover,.album-radio.active,.anime-expo-container .main .price,.app-ctnr .live-helper .main-content .anchor li:hover,.app-ctnr .live-helper .main-content .menu-item .menu-txt .download .down-item a,.app-ctnr .live-helper .main-content .menu-item .menu-txt p a,.article-header .filter-wrp .article-type .bili-btn.current,.article-header .filter-wrp .filter-article-type .bili-btn.current,.article-header .filter-wrp .filter-level .bili-btn.current,.bili-blue,.categories-bar .tag-item.on,.check-box-v2-container .check-box-v2-pre-selected,.collapse-item--active .collapse-title,.comment-card .comment-item .comment-info .reply-block .comment-vedio a,.comment-container .main-desc .goods-info .desc .price,.cover-chop-modal-v2-body .cover-chop-modal-v2-body-left .cover-chop-clip-reset-v2:hover>span,.cover-v2-container .cover-v2-detail-wrp .cover-v2-selector .cover-v2-selector-title-more:hover,.date-picker-v2-container .date-picker-v2-body-wrp .date-wrp .date-item:hover,.date-picker-v2-container .date-picker-v2-footer-wrp .date-picker-v2-select-today,.drop-cascader-container .drop-cascader-list-wrp .drop-cascader-list-item-selected p.item-main,.drop-cascader-container .drop-cascader-pre-wrp .drop-cascader-pre-item-selected .pre-item-content,.drop-list-v2-container .drop-list-v2-item i.drop-list-v2-item-icon,.drop-menu-item:hover,.elecrank-header .rank-tab.active,.file-list-v2-wrp .file-list-v2-item .file-list-v2-item-wrp .item-status-wrp .item-status-op .item-status-click:hover,.fixed-service-word a,.fixed-service-word a:hover,.footer-box .footer-text a:hover,.gift-all .gift-box .info .price-box em,.gift-recommend .gift-box .info .price-box em,.goods-container>.info-container .price,.help-subcontent a,.help-subcontent a:hover,.help-subindex,.help-title-wrap.help-box .help-title,.home-wrap .home-suggest .title .delete-history:hover,.hot-goods-container .bottom .price-tag .price,.i-pin-info a:hover,.icon-label.hover-text-blue:hover .label,.item:hover .title,.left-nav-item-child:hover,.left-nav-item-childed:hover,.left-nav-item:hover,.left-nav-item:hover .icon,.link-no-hover:hover,.list-wrap.hot-forum-lft-con .s-imgUnit a:hover,.list-wrap.lft-con .s-imgUnit a:hover,.main-c .main-b .main-b-l .info-l i,.main-c .main-head .main-h span.sc,.mini-wnd .list li a:hover,.mycollect-info .mycollect-li .song-title .song-collection.font-blue,.mycollect-info .mycollect-li .song-title .song-float:hover,.mycollect-info .mycollect-li .song-title .song-normal:hover,.nameplate-card .nameplate-text .n-type a,.nav-item1 .nav-item1-title.expand,.new_list .vd_list li .title:hover,.notice .blink:hover,.notice-ctnr .blink:hover,.player-limit-wrap .limit_not_start_wrap .not_start_info span,.privilege-tabs .privilege-item-active,.privilege-tabs .privilege-item:hover,.q-c-div dl.active dt,.q-title a.active,.qa-index .help-content .help-title,.qa-index .help-list .collapse-item.collapse-item-active .collapse-title,.qa-index .help-list .collapse-item.collapse-item-title,.s-statusUnit-text .info a:hover,.s_tag .btn-view-tag a:hover,.save-btn.active,.section-item .diff-wrp .diff-text,.security-right .vip-help a:hover,.song-li .song-right .song-right-title a:hover,.sr-record a.on,.sr-record a:hover,.stat-card .num .text,.stm-ly .stm-lst .name a:hover,.stm-ly .stm-lst a,.stm-ly .stm-lst a:hover,.tab-selector-wrap .tab-wrap .tab span.active,.tab-selector-wrap .tab-wrap .tab span:hover,.tab-selector-wrap .tag-wrap .tag span.selected,.tabs-tab-active,.text-blue,.time-picker-v2-container .time-picker-body-wrp .time-picker-panel-select-wrp .time-picker-panel-select-item.time-selected,.total-bt .t-date a:hover,.tv-m2 .tv-m-tt:hover,.tv-m3 .tv-m-tt:hover,.video-info-m .tm-info a:hover,.video-toolbar-module .app-download .qr-code-box .box .txt a,.video-toolbar-module .elec-btn,.voucher-right-ing,.water-mark-set-v2-copy-switch-wrp a:hover,li.log-item .user-action .up-mark{color:var(--theme-color)!important}#dyn_wnd .dyn_menu .line:before,.data-card .data-box .tab .fan-tab.current:after,.data-card .fans-box .tab .fan-tab.current:after,.section-item .diff-wrp .diff-text:before,.tabs-tab-active:before{border-left-color:transparent!important;border-right-color:transparent!important}#app-container .main .share-step,#app-container .main .share-success,#app-ctnr .content,#app-ctnr .content #comment,#area-list ul li:after,#disable-popup-modal .btn,#disable-popup-modal .btn-transparent,#disable-popup-modal .btn-white,#disable-popup-modal .vip-exchange .months #showMonths,#disable-popup-modal .vip-exchange .months button,#disable-popup-modal .vip-exchange .selector li.current,#disable-popup-modal .vip-exchange a.btn.disabled,#page-channel-detail .channel-add-video,#page-channel-detail .channel-detail .channel-action-row .be-dropdown,#page-channel-detail .channel-option .modify-channel,#ssr-app.wrap,#vip-exchange-modal .btn,#vip-exchange-modal .btn-transparent,#vip-exchange-modal .btn-white,#vip-exchange-modal .vip-exchange .months #showMonths,#vip-exchange-modal .vip-exchange .months button,#vip-exchange-modal .vip-exchange .selector li.current,#vip-exchange-modal .vip-exchange a.btn.disabled,.area-selector-ctnr.data-area-selector .area-selector,.backdrop .extension-wrapper #app,.ban-app .case-tip .click-btn,.ban-vote .vote-dialog .dialog-footer .white-btn,.bangumi-pagelistbox .custom-right .custom-right-inner.custompage,.bangumi-pagelistbox .p,.bili-pay-payment-wrapper-gift,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-item:hover,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-item[data-state-play=true],.bilibili-player-feedback,.bnj-main>.content,.bp-vote-container.vote-box .create-vote,.btn-my-operate,.calendar-table td.disabled,.chat-input-ctnr.p-relative .block-panel,.coin-dialog-mask .coin-operated,.common-dialig-left-btn,.confirm-window .mask .confirm-board,.container .content .comment-area,.container .play-coin-bg .play-coin,.container .qr-code-bg .qr-code-box,.d-state-highlight,.date-picker-input,.datepicker.range_start.hasDatepicker .datepicker-popup,.edit-media-list .edit-mask .default-edit,.edit-media-list .edit-mask .edit-board,.editor.active,.editor:focus,.editor:hover,.emoji-box .static-popup,.ep-list-wrapper .ep-item.cursor,.ep-list-wrapper .ep-item:hover,.favInfo-box .favInfo-details .fav-options .fav-play,.group-helper-msg-list,.history-dlg .hsbtn .cancel,.item-footer .button-line .button-wrapper .button-item.support .tooltip-wrapper .tip-arrow,.item-footer .button-line .button-wrapper .button-item.support .tooltip-wrapper .tooltip,.link-btn-ctnr.dp-i-block.v-middle .my-link-btn:before,.link-tag.custom,.link-tag.default,.link-tag.origin,.live-room-app .app-content .link-footer-ctnr,.lottery-box .title,.main-container .ep-list-wrapper .list-wrapper.simple ul .ep-item,.main-container .ep-list-wrapper .list-wrapper.simple ul .ep-item.cursor,.media-tab-module-content .mtlr-list-wrp .block-relate-wrp .pagelistbox .custom-right .custom-right-inner.custompage,.media-tab-module-content .sl-ep-list .section-item,.nav-panel-live .area-list-item:hover,.nav-panel-live .static-link:hover,.p-rel.f-clear.publish-panel .textarea,.pika-label,.pika-single.is-bound.left-aligned.bottom-aligned .pika-lendar,.player-auxiliary-playlist-item-p-item:hover,.player-his-info,.range-picker.dp-i-block .range.active,.section-ep-wrapper .ep-item.cursor,.section-ep-wrapper .ep-item:hover,.send-vip-content,.short-review-masker .short-review-content .review-body-wrap .mr-btn,.sidebar-wrapper .sidebar .feedlist-wrapper .more,.sidebar-wrapper .sidebar .feedlist-wrapper .title .number,.textarea.active,.textarea:focus,.textarea:hover,.video-list .vl-hd .float_window{background-color:#222!important}.area-panel,.main-container .review-module .review-list .review-item .review-body,.pika-button:hover,.rank-list-ctnr .tab-content{background-color:#333!important}#app .main .content-wrp,#app-ctnr .content .nav-wrapper,#area-list ul li,#disable-popup-modal .modal,#vip-exchange-modal .modal,.bb-comment .no-login .baffle,.bb-comment .no-login .comment-emoji,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist,.bilibili-player-feedback-content .bilibili-player-feedback-default-content .bilibili-player-feedback-contact-information-input,.bilibili-player-feedback-content .bilibili-player-feedback-default-content .bilibili-player-feedback-submit-wrap .bilibili-player-feedback-submit.disable,.bnj-reserve-progress .contact,.bp-input .content-box.textarea-box .textarea,.calendar-month>a:hover,.calendar-table td.inrange,.calendar-table td:hover,.calendar-year>a:hover,.category-divider,.coin-dialog-mask .coin-operated .coin-bottom .coin-btn,.common-dialog-content,.confirm-window .mask .confirm-board .btn-wrap .btn.cancel,.container .play-coin-bg .play-coin .play-coin-btn,.container .right-container .media-upper .media-upper-follow .media-upper-followed,.core-player,.core-player-video-panel,.create-vote .button-bar .bp-button,.d-outer,.danmaku-wrap .player-auxiliary-area .player-auxiliary-danmaku-wrap-child,.datepicker.range_start.hasDatepicker .input,.dialog-contnent,.dlg-contain .history-dlg,.draw-popup-warp .rules,.edit-media-list .edit-mask .default-edit .default-edit-info .default-btn-wrap .default-btn.cancel,.edit-media-list .edit-mask .default-edit .default-edit-info .info-wrap .name-input,.edit-media-list .edit-mask .edit-board .edit-info .info-wrap .name-input,.ep-section-module,.feed-topic .publish-panel-container,.feedback-content,.gather-wrap .cardhead .type,.gather-wrap .videos .item,.gift-items.col-2 .gift-item .gift-img,.group-helper-msg-list:after,.history-wrap .warn .btn,.list-info .list-li.even,.list-info .list-li.odd,.main-container .entry-old .btn-old,.main-container .ep-list-wrapper,.main-container .media-info .media-cover,.main-container .media-info .media-right .media-tool-bar .btn-rating,.main-container .nav-tools .tool-item,.main-container .pay-bar .sponsor .btn-pay,.main-container .pre-mask,.main-container .recom-wrapper .expand-more,.main-container .season-list .ss-list-wrapper .expand-more,.main-container .season-list .ss-list-wrapper .ss-item .ss-cover,.main-container .tool-bar .mobile-info .mobile-more,.main-container .tool-bar .share-info .share-more,.main-content .group .bp-input .content-box,.main-content .group .title .slot-right .bp-selector,.main-content .list .all-list .pic-item,.main-content .list .all-list .vc-item,.narrowscreen .ov-box,.notification,.page-list-box .page-input,.page-list-box .page-item,.pgc-list .synthetical .headline .pgc-label,.pika-table thead,.pk-result .mvp-info,.pk-result .winner-info,.play-list .leftside-content .oprate-panel .oprate-item .oprate-window,.play-list .leftside-content .upper-info .followed-btn,.play-list .rightside-content .batch-operation .batch-btn,.play-list .rightside-content .batch-operation .delete-btn,.play-list .rightside-content .source-list .source-item .collect,.player-his-nav-wrp,.player-his-round div,.player-module .player-tool-bar,.player-module .stardust-player.mini-player .drag-bar i,.player-module .stardust-player.mini-player .drag-bar span,.rank-detail .my-info,.rank-detail .top50,.rank-detail .top50 li:nth-child(2n),.rank-main .rank-box .child-nav,.recommend-box .section-title .action-tab,.share-content.plain .music-card,.short-review-masker .short-review-content,.side-box .side-title.f-clear .action-tab,.sidebar-wrapper .sidebar .feedlist-wrapper,.sidebar-wrapper .sidebar .profile-wrapper .info-wrapper,.slot-ctnr.p-relative .nav-panel-live,.sponsor-rank-item.pos-rank-module .sp-right .sp-msg,.sub-nav-m .tips,.teach-last-list,.top3 li div.content-detail,.uns_box li.u-i.b-post .s-menu,.up-info .btn-panel .following,.up-info .btn-panel .following-charge-btn,.user-card-m .loading .mc1,.user-card-m .loading .mc3,.user-card-m .loading .mc4,.video-list .vl-hd .float_window .selet-datebox .sse a:hover,.video-list .vl-hd .vl-hd-sub .selector-block .date-select,.winner-list .list-wrap,.z-top-container.has-stardust,input[type=radio]:checked+.custom-radio{background-color:#444!important}.pgc-space-follow-item .pgc-item-info .pgc-item-state i,.pgc-space-follow-item .pgc-item-info .type-and-area i{background-color:#aaa!important}#gift-control-vm,#head-info-vm,#rank-list-ctnr-box{background-image:none!important}#app-ctnr .article-content .content,#app-ctnr .content .container,.all-hot-list-warp .pager .pages .page-item button,.all-hot-list-warp .pager .pages .page-item button:hover,.all-hot-list-warp .pager .pages .page-item.active button,.area-category-item.dp-i-block.p-relative.t-center.pointer .category-divider,.bangumi-pagelistbox.clearfix .custom-right .result,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-item:hover .bilibili-player-playlist-part-list:before,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-part-list:before,.body-contain .user-wrap .dropdown-wrap .select-wrap .bili-dropdown,.change-container .video-list,.chat-history-panel,.chat-history-panel .chat-history-list .chat-item.danmaku-item[class*=guard-level-]:before,.chat-history-panel .chat-history-list .chat-item.danmaku-item[class*=week-all-area-top-]:after,.chat-history-panel .chat-history-list .chat-item.danmaku-item[class*=week-all-area-top-]:before,.collection-m .content .group-list .add-group .input-group input,.collection-m .content .group-list ul .collection-mask,.info-wrap .bk-text-con p span,.list-row:hover,.list-row:nth-child(odd),.live-item .live-item-link .live-img-box,.live-room-app .app-content .app-body .player-and-aside-area .aside-area .chat-control-panel,.main-content .group .bp-input .indicator,.original-card-content .media-list .content,.original-card-content .media-list .content .cover-box-cliper .cover-box,.page-item.disabled .pager .pages .page-item .next,.page-item.disabled .pager .pages .page-item .next.disabled:hover,.page-item.disabled .pager .pages .page-item button,.pager .pages .page-item .next.disabled,.pk-container.p-absolute.normal-pk .player-area.p-absolute.init-player.normal-pk .player-area.init-player.normal-pk .pk-result,.pk-container.p-absolute.normal-pk .player-area.p-absolute.match-player.normal-pk .player-area.match-player.normal-pk .pk-result,.ps .ps__rail-x.ps--clicking,.ps .ps__rail-x:focus,.ps .ps__rail-x:hover,.ps .ps__rail-y.ps--clicking,.ps .ps__rail-y:focus,.ps .ps__rail-y:hover,.rank-main .rank-box .child-nav .nav-remind,.report-wrap-module.ban-modal.pub-list.init-end .info dl dt p span,.row .col-4-med.col-4 .pager .pages .page-item button,.row .col-4-med.col-4 .pager .pages .page-item button:hover,.row .col-4-med.col-4 .pager .pages .page-item.active button,.section-block .publish-panel .emoji-box,.share-content.plain .music-card .media-list.share-media-list .content,.sidebar-wrapper .sidebar .profile-wrapper .img-wrapper,.tab-list .tab-item.active:before,.upper-right-ctnr.p-absolute.none-select .btn.primary{background-color:transparent!important}.chat-history-panel .chat-history-list .chat-item.danmaku-item[class*=guard-level-]:before,.chat-history-panel .chat-history-list .chat-item.danmaku-item[class*=week-all-area-top-]:after,.chat-history-panel .chat-history-list .chat-item.danmaku-item[class*=week-all-area-top-]:before,.d-state-highlight,.follow-dialog-wrap .follow-dialog-window .content .group-list .add-group .input-group .submit,.follow-dialog-wrap .follow-dialog-window .content .group-list .add-group .input-group input,.follow-dialog-wrap .follow-dialog-window .content .group-list ul .follow-group-mask,.static-popup.bp-arrow:before{background:0 0!important}.bnj-progress-inner-operation .operation .programme .show-programme .content,.bnj-reserve .content h5,.operation .inner .bnj-button .content{color:#222!important}#article-list-index .article-list-title,#disable-popup-modal .vip-exchange .selector li p.cost,#disable-popup-modal .vip-exchange a.help,#disable-popup-modal .vip-exchange p#errorTips,#disable-popup-modal .vip-exchange p.tips,#disable-popup-modal .vip-exchange p.totail,#disable-popup-modal .vip-exchange p.totail label,#pin-wrapper .pin-layer-header-counter,#vip-exchange-modal .vip-exchange .selector li p.cost,#vip-exchange-modal .vip-exchange a.help,#vip-exchange-modal .vip-exchange p#errorTips,#vip-exchange-modal .vip-exchange p.tips,#vip-exchange-modal .vip-exchange p.totail,#vip-exchange-modal .vip-exchange p.totail label,.area-text.dp-i-block.v-middle .area-link,.area-text.dp-i-block.v-middle .child-area,.article-content-ctnr .article-footer,.article-wrap .article .so-icon a,.ban-app .case-tip .tips,.bb-comment .comment-list .list-item .con .vote-container .text-area .text-desc,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-info .bilibili-player-danmaku-number,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-info .bilibili-player-watching,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-info-other,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-nav-header,.calendar-table td.disabled,.card .focus-btn .focus .focus-text,.chat-input-ctnr.p-relative .block-panel,.coin-dialog-mask .coin-operated .coin-bottom .tips,.col-9-med.col-7 .list-padding,.common-dialig-sub-title,.common-popup-wrap.arrow-top.drop-bubble-ctnr .score-introduction,.container .play-coin-bg .play-coin .play-coin-exp,.container .right-container .media-info .media-content .media-playnum,.container .right-container .media-upper .media-upper-info .media-upper-time,.content-list.clearfix .v .i span,.core-player-info,.count-wrapper div.up-info a,.draw-popup-warp .rules .tips,.edit-media-list .edit-mask .default-edit .default-edit-info .media-list-type,.edit-media-list .edit-mask .edit-board .edit-info .media-list-type,.face-buy-item,.face-buy-price,.favInfo-box .favInfo-details .fav-options .meta,.feedback-dialog-content p,.gift-component-effect-rule,.gift-items.col-3 .gift-item,.is-disabled .pika-button,.item-footer .button-line .button-wrapper a,.list-info .list-li .song-title .song-collection,.list-info .list-li .song-title .song-float,.list-padding .list-intro,.list-padding .list-publish,.lottery-notice-cntr .ignore-notice,.lottery-notice-cntr .thx,.lottery-notice-cntr .win,.lottery-notice-cntr .win .gift-name,.main-container .ep-list-wrapper .list-title .ep-list-progress,.main-container .media-info .media-right .media-count,.main-container .media-info .media-right .media-rating p,.main-container .media-info .media-right .pub-wrapper,.main-container .recom-wrapper .recom-list .recom-item .info-wrapper .video-count,.main-container .recom-wrapper .recom-list .recom-item .info-wrapper .video-uper,.main-container .review-module .review-list .review-item .pub-time,.main-container .season-list .ss-list-wrapper .ss-item .ss-info .pub-info,.main-container .sponsor-module .sponsor-info .sponsor-count,.main-container .tool-bar .coin-info i,.main-container .tool-bar .coin-info span,.main-container .tool-bar .mobile-info i,.main-container .tool-bar .mobile-info span,.main-container .tool-bar .share-info i,.main-container .tool-bar .share-info span,.main-content .group .bp-input .indicator,.main-content-page .coin-no-log,.main-content-page .record-login-descript.record-group.clearfix p,.media-list .content .text-box .count-box,.media-list .content .text-box .description,.narrowscreen .ov-box .v-data span,.narrowscreen .ov-box .v-info,.narrowscreen .ov-box .v-preview .txt,.notification .notification-group .notification-content,.page-container.p-rel .tab-nav .tab .tab-text,.page-list-box .jump-input,.page-list-box .pageInfo,.pgc-space-follow-item .pgc-item-info .pgc-item-desc,.pgc-space-follow-item .pgc-item-info .pgc-item-state,.pgc-space-follow-item .pgc-item-info .type-and-area,.pic-item .content-wrapper .main-content .datetime,.play-list .leftside-content .list-info,.play-list .leftside-content .oprate-panel .oprate-item,.play-list .leftside-content .oprate-panel .oprate-item .iconfont,.play-list .rightside-content .source-list .source-item .more-oprate,.player-auxiliary-playlist-count,.player-his-follow,.player-his-follow a,.player-his-notice-content,.player-his-notice-content b,.player-his-tip .player-his-tip-des,.popup-content-ctnr .content .content-text,.profile-wrapper .info-wrapper .relationship,.profile-wrapper .info-wrapper .relationship .followings:after,.progress-outer-ctnr .lv-text,.progress-outer-ctnr .next-text,.rhythm-master-gift-panel .rhythm-danmaku .danmaku-item,.room-info-upper-row.p-relative .upper-right-ctnr.p-absolute.none-select .btn.primary,.row .list-theme span,.share-content.plain .music-card .up-info .tip,.share-step .btn-field .count,.short-review-masker .short-review-content .dialog-close,.side-box .list .item .info a,.t-center.glory-item.dp-i-block.v-middle .glory-activity-name,.t-center.glory-item.dp-i-block.v-middle .glory-create-time,.tags-inner-ctnr.dp-i-block.v-top.border-box .area-tag-item,.textarea-container .comm-tool .comm-emoji,.uns_box li.u-i.b-post .s-menu li a,.user-list .up-item .up-info>span,.vc-item .item-top .detail .time,.video-info .video-data .a-crumbs a,.winner-list .gift-name,.wrap .state-null>.txt,.wrapper .fav-guide .sub-title,.you-not-win .tips{color:#aaa!important}#app .main .side-bar li a,#app-container .main .share-step .title,#area-list ul li dl,#article-list-index .title-holder .title,#disable-popup-modal,#disable-popup-modal .btn,#disable-popup-modal .btn-transparent,#disable-popup-modal .btn-white,#disable-popup-modal .vip-exchange .months #showMonths,#disable-popup-modal .vip-exchange .months button,#disable-popup-modal .vip-exchange .months button.disabled,#disable-popup-modal .vip-exchange a.btn.disabled,#disable-popup-modal .vip-exchange p.balance a,#disable-popup-modal .vip-exchange p.totail strong,#page-channel-detail .channel-option .modify-channel,#page-fav .fav-sidenav .favlist-title,#page-fav .fav-sidenav .num,#page-fav .fav-sidenav .watch-later,#pin-wrapper .pin-layer-header-counter .count,#vip-exchange-modal,#vip-exchange-modal .btn,#vip-exchange-modal .btn-transparent,#vip-exchange-modal .btn-white,#vip-exchange-modal .vip-exchange .months #showMonths,#vip-exchange-modal .vip-exchange .months button,#vip-exchange-modal .vip-exchange .months button.disabled,#vip-exchange-modal .vip-exchange a.btn.disabled,#vip-exchange-modal .vip-exchange p.balance a,#vip-exchange-modal .vip-exchange p.totail strong,.area-category-selector .area-category-item,.area-selector-ctnr.data-area-selector .area-selector,.ban-app .case-tip .click-btn,.ban-vote .vote-dialog .dialog-footer .blue-btn,.ban-vote .vote-dialog .dialog-footer .white-btn,.ban-vote .vote-dialog .dialog-main p,.bangumi-pagelistbox .custom-right .custom-right-inner,.bangumi-pagelistbox .p,.bangumi-pagelistbox .p.active,.bangumi-pagelistbox .p:hover,.bb-comment .comment-list .list-item .con .vote-container .text-area .text-content,.bb-comment .no-login .baffle,.bili-pay-header-wrapper .bili-pay-gift-info,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-nav-title,.bilibili-player-feedback-content .bilibili-player-feedback-default-content .bilibili-player-feedback-contact-information-input,.bilibili-player-feedback-content .bilibili-player-feedback-default-content .bilibili-player-feedback-hint,.bilibili-player-feedback-content .bilibili-player-feedback-default-content .bilibili-player-feedback-submit-wrap .bilibili-player-feedback-submit,.bilibili-player-feedback-content .bilibili-player-feedback-default-content .bilibili-player-feedback-submit-wrap .bilibili-player-feedback-submit.disable,.bilibili-player-feedback-content .bilibili-player-feedback-default-content .bilibili-player-feedback-tabmenu,.bilibili-player-feedback-content .bilibili-player-feedback-default-content .bilibili-player-feedback-version-wrap a,.bilibili-player-feedback-title,.bilibili-player-pgcinfo-follow .bilibili-player-pgcinfo-follow-binge-watching,.bp-vote-container.vote-box .create-vote .main-content .group .title .title-content,.btn-my-operate,.btn-no-my-operate,.button-box .item>button,.calendar-content .calendar-table .today,.calendar-month>a.current,.calendar-table td.current,.calendar-year>a.current,.cases-wrap.clearfix .column.col2 a,.change-song .container .iconfont,.chat-history-panel .chat-history-list .chat-item.misc-msg.guard-buy .count,.coin-dialog-mask .coin-operated .coin-bottom .coin-btn,.coin-dialog-mask .coin-operated .coin-title,.collection-bg .collection-m .content .group-list .add-group .input-group input,.collection-m .content .group-list .add-group .fav-add-tip,.collection-m .content .group-list .add-group .input-group .submit,.common-dialig-left-btn,.common-dialig-right-btn,.common-dialig-title,.confirm-window .mask .confirm-board .btn-wrap .btn.cancel,.confirm-window .mask .confirm-board .btn-wrap .btn.confrim,.confirm-window .mask .confirm-board .head,.container .play-coin-bg .play-coin .play-coin-btn,.container .play-coin-bg .play-coin .play-coin-title,.container .qr-code-bg .qr-code-box .box .qr-info,.container .qr-code-bg .qr-code-box .qr-code-title,.container .right-container .media-upper .media-upper-follow .media-upper-followed,.container .right-container .media-upper .media-upper-follow .media-upper-not-follow,.content-list.clearfix .v .t,.create-vote .button-bar .bp-button,.danmaku-report-panel,.danmaku-wrap .player-auxiliary-area .player-auxiliary-danmaku-wrap-child .player-auxiliary-panel-title,.data-overview,.date-picker-input,.datepicker.range_start.hasDatepicker .input,.draw-popup-warp .rules .title,.edit-media-list .edit-mask .default-edit .default-edit-info .default-btn-wrap .default-btn.cancel,.edit-media-list .edit-mask .default-edit .default-edit-info .default-btn-wrap .default-btn.confirm,.edit-media-list .edit-mask .default-edit .default-edit-info .info-wrap .name-input,.edit-media-list .edit-mask .default-edit .default-edit-info .info-wrap .title,.edit-media-list .edit-mask .default-edit .head,.edit-media-list .edit-mask .edit-board .edit-info .info-wrap .name-input,.edit-media-list .edit-mask .edit-board .edit-info .info-wrap .title,.edit-media-list .edit-mask .edit-board .head,.el-radio,.elecrank-wrapper .elecrank-content .rank-item .item-name,.ep-list-wrapper .ep-item,.favInfo-box .favInfo-details .fav-name,.favInfo-box .favInfo-details .fav-options .fav-play,.feedback-dialog-content .ip-info,.feedback-dialog-content .ip-local,.feedback-dialog-content .time-info,.feedback-dialog-title,.feedback-dialog-txt,.feedlist-wrapper .list-content .list-item .right .username,.float_content .selet-datebox .inpt .datepicker,.follow-dialog-wrap .follow-dialog-window .content .group-list .add-group .input-group .submit,.follow-dialog-wrap .follow-dialog-window .content .group-list .add-group .input-group input,.friend-name,.gather-wrap .cardhead .type,.gather-wrap .videos .item,.gather-wrap .videos .item a,.gather-wrap .videos .item a:hover,.gather-wrap .videos .item:hover,.gift-item.active,.gift-items.col-2 .gift-item,.group-helper-msg-list .tab-list,.group-item .name-box .name,.has-event .pika-button,.history-dlg .dlg-txt,.history-dlg .hsbtn .cancel .history-dlg .hsbtn .cancel:hover,.history-dlg .hsbtn .sure,.history-wrap .warn .btn,.is-selected .pika-button,.item-footer .button-line .button-wrapper .button-item.support .tooltip-wrapper .tooltip,.judgement .ban-app,.list-gap .list-title,.list-info .list-li .song-sort,.list-info .list-li .song-title .song-normal,.list-info .list-li .song-uname,.list-padding .list-founder,.list-row .list-unit,.list.dp-i-block.v-top .item .title,.lottery-box .title,.main-container .entry-old .btn-old,.main-container .entry-old .btn-old:hover,.main-container .entry-old .feedback .btn,.main-container .ep-list-wrapper .list-title h4,.main-container .media-info .media-right .media-desc,.main-container .media-info .media-right .media-title,.main-container .media-info .media-right .media-tool-bar .btn-follow.active,.main-container .media-info .media-right .media-tool-bar .btn-rating,.main-container .media-info .media-right .media-tool-bar .btn-rating .star-wrapper li i,.main-container .media-info .media-right .pub-wrapper .av-link,.main-container .media-info .media-right .pub-wrapper .home-link,.main-container .nav-tools .tool-item:hover,.main-container .pay-bar .vip .btn-pay.active,.main-container .plp-l .media-wrapper h1,.main-container .recom-wrapper .expand-more,.main-container .recom-wrapper .recom-title,.main-container .review-module .module-title,.main-container .review-module .review-list .review-item .review-content,.main-container .review-module .review-list .review-item .review-header .review-author,.main-container .review-module .review-list .review-item .review-title,.main-container .season-list .series-title,.main-container .season-list .ss-list-wrapper .expand-more,.main-container .season-list .ss-list-wrapper .ss-item .ss-info .ss-title,.main-container .sponsor-module .sponsor-info .btn-sponsor,.main-container .sponsor-module .sponsor-info .sponsor-count span,.main-container .tool-bar .mobile-info .mobile-more p,.main-container .tool-bar .share-info .share-more .share-wrapper .share-btn span,.main-container.clearfix .plp-r .ep-section-module .section-title,.main-content .group .bp-input .input,.main-content .group .title .slot-right .bp-selector .selector,.media-list .content .text-box .title,.media-tab-module-wrp .media-tab-module-content .sl-ep-nav-title,.mng-type-item,.narrowscreen .ov-box .title,.notification .notification-group .notification-title,.notification-content a,.p-rel.f-clear.publish-panel .textarea,.page-list-box .page-input,.page-list-box .page-item a,.pgc-list .synthetical .headline .pgc-label,.pgc-space-follow-item .pgc-item-info .pgc-item-title,.pic-item .content-wrapper .main-content .article,.pika-button,.pika-button:hover,.pika-label,.play-list .leftside-content .list-title,.play-list .leftside-content .oprate-panel .oprate-item .oprate-window .window-item,.play-list .leftside-content .play-btn,.play-list .leftside-content .upper-info .followed-btn,.play-list .leftside-content .upper-info .upper-name,.play-list .rightside-content .batch-operation .batch-btn,.play-list .rightside-content .batch-operation .cancel-batch,.play-list .rightside-content .batch-operation .clear-btn:hover,.play-list .rightside-content .batch-operation .delete-btn,.play-list .rightside-content .batch-operation .delete-btn.delete-check,.play-list .rightside-content .batch-operation .manage-btn,.play-list .rightside-content .batch-operation .manage-btn:hover,.play-list .rightside-content .source-list .source-item .collect .collect-item,.play-list .rightside-content .source-list .source-item .source-index,.play-list .rightside-content .source-list .source-item .source-info .source-name,.player-auxiliary-playlist-item-p-item,.player-auxiliary-playlist-item-title,.player-his-info .player-his-title,.player-his-main .player-his-title,.player-his-notice .player-his-title,.player-his-notice-content a,.player-his-tip .player-his-tip-title,.range-picker.dp-i-block .range,.range-picker.dp-i-block .range.active,.rank-main .rank-box .child-nav li,.rank-main .rank-box .child-nav li.active,.recommend-box .section-title .action-tab,.recommend-box .section-title .action-tab a,.recommend-box .section-title .category-name,.review-edit-header .review-edit-media-info .rate-tip,.review-edit-header .review-edit-media-info h4,.row .list-theme,.s-space .wrapper .col-full .sub-tabs span,.section-ep-wrapper .ep-item,.section-ep-wrapper .ep-item .badge,.section-item .section-text .section-index,.send-tabs-item,.share-board .list-playbtn,.share-content.plain .music-card .up-info .name,.share-step .btn-field .share-btn,.short-review-masker .short-review-content .review-body-wrap .mr-btn.active,.side-box .side-title.f-clear .action-tab,.sidebar-wrapper .sidebar .feedlist-wrapper .more,.sidebar-wrapper .sidebar .feedlist-wrapper .title,.sidebar-wrapper .sidebar .feedlist-wrapper .title .number,.song-title .container a,.sponsor-rank-item.pos-rank-module .sp-right .sp-msg,.sub-nav-m .tips,.t-center.glory-item.dp-i-block.v-middle .glory-name,.table-normal.table-styleW .feedbtn,.textarea-container .comm-tool .comm-emoji:hover .comm-text,.title .slot-right .bp-radio,.up-info .btn-panel .following-charge-btn,.up-info>a .up-name,.vc-item .item-top .detail p a.description,.video-list .tab-wrap .tab-item,.video-list .vl-hd .float_window .selet-datebox .sse a,.video-list .vl-hd .float_window .selet-datebox .sse a.on,.video-list .vl-hd .vl-hd-sub .selector-block .date-select,.vippendant-title,.winner-list,.wrapper .fav-guide .main-title,.you-not-win .title,.you-win .gift-name,li.log-item .txt-block,li.normal-item .uname,th.list-head-text{color:#eee!important}#app .main .content-wrp,#app-container .main .share-step,#app-container .main .share-success,#app-ctnr .content .nav-wrapper,#disable-popup-modal .btn,#disable-popup-modal .btn-transparent,#disable-popup-modal .btn-transparent:hover,#disable-popup-modal .btn-white,#disable-popup-modal .btn-white:hover,#disable-popup-modal .btn:hover,#disable-popup-modal .vip-exchange .months,#disable-popup-modal .vip-exchange .title,#disable-popup-modal .vip-exchange a.btn.disabled,#disable-popup-modal .vip-exchange p.totail,#edit-page .original-editor-wrap,#page-channel-detail .channel-detail .channel-action-row .be-dropdown,#page-fav .fav-main .favList-info,#page-fav .fav-sidenav .watch-later,#vip-exchange-modal .btn,#vip-exchange-modal .btn-transparent,#vip-exchange-modal .btn-transparent:hover,#vip-exchange-modal .btn-white,#vip-exchange-modal .btn-white:hover,#vip-exchange-modal .btn:hover,#vip-exchange-modal .vip-exchange .months,#vip-exchange-modal .vip-exchange .title,#vip-exchange-modal .vip-exchange a.btn.disabled,#vip-exchange-modal .vip-exchange p.totail,.area-category-selector,.area-panel,.area-selector-ctnr.data-area-selector .area-selector,.ban-vote .vote-dialog .dialog-footer .white-btn,.bangumi-pagelistbox .custom-right .custom-right-inner.custompage,.bangumi-pagelistbox .p,.bangumi-pagelistbox .p.active,.bangumi-pagelistbox .p:hover,.bili-pay-payment-wrapper-gift,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-nav-header,.bilibili-player-feedback,.bilibili-player-feedback-content .bilibili-player-feedback-default-content .bilibili-player-feedback-contact-information-input,.bilibili-player-feedback-title,.bp-upload:before,.bp-vote-container.vote-box .create-vote,.btn-my-operate,.button-bar:before,.change-content .feed-wrap .feed-tag .card,.chat-input-ctnr.p-relative .chat-input,.coin-dialog-mask .coin-operated .coin-bottom .coin-btn,.coin-dialog-mask .coin-operated .coin-bottom .coin-btn:hover,.common-dialig-left-btn,.confirm-window .mask .confirm-board .btn-wrap .btn.cancel,.confirm-window .mask .confirm-board .head,.container .right-container .media-upper .media-upper-follow .media-upper-followed,.date-picker-input,.datepicker.range_start.hasDatepicker .datepicker-popup,.datepicker.range_start.hasDatepicker .input,.dlg-contain .history-dlg,.edit-media-list .edit-mask .default-edit .default-edit-info .default-btn-wrap .default-btn.cancel,.edit-media-list .edit-mask .default-edit .default-edit-info .info-wrap .name-input,.edit-media-list .edit-mask .default-edit .head,.edit-media-list .edit-mask .edit-board .edit-info .info-wrap .name-input,.edit-media-list .edit-mask .edit-board .head,.emoji-box .static-popup,.feed-topic .hot-content .card.card-offset,.feed-topic .separater-line,.feedback-dialog-title,.follow-dialog-wrap .follow-dialog-window .content .group-list .add-group .input-group .submit,.gather-wrap .cardhead .type,.gather-wrap .videos .item,.gather-wrap .videos .item:hover,.history-dlg .hsbtn .cancel,.history-dlg .hsbtn .cancel:hover,.item-footer .button-line .button-wrapper .button-item.support .tooltip-wrapper .tip-arrow,.item-footer .button-line .button-wrapper .button-item.support .tooltip-wrapper .tooltip,.link-tag.custom,.link-tag.default,.link-tag.origin,.lottery-box,.main-container .entry-old .btn-old,.main-container .entry-old .btn-old:hover,.main-container .ep-list-wrapper .list-wrapper.simple ul .ep-item,.main-container .media-info .media-right .media-tool-bar .btn-rating,.main-container .nav-tools .tool-item,.main-container .nav-tools .tool-item:hover,.main-container .pay-bar .vip .btn-pay.active,.main-container .tool-bar .mobile-info .mobile-more,.main-container .tool-bar .share-info .share-more,.main-content .list .all-list .pic-item,.main-content .list .all-list .pic-item .footer-wrapper,.main-content .list .all-list .vc-item,.main-content .list .all-list .vc-item .footer-wrapper,.media-tab-module-content .sl-ep-list .section-item,.narrowscreen .ov-box,.original-card-content .media-list .content,.p-rel.f-clear.publish-panel .textarea,.page-list-box .active,.page-list-box .page-input,.page-list-box .page-item,.page-list-box .page-item:hover,.pgc-list .synthetical .headline .pgc-label,.pika-table thead,.play-list .leftside-content .oprate-panel .oprate-item .oprate-window,.play-list .leftside-content .oprate-panel .oprate-item .oprate-window .window-item,.play-list .rightside-content .batch-operation .batch-btn,.play-list .rightside-content .batch-operation .clear-btn:hover,.play-list .rightside-content .batch-operation .delete-btn.delete-check,.play-list .rightside-content .source-list .source-item .collect,.play-list .rightside-content .source-list .source-item .collect .collect-item:first-child,.player .bilibili-player-video-bottom-area .bilibili-player-video-sendbar,.player-auxiliary-area .player-auxiliary-panel-title,.popup-content-ctnr .content .report-input,.recommend-box .section-title .action-tab,.room-introduction .edit-button,.row .list-comment,.row .list-info,.send-tabs,.send-tabs-item,.send-wrapper,.setting .follow-setting,.share-content.plain .music-card .media-list.share-media-list .content,.short-review-masker .short-review-content .review-body-wrap,.side-box .side-title.f-clear .action-tab,.sidebar-wrapper .sidebar .feedlist-wrapper,.sidebar-wrapper .sidebar .profile-wrapper .img-wrapper,.sidebar-wrapper .sidebar .profile-wrapper .info-wrapper,.sponsor-rank-item.pos-rank-module .sp-right .sp-msg,.sub-nav-m .tips,.up-info .btn-panel .charge-btn,.up-info .btn-panel .following,.video-list .vl-hd .float_window,.video-list .vl-hd .float_window .close,.video-list .vl-hd .float_window .close:hover{border-color:transparent!important}.ban-vote .vote-dialog .dialog-header,.core-player-auxiliary-area,.core-player-filter,.core-player-video-control,.face-buy-item,.face-buy-price,.item-footer .button-line .button-wrapper .button-item,.tags-inner-ctnr.dp-i-block.v-top.border-box .area-tag-item,.wrap .state-null>.txt{border-color:#aaa!important}#disable-popup-modal .vip-exchange .months #showMonths,#page-channel-detail .channel-add-video,#vip-exchange-modal .vip-exchange .months #showMonths,.container .qr-code-bg .qr-code-box .qr-code-title,.elecrank-header,.gather-wrap .gather,.jumping-ctnr .jumping-input,.left-container .play-options .play-options-ul .share-box .or-code,.main-container .media-info,.main-container .plp-l .comment-wrapper,.main-container .review-module,.main-container .sponsor-module,.play-list .leftside-content .oprate-panel,.play-list .rightside-content .source-list .source-item .source-right,.player-his-tip .player-his-tip-des,.player-his-tip-date .player-his-round,.video-list .vl-hd .float_window .float_content h3{border-color:#444!important}.chat-history-panel .chat-history-list .chat-item.danmaku-item[class*=guard-level-]:before,.chat-history-panel .chat-history-list .chat-item.danmaku-item[class*=week-all-area-top-]:after,.chat-history-panel .chat-history-list .chat-item.danmaku-item[class*=week-all-area-top-]:before{border-image:none!important}.area-list-item.dp-i-block.t-over-hidden.t-nowrap.v-top.border-box.a-move-in-left.ts-dot-2 .live-icon-16,.is-rtl .pika-next,.is-rtl .pika-prev,.link-btn-ctnr.dp-i-block.v-middle .my-link-btn .icon,.link-navbar .main-ctnr .nav-logo,.pika-next,.pika-prev,.video-list .vl-hd .float_window .close{filter:brightness(0) invert(1)!important}#app .header .close:hover,#disable-popup-modal .modal-close,#vip-exchange-modal .modal-close,.aside-area-toggle-btn .btn-ctnr .restore-btn,.bb-comment .comment-list .list-item .text .vote-link img,.bp-input .option-delete,.channel-item.channel-add-video .add-covers-meta #browser-version-tip #close-browser-tip,.channel-item.channel-add-video .add-covers-meta .icon,.collection-m .content .group-list .add-group .fav-add-tip .blue-arrow,.edit-media-list .edit-mask .default-edit .default-edit-info .media-list-type .icon-check,.edit-media-list .edit-mask .edit-board .edit-info .media-list-type .icon-check,.face-buy-close,.face-buy-item.active,.helper-btn.active:before,.home-wrap .home-suggest .title .delete-history .icon-garbage,.icon-vote-create-btn.active,.main-content .group .bp-add-button .add-icon,.pin-layer-body .pin-layer-search #browser-version-tip #close-browser-tip,.pin-layer-body .pin-layer-search .icon,.pin-layer-header #browser-version-tip #close-browser-tip,.pin-layer-header .icon,.popup-content-ctnr .content .selector-box .type-selector .radio-selected,.slidesjs-pagination li a.active,.slidesjs-pagination li a:hover,.v-filter-line.clearfix .item.style .icon{filter:var(--blue-image-filter)!important}.z-top-container .b-icon{filter:var(--pink-image-filter)!important}#app-container .main .share-step,#app-container .main .share-success,.main-container .entry-old .feedback .btn,.section-block .publish-panel .emoji-box,.video-list .vl-hd .float_window .close:hover{box-shadow:none!important}.bp-vote-container.vote-box .create-vote,.button-box .item .group-helper-msg-list,.container .left-container .play-options .play-options-more .play-options-content .play-option:hover,.datepicker.range_start.hasDatepicker .datepicker-popup,.emoji-box .static-popup,.item-footer .button-line .button-wrapper .button-item.support .tooltip-wrapper .tooltip,.left-container .play-options .play-options-ul .share-box,.narrowscreen .ov-box,.play-list .leftside-content .oprate-panel .oprate-item .oprate-window,.play-list .rightside-content .source-list .source-item .collect,.sub-nav-m .tips,.video-list .vl-hd .float_window{box-shadow:0 1px 10px 0 var(--theme-color-30)!important}.textarea{transition:.2s}#disable-popup-modal .vip-exchange .selector li:first-child,#page-channel-detail .channel-add-video:hover,#vip-exchange-modal .vip-exchange .selector li:first-child,.area-group-item.checked,.bangumi-pagelistbox .custom-right .custom-right-inner.custompage:hover,.coin-dialog-mask .coin-operated .mc .mc-box,.collection-m .content .group-list .add-group .input-group,.comment-bilibili-con .con input[type=radio]:checked+label:before,.container .live,.container .play-coin-bg .play-coin .play-coin-content .play-one-coin.active,.container .play-coin-bg .play-coin .play-coin-content .play-one-coin:hover,.date-picker-input.active,.editor.active,.editor:focus,.editor:hover,.el-radio__inner:hover,.el-radio__input.is-checked .el-radio__inner,.face-buy-item.active,.face-buy-item:hover,.follow-dialog-wrap .follow-dialog-window .content .group-list .add-group .input-group,.gift-item.active .gift-img,.group-item .name-box .operate-btn,.group-item .operate-btn,.live-item .live-item-link .live-img-box .hover-panel .live-bg-merge .live-item-mark,.main-container .ep-list-wrapper .list-wrapper.simple ul .ep-item.cursor,.main-container .ep-list-wrapper .list-wrapper.simple ul .ep-item:hover,.p-rel.f-clear.publish-panel .textarea:focus-within,.report-image-candidate-ctnr.t-center .upload-hint,.score-progress-bar.dp-i-block.v-middle.p-relative .progress-bar-core.p-absolute,.send-tabs-item-active,.stick.true-love .medal-level,.sub-area em.active,.sub-area em:hover,.sub-tabs a.active,.sub-tabs a.active:before,.tab-list .tab-item.active:before,.tags-inner-ctnr.dp-i-block.v-top.border-box .area-tag-item:hover,.textarea.active,.textarea:focus,.textarea:hover,.video-list .tab-wrap .tab-item.active,.video-list .vl-hd .float_window .selet-datebox .sse,.video-list .vl-hd .float_window .selet-datebox .sse a,.video-list .vl-hd .vl-hd-sub .selector-block .date-select:hover,input[type=radio]:checked+.custom-radio{border-color:var(--theme-color)!important}.tab-wrap .tab-item.active:after{border-bottom-color:var(--theme-color)!important}#disable-popup-modal .btn-transparent:hover,#disable-popup-modal .btn-white:hover,#disable-popup-modal .btn:hover,#disable-popup-modal .vip-exchange .months button:hover,#page-channel-detail .channel-option .modify-channel:hover,#vip-exchange-modal .btn-transparent:hover,#vip-exchange-modal .btn-white:hover,#vip-exchange-modal .btn:hover,#vip-exchange-modal .vip-exchange .months button:hover,.aside-area-toggle-btn .btn-ctnr:hover .btn-slider,.ban-app .case-tip .click-btn:hover,.ban-vote .vote-dialog .dialog-footer .blue-btn,.ban-vote .vote-dialog .dialog-footer .blue-btn:hover,.bangumi-pagelistbox .p.active,.bangumi-pagelistbox .p:hover,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-part-item[data-state-play=true] .bilibili-player-playlist-plist-play,.bilibili-player-feedback-content .bilibili-player-feedback-default-content .bilibili-player-feedback-submit-wrap .bilibili-player-feedback-submit,.bilibili-player-feedback-content .bilibili-player-feedback-default-content .bilibili-player-feedback-submit-wrap .bilibili-player-feedback-submit.disable:hover,.bilibili-player-feedback-content .bilibili-player-feedback-default-content .bilibili-player-feedback-submit-wrap .bilibili-player-feedback-submit:hover,.btn-no-my-operate,.calendar-month>a.current,.calendar-table td.current,.calendar-year>a.current,.coin-dialog-mask .coin-operated .coin-bottom .coin-btn:hover,.collection-m .content .group-list .add-group .fav-add-tip,.comment-bilibili-con .con label:after,.common-dialig-right-btn,.confirm-window .mask .confirm-board .btn-wrap .btn.confrim,.container .play-coin-bg .play-coin .play-coin-btn:hover,.container .right-container .media-upper .media-upper-follow .media-upper-not-follow,.container .right-container .media-upper .media-upper-follow .media-upper-not-follow:hover,.danmaku-item.pointer .custom-radio:after,.edit-media-list .edit-mask .default-edit .default-edit-info .default-btn-wrap .default-btn.confirm,.edit-media-list .edit-mask .edit-board .edit-info .submit-btn,.edit-media-list .edit-mask .edit-board .edit-info .submit-btn:hover,.el-radio__input.is-checked .el-radio__inner,.ep-list-wrapper .ep-item .badge.pink,.favInfo-box .favInfo-details .fav-options .fav-play:hover,.gather-wrap .videos .item:hover,.has-event .pika-button,.history-dlg .hsbtn .sure,.history-dlg .hsbtn .sure:hover,.history-wrap .warn .btn:hover,.is-selected .pika-button,.live-item .live-item-link .live-img-box .hover-panel .live-bg-merge .live-item-mark .white-dot,.main-container .entry-old .btn-old:hover,.main-container .entry-old .feedback .btn,.main-container .entry-old .feedback .btn:hover,.main-container .media-info .media-right .media-tool-bar .btn-follow,.main-container .media-info .media-right .media-tool-bar .btn-follow:hover,.main-container .media-info .media-right .media-tool-bar .btn-rating:hover,.main-container .nav-tools .tool-item:hover,.main-container .pay-bar .sponsor .btn-pay:hover,.main-container .season-list .ss-list-wrapper .ss-item .ss-cover .ss-badge.pink,.main-container .sponsor-module .sponsor-info .btn-sponsor,.page-container.p-rel .tab-nav .line,.page-list-box .active,.page-list-box .page-item:hover,.pgc-space-follow-item a.pgc-item-cover .badge.type_0,.play-list .leftside-content .play-btn,.play-list .leftside-content .play-btn:hover,.play-list .rightside-content .batch-operation .cancel-batch,.play-list .rightside-content .batch-operation .cancel-batch:hover,.play-list .rightside-content .batch-operation .clear-btn:hover,.play-list .rightside-content .batch-operation .delete-btn.delete-check,.play-list .rightside-content .batch-operation .manage-btn,.play-list .rightside-content .batch-operation .manage-btn:hover,.player-his-nav.active,.player-his-title div,.radio-icon.checked:before,.rank-main .rank-box .child-nav li.active,.section-ep-wrapper .ep-item .badge.pink,.share-board .list-playbtn,.share-board .list-playbtn:hover,.share-step .btn-field .clickable,.short-review-masker .short-review-content .review-body-wrap .mr-btn.active,.short-review-masker .short-review-content .review-body-wrap .mr-btn.active:hover,.sidebar-wrapper .sidebar .feedlist-wrapper .more:hover,.tab-list .tab-item.active:after,.up-info .btn-panel .following-charge-btn:hover,.video-list .vl-hd .float_window .selet-datebox .sse a.on,ul.navigation li span:after{background-color:var(--theme-color)!important}#app .main .side-bar li a.router-link-active,#app .main .side-bar li a:hover,#area-list ul li dl:hover,#disable-popup-modal .vip-exchange .selector li.current p.cost,#disable-popup-modal .vip-exchange .selector li:hover,#disable-popup-modal .vip-exchange .selector li:hover p.cost,#disable-popup-modal .vip-exchange p.balance a:hover,#dyn_wnd .dyn_list a:hover,#page-channel-detail .channel-add-video:hover .text,#pin-wrapper .pin-layer-video-empty a,#vip-exchange-modal .vip-exchange .selector li.current p.cost,#vip-exchange-modal .vip-exchange .selector li:hover,#vip-exchange-modal .vip-exchange .selector li:hover p.cost,#vip-exchange-modal .vip-exchange p.balance a:hover,.all-hot-list-warp .pager .pages .page-item button:hover,.all-hot-list-warp .pager .pages .page-item.active button,.area-category-selector .area-category-item.active,.area-group-item.checked,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-item:hover .bilibili-player-playlist-info-title,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-nav-loop.bppl-state-selected,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-nav-loop:hover,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-nav-ownername:hover,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-nav-positive.bppl-state-selected,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-nav-positive:hover,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-nav-random.bppl-state-selected,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-nav-random:hover,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-nav-reverse.bppl-state-selected,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-nav-reverse:hover,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-nav-title:hover,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-order-play,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-part-item:hover,.bilibili-player-feedback-content .bilibili-player-feedback-default-content .bilibili-player-feedback-version-wrap a:hover,.block-wrap #activity .activity-info a,.block-wrap #activity .activity-info a:hover,.bp-add-button,.btn-my-operate:hover,.button-box .item>button.active,.calendar-header>a:hover,.card .focus-btn .focus .focus-text:hover,.cases-wrap.clearfix .column.col2 a:hover,.coin-dialog-mask .coin-operated .coin-title span,.coin-dialog-mask .coin-operated .mc .mc-box .c-num,.container .left-container .play-options .play-options-ul li .blue,.container .live,.container .play-coin-bg .play-coin .play-coin-content .play-one-coin.active,.container .play-coin-bg .play-coin .play-coin-title .play-coin-number,.content-list.clearfix .v:hover .t,.count-wrapper div.up-info a:hover,.creation-li .creation-right .creation-theme .creation-link:hover,.danmaku-report-panel .danmaku-content,.detail-content p span a,.edit-media-list .edit-mask .default-edit .default-edit-info .media-list-type .blue-icon,.edit-media-list .edit-mask .edit-board .edit-info .media-list-type .blue-icon,.ep-list-wrapper .ep-item i,.ep-list-wrapper .ep-item.cursor,.face-buy-item.active,.face-buy-item:hover,.face-buy-price a,.favInfo-box .favInfo-details .fav-name:hover,.favInfo-box .favInfo-details .fav-options .meta.selected,.feedlist-wrapper .list-content .list-item:hover .right .username,.group-item .name-box .operate-btn,.group-item .operate-btn,.item-footer .button-line .button-wrapper:hover .button-item .label,.item-footer .button-line .button-wrapper:hover .button-item .num,.link-navbar .nav-item:hover .icon-font,.list-info .list-li .song-title .song-collection.font-blue,.list-info .list-li .song-title .song-float:hover,.live-item .live-item-link .live-img-box .hover-panel .live-bg-merge .live-item-mark,.lottery-notice-cntr .win .uname,.main-container .ep-list-wrapper .list-title .mode-change:hover,.main-container .ep-list-wrapper .list-wrapper.simple ul .ep-item.cursor,.main-container .ep-list-wrapper .list-wrapper.simple ul .ep-item:hover,.main-container .media-info .media-right .media-title:hover,.main-container .media-info .media-right .pub-wrapper .av-link:hover,.main-container .media-info .media-right .pub-wrapper .home-link:hover,.main-container .review-module .review-list .review-item .review-header .review-author:hover,.main-container .review-module .review-list .review-item:hover .review-title,.main-container .season-list .ss-list-wrapper .ss-item .ss-info .ss-title:hover,.main-container .tool-bar .coin-info.active i,.main-container .tool-bar .coin-info.active span,.main-container .tool-bar .coin-info:hover i,.main-container .tool-bar .coin-info:hover span,.main-container .tool-bar .mobile-info .mobile-more p a,.main-container .tool-bar .mobile-info:hover i,.main-container .tool-bar .mobile-info:hover span,.main-container .tool-bar .share-info .share-more .share-wrapper .share-btn:hover i,.main-container .tool-bar .share-info .share-more .share-wrapper .share-btn:hover span,.main-container .tool-bar .share-info:hover>i,.main-container .tool-bar .share-info:hover>span,.mng-type-item.active,.mvp-info .user-info .title,.notification-content .address,.notification-content a:hover,.pgc-space-follow-item .pgc-item-info .pgc-item-title:hover,.pic-item .content-wrapper .main-content .article:hover,.play-list .leftside-content .list-title:hover,.play-list .leftside-content .oprate-panel .oprate-item .oprate-window .window-item:hover,.play-list .leftside-content .upper-info .upper-name:hover,.play-list .rightside-content .batch-operation .all-checked,.play-list .rightside-content .source-list .source-item .collect .collect-item:hover,.play-list .rightside-content .source-list .source-item .more-oprate:hover,.play-list .rightside-content .source-list .source-item .source-checked,.play-list .rightside-content .source-list .source-item .source-info .source-name:hover,.play-list .rightside-content .source-list .source-item .source-info .source-upper-name:hover,.player-auxiliary-area .player-auxiliary-panel-title .player-auxiliary-panel-close:hover,.player-auxiliary-playlist-item-p-item:hover,.player-auxiliary-playlist-item.player-auxiliary-playlist-item-active .player-auxiliary-playlist-item-title,.player-his-nav:hover,.player-his-notice-content a:hover,.profile-wrapper .info-wrapper .relationship .followings:hover,.rank-main .rank-box .child-nav .nav-remind,.rank-main .rank-box .child-nav li:hover,.recommend-box .section-title .action-tab a:hover,.recommend-box .section-title .action-tab a:hover .icon-font,.recommend-box .section-title .action-tab:hover,.recommend-box .section-title .action-tab:hover .icon-replace,.row .col-4-med.col-4 .pager .pages .page-item button:hover,.row .col-4-med.col-4 .pager .pages .page-item.active button,.s-space .wrapper .col-full .sub-tabs.clearfix a:hover,.section-ep-wrapper .ep-item i,.section-ep-wrapper .ep-item.cursor,.section-item:hover .section-text .section-index,.section-item:hover .section-text .section-title,.seeds-wrap .item.btn,.send-tabs-item-active,.short-review-masker .short-review-content .dialog-close:hover,.short-review-masker .short-review-content .mr-long-review,.side-box .side-title.f-clear .action-tab:hover,.side-box .side-title.f-clear .action-tab:hover .icon-replace,.sub-area em.active,.sub-area em:hover,.table-normal.table-styleW .feedbtn:hover,.tags-inner-ctnr.dp-i-block.v-top.border-box .area-tag-item:hover,.up-info .btn-follow-up,.up-info .u-info .name .message:hover,.up-info .u-info .name .message:hover i,.up-info>a .up-name:hover,.vc-item .item-top .detail p a.description:hover,.vc-item .item-top .detail p a.tag,.video-info .video-data .a-crumbs a:hover,.video-list .tab-wrap .tab-item.active,.winner-list .list-wrap .title,li.normal-item a:hover .uname{color:var(--theme-color)!important}.sub-tabs a.active:before{border-left-color:transparent!important;border-right-color:transparent!important}#bili-data-center .version-switch-section,.advice-dialog-wrapper .input-style,.advice-dialog-wrapper .submit-btn,.article-info-module,.bili-dialog-bomb .appeal-box .header,.bili-dialog-bomb .appeal-box .submit,.bili-dialog-bomb .appeal-box .wrap .container,.bp-emoji-box .static-popup,.cc-article-wrp .article-card .meta-title .typename,.cc-content-body .select-box,.cc-content-body .select-box .option-footer,.collection-bg .collection-board .collection-submit,.common .bb-comment .no-login .baffle .b-btn,.dc-page .version-switch-section,.enter-failure,.error-body .error-container .error-panel .audio-split,.error-body .error-container .song-wrap .change-song,.error-body .error-container .song-wrap .image-split,.face-container .pendant-list li,.face-container .pendant-list li>div,.face-container .record-table thead th,.feedback-mask .content .feedback-body .feedback-submit,.float_window,.home-pc .dialog .footer .apply-btn,.info-line .status-attend.status-attend-hover,.info-line .status-no-attend,.link-tag-box .selector-wrap ul>li:hover,.live-user .user-item .item-right .status,.m-layer.m-button,.m_layer.m-button,.main-container .media-info .media-right .media-desc i,.mask .popup-container .btn-primary,.normal-v2-container .normal-title-wrp>.template-op>.template-op-divide,.pendant-mask .pendant-box .pendant-main .price-btn,.protocol-modal .modal-wrap .modal-content .text-content,.read-list-page .read-list-name .info.right.show .col .split-line,.read-list-page .read-list-name .info.right.show .right-float .ui-btn.grey-radius .menu-list,.read-list-page.edit-page .read-list-name .cover,.regist .toolbox,.result.is-web .vote-result-comment,.right-container.f-left .active-panel .show-more-button,.section-block .bp-emoji-box .static-popup,.security-right-bottom .face-tool .tool-container .tool-uninstall-pendant,.share-board .song-share .song-share-ul li:hover,.song-info .info-wrap .type-list .item-list .type-item,.song-info .info-wrap .type-list .musicHoverType,.ssr-content .link-tag.activity,.tab-selector-wrap .selector-wrap ul>li:hover,.text-article-wrp .article-card .meta-title .typename,.text-article-wrp .article-card .meta-view .appeal,.text-article-wrp .article-card .meta-view .data,.text-article-wrp .article-card .meta-view .menu,.text-article-wrp .article-card .meta-view .menu-list,.text-article-wrp .article-card .meta-view .meta-item.text-item,.text-article-wrp .article-card .meta-view .option,.ui-popup.popup-cover .bili-btn.cancel,.ui-widget-header,.video-card .labels-ctnr{background-color:#222!important}.content .link-tag-box,.content .tab-selector-wrap,.danmaku-wrap .player-auxiliary-area .player-auxiliary-danmaku-management,.home-pc .application .application-body .btn-color,.live-user .user-item .item-right .tags>span,.vl-hd-sub .selector-block .b-slt .list li:hover{background-color:#333!important}#app .el-button.is-disabled,#app .el-button.is-disabled:focus,#app .el-button.is-disabled:hover,#pgc-navigate-wrap .ep-box .ep-sub .ep-item,#pgc-navigate-wrap .play-btn,.abnormal-module .abnormal-item .btn-back,.advice-dialog-wrapper,.bangumi-list .bangumi-item .right-info .headline .bangumi-label,.bili-dialog-bomb .appeal-box .submit .cancel,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-filter .bilibili-player-filter-btn.active,.block-area .follow-wrapper .follow-head .follow-more,.cards-block .modal-wrap .btn-group button,.carousel-wrp .panel .pic li,.cc-container .nav-search .dropdown-btn,.cc-content-body .select-box .option-footer:hover,.cc-content-body .select-box .select-item:hover,.collection-bg .collection-board,.container-left .answer-container,.content .rank-list,.cropper-modal .modal,.customize-wrp .customize-tab,.detail-wrp .detail-empty,.emoji-box .emoji-tabs .tab-link:hover,.enter-failure .bl-button--primary:disabled,.enter-failure .link-input,.error-container .video-details p.num,.home-pc .application,.info-wrap .feedback-mask .content,.link-tag-box .selector-wrap,.link-tag-box .selector-wrap ul,.list-container .article-list-block,.list-container .list-info-block,.live-category .category,.live-user .user-item,.main-ctnr .qualify-drawer .drawer-pop,.pendant-mask .pendant-box,.pendant-mask .pendant-box .pendant-header,.pgc-list .pgc-item .right-info .headline .pgc-label,.popup-content-ctnr .report-input,.read-list-modal-component .creat-read-list-box .input-box button,.read-list-modal-component .creat-read-list-box .input-box button[disabled],.read-list-page .module-box,.read-list-page.edit-page .module-box,.report-wrap-module .code-input.el-input .el-input__inner,.report-wrap-module .form-group .el-input-group>.el-input__inner,.report-wrap-module .form-group .el-input__inner,.selet-datebox .inpt a.b-btn,.selet-datebox .inpt input[type=text],.selet-datebox .sse a:hover,.setting .public-setting .public-wrp .button-wrap .btn-text.ok.is-disable,.setting .public-setting .public-wrp .setting-item .circle-wrap,.share-board .share-btn,.share-board .song-share .song-share-ul,.share-wrap .content-wrap .input-wrap input,.song-coin-bg .song-coin,.tab-selector-wrap .selector-wrap,.tab-selector-wrap .selector-wrap ul,.tag.sky-blue,.tag.sky-blue:hover,.text-article-wrp .article-card,.text-article-wrp .head-stat,.ui-popup .popup-wrap,.ui-widget-content,.up-info .btn-panel .charge-btn,.vd-list.l3 li .l-item,.video .video-topic .video-list,.view-later-module .bilibili-player .bilibili-player-auxiliary-area .bilibili-player-watchlater-item:hover,.view-later-module .bilibili-player .bilibili-player-auxiliary-area .bilibili-player-watchlater-item[data-state-play=true],.vl-hd-sub .selector-block .b-slt,.vl-hd-sub .selector-block .b-slt .list{background-color:#444!important}.follow-main .list-item:hover{background-color:#3d3d3d!important}.ssr-content .cntr .check-all-ctn{background-image:linear-gradient(rgba(242,243,245,0),#222 40%,#222)!important}.ui-state-active,.ui-state-default,.ui-state-focus,.ui-state-hover,.ui-widget-content,.ui-widget-content .ui-state-active,.ui-widget-content .ui-state-default,.ui-widget-content .ui-state-focus,.ui-widget-content .ui-state-hover,.ui-widget-header .ui-state-active,.ui-widget-header .ui-state-default,.ui-widget-header .ui-state-focus,.ui-widget-header .ui-state-hover{background-image:none!important}.comment-list-item .ci-action span.date,.header-info-ctnr .normal-mode .area-link:active,.list-container .list-info-block .right-side .col .split-line,.main-ctnr .qualify-drawer .draw-list,.p-relative.rank-list-section.z-rank-list .rank-list-ctnr,.rank-list-ctnr a,.rank-list-ctnr a:hover,.read-list-page .read-list-name .info.right.show .right-float .ui-btn.grey-radius .menu-list .menu-item:hover,.tab-bg.w-100.bg-white,.text-article-wrp .article-card .meta-view .menu-list .menu-item:hover,.ui-datepicker .ui-datepicker-header,.ui-state-default,.ui-widget-content .ui-state-default,.ui-widget-header .ui-state-default,.vd-list li .l-item,.view-later-module .up-info-module,.view-later-module .video-box-module,.view-later-module .video-info-module .number .fav i{background-color:transparent!important}#member-container:hover::-webkit-scrollbar,#member-container:hover::-webkit-scrollbar-track,.cc-body .home-wrap .card,.gift-rank-cntr .rank-cntr .item.own,.list-container .article-list-block .article-item,.original-editor-wrap .float-toolbar .toolbar-list,.register-container .report-wrap-module .back-fff,.text-article-wrp .head-stat .section .count,.ui-widget-header,.view-later-module .read-list-modal-component .mask,.view-later-module .video-info-module .number .coin i,.view-later-module .video-info-module .number .fav i{background:0 0!important}#dc-section_behavior .follow-tool-box .follow-line-legend .legend-item .legend-text,#dc-section_summary .source-rank-list-item .video-info-pubdate,#navigator .v-switcher-header-item a span,#page-article .article-lists .lists-item .item-right .item-info span,#page-article .article-lists .lists-item .item-right .item-title,#page-setting .setting-privacy-item .setting-privacy-switcher .be-switch-label,.abnormal-module .abnormal-item .txt,.article-card .article-info .data,.article-card .article-info .data a,.article-info-module .v-data span,.article-info-module .v-info,.article-list-holder-block .article-list-name,.article-net-charts .area .empty-tips,.bangumi-info-module .v-data span,.bangumi-info-module .v-preview .desc,.bangumi-list .bangumi-item .right-info .intros .label,.bangumi-list .bangumi-item .right-info .intros .value,.bangumi-media .bangumi-media-body .review-empty-wrapper .empty-info,.bili-dialog-bomb .appeal-box .wrap .container .img-text,.bili-dialog-bomb .appeal-box .wrap .container .textarea .textarea-wrap .limit,.block-wrap .classify .position,.cards-block .cards-list .card-item .card-case .other label,.carousel-wrp .panel .pic li a .card-info .detail,.case-list .info .comment,.case-list .info .jury-time,.cc-article-wrp .article-card .meta-footer .view-stat,.cc-article-wrp .article-card .meta-status .pubdate,.cc-container .tips,.collection-bg .collection-board .collection-list .collection-li .collection-attr,.comment-list-item .ci-action,.comment-list-item .ci-parent-reply .cipr-footer,.container .form-group .form-message,.coupon-content-con .coupon-time,.coupon-content-con .coupon-type,.data-card .data-wrp .tab .fan-tab,.data-card .data-wrp .tip p,.data-card .fans-wrp .tab .fan-tab,.data-card .fans-wrp .tip p,.detail-wrp .detail-header .article-link,.detail-wrp .detail-header .tips,.el-breadcrumb__item:last-child .el-breadcrumb__inner,.el-breadcrumb__item:last-child .el-breadcrumb__inner a,.el-breadcrumb__item:last-child .el-breadcrumb__inner a:hover,.el-breadcrumb__item:last-child .el-breadcrumb__inner:hover,.error-body .error-container .error-panel .error-clue,.error-body .error-container .msg-text,.error-body .error-container .song-wrap .song-list .song-li .content .num,.follow-item .details .ep-info,.follow-item .details .ep-intro,.game-item-container .game-package-item .game-package-gift,.game-item-container .game-package-item .game-package-price,.home-pc .application .application-body .fjw-tip,.home-pc .application .application-foot p,.home-pc .application .application-header p,.home-wrap .data-card .data-wrp .total,.home-wrap .data-card .fans-wrp .total,.list-container .list-info-block .right-side .col,.list-container .list-info-block .right-side .summary,.live-user .user-item .item-right .info .star,.live-user .user-item .item-right .info .type,.option-content-wrapper .desc .option-vote,.pendant-list li .pendant-expire,.pendant-main .final-price,.pendant-main .point-info,.pendant-main .unit-price li,.pgc-list .pgc-item .right-info .intros .label,.pgc-list .pgc-item .right-info .intros .value,.player-his-main .player-his-tip-date,.r-con .members-info .up-card .info-title,.read-list-component .empty-state .empty-tips,.read-list-modal-component .tips,.read-list-modal-component .tips.input-tips,.read-list-page .add-article-modal .article-list-box li label span.uptime,.read-list-page .add-article-modal .module-tips,.read-list-page .module-box .module-tips,.read-list-page.edit-page .read-list-name .cover .empty-state,.read-list-page.edit-page header.header .link-btn,.rule-description p,.section.album .album-item .meta-col,.section.article .article-content .meta-col,.security-right .my-package-ruls p,.share-board .share-btn .bili-share div,.share-wrap .content-wrap .qr-wrap .qr-title,.song-coin-bg .song-coin .song-coin-exp,.steps .step-operate,.text-article-wrp .article-card .meta-footer .view-stat,.text-article-wrp .article-card .meta-status .pubdate,.text-article-wrp .article-card .meta-view .meta-item .icon-font,.text-article-wrp .article-card .meta-view .meta-item .iconfont,.text-article-wrp .head-stat .section .diff-wrp .diff-text,.text-article-wrp .head-stat .section .diff-wrp .diff-yeaterday,.ui-input-text .count,.ui-popup .popup-wrap .text-box .subtext,.ui-popup .popup-wrap .text-box .text .sub-tips,.upload-cover-wrapper .upload-cover-suggest,.vd-list li .l-r .up-info .v-author,.vd-list li .l-r .up-info .v-date,.vd-list li .v-desc,.vd-list li .v-info .v-info-i,.video-card .icons-label .text,.video-card .labels-ctnr,.video-detail .item-number,.video-detail .item-time,.video-info-module .v-data span,.video-info-module .v-info,.video-info-module .v-preview .txt,.view-later-module .bilibili-player .bilibili-player-auxiliary-area .bilibili-player-watchlater-info-other,.view-later-module .bilibili-player .bilibili-player-auxiliary-area .bilibili-player-watchlater-nav-header,.view-later-module .up-info-module .number,.view-later-module .video-info-module .tm-info,.view-later-module .video-info-module .tm-info .btn-appeal,.view-later-module .video-info-module .tm-info a,.view-later-module .video-info-module .tm-info time,.vote-info-wrapper .user-name .text{color:#aaa!important}#navigator .v-switcher-header-item a,#page-article .article-lists .lists-item .item-right .item-name,#page-fav .fav-main .fav-action-bottom .search-results-num,#pgc-navigate-wrap .ep-box .ep-sub .ep-item,#pgc-navigate-wrap .ep-box .ep-sub .ep-item:hover,#pgc-navigate-wrap .play-btn,#pgc-navigate-wrap .play-btn:hover,.abnormal-module .abnormal-item .btn-back,.advice-dialog-wrapper .advice-dialog-close,.advice-dialog-wrapper .advice-info,.advice-dialog-wrapper .advice-item-title,.advice-dialog-wrapper .advice-title,.advice-dialog-wrapper .input-style,.answer-container .footer-bottom .btn-default,.answer-list .exam-list .exam-number,.article-card .article-info .title,.article-data-wrp .breadcrumb .sign,.article-data-wrp .breadcrumb a,.author-container .attention-animation-holder .attention-btn,.bangumi-list .bangumi-item .right-info .headline .bangumi-label,.bangumi-list .bangumi-item .right-info .headline .title,.bili-dialog-bomb .appeal-box .submit .cancel,.bili-dialog-bomb .appeal-box .submit .confirm,.bili-dialog-bomb .appeal-box .wrap .container .question,.bili-header-m .profile-m .grade .bar .num .v0,.block-area .follow-wrapper .follow-head .follow-more,.bp-emoji-box .static-popup.common-font.bp-arrow .title,.card-warpper .card-warpper-outside .card-item .info-text,.cards-block .cards-list .card-item .card-case .title,.carousel-wrp .panel .pic li a .card-info .title .headline,.cc-article-wrp .article-card .meta-title .typename,.cc-container .nav-search .dropdown-btn,.cc-container .nav-search .search,.cc-container .nav-search .search input,.cc-content-body .select-box .option-footer,.cc-content-body .select-box .select-item .text,.collection-bg .collection-board .collection-list .collection-li .collection-name,.collection-bg .collection-board .collection-list .collection-li .collection-song-number,.collection-bg .collection-board .collection-submit,.collection-bg .collection-board .collection-submit.active,.collection-bg .collection-board .collection-theme,.comment-list-item .article-wrap .name,.comment-list-item .ci-content,.common .bb-comment .no-login .baffle .b-btn:hover,.container .form-group .form-group-title,.container .form-group .mail-text,.container-left .answer-container .header-top h2,.customize-wrp .steps-title,.danmaku-wrap .player-auxiliary-area .player-auxiliary-danmaku-management i,.danmaku-wrap .player-auxiliary-area .player-auxiliary-danmaku-management>*,.detail-wrp .detail-empty,.enter-failure,.enter-failure .supporting-text,.error-body .error-container .error-panel .audio-split,.error-body .error-container .song-wrap .change-song,.error-body .error-container .song-wrap .iconfont,.error-body .error-container .song-wrap .image-split,.face-container .pendant-list li .pendant-btn,.face-container .pendant-nav li div,.face-container .pendant-nav li div.active,.face-container .record-table,.feedback-mask .content .feedback-body .dl-item .dt-item,.feedback-mask .content .feedback-body .feedback-submit,.feedback-mask .content .feedback-body .feedback-submit.active,.fold-box .fold-hoverable,.follow-item .details .season-title,.game-item-container .game-package-item .game-package-name,.game-package-wrapper .title-package-wrapper .title-package-name,.home-pc .application .application-body .application-item .p1,.home-pc .application .application-body button,.home-pc .application .application-header .title span,.home-pc .dialog .footer .apply-btn,.home-pc .dialog .header h1,.link-tag-box .selector-wrap,.link-tag-box .selector-wrap ul>li:hover,.link-tag-box .tab-wrap>ul li,.list-container .list-info-block .right-side .title,.list-filter-bar .item-text,.live-user .user-item .item-right .status,.live-user .user-item .item-right .tags>span,.m-layer .b-btn,.m-layer.m-button,.m_layer.m-button,.main-container .media-info .media-right .media-desc i,.mask .popup-container .title,.normal-v2-container .normal-title-wrp>.template-op>p,.pendant-main .pendant-btn,.pendant-mask .pendant-box .pendant-main .price-btn,.pendant-mask .pendant-main .pendant-info p,.pgc-list .pgc-item .right-info .headline .pgc-label,.pgc-list .pgc-item .right-info .headline .title,.player-his-main .player-his-nav,.popup-content-ctnr .report-input,.popup-content-ctnr .upload-box .upload-btn,.r-con .members-info .up-card .attention,.r-con .members-info .up-card .attention--not,.r-con .members-info .up-card .info-name,.r-con .members-info__header .btn,.r-con .members-info__header .title,.read-list-modal-component .creat-read-list-box .input-box button,.read-list-page .read-list-name .info.right.show .right-float .ui-btn.grey-radius .menu-list .menu-item,.read-list-page .read-list-name .info.right.show .title,.regist .reg-main-text,.regist .reg-main-title,.regist .toolbox .reg-tip,.right-content .customize-wrp .title,.right-content .reward-wrp .reward-title,.security-right-bottom .face-nav>div a,.security-right-bottom .tool-uninstall-pendant span,.selet-datebox .inpt a.b-btn,.selet-datebox .inpt input[type=text],.selet-datebox .sse a,.setting .public-setting .public-wrp .button-wrap .btn-text.ok,.setting .public-setting .public-wrp .button-wrap .btn-text.ok.is-disable,.setting .public-setting .public-wrp .setting-item,.share-board .share-btn .share-type,.share-board .song-share .song-share-ul,.share-wrap .content-wrap .input-wrap button,.share-wrap .content-wrap .input-wrap input,.share-wrap .content-wrap .input-wrap span,.song-coin-bg .song-coin .song-coin-btn,.song-coin-bg .song-coin .song-coin-title,.song-info .info-wrap .current-selector .chosen-type,.song-info .info-wrap .type-list .item-list .type-item,.song-info .info-wrap .type-list .item-list .type-item.active:hover,.song-info .info-wrap .type-list span,.sponsor-rank-item.pos-rank-module .sp-right .sp-user .sp-name,.steps .step-operate .step-bread .step-index,.tab-selector-wrap .selector-wrap,.tab-selector-wrap .selector-wrap ul>li:hover,.tab-selector-wrap .tab-wrap>ul li,.tabs .customize-tab .tab-title,.tag.sky-blue,.tag.sky-blue.activated,.tag.sky-blue:hover,.teach-last-list .teach-tv-text,.text-article-wrp .article-card .meta-title .typename,.text-article-wrp .article-card .meta-view .menu-list .menu-item,.text-article-wrp .article-card .meta-view .meta-item.text-item,.text-article-wrp .head-stat .section .title,.title-library-wrap .title-status button,.ui-popup .popup-wrap .text-box .text,.ui-popup.popup-cover .bili-btn.cancel,.ui-state-active,.ui-state-default,.ui-state-focus,.ui-state-hover,.ui-widget-content,.ui-widget-content .ui-state-active,.ui-widget-content .ui-state-default,.ui-widget-content .ui-state-focus,.ui-widget-content .ui-state-hover,.ui-widget-header,.ui-widget-header .ui-state-active,.ui-widget-header .ui-state-default,.ui-widget-header .ui-state-focus,.ui-widget-header .ui-state-hover,.up-info .btn-panel .charge-btn,.up-info .btn-panel .not-follow-charge-btn:hover,.vd-list li .title,.video-detail .item-title,.view-later-module .up-info-module .b-btn,.view-later-module .video-info-module h1,.vl-hd-sub .b-slt .list li,.vl-hd-sub .b-slt .txt,.vote-info-wrapper .user-name .name,.vote-info-wrapper .vote-to{color:#eee!important}#bili-data-center .version-switch-section,#navigator .v-switcher-header-item,#pgc-navigate-wrap .ep-box .ep-sub .ep-item,#pgc-navigate-wrap .play-btn,#pgc-navigate-wrap .play-btn:hover,.answer-container .answer-list,.answer-container .answer-list .exam-list,.answer-container .footer-bottom .btn-default,.article-info-module,.article-net-charts .area,.article-net-charts .charts .person,.article-net-charts .charts .play,.b-slt.on,.b-slt.on:hover,.b-slt:hover,.bangumi-list .bangumi-item,.bangumi-list .bangumi-item .right-info .headline .bangumi-label,.bili-dialog-bomb .appeal-box .submit .cancel,.bili-modal.cropper-modal .modal-footer,.bili-modal.cropper-modal .modal-head .head-wrap,.block-area .follow-wrapper .follow-head .follow-more,.bp-emoji-box .static-popup,.card .fold-box,.cards-block .modal-wrap .btn-group,.carousel-wrp .panel .pic li,.cc-article-wrp .article-card .meta-title .typename,.cc-body .setting .follow-setting,.cc-body .setting .public-setting,.cc-container .nav-search .dropdown-btn,.cc-content-body .select-box,.cc-content-body .select-box .row,.collection-bg .collection-board .collection-list,.container-left .answer-container,.container-left .header-top,.cover-upload-box .modal-head .head-wrap,.customize-wrp .customize-tab,.danmaku-wrap .player-auxiliary-area .player-auxiliary-danmaku-management>*,.dc-page .version-switch-section,.detail-wrp .detail-empty,.el-picker-panel__body .el-date-table th,.el-popper[x-placement^=bottom] .popper__arrow,.el-popper[x-placement^=bottom] .popper__arrow:after,.error-body .error-container .song-wrap .change-song,.face-container .pendant-list li,.face-container .pendant-list li>div,.face-container .record-table tbody td,.face-g-list#my-g-list .face-g-block .my-mp-block,.feed-topic .card,.feed-topic .hot-content .card,.feed-topic .top-content .card.card-offset,.float_window,.float_window .close,.float_window .close:hover,.float_window .selet-datebox .inpt input[type=text],.home-pc .application .application-foot,.info-wrap .feedback-mask .content .headline,.link-tag-box .selector-wrap div,.link-tag-box .selector-wrap ul,.link-tag-box .tab-wrap,.list-container .list-info-block .right-side .up-info-block .follow-btn.on,.live-category .category,.live-user .user-item .item-right .tags>span,.m-layer .b-btn,.m-layer.m-button,.m_layer.m-button,.main-ctnr .qualify-drawer .draw-list,.main-ctnr .qualify-drawer .drawer-pop:after,.modal-content.clearfix .img-clip-wrap .reset-img,.more-selector-v2-container .dividing-line,.normal-v2-container .normal-title-wrp>.template-op,.pgc-list .pgc-item,.pgc-list .pgc-item .right-info .headline .pgc-label,.popup-content-ctnr .report-input,.protocol-modal .cancel-btn,.r-con .members-info .up-card .attention--not:hover,.read-list-modal-component .creat-read-list-box .input-box,.read-list-modal-component .creat-read-list-box .input-box button,.read-list-modal-component hr,.s-space #page-fav .fav-sidenav,.section-block .bp-emoji-box .static-popup,.section-block.with-radius.p-relative .section-nav,.security-right .game-package-wrapper,.security-right .game-package-wrapper .game-item-container .game-package-item,.security-right .vip-package-wrapper,.security-right-bottom .face-nav,.security-right-bottom .face-tool .tool-container,.security-right-bottom .face-tool .tool-container .tool-change-face,.security-right-bottom .face-tool .tool-container .tool-uninstall-pendant,.selet-datebox .inpt a.b-btn,.selet-datebox .inpt a.b-btn:hover,.share-board .share-btn .share-type.song-border,.share-board .song-share .song-share-ul,.share-board .song-share .song-share-ul li,.share-wrap .content-wrap .input-wrap input,.song-info .info-wrap .type-list .item-list .type-item,.ssr-content .link-tag.activity:active,.tab-selector-wrap .selector-wrap div,.tab-selector-wrap .selector-wrap ul,.tag.sky-blue,.tag.sky-blue.activated,.text-article-wrp .article-card,.text-article-wrp .article-card .meta-title .typename,.ui-popup .popup-wrap.shadow,.ui-popup.popup-cover .bili-btn.cancel,.ui-state-active,.ui-state-default,.ui-state-focus,.ui-state-hover,.ui-widget-content .ui-state-active,.ui-widget-content .ui-state-default,.ui-widget-content .ui-state-focus,.ui-widget-content .ui-state-hover,.ui-widget-header,.ui-widget-header .ui-state-active,.ui-widget-header .ui-state-default,.ui-widget-header .ui-state-focus,.ui-widget-header .ui-state-hover,.up-info .btn-panel .charge-btn,.vd-list.l3 li .l-item,.version-switch-section .bottom-border,.videoCharts .stat-wrp,.view-later-module .core-player-auxiliary-area,.view-later-module .core-player-filter,.view-later-module .core-player-video-control,.view-later-module .up-info-module .b-btn,.view-later-module .video-box-module,.view-later-module .video-toolbar-module,.vl-hd-sub .selector-block .b-slt .list{border-color:transparent!important}.article-info-module .v-info .line,.bangumi-media .bangumi-media-body .review-empty-wrapper .empty-info .btn-go-write,.list-container .article-list-block .article-item .item-holder .article-content .article-left-block,.modal .img-clip-wrap .container-box,.pendant-main .final-price,.pendant-main .unit-price li,.text-article-wrp .article-card .meta-status .pubdate,.video-info-module .v-info .line{border-color:#aaa!important}#float_window h3,.article-info-module .v-data,.bili-dialog-bomb .appeal-box .header,.bili-dialog-bomb .appeal-box .submit,.read-list-page .add-article-modal hr,.selet-datebox .sse,.selet-datebox .sse a,.ui-widget-content,.vd-list li .l-r .up-info .v-date,.vd-list.l1 li .l-r,.vd-list.l2 li,.vd-list.l2 li .l-item,.view-later-module .video-desc,.view-later-module .video-info-module .number .line,.view-later-module .video-tag,.web-box .expanded .user-li::after{border-color:#444!important}#pgc-navigate-wrap .play-btn .play-btn-svg,.b-slt .b-slt-arrow,.block-area .follow-wrapper .follow-head .follow-more .icon,.error-related .error.details,.float_window .close,.text-article-wrp .head-stat .section .iconarrow,.video-toolbar-module .share-box .share-btn ul li{filter:brightness(0) invert(1)!important}#page-fav .fav-main .search-input .icon-search,.album-card .info .like-num .icon-like,.album-card .info .view-count .icon-view,.album-item .meta-col .icon,.article-card .article-info .data .icon,.article-content .meta-col .icon,.article-info-module .v-data .icon,.bangumi-info-module .v-data .icon,.case-list .info .jury-time i,.col-1 .i-pin-info .icon,.col-1 .meta .icon,.cube .meta .icon,.item-right .info.clearfix .icon-live-col,.item-right .info.clearfix .icon-live-compete,.item-right .info.clearfix .icon-live-life,.item-right .info.clearfix .icon-live-mgame,.l-item .v-info .b-icon,.section-block .col-full .meta .icon,.video-info-module .v-data .icon,.view-later-module .share-box .s-text .icon{filter:brightness(0) invert(.7)!important}#page-fav .fav-main .search-input .icon-search:hover,.answer-list .key-list li.active:before,.bui-radio .bui-radio-normal .bui-radio-item:hover .bui-radio-icon svg,.error-body .error-container .error-panel .error-msg .error-img,.feedback-mask .content .feedback-body input[type=radio]:checked+.radio-icon,.fold-box .fold-hoverable:hover .fold-arrow,.left-nav-item:hover .icon-customize,.left-nav-ul .icon-customize.active,.nav-upload-container .nav-upload-item>img,.pendant-main .unit-price li.active,.pendant-pay-close,.register-agree .checkbox-bwxr.active,.security-right-bottom .face-nav>.active:after,.self-icon-vote-create-btn.active,.song-info .info-wrap .type-list .fold-div .foldStatus,.song-info .info-wrap .type-list .fold-div .unfoldStatus,.vl-hd #tab_list_mode .tab-i{filter:var(--blue-image-filter)!important}.container-right .rule-title .pink-icon{filter:var(--pink-image-filter)!important}.float_window .close:hover,.view-later-module .video-info-module{box-shadow:none!important}#app-ctnr .demo-app .category,#root .nav-upload-container,.article-info-module,.cc-content-body .select-box,.charge-participate .part-btn,.detail-wrp .detail-empty,.face-g-list#my-g-list .face-g-block .my-mp-block:hover,.float_window,.left-nav-wrapper,.live-user .user-item:hover,.m-layer.m-button,.m_layer.m-button,.read-list-page .module-box,.share-board .share-btn,.share-board .song-share .song-share-ul,.text-article-wrp .head-stat{box-shadow:0 1px 10px 0 var(--theme-color-30)!important}.bangumi-media .bangumi-media-body .review-empty-wrapper .empty-info .btn-go-write:hover,.carousel-wrp .page .next.current,.customize-wrp .select,.data-card .data-wrp .tab .fan-tab.current,.data-card .data-wrp .tab .fan-tab.current:after,.data-card .data-wrp .total .incr-num:before,.data-card .fans-wrp .tab .fan-tab.current,.data-card .fans-wrp .tab .fan-tab.current:after,.data-card .fans-wrp .total .incr-num:before,.error-body .error-container .song-wrap .song-list .song-li .song-shadow,.face-container .pendant-list li:hover,.info-line .status-attend,.list-filter-bar .item-text.active,.list-filter-bar .item-text.expand,.list-filter-bar .item-text:hover,.live-category .category:hover,.pendant-main .unit-price li.active,.pendant-main .unit-price li:hover,.security-right-bottom .face-nav>.active,.setting .public-setting .public-wrp .setting-item .circle-wrap.active,.song-coin-bg .song-coin .song-coin-content .song-one-coin.active,.song-coin-bg .song-coin .song-coin-content .song-one-coin:hover,.song-coin-bg .song-coin .song-coin-content .song-two-coin.active,.song-coin-bg .song-coin .song-coin-content .song-two-coin:hover,.song-info .info-wrap .type-list .item-list .type-item:hover,.ssr-content .link-tag.activity,.tag.sky-blue:hover,.title-library-wrap .title-status button,.vl-hd .vl-tab .tab-i.on{border-color:var(--theme-color)!important}#app .el-button--primary,#app .el-button--primary:focus,#app .el-button--primary:hover,#navigator .v-switcher-header-anchor,#pgc-navigate-wrap .ep-box .ep-sub .ep-item:hover,#pgc-navigate-wrap .play-btn:hover,.abnormal-module .abnormal-item .btn-back:hover,.ac-article-wrp .tabs-nav .select,.advice-dialog-wrapper .submit-btn:hover,.answer-container .footer-bottom .btn-default,.author-container .attention-animation-holder .attention-btn,.bili-dialog-bomb .appeal-box .submit .confirm,.bili-dialog-bomb .appeal-box .wrap .container .options .option .checkbox.checked:before,.bili-header-m .mini-wnd-nav.history-wnd .top-login .loginbtn,.bilibili-player .bilibili-player-area .bilibili-player-video-control .bilibili-player-video-btn .bilibili-player-video-quality-menu .bilibili-player-bigvip,.block-area .follow-wrapper .follow-head .follow-more:hover,.cards-block .images-list .image-item .selected,.carousel-wrp .page .next.current,.collection-bg .collection-board .collection-submit.active,.common .bb-comment .no-login .baffle .b-btn:hover,.face-container .pendant-list li .pendant-btn,.face-container .pendant-list li .pendant-btn:hover,.face-container .pendant-nav li div.active,.feedback-mask .content .feedback-body .feedback-submit.active,.home-pc .application .application-body .btn-color:hover,.home-pc .dialog .footer .apply-btn:hover,.m-layer .b-btn,.pendant-main .pendant-btn,.popup-content-ctnr .upload-box .upload-btn,.r-con .members-info .up-card .attention--not:hover,.security-right-bottom .face-tool .tool-container .tool-change-face,.selet-datebox .inpt a.b-btn:hover,.selet-datebox .sse a.on,.setting .public-setting .public-wrp .button-wrap .btn-text.ok,.setting .public-setting .public-wrp .setting-item .circle-wrap .circle-inlie,.share-wrap .content-wrap .input-wrap button,.song-coin-bg .song-coin .song-coin-btn,.song-coin-bg .song-coin .song-coin-btn:hover,.ssr-content .link-tag.activity:active,.ssr-content .link-tag.activity:hover,.steps .step-operate .step-bread .step-index,.tab-wrap>ul li.selected a span:after,.tag.sky-blue.activated,.text-article-wrp .article-card .meta-view .meta-item:hover,.ui-state-active,.ui-state-focus,.ui-state-hover,.ui-widget-content .ui-state-active,.ui-widget-content .ui-state-focus,.ui-widget-content .ui-state-hover,.ui-widget-header .ui-state-active,.ui-widget-header .ui-state-focus,.ui-widget-header .ui-state-hover,.up-info .btn-panel .not-follow-charge-btn:hover,.view-later-module .up-info-module .b-btn{background-color:var(--theme-color)!important}#announcement-area .flip-view .action-arrow-ctnr:hover .icon-font,#navigator .v-switcher-header-item a:hover,#page-article .article-lists .lists-item .item-right .item-name a:hover,#page-article .article-lists .lists-item .item-right .item-title a:hover,#page-fav .fav-main .fav-action-bottom .search-results-num i,.answer-container .header-top .header-tip,.article-card .article-info .title:hover,.article-content-ctnr .supporting-info .category:hover,.b-slt-tab .tab-i:hover,.b-slt-tab li:hover,.bangumi-list .bangumi-item .right-info .headline .title:hover,.bangumi-media .bangumi-media-body .review-empty-wrapper .empty-info .btn-go-write:hover,.bili-header-m .profile-m .grade .bar .num .v0:hover,.card-warpper .card-warpper-outside .card-item .learn.unlearn,.cntr .sort-cntr .href-all:hover,.cntr .sort-cntr .href-all:hover i,.col-1 .article-wrap .article-con a:hover,.collection-bg .collection-board .collection-list .collection-li .collection-checkbox .collection-checked,.collection-bg .collection-board .collection-list .collection-li:hover .collection-checkbox,.collection-bg .collection-board .collection-list .collection-li:hover .collection-name,.comment-list-item .article-wrap .show-all,.content-tag-v2-edit-mod-wrp p a,.content-tag-v2-edit-mod-wrp p a:hover,.coupon-money-2:before,.danmaku-wrap .player-auxiliary-area .player-auxiliary-danmaku-management>:hover,.danmaku-wrap .player-auxiliary-area .player-auxiliary-danmaku-management>:hover i,.data-card .data-wrp .tab .fan-tab.current,.data-card .fans-wrp .tab .fan-tab.current,.electron-set-v2-hint a,.electron-set-v2-hint a .electron-set-v2-hint a:hover,.electron-set-v2-hint a:hover,.enter-failure .password-input .empty-hint,.fold-box .fold-hoverable:hover,.follow-item .details .highlight,.follow-item .details .season-title:hover,.form-group .register-agree a,.form-group.register-hidden-gruop.text-right a,.game-package-item .game-package-type,.home-pc .application .application-body .fjw-tip li:first-child,.icon-close:hover,.list-filter-bar .item-text.active,.list-filter-bar .item-text.expand,.list-filter-bar .item-text:hover,.pendant-main .final-price span,.pendant-main .point-info a,.pendant-main .unit-price li.active,.pendant-main .unit-price li:hover,.pgc-list .pgc-item .right-info .headline .title:hover,.pgc-space-follow-item .pgc-item-info .pgc-item-state .publish-state.is-new,.photo-imager-container .image-count-hinter .count-hinter .current-index,.rank-item:hover .item-title,.read-list-page .read-list-name .info.right.show .right-float .ui-btn.grey-radius .menu-list .menu-item:hover,.register-hidden-gruop.text-right a,.rule-time span,.share-board .song-share .song-share-ul li:hover,.share-wrap .content-wrap .title,.small-item .search-keyword-highlight,.song-coin-bg .song-coin .song-coin-content .song-one-coin.active,.song-coin-bg .song-coin .song-coin-content .song-two-coin.active,.song-coin-bg .song-coin .song-coin-title .song-coin-number,.song-info .info-wrap .choose-type .selected,.song-info .info-wrap .current-selector .selector-list .font-blue,.song-info .info-wrap .type-list .fold-div,.song-info .info-wrap .type-list .item-list .type-item:hover,.sponsor-rank-item.pos-rank-module .sp-right .sp-user .sp-name:hover,.steps .step-operate .dropdown-btn .icon-text,.steps .step-operate .step-bread .step-title.selected,.tab-wrap>ul li a span:hover,.tab-wrap>ul li.selected a span,.text-article-wrp .article-card .meta-status .status,.text-article-wrp .article-card .meta-view .menu-list .menu-item:hover,.ui-checkbox input[type=checkbox]:active+.ui-checkbox-icon,.ui-checkbox input[type=checkbox]:hover+.ui-checkbox-icon,.vd-list li .title:hover,.view-later-module .bilibili-player .bilibili-player-auxiliary-area .bilibili-player-watchlater-item:hover .bilibili-player-watchlater-info-title,.view-later-module .bilibili-player .bilibili-player-auxiliary-area .bilibili-player-watchlater-nav-positive.bppl-state-selected,.view-later-module .bilibili-player .bilibili-player-auxiliary-area .bilibili-player-watchlater-nav-positive:hover,.view-later-module .bilibili-player .bilibili-player-auxiliary-area .bilibili-player-watchlater-nav-random.bppl-state-selected,.view-later-module .bilibili-player .bilibili-player-auxiliary-area .bilibili-player-watchlater-nav-random:hover,.view-later-module .bilibili-player .bilibili-player-auxiliary-area .bilibili-player-watchlater-nav-reverse.bppl-state-selected,.view-later-module .bilibili-player .bilibili-player-auxiliary-area .bilibili-player-watchlater-nav-reverse:hover,.view-later-module .bilibili-player-iconfont.icon-12toview-play:before,.view-later-module .video-info-module .tm-info a:hover,.vl-hd #tab_list_type .tab-i.on,.vl-hd .vl-tab .tab-i.on{color:var(--theme-color)!important}.contri-condition .contri-select.active:after,.data-card .data-wrp .tab .fan-tab.current:after,.data-card .data-wrp .total .incr-num:before,.data-card .fans-wrp .tab .fan-tab.current:after,.data-card .fans-wrp .total .incr-num:before{border-left-color:transparent!important;border-right-color:transparent!important}.ui-datepicker .ui-datepicker-next,.ui-datepicker .ui-datepicker-prev,.ui-state-default,.ui-widget-content,.ui-widget-content .ui-state-default,.ui-widget-header .ui-state-default{border-radius:4px!important}.cc-content-body .select-box .select-item:hover{border-radius:15px!important}.app-layout .dropbox-component,.app-layout .dropbox-component .data-list,.app-layout .page-content .feedback-content-input,.app-layout .page-content .manga-textbox,.box .content-wrap .btn .info,.calendar-wrap .calendar-body .date-desc_wrap,.content .share-wrap,.dialog-wrapper .dialog,.fjw-kpi-wrap-bg,.fjw-point .point-wrap .user-point .face .unfocus-btn,.international-home .bilibili-search-history,.item-wrap__task .operate-btn,.main-wrapper .comment-wrapper,.navbar-container,.nomal-task .bottom-box .btn,.reply-bottom-menu-mask .more-ops,.reply-emoji-panel .emoji-cate,.reply-emoji-panel .emoji-cate a,.reply-emoji-panel .emoji-list,.round-corner .app-layout,.row1 .calendar-wrap,.security_content .close-btn,.security_content .coupon-wrapper .coupon-content,.security_content .title-right-link,.submit button,.van-popover{background-color:#222!important}.app-layout .sidebar,.at-popup .user-container .item.is-selected,.bangumi-options .opt-list,.bpui-selected,.bpui-selected span,.bui-button.bui-button-gray2,.bui-swiper-wrap .bui-swiper-item .bui-swiper-text,.comic-info-component .page-normal .comic-info-con,.comic-info-component .page-normal .comic-info-con .comic-des,.container .links .link-item:hover,.container .logout a:hover,.container .tab-item--normal:hover,.container .video-card:hover,.danmaku-wrap .player-auxiliary-area .player-auxiliary-danmaku-btn-footer,.danmaku-wrap .player-auxiliary-area .player-auxiliary-danmaku-wrap,.danmaku-wrap .player-auxiliary-area .player-auxiliary-danmaku-wrap-child .player-auxiliary-panel-title,.danmaku-wrap .player-auxiliary-block-wrap,.dropdown__content .dropdown__active,.dropdown__content .dropdown__item:hover,.guest-home .button-box button,.lang-change .lang-intro-item:hover,.lang-change .lang-item:hover,.manga-button.ghost,.manga-button.primary,.player-auxiliary-danmaku-function,.player-auxiliary-danmaku-function [class*=player-auxiliary-danmaku-btn-],.player-auxiliary-danmaku-wrap .player-auxiliary-danmaku-load-status,.practice-wrap .tab-container,.qa-area-ol-wrp,.r-con .members-info__container,.video-editor-ol-wrp{background-color:#333!important}.app-layout .page-content .router-view,.app-layout .sidebar .nav-item-indicator,.bangumi-item .right-info .headline .bangumi-label,.bangumi-options .opt-list li:hover,.bili-search .live-user-item .item-right .tags>span,.bili-search .pgc-item .right-info .headline .pgc-label,.bili-search .user-item .attention-btn,.box .content-wrap,.box .record-wrap,.box-body,.bpui-selected>span,.bpui-selecting>span,.bpui-unselecting,.bui-collapse .bui-collapse-header,.bui-swiper-wrap .bui-swiper-next,.bui-swiper-wrap .bui-swiper-pre,.calendar-wrap .calendar-body .calendar-body__select .ui-dropdown .default:hover,.calendarEntry_wrap,.calendarEntry_wrap .calendarEntry_slide,.carousel-wrap li.scrollx,.coming-soon-wrapper .card-wrapper .card-item .time-line-wrapper .line .point-wrapper,.coming-soon-wrapper .slider-contro span,.comment .comment-hot-item-floor .operate-utils,.container .more-btn,.detail-content .activity-info,.detail-content .guest-wrapper,.detail-content .jump-pagination-input,.detail-content .more-hot-comments,.elevator .list-box,.elevator .list-box .item,.elevator .list-box .item.back-old,.elevator .list-box .item.sort,.episode-list-component .episode-list .list-data .list-item,.exchange-btn .btn,.feed-card .feed-title,.feed-topic .empty-content,.flow-loader .activity-item .info .type,.follow-right-module .follow-head .follow-more,.gg-window .online,.guest-home .login-panel,.hot-recom-module .random-change,.international-home .bilibili-search-history .history-item.focus,.international-home .bilibili-search-history .history-item:hover,.list-header .filter-wrp .article-type,.list-header .filter-wrp .category-wrp,.list-header .filter-wrp .filter-level,.list-header .filter-wrp .order-wrp,.list-header .filter-wrp .video-type,.live-charge-box .tip-popup,.live-rank .live-rank-item .number,.main-panel .hot-topic-panel,.mession-box .content .list-wrap .item-index,.modal-wrapper .modal-container,.news-dialog-Wrapper,.pgc-rank-wrap .number,.player-auxiliary-danmaku-report-wrap.player-auxiliary-danmaku-report-wrap-white .player-auxiliary-danmaku-report-box .player-auxiliary-danmaku-report-panel,.r-con .members-info .up-card .attention,.r-con .members-info .up-card .attention--not,.r-con .members-info__header,.rank-wrap .number,.recommendation-list .list-item:before,.replies-comment-input-wrapper .replies-upload .comment-input-img,.replies-comment-input-wrapper .replies-upload .replies-uploading-container,.replies-comment-input-wrapper .submit-comment.no-login,.reply-emoji-panel .emoji-cate a.on,.reply-emoji-panel .emoji-list .emoji-pager .pager-dot,.reply-input .input-area .reply-emoji-btn,.reply-input .input-area .reply-submit-btn,.reply-input .input-area input,.reply-report .reason-choose .reason-group .list li input[type=radio],.reply-report .submit-btn button:disabled,.report-pc-dialog .report-dialog-container,.security_content .coupon-content-con .coupon-btn,.tabs .customize-tab,.tabs-nav .tab-item.border-bottom,.tabs-nav .tab-item.full,.tabs-wrapper,.ticket-tips-wrapper .rec-item,.ticket-tips-wrapper .ticket-tips,.time-line .tl-link,.ui-dropdown .default,.ui-dropdown .ui-dropdown-text,.ui-dropdown .ul-dropdown-list,.user-item .attention-btn.followed,.user-item .attention-btn.followed:hover,.vip-m .bubble-traditional .renew-btn button,li.danmaku-info-row.bpui-selected,li.danmaku-info-row.bpui-selecting{background-color:#444!important}.coming-soon-wrapper .card-wrapper .card-item .time-line-wrapper .line,.coming-soon-wrapper .card-wrapper .card-item .time-line-wrapper .line .point-wrapper .point,.config-item:not(:last-child):after{background-color:#555!important}.guard-rank-cntr .rank-cntr .rank-list-box .url-back,.replies-comment-input-wrapper .submit-comment{background-image:none!important}#app .calendarEntry_content .header,#app .report-dialog-container .submit,#bp-app,.app-layout .list-item:hover,.app-layout .page-content,.app-layout .size-ruler,.app-layout .user-info>.uid,.article-action .more .more-ops-list,.article-action .more .more-ops-list ul li:hover,.buyticket,.buyticket .bread-wrapper,.calendar-wrap .calendar-body .date-desc_wrap .date-desc__content .nothing-wrap,.calendar-wrap .calendar-body .date-desc_wrap .item-desc_card,.card .forw-area a.more:hover,.cc-body #app .container,.container .info .date,.danmaku-box .bui-radio-input:checked+.bui-radio-label,.detail-content .activity-info-body .info-header,.detail-content .comment,.edit-article-wrap #edit-article-box,.episode-item,.high-wrapper .body-padding,.iframe-comp-container>div,.list-header .filter-wrp .article-type .bili-btn,.list-header .filter-wrp .article-type .line,.list-header .filter-wrp .filter-level .bili-btn,.list-header .filter-wrp .filter-level .line,.list-header .filter-wrp .video-type .bili-btn,.list-header .filter-wrp .video-type .line,.manga-recommendation .data-list .list-item,.manga-spread-module .label,.mini-header__content .i-frame,.mini-header__content .i-frame::before,.multi-line-text:after,.page-content .-BiliFooter,.player-auxiliary-area .danmaku-info-row-special,.rank-list-ctnr .normal-list .item.self,.rank-list-ctnr .own,.reply-emoji-panel .emoji-list .emoji-text:hover,.round-corner .international-footer,.round-corner .loc-menu-box,.round-corner .out-container,.round-corner .out-container .tab-bar,.whole-detail-info-wrapper{background-color:transparent!important}.reply-item .sub-reply-preview,.security_content .coupon-wrapper{background:0 0!important}.box .title .h1:after{background:#fff!important}.fans-medal-item.special-medal .label .content{color:#222!important}.main-container .ep-list-wrapper .list-wrapper.simple ul .ep-item.visited,.main-container .ep-list-wrapper .list-wrapper.simple ul .ep-item:visited{color:#888!important}#all-list .user-item .up-info>span,#page-index .channel .channel-item .small-item .video-desc,.app-layout .page-content .extral-info,.article-card .r-con .count,.article-card .r-con .up,.bangumi-item .right-info .intros .label,.bangumi-item .right-info .intros .value,.bili-search .article-item .content .desc,.bili-search .article-item .content .so-icon a,.bili-search .live-user-item .item-right .info .star,.bili-search .live-user-item .item-right .info .type,.bili-search .pgc-item .right-info .intros .label,.bili-search .pgc-item .right-info .intros .value,.bili-search .topic-item .content .desc,.bottom-box .wrap-list .gift-item .B-paper,.box .content-wrap p,.box .list-box .wrap-list .text,.calendar-wrap .calendar-body .date-desc_wrap .item-desc_card .item-desc_body .item-desc__content,.calendarEntry_wrap .calendarEntry_footer .footer_content span,.carousel-wrap .panel .pic li a .card-info .detail,.center-box .line-1,.coming-soon-wrapper .card-wrapper .card-item .info-wrapper .desc,.comment .comment-hot-item-floor,.comment .reply-comment-list .reply-comment-item .reply-comment-item-floor,.data-list .list-container .data-item .text-section .footer-text .text,.detail-content .activity-info-body .info-content p span,.guest-home .title h2,.h5share-container .text-area .text-desc,.header-info .manga-info .supporting-text,.item-wrap__task .content-desc,.live-card .up .txt .desc,.live-card .up .txt .tag,.live-list .text-info,.live-list .text-info a,.live-rank .live-rank-item .txt p.p2,.manga-card-horizontal .text-section .footer-text,.manga-rank-list .rank-item .ri-detail .ri-first-info,.manga-rank-list .rank-item .ri-detail .ri-update,.manga-spread-module .label,.mession-box .content .list-wrap .item-summary,.my-coupon .subtitle,.past-work .card-view .collect-num,.past-work .card-view .danmu-num,.past-work .card-view .play-num,.pgc-rank-wrap .txt .update,.player-auxiliary-area .danmaku-info-row-block span.danmaku-info-danmaku,.player-auxiliary-area .danmaku-info-row-block span.danmaku-info-time,.player-auxiliary-area .danmaku-info-row-block::after,.player-auxiliary-area .danmaku-info-row-super::after,.practice-wrap .banner-container .title~p,.purchase-history .list-item .text-info .recharge-date,.qa-area-ol-wrp .qa-area-ol-content a,.rank-wrap .preview .txt span,.reply-dialog .subtitle,.security_content .common-subtitle,.ticket-tips-wrapper .rec-item .rec-item-time,.ticket-tips-wrapper .rec-item .rec-item-vuene,.time-line-card .txt .update a,.user-item .up-info>span,.user-item .up-videos .ptime,.video-card-common .up,.video-editor-ol-wrp .video-editor-ol-content a,.video-list .card-view .collect-num,.video-list .card-view .danmu-num,.video-list .card-view .play-num,.videos-wrap .card-view .collect-num,.videos-wrap .card-view .danmu-num,.videos-wrap .card-view .play-num{color:#aaa!important}#all-list .user-item .title,.activity-info .activity-info-header,.activity-item .info .title,.app-ctnr .club-brief,.app-layout .account-info-container,.app-layout .dropbox-component .current,.app-layout .dropbox-component .data-list>li,.app-layout .page-content .feedback-content-input .length-hinter,.app-layout .page-content .manga-textbox,.app-layout .search-list .keyword-hinter,.article-card .r-con .title,.bangumi-item .right-info .headline .bangumi-label,.bangumi-item .right-info .headline .title,.bangumi-options .opt-list li,.bangumi-options .opt-list li:hover,.bb-comment a.more-link,.bili-search #live-list .headline-live .user-more,.bili-search #live-list .headline-room .filter a,.bili-search #live-list .live-tabs a,.bili-search .article-item .content .title,.bili-search .live-room-item .item-title,.bili-search .live-user-item .item-right .tags>span,.bili-search .live-user-item .item-right .uname,.bili-search .pgc-item .right-info .headline .pgc-label,.bili-search .pgc-item .right-info .headline .title,.bili-search .photo-item .title,.bili-search .topic-item .content .headline a,.bili-search .user-item .attention-btn,.bili-search .user-item .title,.bottom-box .complete,.box .title .h1,.box .title .progress-num,.bui-swiper-wrap .bui-swiper-item .bui-swiper-text,.buyticket .bread-wrapper span,.buyticket .bread-wrapper span a,.buyticket .map-model .modal-container .modal-header,.buyticket .whole-detail-info-wrapper,.calendar .month,.calendar .weekdays li,.calendar-wrap .calendar-body .date-desc_wrap .item-desc_card .item-desc_title .item-title,.calendar-wrap .calendar-body .date-wrap,.calendar-wrap .calendar-body .date-wrap .wrap-content .today,.calendar-wrap .calendar-header,.calendar-wrap .headerClass,.calendarEntry_wrap .calendarEntry_slide,.calendarEntry_wrap .greetings,.carousel-wrap .panel .pic li a .card-info .title .headline,.cc-nav-wrp .activity-nav-wrp .activity-link,.cc-zimu-wrp .zimu-header .zimu-header-title,.center-box .line-2,.comic-episodes .episode-header .episode-operation,.comic-episodes .episode-list .episode-item,.comic-info-component .page-normal .comic-info-con .comic-des .comic-operation .fav-btn .fav-text,.comic-info-component .page-normal .comic-tab .tab-titles .tab-title.active .comments-total,.coming-soon-wrapper .block-title,.coming-soon-wrapper .card-wrapper .card-item .info-wrapper .title,.coming-soon-wrapper .card-wrapper .card-item .time-line-wrapper .date,.coming-soon-wrapper .card-wrapper .card-item .time-line-wrapper .time,.comment .comment-hot-item-floor .operate-utils,.comment .comment-hot-item-user-name,.common-pagination-wrapper,.container .count-item .item-value,.container .date-title,.container .level-info .grade,.container .level-intro,.container .links .link-title,.container .more-btn,.container .split-line,.container .tab-header .tab-item,.container .tab-header .tab-item:hover,.container .tab-item--normal,.container .video-info .line-2,.customize-wrap .item-list .item .info-text,.customize-wrap .steps-title,.customize-wrap .title,.data-list .list-container .data-item .text-section .manga-title,.detail-content .activity-info-body .info-header span,.detail-content .content-detail p,.detail-content .content-detail span,.detail-content .jump-pagination-input,.detail-content .more-hot-comments,.dynamic-btn.pink.with-border-radius.publish-btn.disabled,.dynamic-m .dyn_menu li,.elevator .list-box .item.back-old,.empty-wrap .empty-text,.episode-list-component .episode-list .list-header .header-item,.exchange-btn .btn,.feed-card .feed-title,.fjw-point .point-wrap .user-point .face .unfocus-btn,.flow-loader .activity-item .info .type,.follow-right-module .follow-head .follow-more,.gg-window .online a,.guest-home .button-box .regist,.guest-home .title h1,.guest-wrapper .guest-header,.guest-wrapper .guest-list .name,.h5share-container .text-area .text-content,.handpick-right-module .block-header .block-title,.header-info .manga-info .author-name,.horizontalSelect-wrap .month,.hot-recom-module .random-change .info,.index-entry-wrapper .filter-block-title a,.index-entry-wrapper .filter-block-title span,.index-entry-wrapper .filter-list .filter-item,.interact-dialog .btn,.international-header a,.item-wrap__task .content-title,.item-wrap__task .operate-btn,.lang-change .lang-intro,.lang-change .lang-title,.left-nav-list.no-office .left-nav-item span,.list-header .dropdown-btn .icon-text,.list-header .dropdown-btn:hover,.list-header .filter-wrp .article-type .bili-btn,.list-header .filter-wrp .bread-crumb .main,.list-header .filter-wrp .bread-crumb .second,.list-header .filter-wrp .filter-level .bili-btn,.list-header .filter-wrp .video-type .bili-btn,.live-card .up .txt .name,.live-charge-box .popup-cntr .retry,.live-charge-cntr .popup-cntr .tip-content,.live-rank .live-rank-item .number,.live-rank .live-rank-item .txt p,.main-panel .more,.main-panel .title,.manga-button.ghost,.manga-button.primary,.manga-card .manga-title,.mession-box .btn,.mession-box .content .list-wrap .item-index,.mession-box .content .list-wrap .item-title,.mession-box .title,.my-coupon .coupon-title,.my-coupon .coupon-title .coupon-number,.navbar-container .logo-part,.navbar-container .size-ruler .app-title,.new-comers-module .zone-title .headline .name,.news-dialog__wrapper .dialog-wrapper__desc .dialog-wrapper__body,.news-dialog__wrapper .dialog-wrapper__desc .dialog-wrapper__btn,.news-dialog__wrapper .dialog-wrapper__desc .dialog-wrapper__title,.pgc-rank-wrap .number,.pgc-rank-wrap .txt .title,.pivot-component .pivot-headers .pivot-header-item,.player-auxiliary-danmaku-report-wrap .player-auxiliary-danmaku-report-box .player-auxiliary-danmaku-report-panel .player-auxiliary-report-panel-title,.player-auxiliary-danmaku-report-wrap.player-auxiliary-danmaku-report-wrap-white .player-auxiliary-danmaku-report-box .player-auxiliary-danmaku-report-panel .player-auxiliary-report-content,.popularity-list .list-title,.product-info-time-wrapper .product-info-time,.product-info-time-wrapper .product-info-time-title,.purchase-history .list-item .coin-info .recharge-count,.purchase-history .list-item .text-info .display-text,.qa-area-ol-wrp .qa-area-ol-content p,.rank-header .name,.rank-list-item .expand-mode .text-section .item-title,.rank-wrap .link .title,.rank-wrap .number,.rank-wrap .preview .txt p,.reason-container .reason-category .reason-category-title,.reply-bottom-menu-mask .more-ops .cancel,.reply-bottom-menu-mask .more-ops .ops-list li,.reply-bottom-menu-mask .more-ops .ops-list li a,.reply-dialog .title,.reply-emoji-panel .emoji-list .emoji-text .text-list span,.reply-input .input-area .reply-emoji-btn,.reply-input .input-area .reply-submit-btn,.reply-item .info .name,.reply-report .reason-choose .reason-group .list li,.reply-report .submit-btn button,.reply-report .submit-btn button:disabled,.report-dialog-container .submit .cancel-btn,.report-pc-dialog .report-dialog-container .title,.round-corner .international-footer .link-box .link-item .bt,.round-corner .international-footer .link-box .link-item ul a,.round-corner .international-footer .link-box .link-item.link-c p,.round-corner .international-footer .partner a,.round-corner .out-container .tab-bar,.schedule-list .list-header .date-selector .date-item,.security_content .close-btn,.security_content .common-title,.security_content .coupon-content-con .coupon-btn,.security_content .title-package-name,.security_content .title-right-link,.selectable-option.unable,.special-recommend header,.style-section .tag-block .block-title,.style-section .tag-block .tag-containers .style-tag,.sub-tabs .filter-content,.tabs-nav .tab-item,.tabs-nav .tab-item.border-bottom,.tabs-nav .tab-item.full,.ticket-tips-wrapper .rec-item .rec-item-name,.ticket-tips-wrapper .ticket-tips-content span,.ticket-tips-wrapper .ticket-tips-header,.time-line .tl-link,.time-line-card .txt .ss,.ui-dropdown .default,.ui-dropdown .ul-dropdown-list,.up-info .btn-panel .following,.user-info-component .coin-info,.user-item .attention-btn.followed,.user-item .attention-btn.followed:hover,.user-item .up-videos .video-item .video-desc,.user-item .up-videos .video-more,.van-popover a,.video-card-common .title,.video-editor-ol-wrp .video-editor-ol-content p,.video-item.matrix .title,.vip-m .bubble-traditional .recommand .title,.vip-m .bubble-traditional .renew-btn button,.whole-detail-info-wrapper .detail-info-wrapper .vuene-wrapper .check-map,.whole-detail-info-wrapper .detail-info-wrapper .vuene-wrapper .title,.whole-detail-info-wrapper .detail-info-wrapper .vuene-wrapper .vuene-info-content .address-name,.whole-detail-info-wrapper .product-buy-wrapper .want-wrapper .want-content p{color:#eee!important}.app-layout .dropbox-component,.app-layout .dropbox-component .data-list,.app-layout .page-content .manga-textbox:focus,.ban-vote .vote-dialog .dialog-header,.bangumi-item .right-info .headline .bangumi-label,.bangumi-options .opt-list,.bangumi-timing-module .headline .c-clink,.bili-search .live-user-item .item-right .tags>span,.bili-search .pgc-item .right-info .headline .pgc-label,.bili-search .photo-item,.bilibili-player-ending-panel-box-recommend:hover,.calendarEntry_wrap,.calendarEntry_wrap .calendarEntry_slide,.calendarEntry_wrap .greetings,.carousel-wrap .page .next.current,.coin-nav,.comic-info-component .page-normal .comic-tab .tab-titles,.comment .comment-selecotr,.container .coins,.container .counts,.container .links,.container .tab-header,.detail-content .activity-info,.detail-content .comment,.detail-content .guest-wrapper,.detail-content .jump-pagination-input,.elevator .list-box,.elevator .list-box .item.back-old,.elevator .list-box .item.back-top,.exchange-btn .btn,.flow-loader .activity-item,.flow-loader .activity-item .info .type,.flow-loader .user-item,.flow-loader .video-item.matrix,.follow-right-module .follow-head .follow-more,.gg-window .online,.guest-home .button-box button,.head .dropdown-menu .article-list,.home-container .at-popup,.hot-recom-module .random-change,.interact-dialog .btn,.international-home .bilibili-search-history,.item-wrap__task .operate-btn,.lang-change,.list-header .filter-wrp .article-type,.list-header .filter-wrp .category-wrp,.list-header .filter-wrp .filter-level,.list-header .filter-wrp .order-wrp,.list-header .filter-wrp .video-type,.love-card .header:after,.love-detail .follow-btn.active,.main-wrapper .comment-wrapper,.navbar-container,.nomal-task .card,.page-tab .con li,.practice-wrap .tab-container,.replies-comment-input-wrapper .replies-upload .comment-input-img,.reply-bottom-menu-mask .more-ops .cancel,.reply-input .input-area .reply-emoji-btn,.reply-input .input-area .reply-submit-btn,.reply-report .reason-choose .reason-group .list li input[type=radio],.report-dialog-container .submit .cancel-btn:after,.report-dialog-container .submit .submit-btn:after,.report-dialog-container .textarea-wrapper,.round-corner .out-container .tab-bar,.security_content .bcoin-wrapper,.security_content .title-right-link,.tab-line-itnl,.tabs .customize-tab,.ticket-tips-wrapper .rec-item,.ticket-tips-wrapper .ticket-tips,.time-line .tl-link,.title-container .info .activity,.ui-dropdown .ui-dropdown-text,.van-popover,.van-popper[x-placement^=bottom] .popper__arrow,.van-popper[x-placement^=top] .popper__arrow{border-color:transparent!important}.carousel-wrp .page .next,.item-wrap__task:after,.item-wrap__task:before,.security_content .coupon-wrapper .coupon-content-con{border-color:#aaa!important}#all-list .mixin-list ul:not(:last-child),.bili-search .article-item,.bili-search .bangumi-item,.bili-search .pgc-item,.bili-search .topic-item,.calendar-wrap .calendar-body .date-desc_wrap .item-desc_card .item-desc_body .item-desc__content,.calendar-wrap .calendar-header,.comic-episodes .episode-list .episode-item .item-body,.link-input,.live-category .latest,.mession-box .content,.mession-box .content .list-wrap .border-btm,.practice-wrap .banner-container .current-work,.reply-bottom-menu-mask .more-ops .ops-list li,.reply-list .reply-item,.round-corner .international-footer .link-box .link-item,.tab-content .bilibili-comment,.van-popper[x-placement^=bottom] .popper__arrow:after,.van-popper[x-placement^=top] .popper__arrow:after{border-color:#444!important}.app-layout .pivot-component .pivot-headers,.at-item:not(:last-child):after,.carousel-wrap .page .next,.center-box .orginal-reply,.container .play-all,.container .split-line::before,.container .tabs-panel,.elevator .list-box .item.sort,.liked-user:not(:last-child):after,.love-item:not(:last-child):after,.player-auxiliary-danmaku-report-wrap.player-auxiliary-danmaku-report-wrap-white .player-auxiliary-danmaku-report-box .player-auxiliary-danmaku-report-panel .player-auxiliary-report-panel-title,.reply-item:not(:last-child):after{border-color:#555!important}.app-layout .sidebar .nav-item .nav-item-icon,.follow-right-module .follow-head .follow-more .icon,.header-info .manga-info .action-buttons .do-favourite .fav-icon,.header-info .manga-info .supporting-text .label-icon,.hot-recom-module .random-change .icon_read,.index-entry-wrapper .filter-block-title a:after,.my-coupon .subtitle .question-cion,.security_content .m-arrow-package,.security_content .security-list:hover .security-icon,.whole-detail-info-wrapper .detail-info-wrapper .vuene-wrapper .address-icon{filter:brightness(0) invert(1)!important}.bili-search .so-icon i.icon-like,.bili-search .so-icon i.icon-reply,.bili-search .so-icon i.icon-view{filter:brightness(0) invert(.7)!important}.bili-search #live-list .headline-room .icon-live-face,.bili-search #live-list .headline-room .icon-live-frame,.bui-swiper-wrap .bui-swiper-next svg,.bui-swiper-wrap .bui-swiper-pre svg,.fjw-random .agree.active,.fjw-random .agree:hover,.fjw-random .unagree.active,.fjw-random .unagree:hover,.fold-box:hover .fold-arrow,.home-slide .trigger span.on,.ops canvas.ring-progress,.sticky-bar .bar-content .title-icon,.svga-container.svga-center canvas{filter:var(--blue-image-filter)!important}.activity-info .icon-activity,.buyticket .product-buy.enable,.calendar-date-body .wrap-content img,.comment .up-icon.active,.detail-content .comment .hot-icon span,.guest-wrapper .icon-guest,.reason-container .reason-category .other-reason .icon-select.selected,.reason-container .reason-category .reason-item .icon-select.selected,.replies-comment-input-wrapper .replies-upload .comment-input-img span,.replies-comment-input-wrapper .replies-upload .replies-uploading-container .replies-uploading-btn,.replies-comment-input-wrapper .replies-upload .replies-uploading-container p span:hover,.report-pc-dialog .report-dialog-container .title i:hover,.ticket-count .count-plus.active:after,.ticket-count .count-reduce.active:before,.ticket-tips-wrapper .ticket-tips-header span,.whole-detail-info-wrapper .product-buy-wrapper .want-wrapper .want-icon{filter:var(--pink-image-filter)!important}.fans-medal-item.special-medal .union{filter:brightness(.125)!important}.video-info-m .number .coin b,.video-info-m .number .coin i,.video-info-m .number .fav b,.video-info-m .number .fav i{filter:brightness(.135)!important}.bili-share-pc .favourite .icon-fav,.news-dialog__wrapper .trangle-img img{filter:brightness(.27)!important}.box .record-wrap,.buyticket .product-buy.enable,.comment .comment-hot-item-user-content,.comment .comment-selecotr,.replies-comment-input-wrapper .submit-comment{box-shadow:none!important}.bilibili-player-ending-panel-box-recommend:hover,.guest-wrapper .guest-list .guest-item:hover .image,.navbar-container,.pgc-space-follow-item .bangumi-options .opt-list,.player-auxiliary-danmaku-report-wrap.player-auxiliary-danmaku-report-wrap-white .player-auxiliary-danmaku-report-box .player-auxiliary-danmaku-report-panel,.section-block .at-popup,.selectable-option.active{box-shadow:0 1px 10px 0 var(--theme-color-30)!important}.members-info .up-card{margin:16px!important}.bili-search #live-list .live-tabs a.active,.bilibili-player-ending-panel-box-functions .bilibili-player-upinfo-head.up-avatar:hover,.comic-info-component .page-normal .comic-tab .tab-titles .tab-title.active .tab-btn,.live-tabs .tab-switch .tab-switch-item.on,.replies-comment-input-wrapper .replies-upload .comment-input-img:hover,.selectable-option.active,.selectable-option.active:after,.tabs-nav .tab-item.border-bottom,.time-line .tab-switch .tab-switch-item.on{border-color:var(--theme-color)!important}.app-layout .dropbox-component .data-list>li:hover,.be-tags-container .tag,.bili-search .user-item .attention-btn:hover,.bottom-box .complete .complete_text:before,.bui-swiper-wrap .bui-swiper-next:hover,.bui-swiper-wrap .bui-swiper-pre:hover,.calendar .days li.selected,.calendar-wrap .calendar-body .date-wrap .wrap-content .select-icon,.carousel-wrap .page .next.current,.channel-menu-itnl .item .name em,.comic-info-component .page-normal .comic-info-con .comic-des .comic-operation .comic-view-btn,.comment .comment-selecotr .all-comments.active:before,.comment .comment-selecotr .sortByHot.active:before,.container .more-btn:hover,.container .tab-item--active,.elevator .list-box .item.on,.elevator .list-box .item:hover,.episode-list-component .episode-list .list-data .list-item:hover,.exchange-btn .btn:hover,.follow-right-module .follow-head .follow-more:hover,.guest-home .button-box button:hover,.h5share-container .tag,.home-slide .trigger span:hover,.interact-dialog .btn,.item-wrap__task .item-index,.live-rank .live-rank-item .number.on,.live-room-app .guard-rank-cntr .rank-cntr .btn-box .buy:hover,.manga-button.primary:hover,.navbar-container .nav-items .nav-item.activated:before,.news-dialog__wrapper .dialog-wrapper__desc .dialog-wrapper__btn,.pgc-rank-wrap .number.on,.practice-wrap .banner-container .current-work .bili-btn,.progress-bar-core.p-absolute,.qa-area-ol-wrp .qa-area-ol-btn,.rank-wrap .number.on,.replies-comment-input-wrapper .submit-comment,.reply-emoji-panel .emoji-list .emoji-pager .pager-dot.on,.reply-input .input-area .reply-emoji-btn:hover,.reply-input .input-area .reply-submit-btn:hover,.reply-report .reason-choose .reason-group .list li input[type=radio]:checked:after,.reply-report .submit-btn button,.round-corner .out-container .tab-item.active,.security_content .close-btn:hover,.security_content .coupon-content-con .coupon-btn:hover,.style-section .tag-block .tag-containers .style-tag:active,.tabs-wrapper .tabs .tabs-item.active:before,.time-line .tl-link:hover,.video-control-show .bilibili-player-video-interactive-list .check:hover .big-round,.video-editor-ol-wrp .video-editor-ol-btn,.vip-m .bubble-traditional .renew-btn button:hover{background-color:var(--theme-color)!important}#all-list .user-item .title:hover,.activity-item .info .title:hover,.article-card .r-con .title:hover,.article-container:hover .text-area .title,.bangumi-item .right-info .headline .title:hover,.bili-search #live-list .headline-live .user-more:hover,.bili-search #live-list .headline-room .filter a.active,.bili-search #live-list .headline-room .filter a:hover,.bili-search #live-list .live-tabs a.active,.bili-search .article-item .content .title:hover,.bili-search .live-room-item .item-title:hover,.bili-search .live-user-item .item-right .uname:hover,.bili-search .pgc-item .right-info .headline .title:hover,.bili-search .photo-item .title:hover,.bili-search .topic-item .content .headline a:hover,.bili-search .user-item .title:hover,.bottom-box .complete .uncomplete,.bui-swiper-wrap .bui-swiper-item .bui-swiper-text:hover,.calendar-wrap .calendar-body .date-desc_wrap .date-desc__content .nothing-wrap .release-link,.calendar-wrap .calendar-body .date-desc_wrap .item-desc_card .item-desc_body .item-desc__content .item-desc_share,.calendarEntry_wrap .calendarEntry_footer .footer-link,.calendarEntry_wrap .greetings .greet-num,.card .forw-area a.more:hover,.card .more-panel .child-button:hover,.cc-nav-wrp .activity-nav-wrp .activity-link.active i,.cc-nav-wrp .activity-nav-wrp .activity-link.active span,.cc-nav-wrp .activity-nav-wrp .activity-link:hover i,.cc-nav-wrp .activity-nav-wrp .activity-link:hover span,.cc-nav-wrp .nav-item.active i,.cc-nav-wrp .nav-item.active span,.cc-nav-wrp .nav-item:hover i,.cc-nav-wrp .nav-item:hover span,.center-box .line-1 .like-item:hover,.center-box .line-3 .action-button.active,.center-box .line-3 .action-button:hover,.comic-info-component .page-normal .comic-tab .tab-titles .tab-title.active,.coming-soon-wrapper .card-wrapper .card-item .info-wrapper .title:hover,.comment .comment-selecotr .all-comments.active,.comment .comment-selecotr .sortByHot.active,.comment .more-replys span,.container .count-item:hover .item-key,.container .count-item:hover .item-value,.container .publish-time,.container .video-list .content:hover,.customize-wrap .item-list .item .learn.unlearn,.d-data .fold-box:hover,.gg-window .online a:hover,.guest-wrapper .guest-list .guest-item:hover .name,.index-entry-wrapper .filter-block-title a:hover,.index-entry-wrapper .filter-list .filter-item:hover,.international-header a:hover,.international-home .bilibili-search-history .cancel-icon:hover,.lang-change .lang-intro-item.on,.left-nav-childed .left-nav-childed-list .left-nav-item-childed:hover span,.left-nav-childed .left-nav-childed-list.active .left-nav-item-childed span,.left-nav-item-child:hover i,.left-nav-item-child:hover span,.left-nav-list.active .left-nav-item i,.left-nav-list.active .left-nav-item span,.left-nav-wrapper .left-nav-ul .left-nav-item:hover i,.left-nav-wrapper .left-nav-ul .left-nav-item:hover span,.list-header .filter-wrp .article-type .bili-btn.current,.list-header .filter-wrp .filter-level .bili-btn.current,.list-header .filter-wrp .video-type .bili-btn.current,.live-card .up .txt .name:hover,.live-category .latest a.active,.live-category .latest a:hover,.live-tabs .tab-switch .tab-switch-item.on,.main-panel .more:hover,.mession-box .btn:hover,.n-statistics a:hover,.new-comers-module .zone-title .headline .name:hover,.pgc-rank-wrap .txt .title:hover,.pivot-component .pivot-headers .pivot-header-item.selected,.pivot-component .pivot-headers .pivot-header-item:active,.qa-area-ol-wrp .qa-area-ol-content a:hover,.rank-wrap .link p:hover,.rank-wrap .preview .txt p:hover,.replies-comment-input-wrapper .replies-upload .comment-input-img,.round-corner .international-footer .link-box .link-item ul a:hover,.round-corner .international-footer .link-box .link-item.link-c a:hover p,.round-corner .international-footer .partner a:hover,.round-corner .out-container .tab-item:hover,.schedule-list .list-header .date-selector .date-item.active,.security_content .coupon-content-con .coupon-money,.security_content .coupon-money-1:after,.security_content .coupon-money-2:after,.security_content .security-list-link-jump:hover,.security_content .title-right-link:hover,.selectable-option.active,.sub-reply-preview .show-more,.sub-reply-preview .sub-preview-item a,.tabs-wrapper .tabs .tabs-item.active,.time-line .tab-switch .tab-switch-item.on,.time-line-card .txt .update .published,.time-line-card .txt a:hover,.up-info .up-focus-btn,.user-item .up-videos .video-item .video-desc:hover,.user-item .up-videos .video-more:hover,.van-popover a:hover,.video-card-common .title:hover,.video-card-common .up:hover,.video-editor-ol-wrp .video-editor-ol-content a:hover,.video-item-biref:hover .biref-info .biref-title,.video-item.matrix .title:hover,.video-list .card-txt:hover,.whole-detail-info-wrapper .product-buy-wrapper .want-wrapper .want-content p:hover,.whole-pagination-wrapper .common-pagination-wrapper .pageNum.active,.whole-pagination-wrapper .common-pagination-wrapper .pageNum:hover{color:var(--theme-color)!important}#page-fav .fav-sidenav .fav-item.cur .be-dropdown-trigger .icon-ic_more,#page-fav .fav-sidenav .fav-item.cur .iconfont,#page-fav .fav-sidenav .fav-item.cur .num,#page-fav .fav-sidenav .fav-item.cur .text.router-link-exact-active.router-link-active,.app-layout .dropbox-component .data-list>li:hover,.bangumi-timing-module .headline .c-clink,.bangumi-timing-module .headline .c-clink:hover,.bilibili-player-ending-panel-box-functions .bilibili-player-upinfo-electric,.bilibili-player-ending-panel-box-functions .bilibili-player-upinfo-electric.little,.block-area .timeline-title .headline .timeline-more:hover,.comic-info-component .page-normal .comic-info-con .comic-des .comic-operation .comic-view-btn,.container .more-btn:hover,.container .tab-item--active,.dynamic-m .wnd_bottom a:hover,.edit-media-list .edit-mask .edit-board .edit-info .submit-btn,.elevator .list-box .item.on,.elevator .list-box .item:hover,.elevator-module .nav-list .customize:hover,.elevator-module .nav-list .item.on,.episode-list-component .episode-list .list-data .list-item:hover,.exchange-btn .btn:hover,.favInfo-box .favInfo-details .fav-options .fav-play:hover,.follow-dialog-wrap .follow-dialog-window .bottom .btn,.follow-right-module .follow-head .follow-more:hover,.guest-home .button-box button:hover,.h5share-container .tag,.item-wrap__task .item-index,.link-navbar .nav-item:hover .nav-link,.live-rank .live-rank-item .number.on,.manga-navbar-manga-logo,.new-stat-module .zone-title .headline .new-stat-more:hover,.pgc-rank-wrap .number.on,.practice-wrap .banner-container .current-work .bili-btn,.qa-area-ol-wrp .qa-area-ol-btn,.rank-wrap .number.on,.reply-input .input-area .reply-emoji-btn:hover,.reply-input .input-area .reply-submit-btn:hover,.round-corner .out-container .tab-item.active,.security-left .on .security-nav-name,.security_content .close-btn:hover,.security_content .coupon-content-con .coupon-btn:hover,.security_content .security-list:hover .security-nav-name,.sticky-bar .bar-content .send-button .send-text,.time-line .tl-link:hover,.timeline-box .timeline-item.new p.num a,.upload-v2-step1-container #homeDrop .upload-btn .upload-btn-title,.video-editor-ol-wrp .video-editor-ol-btn{color:var(--foreground-color)!important}.bilibili-player-ending-panel-box-functions .bilibili-player-upinfo-follow .bp-svgicon{fill:var(--foreground-color)!important}.selectable-option.active:after{border-top-color:transparent!important;border-left-color:transparent!important}.van-popper[x-placement^=bottom] .popper__arrow:after,.van-popper[x-placement^=top] .popper__arrow:after{border-left-color:transparent!important;border-right-color:transparent!important}.feed-topic .empty-content,.report-dialog-container .textarea-wrapper{border-radius:4px!important}.level-1{border-color:#44b0a0!important}.level-1 .label{background-color:#44b0a0!important}.level-1 .level{color:#44b0a0!important}.level-2{border-color:#44b0a0!important}.level-2 .label{background-color:#44b0a0!important}.level-2 .level{color:#44b0a0!important}.level-3{border-color:#44b0a0!important}.level-3 .label{background-color:#44b0a0!important}.level-3 .level{color:#44b0a0!important}.level-4{border-color:#44b0a0!important}.level-4 .label{background-color:#44b0a0!important}.level-4 .level{color:#44b0a0!important}.level-5{border-color:#74b0f6!important}.level-5 .label{background-color:#74b0f6!important}.level-5 .level{color:#74b0f6!important}.level-6{border-color:#74b0f6!important}.level-6 .label{background-color:#74b0f6!important}.level-6 .level{color:#74b0f6!important}.level-7{border-color:#74b0f6!important}.level-7 .label{background-color:#74b0f6!important}.level-7 .level{color:#74b0f6!important}.level-8{border-color:#74b0f6!important}.level-8 .label{background-color:#74b0f6!important}.level-8 .level{color:#74b0f6!important}.level-9{border-color:#ba94f2!important}.level-9 .label{background-color:#ba94f2!important}.level-9 .level{color:#ba94f2!important}.level-10{border-color:#ba94f2!important}.level-10 .label{background-color:#ba94f2!important}.level-10 .level{color:#ba94f2!important}.level-11{border-color:#ba94f2!important}.level-11 .label{background-color:#ba94f2!important}.level-11 .level{color:#ba94f2!important}.level-12{border-color:#ba94f2!important}.level-12 .label{background-color:#ba94f2!important}.level-12 .level{color:#ba94f2!important}.van-popover .level-bar .level-progress{background-color:#ffae00!important}#biliAppHomeSetting>div,#gift-package-item-box .panel-wrapper,.app-layout .manga-navbar,.container .play-all,.container .split-line .history-tip,.hover-panel-wrap,.hover-panel-wrapper,.lang-change .lang-intro,.manga-navbar .drop-list,.title-renew-panel .actions,.user-title-using-cntr .panel,.van-popover .container{background-color:#222!important}.container .level-intro,.container .play-all:hover,.international-header .bili-banner,.manga-navbar .drop-list .more-btn-container,.manga-navbar .search-bar .search-bar-bg,.manga-navbar .user-panel .drop-list .logout-btn-container,.message-list-content .notify-wrapper .notify-text,.recommend-area-ctnr .rec-area-item,.skeleton .skeleton-content,.skeleton .skeleton-focusbtn,.skeleton .skeleton-head,.skeleton .skeleton-time,.skeleton .skeleton-user-name,.user-title-using-cntr .user-title-box,.van-popover .btn-box .btn.reg-btn:hover,.van-popover .upload-item:hover,.yzly-content-ctnr .btn{background-color:#333!important}.wide-members .avatar-list i{background-color:#444!important}.wide-members .avatar-list i:hover{color:var(--theme-color)!important}.grid-area-ctnr .hab-ctnr,.grid-area-ctnr .news-ctnr,.grid-area-ctnr .rank-ctnr{background-color:#444!important}.confirmorder-container{background-color:#444!important;box-shadow:none!important}.confirmorder-container h1{color:#eee!important}.confirmorder-container h1 span{color:#aaa!important}.confirmorder-container .card .card-bottom .delete{filter:brightness(0) invert(.7)!important}.confirmorder-container .card .card-bottom .delete:hover{filter:var(--pink-image-filter)!important}.confirmorder-container .card.active{border-color:var(--theme-color)!important}.confirmorder-container .card.active::before{filter:var(--pink-image-filter)!important}.confirmorder-container .discounts{border-color:#555!important}.confirmorder-container .discounts .discounts-list p{border-color:transparent!important;background-color:#111!important;color:#666!important}.confirmorder-container .total-container div span{color:#eee!important}.confirmorder-container .total-container div span.total{color:var(--theme-color)!important}.confirmorder-container .confirm-bottom .confirm-paybtn.active{filter:var(--pink-image-filter)!important}.confirmorder-container .confirm-bottom .service-term{color:#aaa!important}.confirmorder-container .confirm-bottom .service-term .check-icon,.confirmorder-container .confirm-bottom .service-term .check-icon.checked{filter:var(--pink-image-filter)!important}.confirmorder-container .confirm-bottom .service-term .term-content{color:var(--theme-color)!important}.eticket-container .top-box .header{border-color:transparent!important;background-color:#333!important}.eticket-container .top-box .header .header-back{filter:brightness(0) invert(1)!important}.eticket-container .top-box .header h1{color:#eee!important}.eticket-container .top-box .header::after{border-color:transparent!important}.eticket-container .eticket-info-container{background-color:#444!important;box-shadow:none!important}.eticket-container .eticket-info-right div{color:#eee!important}.eticket-container .eticket-info-right p{color:#aaa!important}.eticket-container .qrcode-container{background-color:#444!important}.eticket-container .qrcode-container .qrcode-tip{background-color:transparent!important;color:#eee!important}.eticket-container .qrcode-container .qrcode-container-item .qrcode-hide-tip{color:#eee!important}.eticket-container .qrcode-container .ticket-code,.eticket-container .qrcode-container .ticket-code .color-gray-light,.eticket-container .qrcode-container .ticket-type,.eticket-container .qrcode-container .ticket-type .color-gray-light{color:#aaa!important}.eticket-container .qrcode-container .ticket-code span,.eticket-container .qrcode-container .ticket-type span{color:#eee!important}.eticket-container .qrcode-container .addr-map{background-color:#383838!important}.eticket-container .qrcode-container .addr-map h1{color:#eee!important}.eticket-container .qrcode-container .addr-map p{color:#aaa!important}.eticket-container .qrcode-container .addr-map .map-icon{filter:var(--pink-image-filter)!important}.orderdetail-container .orderdetail-wrapper{color:#aaa!important}.orderdetail-container .orderdetail-wrapper .wrapper-ticket{color:#eee!important}.orderdetail-container .orderdetail-wrapper .wrapper-ticket .tip{color:var(--theme-color)!important}.orderdetail-container .total-container div span{color:#eee!important}.orderdetail-container .total-container div span.total{color:var(--theme-color)!important}#biliAppHomeSetting input,#biliAppHomeSetting select,.highlight-areas-ctnr .highlight-area-item,.s_tag .btn-add,.section-block .flip-view,.share-content .video-card,.van-popover .btn-box .btn.reg-btn,.van-popover .level-bar,.van-popper-history .view-all{background-color:#444!important}.love-card .header::after{background-color:#555!important}.s_tag .btn-add span{background-color:#eee!important}.coin-dialog-mask .coin-operated .mc .mc-box{background-color:#fff!important}.card .risk-tip-content{background-color:#624f27!important}.live-room-app .aside-area .chat-history-panel-top,.manga-navbar .nav-list,.news-content,.news-ctnr .more-link,.news-ctnr .more-link:hover,.publish-panel .editor:focus,.publish-panel .editor:focus-within,.publish-panel .editor:hover,.text-info-ctnr,.title-renew-panel .card{background-color:transparent!important}.manga-navbar .search-bar .placeholder-list .placeholder-item{color:#888!important}#biliAppHomeSetting label~span,.bb-comment .comment-list .list-item .blacklist-font-color,.center-box .line-3 .action-button,.comment-bilibili-fold .comment-list .list-item .blacklist-font-color,.container .split-line .history-tip,.follow-dialog-wrap .special-tip,.highlight-areas-ctnr .area-desc,.list-item .publish-time,.manga-navbar .data-list .list-container .empty-hinter,.manga-navbar .data-list .list-container .failure-hinter,.manga-navbar .data-list .list-container .loading-hinter,.rank-item .room-title,.share-content .video-card .up-info .name,.share-content .video-card .up-info .tip,.video-container .text-area .view-danmaku{color:#aaa!important}#biliAppHomeSetting a,#biliAppHomeSetting input,#biliAppHomeSetting select,.center-box .line-1 .like-item,.center-box .line-1 .name-field,.center-box .line-1 .name-field a,.manga-navbar .drop-list .more-btn-container .more-button,.manga-navbar .search-bar .search-input,.manga-navbar .user-info-panel .info-item,.manga-navbar .user-info-panel .user-name,.manga-navbar .user-panel .drop-list .logout-btn-container .logout-button{color:#eee!important}.center-box .line-2 .im-dynamic-link{color:var(--theme-color)!important}.bb-comment .comment-send .dynamic-repost,.comment-bilibili-fold .comment-send .dynamic-repost{color:#ccc!important}.area-detail-ctnr .area-title,.banner-ctnr .banner-title,.bilibili-player-video-danmaku-setting-left-block-word,.item-ctnr .item-title,.love-card .header,.manga-navbar-favourite-manga .action-button,.manga-navbar-history-list .action-button,.more-ctnr,.news-content,.news-ctnr .more-link,.rank-item .room-anchor,.recommend-area-ctnr .area-name,.recommend-area-ctnr .title-text,.tab-ctnr .tab-item,.user-title-using-cntr .user-title-box .name,.van-popover .btn-box .btn.reg-btn,.van-popover .coins .info a,.van-popper-history .view-all,.van-popper-login .title,.van-popper-upload .upload-item .bilifont,.yzly-ctnr .yzly-title{color:#eee!important}.international-header .mini-upload:hover,.van-popover .vip:hover{color:#fff!important}.editor .placeholder-shown::before{color:#666!important}.highlight-areas-ctnr .highlight-area-item:nth-child(1) .area-name{color:#a0a7dc!important}.highlight-areas-ctnr .highlight-area-item:nth-child(2) .area-name{color:#c7aade!important}.highlight-areas-ctnr .highlight-area-item:nth-child(3) .area-name{color:#deb29c!important}.highlight-areas-ctnr .highlight-area-item:nth-child(4) .area-name{color:#afb7e8!important}.highlight-areas-ctnr .highlight-area-item:nth-child(5) .area-name{color:#dcbf94!important}.highlight-areas-ctnr .highlight-area-item:nth-child(6) .area-name{color:#95c5a8!important}.card-content .like-users-panel::before{background-color:#666!important}.card-content .like-users-panel .users-box,.card-content .like-users-panel .users-box .like-users-list,.card-content .like-users-panel .users-box .like-users-list:active,.card-content .like-users-panel .users-box .like-users-list:link,.card-content .like-users-panel .users-box .like-users-list:visited{color:#eee!important}.card-content .like-users-panel .suffix-text{color:#aaa!important}.live-room-app .aside-area .chat-control-panel{background-image:none!important}.charge-container{background-color:transparent!important}.charge-container .charge-header-close{filter:brightness(0) invert(1)!important}.charge-container .charge-header-bg{background-image:none!important}.charge-container .charge-header .user-link{background-color:#333!important;border-color:transparent!important}.charge-container .charge-header .user-link .user-name{color:#eee!important}.charge-container .charge-header .user-link:hover .user-name{color:var(--theme-color)!important}.charge-container .battery-item .battery-bg{background-color:#333!important;border-color:transparent!important}.charge-container .battery-item .battery-tool input{background-color:transparent!important;border-color:#444!important;color:#eee!important}.charge-container .battery-item.active .battery-bg{background-color:#444!important;border-color:var(--theme-color)!important}.charge-container .battery-item.active .battery-text{color:var(--theme-color)!important}.charge-container .battery-item.active .battery-tool input{border-color:var(--theme-color)!important}.charge-container .charge-info{color:#eee!important}.charge-container .charge-info span{color:var(--theme-color)!important}.charge-container .split-line{background-color:#444!important}.charge-container .battery-pay-info{color:#eee!important}.charge-container .battery-pay-info span{color:var(--theme-color)!important}.charge-container .battery-pay-info .battery-pay-tips span,.charge-container .battery-tips{color:#aaa!important}.charge-container .battery-tips a,.charge-container .battery-tips a:hover{color:var(--theme-color)!important}.charge-container .checkbox-bwxr.active{filter:var(--blue-image-filter)!important}.charge-container .btn-default{background-color:var(--theme-color-80)!important;color:var(--foreground-color)!important;border-color:transparent!important}.charge-container .btn-default:hover{background-color:var(--theme-color)!important}.charge-container .charge-success-content>p{color:#eee!important}.charge-container .charge-success-content>p i,.charge-container .charge-success-content>p span{color:var(--theme-color)!important}.charge-container .charge-success-content>.charge-success-message{border-color:var(--theme-color)!important}.charge-container .charge-success-content>.charge-success-message .charge-success-message-tool span{color:#aaa!important}.activity-m .inside-wrp{border-color:#444!important}.activity-m .inside-wrp .right .inside-bg::before{background-image:linear-gradient(90deg,#222,transparent 30%)!important}.activity-m .hinter-msg{color:#eee!important}.activity-m .b-btn-praise{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.activity-m .b-btn-praise.voted{color:#aaa!important;border-color:transparent!important;background-color:#333!important}.international-home .contact-help{color:#999!important;background-color:#333!important;border-color:transparent!important;box-shadow:0 6px 10px 0 #111!important}.bili-header-m .mini-type .nav-search #nav_searchform,.international-header .mini-type .nav-search #nav_searchform,.van-popover .mini-type .nav-search #nav_searchform{background-color:#333!important;border-color:transparent!important}.bili-header-m .mini-type .nav-search #nav_searchform .nav-search-keyword,.international-header .mini-type .nav-search #nav_searchform .nav-search-keyword,.van-popover .mini-type .nav-search #nav_searchform .nav-search-keyword{color:#aaa!important}.bili-header-m .mini-type .nav-search #nav_searchform .nav-search-keyword:focus,.international-header .mini-type .nav-search #nav_searchform .nav-search-keyword:focus,.van-popover .mini-type .nav-search #nav_searchform .nav-search-keyword:focus{color:#eee!important}.bili-header-m .mini-type .nav-search .nav-search-btn,.international-header .mini-type .nav-search .nav-search-btn,.van-popover .mini-type .nav-search .nav-search-btn{background-color:#444!important}.bili-header-m .mini-type .nav-search .nav-search-btn .nav-search-submit,.international-header .mini-type .nav-search .nav-search-btn .nav-search-submit,.van-popover .mini-type .nav-search .nav-search-btn .nav-search-submit{color:#eee!important}.bili-header-m .mini-type .nav-search .nav-search-btn:hover .nav-search-submit,.international-header .mini-type .nav-search .nav-search-btn:hover .nav-search-submit,.van-popover .mini-type .nav-search .nav-search-btn:hover .nav-search-submit{color:var(--theme-color)!important}.bilibili-search-history,.bilibili-search-suggest{background-color:#333!important;border-color:transparent!important}.module-game .rule .detail .content{color:#000!important}#biliAppHomeSetting input,#biliAppHomeSetting select{border-color:transparent!important;border-radius:4px}#gift-package-item-box .panel-wrapper::before,.at-popup,.chat-popups-section .draw-full-ctnr,.hover-panel-wrap,.hover-panel-wrapper,.recommend-area-ctnr .rec-area-item,.title-renew-panel .actions,.van-popover .btn-box .btn.reg-btn,.van-popper-history .view-all{border-color:transparent!important}.wide-members .avatar{border-color:#333!important}.van-popper-login .container{border-color:#444!important}#page-fav .fav-sidenav .icon:not(.icon-cursor),.container .level-intro .svg-icon,.manga-navbar .search-bar .confirm-btn .search-icon{filter:brightness(0) invert(1)!important}.side-bar-btn .size-bar-text{filter:brightness(.6) invert(1) hue-rotate(180deg)!important;text-shadow:0 0 0}.confirmorder-container .confirm-bottom .confirm-paybtn.active,.whole-detail-info-wrapper .product-buy-wrapper .unsale-btn{box-shadow:0 3px 4px 0 #6e4752!important}.app-layout .manga-navbar{box-shadow:rgba(0,0,0,.2) 0 4px 8px 0!important}.highlight-areas-ctnr .highlight-area-item.hover{box-shadow:0 7px 11px 0 rgba(0,0,0,.18)!important}.hover-panel-wrap{box-shadow:0 13px 20px 0 rgba(0,0,0,.22)!important}.van-popper .popper__arrow{display:none!important}.nav-tab-bar .tab-item[data-tab-id="1"]:not(.on)::before{background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADgAAAA4CAQAAAACj/OVAAAD00lEQVRYw+2YbWhVdRzHb2aWsILo4UVC5Pd3drfdIZNW1sRod7eW1gSxLIxo5aWgB1GHbkNaDILoAaJYtKQNRDHQTcp6McQoISusXuSLZTXXICVoa3Nmtu0+nE8vdtzd1T3c7dzzzu/31b2X+//w+//+5/y+54RCVzSLKq+zqD1t9driPB4uCxjm3G+f6ILI2E7bu+ElgcB0u3UJIXcd23mT19jMqnHsiF6vXJjv2iqtX5S5HzDAZHWzFbnCjjq35BFnK21UxBlmKv3ESlfoRKQgf5vZL17F9QBDfMkRkpOQf1ON0Of5qm+/iHu4f2jEQYhDWVWeptwVzmN5wIVXiFL3LwB6qEAYMRou6SXsR1jvhqv919cq3gIgyVpEDT9P2UmXGMKiPnFcpT/FLwC0Ie5hiOn0DsJafAKLbhMrvAUfRbQxvX5A2Dd+O3i3WOcteC/ixxmAZxDq89vBKvGUt+Au6iYujak0jNCg3ztMRDxEbvoNYd1+gTfILXHHcgJ2IazL/2XxnTiSE3AbwqnzD9whanPA9RNxRdFS38BlN2pQfDUrsB5hB/Jz894qyt0/ZsQdQNhoofICbF6gz0SUnmlxnYRdYc/kbR5GCnRcLHP3kboMNkAjQjjNeY5O2itElBa6GfNG1VGaiLhCI1ab/0wTEzYRnpYTyUSpzqKiAEKU7RJvJz5idQZ1VsetySkNJo0utAHxKwCfIuzrisXBJtJqUe0dk+cQeiHgCKw28Z53VIpRym4NFFd+jQbFKQAOIuyLgOuzNWKNt6GbEPZ80MDd4n1vyFrCkuGbA8VFFums6Ju4Z+pwwPUV1ogab0NrEc6mvCPCZc5L1qp2zz1iOTFixHBQWnvVrnZrceJ5mQ6RAmuVO/kZcHrbmL3iO2vbx6KUnYl9dNBBB7tpyHKL9/0etiSUFtbkD7dalLl9Oea0b91CLGGOH+AesYonc/ZdiKU75/2cZMdy691lvTzo2Dwyto2JZTzAxjlU+ASVlCBsoDg8t+qW2DnR9N8Ic9cQ8YSw3sii2UbOtU6FnnXiTtyJO4dEufvycD3zcR02IuzD8bWsquj6qWq6T7/Pr2M5eEgbL+2YY+dFdbqBRuqTm89FU9FkllNV6ap0VTrmXnTm0/gvWf9IRVPRVHVy2/kdifrU+qSQW/hg9kDtFNtnfPjyo1aETk7CVSzWvw6DBKcKRGFJ5risFesJUg0INWZFvpZAgYcRdiwDPCO6AwVeoBilim8a39BScSen6A3Uj4wKZ0MoFAqFiu/Idd759sMXD82LOqGTAft7543mBVfeoAeg/wFlFeKImou+wAAAAABJRU5ErkJggg==)!important}.aside-item.active .item-border,.aside-item:hover .item-border{border-color:var(--theme-color)!important}.aside-item::after{border-right-color:var(--theme-color)!important}#bilibili_pbp,#bilibili_pbp_canvas{filter:var(--pink-image-filter)!important}#biliAppHomeSetting button,.bui-button.bui-button-gray:hover,.interact-dialog .btn,.rookie-guide .close-button,.van-popover .btn-box .btn,.van-popper-history .view-all:hover,.video-control-show .bilibili-player-video-interactive-list .check:hover .big-round{background-color:var(--theme-color)!important}#biliAppHomeSetting h2,.bilibili-search-suggest .suggest-item .suggest_high_light,.more-ctnr:hover,.news-ctnr .more-link:hover,.tab-ctnr .tab-item.activated,.tab-ctnr .tab-item:hover,.van-popover .coins .info a:hover,.van-popper-upload .upload-item:hover .bilifont,.video-desc .subtitle a{color:var(--theme-color)!important}#biliAppHomeSetting button,.bui-button.bui-button-gray:hover,.interact-dialog .btn,.rookie-guide .close-button,.van-popover .btn-box .btn,.van-popper-history .view-all:hover{color:var(--foreground-color)!important}`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/dark-important.min.css"] = `#disable-popup-modal .vip-exchange .months button.disabled,#vip-exchange-modal .vip-exchange .months button.disabled,.action-row .publish-btn.disabled,.action-row .publish-btn.publishing,.action-row .sch-pub-btn.disabled,.action-row .sch-pub-btn.publishing,.app-body .section-block,.bl-button--primary:disabled,.home-content .publish-btn.disabled,.link-footer,.payment-active,.player-auxiliary-area .player-auxiliary-bscrollbar .bscroll-indicator,.tab-list .tab-item.active:before{background-color:#222!important}.app-body .section-block.with-bottom-radius,.app-body .section-block.with-radius,.bb-comment .no-login .comment-submit,.common .bb-comment .no-login .comment-submit,.container .pagination,.coupon-content-con .coupon-btn-disable,.customize-wrp .select,.f-list-hover:hover,.fjw-case-detail .ban-detail .content-box .video-model,.game-groom-m .num,.main-container .media-info .media-right .media-tool-bar .btn-follow.active,.main-container .pay-bar .vip .btn-pay.active,.open-dialog-masker .open-dialog-content .open-footer .btn-normal.disabled,.open-dialog-masker .open-dialog-content .open-footer .btn-normal.disabled:hover,.pagination-container li.pagination,.status_box .status_btn.disabled,.wrapper .elec-btn.disabled{background-color:#444!important}.danmaku-wrap .player-auxiliary-area .player-auxiliary-danmaku-wrap .bscroll-indicator{background-color:#555!important}.danmaku-wrap .player-auxiliary-area .player-auxiliary-danmaku-wrap .bscroll-vertical-scrollbar.mousedown,.danmaku-wrap .player-auxiliary-area .player-auxiliary-danmaku-wrap:hover .bscroll-vertical-scrollbar,.m-recommend-item div.box,.player-auxiliary-area .player-auxiliary-bscrollbar .bscroll-vertical-scrollbar,.player-auxiliary-area .player-auxiliary-bscrollbar .bscroll-vertical-scrollbar.mousedown,.player-auxiliary-area .player-auxiliary-bscrollbar:hover .bscroll-vertical-scrollbar{background-color:transparent!important}.open-dialog-masker .open-dialog-content .open-footer .btn-normal.disabled,.open-dialog-masker .open-dialog-content .open-footer .btn-normal.disabled:hover,.status_box .status_btn.disabled,blockquote,blockquote *,blockquote .color-blue-01,blockquote .color-blue-02,blockquote .color-blue-03,blockquote .color-blue-04,blockquote .color-gray-01,blockquote .color-gray-02,blockquote .color-gray-03,blockquote .color-gray-04,blockquote .color-green-01,blockquote .color-green-02,blockquote .color-green-03,blockquote .color-green-04,blockquote .color-lblue-01,blockquote .color-lblue-02,blockquote .color-lblue-03,blockquote .color-lblue-04,blockquote .color-pink-01,blockquote .color-pink-02,blockquote .color-pink-03,blockquote .color-pink-04,blockquote .color-purple-01,blockquote .color-purple-02,blockquote .color-purple-03,blockquote .color-purple-04,blockquote .color-yellow-01,blockquote .color-yellow-02,blockquote .color-yellow-03,blockquote .color-yellow-04{color:#aaa!important}#app .sticky-bar .bar-content .message,.bb-comment .no-login .comment-submit,.bp-popup-panel .title-ctnr .popup-title,.commnent-screen-wrap .el-input__inner,.common .bb-comment .no-login .comment-submit,.coupon-content-con .coupon-btn-disable,.cover .disabled-cover,.customize-wrp .select,.el-input__inner,.home-page .sticky-bar .bar-content .message,.invitation-record-warp .invtable .inputdone,.live-room-app .guard-rank-cntr .tabs.isHundred .item.active,.live-room-app .guard-rank-cntr.hundred .live-skin-highlight-text,.live-room-app .guard-rank-cntr.hundred .live-skin-main-a-text,.live-room-app .guard-rank-cntr.hundred .page-box .live-skin-main-text,.live-room-app .guard-rank-cntr.thousand .live-skin-highlight-text,.live-room-app .guard-rank-cntr.thousand .live-skin-main-a-text,.live-room-app .guard-rank-cntr.thousand .page-box .live-skin-main-text,.manga-detail .episode-list-component .episode-list .list-data .list-item.last-read,.popup-content-ctnr .bl-button--ghost,.s-paging>ul>a.current,.s-paging>ul>span.current,.score-info .go-movie,.tag-list li.tag-item.on{color:#eee!important}#rank-list-vm .tabs.isHundred .item,.bb-comment .no-login .comment-submit,.commnent-screen-wrap .el-input__inner,.common .bb-comment .no-login .comment-submit,.el-input__inner,.enter-failure .password-input .pink-border,.link-footer,.popup-content-ctnr .bl-button--ghost:hover,.score-info .go-movie,.select-box-v2-container .select-box-v2-controller-disabled,.song-info .info-wrap .type-list .item-list .type-item.active,.tabs-bar,.ui-input-textarea.focus,.user-setting-warp .el-radio-button__orig-radio:checked+.el-radio-button__inner{border-color:transparent!important}#app .sticky-bar .bar-content .message:hover,.app-layout .style-section .tag-block .tag-containers .style-tag.selected,.container .video-panel .play-all .bilifont,.detail-wrp .detail-content[data-v-00c9b213] p a span,.drop-list-v2-container .drop-list-v2-item-selected .drop-list-v2-item-cont p.item-cont-main,.edit-button:hover>.icon-font,.edit-button:hover>span .left-nav-item-childed:hover,.el-select-dropdown__item.selected,.home-page .sticky-bar .bar-content .message:hover,.im-popup .bp-popup-panel .title-ctnr .popup-title,.left-nav-wrapper .active,.left-nav-wrapper .active .left-nav-item-child,.left-nav-wrapper .advice-btn:hover,.left-nav-wrapper .left-nav-item.active,.left-nav-wrapper .left-nav-item.active i.active,.left-nav-wrapper .left-nav-list.on .left-nav-item,.left-nav-wrapper .left-nav-list.on .left-nav-item .icon,.live-room-app .guard-rank-cntr.hundred .live-skin-main-a-text:hover,.live-room-app .guard-rank-cntr.thousand .live-skin-main-a-text:hover,.live-skin-normal-a-text:active,.manga-detail .episode-list-component .episode-list .list-header .header-item.selected,.more-data a:hover,.other a a:hover,.r-con .members-info .up-card .info-name.is-vip:hover,.rank-item .content .info .detail a a:hover,.rank-item .content .info:hover .title,.rank-item .content .more-data:hover,.rank-item .content .other a:hover,.room-info-down-row .icon-label.hover-text-blue:hover .label,.room-introduction .edit-button:hover>.icon-font,.room-introduction .edit-button:hover>span,.round-corner .van-popper-favorite .play-all .bilifont,.up-info .u-info .name .username.is-vip:hover,.voucher-ing .voucher-left-money,.voucher-ing .voucher-left-money:before,.voucher-no-used .voucher-left-money,.voucher-no-used .voucher-left-money:before{color:var(--theme-color)!important}.aside-ctnr .author-info .communicate-btn,.manga-detail .episode-list-component .episode-list .list-data .list-item.last-read,.page-list-box .page-input:focus,.page-list-box .page-input:hover,.popup-content-ctnr .bl-button--ghost,.season-timeline .season-group.today,.season-timeline .season-group.today .group-time::before,.tag-list li.tag-item.on,.tag-list li.tag-item:hover{border-color:var(--theme-color)!important}.bg-blue,.el-date-table td.current:not(.disabled),.el-date-table td.end-date,.el-date-table td.start-date,.face-g-list#my-g-list .face-g-block .my-mp-block .mp-info .btn-white,.face-g-tab li.current,.popup-content-ctnr .bl-button--ghost:hover,.popup-content-ctnr .bl-button--primary,.season-timeline .season-group.today.is-published .group-time::before,.security-list .child-list li a.bg-blue:hover,.song-info .info-wrap .type-list .item-list .type-item.active,.tag-list li.tag-item.on,.user-my-btn .el-button--primary,.user-setting-warp .el-radio-button__orig-radio:checked+.el-radio-button__inner{background-color:var(--theme-color)!important}.current .tab-btn-link,.el-date-table td.current:not(.disabled),.el-date-table td.end-date,.el-date-table td.start-date,.face-g-tab li.current,.popup-content-ctnr .bl-button--ghost:hover,.style-section .tag-block .tag-containers .style-tag:active{color:var(--foreground-color)!important}#bilibiliPlayer{box-shadow:0 4px 8px 0 #0004;background-color:#222!important}.live-skin-coloration-area .live-skin-separate-area,.live-skin-coloration-area .live-skin-separate-area-hover:hover{background-color:#222!important}.live-skin-coloration-area .live-skin-normal-a-text,.live-skin-coloration-area .live-skin-normal-a-text:link,.live-skin-coloration-area .live-skin-normal-a-text:visited,.live-skin-coloration-area .live-skin-normal-text{color:#aaa!important}.live-skin-coloration-area .live-skin-highlight-text,.live-skin-coloration-area .live-skin-main-text{color:#eee!important}.live-skin-coloration-area .live-skin-highlight-border,.live-skin-coloration-area .live-skin-separate-border{border-color:transparent!important}.live-skin-coloration-area .live-skin-normal-a-text:hover{color:var(--theme-color)!important}.live-skin-coloration-area .room-info-ctnr .info-section .live-skin-highlight-border{border-color:var(--theme-color)!important}.live-skin-coloration-area .live-skin-highlight-bg{background-color:var(--theme-color)!important}`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/dark-navbar.min.css"] = `#link-navbar-vm>.link-navbar .nav-item:hover,.bili-header-m .nav-menu .nav-con .nav-item:hover,.link-navbar .nav-item:hover,.nav-header-wrapper .nav-header .nav-header-search-bar,.right-part>.shortcuts-ctnr .shortcut-item:hover,.search-bar-ctnr .search-bar,.shortcuts-ctnr .shortcut-item:hover,.uns_box ul.menu li:not(.b-post):hover,.z_top .z_top_nav ul li:hover{background-color:#222!important}#app>.link-navbar,#app>.nav-header-wrapper,#link-navbar-vm>.link-navbar,#navbar-vm>.link-navbar,.b-header-mask-wrp .b-header-mask,.bili-header-m .nav-menu .nav-mask,.bili-header-m .nav-menu.blur-black .nav-mask,.link-navbar{background-color:#444!important}.z_top .i-link:hover,.z_top .z_top_nav ul li.home:hover{background-color:transparent!important}#app>.nav-header-wrapper>.nav-header{background:0 0!important}#app>.link-navbar .main-ctnr .nav-logo,#app>.link-navbar .nav-item.selected .label,#app>.link-navbar .nav-item:hover .icon-font,#app>.nav-header-wrapper>.nav-header .nav-header-mainsite,#app>.nav-header-wrapper>.nav-header .order-center,#link-navbar-vm>.link-navbar .main-ctnr .nav-logo,#link-navbar-vm>.link-navbar .nav-item:hover,.bili-header-m .nav-menu .nav-con .nav-item .t,.link-navbar .main-ctnr .custom-link>a,.link-navbar .main-ctnr .nav-logo,.my-link-btn .label,.nav-header-wrapper .nav-header .nav-header-search-bar,.right-part>.shortcuts-ctnr,.right-part>.shortcuts-ctnr .shortcut-item:hover,.search-bar-ctnr .search-bar input,.shortcut-item .list-item span,.shortcuts-ctnr .shortcut-item,.uns_box li.u-i a.i-link,.z_top a,.z_top.b-header-blur .uns_box li.u-i a.i-link,.z_top.b-header-blur .z_top_nav li a.i-link{color:#eee!important}.search-bar-ctnr .search-bar .placeholder,.search-bar-ctnr .search-bar .search-btn,.search-bar-ctnr .search-bar input::placeholder{color:#878787!important}.uns_box li.u-i:hover a.i-link,.z_top .i-link:hover{color:var(--theme-color)}.link-navbar,.link-navbar-ctnr{box-shadow:none!important}.link-navbar .main-ctnr .nav-logo::before,.nav-header-wrapper .nav-header .order-icon{filter:brightness(0) invert(1)!important}.search-bar-ctnr .search-bar{border-color:transparent!important;box-shadow:0 2px 10px 1px #0002}`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/dark-schedule.min.js"] = (()=>{return(e,t)=>{class i{constructor(...e){if(e.length===0){const e=new Date;this.hour=e.getHours();this.minute=e.getMinutes()}else if(e.length===1){const[t]=e;[this.hour,this.minute]=t.split(":").slice(0,2).map(e=>this.validatePart(e));this.normalize()}else if(v.length===2){[this.hour,this.minute]=e}}validatePart(e){const t=parseInt(e);if(!isNaN(t)&&t>=0&&t<=59){return t}else{return null}}normalize(){while(this.minute<0){this.minute+=60;this.hour-=1}while(this.minute>=60){this.minute-=60;this.hour+=1}while(this.hour<0){this.hour+=24}while(this.hour>=24){this.hour-=24}}lessThan(e){if(this.hour<e.hour||this.hour===e.hour&&this.minute<e.minute){return true}return false}greaterThan(e){if(this.hour>e.hour||this.hour===e.hour&&this.minute>e.minute){return true}return false}equals(e){return this.hour===e.hour&&this.minute===e.minute}isInRange(e,t){if(e.equals(t)){return false}let i=this.greaterThan(e)&&this.lessThan(t);if(e.greaterThan(t)){i=this.greaterThan(e)||this.lessThan(t)}const s=i||this.equals(e);return s}static millisecondsBefore(e){const t=new i;const s=(new Date).getSeconds();const r=1e3*(t.hour*3600+t.minute*60+s);const n=1e3*(e.hour*3600+e.minute*60);let h=n-r;if(t.greaterThan(e)||t.equals(e)&&s!==0){h+=24*3600*1e3}return h}}function s(){if(e.darkSchedule){const t=new i(e.darkScheduleStart);const r=new i(e.darkScheduleEnd);const n=new i;const h=n.isInRange(t,r);if(e.useDarkStyle!==h){e.useDarkStyle=h}let u=0;if(h){u=i.millisecondsBefore(r)}else{u=i.millisecondsBefore(t)}if(u!==0){setTimeout(()=>s(),u)}}}fullyLoaded(()=>s());return{export:{ScheduleTime:i}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/dark-styles.min.js"] = (()=>{return(t,e)=>{const r=()=>{SpinQuery.select(".custom-scrollbar").then(t=>t&&t.classList.remove("custom-scrollbar"))};const l=()=>{document.body.classList.remove("dark");e.removeStyle("scrollbarStyle");e.removeStyle("darkStyleNavBar");e.removeStyle("darkStyle");e.removeStyle("darkStyleImportant")};const a=()=>{if(t.noDarkOnMember&&document.URL.startsWith("https://member.bilibili.com/v2")){l();return}document.body.classList.add("dark");r();e.applyStyle("scrollbarStyle");e.applyImportantStyle("darkStyleNavBar");e.applyStyle("darkStyle");e.applyImportantStyle("darkStyleImportant")};a();return{reload:a,unload:l}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/debounce.min.js"] = (()=>{return(n,l)=>{function u(n,l,u){var e,t,i,r,f;if(null==l)l=100;function o(){var a=Date.now()-r;if(a<l&&a>=0){e=setTimeout(o,l-a)}else{e=null;if(!u){f=n.apply(i,t);i=t=null}}}var a=function(){i=this;t=arguments;r=Date.now();var a=u&&!e;if(!e)e=setTimeout(o,l);if(a){f=n.apply(i,t);i=t=null}return f};a.clear=function(){if(e){clearTimeout(e);e=null}};a.flush=function(){if(e){f=n.apply(i,t);i=t=null;clearTimeout(e);e=null}};return a}return{export:{debounce:u}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/default-danmaku-settings.min.css"] = `.bilibili-player-video-danmaku-setting-wrap{display:none!important}`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/default-danmaku-settings.min.js"] = (()=>{return(e,t)=>{async function i(e,t){const i=await SpinQuery.select(()=>document.querySelector(e));if(!i){return}i.checked=t;raiseEvent(i,"change")}Observer.videoChange(()=>{if(!e.enableDanmaku){i(".bilibili-player-video-danmaku-switch>input",false)}if(e.rememberDanmakuSettings){const i={subtitlesPreserve:".bilibili-player-video-danmaku-setting-left-preventshade input",smartMask:".bilibili-player-video-danmaku-setting-left-danmaku-mask input"};async function n(){const n=await SpinQuery.select(()=>document.querySelector(".bilibili-player-video-danmaku-setting"));if(!n){return}await loadLazyPanel(".bilibili-player-video-danmaku-setting");setTimeout(()=>t.removeStyle("defaultDanmakuSettingsStyle"),300);for(const[t,n]of Object.entries(e.danmakuSettings)){const e=await SpinQuery.select(()=>document.querySelector(i[t]));if(e!==null&&e.checked!==undefined&&e.checked!==n){e.click()}}}async function a(){for(const t in e.danmakuSettings){const n=await SpinQuery.select(()=>document.querySelector(i[t]));if(!n){return}n.addEventListener("click",()=>{e.danmakuSettings=Object.assign(e.danmakuSettings,{[t]:n.checked})})}}n();a()}})}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/default-live-quality.min.js"] = (()=>{return(t,i)=>{(async()=>{if(!document.URL.match(/^https:\/\/live.bilibili.com\/(\d+)/)){return}const i=Resource.all.useDefaultLiveQuality.dropdown;const e=i.items;const l=t.defaultLiveQuality;const o=await SpinQuery.select(".bilibili-live-player-video-controller-switch-quality-btn");if(o===null){console.warn("qualitySettings null");return}const n=async()=>{const t=o.children[0].getAttribute("data-title");const i=dqa(o,".bilibili-live-player-video-controller-html-tooltip-option .text-btn");const n=i.map(t=>t.getAttribute("data-title"));console.log(t,n,l);if(t!==l){let t=l;while(!n.includes(t)){const i=e.indexOf(t);if(i>=e.length-1){console.log("reached lowest quality");return}t=e[i+1]}const o=i[n.indexOf(t)];console.log(o);while(!(o.classList.contains("active")||dq(".bilibili-live-player-video-controller-switch-quality-info"))){await(()=>new Promise(t=>setTimeout(()=>t(),3e3)))();o.click();console.log("click")}}};const c=Observer.childList(o,()=>{console.log(o.childElementCount);if(o.childElementCount>0){n()}})})()}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/default-player-layout.min.js"] = (()=>{return(e,o)=>{class t{setCookie(e,o){document.cookie=`${e}=${o};path=/;domain=.bilibili.com;max-age=31536000`}clearCookie(e){document.cookie=`${e}=;path=/;domain=.bilibili.com;max-age=0`}getValue(e){return document.cookie.replace(new RegExp(`(?:(?:^|.*;\\s*)${e}\\s*\\=\\s*([^;]*).*$)|^.*$`),"$1")}checkSettings(){return e.useDefaultPlayerLayout}checkCookies(){}useNewLayout(){}useOldLayout(){}setLayout(e){if(e){this.useNewLayout()}else{this.useOldLayout()}}}class s extends t{checkCookies(){super.checkCookies();const o=this.getValue(this.cookieKey);if(o===""||parseInt(o)<0&&e.defaultPlayerLayout!=="旧版"){console.log(`default/old -> new`);this.useNewLayout()}else if(e.defaultPlayerLayout!=="新版"){console.log(`new -> old`);this.useOldLayout()}}constructor(){super();this.cookieKey="stardustvideo";this.checkCookies()}useNewLayout(){super.useNewLayout();this.setCookie(this.cookieKey,1)}useOldLayout(){super.useOldLayout();this.setCookie(this.cookieKey,-1)}}class u extends t{checkCookies(){super.checkCookies();const o=this.getValue(this.cookieKey);if(o===""||parseInt(o)<=0&&e.defaultBangumiLayout!=="旧版"){console.log(`default/old -> new`);this.useNewLayout()}else if(e.defaultBangumiLayout!=="新版"){console.log(`new -> old`);this.useOldLayout()}}constructor(){super();this.cookieKey="stardustpgcv";this.checkCookies()}useNewLayout(){super.useNewLayout();this.setCookie(this.cookieKey,"0606")}useOldLayout(){super.useOldLayout();this.setCookie(this.cookieKey,0)}}const i=new s;addSettingsListener("defaultPlayerLayout",e=>{i.setLayout(e==="新版")});const a=new u;addSettingsListener("defaultBangumiLayout",e=>{a.setLayout(e==="新版")})}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/default-player-mode.min.js"] = (()=>{return(e,i)=>{if(typeof isEmbeddedPlayer!=="undefined"&&isEmbeddedPlayer()){return}const n=[{name:"常规",action:()=>{}},{name:"宽屏",action:()=>{document.querySelector(".bilibili-player-video-btn-widescreen").click()}},{name:"网页全屏",action:()=>{document.querySelector(".bilibili-player-video-web-fullscreen").click()}},{name:"全屏",action:async()=>{const e=await SpinQuery.condition(()=>document.querySelector(".bilibili-player-video video"),e=>{return e!==null&&e.readyState===4&&document.readyState==="complete"&&document.hasFocus()});if(e===null){console.warn("[默认播放器模式] 未能应用全屏模式, 等待超时.");return}document.querySelector(".bilibili-player-video-btn-fullscreen").click()}}];let t=()=>{};let a=()=>{};async function l(){if(e.autoLightOff){await SpinQuery.unsafeJquery();const e=await SpinQuery.any(()=>unsafeWindow.$(".bilibili-player-video-btn-setting"));if(!e){return}e.mouseover().mouseout();const i=async e=>{const i=await SpinQuery.select(()=>document.querySelector(".bilibili-player-video-btn-setting-panel-others-content-lightoff .bui-checkbox-input"));i.checked=e;raiseEvent(i,"change")};t=(()=>i(true));a=(()=>i(false))}}async function o(){await l();await SpinQuery.condition(()=>$(".bilibili-player-video,.bilibili-player-video-btn-start,.bilibili-player-area"),e=>e.length===3&&$("video").length>0&&$("video").prop("duration"));const i=document.querySelector("video");if(!i){return}const o=n.find(i=>i.name===e.defaultPlayerMode);{const n=()=>{if(o&&$("#bilibiliPlayer[class*=mode-]").length===0){o.action()}};if(e.applyPlayerModeOnPlay&&!e.autoPlay){i.addEventListener("play",n,{once:true})}else{n()}if(!e.autoPlay){i.addEventListener("play",t,{once:true})}else{t()}i.addEventListener("ended",a,{once:true})}}Observer.videoChange(o)}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/default-video-quality.min.js"] = (()=>{return(e,a)=>{const t=[{name:"1080P60",value:116},{name:"1080P+",value:112},{name:"1080P",value:80},{name:"720P60",value:74},{name:"720P",value:64},{name:"480P",value:32},{name:"360P",value:15},{name:"自动",value:0}];async function i(){const a=await SpinQuery.any(()=>$(".bilibili-player-video-quality-menu .bui-select-list>li.bui-select-item"));if(!a){return}const i=(e,a)=>a-e;const[n]=a.toArray().map(e=>parseInt(e.getAttribute("data-value"))).sort(i);const[l]=t.filter(a=>a.name===e.defaultVideoQuality).map(e=>e.value).sort(i);const[r]=t.map(e=>e.value).filter(e=>e<=Math.min(l,n)).sort(i);const u=await SpinQuery.select(()=>document.querySelector("video"));function s(){a.each((e,a)=>{if(parseInt(a.getAttribute("data-value"))===r){a.click()}});this.removeEventListener("play",s)}u.addEventListener("play",s)}if(Observer.videoChange){Observer.videoChange(i)}else{Observer.childList("#bofqi",()=>i())}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/default-video-speed.min.js"] = (()=>{return(e,a)=>{const i=a=>{const i=parseFloat(e.defaultVideoSpeed);a.playbackRate=i;SpinQuery.condition(()=>a,()=>a.playbackRate!==i,()=>a.playbackRate=i)};Observer.videoChange(async()=>{const e=await SpinQuery.select(".bilibili-player-video video");i(e)})}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/double-click-fullscreen.min.js"] = (()=>{return(i,e)=>{const l=()=>{const e=["https://www.bilibili.com/bangumi/","https://www.bilibili.com/video/"];if(!e.some(i=>document.URL.startsWith(i))){return}if(i.touchVideoPlayer&&i.touchVideoPlayerDoubleTapControl){Toast.info("在开启了<span>播放器触摸支持-启用双击控制</span>后, <span>双击全屏</span>功能将无效.","提示");i.doubleClickFullscreen=false;return}Observer.videoChange(async()=>{await SpinQuery.unsafeJquery();const e=await SpinQuery.condition(()=>dq(".bilibili-player-area"),i=>i!==null&&unsafeWindow.$(".bilibili-player-video").data("events"));if(e===null){return}const l="double-click-fullscreen";if(!e.classList.contains(l)){e.classList.add(l);const n=unsafeWindow.$(".bilibili-player-video");const s=i.doubleClickFullscreenPreventSingleClick?n.data("events").click[0].handler:()=>{};const t=new DoubleClickEvent(()=>dq(".bilibili-player-video-btn-fullscreen").click(),i=>s(i));if(i.doubleClickFullscreenPreventSingleClick){n.unbind("click")}t.bind(n[0])}})};l()}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/download-audio.min.js"] = (()=>{return(e,t)=>{class n{constructor(){this.sid=null;this.progress=null}async getDownloadUrl(){const e=`https://www.bilibili.com/audio/music-service-c/web/url?sid=${this.sid}&privilege=2&quality=2`;const t=await Ajax.getJsonWithCredentials(e);if(t.code===0){return t.data.cdns.shift()}else{logError("获取下载链接失败, 请确保当前账号有下载权限.","下载音频",1e4);return null}}async download(){const e=await this.getDownloadUrl();return new Promise((t,n)=>{const s=new XMLHttpRequest;s.open("GET",e);s.responseType="blob";s.addEventListener("load",()=>t(s.response));s.addEventListener("error",()=>n(s.status));s.addEventListener("progress",e=>this.progress&&this.progress(100*e.loaded/e.total));s.send()})}}const s="下载音频";return{export:n,widget:{content:`\n<button\n                disabled\n                class="gui-settings-flat-button"\n                id="download-audio">\n<i class="icon-download"></i>\n<span>${s}</span>\n<a id="download-audio-link" style="display: none"></a>\n</button>`,condition:()=>document.URL.includes("bilibili.com/audio"),success:async()=>{await SpinQuery.select(()=>document.querySelector("#app"));const e=document.querySelector("#download-audio");const t=e.querySelector("span");const o=new n;o.progress=(e=>{t.innerHTML=`${Math.round(e)}%`});const i=document.querySelector("#download-audio-link");e.addEventListener("click",async e=>{if(o.sid===null||e.target===i){return}const n=await o.download();t.innerHTML=s;const r=i.getAttribute("href");if(r){URL.revokeObjectURL(r)}i.setAttribute("href",URL.createObjectURL(n));const d=(()=>{const e=document.querySelector(".song-title");if(e){return e.getAttribute("title")}else{return"神秘音频"}})();i.setAttribute("download",d+".m4a");i.click()});Observer.childList("#app",()=>{const t=document.URL.match(/bilibili\.com\/audio\/au([\d]+)/);if(t&&t[1]){e.disabled=false;o.sid=t[1]}else{e.disabled=true}})}}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/download-danmaku.min.js"] = (()=>{return(t,e)=>{const{getFriendlyTitle:n}=e.import("title");const{DanmakuInfo:i}=e.import("video-info");const{DanmakuConverter:a}=e.import("danmaku-converter");async function o(t){const e=n();let i={title:e};try{await loadDanmakuSettingsPanel();const t=t=>{const e=parseFloat(dq(t).style.transform.replace(/translateX\(([\d\.]+)/,"$1"));return e*4/188};const e=t=>{const e=parseFloat(dq(t).style.transform.replace(/translateX\(([\d\.]+)/,"$1"));const n={0:0,44:1,94:2,144:3,188:4}[e];return n};i.font=dq(".bilibili-player-video-danmaku-setting-right-font .bui-select-result").innerText;i.alpha=(100-parseFloat(dq(".bilibili-player-setting-opacity .bui-thumb-tooltip").innerText))/100;i.duration=(()=>{const e=18-3*t(".bilibili-player-setting-speedplus .bui-thumb");return t=>{switch(t.type){case 4:case 5:return 4;default:return e}}})();i.blockTypes=(()=>{let t=[];const e={".bilibili-player-block-filter-type[ftype=scroll]":[1,2,3],".bilibili-player-block-filter-type[ftype=top]":[5],".bilibili-player-block-filter-type[ftype=bottom]":[4],".bilibili-player-block-filter-type[ftype=color]":["color"]};for(const[n,i]of Object.entries(e)){if(dq(n).classList.contains("disabled")){t=t.concat(i)}}return t.concat(7,8)})();const n=1.4-.2*t(".bilibili-player-setting-fontsize .bui-thumb");i.resolution={x:1920*n,y:1080*n};i.bottomMarginPercent=[.75,.5,.25,0,0][e(".bilibili-player-setting-area .bui-thumb")];if(i.bottomMarginPercent===0&&dq(".bilibili-player-video-danmaku-setting-left-preventshade input").checked){i.bottomMarginPercent=.15}i.bold=dq(".bilibili-player-video-danmaku-setting-right-font-bold input").checked}catch(t){i={font:"微软雅黑",alpha:.4,duration:t=>{switch(t.type){case 4:case 5:return 4;default:return 6}},blockTypes:[7,8],resolution:{x:1920,y:1080},bottomMarginPercent:.15,bold:false}}const o=new a(i);const l=o.convertToAssDocument(t);return l.generateAss()}async function l(t){const e=n();const a=new i((unsafeWindow||window).cid);await a.fetchInfo();const l=await(async()=>{if(t===true){return new Blob([await o(a.rawXML)],{type:"text/plain"})}else{return new Blob([a.rawXML],{type:"text/plain"})}})();const r=URL.createObjectURL(l);const s=dq("#danmaku-link");const c=s.getAttribute("href");if(c){URL.revokeObjectURL(c)}s.setAttribute("download",`${e}.${t?"ass":"xml"}`);s.setAttribute("href",r);s.click()}return{export:{downloadDanmaku:l,convertToAss:o},widget:{content:`\n<button\n        class="gui-settings-flat-button"\n        id="download-danmaku">\n<i class="icon-danmaku"></i>\n<span>下载弹幕</span>\n<a id="danmaku-link" style="display:none"></a>\n</button>`,condition:async()=>{let t=await SpinQuery.select(()=>(unsafeWindow||window).cid);return Boolean(t)},success:()=>{const t=dq("#danmaku-link");const e=dq("#download-danmaku");e.addEventListener("click",n=>{if(n.target!==t){try{e.disabled=true;l(n.shiftKey)}catch(t){logError(t)}finally{e.disabled=false}}})}}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/download-live-records.min.js"] = (()=>{return(t,o)=>{const e=()=>document.URL.replace(location.search,"").match(/https:\/\/live\.bilibili\.com\/record\/(.+)/);return{widget:{content:`\n<button class="gui-settings-flat-button" style="position: relative; z-index: 100;" id="download-live-records">\n<i class="icon-download"></i>\n<span>下载录像</span>\n</button>`,condition:async()=>{const t=e();return Boolean(t)},success:()=>{const t=dq("#download-live-records");t.addEventListener("click",async()=>{try{t.disabled=true;const o=e()[1];const n=await Ajax.getJson(`https://api.live.bilibili.com/xlive/web-room/v1/record/getLiveRecordUrl?rid=${o}&platform=html5`);if(n.code!==0){logError(new Error(`获取录像链接失败: ${n.message}`));return}const i=n.data.list.map(t=>t.url);Toast.success(i.map(t=>`<a class="download-link" target="_blank" href="${t}">${t}</a>`).join("\n"),"下载录像")}catch(t){logError(t)}finally{t.disabled=false}})}}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/download-subtitle.min.js"] = (()=>{return(t,e)=>{let i;const o=(t,e)=>{const o=document.createElement("a");const n=URL.createObjectURL(new Blob([t]));if(i){URL.revokeObjectURL(i)}i=n;o.setAttribute("href",n);o.setAttribute("download",escapeFilename(e));document.body.appendChild(o);o.click();o.remove()};return{widget:{content:`\n<button class="gui-settings-flat-button" id="download-subtitle">\n<i class="icon-cc-subtitles"></i>\n<span>下载字幕</span>\n</button>`,condition:videoCondition,success:()=>{const t=dq("#download-subtitle");t.addEventListener("click",async i=>{try{t.disabled=true;const{aid:n,cid:s}=unsafeWindow;if(!n||!s){logError("未找到视频AID和CID");return}const{VideoInfo:l}=await e.importAsync("video-info");const{getFriendlyTitle:c}=await e.importAsync("title");const r=new l(n);r.cid=parseInt(s);await r.fetchInfo();const a=r.subtitles;if(a.length===0){Toast.info("当前视频没有字幕.","下载字幕",3e3);return}const d=await loadSubtitleSettingsPanel();if(!d){logError("未找到字幕设置");return}const u=d.querySelector(".bilibili-player-video-subtitle-setting-lan .bui-select-result").innerHTML;const b=a.find(t=>t.language===u)||a[0];const f=await Ajax.getJson(b.url);const p=f.body;const y=c(true);if(i.shiftKey){const{SubtitleConverter:t,SubtitleSize:i,SubtitleLocation:n}=await e.importAsync("subtitle-converter");const s=d.querySelector(".bilibili-player-video-subtitle-setting-fontsize .bui-thumb");const l=parseFloat(s.style.transform.replace(/translateX\(([\d\.]+)/,"$1"));const c={214:i.VeryLarge,163.5:i.Large,107:i.Medium,50.5:i.Small,0:i.VerySmall};const r=c[l];const a=d.querySelector(".bilibili-player-video-subtitle-setting-color .bui-select-result span:first-child");const u=a.getAttribute("style").match(/background:[ ]*(.+);/)[1];const b=d.querySelector(".bilibili-player-video-subtitle-setting-opacity .bui-bar");const f=parseFloat(b.style.transform.replace(/scaleX\(([\d\.]+)/,"$1"));const g=dq(".subtitle-position");const m={bc:n.BottomCenter,bl:n.BottomLeft,br:n.BottomRight,tc:n.TopCenter,tl:n.TopLeft,tr:n.TopRight};const h=Object.entries(m).filter(([t])=>{return g.classList.contains(`subtitle-position-${t}`)}).map(([,t])=>t).shift();const w=dq("video");const v={title:y,height:w.videoHeight,width:w.videoWidth,color:u,location:h,opacity:f,size:r};const S=new t(v);const L=await S.convertToAss(p);o(L,y+".ass")}else{o(JSON.stringify(p),y+".json")}}catch(t){logError(t)}finally{t.disabled=false}})}}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/download-video.min.css"] = `.download-video{--download-video-background:white;--download-video-foreground:black;position:absolute;top:96px;left:50%;transform:translateX(-50%) scale(.95);background:var(--download-video-background);color:var(--download-video-foreground);box-shadow:rgba(0,0,0,.2) 0 4px 8px 0;z-index:10001;pointer-events:none;opacity:0;padding:16px;width:300px;display:flex;flex-direction:column;align-items:stretch;justify-content:space-between;box-sizing:content-box;line-height:normal}.download-video,.download-video *{transition:.2s ease-out;-webkit-tap-highlight-color:transparent!important}.download-video.opened{pointer-events:initial;opacity:1;transform:translateX(-50%) scale(1)}body.dark .download-video{--download-video-background:#222;--download-video-foreground:#eee}.round-corner .download-video,.round-corner .download-video .episode-list .v-checkbox,.round-corner .download-video .rpc-settings{border-radius:var(--large-corner-radius)}.round-corner .download-video .button,.round-corner .download-video .cover,.round-corner .download-video .direct-download .progress .background,.round-corner .download-video .direct-download .progress .foreground,.round-corner .download-video .rpc-settings input[type=text],.round-corner .download-video .size-warning-tip,.round-corner .download-video .title,.round-corner .download-video button{border-radius:var(--corner-radius)}.download-video .cover{min-height:100px;max-height:120px;object-fit:contain}.download-video h1{font-size:13pt;font-weight:700;color:var(--download-video-foreground)}.download-video h2{font-size:11pt;font-weight:700;color:var(--download-video-foreground)}.download-video .header{display:flex;justify-content:space-between;align-items:center}.download-video .header .grow{flex-grow:1}.download-video .header .mdi-download{font-size:16pt;color:var(--download-video-foreground);margin-right:8px}.download-video .header .mdi-close{font-size:16pt;color:var(--download-video-foreground);cursor:pointer}.download-video .header .mdi-close:hover{color:var(--theme-color)}.download-video .info{display:flex;flex-direction:column;align-items:center;margin-top:12px}.download-video .title{display:flex;flex-direction:column;justify-content:space-between;align-items:stretch;margin-top:12px}.download-video .title .bold{width:300px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;text-align:center}.download-video .title .size{font-size:10pt;color:var(--download-video-foreground);align-self:center;display:flex;align-items:center;height:24px}.download-video .bold{color:var(--download-video-foreground);font-weight:700;font-size:12pt}.download-video .option-item{display:flex;justify-content:space-between;align-items:center;padding-top:12px;font-size:10pt}.download-video .tabs{display:flex;padding:12px 0;font-size:10pt}.download-video .tabs .tab{cursor:pointer;position:relative;opacity:.5}.download-video .tabs .tab.active{font-weight:700;opacity:1}.download-video .tabs .tab:not(:last-child){margin-right:16px}.download-video .tabs .tab::after{content:"";position:absolute;border-radius:2px;background-color:var(--theme-color);height:3px;width:80%;left:10%;bottom:-8px;transition:.2s ease-out;transform:scaleX(0)}.download-video .tabs .tab.active::after{transform:scaleX(1)}.download-video .separator{height:1px;background:#8884;width:100%;margin:12px 0;flex-shrink:0}.download-video .direct-download{display:flex;flex-direction:column;align-items:start;justify-content:space-between}.download-video .button,.download-video button{border:none;outline:0!important;padding:6px 16px;font-size:10pt;cursor:pointer;background:#8884;color:var(--download-video-foreground)}.download-video .button:hover,.download-video button:hover{background:#8886}.download-video .primary{background:var(--theme-color);color:var(--foreground-color);align-self:center}.download-video .primary:hover{background:var(--theme-color-90)}.download-video .busy .button,.download-video .busy .primary,.download-video .busy button,.download-video button:disabled{background-color:#0001;color:#8884;cursor:not-allowed}.download-video .busy .button,.download-video .busy button{cursor:wait!important}.download-video .direct-download .progress{align-self:stretch;display:flex;align-items:center;margin-top:8px}.download-video .direct-download .progress .background{flex-grow:1;height:4px;background:#8884;margin-right:4px;position:relative}.download-video .direct-download .progress .background .foreground{position:absolute;top:0;left:0;height:4px;background:linear-gradient(to right,var(--theme-color),var(--theme-color-60))}.download-video .direct-download .progress .percent{width:50px;text-align:right;font-size:12px}.download-video .actions{display:flex;flex-wrap:wrap;justify-content:space-between;margin:8px -4px 0}.download-video .actions>*{margin:4px;flex-grow:1;flex-basis:calc(50% - 16px);display:flex;justify-content:center;align-items:center;white-space:nowrap}.download-video i.mdi-alert-circle{font-size:14pt;color:#ff9800}.download-video .size-warning{position:relative;padding:0 8px}.download-video .size-warning-tip{position:absolute;bottom:100%;left:50%;transform:translateX(-50%);background:var(--download-video-background);color:var(--download-video-foreground);border:1px dashed var(--theme-color);z-index:2;font-size:10pt;width:200px;padding:8px;box-shadow:rgba(0,0,0,.2) 0 4px 8px 0;pointer-events:none;opacity:0}.download-video .size-warning:hover .size-warning-tip{opacity:1}.download-video .episode-list .v-checkbox{padding:4px 8px;margin:4px 0;position:relative;background-color:transparent}.download-video .episode-list .v-checkbox.checked{background-color:#8882}.download-video .episode-header{display:flex;align-items:center;justify-content:space-between;margin-bottom:12px}.download-video .episode-list{overflow:auto;max-height:320px}.download-video button.list-tool{padding:4px;line-height:1;font-size:12pt;margin:0 4px}.download-video .episode-header h2{flex-grow:1}.download-video .selected-count{width:64px;font-size:12px;text-align:right}.download-video .aria2-rpc .mdi{margin-left:8px;font-size:14pt;line-height:1}.download-video .aria2-rpc{position:relative}.download-video .rpc-settings{position:absolute;display:flex;flex-direction:column;align-items:stretch;color:var(--download-video-foreground);background:#fff;bottom:120%;left:50%;cursor:initial;box-shadow:rgba(0,0,0,.2) 0 4px 8px 0;transform-origin:bottom;transform:translateX(-50%) scale(.9);opacity:0;pointer-events:none;padding:8px;z-index:3;transition:.3s cubic-bezier(.18,.89,.32,1.28);width:120%}body.dark .download-video .rpc-settings{background:#282828}.download-video .rpc-settings>*{margin:8px}.download-video .rpc-settings.show{opacity:1;transform:translateX(-50%) scale(1);pointer-events:initial}.download-video .rpc-settings input[type=text]{background:0 0;color:var(--download-video-foreground);border:1px solid #8884;padding:4px;margin-left:8px}.download-video .rpc-settings input[type=text]:focus{border-color:var(--theme-color)}.download-video .rpc-settings .operations{display:flex;align-items:center;justify-content:space-evenly}.download-video .final-dir{white-space:normal;word-break:break-all}.download-video .rpc-settings-item{display:flex;align-items:center;justify-content:space-between;white-space:nowrap}.download-video .rpc-settings-item input[type=text]{flex-grow:1;margin-left:24px}.download-video button.cancel-download,.download-video button.start-download{margin-top:8px}.download-video .direct-download-header{align-self:stretch;display:flex;justify-content:space-between;align-items:center}.download-video .manual-input-header{margin-bottom:12px;display:flex;justify-content:space-between;align-items:center}.download-video .manual-input-content{display:flex;justify-content:stretch}.download-video .manual-input-content textarea{margin:0;height:180px;resize:none;padding:8px;border-radius:4px;flex:1 0 0;outline:0!important;border-color:#dfdfdf}.download-video .manual-input-content textarea:focus,.download-video .manual-input-content textarea:focus-within{border-color:var(--theme-color)}body.dark .download-video .direct-download .progress .foreground{background:linear-gradient(to right,var(--theme-color-70),var(--theme-color))}`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/download-video.min.html"] = `<div class=download-video><a :href=blobUrl id=video-complete style="display: none"></a><div class=header><i class="mdi mdi-download"></i><h1>下载视频</h1><div class=grow></div><i class="mdi mdi-close"@click=close()></i></div><div class=tabs><div class=tab v-for="t of tabs":class="{active: selectedTab === t, ['download-' + t.name]: true}":key=t.name @click="selectedTab = t">{{t.displayName}}</div></div><div v-show=downloadSingle class=info><img :src=coverUrl class=cover><div class=title><span class=size><div v-if=sizeWarning class=size-warning><i class="mdi mdi-alert-circle"></i><div class=size-warning-tip>警告: 过大的视频大小会在直接下载时占用大量内存, 并可能导致浏览器标签页崩溃. 请考虑降低清晰度或使用导出选项.</div></div>预计大小: {{displaySize}}</span></div></div><div class=options><div class=option-item v-if=enableDash>格式<v-dropdown style="text-transform: uppercase;"@change=dashChange() :items=dashModel.items :value.sync=dashModel.value></v-dropdown></div><div class=option-item>清晰度<v-dropdown v-if="selectedTab.name !== 'manual'"@change=formatChange(true) :items=qualityModel.items :value.sync=qualityModel.value></v-dropdown><v-dropdown v-else :items=manualQualityModel.items :value.sync=manualQualityModel.value></v-dropdown></div><div class=option-item>弹幕<v-dropdown @change=danmakuOptionChange() :items=danmakuModel.items :value.sync=danmakuModel.value></v-dropdown></div><div class=option-item v-if="enableDash && dashModel.value === 'dash'">首选编码<v-dropdown @change=codecChange() :items=codecModel.items :value.sync=codecModel.value></v-dropdown></div></div><div class=separator></div><div v-show=downloadSingle class=direct-download><div class=direct-download-header><h2>直接下载</h2><span class=download-speed>{{speed}}</span></div><button v-if=!downloading class="primary start-download"@click=startDownload()>开始</button><button v-else class="primary cancel-download"@click=cancelDownload()>取消</button><div class=progress><div class=background><div class=foreground :style="{width: progressPercent + '%'}"></div></div><span class=percent>{{progressPercent}}%</span></div></div><div v-show="selectedTab.name === 'batch'"class=batch-download><div class=episode-header><h2>选集</h2><button class=list-tool title=全选 @click=selectAllEpisodes()><i class="mdi mdi-checkbox-multiple-marked-circle"></i></button><button class=list-tool title=全不选 @click=unselectAllEpisodes()><i class="mdi mdi-checkbox-multiple-blank-circle-outline"></i></button><button class=list-tool title=反选 @click=inverseAllEpisodes()><i class="mdi mdi-circle-slice-4"></i></button><span class=selected-count>{{selectedEpisodeCount}}/{{episodeList.length}}</span></div><div class=episode-list><v-checkbox v-for="ep of episodeList":key=ep.index :title=ep.title :checked.sync=ep.checked></v-checkbox></div></div><div v-show="selectedTab.name === 'manual'"class=manual-input><div class=manual-input-header><h2>链接列表</h2><div class=items-count>共{{manualInputItems.length}}个视频</div></div><div class=manual-input-content><textarea placeholder="请输入视频链接或av号 (没错, 不能是bv号), 空格/换行分隔"v-model=manualInputText></textarea></div></div><div class=separator></div><div class=exports><h2>导出</h2><div class=actions :class="{busy: busy}"><button class=show-link :disabled="downloadSingle ? null : 'disabled'"@click="exportData('showLink')">显示链接</button><button class=aria2-file @click="exportData('aria2')">aria2</button><button class=ffmpeg-fragments v-if="!dash && selectedTab.name !== 'manual'"@click="exportData('ffmpegFragments')">ffmpeg - 分段列表</button><button class=ffmpeg-episodes v-if="!dash && selectedTab.name !== 'manual'":disabled="downloadSingle ? 'disabled' : null"@click="exportData('ffmpegEpisodes')">ffmpeg - 分P列表</button><div class="button aria2-rpc"@click.self=toggleRpcSettings()>{{showRpcSettings ? '取消' : 'aria2 RPC'}}<i :class="{'mdi-close': showRpcSettings, 'mdi-chevron-right': !showRpcSettings}"class=mdi @click.self=toggleRpcSettings()></i><div class=rpc-settings :class="{show: showRpcSettings}"><h1>aria2 RPC</h1><rpc-profiles @profile-change=updateProfile></rpc-profiles><h2>配置</h2><div class=rpc-settings-item>主机<input type=text v-model=rpcSettings.host placeholder=127.0.0.1></div><div class=rpc-settings-item>端口<input type=text v-model=rpcSettings.port placeholder=6800></div><div class=rpc-settings-item>密钥<input type=text v-model=rpcSettings.secretKey></div><div class=rpc-settings-item>限速<input type=text v-model=rpcSettings.maxDownloadLimit placeholder=无></div><div class=rpc-settings-item>默认路径<input type=text v-model=rpcSettings.baseDir></div><div class=rpc-settings-item>路径<input type=text v-model=rpcSettings.dir></div><div class=final-dir>最终路径: {{rpcSettings.baseDir + rpcSettings.dir}}</div><div class=rpc-settings-item>方法<v-dropdown style="text-transform: uppercase;":items="['get', 'post']":value.sync=rpcSettings.method></v-dropdown></div><div class=operations><div class="primary button"@click="saveRpcSettings();toggleRpcSettings();exportData('aria2RPC')">开始下载</div><div class=button @click=saveRpcSettings()>{{saveRpcSettingsText}}</div></div></div></div></div></div></div>`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/download-video.min.js"] = (()=>{return(t,e)=>{const{getFriendlyTitle:a}=e.import("title");const{VideoInfo:s,DanmakuInfo:i}=e.import("video-info");const{DownloadVideoPackage:n}=e.import("download-video-package");class o{async getApiGenerator(t=false){function e(e,a,s){if(t){if(s){return`https://api.bilibili.com/x/player/playurl?avid=${e}&cid=${a}&qn=${s}&otype=json&fnver=0&fnval=16`}else{return`https://api.bilibili.com/x/player/playurl?avid=${e}&cid=${a}&otype=json&fnver=0&fnval=16`}}else{if(s){return`https://api.bilibili.com/x/player/playurl?avid=${e}&cid=${a}&qn=${s}&otype=json`}else{return`https://api.bilibili.com/x/player/playurl?avid=${e}&cid=${a}&otype=json`}}}return e.bind(this)}async getDashUrl(t){return(await this.getApiGenerator(true))(c.aid,c.cid,t)}async getUrl(t){return(await this.getApiGenerator())(c.aid,c.cid,t)}}class r extends o{async getApiGenerator(t=false){function e(e,a,s){if(t){if(s){return`https://api.bilibili.com/pgc/player/web/playurl?avid=${e}&cid=${a}&qn=${s}&otype=json&fourk=1&fnval=16`}else{return`https://api.bilibili.com/pgc/player/web/playurl?avid=${e}&cid=${a}&otype=json&fourk=1&fnval=16`}}else{if(s){return`https://api.bilibili.com/pgc/player/web/playurl?avid=${e}&cid=${a}&qn=${s}&otype=json`}else{return`https://api.bilibili.com/pgc/player/web/playurl?avid=${e}&cid=${a}&qn=&otype=json`}}}return e.bind(this)}}class l extends o{constructor(t){super();this.ep=t}async getApiGenerator(t=false){function e(e,a,s){if(t){if(s){return`https://api.bilibili.com/pugv/player/web/playurl?avid=${e}&cid=${a}&qn=${s}&otype=json&ep_id=${this.ep}&fnver=0&fnval=16`}else{return`https://api.bilibili.com/pugv/player/web/playurl?avid=${e}&cid=${a}&otype=json&ep_id=${this.ep}&fnver=0&fnval=16`}}else{if(s){return`https://api.bilibili.com/pugv/player/web/playurl?avid=${e}&cid=${a}&qn=${s}&otype=json&ep_id=${this.ep}`}else{return`https://api.bilibili.com/pugv/player/web/playurl?avid=${e}&cid=${a}&otype=json&ep_id=${this.ep}`}}}return e.bind(this)}}const c={entity:new o,aid:"",cid:""};let d=[];let p=null;let h=null;class u{constructor(t,e,a){this.quality=t;this.internalName=e;this.displayName=a}async downloadInfo(t=false){const e=new m(this);await e.fetchVideoInfo(t);return e}static parseFormats(t){const e=t.accept_quality;const a=t.accept_format.split(",");const s=t.accept_description;const i=e.map((t,e)=>{return new u(t,a[e],s[e])});return i}static async filterFormats(t){if(h===null){h=(await Ajax.getJsonWithCredentials("https://api.bilibili.com/x/web-interface/nav")).data}_.remove(t,t=>{const e=t.quality;if(h.isLogin===false){return e>=64}if(h.vipStatus!==1){return e===116||e===112||e===74}return false});return t}static async getAvailableDashFormats(){const t=await c.entity.getDashUrl();const e=await Ajax.getJsonWithCredentials(t);if(e.code!==0){throw new Error("获取清晰度信息失败.")}const a=e.data||e.result||e;return await u.filterFormats(u.parseFormats(a))}static async getAvailableFormats(){const t=await c.entity.getUrl();const e=await Ajax.getJsonWithCredentials(t);if(e.code!==0){throw new Error("获取清晰度信息失败.")}const a=e.data||e.result||e;return await u.filterFormats(u.parseFormats(a))}}const f=[new u(120,"4K","超清 4K"),new u(116,"1080P60","高清 1080P60"),new u(112,"1080P+","高清 1080P+"),new u(80,"1080P","高清 1080P"),new u(74,"720P60","高清 720P60"),new u(64,"720P","高清 720P"),new u(32,"480P","清晰 480P"),new u(15,"320P","流畅 320P")];class m{constructor(t,e){this.fragmentSplitFactor=6*2;this.workingXhr=null;this.progressMap=new Map;this.format=t;this.fragments=e||[];this.videoSpeed=new w(this)}get danmakuOption(){return t.downloadVideoDefaultDanmaku}get isDash(){return this.fragments.some(t=>t.url.includes(".m4s"))}get totalSize(){return this.fragments.map(t=>t.size).reduce((t,e)=>t+e)}async fetchVideoInfo(t=false){if(!t){const t=await c.entity.getUrl(this.format.quality);const a=await Ajax.getTextWithCredentials(t);const s=JSON.parse(a.replace(/http:/g,"https:"));const i=s.data||s.result||s;const n=this.format.quality;if(i.quality!==n){const{throwQualityError:t}=await e.importAsync("quality-errors");t(n)}const o=i.durl;this.fragments=o.map(t=>{return{length:t.length,size:t.size,url:t.url,backupUrls:t.backup_url}})}else{const{dashToFragments:t,getDashInfo:a}=await e.importAsync("video-dash");const s=await a(await c.entity.getDashUrl(this.format.quality),this.format.quality);this.fragments=t(s)}return this.fragments}updateProgress(){const t=this.progressMap?[...this.progressMap.values()].reduce((t,e)=>t+e,0)/this.totalSize:0;if(t>1||t<0){console.error(`[下载视频] 进度异常: ${t}`,this.progressMap.values())}this.progress&&this.progress(t)}cancelDownload(){this.videoSpeed.stopMeasure();if(this.workingXhr!==null){this.workingXhr.forEach(t=>t.abort())}else{logError("Cancel Download Failed: forEach in this.workingXhr not found.")}}downloadFragment(t){const e=[];const a=this.isDash?4*1024*1024:16*1024*1024;let s;if(t.size<=a*6){s=t.size/this.fragmentSplitFactor}else{s=a}let i=0;const n=t=>[...this.progressMap.keys()].indexOf(t)+1;while(i<t.size){const a=Math.min(t.size-1,Math.round(i+s));const o=`bytes=${i}-${a}`;const r=a-i+1;e.push(new Promise((e,a)=>{const s=new XMLHttpRequest;s.open("GET",t.url);s.responseType="arraybuffer";s.withCredentials=false;s.addEventListener("progress",t=>{console.debug(`[下载视频] 视频片段${n(s)}下载进度: ${t.loaded}/${r} bytes loaded, ${o}`);this.progressMap.set(s,t.loaded);this.updateProgress()});s.addEventListener("load",()=>{if((""+s.status)[0]==="2"){console.debug(`[下载视频] 视频片段${n(s)}下载完成`);e(s.response)}else{a(`视频片段${n(s)}请求失败, response = ${s.status}`)}});s.addEventListener("abort",()=>a("canceled"));s.addEventListener("error",()=>{console.error(`[下载视频] 视频片段${n(s)}下载失败: ${o}`);this.progressMap.set(s,0);this.updateProgress();s.open("GET",t.url);s.setRequestHeader("Range",o);s.send()});s.setRequestHeader("Range",o);this.progressMap.set(s,0);s.send();this.workingXhr.push(s)}));i=Math.round(i+s)+1}return Promise.all(e)}async copyUrl(){const t=this.fragments.map(t=>t.url).reduce((t,e)=>t+"\r\n"+e);GM.setClipboard(t,"text")}async showUrl(){const t=this.fragments.map(t=>`\n<a class="download-link" href="${t.url}">${t.url}</a>\n`).reduce((t,e)=>t+"\r\n"+e);Toast.success(t+`<a class="link" id="copy-link" style="cursor: pointer;margin: 8px 0 0 0;">复制全部</a>`,"显示链接");const e=await SpinQuery.select("#copy-link");e.addEventListener("click",async()=>{await this.copyUrl()})}async exportData(t=false){const e=JSON.stringify([{fragments:this.fragments,title:a(),totalSize:this.fragments.map(t=>t.size).reduce((t,e)=>t+e),referer:document.URL.replace(window.location.search,"")}]);if(t){GM.setClipboard(e,"text")}else{const t=new Blob([e],{type:"text/json"});const s=await this.downloadDanmaku();const i=new n;i.add(`${a()}.json`,t);i.add(a()+"."+this.danmakuOption.toLowerCase(),s);await i.emit(`${a()}.zip`)}}async exportAria2(s=false){if(s){const s=await this.downloadDanmaku();const i=new n;i.add(`${a()}.${this.danmakuOption==="ASS"?"ass":"xml"}`,s);await i.emit();const o=t.aria2RpcOption;const r=this.fragments.map((t,e)=>{let s="";if(this.fragments.length>1&&!this.isDash){s=" - "+(e+1)}const i=[];if(o.secretKey!==""){i.push(`token:${o.secretKey}`)}i.push([t.url]);i.push({referer:document.URL.replace(window.location.search,""),"user-agent":UserAgent,out:`${a()}${s}${this.extension(t)}`,split:this.fragmentSplitFactor,dir:o.baseDir+o.dir||undefined,"max-download-limit":o.maxDownloadLimit||undefined});const n=encodeURIComponent(`${a()}${s}`);return{params:i,id:n}});const{sendRpc:l}=await e.importAsync("aria2-rpc");await l(r)}else{const t=`\n# Generated by Bilibili Evolved Video Export\n# https://github.com/the1812/Bilibili-Evolved/\n${this.fragments.map((t,e)=>{let s="";if(this.fragments.length>1&&!this.isDash){s=" - "+(e+1)}return`\n${t.url}\n  referer=${document.URL.replace(window.location.search,"")}\n  user-agent=${UserAgent}\n  out=${a()}${s}${this.extension(t)}\n  split=${this.fragmentSplitFactor}\n`.trim()}).join("\n")}\n`.trim();const e=new Blob([t],{type:"text/plain"});const s=await this.downloadDanmaku();const i=new n;i.add(`${a()}.txt`,e);i.add(a()+"."+this.danmakuOption.toLowerCase(),s);await i.emit(`${a()}.zip`)}}extension(t){const e=t||this.fragments[0];const a=[".flv",".mp4"].find(t=>e.url.includes(t));if(a){return a}else if(e.url.includes(".m4s")){return this.fragments.indexOf(e)===0?".mp4":".m4a"}else{console.warn("No extension detected.");return".flv"}}async downloadDanmaku(){if(this.danmakuOption!=="无"){const t=new i(c.cid);await t.fetchInfo();if(this.danmakuOption==="XML"){return t.rawXML}else{const{convertToAss:a}=await e.importAsync("download-danmaku");return a(t.rawXML)}}else{return null}}async download(){this.workingXhr=[];this.progressMap=new Map;this.updateProgress();const t=[];this.videoSpeed.startMeasure();for(const e of this.fragments){const a=await this.downloadFragment(e);t.push(a)}if(t.length<1){throw new Error("下载失败.")}const e=a();const s=new n;t.forEach((a,i)=>{let n;const o=this.fragments[i];if(t.length>1&&!this.isDash){n=`${e} - ${i+1}${this.extension(o)}`}else{n=`${e}${this.extension(o)}`}s.add(n,new Blob(Array.isArray(a)?a:[a]))});const i=await this.downloadDanmaku();s.add(`${a()}.${this.danmakuOption==="ASS"?"ass":"xml"}`,i);await s.emit(e+".zip");this.progress&&this.progress(0);this.videoSpeed.stopMeasure()}}class w{constructor(t){this.lastProgress=0;this.measureInterval=1e3;this.workingDownloader=t}startMeasure(){this.intervalTimer=setInterval(()=>{const t=this.workingDownloader.progressMap?[...this.workingDownloader.progressMap.values()].reduce((t,e)=>t+e,0):0;const e=t-this.lastProgress;if(this.speedUpdate!==undefined){this.speedUpdate(formatFileSize(e)+"/s")}this.lastProgress=t},this.measureInterval)}stopMeasure(){clearInterval(this.intervalTimer)}}async function g(){const t=await SpinQuery.select(()=>(unsafeWindow||window).aid);const e=await SpinQuery.select(()=>(unsafeWindow||window).cid);if(!(t&&e)){return false}c.aid=t;c.cid=e;if(document.URL.includes("bangumi")){c.entity=new r}else if(document.URL.includes("cheese")){const t=document.URL.match(/cheese\/play\/ep([\d]+)/);c.entity=new l(t[1])}else{c.entity=new o}try{d=await u.getAvailableFormats()}catch(t){return false}return true}const y=e=>{const a=t.downloadVideoQuality;const s=e.find(t=>t.quality===a);if(s){return s}const i=e.filter(t=>t.quality<a).shift();if(i){return i}return e.shift()};async function b(){p=y(d);e.applyStyle("downloadVideoStyle");const t=dq("#download-video");t.addEventListener("click",()=>{const t=dq(".download-video");t.classList.toggle("opened");window.scroll(0,0);dq(".gui-settings-mask").click()});document.body.insertAdjacentHTML("beforeend",e.import("downloadVideoHtml"));v()}async function v(){let r;const l=[{name:"single",displayName:"单个视频"},{name:"batch",displayName:"批量导出"},{name:"manual",displayName:"手动输入"}];const h=new Vue({el:".download-video",components:{VDropdown:()=>e.importAsync("v-dropdown.vue"),VCheckbox:()=>e.importAsync("v-checkbox.vue"),RpcProfiles:()=>e.importAsync("aria2-rpc-profiles.vue")},data:{batch:false,selectedTab:l[0],coverUrl:EmptyImageUrl,aid:c.aid,cid:c.cid,dashModel:{value:t.downloadVideoFormat,items:["flv","dash"]},qualityModel:{value:p.displayName,items:d.map(t=>t.displayName)},manualQualityModel:{value:f[1].displayName,items:f.map(t=>t.displayName)},danmakuModel:{value:t.downloadVideoDefaultDanmaku,items:["无","XML","ASS"]},codecModel:{value:t.downloadVideoDashCodec,items:["AVC/H.264","HEVC/H.265"]},progressPercent:0,size:"获取大小中",blobUrl:"",episodeList:[],downloading:false,speed:"",rpcSettings:t.aria2RpcOption,showRpcSettings:false,busy:false,saveRpcSettingsText:"保存配置",enableDash:t.enableDashDownload,lastDirectDownloadLink:"",manualInputText:""},computed:{tabs(){if(this.batch){return l}const t=[...l];_.remove(t,t=>t.name==="batch");return t},manualInputItems(){const t=this.manualInputText.split(/\s/g);const e=t.map(t=>t.match(/av(\d+)/i)||t.match(/^(\d+)$/));return _.uniq(e.filter(t=>t!==null).map(t=>t[1]))},downloadSingle(){return this.selectedTab.name==="single"},displaySize(){if(typeof this.size==="string"){return this.size}return formatFileSize(this.size)},sizeWarning(){if(typeof this.size==="string"){return false}return this.size>1073741824},selectedEpisodeCount(){return this.episodeList.filter(t=>t.checked).length},dash(){return this.dashModel.value==="dash"}},methods:{close(){this.$el.classList.remove("opened")},danmakuOptionChange(){t.downloadVideoDefaultDanmaku=this.danmakuModel.value},async codecChange(){t.downloadVideoDashCodec=this.codecModel.value;await this.formatChange()},async dashChange(){const e=t.downloadVideoFormat=this.dashModel.value;let a=[];if(e==="flv"){a=await u.getAvailableFormats()}else{a=await u.getAvailableDashFormats()}d=a;p=y(d);this.qualityModel.items=a.map(t=>t.displayName);this.qualityModel.value=this.qualityModel.items[d.indexOf(p)];await this.formatChange()},async formatChange(e=false){const a=this.getFormat();if(e){t.downloadVideoQuality=a.quality}try{this.size="获取大小中";const t=await a.downloadInfo(this.dash);this.size=t.totalSize}catch(t){this.size="获取大小失败";throw t}},getManualFormat(){let t;t=f.find(t=>t.displayName===this.manualQualityModel.value);if(!t){console.error(`No format found. model value = ${this.manualQualityModel.value}`);return null}return t},getFormat(){let t;t=d.find(t=>t.displayName===this.qualityModel.value);if(!t){console.error(`No format found. model value = ${this.qualityModel.value}`);return null}return t},async exportData(t){if(this.busy===true){return}try{this.busy=true;if(this.selectedTab.name==="batch"){await this.exportBatchData(t);return}if(this.selectedTab.name==="manual"){await this.exportManualData(t);return}const s=this.getFormat();const i=await s.downloadInfo(this.dash);switch(t){case"copyLink":await i.copyUrl();Toast.success("已复制链接到剪贴板.","下载视频",3e3);break;case"showLink":await i.showUrl();break;case"aria2":await i.exportAria2(false);break;case"aria2RPC":await i.exportAria2(true);break;case"copyVLD":await i.exportData(true);Toast.success("已复制VLD数据到剪贴板.","下载视频",3e3);break;case"exportVLD":await i.exportData(false);break;case"ffmpegFragments":if(i.fragments.length<2){Toast.info("当前视频没有分段.","分段列表",3e3)}else{const{getFragmentsList:t}=await e.importAsync("ffmpeg-support");const s=new n;s.add("ffmpeg-files.txt",t(i.fragments.length,a(),i.fragments.map(t=>i.extension(t))));await s.emit()}break;default:break}}catch(t){logError(t)}finally{this.busy=false}},async exportBatchData(t){const s=this.episodeList;if(s.every(t=>t.checked===false)){Toast.info("请至少选择1集或以上的数量!","批量导出",3e3);return}const o=t=>{const e=s.find(e=>e.cid===t.cid);if(e===undefined){return false}return e.checked};const r=this.batchExtractor;const l=this.getFormat();if(this.danmakuModel.value!=="无"){const t=Toast.info("下载弹幕中...","批量导出");const a=new n;try{if(this.danmakuModel.value==="XML"){for(const t of s.filter(o)){const e=new i(t.cid);await e.fetchInfo();a.add(r.formatTitle(t.titleParameters)+".xml",e.rawXML)}}else{const{convertToAss:t}=await e.importAsync("download-danmaku");for(const e of s.filter(o)){const s=new i(e.cid);await s.fetchInfo();a.add(r.formatTitle(e.titleParameters)+".ass",await t(s.rawXML))}}await a.emit(this.cid+".danmakus.zip")}catch(t){logError(`弹幕下载失败`);throw t}finally{t.dismiss()}}const d=Toast.info("获取链接中...","批量导出");r.config.itemFilter=o;r.config.api=await c.entity.getApiGenerator(this.dash);let p;try{switch(t){case"aria2":p=await r.collectAria2(l,d,false);await n.single(a(false)+".txt",new Blob([p],{type:"text/plain"}),{ffmpeg:this.ffmpegOption});return;case"aria2RPC":await r.collectAria2(l,d,true);Toast.success(`成功发送了批量请求.`,"aria2 RPC",3e3);return;case"copyVLD":GM.setClipboard(await r.collectData(l,d),{mimetype:"text/plain"});Toast.success("已复制批量vld数据到剪贴板.","批量导出",3e3);return;case"exportVLD":p=await r.collectData(l,d);await n.single(a(false)+".json",new Blob([p],{type:"text/json"}),{ffmpeg:this.ffmpegOption});return;case"ffmpegFragments":{const t=await r.getRawItems(l);const s=new m(l,t[0].fragments);const{getBatchFragmentsList:i}=await e.importAsync("ffmpeg-support");const o=i(t,this.dash||s.extension());if(!o){Toast.info("所有选择的分P都没有分段.","分段列表",3e3)}else{const t=new n;for(const[e,a]of o.entries()){t.add(e,a)}await t.emit(escapeFilename(`${a(false)}.zip`))}}break;case"ffmpegEpisodes":{const t=await r.getRawItems(l);const a=new m(l,t[0].fragments);const{getBatchEpisodesList:s}=await e.importAsync("ffmpeg-support");const i=s(t,this.dash||a.extension());const o=new n;o.add("ffmpeg-files.txt",i);await o.emit()}break;default:return}}catch(t){logError(t)}finally{d.dismiss()}},async exportManualData(t){if(this.manualInputItems.length===0){Toast.info("请至少输入一个有效的视频链接!","手动输入",3e3);return}const{ManualInputBatch:a}=await e.importAsync("batch-download");const s=new a({api:await(new o).getApiGenerator(this.dash),itemFilter:()=>true});s.items=this.manualInputItems;if(this.danmakuModel.value!=="无"){const t=Toast.info("下载弹幕中...","手动输入");const o=new n;try{if(this.danmakuModel.value==="XML"){for(const t of await s.getItemList()){const e=new i(t.cid);await e.fetchInfo();o.add(a.formatTitle(t.titleParameters)+".xml",e.rawXML)}}else{const{convertToAss:t}=await e.importAsync("download-danmaku");for(const e of await s.getItemList()){const s=new i(e.cid);await s.fetchInfo();o.add(a.formatTitle(e.titleParameters)+".ass",await t(s.rawXML))}}await o.emit("manual-exports.danmakus.zip")}catch(t){logError(`弹幕下载失败`);throw t}finally{t.dismiss()}}const r=Toast.info("获取链接中...","手动输入");try{switch(t){default:case"aria2":{const t=await s.collectAria2(this.getManualFormat().quality,false);await n.single("manual-exports.txt",new Blob([t],{type:"text/plain"}),{ffmpeg:this.ffmpegOption});break}case"aria2RPC":{await s.collectAria2(this.getManualFormat().quality,true);Toast.success(`成功发送了批量请求.`,"aria2 RPC",3e3);break}}}catch(t){logError(t)}finally{r.dismiss()}},async checkBatch(){const t=["//www.bilibili.com/bangumi","//www.bilibili.com/video","//www.bilibili.com/blackboard/bnj2020.html"];if(!t.some(t=>document.URL.includes(t))){this.batch=false;this.episodeList=[];return}const{BatchExtractor:a}=await e.importAsync("batch-download");if(await a.test()!==true){this.batch=false;this.episodeList=[];return}const s=this.batchExtractor=new a;this.batch=true;this.episodeList=(await s.getItemList()).map((t,e)=>{return{aid:t.aid,cid:t.cid,title:t.title,titleParameters:t.titleParameters,index:e,checked:true}})},cancelDownload(){if(r){r.cancelDownload()}},async startDownload(){const t=this.getFormat();try{this.downloading=true;const e=await t.downloadInfo(this.dash);e.videoSpeed.speedUpdate=(t=>this.speed=t);e.progress=(t=>{this.progressPercent=Math.trunc(t*100)});r=e;await e.download();this.lastDirectDownloadLink=n.lastPackageUrl}catch(t){if(t!=="canceled"){logError(t)}this.progressPercent=0}finally{this.downloading=false;this.speed=""}},selectAllEpisodes(){this.episodeList.forEach(t=>t.checked=true)},unselectAllEpisodes(){this.episodeList.forEach(t=>t.checked=false)},inverseAllEpisodes(){this.episodeList.forEach(t=>t.checked=!t.checked)},toggleRpcSettings(){this.showRpcSettings=!this.showRpcSettings},saveRpcSettings(){if(this.rpcSettings.host===""){this.rpcSettings.host="127.0.0.1"}if(this.rpcSettings.port===""){this.rpcSettings.port="6800"}t.aria2RpcOption=this.rpcSettings;const e=t.aria2RpcOptionProfiles.find(e=>e.name===t.aria2RpcOptionSelectedProfile);if(e){Object.assign(e,this.rpcSettings);t.aria2RpcOptionProfiles=t.aria2RpcOptionProfiles}this.saveRpcSettingsText="已保存";setTimeout(()=>this.saveRpcSettingsText="保存配置",2e3)},updateProfile(e){t.aria2RpcOption=this.rpcSettings=_.omit(e,"name")}},async mounted(){}});Observer.videoChange(async()=>{h.close();h.batch=false;h.selectedTab=l[0];const t=dq("#download-video");const e=await g();t.style.display=e?"flex":"none";if(!e){return}h.aid=c.aid;h.cid=c.cid;try{const t=new s(c.aid);await t.fetchInfo();h.coverUrl=t.coverUrl.replace("http:","https:")}catch(t){h.coverUrl=EmptyImageUrl}h.dashChange();await h.checkBatch()})}return{widget:{content:`\n<button class="gui-settings-flat-button" style="position: relative; z-index: 100;" id="download-video">\n<i class="icon-download"></i>\n<span>下载视频</span>\n</button>`,condition:g,success:b}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/download-video-package.min.js"] = (()=>{return(e,t)=>{class n{constructor(e={}){this.config=e;this.entries=[]}download(e,t){const a=document.createElement("a");const i=URL.createObjectURL(t);if(n.lastPackageUrl){URL.revokeObjectURL(n.lastPackageUrl)}n.lastPackageUrl=i;a.setAttribute("href",i);a.setAttribute("download",escapeFilename(e));document.body.appendChild(a);a.click();a.remove()}add(e,t){if(t===null||t===undefined){return}this.entries.push({name:escapeFilename(e),data:t})}async blob(){if(this.entries.length===0){return null}if(this.entries.length===1){const e=this.entries[0].data;return typeof e==="string"?new Blob([e]):e}const e=new JSZip;this.entries.forEach(({name:t,data:n})=>{e.file(t,n)});return await e.generateAsync({type:"blob"})}async emit(e){if(this.entries.length===0){return}if(!e||this.entries.length===1){e=this.entries[0].name}const t=await this.blob();if(!t){return}return this.download(e,t)}static async single(e,t,a={}){const i=new n(a);i.add(e,t);return await i.emit()}}n.lastPackageUrl="";return{export:{DownloadVideoPackage:n}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/dpi-img.vue.min.js"] = (()=>{return(t,e)=>{const s=`<img :width=width :height=height :srcset=srcset :src=actualSrc :class="{placeholder: isPlaceholderActive}":style={filter}>`;return{export:Object.assign({template:s},{props:{size:[Object,Number],src:String,blur:Number,root:HTMLElement,rootMargin:String,threshold:Number,placeholderImage:Boolean},data(){return{srcset:null,actualSrc:null,isPlaceholderActive:false}},watch:{size(){this.sourceChange()},src(){this.sourceChange()}},methods:{sourceChange(){if(this.actualSrc===null||this.srcset===null){return}this.calcSrc()},calcSrc(){const t=!this.src||!this.size;this.isPlaceholderActive=t&&this.placeholderImage;if(t){this.srcset=null;if(this.placeholderImage){this.actualSrc=`https://s1.hdslb.com/bfs/static/blive/live-web-center/static/img/no-cover.1ebe4d5.jpg`}else{this.actualSrc=null}return}let e=this.src;if(e.startsWith("http:")){e=e.replace("http:","https:")}if(e.includes("//static.hdslb.com/images/member/noface.gif")){this.srcset=e;this.actualSrc=e;return}const s=e.substring(e.lastIndexOf(".")+1);this.srcset=getDpiSourceSet(e,this.size,s);this.actualSrc=e}},mounted(){const t={root:this.root,rootMargin:this.rootMargin||"200px",threshold:this.threshold};const e=new IntersectionObserver(t=>{t.forEach(t=>{if(t.isIntersecting){this.calcSrc();e.disconnect()}})},t);e.observe(this.$el)},computed:{width(){if(typeof this.size==="object"&&"width"in this.size){return this.size.width}return null},height(){if(typeof this.size==="object"&&"height"in this.size){return this.size.height}return null},filter(){const t=[];if(this.blur){t.push(`blur(${this.blur}px)`)}return t.join(" ")}}})}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/expand-danmaku.min.js"] = (()=>{return(e,a)=>{if(typeof isEmbeddedPlayer!=="undefined"&&isEmbeddedPlayer()){return}Observer.videoChange(async()=>{const e=await SpinQuery.select(".bui-collapse-wrap");if(e&&e.classList.contains("bui-collapse-wrap-folded")){const e=await SpinQuery.select(".bui-collapse-header");e.click()}})}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/expand-description.min.css"] = `.play-up-info .play-up-self,.video-desc .info{height:auto!important}.play-up-info .play-up-self-btn,.video-desc .btn{display:none!important}`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/expand-description.min.js"] = (()=>{return(e,p)=>{p.applyStyle("expandDescriptionStyle")}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/favorites-redirect.min.js"] = (()=>{return(t,e)=>{function i(){const t=document.querySelectorAll("li[data-aid]>a");t.forEach(t=>{const e=t.getAttribute("href");if(e===null||!e.includes("medialist")){return}const i=t.parentElement.getAttribute("data-aid");t.setAttribute("href",`https://www.bilibili.com/video/av${i}`)})}(async()=>{const t=await SpinQuery.select("#app>.s-space");if(t!==null){Observer.childListSubtree("#app>.s-space",i)}})()}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/feeds-apis.min.js"] = (()=>{return(e,t)=>{const i={repost:{id:1,name:"转发"},textWithImages:{id:2,name:"图文"},text:{id:4,name:"文字"},video:{id:8,name:"视频"},miniVideo:{id:16,name:"小视频"},column:{id:64,name:"专栏"},audio:{id:256,name:"音频"},bangumi:{id:512,name:"番剧"},share:{id:2048,name:"分享"},manga:{id:2049,name:"漫画"},film:{id:4098,name:"电影"},tv:{id:4099,name:"TV剧"},chinese:{id:4100,name:"国创"},documentary:{id:4101,name:"纪录片"},mediaList:{id:4300,name:"收藏夹"}};const n=e=>{if(e.querySelector(".repost")){return i.repost}if(e.querySelector(".imagesbox")){return i.textWithImages}if(e.querySelector(".video-container")){return i.video}if(e.querySelector(".bangumi-container")){return i.bangumi}if(e.querySelector(".article-container")){return i.column}if(e.querySelector(".music-container")){return i.audio}if(e.querySelector(".h5share-container")){return i.share}if(e.querySelector(".vc-ctnr")){return i.miniVideo}return i.text};class r extends EventTarget{constructor(){super(...arguments);this.watching=false;this.cards=[]}addEventListener(e,t,i){super.addEventListener(e,t,i)}removeEventListener(e,t,i){super.removeEventListener(e,t,i)}async addCard(e){if(e instanceof HTMLElement&&e.classList.contains("card")){if(e.querySelector(".skeleton")!==null){const t=Observer.childList(e,()=>{if(e.querySelector(".skeleton")===null){t.stop();this.addCard(e)}})}else{const t=await this.parseCard(e);this.cards.push(t);this.cards.sort((e,t)=>{if(e.id===t.id){return 0}return e.id>t.id?-1:1});const i=new CustomEvent("addCard",{detail:t});this.dispatchEvent(i)}}}async removeCard(e){if(e instanceof HTMLElement&&e.classList.contains("card")){const t=(await this.parseCard(e)).id;const i=this.cards.findIndex(e=>e.id===t);const n=this.cards[i];this.cards.splice(i,1);const r=new CustomEvent("removeCard",{detail:n});this.dispatchEvent(r)}}async parseCard(e){const t=async t=>{const i=await SpinQuery.condition(()=>e.querySelector(t),e=>e!==null);if(i===null){console.warn(e,t);return""}const n=i.innerText.trim();return n};const r=async t=>{if(t===i.bangumi){return""}const n=await SpinQuery.condition(()=>e,e=>Boolean(e.__vue__));if(n===null){console.warn(n);return""}if(t===i.repost){const e=n.__vue__.originCardData.pureText;return n.__vue__.card.item.content+"\n"+e||""}return n.__vue__.originCardData.pureText||""};const a=async e=>{const i=parseInt(await t(e));if(isNaN(i)){return 0}return i};const s={id:e.getAttribute("data-did"),username:await t(".main-content .user-name"),text:"",reposts:await a(".button-bar .single-button:nth-child(1) .text-offset"),comments:await a(".button-bar .single-button:nth-child(2) .text-offset"),likes:await a(".button-bar .single-button:nth-child(3) .text-offset"),element:e,type:n(e),async getText(){const e=await r(this.type);this.text=e;return e}};await s.getText();e.setAttribute("data-type",s.type.id.toString());return s}async startWatching(){const e=await SpinQuery.select(".card-list .content");if(!e){return false}if(this.watching){return true}this.watching=true;const t=[...e.querySelectorAll(".content>.card")];t.forEach(e=>this.addCard(e));Observer.childList(e,e=>{e.forEach(e=>{e.addedNodes.forEach(e=>this.addCard(e));e.removedNodes.forEach(e=>this.removeCard(e))})});return true}}const a=new r;const s=async(e="video")=>{if(!getUID()){return[]}const t=await Ajax.getJsonWithCredentials(`https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=${getUID()}&type_list=${e==="video"?8:512}`);if(t.code!==0){throw new Error(t.message)}if(e==="video"){return t.data.cards.filter(e=>{return e.desc.orig_dy_id===0}).map(e=>{const t=JSON.parse(e.card);const i=_.get(e,"display.topic_info.topic_details",[]).map(e=>{return{id:e.topic_id,name:e.topic_name}});return{id:e.desc.dynamic_id_str,aid:t.aid,title:t.title,upID:e.desc.user_profile.info.uid,upName:e.desc.user_profile.info.uname,upFaceUrl:e.desc.user_profile.info.face,coverUrl:t.pic,description:t.desc,timestamp:e.timestamp,time:new Date(e.timestamp*1e3),topics:i,dynamic:t.dynamic,like:formatCount(e.desc.like),duration:t.duration,durationText:formatDuration(t.duration,0),playCount:formatCount(t.stat.view),danmakuCount:formatCount(t.stat.danmaku),watchlater:store.state.watchlaterList.includes(t.aid)}})}else if(e==="bangumi"){return t.data.cards.map(e=>{const t=JSON.parse(e.card);return{id:e.desc.dynamic_id_str,aid:t.aid,epID:t.episode_id,title:t.new_desc,upName:t.apiSeasonInfo.title,upFaceUrl:t.apiSeasonInfo.cover,coverUrl:t.cover,description:"",timestamp:e.timestamp,time:new Date(e.timestamp*1e3),like:formatCount(e.desc.like),durationText:"",playCount:formatCount(t.play_count),danmakuCount:formatCount(t.bullet_count),watchlater:false}})}else{return[]}};return{export:{feedsCardsManager:a,feedsCardTypes:i,getVideoFeeds:s}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/feeds-filter.min.js"] = (()=>{return(e,t)=>{(async()=>{if(document.URL.replace(location.search,"")!=="https://t.bilibili.com/"){return}const e=await SpinQuery.select(".home-container .left-panel");if(e===null){return}e.insertAdjacentHTML("beforeend",html`<feeds-filter-card></feeds-filter-card>`);new Vue({el:"feeds-filter-card",components:{FeedsFilterCard:()=>t.importAsync("feeds-filter-card.vue")}})})();return{reload:()=>document.body.classList.remove("disable-feeds-filter"),unload:()=>document.body.classList.add("disable-feeds-filter")}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/feeds-filter-card.vue.min.js"] = (()=>{return(e,t)=>{const i=`<div class=feeds-filter><h1>动态过滤</h1><h2>类型</h2><div class=filter-types><filter-type-switch v-for="[name, type] of allTypes":name=name :type=type :key=type.id></filter-type-switch></div><h2>关键词</h2><div class=filter-patterns><div class=pattern v-for="p of patterns":key=p>{{p}}<icon title=删除 type=mdi icon=trash-can-outline @click.native=deletePattern(p)></icon></div></div><div class=add-pattern><input placeholder="支持正则表达式 /^xxx$/"type=text v-model=newPattern @keydown.enter=addPattern(newPattern)><icon title=添加 type=mdi icon=plus @click.native=addPattern(newPattern)></icon></div><h2>侧边栏</h2><div class=filter-side-card><div class="filter-side-card-switch feeds-filter-swtich"v-for="[id, type] of Object.entries(allSideCards)":key=id @click=toggleBlockSide(id)><label :class="{disabled: sideDisabled(id)}"><span class=name :class="{disabled: sideDisabled(id)}">{{type.displayName}}</span><icon class=disabled type=mdi icon=cancel></icon><icon type=mdi icon=check></icon></label></div></div></div>`;t.applyStyleFromText(`body.enable-feeds-filter:not(.disable-feeds-filter).feeds-filter-block-audio .feed-card .card[data-type="256"],body.enable-feeds-filter:not(.disable-feeds-filter).feeds-filter-block-bangumi .feed-card .card[data-type="512"],body.enable-feeds-filter:not(.disable-feeds-filter).feeds-filter-block-column .feed-card .card[data-type="64"],body.enable-feeds-filter:not(.disable-feeds-filter).feeds-filter-block-miniVideo .feed-card .card[data-type="16"],body.enable-feeds-filter:not(.disable-feeds-filter).feeds-filter-block-repost .feed-card .card[data-type="1"],body.enable-feeds-filter:not(.disable-feeds-filter).feeds-filter-block-share .feed-card .card[data-type="2048"],body.enable-feeds-filter:not(.disable-feeds-filter).feeds-filter-block-text .feed-card .card[data-type="4"],body.enable-feeds-filter:not(.disable-feeds-filter).feeds-filter-block-textWithImages .feed-card .card[data-type="2"],body.enable-feeds-filter:not(.disable-feeds-filter).feeds-filter-block-video .feed-card .card[data-type="8"]{display:none!important}body.enable-feeds-filter:not(.disable-feeds-filter) .left-panel>*,body.enable-feeds-filter:not(.disable-feeds-filter) .right-panel>*{margin:0 0 8px!important}body.enable-feeds-filter:not(.disable-feeds-filter) .feed-card .card.pattern-block,body.enable-feeds-filter:not(.disable-feeds-filter).feeds-filter-side-block-following-tags .left-panel .tag-panel,body.enable-feeds-filter:not(.disable-feeds-filter).feeds-filter-side-block-live .right-panel .live-panel,body.enable-feeds-filter:not(.disable-feeds-filter).feeds-filter-side-block-notice .right-panel .notice-panel,body.enable-feeds-filter:not(.disable-feeds-filter).feeds-filter-side-block-profile .left-panel .user-wrapper,body.enable-feeds-filter:not(.disable-feeds-filter).feeds-filter-side-block-trending-tags .right-panel .tag-panel{display:none!important}.feeds-filter{background-color:#fff;width:100%;padding:12px 16px;float:left;border-radius:4px;box-sizing:border-box;display:none;flex-direction:column}body.enable-feeds-filter:not(.disable-feeds-filter) .feeds-filter{display:flex}.feeds-filter,.feeds-filter *{transition:.2s ease-out}body.dark .feeds-filter{color:#eee;background-color:#444}.feeds-filter h1{font-weight:400;font-size:14px;margin:0 0 14px}.feeds-filter h2{font-weight:700;font-size:13px;margin:0 0 8px}.feeds-filter .feeds-filter-swtich:not(:last-child){margin-bottom:4px}.feeds-filter .feeds-filter-swtich label{cursor:pointer;margin:0;padding:4px 8px;border-radius:4px;background-color:#0001;display:flex;align-items:center;justify-content:space-between;border:1px solid transparent}.feeds-filter .feeds-filter-swtich label .name{font-size:12px}.feeds-filter .feeds-filter-swtich label .disabled{color:var(--theme-color)!important}.feeds-filter .feeds-filter-swtich label:hover{background-color:#0002}.feeds-filter .feeds-filter-swtich label input{display:none}.feeds-filter .feeds-filter-swtich label .be-icon{font-size:16px}.feeds-filter .feeds-filter-swtich label .be-icon.disabled,.feeds-filter .feeds-filter-swtich label.disabled .be-icon{display:none}.feeds-filter .feeds-filter-swtich label.disabled .be-icon.disabled{display:block}.feeds-filter .filter-type-switch{flex:0 0 49%}.feeds-filter .filter-side-card-switch{flex:0 0 100%}.feeds-filter .filter-types{display:flex;flex-wrap:wrap;justify-content:space-between;margin-bottom:18px}.feeds-filter .filter-patterns:not(:empty){margin-bottom:8px}.feeds-filter .filter-patterns .pattern{display:flex;align-items:center;justify-content:space-between;padding:4px 8px;border-radius:4px;background-color:#0001;font-size:12px}.feeds-filter .filter-patterns .pattern:not(:last-child){margin-bottom:4px}.feeds-filter .filter-patterns .pattern .be-icon{font-size:18px;cursor:pointer}.feeds-filter .add-pattern{display:flex;align-items:center;margin-bottom:18px}.feeds-filter .add-pattern input{color:inherit;background-color:transparent;font-size:12px;border:1px solid #8884;border-radius:4px;outline:0!important;padding:4px;flex:1 0 0;width:0}.feeds-filter .add-pattern input:focus{border-color:var(--theme-color)}.feeds-filter .add-pattern .be-icon{font-size:18px;cursor:pointer;margin-left:8px}`,"feeds-filter-card-style");const d={0:{className:"profile",displayName:"个人资料"},1:{className:"following-tags",displayName:"关注的话题"},2:{className:"notice",displayName:"公告栏"},3:{className:"live",displayName:"正在直播"}};const s="feeds-filter-side-block-";return{export:Object.assign({template:i},{components:{FilterTypeSwitch:()=>t.importAsync("filter-type-switch.vue"),Icon:()=>t.importAsync("icon.vue")},methods:{updateCard(t){const i=(e,t)=>{if(e.startsWith("/")&&e.endsWith("/")){return new RegExp(e.slice(1,e.length-1)).test(t)}return t.includes(e)};const d=(()=>{return e.feedsFilterPatterns.some(e=>{const d=e.match(/(.+) up:([^ ]+)/);if(d){return i(d[1],t.text)&&i(d[2],t.username)}return i(e,t.text)})})();if(d){t.element.classList.add("pattern-block")}else{t.element.classList.remove("pattern-block")}},deletePattern(t){const i=e.feedsFilterPatterns.indexOf(t);if(i!==-1){this.patterns.splice(i,1)}},addPattern(e){if(e&&!this.patterns.includes(e)){this.patterns.push(e)}this.newPattern=""},updateBlockSide(){Object.entries(d).forEach(([e,t])=>{const i=s+t.className;document.body.classList[this.blockSideCards.includes(e)?"add":"remove"](i)})},toggleBlockSide(t){const i=this.blockSideCards.indexOf(t);const a=d[t];if(i!==-1){this.blockSideCards.splice(i,1);document.body.classList.remove(s+a.className)}else{this.blockSideCards.push(t);document.body.classList.add(s+a.className)}e.feedsFilterSideCards=this.blockSideCards},sideDisabled(e){return this.blockSideCards.includes(e)}},watch:{patterns(){e.feedsFilterPatterns=this.patterns;if(this.feedsCardsManager!==null){this.feedsCardsManager.cards.forEach(e=>this.updateCard(e))}}},data(){return{allTypes:[],patterns:[...e.feedsFilterPatterns],newPattern:"",feedsCardsManager:null,allSideCards:d,blockSideCards:[...e.feedsFilterSideCards]}},async mounted(){this.updateBlockSide();const e=await SpinQuery.select(".feed-card .tab-bar");if(!e){console.error("tabBar not found");return}const i=e.querySelector(".tab:nth-child(1) .tab-text");Observer.attributes(i,()=>{document.body.classList.toggle("enable-feeds-filter",i.classList.contains("selected"))});const{feedsCardsManager:d,feedsCardTypes:s}=await t.importAsync("feeds-apis");const a=await d.startWatching();if(!a){console.error("feedsCardsManager.startWatching() failed");return}this.allTypes=Object.entries(s).filter(([e,t])=>t.id<=2048).map(([e,t])=>{return[e,_.clone(t)]});d.cards.forEach(e=>this.updateCard(e));d.addEventListener("addCard",e=>{const t=e.detail;this.updateCard(t)});this.feedsCardsManager=d}})}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/feeds-translate.min.css"] = `.card-content .translate-container{margin-top:10px}.card-content .translate-container .translated{font-size:12px;color:#aaa}.card-content .translate-container .translated a{color:var(--theme-color)}.card-content .translate-container .translate{display:flex;align-items:center;font-size:12px;color:#aaa;cursor:pointer}.card-content .translate-container .translate:hover{color:var(--theme-color)}.card-content .translate-container .translate .mdi{font-size:14px;margin-right:2px}.card-content .translate-container .translating{font-size:18px}.card-content .translate-container .translate-result{padding-top:10px;padding-right:10px;white-space:pre-wrap;line-height:22px;word-break:break-all;overflow-wrap:break-word}body.dark .card-content .translate-container .translate-result{color:#eee}`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/feeds-translate.min.js"] = (()=>{return(t,a)=>{(async()=>{if(!document.URL.startsWith("https://t.bilibili.com/")){return}a.applyStyle("feedsTranslateStyle");const{getTranslator:e}=await a.importAsync("feeds-translate-providers");const r=Vue.extend({template:`\n<div class="translate-container">\n<div class="translate" v-if="!working && !translated" @click="translate()">\n<i class="mdi mdi-earth"></i>翻译\n</div>\n<i v-if="working" class="translating mdi mdi-18px mdi-loading mdi-spin"></i>\n<div class="translated" v-if="translated">翻译自<a :href="activeTranslator.link" target="_blank">{{activeTranslator.name}}</a>:</div>\n<div v-if="translated" class="translate-result">{{result}}</div>\n</div>\n`,props:{card:{type:Object,required:true}},data(){return{result:"",working:false,activeTranslator:{}}},computed:{translated(){return this.result!==""}},methods:{async translate(){const a=this.card;try{this.working=true;const r=(await a.getText()).replace(/#(.+?)#/g,"");const n=this.activeTranslator=e();this.result=await n.translate(r,{targetLanguage:(()=>{if(t.i18n){return languageNameToCode[t.i18nLanguage]}if(t.feedsTranslateLanguage!==""){return t.feedsTranslateLanguage}return})()})}catch(t){logError(t)}finally{this.working=false}}}});const n=t=>{if(t.text.replace(/#(.+?)#/g,"")===""){return}const a=t.element.querySelector(".card-content");const e=new r({propsData:{card:_.clone(t)}}).$mount();a.insertAdjacentElement("beforeend",e.$el)};const s=document.URL.replace(location.search,"");const{feedsCardsManager:i}=await a.importAsync("feeds-apis");if(s==="https://t.bilibili.com/"){const t=await i.startWatching();if(!t){console.error("feedsCardsManager.startWatching() failed");return}i.cards.forEach(n);i.addEventListener("addCard",t=>{n(t.detail)})}else if(s.match(/t.bilibili.com\/(\d+)/)){const t=await SpinQuery.select(".detail-card .card");if(t!==null&&"__vue__"in t){const a=await i.parseCard(t);n(a)}}})()}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/feeds-translate-providers.min.js"] = (()=>{return(t,e)=>{class n{}class r extends n{constructor(){super(...arguments);this.name="Bing";this.link="https://translate.bing.com/"}async translate(t,e){const n="zh-Hans";let r=_.get(e,"targetLanguage",n);if(r.includes("-")&&r!==n){r=r.substring(0,r.indexOf("-"))}try{const e=await Ajax.monkey({url:"https://cn.bing.com/ttranslatev3",method:"POST",data:Object.entries({fromLang:"auto-detect",to:r,text:t}).map(([t,e])=>`${t}=${e}`).join("&"),headers:{"User-Agent":UserAgent,"Content-Type":"application/x-www-form-urlencoded"},responseType:"json"});const[n]=e;if(n.translations){return n.translations.map(t=>t.text).join("\n")}else{console.error("Translator: Bing",n);throw new Error("调用Bing翻译失败.")}}catch(t){console.error("Translator: Bing",t);throw new Error("调用Bing翻译失败.")}}}class s extends n{constructor(){super(...arguments);this.name="Google";this.link="https://translate.google.com/";this.apiUrl="https://translate.google.com/translate_a/single"}async translate(t,e){const n="zh";let r=_.get(e,"targetLanguage",n);if(r.includes("-")&&r!==n){r=r.substring(0,r.indexOf("-"))}try{const e=await Ajax.monkey({url:`${this.apiUrl}?${Object.entries({client:"gtx",sl:"auto",tl:r,dt:"t",q:encodeURIComponent(t)}).map(([t,e])=>`${t}=${e}`).join("&")}`,method:"GET",headers:{"User-Agent":UserAgent},responseType:"json"});const n=e[0].map(t=>t[0]).join("");return n}catch(t){console.error("Translator: Google",t);throw new Error("调用Google翻译失败.")}}}class o extends s{constructor(){super(...arguments);this.link="https://translate.google.cn/";this.apiUrl="https://translate.google.cn/translate_a/single"}}const a=()=>{switch(t.feedsTranslateProvider){default:case"Bing":return new r;case"Google":return new s;case"GoogleCN":return new o}};return{export:{getTranslator:a}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/ffmpeg-support.min.js"] = (()=>{return(e,t)=>{const n=[".mp4",".m4a"];const r=(e,t,n)=>{if(e<2){return null}const r=[];for(let s=1;s<=e;s++){let e=` - ${s}`;if(n.includes(".m4a")){e=""}const l=escapeFilename(`${t}${e}${n[s-1]}`).replace(/'/g,"'\\''");r.push(`file '${l}'`)}return r.join("\n")};const s=(e,t)=>{const r=e=>e.fragments.length>1;const s=e.filter(r);if(s.length===0){return null}const l=new Map;s.forEach(e=>{l.set(escapeFilename(`ffmpeg-files-${e.title}.txt`),e.fragments.map((r,s)=>{let l=` - ${s+1}`;if(t===true){l=""}const a=escapeFilename(`${e.title}${l}${t===true?n[s]:t}`).replace(/'/g,"'\\''");return`file '${a}'`}).join("\n"))});return l};const l=(e,t)=>{const r=[];e.forEach(e=>{e.fragments.forEach((s,l)=>{let a="";if(e.fragments.length>1&&t!==true){a=` - ${l+1}`}const c=escapeFilename(`${e.title}${a}${t===true?n[l]:t}`).replace(/'/g,"'\\''");r.push(`file '${c}'`)})});return r.join("\n")};return{export:{getFragmentsList:r,getBatchFragmentsList:s,getBatchEpisodesList:l}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/fill-with-comments.min.js"] = (()=>{return(t,e)=>{const n="fill-with-comments-style";const l=t=>{};return{export:{fillWithComments:l}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/filter-type-switch.vue.min.js"] = (()=>{return(e,s)=>{const i=`<div class="filter-type-switch feeds-filter-swtich"><label :class={disabled}><span class=name :class={disabled}>{{type.name}}</span><input type=checkbox v-model=disabled><icon class=disabled type=mdi icon=cancel v-if=disabled></icon><icon type=mdi icon=check v-else></icon></label></div>`;return{export:Object.assign({template:i},{components:{Icon:()=>s.importAsync("icon.vue")},props:["name","type"],methods:{setFilter(s,i=true){document.body.classList[s?"add":"remove"](`feeds-filter-block-${this.name}`);if(!i){return}if(s){e.feedsFilterTypes.push(this.type.id)}else{const s=e.feedsFilterTypes.indexOf(this.type.id);if(s!==-1){e.feedsFilterTypes.splice(s,1)}}e.feedsFilterTypes=e.feedsFilterTypes}},data(){const s=e.feedsFilterTypes.includes(this.type.id);this.setFilter(s,false);return{disabled:s}},watch:{disabled(e){this.setFilter(e)}}})}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/fix-fullscreen.min.js"] = (()=>{return(e,n)=>{unsafeWindow.Element.ALLOW_KEYBOARD_INPUT={};const t=unsafeWindow.Element.prototype.requestFullscreen;unsafeWindow.Element.prototype.requestFullscreen=function(){t.call(this)}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/fold-comment.min.css"] = `.panel-area .bb-comment .fold-comment{position:-webkit-sticky;position:sticky;bottom:0;height:40px;width:calc(100% + 48px);font-size:14px;transform:translateX(-24px);display:flex;align-items:center;justify-content:center;background-color:#fff;color:#99a2aa;cursor:pointer;transition:.2s ease-out;z-index:1000;border-radius:4px}.panel-area .bb-comment .fold-comment:hover{color:#000}body.dark .panel-area .bb-comment .fold-comment{background-color:#444;color:#eee}body.dark .panel-area .bb-comment .fold-comment:hover{color:var(--theme-color)}`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/fold-comment.min.js"] = (()=>{return(e,t)=>{if(document.URL.replace(window.location.search,"")==="https://t.bilibili.com/"){(async()=>{t.applyImportantStyle("foldCommentStyle");const e=await SpinQuery.select(".card-list .feed-card>.content");const l=e=>{const t=t=>{const l=document.createElement("div");l.classList.add("fold-comment");l.innerHTML="收起评论";const n=t.querySelector(".bb-comment");if(n===null){console.error("未找到评论区");return}else if(n.querySelector(".fold-comment")!==null){return}else{l.addEventListener("click",()=>{const t=e.querySelector(".button-bar").children[1];if(t!==null){t.click();e.scrollIntoView()}});n.insertAdjacentElement("beforeend",l)}};const l=e.querySelector(".panel-area");if(l===null){console.log(e)}if(l.childElementCount===0){const e=Observer.childList(l,n=>{if(n.length>0){t(l);e.forEach(e=>e.stop())}})}else{t(l)}};Observer.childList(e,()=>e.querySelectorAll("div.card").forEach(l))})()}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/frame-playback.min.css"] = `.frame-playback{display:none!important;height:100%;align-items:center;padding-left:4px;cursor:pointer;filter:brightness(0) invert(1)!important}.frame-playback.touch{padding-left:8px}.frame-playback.touch span{display:flex;align-items:center}.bilibili-player-video-control-bottom .frame-playback{display:flex!important}.frame-playback i{transition:.4s cubic-bezier(.18,.89,.32,1.28);opacity:.9}.frame-playback:not(.touch) i{margin-top:-2px}.bilibili-player.mode-fullscreen .frame-playback span,.bilibili-player.mode-webfullscreen .frame-playback span{transform:scale(1.2)}.bilibili-player.mode-fullscreen .frame-playback:not(.touch) i,.bilibili-player.mode-webfullscreen .frame-playback:not(.touch) i{margin-top:2px}.bilibili-player.mode-fullscreen .frame-playback,.bilibili-player.mode-webfullscreen .frame-playback{margin-left:0}.bilibili-player.mode-fullscreen .frame-playback.touch,.bilibili-player.mode-webfullscreen .frame-playback.touch{margin-left:6px}.frame-playback.prev-frame i{transform:scale(1.3) rotate(-90deg)}.frame-playback.prev-frame:hover i{transform:scale(1.4) rotate(-90deg);opacity:1}.frame-playback.prev-frame:active i{transform:scale(1.25) rotate(-90deg);opacity:1}.frame-playback.next-frame i{transform:scale(1.3) rotate(90deg)}.frame-playback.next-frame:hover i{transform:scale(1.4) rotate(90deg);opacity:1}.frame-playback.next-frame:active i{transform:scale(1.25) rotate(90deg);opacity:1}`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/frame-playback.min.html"] = `<div class="frame-playback prev-frame icons-enabled"title=上一帧><span><i class=icon-arrow></i></span></div><div class="frame-playback next-frame icons-enabled"title=下一帧><span><i class=icon-arrow></i></span></div>`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/frame-playback.min.js"] = (()=>{return(e,t)=>{const r=t.import("framePlaybackHtml");t.applyStyle("framePlaybackStyle");const a=async()=>{if(e.videoScreenshot){const e=await SpinQuery.select(".video-take-screenshot");if(e===null||document.querySelector(".frame-playback")){return}e.insertAdjacentHTML("afterend",r)}else{const e=await SpinQuery.select(".bilibili-player-video-time");if(e===null||document.querySelector(".frame-playback")){return}e.insertAdjacentHTML("afterend",r)}let t=0;const a=()=>dq("video").currentTime-=t;const i=()=>dq("video").currentTime+=t;Observer.attributesSubtree(".bilibili-player-video-quality-menu ul.bui-select-list",()=>{const e=document.querySelector(".bilibili-player-video-quality-menu .bui-select-item-active");const r=e?parseInt(e.getAttribute("data-value")):0;const a=(()=>{switch(r){case 116:case 74:return 6e4/1001;default:return 3e4/1001}})();t=1/a});document.addEventListener("keydown",e=>{if(e.shiftKey&&!["input","textarea"].includes(document.activeElement.nodeName.toLowerCase())){if(e.key==="ArrowLeft"){e.stopPropagation();e.preventDefault();a()}else if(e.key==="ArrowRight"){e.stopPropagation();e.preventDefault();i()}}});document.querySelector(".prev-frame").addEventListener("click",a);document.querySelector(".next-frame").addEventListener("click",i);if(e.touchVideoPlayer){document.querySelectorAll(".frame-playback").forEach(e=>e.classList.add("touch"))}};Observer.videoChange(a);return{reload:()=>document.querySelectorAll(".bilibili-player-video-control-bottom .frame-playback").forEach(e=>e.setAttribute("style","display: flex !important")),unload:()=>document.querySelectorAll(".bilibili-player-video-control-bottom .frame-playback").forEach(e=>e.setAttribute("style","display: none !important"))}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/full-activity-content.min.js"] = (()=>{return(n,t)=>{const a=`\n.card .main-content .expand-btn,\n.card .main-content .content-ellipsis {\n  display: none !important;\n}\n.card .main-content .content-full{\n  display: block !important;\n  height: auto !important;\n}\n`;return t.toggleStyle(a,"full-activity-content")}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/full-page-title.min.css"] = `.multi-page .cur-list .list-box li{height:auto!important}.multi-page .cur-list .list-box li a{overflow:visible!important;white-space:normal!important}.multi-page .cur-list ul{max-height:none!important}`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/full-page-title.min.js"] = (()=>{return(e,l)=>{return l.toggleStyle("fullPageTitleStyle")}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/full-tweets-title.min.css"] = `.dynamic-m .info{height:auto!important}.dynamic-m .info a{white-space:normal!important}`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/full-tweets-title.min.js"] = (()=>{return(t,n)=>{const i=`\n.dynamic-m .info {\n  height: auto !important;\n}\n.dynamic-m .info a {\n  white-space: normal !important;\n}\n.custom-navbar .video-activity-card .title {\n  display: block !important;\n  max-height: unset !important;\n}\n.custom-navbar .video-activity-card .cover {\n  height: unset !important;\n}\n`;return n.toggleStyle(i,"full-tweets-title")}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/gui-settings.min.css"] = `.gui-settings-icon-panel{height:auto;display:flex;flex-direction:column;justify-content:center;align-items:center;position:fixed;top:calc(50% + var(--side-bar-offset));left:0;width:32px;z-index:99999;transform:translateY(-50%);user-select:none}.gui-settings-icon-panel i{transition:.2s;opacity:.6;transform:rotate(360deg);font-size:12px}.gui-settings,.gui-settings-widgets{display:flex;justify-content:center;align-items:center;cursor:pointer;-webkit-tap-highlight-color:transparent;margin:16px 0;width:24px;height:24px;transition:.2s;opacity:1;transform-origin:center!important;transform:translateX(-16px);background-color:#dddc;border-radius:0 50% 50% 0;padding:6px;box-sizing:content-box}.gui-settings-widgets:hover i,.gui-settings:hover i{opacity:.75;transform:rotate(0)}body.dark .gui-settings,body.dark .gui-settings-widgets{background-color:rgba(0,0,0,.3)}.gui-settings-widgets:hover,.gui-settings:hover{opacity:1;transform:translateX(0)}.gui-settings-footer,.gui-settings-header{flex-grow:0;display:flex;align-items:center;justify-content:space-between;flex-shrink:0;padding:32px 24px 32px 32px}.gui-settings-header .operations{margin-left:16px;cursor:pointer;position:relative}.gui-settings-header .operations,.gui-settings-header .operations *{transition:.2s ease-out}.gui-settings-header .operations .mdi{font-size:20px}.gui-settings-header .operations .operations-menu{transition-delay:.2s;position:absolute;top:calc(100% + 8px);right:0;display:flex;flex-direction:column;opacity:0;transform-origin:top;transform:scaleY(0);z-index:102;background-color:#fff;border-radius:8px;box-shadow:0 2px 4px 1px #0002}body.dark .gui-settings-header .operations .operations-menu{background-color:#333}.gui-settings-header .operations .operations-menu .operation{display:flex;align-items:center;padding:8px 16px;white-space:nowrap;font-size:14px;border-radius:8px}.gui-settings-header .operations .operations-menu .operation .mdi{margin-right:8px}.gui-settings-header .operations .operations-menu .operation:hover{background-color:#8882}.gui-settings-header .operations:hover .operations-menu{opacity:1;transform:scaleY(1)}.gui-settings-footer{height:80px;justify-content:center;position:relative}.gui-settings-content{flex-grow:1;overflow:auto;position:relative;overscroll-behavior:contain}.gui-settings-content ul{padding:0;margin:0}.gui-settings-content ul li{font-size:16px;margin-bottom:18px;display:flex;height:24px;transition:.2s;box-sizing:content-box}.gui-settings-content ul li.disabled,.gui-settings-content ul li:not(.category).folded{height:0;margin:0;overflow:hidden}.gui-settings-content ul li.indent-0{margin-left:16px}.gui-settings-content ul li.indent-1{margin-left:80px}.gui-settings-content ul li.indent-2{margin-left:144px}.gui-settings-content ul li.indent-center{align-items:center;justify-content:center}.gui-settings-content ul li.category{padding:16px 0;margin-bottom:18px;border-top:1px dashed #8884;border-bottom:1px dashed #8884;background:#fff;position:-webkit-sticky;position:sticky;top:0;z-index:101;cursor:pointer;transition:.2s ease-out;-webkit-tap-highlight-color:transparent}.gui-settings-content ul li.category.folded{margin-bottom:-1px}.gui-settings-content ul li.category *{opacity:.8}.gui-settings-title{font-size:16pt;flex:0 0 auto}.gui-settings-box .gui-settings-title{margin-right:64px}.gui-settings-search[type=text]{flex:1 0 auto;height:auto;border:none;padding:6px;font-size:12pt;width:40%;border-bottom:1px solid #8884;transition:.2s;color:inherit;background:0 0;box-sizing:border-box;outline:0!important}.gui-settings-close{width:24px;height:24px;padding:16px}.gui-settings-header .gui-settings-close{cursor:pointer;-webkit-tap-highlight-color:transparent}.gui-settings-textbox-container{display:flex;justify-content:center;align-items:center;-webkit-tap-highlight-color:transparent}.gui-settings-textbox-container span{margin:0 16px;transition:.2s}.gui-settings-textbox-container input{border:none;height:100%;max-width:90px;padding:4px 8px!important;background:#8884;transition:.2s;font-size:16px}.gui-settings-textbox-container input:disabled,.gui-settings-textbox-container.disabled div,.gui-settings-textbox-container.disabled span{opacity:.5}.gui-settings-textbox-container input[key=batchFilenameFormat],.gui-settings-textbox-container input[key=filenameFormat]{max-width:500px}.gui-settings-dropdown-span{margin:0 16px;transition:.2s}.gui-settings-checkbox-container{cursor:pointer;display:flex;width:100%;justify-content:start;align-items:center;padding:0 16px;-webkit-tap-highlight-color:transparent}.gui-settings-checkbox-container .gui-settings-checkbox{width:28px;margin-right:24px;height:12px;background:#8884;border-radius:16px;position:relative}.gui-settings-checkbox-container .gui-settings-checkbox::after{content:"";width:20px;height:20px;background:#c6c6c6;position:absolute;border-radius:50%;top:-4px;left:-4px;box-shadow:0 2px 4px 0 #0003;transition:.2s ease-out}.gui-settings-checkbox-container .gui-settings-ok{width:24px;height:24px;margin-right:16px;transition:.2s}.gui-settings-checkbox-container input{visibility:collapse;transition:.2s;width:0;position:absolute}.gui-settings-checkbox-container input:checked~.gui-settings-checkbox{background:var(--theme-color-80)}.gui-settings-checkbox-container input:checked~.gui-settings-checkbox::after{background:var(--theme-color)!important;box-shadow:0 2px 4px 0 var(--theme-color-40);left:calc(100% - 16px)}.gui-settings-checkbox-container input:disabled~.gui-settings-checkbox{opacity:.5}.gui-settings-checkbox-container input~.gui-settings-ok{background-color:#8884}.gui-settings-checkbox-container input:checked~.gui-settings-ok{background-color:var(--theme-color)}.gui-settings-checkbox-container input~.gui-settings-ok>i{opacity:0;transform-origin:center;transform:scale(.9)}.gui-settings-checkbox-container input:checked~.gui-settings-ok>i{opacity:1}.gui-settings-checkbox-container input:disabled~.gui-settings-ok,.gui-settings-checkbox-container input:disabled~span{opacity:.5}button.gui-settings-button{padding:6px 20px;margin:0 4px;max-height:34px;border:none;background:#8884;font-size:16px;cursor:pointer;transition:.2s ease-out;font-family:inherit;-webkit-tap-highlight-color:transparent}button.gui-settings-button:hover{opacity:.9}button.gui-settings-button:active{opacity:.8}button.gui-settings-button:focus{outline:0}.custom-color-preview{width:28px;height:28px;border-radius:50%;background:var(--theme-color);margin-right:16px;position:relative;cursor:pointer;box-sizing:border-box;box-shadow:0 2px 4px 0 var(--theme-color-40)}.predefined-colors{transition:.2s;display:flex;opacity:0;background:#fff;width:168px;height:168px;position:absolute;box-shadow:rgba(0,0,0,.2) 0 4px 8px 0;top:32px;left:calc(-84px + 50%);transform:scale(0);transform-origin:top;z-index:9}.predefined-colors.opened{opacity:1;transform:scale(1)}.predefined-colors-grid{display:grid;grid-template-columns:auto auto auto auto;margin:0;flex-grow:1}.predefined-colors-grid-block{width:100%;height:100%;justify-self:center;align-self:center;cursor:pointer;transform-origin:center;transition:.1s ease-out}.predefined-colors-grid-block:hover{transform:scale(1.1);box-shadow:0 0 8px 1px #0004}input[key]:focus{outline:0}input[type=text][key]{height:auto;border:none;line-height:normal}.gui-settings-label{margin:0 16px;font-size:16px}.hidden{display:none!important}@supports (backdrop-filter:blur(24px)) or (-webkit-backdrop-filter:blur(24px)){.gui-settings-box.blur li.category{-webkit-backdrop-filter:blur(24px);backdrop-filter:blur(24px);background:0 0}.gui-settings-box.blur{background:#fff8}.gui-settings-box.blur .gui-settings-content,.gui-settings-box.blur .gui-settings-footer,.gui-settings-box.blur .gui-settings-header{background:#fff8;-webkit-backdrop-filter:blur(64px);backdrop-filter:blur(64px)}}li.category i.icon-arrow{transition:.2s ease-out}li.category.folded i.icon-arrow{transform:rotate(180deg)}.gui-settings-dropdown-container{display:flex;align-items:center}.gui-settings-dropdown{position:relative;cursor:pointer;-webkit-tap-highlight-color:transparent;background-color:#8884;display:inline-flex;align-items:center;height:32px}.gui-settings-dropdown>i{transition:.2s ease-out;transform-origin:center;transform:rotate(180deg)}.gui-settings-dropdown>ul{position:absolute;top:calc(100%);width:100%;cursor:pointer;background:#fff;transform-origin:top;transform:scaleY(0);transition:.2s cubic-bezier(.6,-.28,.74,.05);display:flex;flex-direction:column;align-items:center;box-shadow:rgba(0,0,0,.2) 0 4px 8px 0;z-index:102}.gui-settings-dropdown ul li{margin:0;padding:8px 0;height:auto;width:100%;justify-content:center}.gui-settings-dropdown ul li:hover{background:rgba(0,0,0,.16)}.gui-settings-dropdown.opened>ul{transform:scaleY(1);transition-timing-function:cubic-bezier(.18,.89,.32,1.28)}.gui-settings-dropdown.opened>i{transform:rotate(0)}.gui-settings-dropdown input{cursor:pointer;border:none;height:100%;max-width:80px;padding:4px 8px;transition:.2s;font-size:16px;background-color:transparent}.gui-settings-dropdown input[key=defaultPlayerMode]{max-width:120px}.gui-settings-dropdown input[key=scriptLoadingMode]{max-width:170px}.gui-settings-dropdown input[key=defaultBangumiLayout],.gui-settings-dropdown input[key=defaultPlayerLayout],.gui-settings-dropdown input[key=defaultVideoSpeed]{max-width:50px}.gui-settings-mask{height:calc(100% + 5px);width:calc(100% + 5px);opacity:0;background:#000a;position:fixed;top:0;left:0;z-index:99999;pointer-events:none;transition:.3s cubic-bezier(0,.86,.58,1);overscroll-behavior:contain}.gui-settings-mask.opened{opacity:1;pointer-events:initial}.gui-settings-mask.opened.transparent{opacity:0;transition:.3s cubic-bezier(0,.86,.58,1) .3s}.gui-settings-box,.gui-settings-widgets-box{height:100%;width:420px;background:#fff;color:#000;position:fixed;top:0;left:0;z-index:100001;transform:translateX(-101%);transition:.3s cubic-bezier(0,.86,.58,1);display:none;flex-direction:column;box-shadow:4px 0 16px 0 #0000}.gui-settings-box.loaded,.gui-settings-widgets-box.loaded{display:flex}.gui-settings-box.opened,.gui-settings-widgets-box.opened{transform:translateX(0);box-shadow:4px 0 16px 0 #0005}.gui-settings-box kbd,.gui-settings-widgets-box kbd{padding:0 4px;border-radius:4px;border:1px solid #ccc;color:#ccc;border-bottom-width:3px;margin:0 4px}.gui-settings-box li i.downloading,.gui-settings-widgets-box li i.downloading{margin-left:8px;font-style:normal;display:flex;align-items:center;font-size:14px;background:var(--theme-color);color:var(--foreground-color);padding:2px 8px}.gui-settings-widgets-box{min-width:210px;width:auto}.gui-settings-widgets-box>.title{margin:32px;font-size:16pt}.gui-settings-widgets-box>.widgets-container{padding:32px;display:flex;flex-direction:column;align-items:start;justify-content:start;position:relative;overscroll-behavior:contain;overflow:auto;height:100%;scrollbar-width:none!important}.gui-settings-widgets-box>.widgets-container::-webkit-scrollbar{height:0!important;width:0!important}.gui-settings-widgets-box>.widgets-container .empty-tip{font-size:10pt;display:none}.gui-settings-widgets-box>.widgets-container .empty-tip.show{display:block}.gui-settings-widgets-box>.gui-settings-header{justify-content:start}.gui-settings-flat-button,.gui-settings-flat-button a,.gui-settings-flat-button a:hover{display:flex;align-items:center;justify-content:center;color:inherit}.gui-settings-flat-button{width:auto;white-space:nowrap;padding:8px 16px;background:#8882;border:none;color:#000;cursor:pointer;transition:.2s ease-out;font-size:10pt;flex:0 0 auto;margin:4px;border-radius:20px;box-shadow:#0004 0 2px 4px;height:40px;box-sizing:border-box;-webkit-tap-highlight-color:transparent!important}.gui-settings-flat-button:disabled{opacity:.5;cursor:not-allowed}.gui-settings-flat-button:hover:not(:disabled){background:#8884}.gui-settings-flat-button:active:not(:disabled){border-bottom-color:var(--theme-color)}.gui-settings-flat-button:focus{outline:0}.gui-settings-flat-button i{margin-right:8px;line-height:24px;height:24px}.gui-settings-flat-button .popup{position:absolute;top:calc(100% + 2px);transition:.2s ease-out;transform:translateX(-50%) translateY(-6px);opacity:0;pointer-events:none;left:50%;background:#fff;box-shadow:rgba(0,0,0,.2) 0 4px 8px 0;z-index:200;display:flex;flex-direction:column;align-items:center;width:max-content}.gui-settings-flat-button .popup *{transition:.2s}.gui-settings-flat-button .popup.opened{transform:translateX(-50%) translateY(0);opacity:1;pointer-events:initial}.gui-settings-flat-button .popup ul{list-style:none;margin:0;padding:0}.gui-settings-header>i{margin-right:8px}.player-full-win .app-content,.player-full-win .live-room-app .app-content,.player-mode-webfullscreen .player-module{z-index:100000!important}body.round-corner{--corner-radius:4px;--large-corner-radius:8px}body.round-corner .gui-settings-box li i.downloading,body.round-corner .gui-settings-dropdown,body.round-corner .gui-settings-dropdown ul li,body.round-corner .gui-settings-dropdown>ul,body.round-corner .gui-settings-flat-button .popup,body.round-corner .gui-settings-textbox-container input{border-radius:var(--corner-radius)}.gui-settings-dock-right .gui-settings-icon-panel{right:0;left:unset}.gui-settings-dock-right .gui-settings-icon-panel .gui-settings,.gui-settings-dock-right .gui-settings-icon-panel .gui-settings-widgets{transform:translateX(16px);border-radius:50% 0 0 50%}.gui-settings-dock-right .gui-settings-icon-panel .gui-settings-widgets:hover,.gui-settings-dock-right .gui-settings-icon-panel .gui-settings:hover{transform:translateX(0)}.gui-settings-dock-right .gui-settings-box,.gui-settings-dock-right .gui-settings-widgets-box{right:0;left:unset;transform:translateX(101%)}.gui-settings-dock-right .gui-settings-box.opened,.gui-settings-dock-right .gui-settings-widgets-box.opened{transform:translateX(0)}.gui-settings-dock-right .gui-settings-tooltip{right:440px;left:unset}`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/gui-settings.min.html"] = `<div class=gui-settings-mask></div><div class="gui-settings-widgets-box icons-enabled"><div class=gui-settings-header><i class=icon-widgets></i><span class=gui-settings-title>附加功能</span></div><div class=widgets-container><div class=empty-tip>空空如也哦 =￣ω￣=</div></div></div><div class="gui-settings-box icons-enabled"><div class=gui-settings-header><i class=icon-settings></i><span class=gui-settings-title>设置</span><i class=icon-search style="transform: scale(0.9); margin-right: 0"></i><input class=gui-settings-search placeholder=搜索设置项 type=text><div class=operations><i class="mdi mdi-dots-vertical"></i><div class=operations-menu><div class="operation export"><i class="mdi mdi-inbox-arrow-up"></i>导出设置</div><div class="operation import"><i class="mdi mdi-inbox-arrow-down"></i>导入设置</div></div></div></div><div class=gui-settings-content><ul><li class="indent-center category folded"><i class=icon-video style=margin-right:8px></i><span class=settings-category>视频</span><i class=icon-arrow style=margin-left:8px></i></li><li class="indent-0 folded"data-indent=0 data-key=useDefaultPlayerMode data-dependencies=""><label class=gui-settings-checkbox-container><input key=useDefaultPlayerMode type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-1 folded"data-indent=1 data-key=defaultPlayerMode data-dependencies=useDefaultPlayerMode><label class=gui-settings-dropdown-container><span class=gui-settings-dropdown-span></span><div class="gui-settings-dropdown popup"><input readonly=readonly type=text spellcheck=false key=defaultPlayerMode dependencies=useDefaultPlayerMode><ul></ul><i class=icon-arrow></i></div></label></li><li class="indent-1 folded"data-indent=1 data-key=applyPlayerModeOnPlay data-dependencies=useDefaultPlayerMode><label class=gui-settings-checkbox-container><input key=applyPlayerModeOnPlay type=checkbox dependencies=useDefaultPlayerMode checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-1 folded"data-indent=1 data-key=autoLightOff data-dependencies=useDefaultPlayerMode><label class=gui-settings-checkbox-container><input key=autoLightOff type=checkbox dependencies=useDefaultPlayerMode checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=useDefaultVideoQuality data-dependencies=""><label class=gui-settings-checkbox-container><input key=useDefaultVideoQuality type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-1 folded"data-indent=1 data-key=defaultVideoQuality data-dependencies=useDefaultVideoQuality><label class=gui-settings-dropdown-container><span class=gui-settings-dropdown-span></span><div class="gui-settings-dropdown popup"><input readonly=readonly type=text spellcheck=false key=defaultVideoQuality dependencies=useDefaultVideoQuality><ul></ul><i class=icon-arrow></i></div></label></li><li class="indent-0 folded"data-indent=0 data-key=useDefaultVideoSpeed data-dependencies=""><label class=gui-settings-checkbox-container><input key=useDefaultVideoSpeed type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-1 folded"data-indent=1 data-key=defaultVideoSpeed data-dependencies=useDefaultVideoSpeed><label class=gui-settings-dropdown-container><span class=gui-settings-dropdown-span></span><div class="gui-settings-dropdown popup"><input readonly=readonly type=text spellcheck=false key=defaultVideoSpeed dependencies=useDefaultVideoSpeed><ul></ul><i class=icon-arrow></i></div></label></li><li class="indent-0 folded"data-indent=0 data-key=useDefaultDanmakuSettings data-dependencies=""><label class=gui-settings-checkbox-container><input key=useDefaultDanmakuSettings type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-1 folded"data-indent=1 data-key=enableDanmaku data-dependencies=useDefaultDanmakuSettings><label class=gui-settings-checkbox-container><input key=enableDanmaku type=checkbox dependencies=useDefaultDanmakuSettings checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-1 folded"data-indent=1 data-key=rememberDanmakuSettings data-dependencies="useDefaultDanmakuSettings enableDanmaku"><label class=gui-settings-checkbox-container><input key=rememberDanmakuSettings type=checkbox dependencies="useDefaultDanmakuSettings enableDanmaku"checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=expandDanmakuList data-dependencies=""><label class=gui-settings-checkbox-container><input key=expandDanmakuList type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=expandDescription data-dependencies=""><label class=gui-settings-checkbox-container><input key=expandDescription type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=autoContinue data-dependencies=""><label class=gui-settings-checkbox-container><input key=autoContinue type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-1 folded"data-indent=1 data-key=allowJumpContinue data-dependencies=autoContinue><label class=gui-settings-checkbox-container><input key=allowJumpContinue type=checkbox dependencies=autoContinue checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=autoPlay data-dependencies=""><label class=gui-settings-checkbox-container><input key=autoPlay type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=skipChargeList data-dependencies=""><label class=gui-settings-checkbox-container><input key=skipChargeList type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=framePlayback data-dependencies=""><label class=gui-settings-checkbox-container><input key=framePlayback type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=videoScreenshot data-dependencies=""><label class=gui-settings-checkbox-container><input key=videoScreenshot type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=playerFocus data-dependencies=""><label class=gui-settings-checkbox-container><input key=playerFocus type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-1 folded"data-indent=1 data-key=playerFocusOffset data-dependencies=playerFocus><label class=gui-settings-textbox-container><span></span><input key=playerFocusOffset dependencies=playerFocus spellcheck=false type=text></label></li><li class="indent-0 folded"data-indent=0 data-key=outerWatchlater data-dependencies=""><label class=gui-settings-checkbox-container><input key=outerWatchlater type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=keymap data-dependencies=""><label class=gui-settings-checkbox-container><input key=keymap type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=doubleClickFullscreen data-dependencies=""><label class=gui-settings-checkbox-container><input key=doubleClickFullscreen type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-center category folded"><i class=icon-style style=margin-right:8px></i><span class=settings-category>样式</span><i class=icon-arrow style=margin-left:8px></i></li><li class="indent-0 folded"><label class=gui-settings-textbox-container><span>主题颜色</span><div class=custom-color-preview><div class="predefined-colors popup"><div class=predefined-colors-grid></div></div></div><input key=customStyleColor dependencies=""spellcheck=false type=text></label></li><li class="indent-0 folded"data-indent=0 data-key=foregroundColorMode data-dependencies=""><label class=gui-settings-dropdown-container><span class=gui-settings-dropdown-span></span><div class="gui-settings-dropdown popup"><input readonly=readonly type=text spellcheck=false key=foregroundColorMode dependencies=""><ul></ul><i class=icon-arrow></i></div></label></li><li class="indent-0 folded"data-indent=0 data-key=customNavbar data-dependencies=""><label class=gui-settings-checkbox-container><input key=customNavbar type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-1 folded"data-indent=1 data-key=customNavbarSeasonLogo data-dependencies=customNavbar><label class=gui-settings-checkbox-container><input key=customNavbarSeasonLogo type=checkbox dependencies=customNavbar checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-1 folded"data-indent=1 data-key=customNavbarFill data-dependencies=customNavbar><label class=gui-settings-checkbox-container><input key=customNavbarFill type=checkbox dependencies=customNavbar checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-1 folded"data-indent=1 data-key=customNavbarTransparent data-dependencies=customNavbar><label class=gui-settings-checkbox-container><input key=customNavbarTransparent type=checkbox dependencies=customNavbar checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-1 folded"data-indent=1 data-key=customNavbarShadow data-dependencies=customNavbar><label class=gui-settings-checkbox-container><input key=customNavbarShadow type=checkbox dependencies=customNavbar checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-1 folded"data-indent=1 data-key=customNavbarCompact data-dependencies=customNavbar><label class=gui-settings-checkbox-container><input key=customNavbarCompact type=checkbox dependencies=customNavbar checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-1 folded"data-indent=1 data-key=customNavbarBlur data-dependencies=customNavbar><label class=gui-settings-checkbox-container><input key=customNavbarBlur type=checkbox dependencies=customNavbar checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-2 folded"data-indent=2 data-key=customNavbarBlurOpacity data-dependencies="customNavbar customNavbarBlur"><label class=gui-settings-textbox-container><span></span><input key=customNavbarBlurOpacity dependencies="customNavbar customNavbarBlur"spellcheck=false type=text></label></li><li class="indent-0 folded"data-indent=0 data-key=useDarkStyle data-dependencies=""><label class=gui-settings-checkbox-container><input key=useDarkStyle type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=darkSchedule data-dependencies=""><label class=gui-settings-checkbox-container><input key=darkSchedule type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-1 folded"data-indent=1 data-key=darkScheduleStart data-dependencies=darkSchedule><label class=gui-settings-textbox-container><span></span><input key=darkScheduleStart dependencies=darkSchedule spellcheck=false type=text></label></li><li class="indent-1 folded"data-indent=1 data-key=darkScheduleEnd data-dependencies=darkSchedule><label class=gui-settings-textbox-container><span></span><input key=darkScheduleEnd dependencies=darkSchedule spellcheck=false type=text></label></li><li class="indent-0 folded"data-indent=0 data-key=compactLayout data-dependencies=""><label class=gui-settings-checkbox-container><input key=compactLayout type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=useCommentStyle data-dependencies=""><label class=gui-settings-checkbox-container><input key=useCommentStyle type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=simplifyHome data-dependencies=""><label class=gui-settings-checkbox-container><input key=simplifyHome type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-1 folded"data-indent=1 data-key=simplifyHomeStyle data-dependencies=simplifyHome><label class=gui-settings-dropdown-container><span class=gui-settings-dropdown-span></span><div class="gui-settings-dropdown popup"><input readonly=readonly type=text spellcheck=false key=simplifyHomeStyle dependencies=simplifyHome><ul></ul><i class=icon-arrow></i></div></label></li><li class="indent-0 folded"data-indent=0 data-key=hideBanner data-dependencies=""><label class=gui-settings-checkbox-container><input key=hideBanner type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=playerShadow data-dependencies=""><label class=gui-settings-checkbox-container><input key=playerShadow type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=narrowDanmaku data-dependencies=""><label class=gui-settings-checkbox-container><input key=narrowDanmaku type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=customControlBackground data-dependencies=""><label class=gui-settings-checkbox-container><input key=customControlBackground type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-1 folded"data-indent=1 data-key=customControlBackgroundOpacity data-dependencies=customControlBackground><label class=gui-settings-textbox-container><span></span><input key=customControlBackgroundOpacity dependencies=customControlBackground spellcheck=false type=text></label></li><li class="indent-0 folded"data-indent=0 data-key=removeVideoTopMask data-dependencies=""><label class=gui-settings-checkbox-container><input key=removeVideoTopMask type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=hideOldEntry data-dependencies=""><label class=gui-settings-checkbox-container><input key=hideOldEntry type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=hideBangumiReviews data-dependencies=""><label class=gui-settings-checkbox-container><input key=hideBangumiReviews type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=hideBangumiSponsors data-dependencies=""><label class=gui-settings-checkbox-container><input key=hideBangumiSponsors type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=hideRecommendLive data-dependencies=""><label class=gui-settings-checkbox-container><input key=hideRecommendLive type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=hideRelatedVideos data-dependencies=""><label class=gui-settings-checkbox-container><input key=hideRelatedVideos type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=hideCategory data-dependencies=""><label class=gui-settings-checkbox-container><input key=hideCategory type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-center category folded"><i class=icon-activity style=margin-right:8px></i><span class=settings-category>动态</span><i class=icon-arrow style=margin-left:8px></i></li><li class="indent-0 folded"data-indent=0 data-key=activityImageSaver data-dependencies=""><label class=gui-settings-checkbox-container><input key=activityImageSaver type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=foldComment data-dependencies=""><label class=gui-settings-checkbox-container><input key=foldComment type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=fullTweetsTitle data-dependencies=""><label class=gui-settings-checkbox-container><input key=fullTweetsTitle type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=fullActivityContent data-dependencies=""><label class=gui-settings-checkbox-container><input key=fullActivityContent type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=feedsFilter data-dependencies=""><label class=gui-settings-checkbox-container><input key=feedsFilter type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=feedsTranslate data-dependencies=""><label class=gui-settings-checkbox-container><input key=feedsTranslate type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-1 folded"data-indent=1 data-key=feedsTranslateProvider data-dependencies=feedsTranslate><label class=gui-settings-dropdown-container><span class=gui-settings-dropdown-span></span><div class="gui-settings-dropdown popup"><input readonly=readonly type=text spellcheck=false key=feedsTranslateProvider dependencies=feedsTranslate><ul></ul><i class=icon-arrow></i></div></label></li><li class="indent-center category folded"><i class=icon-video-outline style=margin-right:8px></i><span class=settings-category>直播</span><i class=icon-arrow style=margin-left:8px></i></li><li class="indent-0 folded"data-indent=0 data-key=useDefaultLiveQuality data-dependencies=""><label class=gui-settings-checkbox-container><input key=useDefaultLiveQuality type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-1 folded"data-indent=1 data-key=defaultLiveQuality data-dependencies=useDefaultLiveQuality><label class=gui-settings-dropdown-container><span class=gui-settings-dropdown-span></span><div class="gui-settings-dropdown popup"><input readonly=readonly type=text spellcheck=false key=defaultLiveQuality dependencies=useDefaultLiveQuality><ul></ul><i class=icon-arrow></i></div></label></li><li class="indent-0 folded"data-indent=0 data-key=simplifyLiveroom data-dependencies=""><label class=gui-settings-checkbox-container><input key=simplifyLiveroom type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=harunaScale data-dependencies=""><label class=gui-settings-checkbox-container><input key=harunaScale type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=collapseLiveSideBar data-dependencies=""><label class=gui-settings-checkbox-container><input key=collapseLiveSideBar type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=removeLiveWatermark data-dependencies=""><label class=gui-settings-checkbox-container><input key=removeLiveWatermark type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=noLiveAutoplay data-dependencies=""><label class=gui-settings-checkbox-container><input key=noLiveAutoplay type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-1 folded"data-indent=1 data-key=hideHomeLive data-dependencies=noLiveAutoplay><label class=gui-settings-checkbox-container><input key=hideHomeLive type=checkbox dependencies=noLiveAutoplay checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=autoDraw data-dependencies=""><label class=gui-settings-checkbox-container><input key=autoDraw type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=autoMatchMedal data-dependencies=""><label class=gui-settings-checkbox-container><input key=autoMatchMedal type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=recordLiveDanmaku data-dependencies=""><label class=gui-settings-checkbox-container><input key=recordLiveDanmaku type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-center category folded"><i class=icon-tool style=margin-right:8px></i><span class=settings-category>工具</span><i class=icon-arrow style=margin-left:8px></i></li><li class="indent-0 folded"data-indent=0 data-key=removeAds data-dependencies=""><label class=gui-settings-checkbox-container><input key=removeAds type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-1 folded"data-indent=1 data-key=showBlockedAdsTip data-dependencies=removeAds><label class=gui-settings-checkbox-container><input key=showBlockedAdsTip type=checkbox dependencies=removeAds checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-1 folded"data-indent=1 data-key=removeGameMatchModule data-dependencies=removeAds><label class=gui-settings-checkbox-container><input key=removeGameMatchModule type=checkbox dependencies=removeAds checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-1 folded"data-indent=1 data-key=preserveEventBanner data-dependencies=removeAds><label class=gui-settings-checkbox-container><input key=preserveEventBanner type=checkbox dependencies=removeAds checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=watchLaterRedirect data-dependencies=""><label class=gui-settings-checkbox-container><input key=watchLaterRedirect type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=favoritesRedirect data-dependencies=""><label class=gui-settings-checkbox-container><input key=favoritesRedirect type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=hideTopSearch data-dependencies=""><label class=gui-settings-checkbox-container><input key=hideTopSearch type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=fullPageTitle data-dependencies=""><label class=gui-settings-checkbox-container><input key=fullPageTitle type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=biliplusRedirect data-dependencies=""><label class=gui-settings-checkbox-container><input key=biliplusRedirect type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=imageResolution data-dependencies=""><label class=gui-settings-checkbox-container><input key=imageResolution type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=i18n data-dependencies=""><label class=gui-settings-checkbox-container><input key=i18n type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-1 folded"data-indent=1 data-key=i18nLanguage data-dependencies=i18n><label class=gui-settings-dropdown-container><span class=gui-settings-dropdown-span></span><div class="gui-settings-dropdown popup"><input readonly=readonly type=text spellcheck=false key=i18nLanguage dependencies=i18n><ul></ul><i class=icon-arrow></i></div></label></li><li class="indent-0 folded"data-indent=0 data-key=seedsToCoins data-dependencies=""><label class=gui-settings-checkbox-container><input key=seedsToCoins type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=selectableColumnText data-dependencies=""><label class=gui-settings-checkbox-container><input key=selectableColumnText type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=urlParamsClean data-dependencies=""><label class=gui-settings-checkbox-container><input key=urlParamsClean type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-center category folded"><i class=icon-touch style=margin-right:8px></i><span class=settings-category>触摸</span><i class=icon-arrow style=margin-left:8px></i></li><li class="indent-0 folded"data-indent=0 data-key=touchNavBar data-dependencies=""><label class=gui-settings-checkbox-container><input key=touchNavBar type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=comboLike data-dependencies=""><label class=gui-settings-checkbox-container><input key=comboLike type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=touchVideoPlayer data-dependencies=""><label class=gui-settings-checkbox-container><input key=touchVideoPlayer type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-1 folded"data-indent=1 data-key=touchVideoPlayerDoubleTapControl data-dependencies=touchVideoPlayer><label class=gui-settings-checkbox-container><input key=touchVideoPlayerDoubleTapControl type=checkbox dependencies=touchVideoPlayer checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=miniPlayerTouchMove data-dependencies=""><label class=gui-settings-checkbox-container><input key=miniPlayerTouchMove type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-center category folded"><i class=icon-other style=margin-right:8px></i><span class=settings-category>其他</span><i class=icon-arrow style=margin-left:8px></i></li><li class="indent-0 folded"data-indent=0 data-key=toast data-dependencies=""><label class=gui-settings-checkbox-container><input key=toast type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-1 folded"data-indent=1 data-key=toastInternalError data-dependencies=toast><label class=gui-settings-checkbox-container><input key=toastInternalError type=checkbox dependencies=toast checked=checked><div class=gui-settings-checkbox></div><span></span></label></li><li class="indent-0 folded"data-indent=0 data-key=filenameFormat data-dependencies=""><label class=gui-settings-textbox-container><span></span><input key=filenameFormat dependencies=""spellcheck=false type=text></label></li><li class="indent-0 folded"data-indent=0 data-key=batchFilenameFormat data-dependencies=""><label class=gui-settings-textbox-container><span></span><input key=batchFilenameFormat dependencies=""spellcheck=false type=text></label></li><li class="indent-0 folded"data-indent=0 data-key=scriptLoadingMode data-dependencies=""><label class=gui-settings-dropdown-container><span class=gui-settings-dropdown-span></span><div class="gui-settings-dropdown popup"><input readonly=readonly type=text spellcheck=false key=scriptLoadingMode dependencies=""><ul></ul><i class=icon-arrow></i></div></label></li><li class="indent-0 folded"data-indent=0 data-key=guiSettingsDockSide data-dependencies=""><label class=gui-settings-dropdown-container><span class=gui-settings-dropdown-span></span><div class="gui-settings-dropdown popup"><input readonly=readonly type=text spellcheck=false key=guiSettingsDockSide dependencies=""><ul></ul><i class=icon-arrow></i></div></label></li><li class="indent-0 folded"data-indent=0 data-key=sideBarOffset data-dependencies=""><label class=gui-settings-textbox-container><span></span><input key=sideBarOffset dependencies=""spellcheck=false type=text></label></li><li class="indent-0 folded"data-indent=0 data-key=ajaxHook data-dependencies=""><label class=gui-settings-checkbox-container><input key=ajaxHook type=checkbox dependencies=""checked=checked><div class=gui-settings-checkbox></div><span></span></label></li></ul></div><div class=gui-settings-tooltip></div></div>`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/gui-settings.min.js"] = (()=>{return(e,t)=>{const{ThemeColors:n}=t.import("theme-colors");const{SettingsSearch:i}=t.import("settings-search");const{Validator:s}=t.import("text-validate");let o=[];let c=[];let a=[];function r(e){let t=e.nextElementSibling;const n=[];while(t!==null&&!t.classList.contains("category")){n.push(t);t=t.nextElementSibling}return n}function l(){a.forEach(t=>t.value=e[t.getAttribute("key")]);c.forEach(t=>t.checked=e[t.getAttribute("key")])}function d(){document.querySelector(".gui-settings-mask").addEventListener("click",()=>{document.querySelectorAll(".gui-settings-widgets-box,.gui-settings-box,.gui-settings-mask,.bilibili-evolved-about").forEach(e=>e.classList.remove("opened"))});a.forEach(t=>{t.setAttribute("placeholder",e[t.getAttribute("key")])});document.querySelectorAll(".gui-settings-content ul li.category").forEach(e=>{e.addEventListener("click",e=>{const t=document.querySelector(".gui-settings-search");if(t.value!==""){t.value="";raiseEvent(t,"input")}e.currentTarget.classList.toggle("folded");r(e.currentTarget).forEach(e=>e.classList.toggle("folded"))})});document.querySelectorAll(".gui-settings-dropdown>input").forEach(e=>{e.addEventListener("click",e=>{e.currentTarget.parentElement.classList.toggle("opened")})});dqa(".gui-settings-header .operation").forEach(t=>{t.addEventListener("click",t=>{if(t.target.classList.contains("export")){const t=document.createElement("a");t.style.display="none";const n=URL.createObjectURL(new Blob([JSON.stringify(_.omit(e,"cache"))]));t.href=n;t.download="bilibili-evolved-settings.json";document.body.insertAdjacentElement("beforeend",t);t.click();URL.revokeObjectURL(n);t.remove()}else if(t.target.classList.contains("import")){const t=document.createElement("input");t.style.display="none";t.type="file";t.accept=".json,text/json";document.body.insertAdjacentElement("beforeend",t);t.addEventListener("change",async()=>{try{const n=t.files[0];const i=JSON.parse(await new Response(n).text());for(const[t,n]of Object.entries(i)){if(t in e&&t!=="cache"){e[t]=n}}Toast.success("已成功导入设置, 部分设置需要刷新后生效.","导入设置",3e3)}catch(e){Toast.error("选择的设置文件无效.","导入设置",3e3)}finally{t.remove()}},{once:true});t.click()}})})}function u(){c.forEach(t=>{t.addEventListener("change",()=>{const n=t.getAttribute("key");const i=t.checked;e[n]=i})});a.forEach(t=>{t.addEventListener("change",()=>{const n=t.getAttribute("key");const i=s.getValidator(n).validate(t.value);e[n]=i;t.value=i})})}function g(){const e=o.map(e=>[e.getAttribute("dependencies").split(" ").map(e=>o.find(t=>t.getAttribute("key")===e)),e]);const t=e=>e.nodeName.toUpperCase()==="LI"?e:t(e.parentElement);e.forEach(([e,n])=>{if(e[0]===undefined){return}const i=()=>{if(e.every(e=>e.checked)){t(n).classList.remove("disabled")}else{t(n).classList.add("disabled")}};e.forEach(e=>e.addEventListener("change",i));i()})}function f(){if(typeof offlineData!=="undefined"){}}function m(){if(window.devicePixelRatio===1){o.find(e=>e.getAttribute("key")==="harunaScale").disabled=true;o.find(e=>e.getAttribute("key")==="imageResolution").disabled=true;e.harunaScale=false;e.imageResolution=false}}function y(){for(const[e,t]of Object.entries(Resource.displayNames)){const n=o.find(t=>t.getAttribute("key")===e);if(!n){continue}switch(n.type){case"checkbox":n.nextElementSibling.nextElementSibling.innerHTML=t;break;case"text":const e=n.parentElement;if(e.classList.contains("gui-settings-textbox-container")){n.previousElementSibling.innerHTML=t}else if(e.classList.contains("gui-settings-dropdown")){e.previousElementSibling.innerHTML=t}break;default:break}}}(async()=>{t.applyStyle("guiSettingsStyle");t.applyImportantStyle("iconsStyle");document.body.classList.add("round-corner");const s=document.body&&unsafeWindow.parent.window!==unsafeWindow;if(s){document.querySelector(".gui-settings-icon-panel").style.display="none"}if(e.guiSettingsDockSide==="右侧"){document.body.classList.add("gui-settings-dock-right")}const r=t.data.guiSettingsHtml.text;document.body.insertAdjacentHTML("beforeend",r);const{style:p}=await t.importAsync("mdi");if(!p){document.body.insertAdjacentHTML("afterbegin",`<link rel="stylesheet" href="//cdn.materialdesignicons.com/3.6.95/css/materialdesignicons.min.css">`)}const b=document.querySelector(".widgets-container");const h=b.querySelector(".empty-tip");Observer.childList(b,()=>{if(b.childElementCount<=1){h.classList.add("show")}else{h.classList.remove("show")}});const E=document.querySelectorAll(".gui-settings-widgets-box,.gui-settings-box");const L=document.querySelector(".gui-settings-icon-panel");L.addEventListener("mouseover",async()=>{const{loadTooltip:e}=await t.importAsync("settings-tooltip.loader");await e();await t.applyDropdownOptions();t.applyWidgets();raiseEvent(L,"be:load");const s=dq(".bilibili-evolved-about");if(s){raiseEvent(s,"be:about-load")}(new n).setupDom();E.forEach(e=>e.classList.add("loaded"));o=[...document.querySelectorAll("input[key]")];c=o.filter(e=>e.type==="checkbox");a=o.filter(e=>e.type==="text"&&!e.parentElement.classList.contains("gui-settings-dropdown"));d();f();l();g();u();m();y();addSettingsListener("guiSettingsDockSide",e=>{document.body.classList.toggle("gui-settings-dock-right",e==="右侧")});new i},{once:true})})()}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/haruna-scale.min.js"] = (()=>{return(n,e)=>{const t="haruna-scale";const a=()=>{if(document.getElementById(t)===null){e.applyStyleFromText(`\n      .haruna-ctnr,\n      .avatar-btn\n      {\n        transform: scale(${1/window.devicePixelRatio}) !important;\n      }\n`,t)}};a();return{reload:a,unload:()=>{const n=document.getElementById(t);n&&n.remove()}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/hide-bangumi-reviews.min.js"] = (()=>{return(e,n)=>{return n.toggleStyle(`\n  #review_module { display: none !important; }\n`,`hide-bangumi-reviews-style`)}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/hide-bangumi-sponsors.min.js"] = (()=>{return(n,e)=>{return e.toggleStyle(`\n  #sponsor_module, #paybar_module { display: none !important; }\n`,`hide-bangumi-sponsors-style`)}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/hide-banner.min.css"] = `#banner_link,.custom-navbar .blur-layer,.z-top-container.has-banner>.header{display:none!important}.b-header-mask-wrp .b-header-mask-bg,div.blur-bg{opacity:0!important}.international-header .bili-banner,.international-home .bili-banner{visibility:hidden!important;height:50px!important;min-height:unset!important}`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/hide-banner.min.js"] = (()=>{return(e,l)=>{const r="hideBannerStyle";l.applyStyle(r);return{reload:()=>l.applyStyle(r),unload:()=>l.removeStyle(r)}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/hide-category.min.css"] = `.bili-header-m>.bili-wrapper{visibility:hidden!important;height:18px!important}.primary-menu-itnl{visibility:hidden!important;height:24px!important;padding:0!important}`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/hide-category.min.js"] = (()=>{return(e,t)=>{return t.toggleStyle("hideCategoryStyle")}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/hide-hash-tags.min.js"] = (()=>{return(t,e)=>{if(document.URL.replace(location.search,"")!=="https://t.bilibili.com/"){return}const n=`.left-panel .tag-panel,.right-panel .tag-panel{display: none !important}`;const a="hideHashTagsStyle";return e.toggleStyle(n,a)}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/hide-old-entry.min.js"] = (()=>{return(t,e)=>{const n=`#entryOld, .main-container .entry-old, .try-feedback, .try-feedback ~ .contact-help, .elevator .list-box .item.back-old { display: none !important; }`;const o="hide-old-entry-style";return e.toggleStyle(n,o)}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/hide-recommend-live.min.js"] = (()=>{return(e,t)=>{addSettingsListener("hideRelatedVideos",async e=>{const{fillWithComments:n}=await t.importAsync("fill-with-comments");n(e)},true);return t.toggleStyle(`\n  #live_recommand_report, #live_recommend_report { display: none !important; }\n`,`hide-recommend-live-style`)}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/hide-related-videos.min.js"] = (()=>{return(i,n)=>{addSettingsListener("hideRecommendLive",async i=>{const{fillWithComments:e}=await n.importAsync("fill-with-comments");e(i)},true);return n.toggleStyle(`\n  #recom_module,#reco_list,.bilibili-player-ending-panel-box-videos {\n    display: none !important;\n  }\n  .bilibili-player-ending-panel-box-functions .bilibili-player-upinfo-spans {\n    position: static !important;\n  }\n  .bilibili-player-ending-panel-box {\n    display: flex !important;\n    justify-content: center !important;\n    flex-direction: column !important;\n  }\n`,`hide-related-videos-style`)}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/hide-top-search.min.js"] = (()=>{return(e,r)=>{const t=[".nav-search-keyword",".search-keyword"];for(const e of t){new SpinQuery(()=>$(e),e=>e!==undefined&&e.length>0&&e.attr("placeholder").length>0,e=>e.attr("placeholder","搜索")).start()}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/home-video.vue.min.js"] = (()=>{return(i,e)=>{const a=`<div class=home-video><div class=loading v-if=loading><i class="mdi mdi-18px mdi-loading mdi-spin"></i>加载中...</div><div class=cards v-else-if=cards.length><video-card v-for="card of cards":key=card.id :data=card></video-card></div><div class=empty v-else>空空如也哦 =￣ω￣=</div></div>`;e.applyStyleFromText(`.home-video .loading{height:48px;display:flex;align-items:center;justify-content:center;font-size:11pt;color:#707070}.home-video .loading .mdi{margin-right:8px}body.dark .home-video .loading{color:#eee}.home-video .cards{display:flex;flex-wrap:wrap;align-items:center}`,"home-video-style");return{export:Object.assign({template:a},{components:{VideoCard:()=>e.importAsync("video-card.vue")},data(){return{cards:[],loading:true}},async mounted(){try{const i=await Ajax.getJsonWithCredentials(`https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=${getUID()}&type_list=8`);const{getWatchlaterList:a}=await e.importAsync("watchlater-api");const t=await a();if(i.code!==0){throw new Error(i.message)}this.cards=i.data.cards.map(i=>{const e=JSON.parse(i.card);const a=_.get(i,"display.topic_info.topic_details",[]).map(i=>{return{id:i.topic_id,name:i.topic_name}});return{id:i.desc.dynamic_id_str,aid:e.aid,title:e.title,upID:i.desc.user_profile.info.uid,upName:i.desc.user_profile.info.uname,upFaceUrl:i.desc.user_profile.info.face,coverUrl:e.pic,description:e.desc,timestamp:i.timestamp,time:new Date(i.timestamp*1e3),topics:a,dynamic:e.dynamic,like:formatCount(i.desc.like),duration:e.duration,durationText:formatDuration(e.duration,0),playCount:formatCount(e.stat.view),danmakuCount:formatCount(e.stat.danmaku),watchlater:t.includes(e.aid)}})}catch(i){Toast.error(i.message,"视频动态",3e3)}finally{this.loading=false}}})}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/i18n.de-DE.min.js"] = (()=>{return(e,n)=>{const r=new Map([[`*`,[]]]);const t=new Map([]);return{export:{map:r,regex:t}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/i18n.en-US.min.js"] = (()=>{return(e,o)=>{const t=true;const i=new Map([[`主站`,`Home`],[`画友`,`Photos`],[`音频`,`Music`],[`游戏中心`,`Game`],[`会员购`,`Shop`],[`下载APP`,`App`],[`会员`,[`User`,{selector:`.ep-list-wrapper .ep-item .badge.pink`,text:`VIP`}]],[`大会员`,`VIP`],[`小会员`,`Reverse VIP`],[`未登录`,`Not logged in`],[`注册会员`,`Registered User`],[`正式会员`,`Formal User`],[`年度大会员`,`Annual VIP`],[`年度小会员`,`Annual Reverse VIP`],[`消息`,`Notifications`],[`动态`,`Feeds`],[`稍后再看`,`Watchlater`],[`收藏`,`Favorite`],[`更多`,`More`],[`排行`,`Ranking`],[`图片`,`Photo`],[`视频`,`Video`],[`音乐`,`Music`],[`时尚`,`Fashion`],[`电影`,`Movie`],[`影视`,`Film`],[`特摄`,`Tokusatsu`],[`学习`,`Study`],[`放映厅`,`Cinema`],[`广告`,`Ads`],[`广场`,`Plaza`],[`发布`,`Post`],[`举报`,`Report`],[`首页`,`Home`],[`热门`,`Trending`],[`周一`,`MON`],[`周二`,`TUE`],[`周三`,`WED`],[`周四`,`THU`],[`周五`,`FRI`],[`周六`,`SAT`],[`周日`,`SUN`],[`今天`,`Today`],[`昨天`,`Yesterday`],[`近1周`,`This week`],[`1周前`,`Past week`],[`发送`,`Send`],[`取消`,`Cancel`],[`关闭`,`Close`],[`表情`,`Sticker`],[`小视频`,`Mini video`],[`短视频`,`Mini video`],[`查看更多`,`More`],[`显示更多`,`More`],[`浏览更多`,`More`],[`查看全部`,`More`],[`所有关注`,`All followings`],[`进入专栏区`,`Columns`],[`暂时没有新动态了哦！`,`No new feeds yet.`],[`播放历史`,`History`],[`暂停记录历史`,`Pause recording history`],[`啊叻？你要暂停历史记录功能吗？`,`Do you really want to pause recording history?`],[`确定暂停`,`Yes`],[`清空历史`,`Clear history`],[`已看完`,`Completed`],[`一键清空`,`Clear all`],[`移除已观看视频`,`Clear watched`],[`即将删除所有已观看视频，此操作不可恢复。确定是否删除？`,`This will remove all watched videos and is unrecoverable, do you want to continue?`],[`清空确认`,`Clear Confirm`],[`确定要清空你的稍后再看列表吗？`,`Clear the entire watchlater list?`],[`已观看`,`Watched`],[`删除`,`Delete`],[`确认`,`Yes`],[`添加`,`Add`],[`取消关注`,`Unfollow`],[`全部`,`All`],[`投稿视频`,`Posted video`],[`公告栏`,`Notice`],[`正在直播`,`Live broadcasting`],[`虚拟主播`,`Vtuber`],[`房间标题`,`Title`],[`设置`,`Settings`],[`频道`,`Channel`],[`标签`,`Tag`],[`关注`,`Follow`],[`关注数`,`Following`],[`粉丝`,`Follower`],[`粉丝数`,`Followers`],[`阅读数`,`Read`],[`阅读量`,`Read`],[`相簿`,`Photos`],[`我的频道`,`My Channel`],[`我的视频`,`My Video`],[`我的音频`,`My Audio`],[`我的音乐`,`My Music`],[`我的专栏`,`My Column`],[`我的相簿`,`My Photos`],[`我的关注`,`My Followings`],[`我的粉丝`,`My Follwers`],[`我的消息`,`My Messages`],[`我的收藏`,`My Favorites`],[`我的订阅`,`My Subscribes`],[`系统通知`,`System`],[`网游`,`Online`],[`手游`,`Mobile`],[`单机`,`Console`],[`电台`,`Radio`],[`绘画`,`Drawing`],[`投稿`,`Upload`],[`热门话题`,`Trending #Tags#`],[`人气排行`,`Trending`],[`我关注的话题`,`Following #Tags#`],[`前往TA的直播间`,`Open live room`],[`今天你想了解什么呢？(☆▽☆)`,`Search ~~~ (☆▽☆)`],[`请输入弹幕 DA☆ZE～`,`Enter your danmaku DA☆ZE～`],[`有什么想和大家分享的？`,`What's happening?`],[`有新动态，点击查看`,`New feeds, click to view`],[`以上为热门评论，`,`Aboves are hot comments`],[`请自觉遵守互联网相关的政策法规，严禁发布色情、暴力、反动的言论。`,`Post your comments ε=ε=(ノ≧∇≦)ノ`],[`点击查看`,`Click to view`],[`刚刚`,`Just now`],[`转发动态`,`Repost`],[`分享动态`,`Share`],[`转发`,`Repost`],[`赞`,`Like`],[`好评`,`Like`],[`支持一下`,`Like`],[`重播`,`Replay`],[`投币`,`Coin`],[`同时点赞内容`,`Like as well`],[`添加到收藏夹`,`Add to favorites`],[`投稿了`,`Posted`],[`动态首页`,`Feeds Home`],[`历史动态`,`Feeds History`],[`活动作品`,`Event`],[`未经作者授权，禁止转载`,`Please do not repost or reproduce without prior permission`],[`上一帧`,`Previous Frame`],[`下一帧`,`Next Frame`],[`人正在看`,`watching`],[`条实时弹幕`,`danmakus`],[`开启弹幕`,`Turn on danmakus`],[`显示弹幕`,`Show danmakus`],[`关闭弹幕`,`Turn off danmakus`],[`隐藏弹幕`,`Hide danmakus`],[`发个友善的弹幕见证当下`,`Enter your danmaku`],[`发个弹幕见证当下`,`Enter your danmaku`],[`弹幕礼仪`,`Guidelines`],[`追番`,[`Subscribe`,{selector:`.subscriptions-tabs .tab`,text:`Bangumi`},{selector:`.tab-bar .tab-text`,text:`Subscriptions`}]],[`已追番`,`Subscribed`],[`取消追番`,`Unsubscribe`],[`追剧`,[`Subscribe`,{selector:`.subscriptions-tabs .tab`,text:`Shows`}]],[`已追剧`,`Subscribed`],[`取消追剧`,`Unsubscribe`],[`取消订阅`,`Unsubscribe`],[`用手机观看`,`Mobile`],[`用手机看`,`Mobile`],[`弹幕列表`,`Danmaku List`],[`左舷弹幕太薄了，大家快来吐槽吧~`,`Danmaku list is empty. Be the first danmaku sender!`],[`屏蔽设定`,`Block Settings`],[`屏蔽列表`,`Block List`],[`高级弹幕`,`Special Danmaku`],[`时间`,`Time`],[`弹幕内容 (`,`Content ( `],[`发送时间`,`Time`],[`已屏蔽`,`Blocked`],[`查看历史弹幕`,`Danmaku history`],[`相关视频推荐`,`Related videos`],[`相关推荐`,`Related`],[`点评`,`Reviews`],[`评论`,`Comments`],[`新番时间表`,`Timetable`],[`小黑屋`,`Judge`],[`摄影`,`Photography`],[`插画`,`Illustration`],[`其他`,`Other`],[`下载`,`Download`],[`更新了`,`Updated`],[`排行榜`,`Ranking`],[`推荐`,`Recommended`],[`播放`,`Play`],[`播放数量`,`Plays`],[`暂停`,`Pause`],[`静音`,`Mute`],[`弹幕`,`Danmaku`],[`硬币`,`Coin`],[`宽屏模式`,`Widescreen`],[`退出宽屏`,`Exit widescreen`],[`退出网页全屏`,`Exit web fullscreen`],[`退出全屏`,`Exit fullscreen`],[`进入全屏`,`Fullscreen`],[`全屏模式`,`Fullscreen`],[`打开洗脑循环`,`Turn on loop`],[`观看人数`,`Viewers`],[`转载`,`Reproduction`],[`展开`,`Expand`],[`收起`,`Fold`],[`展开全部`,`Expand`],[`展开全文`,`Expand`],[`收起全文`,`Fold`],[`已结束`,`Ended`],[`电视剧`,`Drama`],[`上一页`,`Previous`],[`下一页`,`Next`],[`搜索`,`Search`],[`直播中`,`Live boradcasting`],[`等级`,`Level`],[`个人中心`,`Profile`],[`创作中心`,`Creations`],[`直播中心`,`Live center`],[`订单中心`,`Orders`],[`B币钱包`,`Bili Wallet`],[`B币`,`Bili Coin`],[`主页`,`Home`],[`排序`,`Sort`],[`移除`,`Remove`],[`复制`,`Copy`],[`换一换`,`Refresh`],[`特别推荐`,`Recommended`],[`热门榜单`,`Hits`],[`播放全部`,`Play all`],[`自动播放`,`Auto play`],[`观看历史`,`History`],[`个人收益`,`Personal income`],[`同时转发到我的动态`,`Repost to my feeds`],[`人气值`,`Popularity`],[`友爱社`,`Club`],[`话题`,`#Tags#`],[`专题`,`Topics`],[`活动`,`Event`],[`活动中心`,`Event center`],[`消息中心`,`Messages`],[`专栏投稿`,`Post column`],[`音频投稿`,`Post audio`],[`视频投稿`,`Post video`],[`相簿投稿`,`Post photo`],[`上传视频`,`Upload`],[`退出登录`,`Log out`],[`回复我的`,`Reply`],[`TA 的直播间`,`Live room`],[`TA 的小视频`,`Mini videos`],[`TA的视频`,`Videos`],[`TA的音频`,`Audios`],[`TA的专栏`,`Columns`],[`TA的频道`,`Channels`],[`TA的订阅`,`Subscriptions`],[`TA的收藏夹`,`Favorites`],[`邮箱验证`,`Email verification`],[`手机验证`,`Phone verification`],[`领取`,`Collect`],[`确定`,`OK`],[`公开`,`Public`],[`隐藏`,`Private`],[`搜索设置项`,`Search settings`],[`样式`,`Style`],[`工具`,`Tools`],[`触摸`,`Touch`],[`指定播放器布局`,`Player layout`],[`视频区布局`,`Video`],[`番剧区布局`,`Bangumi`],[`使用默认播放器模式`,`Default player mode`],[`默认播放器模式`,`Mode`],[`播放时应用模式`,`Apply on playing`],[`播放时自动关灯`,`Turn off light when playing`],[`使用默认视频画质`,`Default video quality`],[`画质设定`,`Quality`],[`使用默认弹幕设置`,`Default danmaku settings`],[`记住弹幕设置`,`Remember danmaku settings`],[`自动展开弹幕列表`,`Auto expand danmaku list`],[`自动展开视频简介`,`Auto expand video description`],[`自动从历史记录点播放`,`Auto continue by history`],[`允许跨集跳转`,`Allow jump across episodes`],[`自动播放视频`,`Auto play video`],[`跳过充电鸣谢`,`Skip charge acknowledgements`],[`启用逐帧调整`,`Enable seek by frame`],[`启用视频截图`,`Enable video screenshots`],[`自动定位到播放器`,`Auto locate player`],[`定位偏移量`,`Locate offset`],[`外置稍后再看`,`Outside watchlater`],[`主题颜色`,`Theme color`],[`使用自定义顶栏`,`Custom navbar`],[`主题色填充`,`Fill with theme color`],[`填充其他顶栏`,`Also fill other navbars`],[`紧凑布局`,`Compact layout`],[`背景模糊`,`Background blur`],[`夜间模式`,`Dark mode`],[`夜间模式计划时段`,`Dark mode schedule`],[`起始时间`,`From`],[`结束时间`,`To`],[`首页使用紧凑布局`,`Compact layout for homepage`],[`简化评论区`,`Simplify comments`],[`简化直播间`,`Simplify live room`],[`隐藏顶部横幅`,`Hide top banner`],[`播放器投影`,`Drop shadow for player`],[`强制保留弹幕栏`,`Force preserve danmaku input`],[`模糊视频控制栏背景`,`Background blur for video controls`],[`控制栏着色`,`Fill video controls`],[`不透明度`,`Opacity`],[`缩放直播看板娘`,`DPI-ware live room showgirl`],[`删除直播水印`,`Remove live watermark`],[`删除视频标题层`,`Remove video top mask`],[`隐藏返回旧版`,`Hide "Back to old"`],[`隐藏番剧点评`,`Hide bangumi reviews`],[`删除广告`,`Remove ads`],[`稍后再看重定向`,`Watchlater redirect`],[`收藏夹视频重定向`,`Favorites redirect`],[`隐藏搜索推荐`,`Hide search recommendation`],[`展开动态标题`,`Expand title in feeds`],[`展开选集列表`,`Expand episode list`],[`BiliPlus跳转支持`,`BiliPlus support`],[`高分辨率图片`,`DPI-aware images`],[`旧版动态跳转支持`,`Old feeds support`],[`界面翻译`,`UI translation`],[`语言`,`Language`],[`顶栏触摸优化`,`Touch support for navbar`],[`素质三连触摸支持`,`Touch support for combo like`],[`播放器触摸支持`,`Touch support for player`],[`启用实验性动画效果`,`Experimental animations`],[`启用双击控制`,`Enable double-tap control`],[`显示消息`,`Show toasts`],[`显示内部错误消息`,`Show internal errors`],[`新版本`,`New version`],[`已发布.`,`is available.`],[`安装`,`Install`],[`查看`,`Details`],[`检查更新`,`Check for updates`],[`安装更新`,`Install update`],[`查看更新`,`View update`],[`启用缓存`,`Enable cache`],[`附加功能`,`Add-ons`],[`清除缓存`,`Clear cache`],[`转到BiliPlus`,`Jump to BiliPlus`],[`顶栏布局`,`Navbar layout`],[`搜索框`,`Search box`],[`用户信息`,`User profile`],[`投稿入口`,`Post entrance`],[`转到新版`,`Jump to new version`],[`回到旧版`,`Jump to old verison`],[`查看封面`,`View cover`],[`复制原链接`,`Copy link`],[`在新标签页打开`,`Open in new tab`],[`下载弹幕`,`Download danmaku`],[`下载视频`,`Download video`],[`下载音频`,`Download audio`],[`更换勋章`,`Change badge`],[`更换头衔`,`Change title`],[`关于`,`About`],[`动画`,`Anime`],[`舞蹈`,`Dance`],[`国创`,`China`],[`科技`,`Tech`],[`生活`,`Life`],[`鬼畜`,`Kichiku`],[`专栏`,`Column`],[`游戏`,`Game`],[`直播`,`Live`],[`数码`,`Digital`],[`TV剧`,`TV`],[`番剧`,[`Bangumi`,{selector:`.elevator-module .nav-list .item`,text:`Bangu`}]],[`纪录片`,[`Documentary`,{selector:`.elevator-module .nav-list .item`,text:`Doc`}]],[`娱乐`,[`Entertainment`,{selector:`.primary-menu .nav-menu li .nav-name, .elevator-module .nav-list .item`,text:`Entmt`}]],[`自动`,`Auto`],[`常规`,`Normal`],[`宽屏`,`Widescreen`],[`网页全屏`,`Web fullscreen`],[`全屏`,`Fullscreen`],[`历史`,`History`],[`登录`,`Log in`],[`注册`,`Sign up`],[`我的直播间`,`My live room`],[`直播间`,`Live room`],[`订阅`,[`Subscribe`,{selector:`.main-content`,text:`Subscriptions`}]],[`主站空间`,`My space`],[`播放数`,`Plays`],[`综合`,`General`],[`用户`,`User`],[`投稿管理`,`Posts`],[`个人信息`,`Profiles`],[`开播设置`,`Live settings`],[`直播分类：`,`Live type`],[`修改分区`,`Edit category`],[`房间标题：`,`Live title`],[`开始直播`,`Start live`],[`关闭直播`,`Stop live`],[`主播公告`,`Host notice`],[`简介`,`Description`],[`直播封面`,`Live cover`],[`我的个人标签`,`My tags`],[`个人简介`,`Bio`],[`直播间信息`,`Live room info`],[`我的船员`,`My sailor`],[`直播数据`,`Live data`],[`数据总览`,`Overall stats`],[`直播时长`,`Total time`],[`最高人气值`,`Max popularity`],[`直播收益(金仓鼠)`,`Live income (Golden hamster)`],[`直播收益`,`Live income`],[`新增关注数`,`New subscribes`],[`人均观看时长`,`Avg watch time`],[`礼物流水`,`Gifts`],[`礼物统计`,`Gift stats`],[`消费排行`,`Consumption ranking`],[`更多>>`,`More>>`],[`主播`,`Host`],[`未开播`,`Idle`],[`金瓜子`,`Golden seeds`],[`银瓜子`,`Silver seeds`],[`残忍取关`,`Unfollow`],[`再考虑一下`,`Cancel`],[`已关注`,`Following`],[`七日榜`,`Rank`],[`舰队`,`Fleet`],[`房管`,`Manager`],[`粉丝榜`,`Follower`],[`分享`,`Share`],[`轮播`,`Slideshow`],[`闲置`,`Idle`],[`回复`,`Reply`],[`查看更多评论`,`View more comments`],[`英雄联盟`,`LOL`],[`APEX英雄`,`Apex Legends`],[`守望先锋`,`Overwatch`],[`绝地求生`,`PUBG`],[`王者荣耀`,`Arena Of Valor`],[`第五人格`,`Identity V`],[`绝地求生:刺激战场`,`PUBG Mobile`],[`崩坏3`,`Houkai 3rd`],[`主机游戏`,`Console games`],[`我的世界`,`MC`],[`怪物猎人:世界`,`Monster Hunter: World`],[`只狼：影逝二度`,`Sekiro: Shadows Die Twice`],[`鬼泣5`,`Devil May Cry 5`],[`视频唱见`,`Singer`],[`舞见`,`Dancer`],[`视频聊天`,`Chat`],[`才艺`,`Talent show`],[`唱见电台`,`Singer radio`],[`声优`,`CV`],[`聊天电台`,`Chat radio`],[`同人绘画`,`Doujin`],[`原创绘画`,`Original`],[`临摹绘画`,` Copy`],[`其他绘画`,`Other`],[`扭蛋机`,`Capsule machine`],[`我关注的直播`,`Following lives`],[`我关注的动态`,`Following feeds`],[`按热度排序`,`By likes`],[`按时间排序`,`By time`],[`全部评论`,`All comments`],[`发消息`,`Send message`],[`点赞`,`Like`],[`发表评论`,`Comment`],[`你的rtmp地址：`,`Yout RTMP address: `],[`你的直播码：`,`Streaming code: `],[`颜值领域专属封面`,`顔出し用サムネ`],[`私信存档`,`Archive`],[`历史私信`,`Message History`],[`用户中心`,`User center`],[`我的信息`,`My messages`],[`领取奖励`,`Collect`],[`关注直播间`,`Follow`],[`加入黑名单`,`Block`],[`悄悄关注`,`Private follow`],[`个人信息举报`,`Report`],[`观众分析`,`Audience`],[`游客分析`,`Visitor`],[`粉丝分析`,`Follower`],[`游客基本属性`,`Basic properties of visitor`],[`性别占比`,`Gender ratio`],[`观众年龄`,`Ages`],[`观看途径`,`Approach`],[`消息设置`,`Settings`],[`消息提醒样式`,`Style`],[`（不含应援团）`,`（Support groups are not included）`],[`数字`,`Number`],[`收到的赞消息提醒`,`Likes`],[`（是否接收点赞消息通知）`,`（Config notifications of likes）`],[`始终提醒`,`Always notify`],[`永不提醒`,`Never notify`],[`回复我的消息提醒`,`Replies`],[`（接受谁的评论消息提醒）`,`（Config notifications of replies）`],[`所有人`,`From all people`],[`关注的人`,`Only from people that you follow`],[`不接受任何消息提醒`,`Never notify`],[`@我的消息提醒`,`@Mentions`],[`（接受谁的@消息提醒）`,`（Config notifications of @mentions）`],[`红点`,`Dot`],[`不提醒`,`Don't show`],[`推荐位申请`,`Apply for recommendation`],[`直播看板娘`,`Live showgirl`],[`收到的赞`,`Likes`],[`漫画`,`Manga`],[`投影`,`Drop shadow`],[`加载中...`,`Loading...`],[`模糊层不透明度`,`Opacity`],[`签到`,`Check-in`],[`新版`,[`New version`,{selector:`.gui-settings-dropdown-container *`,text:`New`}]],[`旧版`,[`Old version`,{selector:`.gui-settings-dropdown-container *`,text:`Old`}]],[`文件命名格式`,`Filename format`],[`发布动态`,`Post`],[`了解更多`,`Learn more`],[`编辑`,`Edit`],[`新闻公告`,`Notice`],[`全部直播`,`All`],[`游戏直播`,`Games`],[`网游直播`,`Online`],[`网络游戏`,`Online`],[`手游直播`,`Mobile`],[`手机游戏`,`Mobile`],[`单机游戏`,`Console`],[`娱乐直播`,`Entertainment`],[`电台直播`,`Radio`],[`绘画直播`,`Drawing`],[`哔考`,`Study`],[`进入直播间`,`Enter`],[`直播持续时间`,`Duration`],[`Ta还没有应援的友爱社喔 (ಥ_ಥ)`,`No fans club yet (ಥ_ಥ)`],[`参与创作了`,`Participated`],[`未经作者授权 禁止转载`,`Please do not reproduce without prior permission`],[`稿件投诉`,`Report`],[`充电`,`Charge`],[`为TA`,``],[`为TA充电`,`Charge`],[`充电设置`,`Charge settings`],[`移动`,`Move`],[`保护`,`Reserve`],[`忽略`,`Ignore`],[`该视频弹幕为空`,`No danmakus yet`],[`屏蔽设置`,`Block settings`],[`屏蔽用户`,`Block user`],[`屏蔽该弹幕的发送者`,`Block sender of this danmaku`],[`设为置顶`,`Stick on top`],[`取消置顶`,`Cancel sticking`],[`没有更多信息`,`No more messages available`],[`取消静音`,`Cancel mute`],[`展开更多`,`More`],[`搜索视频`,`Search for videos`],[`搜索音频`,`Search for audios`],[`搜索稿件`,`Search for works`],[`立即播放`,`Play now`],[`我的友爱社`,`My fans club`],[`新闻`,`News`],[`视频截图`,`Video screenshots`],[`截图`,`Take screenshot`],[`老爷图标`,`Live VIP Icon`],[`粉丝勋章`,`Fans Badge`],[`活动头衔`,`Event Title`],[`用户等级`,`User Level`],[`舰长图标`,`Captain Icon`],[`全区广播`,`Global Messages`],[`欢迎信息`,`Welcome Messages`],[`抽奖提示`,`Lucky Draw Popups`],[`房间皮肤`,`Room Skin`],[`复制链接`,`Copy Link`],[`投稿时间排序`,`Sort by time`],[`点击数排序`,`Sort by views`],[`评论数排序`,`Sort by comments`],[`收藏数排序`,`Sort by favorites`],[`弹幕数排序`,`Sort by danmakus`],[`首页管理`,`Home`],[`内容管理`,`Posts`],[`视频管理`,`Videos`],[`专栏管理`,`Columns`],[`音频管理`,`Audios`],[`相簿管理`,`Photos`],[`你还没有投过一个稿件("▔□▔)`,`You didn't post anything ("▔□▔)`],[`数据`,`Stat`],[`编辑稿件`,`Edit`],[`（单次最多允许上传100p视频，推荐采用mp4、flv格式，可有效缩短审核转码耗时）`,`(Up to 100 episodes per video, using mp4 or flv format can reduce encoding time)`],[`上传完成`,`Upload complete`],[`添加视频`,`Add video`],[`视频封面设置`,`Video cover`],[`（格式jpeg、png，文件大小≤5MB，建议尺寸≥1146*717，最低尺寸≥960*600）`,`(Format: jpeg / png, Size: ≤ 5MB, Recommended Resolution: ≥ 1146px*717px, Minimum Resolution: ≥ 960px*600px)`],[`类型`,`Type`],[`分区`,`Category`],[`全部分区`,`All categories`],[`热门分区`,`Trending categories`],[`标题`,`Title`],[`更多选项`,`Advanced`],[`定时发布`,`Schedule`],[`立即投稿`,`Post immediately`],[`分享投稿`,`Share post`],[`编辑记录`,`Edit history`],[`删除稿件`,`Delete`],[`数据中心`,`Stats`],[`粉丝管理`,`Followers`],[`互动管理`,`Interactions`],[`评论管理`,`Comments`],[`弹幕管理`,`Danmakus`],[`字幕管理`,`Subtitles`],[`收益管理`,`Earnings`],[`创作激励`,`Creative Rewards`],[`充电计划`,`Charge`],[`悬赏计划`,`Bounties`],[`任务成就`,`Achievements`],[`创作学院`,`Learn`],[`个人设置`,`Settings`],[`申诉管理`,`Appeal`],[`你的手机号/邮箱`,`Phone Number / Email`],[`密码`,`Password`],[`禁止直播首页自动播放`,`Disable live autoplay`],[`隐藏首页推荐直播`,`Hide recommended live rooms`],[`侧栏垂直偏移量`,`Side bar vertical offset`],[`合作视频`,`Collaboration`],[`礼物弹幕`,`Gift danmaku`],[`上舰提示`,`New captains`],[`隐藏分区栏`,`Hide category bar`],[`显示失效视频信息`,`Retrieve dead video info`],[`失效视频重定向`,`Redirect dead video`],[`信息来源`,`Info provider`],[`快速收起动态评论区`,`Quick fold comments`],[`收起评论`,`Close comments`],[`我的直播间地址`,`My live room address`],[`选择分类`,`Category`],[`必须选择分类才能开播`,`You can't start live broadcasting before select a category.`],[`使用默认播放速度`,`Default playback rate`],[`默认播放速度`,`Playback rate`],[`标记为 想看`,`Mark as "Want to watch"`],[`想看`,`Want to watch`],[`标记为 在看`,`Mark as "Watching"`],[`在看`,`Watching`],[`标记为 已看`,`Mark as "Watched"`],[`标记为 看过`,`Mark as "Watched"`],[`看过`,`Watched`],[`显示占位文本`,`Show placeholder text`],[`瓜子换硬币`,`Seeds to coins`],[`每天最多能兑换 1 个`,`You can only exchange up to 1 coin per day.`],[`单个视频`,`Single video`],[`获取大小中`,`Fetching size`],[`获取大小失败`,`Failed to fetch size`],[`预计大小:`,`Estimated size: `],[`警告: 过大的视频大小会在直接下载时占用大量内存, 并可能导致浏览器标签页崩溃. 请考虑降低清晰度或使用导出选项.`,`Warning: Videos in large size will cost a large number of RAM during Direct Download, even crash the browser tab. Please use lower quality or use Export.`],[`清晰度`,`Quality`],[`无`,`None`],[`直接下载`,`Direct Download`],[`开始`,`Start`],[`导出`,`Export`],[`导出aria2`,`Export to aria2`],[`复制vld数据`,`Copy vld data`],[`导出vld数据`,`Export vld data`],[`导出aria2 RPC`,`Export to aria2 RPC`],[`无法连接到RPC主机.`,`Could not connect to RPC host.`],[`aria2 RPC 配置`,`aria2 RPC config`],[`主机`,`Host`],[`端口`,`Port`],[`密钥`,`Secret Key`],[`路径`,`Path`],[`批量导出`,`Batch Export`],[`请至少选择1集或以上的数量!`,`Please select at least 1 episode!`],[`选集`,`Episodes`],[`全选`,`Select All`],[`全不选`,`Deselect All`],[`反选`,`Inverse Selection`],[`错误`,`Error`],[`请求遭到拒绝, 请检查您的密钥相关设置.`,`Connection refused, please check your Secret Key.`],[`明日方舟`,`Arknights`],[`直播歌曲内容不适宜请立即调整`,`Your songs in live have conflicted our policy, please use other songs.`],[`快捷键扩展`,`Extended Keymap`],[`限速`,`Speed Limit`],[`双击全屏`,`Quick fullscreen`],[`启用 Ajax Hook API`,`Enable Ajax Hook API`],[`加载模式`,`Loading Mode`],[`同时`,`Simultaneous`],[`延后`,`Delay`],[`同时(自动)`,`Simultaneous (Auto)`],[`延后(自动)`,`Delay (Auto)`],[`设置面板停靠位置`,`Settings panel dock side`],[`左侧`,`Left`],[`右侧`,`Right`],[`直播间自动领奖`,`Auto perform drawing in live room`],[`专栏文字选择`,`Selectable texts in column`],[`稍后再看期限提醒`,`Watchlater expire time warnings`],[`解除动态存图限制`,`Unlock image-saving in feeds`],[`展开动态内容`,`Expand feeds content`],[`使用季节Logo`,`Use seasonal logo`],[`格式`,`Format`],[`预设`,`Presets`],[`配置`,`Config`],[`未命名`,`Unnamed`],[`重命名`,`Rename`],[`新增预设`,`New preset`],[`删除预设`,`Delete preset`],[`默认路径`,`Default Path`],[`方法`,`Method`],[`开始下载`,`Start Download`],[`保存配置`,`Save Config`],[`已保存`,`Saved!`],[`全部动态`,`View all`],[`已添加`,`Added`],[`迷你播放器触摸拖动`,`Touch move for mini player`],[`显示链接`,`Show link`],[`复制全部`,`Copy All`],[`简化首页`,`Simplify home`],[`首页风格`,`Style`],[`清爽`,`Simple`],[`极简`,`Minimal`],[`隐藏番剧承包`,`Hide bangumi sponsors`],[`隐藏推荐直播`,`Hide recommended live`],[`隐藏视频推荐`,`Hide related videos`],[`动态过滤器`,`Feeds filter`],[`动态过滤`,`Feeds filter`],[`首选编码`,`Preferred Codec`],[`ffmpeg - 分段列表`,`ffmpeg - Segments List`],[`ffmpeg - 分P列表`,`ffmpeg - Episodes List`],[`视频动态`,`My Feeds`],[`热门视频`,`Trending`],[`返回顶部`,`Back to top`],[`今日`,`Today`],[`三日`,`3 days`],[`一周`,`Weekly`],[`栏目`,`Sites`],[`自动选择当前直播间勋章`,`Auto wear medal of current live room`],[`付费礼物`,`Paid gifts`],[`看板娘`,`Showgirl`],[`活动横幅`,`Event banner`],[`网址参数清理`,`URL clean up`],[`收起直播间侧栏`,`Collapse live room side bar`],[`导入设置`,`Import settings`],[`导出设置`,`Export settings`],[`已成功导入设置, 部分设置需要刷新后生效.`,`Import settings successful, refresh to take effect.`],[`选择的设置文件无效.`,`Invalid settings file.`],[`上一个`,`Previous`],[`下一个`,`Next`],[`刷新`,`Refresh`],[`有新动态`,`Trends`],[`最新发布`,`Newest`],[`时间表`,`Timetable`],[`批量命名格式`,`Batch format`],[`删除电竞赛事`,`Remove e-sports`],[`透明填充`,`Transparent Fill`],[`下载字幕`,`Download subtitles`],[`当前视频没有字幕.`,`There is no subtitle for this video.`],[`入场特效`,`Entrance Effects`],[`图文`,`Image`],[`文字`,`Text`],[`侧边栏`,`Sidebar`],[`关键词`,`Keyword`],[`个人资料`,`Profile`],[`关注的话题`,`Following #Tags#`],[`没有更多了～`,`No more ～`],[`直播弹幕记录器`,`Live danmaku recorder`],[`默认收藏夹`,`Default`],[`本周`,`This week`],[`最近观看`,`Recently viewed`],[`记录弹幕`,`Record danmaku`],[`记录中`,`Stop`],[`开始记录`,`Start`],[`导出XML`,`Export XML`],[`成就值`,`Achievements`],[`正在连接...`,`Connecting...`],[`使用默认直播画质`,`Use default live quality`],[`默认直播画质`,`Default live quality`],[`原画`,`Original`],[`蓝光`,`BD`],[`超清`,`UHD`],[`高清`,`HD`],[`流畅`,`Smooth`],[`保留活动横幅`,`Preserve event banners`],[`动态翻译`,`Feeds translate`],[`翻译器`,`Translator`],[`文本颜色`,`Text color`],[`追番追剧`,`Subscriptions`],[`黑色`,`Black`],[`白色`,`White`],[`*`,[{selector:`.gui-settings-widgets-box .widgets-container .empty-tip`,text:`Nothing here =￣ω￣=`},{selector:`.custom-navbar-settings .paddings-desc`,text:`Edge padding: Set padding for left and right edge of navbar. It's measured as percent (total width is 100%) with 0% ~ 40% valid range.`},{selector:`.custom-navbar-settings .orders-desc`,text:`Orders & Display: Drag the hamburger icon to reorder them, or press on the name for some time to start a drag. Click the eye icon on the right to toggle their visibility.`}]]]);const a=new Map([[/^浏览：([0-9\.a-z]+)$/,`Views：$1`],[/^收藏：([0-9\.a-z]+)$/,`Favorites：$1`],[/^支持：([0-9\.a-z]+)$/,`Likes：$1`],[/^共([\d]+)页$/,`$1 pages in total`],[/^小视频 ([\d]+)$/,`Mini videos $1`],[/^相簿 ([\d]+)$/,`Photos $1`],[/^在线人数：([\d]+)$/,`Online: $1`],[/^([0-1])[ ]?分钟前$/,`$1 minute ago`],[/^([\d]+)[ ]?分钟前$/,`$1 minutes ago`],[/^([0-1])[ ]?小时前$/,`$1 hour ago`],[/^([\d]+)[ ]?小时前$/,`$1 hours ago`],[/^([0-1])播放/,`$1 View`],[/^([\d]+)播放/,`$1 Views`],[/^([\d]+)\.([\d])万播放/,`$1$2k Views`],[/^([0-1])弹幕$/,`$1 Danmaku`],[/^([\d]+)弹幕$/,`$1 Danmakus`],[/^([\d]+)\.([\d])万弹幕$/,`$1$2k Danmakus`],[/^([\+]?[ ]?)关注([：]?[:]?[ ]?)([\d]+)?$/,`$1Follow$2$3`],[/^上传时间：([\d])/,`Upload time: $1`],[/^粉丝([：]?[:]?[ ]?)$/,`Follower$1`],[/^@([ ]?)我的$/,`@Mentions`],[/^TA([ ]?)的相簿$/,`Photos`],[/^1硬币$/,`1 Coin`],[/^([\d]+)硬币$/,`$1 Coins`],[/^阅读([：]?[:]?[ ]?)$/,`$1 Reads`],[/^弹性空白([\d])/,`Flexible blank $1`],[/^金仓鼠([ ]?[:]?)$/,`Golden hamster$1`],[/^贝壳([ ]?[:]?)$/,`Shell$1`],[/^创作团队（([\d]+)）$/,`Team（$1）`],[/^([\d]+)\.(\d)万$/,`$1$2k`],[/^([\d]+)万$/,`$10k`],[/^在线人数: ([\d]+)$/,`$1 people online`],[/^关注([ ])([\d]+)\.([\d])万$/,`Follow$1$2$3k`],[/^点赞数([\d]+)$/,`$1 Likes`],[/^投硬币枚数([\d]+)$/,`$1 Coins`],[/^收藏人数([\d]+)$/,`$1 Favorites`],[/^热门直播([:]?)$/,`Trending live$1`],[/^热门活动([:]?)$/,`Trending events$1`],[/^全部稿件 \(([\d]+)\)$/,`All works ($1)`],[/^进行中 \(([\d]+)\)$/,`Processing ($1)`],[/^已通过 \(([\d]+)\)$/,`Accepted ($1)`],[/^未通过 \(([\d]+)\)$/,`Rejected ($1)`],[/^共([\d]+)P$/,`$1 Episodes`],[/^超清 ([\d]+)K$/,`Ultra $1K`],[/^高清 ([\d]+)P([60\+]?)$/,`HD $1P$2`],[/^清晰 ([\d]+)P$/,`$1P`],[/^流畅 ([\d]+)P$/,`$1P`],[/^兑换成功\n剩余银瓜子:([\d]+)$/,`Exchanged successfully.\nYou have $1 silver seeds left.`],[/^预计大小: (.+)$/,`Estimated size: $1`],[/^最终路径: (.+)$/,`Final path: $1`],[/^最高全站日排行(.+)名$/,`Daily Ranking Record: $1`],[/^已记录([0-1])条弹幕$/,`$1 danmaku recorded`],[/^已记录([\d]+)条弹幕$/,`$1 danmakus recorded`]]);return{export:{map:i,regex:a}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/i18n.ja-JP.min.js"] = (()=>{return(t,e)=>{const $=true;const o=new Map([[`主站`,`ホーム`],[`画友`,`アルバム`],[`音频`,`音楽`],[`游戏中心`,`ゲーム`],[`会员购`,`会員購`],[`下载APP`,`アプリ`],[`会员`,`会員`],[`大会员`,`大会員`],[`小会员`,`小会員`],[`未登录`,`未登録`],[`注册会员`,`登録会員`],[`正式会员`,`正式会員`],[`年度大会员`,`年度大会員`],[`年度小会员`,`年度小会員`],[`消息`,`通知`],[`动态`,`フィード`],[`全部动态`,`すべてのフィード`],[`发布动态`,`投稿する`],[`稍后再看`,`後で見る`],[`收藏`,`お気に入り`],[`更多`,`もっと`],[`排行`,`ランキング`],[`图片`,`画像`],[`视频`,`動画`],[`番剧`,`番組`],[`音乐`,`音楽`],[`时尚`,`潮流`],[`电影`,`劇場`],[`影视`,`映画`],[`特摄`,`特撮`],[`学习`,`勉強`],[`放映厅`,`映画館`],[`广告`,`広告`],[`广场`,`広場`],[`发布`,`発表`],[`举报`,`報告`],[`首页`,`ホーム`],[`热门`,`人気`],[`周一`,`月`],[`周二`,`火`],[`周三`,`水`],[`周四`,`木`],[`周五`,`金`],[`周六`,`土`],[`周日`,`日`],[`今天`,`今日`],[`昨天`,`昨日`],[`近1周`,`1週間`],[`1周前`,`1週前`],[`发送`,`送信`],[`取消`,`キャンセル`],[`关闭`,`閉じる`],[`开启`,`開く`],[`表情`,`スタンプ`],[`小视频`,`ミニ動画`],[`短视频`,`ミニ動画`],[`查看更多`,`もっと見る`],[`显示更多`,`もっと見る`],[`浏览更多`,`もっと見る`],[`了解更多`,`もっと詳しく`],[`查看全部`,`すべて見る`],[`所有关注`,`すべでのフォロー`],[`进入专栏区`,`コラム区に入る`],[`暂时没有新动态了哦！`,`暫く新しいフィードがないよ`],[`播放历史`,`再生履歴`],[`视频历史`,`動画履歴`],[`专栏历史`,`コラム履歴`],[`暂停记录历史`,`再生履歴機能を一時停止`],[`啊叻？你要暂停历史记录功能吗？`,`あれー？再生履歴機能を一時停止しますか？`],[`确定暂停`,`一時停止`],[`清空历史`,`すべての再生履歴を削除`],[`已看完`,`読み終えた`],[`一键清空`,`すべてを削除`],[`移除已观看视频`,`視聴済み動画を削除`],[`已观看`,`視聴済み`],[`删除`,`削除`],[`确认`,`確認`],[`添加`,`追加`],[`编辑`,`変更`],[`取消关注`,`フォロー解除`],[`全部`,`すべて`],[`投稿视频`,`投稿動画`],[`合作视频`,`協力動画`],[`公告栏`,`掲示板`],[`新闻公告`,`ニュース`],[`正在直播`,`配信中`],[`虚拟主播`,`Vtuber`],[`设置`,`設定`],[`频道`,`チャンネル`],[`标签`,`タグ`],[`关注`,`フォロー`],[`关注数`,`フォロー数`],[`粉丝`,`ファン`],[`粉丝数`,`ファン数`],[`阅读数`,`閲覧数`],[`阅读量`,`閲覧数`],[`相簿`,`アルバム`],[`我的频道`,`私のチャンネル`],[`我的视频`,`私の動画`],[`我的音频`,`私の音楽`],[`我的音乐`,`私の音楽`],[`我的专栏`,`私のコラム`],[`我的相簿`,`私のアルバム`],[`我的粉丝`,`私のファン`],[`我的消息`,`DM`],[`我的收藏`,`私のお気に入り`],[`我的订阅`,`私の購読`],[`系统通知`,`システム`],[`全部直播`,`すべで`],[`游戏直播`,`オンライン`],[`网游直播`,`オンライン`],[`网游`,`オンライン`],[`网络游戏`,`オンライン`],[`手游直播`,`モバイル`],[`手游`,`モバイル`],[`手机游戏`,`モバイルゲーム`],[`单机`,`ビデオゲーム`],[`单机游戏`,`ビデオゲーム`],[`娱乐直播`,`エンタメ`],[`电台直播`,`ラジオ`],[`电台`,`ラジオ`],[`绘画直播`,`絵画`],[`绘画`,`絵画`],[`哔考`,`勉強`],[`热门话题`,`人気話題`],[`人气排行`,`人気ランキング`],[`我关注的话题`,`注目した話題`],[`关注的话题`,`注目した話題`],[`前往TA的直播间`,`配信ルームへ移動`],[`进入直播间`,`配信ルームに入る`],[`直播持续时间`,`配信の持続時間`],[`今天你想了解什么呢？(☆▽☆)`,`今日何を知りたいですか(☆▽☆)`],[`Ta还没有应援的友爱社喔 (ಥ_ಥ)`,`彼はまだ「応援社」にいないよ(ಥ_ಥ)`],[`请输入弹幕 DA☆ZE～`,`弾幕を入力してください( •̀ ω •́ )✧`],[`有什么想和大家分享的？`,`何をみんなと共有したいのですか`],[`有新动态，点击查看`,`新しいフィードがある、クリックして見る`],[`以上为热门评论，`,`以上が人気コメント`],[`请自觉遵守互联网相关的政策法规，严禁发布色情、暴力、反动的言论。`,`インターネット関連のポリシーや規制を意識的に遵守し、ポルノ・暴力・反動的な発言を厳禁してください。`],[`点击查看`,`クリックして見る`],[`刚刚`,`さっき`],[`转发动态`,`転載`],[`分享动态`,`シェア`],[`转发`,`転載`],[`赞`,`いいね`],[`好评`,`いいね`],[`支持一下`,`いいね`],[`重播`,`再放送`],[`投币`,`コインを投げる`],[`同时点赞内容`,`同時に好評`],[`添加到收藏夹`,`お気に入りに追加`],[`投稿了`,`投稿した`],[`参与创作了`,`創作に参加した`],[`动态首页`,`フィードホーム`],[`历史动态`,`フィード履歴`],[`活动作品`,`活動作品`],[`未经作者授权，禁止转载`,`作者の許可を得ずに転載を禁ずる`],[`未经作者授权 禁止转载`,`作者の許可を得ずに転載を禁ずる`],[`上一帧`,`前のフレーム`],[`下一帧`,`次のフレーム`],[`人正在看`,`人が見ている`],[`条实时弹幕`,`条の弾幕`],[`开启弹幕`,`弾幕を開ける`],[`显示弹幕`,`弾幕を表示する`],[`关闭弹幕`,`弾幕を閉じる`],[`隐藏弹幕`,`弾幕を隠す`],[`发个友善的弹幕见证当下`,`友好的な弾幕を送ってみよう(ง •_•)ง`],[`发个弹幕见证当下`,`弾幕を送ってみよう`],[`弹幕礼仪`,`弾幕エチケット`],[`追番`,`番組を購読`],[`已追番`,`購読中`],[`标记为 想看`,`「見たい」としてマーク`],[`想看`,`見たい`],[`标记为 在看`,`「見ている」としてマーク`],[`在看`,`見ている`],[`标记为 已看`,`「見た」としてマーク`],[`标记为 看过`,`「見た」としてマーク`],[`看过`,`見た`],[`取消追番`,`購読を取り消し`],[`追剧`,`ドラマを購読`],[`已追剧`,`購読中`],[`取消追剧`,`購読を取り消し`],[`取消订阅`,`購読を解除`],[`追番追剧`,`購読`],[`用手机观看`,`携帯で見る`],[`用手机看`,`携帯で見る`],[`稿件投诉`,`作品報告`],[`充电`,`充電`],[`为TA`,`彼に`],[`为TA充电`,`彼に充電`],[`充电设置`,`充電設定`],[`弹幕列表`,`弾幕リスト`],[`移动`,`移動`],[`保护`,`保護`],[`忽略`,`無視`],[`左舷弹幕太薄了，大家快来吐槽吧~`,`左舷、弾幕薄いぞ.皆さん、弾幕を送ってください!`],[`该视频弹幕为空`,`この動画には弾幕がありません`],[`屏蔽设定`,`ブロック設定`],[`屏蔽设置`,`ブロック設定`],[`屏蔽列表`,`ブロックリスト`],[`高级弹幕`,`高級弾幕`],[`时间`,`時刻`],[`弹幕内容 (`,`弾幕内容 ( `],[`发送时间`,`書込時刻`],[`屏蔽用户`,`ブロック`],[`屏蔽该弹幕的发送者`,`この弾幕の送信者をブロックする`],[`已屏蔽`,`ブロック`],[`查看历史弹幕`,`弾幕履歴を見る`],[`相关视频推荐`,`おすすめ動画`],[`相关推荐`,`おすすめ`],[`点评`,`採点`],[`评论`,`コメント`],[`设为置顶`,`トップに設定`],[`取消置顶`,`トップを取り消し`],[`没有更多信息`,`もう情報はありません`],[`新番时间表`,`番組時間表`],[`小黑屋`,`公開処刑`],[`摄影`,`撮影`],[`插画`,`イラスト`],[`其他`,`他の`],[`下载`,`ダウンロード`],[`更新了`,`更新した`],[`排行榜`,`ランキング`],[`推荐`,`推薦`],[`播放`,`再生`],[`播放数量`,`再生数`],[`自动`,`自動`],[`暂停`,`停止`],[`静音`,`消音`],[`取消静音`,`消音を解除`],[`弹幕`,`弾幕`],[`硬币`,`コイン`],[`宽屏模式`,`ワイドモード`],[`退出宽屏`,`ワイドモードを終了`],[`退出网页全屏`,`ウェブの全画面を終了`],[`退出全屏`,`全画面を終了`],[`进入全屏`,`全画面に入る`],[`全屏模式`,`全画面モード`],[`打开洗脑循环`,`リピート再生を有効にする`],[`观看人数`,`観覧人数`],[`转载`,`転載`],[`展开`,`表示`],[`收起`,`非表示`],[`展开全部`,`フルテキスト`],[`展开全文`,`フルテキスト`],[`展开更多`,`フルテキスト`],[`收起全文`,`一部を表示`],[`已结束`,`終わり`],[`电视剧`,`ドラマ`],[`上一页`,`前へ`],[`下一页`,`次へ`],[`搜索`,`検索`],[`搜索视频`,`動画検索`],[`搜索音频`,`音楽検索`],[`搜索稿件`,`作品検索`],[`直播中`,`配信中`],[`等级`,`レベル`],[`个人中心`,`個人センター`],[`创作中心`,`創作センター`],[`直播中心`,`配信センター`],[`订单中心`,`受注センター`],[`B币钱包`,`ビリ财布`],[`B币`,`ビリコイン`],[`主页`,`ホーム`],[`排序`,`序列`],[`移除`,`削除`],[`复制`,`コピー`],[`换一换`,`更新`],[`特别推荐`,`特別推薦`],[`热门榜单`,`人気ランキング`],[`播放全部`,`すべて再生`],[`立即播放`,`すぐに再生`],[`自动播放`,`自動再生`],[`观看历史`,`視聴履歴`],[`个人收益`,`個人収益`],[`同时转发到我的动态`,`同時に転載する`],[`人气值`,`人気値`],[`友爱社`,`応援社`],[`我的友爱社`,`私の応援社`],[`话题`,`話題`],[`活动`,`活動`],[`活动中心`,`活動中心`],[`新闻`,`ニュース`],[`消息中心`,`ニュースセンター`],[`专栏投稿`,`コラム投稿`],[`音频投稿`,`音楽投稿`],[`视频投稿`,`動画投稿`],[`相簿投稿`,`アルバム投稿`],[`上传视频`,`アップロード`],[`退出登录`,`ログアウト`],[`回复我的`,`返信`],[`TA 的直播间`,`彼の配信ルーム`],[`TA 的小视频`,`彼のミニ動画`],[`TA的视频`,`彼の動画`],[`TA的音频`,`彼の音楽`],[`TA的专栏`,`彼のコラム`],[`TA的频道`,`彼のチャンネル`],[`TA的订阅`,`彼の購読`],[`TA的收藏夹`,`彼のお気に入り`],[`邮箱验证`,`メールアドレスの確認`],[`手机验证`,`電話番号の確認`],[`领取`,`受け取り`],[`确定`,`確定`],[`公开`,`表示`],[`隐藏`,`非表示`],[`搜索设置项`,`検索設定項目`],[`样式`,`スタイル`],[`工具`,`道具`],[`触摸`,`タッチスクリーン`],[`指定播放器布局`,`プレーヤーのレイアウト`],[`视频区布局`,`動画`],[`番剧区布局`,`番組`],[`使用默认播放器模式`,`プレーヤ・モード`],[`默认播放器模式`,`デフォルト・モード`],[`常规`,`標準`],[`宽屏`,`シアターモード`],[`网页全屏`,`ウェブの全画面`],[`全屏`,`全画面`],[`播放时应用模式`,`再生時に使う`],[`播放时自动关灯`,`再生時はライトを消す`],[`使用默认视频画质`,`動画画質`],[`画质设定`,`画質設定`],[`使用默认弹幕设置`,`弾幕設定`],[`记住弹幕设置`,`弾幕設定を覚える`],[`自动展开弹幕列表`,`弾幕リストを表示`],[`自动展开视频简介`,`動画概要欄を表示`],[`自动从历史记录点播放`,`視聴履歴から自動再生`],[`允许跨集跳转`,`クロスセットジャンプ`],[`自动播放视频`,`動画を自動再生`],[`跳过充电鸣谢`,`エンディングをスキップ`],[`启用逐帧调整`,`フレーム毎に調整`],[`启用视频截图`,`スクリーンショット`],[`视频截图`,`スクリーンショット`],[`截图`,`スクリーンショット`],[`自动定位到播放器`,`プレーヤー自動定位`],[`定位偏移量`,`位置オフセット`],[`外置稍后再看`,`外付け「後で見る」`],[`快捷键扩展`,`ショートカットを追加`],[`双击全屏`,`全画面をダブルクリック`],[`主题颜色`,`テーマカラー`],[`文本颜色`,`テキストの色`],[`黑色`,`黒い`],[`白色`,`白い`],[`使用自定义顶栏`,`カスタム頂欄を使用`],[`使用季节Logo`,`季節のロゴを使用`],[`主题色填充`,`テーマ色で埋める`],[`透明填充`,`透明色で埋める`],[`紧凑布局`,`コンパクトなレイアウト`],[`背景模糊`,`背景がぼやける`],[`模糊层不透明度`,`ぼかしの不透過度`],[`夜间模式`,`ダークテーマ`],[`夜间模式计划时段`,`ダークテーマ计画タイム`],[`起始时间`,`開始時刻`],[`结束时间`,`終了時刻`],[`首页使用紧凑布局`,`ホームページにコンパクトなレイアウトを使う`],[`简化评论区`,`コメントエリアの簡素化`],[`使用默认直播画质`,`生放送画質`],[`默认直播画质`,`画質設定`],[`简化直播间`,`配信ルームの簡素化`],[`老爷图标`,`「老爷」アイコン`],[`粉丝勋章`,`ファン勲章`],[`活动头衔`,`活動肩書き`],[`用户等级`,`User Lv.`],[`舰长图标`,`「艦長」アイコン`],[`全区广播`,`全域放送`],[`欢迎信息`,`ウェルカムメッセージ`],[`礼物弹幕`,`ギフト弾幕`],[`上舰提示`,`艦長購入のヒント`],[`付费礼物`,`有料ギフト`],[`入场特效`,`入場特殊効果`],[`活动横幅`,`イベント横断幕`],[`抽奖提示`,`抽選のヒント`],[`房间皮肤`,`特殊な背景`],[`简化首页`,`ホームページを簡素化`],[`首页风格`,`ホームスタイル`],[`清爽`,`さわやか`],[`极简`,`ミニマル`],[`视频动态`,`動画フィード`],[`热门视频`,`人気動画`],[`回到顶部`,`トップに戻る`],[`隐藏顶部横幅`,`トップの横断幕を非表示`],[`播放器投影`,`プレーヤー投影`],[`强制保留弹幕栏`,`弾幕欄を強制保留`],[`模糊视频控制栏背景`,`動画制御欄の背景がぼやける`],[`控制栏着色`,`制御欄に黒を付ける`],[`不透明度`,`不透過度`],[`缩放直播看板娘`,`配信ルームの看板娘をズーム`],[`删除直播水印`,`生放送透かしを削除`],[`删除视频标题层`,`動画・タイトル層を削除`],[`隐藏返回旧版`,`「返回旧版」を非表示`],[`隐藏番剧点评`,`番組の採点を隠す`],[`隐藏番剧承包`,`番組スポンサーを隠す`],[`承包榜`,`スポンサーランク`],[`隐藏推荐直播`,`おすすめ生放送を隠す`],[`大家围观的直播`,`おすすめ生放送`],[`隐藏视频推荐`,`おすすめ動画を隠す`],[`隐藏分区栏`,`エリア欄を隠す`],[`解除动态存图限制`,`フィード画像の保存制限を解除`],[`快速收起动态评论区`,`すぐにコメントを閉じる`],[`收起评论`,`コメントを閉じる`],[`展开动态标题`,`フィードのタイトルを表示`],[`展开动态内容`,`フィードを全表示`],[`旧版动态跳转支持`,`旧版のフィードをジャンプ`],[`动态过滤器`,`フィードフィルター`],[`动态过滤`,`フィードフィルター`],[`关键词`,`キーワード`],[`支持正则表达式 /^xxx$/`,`正規表現サポート /^xxx$/`],[`侧边栏`,`サイドカード`],[`个人资料`,`個人情報`],[`动态翻译`,`フィード翻訳`],[`翻译器`,`翻訳機`],[`翻译`,`翻訳`],[`删除广告`,`広告を削除`],[`显示占位文本`,`プレースホルダーを表示`],[`删除电竞赛事`,`電子スポーツを削除`],[`保留活动横幅`,`イベント横断幕を表示`],[`稍后再看重定向`,`後で見るの動画をリダイレクト`],[`收藏夹视频重定向`,`お気に入りの動画をリダイレクト`],[`隐藏搜索推荐`,`検索欄の推薦語を非表示`],[`展开选集列表`,`動画選集リストを表示`],[`显示失效视频信息`,`失効動画の情報を表示`],[`失效视频重定向`,`失効動画をリダイレクト`],[`信息来源`,`情報源`],[`BiliPlus跳转支持`,`BiliPlusをジャンプ`],[`高分辨率图片`,`高解像度画像`],[`界面翻译`,`UI 翻訳`],[`语言`,`言語`],[`禁止直播首页自动播放`,`生放送のホームページの自動再生を禁止`],[`隐藏首页推荐直播`,`ホームページのおすすめを隠した`],[`瓜子换硬币`,`ヒマワリの種交換`],[`每天最多能兑换 1 个`,`1 日 1 回まで引き換える`],[`直播间自动领奖`,`配信ルームに自動抽選`],[`专栏文字选择`,`コラムのテキストを選択できる`],[`稍后再看期限提醒`,`「後で見る」のリマインダー`],[`自动选择当前直播间勋章`,`勲章を自動的に選択`],[`网址参数清理`,`追跡パラメーターをリンクから削除`],[`直播弹幕记录器`,`生放送弾幕レコーダー`],[`默认收藏夹`,`デフォルト`],[`本周`,`今週`],[`最近观看`,`視聴履歴`],[`记录弹幕`,`弾幕記録`],[`记录中`,`記録中`],[`开始记录`,`記録を開始`],[`导出XML`,`XMLをエクスポート`],[`成就值`,`達成値`],[`正在连接...`,`接続中...`],[`顶栏触摸优化`,`頂欄にタッチ最適化を行う`],[`素质三连触摸支持`,`素質三連タッチサポート`],[`播放器触摸支持`,`プレーヤータッチサポート`],[`启用双击控制`,`ダブルクリック制御`],[`迷你播放器触摸拖动`,`ミニプレーヤーはタッチドラッグをサポート`],[`显示消息`,`メッセージを表示`],[`显示内部错误消息`,`エラーメッセージを表示`],[`文件命名格式`,`ファイル命名形式`],[`批量命名格式`,`バッチ命名形式`],[`侧栏垂直偏移量`,`設定ボタンの垂直オフセット`],[`启用 Ajax Hook API`,`Ajax Hook APIを有効にする`],[`加载模式`,`読み込みモード`],[`同时`,`同時`],[`延后`,`延後`],[`同时(自动)`,`同時(自動)`],[`延后(自动)`,`延後(自動)`],[`设置面板停靠位置`,`パネルの位置を設定`],[`左侧`,`左側`],[`右侧`,`右側`],[`新版本`,`新しいバージョン`],[`已发布.`,`がリリースされました.`],[`安装`,`インストール`],[`查看`,`見る`],[`检查更新`,`更新を確認する`],[`安装更新`,`更新をインストール`],[`查看更新`,`更新を見る`],[`启用缓存`,`キャッシュを有効にする`],[`附加功能`,`追加機能`],[`清除缓存`,`キャッシュを消す`],[`转到BiliPlus`,`BiliPlusをジャンプ`],[`顶栏布局`,`頂欄のレイアウト`],[`搜索框`,`検索欄`],[`用户信息`,`個人情報`],[`投稿入口`,`投稿ページ入り口`],[`转到新版`,`新版のフィード`],[`回到旧版`,`旧版のフィード`],[`查看封面`,`サムネイルを見る`],[`复制原链接`,`リンクをコピー`],[`复制链接`,`リンクをコピー`],[`在新标签页打开`,`新しいページで開く`],[`下载弹幕`,`弾幕ダウンロード`],[`下载字幕`,`字幕ダウンロード`],[`当前视频没有字幕`,`この動画には字幕がありません`],[`下载视频`,`動画ダウンロード`],[`单个视频`,`シングル動画`],[`获取大小中`,`サイズを取得中`],[`获取大小失败`,`サイズを取得に失敗`],[`警告: 过大的视频大小会在直接下载时占用大量内存, 并可能导致浏览器标签页崩溃. 请考虑降低清晰度或使用导出选项.`,`警告：動画サイズが大きすぎると、直接ダウンロードしたときに大量のメモリを占有する、ブラウザのタブがクラッシュする可能性があります.解像度を下げて、あるいはデータをエクスポートことを考えてください.`],[`格式`,`フォーマット`],[`清晰度`,`解像度`],[`无`,`無`],[`首选编码`,`優先コーデック`],[`直接下载`,`直接ダウンロード`],[`开始`,`開始`],[`导出`,`エクスポート`],[`导出aria2`,`aria2`],[`复制vld数据`,`vldをコピー`],[`导出vld数据`,`vld`],[`显示链接`,`リンクを表示`],[`ffmpeg - 分段列表`,`ffmpeg - セグメントリスト`],[`ffmpeg - 分P列表`,`ffmpeg - エピソードリスト`],[`导出aria2 RPC`,`aria2 RPC`],[`无法连接到RPC主机.`,`RPCホストに接続できません.`],[`预设`,`プリセット`],[`新增预设`,`プリセットを追加`],[`未命名`,`名前なし`],[`配置`,`設定`],[`主机`,`ホスト`],[`端口`,`ポート`],[`密钥`,`キー`],[`限速`,`制限速度`],[`默认路径`,`デフォルトパス`],[`路径`,`パス`],[`开始下载`,`ダウンロード`],[`保存配置`,`設定を保存`],[`批量导出`,`バッチエクスポート`],[`请至少选择1集或以上的数量!`,`少なくとも1つ以上のセットを選択してください!`],[`选集`,`エピソード`],[`全选`,`すべて選択`],[`全不选`,`すべて選択しない`],[`反选`,`逆選択`],[`手动输入`,`手動入力`],[`链接列表`,`リンクのリスト`],[`下载音频`,`音楽をダウンロード`],[`更换勋章`,`勲章を入れ換える`],[`更换头衔`,`肩書きを入れ換える`],[`关于`,`About`],[`加载中...`,`ローディング中`],[`错误`,`エラー`],[`请求遭到拒绝, 请检查您的密钥相关设置.`,`要求は拒否されました、キーの関連設定を確認してください`],[`动画`,{selector:`.elevator-module .nav-list .item`,not:$,text:`アニメ`}],[`舞蹈`,{selector:`.elevator-module .nav-list .item`,not:$,text:`ダンス`}],[`专栏`,{selector:`.elevator-module .nav-list .item`,not:$,text:`コラム`}],[`游戏`,{selector:`.elevator-module .nav-list .item`,not:$,text:`ゲーム`}],[`直播`,{selector:`.elevator-module .nav-list .item`,not:$,text:`生放送`}],[`数码`,{selector:`.elevator-module .nav-list .item`,not:$,text:`デジタル`}],[`纪录片`,{selector:`.elevator-module .nav-list .item,\n    .elevator .list-box .item.sortable`,not:$,text:`ドキュメンタリー`}],[`娱乐`,{selector:`.elevator-module .nav-list .item`,not:$,text:`エンタメ`}],[`历史`,[`歴史`,{text:`履歴`,selector:`.nav-con.fr .nav-item .t, .custom-navbar li[data-name='historyList'] .main-content, .custom-navbar-settings .orders li,\n        .app-layout .manga-navbar .action-button.app-button`}]],[`我的关注`,[`私のフォロー`,{text:`フォロー`,selector:`#page-follows .follow-sidenav .text`}]],[`登录`,`ログイン`],[`注册`,`登録`],[`我的直播间`,`私の配信ルーム`],[`直播间`,`配信ルーム`],[`订阅`,`購読`],[`主站空间`,`個人センター`],[`播放数`,`再生数`],[`综合`,`総合`],[`用户`,`ユーザー`],[`投稿管理`,`投稿センター`],[`个人信息`,`個人情報`],[`开播设置`,`放送設定`],[`我的直播间地址`,`私の配信ルーム`],[`直播分类：`,`配信分類：`],[`选择分类`,`エリアを選択`],[`必须选择分类才能开播`,`生放送を開始するにはエリアを選択する必要があります`],[`修改分区`,`エリアを変更`],[`房间标题：`,`生放送タイトル：`],[`开始直播`,`配信を開始`],[`关闭直播`,`配信を中止`],[`主播公告`,`チャンネル公告`],[`简介`,`概要`],[`直播封面`,`配信サムネイル`],[`我的个人标签`,`私のタグ`],[`个人简介`,`個人紹介`],[`直播间信息`,`配信ルーム情報`],[`我的船员`,`私の船員`],[`直播数据`,`配信データ`],[`数据总览`,`データ統計`],[`直播时长`,`総配信時間`],[`最高人气值`,`最大人気値`],[`直播收益(金仓鼠)`,`生放送収益(金ハムスター)`],[`直播收益`,`生放送収益`],[`新增关注数`,`新しい登録者`],[`人均观看时长`,`平均視聴時間`],[`礼物流水`,`ギフト記録`],[`礼物统计`,`ギフト一覧`],[`消费排行`,`投げ銭ランキング`],[`更多>>`,`もっと>>`],[`主播`,`配信者`],[`未开播`,`待機中`],[`金瓜子`,`ひまわりの金の種`],[`银瓜子`,`ひまわりの銀の種`],[`残忍取关`,`フォロー解除`],[`再考虑一下`,`考え直す`],[`已关注`,`フォロー中`],[`七日榜`,`週間rank`],[`舰队`,`艦隊`],[`粉丝榜`,`ファンrank`],[`房管`,`管理者`],[`分享`,`共有`],[`轮播`,`再放送`],[`闲置`,`待機中`],[`回复`,`返信`],[`查看更多评论`,`もっとコメントを表示`],[`英雄联盟`,`LOL`],[`APEX英雄`,`Apex Legends`],[`守望先锋`,`Overwatch`],[`绝地求生`,`PUBG`],[`王者荣耀`,`伝説対決`],[`第五人格`,`Identity V`],[`绝地求生:刺激战场`,`PUBG Mobile`],[`崩坏3`,`崩壊3rd`],[`明日方舟`,`アークナイツ`],[`主机游戏`,`ホストゲーム`],[`我的世界`,`マイクラ`],[`怪物猎人:世界`,`モンハンワールド`],[`只狼：影逝二度`,`SEKIRO/隻狼`],[`鬼泣5`,`デビルメイクライ5`],[`视频唱见`,`歌ってみた`],[`舞见`,`踊ってみた`],[`视频聊天`,`雑談`],[`才艺`,`タレントショー`],[`唱见电台`,`歌見ラジオ`],[`声优`,`声優`],[`聊天电台`,`チャットラジオ`],[`同人绘画`,`同人絵画`],[`原创绘画`,`オリジナル絵画`],[`临摹绘画`,`模写絵画`],[`其他绘画`,`他の絵`],[`扭蛋机`,`ガチャポン`],[`我关注的直播`,`フォローした配信`],[`我关注的动态`,`フォローしたフィード`],[`按热度排序`,`評価順`],[`按时间排序`,`時間順`],[`投稿时间排序`,`投稿時間順`],[`点击数排序`,`クリックの数順`],[`评论数排序`,`コメントの数順`],[`收藏数排序`,`お気に入りの数順`],[`弹幕数排序`,`弾幕の数順`],[`全部评论`,`すべてのコメント`],[`发消息`,`DMを送る`],[`点赞`,`いいね!`],[`发表评论`,`コメント`],[`你的rtmp地址：`,`サーバー：`],[`你的直播码：`,`ストリームキー：`],[`颜值领域专属封面`,`顔出し用サムネ`],[`私信存档`,`DMアーカイブ`],[`历史私信`,`昔のDM`],[`用户中心`,`個人センター`],[`我的信息`,`個人情報`],[`领取奖励`,`受け取り`],[`关注直播间`,`フォロー`],[`加入黑名单`,`ブロックする`],[`悄悄关注`,`非公開フォロー`],[`个人信息举报`,`通報する`],[`观众分析`,`視聴者分析`],[`游客分析`,`ゲスト分析`],[`粉丝分析`,`ファン分析`],[`游客基本属性`,`ゲスト基本属性`],[`性别占比`,`性別割合`],[`观众年龄`,`年齢割合`],[`观看途径`,`端末割合`],[`消息设置`,`通知設定`],[`消息提醒样式`,`通知様式`],[`（不含应援团）`,`（応援社は除外）`],[`红点`,`赤い点`],[`不提醒`,`通知しない`],[`推荐位申请`,`推薦枠申し込み`],[`直播看板娘`,`配信マスコート`],[`收到的赞`,`いいね！`],[`首页管理`,`ホーム`],[`内容管理`,`コンテンツ`],[`视频管理`,`動画管理`],[`专栏管理`,`コラム管理`],[`音频管理`,`音楽管理`],[`相簿管理`,`アルバム管理`],[`你还没有投过一个稿件("▔□▔)`,`あなたはまだ作品を投稿していません("▔□▔)`],[`数据`,`データ`],[`编辑稿件`,`作品を修正`],[`（单次最多允许上传100p视频，推荐采用mp4、flv格式，可有效缩短审核转码耗时）`,`（最大100pの動画を一度にアップロードできますが、監査やトランスコードにかかる時間を短縮するために、「MP4」や「FLV」形式を使用することをお勧めします）`],[`上传完成`,`アップロード完成`],[`添加视频`,`動画を追加`],[`视频封面设置`,`動画のサムネイルを設置`],[`（格式jpeg、png，文件大小≤5MB，建议尺寸≥1146*717，最低尺寸≥960*600）`,`（形式はjpeg/png、ファイルサイズ≤5MB、推奨サイズ≥1146*717、最小サイズ≥960*600）`],[`类型`,`タイプ`],[`分区`,`エリア`],[`全部分区`,`すべてのエリア`],[`热门分区`,`人気のエリア`],[`标题`,`タイトル`],[`更多选项`,`その他のオプション`],[`定时发布`,`定時発表`],[`立即投稿`,`すぐに投稿`],[`分享投稿`,`作品を共有`],[`编辑记录`,`修正記録`],[`删除稿件`,`作品を削除`],[`数据中心`,`データ管理`],[`粉丝管理`,`ファン管理`],[`互动管理`,`インタラクティブ`],[`评论管理`,`コメント管理`],[`弹幕管理`,`弾幕管理`],[`收益管理`,`収益管理`],[`创作激励`,`創作激励`],[`充电计划`,`充電プラン`],[`悬赏计划`,`報酬プラン`],[`创作学院`,`創作学院`],[`个人设置`,`個人設定`],[`申诉管理`,`アピール管理`],[`你的手机号/邮箱`,`あなたの携帯電話番号/メール`],[`密码`,`アカウントパスワード`],[`签到`,`ログボ`],[`使用默认播放速度`,`デフォルトの再生速度を使用する`],[`默认播放速度`,`デフォルトの再生速度`],[`垃圾广告`,`スパム`],[`话题不相关`,`無関係話題`],[`引战`,`論争を誘い込む`],[`色情`,`ポルノ`],[`人身攻击`,`人身攻撃`],[`违法信息`,`違法な情報`],[`直播歌曲内容不适宜请立即调整`,`放送の内容は適していません、すぐに調整`],[`违反直播言论规范, 请立即调整`,`ライブスピーチ規範の違反、すぐに調整`],[`系统通知`,`システム通知`],[`当前直播间被直播管理员切断直播。`,`今、配信ルームはスーパー管理者によって中断されています．`],[`系统升级维护中`,`システム更新中`],[`一周`,`一週間`],[`栏目`,`セクション`],[`重新载入`,`リロード`],[`问题反馈`,`問題報告`],[`HTML5播放器`,`HTML5`],[`Flash播放器`,`Flash`],[`蓝光`,`ブルーレイ`],[`超清`,`ウルトラ`],[`高清`,`HD`],[`透明度`,`透過度`],[`字号缩放`,`弾幕サイズ`],[`同屏密度`,`弾幕密度`],[`弹幕密度`,`弾幕密度`],[`自动调节密度`,`密度自動調整`],[`颜文字面板`,`顔文字`],[`弹幕设置`,`弾幕設定`],[`弹幕调节`,`弾幕調整`],[`关闭礼物特效`,`特殊効果を非表示`],[`清除弹幕历史`,`弾幕履歴を消す`],[`弹幕滚动锁定`,`弾幕欄をロックする`],[`播放器设置`,`プレーヤー設定`],[`线路选择`,`回線を選ぶ`],[`对本稿件的投币枚数已用完`,`この作品にコインの数は使い果たされました`],[`收起直播间侧栏`,`生放送のサイドカードを非表示`],[`导出设置`,`エクスポート設定`],[`导入设置`,`インポート設定`],[`已成功导入设置, 部分设置需要刷新后生效.`,`設定は正常にインポートされました、一部の設定を有効にするには更新する必要があります.`],[`选择的设置文件无效.`,`選択したの設定ファイルは無効です.`],[`主线`,[`主路線`,{text:`主要`,selector:`.link-radio-button-label`}]],[`*`,[{selector:`.gui-settings-widgets-box .widgets-container .empty-tip`,text:`何もないよ =￣ω￣=`},{selector:`.custom-navbar-settings .paddings-desc`,text:`エッジの間隔：両側のエッジの間隔をパーセントで設定します.100％は頂欄全体の幅です.許容設定範囲は0％〜40％です.`},{selector:`.custom-navbar-settings .orders-desc`,text:`順序と表示：左側の棒状アイコン上でドラッグすると順序が変更されるか、名前を押しながらドラッグすることで順序を変更することができます。右側の目のアイコンをクリックすると表示され、非表示になります.`}]]]);const a=new Map([[/^浏览：([0-9\.a-z]+)$/,`閲覧：$1`],[/^收藏：([0-9\.a-z]+)$/,`お気に入り：$1`],[/^支持：([0-9\.a-z]+)$/,`いいね：$1`],[/^共([\d]+)页$/,`全部で $1 ページ`],[/^小视频 ([\d]+)$/,`ミニ動画 $1`],[/^相簿 ([\d]+)$/,`アルバム $1`],[/^在线人数([：]?[:]?[ ]?)([\d]+)?$/,`オンライン$1$2`],[/^([\d]+)[ ]?分钟前$/,`$1 分前`],[/^([\d]+)[ ]?小时前$/,`$1 時間前`],[/^([\d\.万]+)播放/,`$1 視聴`],[/^([\d\.万]+)弹幕$/,`$1 弾幕`],[/^([\+]?[ ]?)关注([：]?[:]?[ ]?)([\d]+)?$/,`$1フォロー$2$3`],[/^关注([ ])([\d\.万]+)$/,`フォロー$1$2`],[/^上传时间：([\d])/,`アップロード時間：$1`],[/^粉丝([：]?[:]?[ ]?)$/,`ファン$1`],[/^@([ ]?)我的$/,`私に$1＠`],[/^TA([ ]?)的相簿$/,`彼の$1アルバム`],[/^([\d]+)硬币$/,`$1コイン`],[/^阅读([：]?[:]?[ ]?)$/,`閲覧$1`],[/^弹性空白([\d])/,`弾力空白$1`],[/^金仓鼠([ ]?[:]?)$/,`金ハムスター$1`],[/^贝壳([ ]?[:]?)$/,`貝殻$1`],[/^点赞数([\d]+)$/,`「いいね」の人数 $1`],[/^投硬币枚数([\d]+)$/,`「コイン」の数 $1`],[/^收藏人数([\d]+)$/,`「お気に入り」の人数 $1`],[/^热门直播([:]?)$/,`人気生放送$1`],[/^热门活动([:]?)$/,`人気活動$1`],[/^全部稿件 \(([\d]+)\)$/,`すべての作品 ($1)`],[/^进行中 \(([\d]+)\)$/,`進行中 ($1)`],[/^已通过 \(([\d]+)\)$/,`パスした ($1)`],[/^未通过 \(([\d]+)\)$/,`失敗した ($1)`],[/^创作团队（([\d]+)）$/,`創作チーム（$1）`],[/^共([\d]+)P$/,`合計$1P`],[/^高清 ([\d]+)P([60\+]?)$/,`HD $1P$2`],[/^清晰 ([\d]+)P$/,`$1P`],[/^流畅 ([\d]+)P$/,`$1P`],[/^兑换成功\n剩余银瓜子:([\d]+)$/,`引き換え成功\n残り銀ヒマワリの種:$1`],[/^预计大小: ([0-9\.A-Z]+)$/,`推定サイズ: $1`],[/^悲痛欲绝/,`悲しすぎる`],[/^最终路径: (.+)$/,`最終パス: $1`],[/^备线([\d])$/,`予備$1`],[/^已记录([\d]+)条弹幕$/,`$1 条の弾幕記録`],[/^共([\d]+)个视频$/,`合計$1本の動画`]]);return{export:{map:o,regex:a}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/i18n.min.css"] = `.admin-list-cntr .rank-cntr .item .admin-icon,.article-action .ops .coin-btn,.article-action .ops .fav-btn,.article-action .ops .like-btn,.attention-btn-ctnr .left-part,.author-info .communicate-btn,.author-info .favourite-btn,.bangumi-info .info-right .info-title .func-module .bangumi-btn .btn-follow,.bb-comment .comment-list .list-item .info .operation .opera-list,.bili-search .nav-wrap .wrap>.sub,.bili-share-pc .title,.bilibili-player-video-sendbar .bilibili-player-video-danmaku-switch .choose_danmaku,.bilibili-player-video-sendbar .bilibili-player-video-hint,.dashboard li.like,.exchange-btn .more,.h .h-f-btn,.history-wrap .history-btn,.info-line .status-no-attend,.invite-code .copy-btn,.live-sidebar-ctnr .sidebar-btn,.media-info .media-right .media-tool-bar .btn-follow,.n .n-data,.player-auxiliary-area .player-auxiliary-setting-menu-wrap,.rank-header .more,.security-right .mp-mine-takedown,.textarea-container .comm-tool .comm-emoji,.textarea-container .comm-tool .comm-submit,.up-info .up-focus-btn,.user-list .up-item .attention-btn.followed,.user-list .up-item .attention-btn.followed:hover,.v-wrap .video-toolbar .ops>span,.video-toolbar-module .btn-item .t{width:auto!important}#app-ctnr .demo-app .category,.bb-comment .comment-send .comment-emoji,.fjw-point .point-wrap .user-point .face .unfocus-btn,.live-room-app .draw-fold-cntr .draw,.media-info-card .mic-expand{width:max-content!important}.live-panel .more-button,.tag-panel .more-button{width:44px!important}.link-navbar .main-ctnr .nav-logo{width:70px!important}.share-board .share-btn .bili-share{width:90px!important}.share-board .song-share .song-share-ul li{width:120px!important}.bili-header-m .profile-m .grade .bar{width:160px!important}.link-navbar .main-ctnr{width:100%!important}.bili-search .video.list{width:calc(100% - 172px)!important}.bili-search .video.list .des{width:100%!important}.gui-settings-box{width:450px!important}.h .h-f-btn{min-width:76px!important}.v-wrap .video-toolbar .ops>span{min-width:92px!important}.primary-menu .nav-menu .nav-name,.primary-menu .nav-menu .side-nav .side-link span{white-space:pre!important}#area-list ul li dl,.player-auxiliary-area .player-auxiliary-setting-menu-list{white-space:nowrap!important}.admin-list-cntr .rank-cntr .item .admin-icon,.article-action .ops .coin-btn,.article-action .ops .fav-btn,.article-action .ops .like-btn,.attention-btn-ctnr .left-part,.bb-comment .comment-send .comment-emoji,.bilibili-player-video-sendbar .bilibili-player-video-danmaku-switch .choose_danmaku,.h .h-f-btn,.media-info .media-right .media-tool-bar .btn-follow,.player-auxiliary-area .player-auxiliary-setting-menu-list,.textarea-container .comm-tool .comm-emoji,.textarea-container .comm-tool .comm-submit,.up-info .up-focus-btn{padding:0 8px!important}.n .n-data{padding:10px 8px!important}.user-panel-ctnr .user-panel .content-ctnr .ctrl-btn:nth-child(2n){padding-left:8px!important}.dashboard li.share .text{padding-top:15px!important}.cc-nav-wrp .nav-item{padding:0 0 0 40px!important}.cc-nav-wrp .sub-nav a{padding:0!important}.player-auxiliary-area .player-auxiliary-filter-menu{margin:0!important;position:relative!important;left:0!important}.dashboard li.collection{margin:0 10px 0 0!important}.bili-search #navigator{overflow:visible!important}.search-wrap .search-block .search-button{letter-spacing:0!important}.follow-btn>span>span{margin-left:8px}.dynamic-m .dyn_menu .line,.mode-fullscreen .bilibili-player-video-sendbar .bilibili-player-video-hint,.nav-wrap .hover-bar,.tab-bar .line{display:none!important}.mode-fullscreen .bilibili-player-video-control .bilibili-player-video-btn-name{font-size:14px!important}.mode-webfullscreen .bilibili-player-video-sendbar .bilibili-player-video-hint{display:none!important}.mode-webfullscreen .bilibili-player-video-control .bilibili-player-video-btn-name{font-size:14px!important}.bilibili-player-video-info{line-height:normal!important}.tab-bar .tab .tab-text.selected{color:var(--theme-color)!important;border-bottom:2px solid!important;box-sizing:border-box!important}.live-panel .more-button{transform:translateX(-9px)!important}.bilibili-player-ending-panel-box-functions .bilibili-player-upinfo-spans>div{align-items:center!important}.dashboard li.collection>div:first-child{display:flex!important;align-items:center!important;flex-direction:column!important}.dashboard li.share{display:inline-flex!important;align-items:center!important;flex-direction:column!important}.user-panel-ctnr .user-panel .content-ctnr .ctrl-btn{float:none!important}#area-list ul li dd,.highlight-areas-ctnr .highlight-area-item .area-name{font-size:18px!important}.author-info .communicate-btn,.author-info .communicate-btn:active,.author-info .favourite-btn,.author-info .favourite-btn:active,.bilibili-player .bilibili-player-video-control .bilibili-player-video-btn-name{font-size:12px!important}.dashboard li.like{border-color:transparent!important}.gui-settings-tooltip{left:470px!important}.gui-settings-dock-right .gui-settings-tooltip{left:unset!important;right:470px!important}.bb-comment .comment-send .comment-submit,.comment-bilibili-fold .comment-send .comment-submit{overflow-wrap:break-word}.info-section .area-text>a{max-width:50px;overflow:hidden;text-overflow:ellipsis;display:inline-block;white-space:nowrap}html[lang=ja-JP] .player-auxiliary-area .danmaku-info-row-block::after{content:"ブロック"!important}html[lang=ja-JP] .minimal-home .video-list .cards.show-rank .video-card:nth-child(17)::before{content:"一週間"}html[lang=en-US] .player-auxiliary-area .danmaku-info-row-block::after{content:"Blocked"!important}html[lang=en-US] .player-auxiliary-area .danmaku-info-row-super::after{content:"Special"!important}html[lang=en-US] .player-auxiliary-area .danmaku-info-row-special::after{content:"Code"!important}html[lang=en-US] .minimal-home .video-list .cards.show-rank .video-card:nth-child(1)::before{content:"Today"}html[lang=en-US] .minimal-home .video-list .cards.show-rank .video-card:nth-child(9)::before{content:"3 days"}html[lang=en-US] .minimal-home .video-list .cards.show-rank .video-card:nth-child(17)::before{content:"Weekly"}.season-list li.season-item .season-body .season-title span.follow{background-image:none;filter:none!important;width:24px}.season-list li.season-item .season-body .season-title span.follow::after{content:"";font:24px/1 "Material Design Icons";font-size:inherit;text-rendering:auto;line-height:inherit;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;background-color:var(--theme-color);color:var(--foreground-color);display:flex;justify-content:center;align-items:center;border-radius:2px;position:absolute;padding:0 4px}@media screen and (max-width:1400px){.link-navbar .nav-item:not(:first-child) .label{padding:0 12px!important}}`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/i18n.min.js"] = (()=>{return(e,t)=>{const s={"日本語":"ja-JP",English:"en-US",Deutsch:"de-DE"};class a{accepts(e){return e.nodeType===Node.ELEMENT_NODE}getValue(e){return e.nodeValue}setValue(e,t){e.nodeValue=t}getElement(e){return e}translate(e){let t=this.getValue(e);if(!t||typeof t!=="string"||t==="*"){return}t=t.trim();const s=a.map.get(t);if(s===undefined){const s=a.regex.find(([e])=>e.test(t));if(s){const[a,r]=s;this.setValue(e,t.replace(a,r))}}else if(typeof s==="string"){this.setValue(e,s)}else if(Array.isArray(s)){let t=null;for(const a of s){if(typeof a==="string"){t=a}else{const{text:s,selector:r,not:n}=a;if(this.getElement(e).matches(r)!==Boolean(n)){t=s}}}if(t!==null){this.setValue(e,t)}}else{const{text:t,selector:a,not:r}=s;if(this.getElement(e).matches(a)!==Boolean(r)){this.setValue(e,t)}}}static walk(e,t){const s=document.createTreeWalker(e,NodeFilter.SHOW_TEXT|NodeFilter.SHOW_ELEMENT,null,false);let a=s.nextNode();while(a){t(a);a=s.nextNode()}}static translate(e){if(e.nodeType===Node.TEXT_NODE){a.textNode.translate(e);return}const t=e=>{for(const t of a.sensitiveTranslators){if(t.accepts(e)){t.translate(e)}}};t(e);a.walk(e,t)}static translateCssMatches(){const e=a.map.get("*");if(!e){return}for(const{selector:t,text:s}of e){const e=document.querySelector(t);if(e){[...e.childNodes].filter(e=>e.nodeType===Node.TEXT_NODE).forEach(e=>e.nodeValue=s)}}}}class r extends a{accepts(e){return e.nodeType===Node.TEXT_NODE}getElement(e){return e.parentElement}}class n extends a{getValue(e){return e.getAttribute("title")}setValue(e,t){e.setAttribute("title",t)}}class l extends a{getValue(e){return e.getAttribute("placeholder")}setValue(e,t){e.setAttribute("placeholder",t)}}class o extends a{accepts(e){return e instanceof HTMLInputElement&&e.hasAttribute("key")}getValue(e){return e.value}setValue(e,t){e.value=t}}a.textNode=new r;a.title=new n;a.placeholder=new l;a.settingsDropdown=new o;a.sensitiveTranslators=[a.textNode,a.title,a.placeholder];const i=async()=>{const r=s[e.i18nLanguage];const{map:n,regex:l}=await t.importAsync(`i18n.${r}`);document.documentElement.setAttribute("lang",r);a.map=n;a.regex=[...l.entries()];a.translate(document.body);a.translateCssMatches();Observer.observe("body",e=>{e.forEach(e=>{if(e.type==="childList"){if(e.addedNodes.length>0){a.translateCssMatches()}e.addedNodes.forEach(e=>{a.translate(e)})}else if(e.type==="characterData"){a.textNode.translate(e.target)}else if(e.type==="attributes"){if(e.attributeName==="title"){a.title.translate(e.target)}else if(e.attributeName==="placeholder"){a.placeholder.translate(e.target)}}})},{characterData:true,childList:true,subtree:true,attributes:true});const o=await SpinQuery.select(".gui-settings-icon-panel");o.addEventListener("be:load",()=>{a.walk(document.querySelector(".gui-settings-box"),e=>a.settingsDropdown.translate(e))},{once:true})};i();return{export:{Translator:a,TextNodeTranslator:r,TitleTranslator:n,PlaceholderTranslator:l},dropdown:{key:"i18nLanguage",items:[`日本語`]}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/i18n.zh-TW.min.js"] = (()=>{return(r,e)=>{const n=new Map([[`主站`,`主站`],[`画友`,`絵画`],[`音频`,`音樂`],[`游戏中心`,`遊戲`],[`会员购`,`購物`],[`漫画`,`漫畫`],[`下载APP`,`下載APP`],[`大会员`,`大會員`],[`动态`,`動態`],[`稍后再看`,`稍後再看`],[`历史`,`歷史`],[`番剧`,`番劇`],[`动画`,`動畫`],[`国创`,`國創`],[`音乐`,`音樂`],[`游戏`,`遊戲`],[`数码`,`數位`],[`电影`,`電影`],[`纪录片`,`紀錄片`],[`时尚`,`時尚`],[`娱乐`,`娛樂`],[`广告`,`廣告`],[`原创`,`原創`],[`广场`,`廣場`],[`发布`,`發佈`],[`专栏`,`專欄`],[`关注`,`關注`],[`粉丝`,`粉絲`],[`热门`,`熱門`],[`视频`,`影片`],[`图片`,`圖片`],[`小视频`,`短影片`],[`公告栏`,`公告欄`],[`特别推荐`,`特別推薦`],[`有新动态`,`有新動態`],[`所有关注`,`所有關注`],[`首页`,`首頁`],[`编辑`,`編輯`],[`回复`,`回覆`],[`举报`,`舉報`],[`在线人数`,`在線人數`],[`*`,[]]]);return{export:{map:n}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/icon.vue.min.js"] = (()=>{return(o,e)=>{const n=`<i class=be-icon :class=classes></i>`;e.applyStyleFromText(`@font-face{font-family:be-main-iconfont;src:url(//s1.hdslb.com/bfs/seed/jinkela/header/asserts/iconfont.ttf) format("truetype")}@font-face{font-family:be-extended-iconfont;src:url(//s1.hdslb.com/bfs/static/jinkela/video/asserts/iconfont.4bab144.ttf) format("truetype")}@font-face{font-family:be-home-iconfont;src:url(//s1.hdslb.com/bfs/static/jinkela/international-home/asserts/iconfont.ttf) format("truetype")}.be-icon{color:inherit;font-size:24px;font-style:normal;line-height:1}.be-icon.be-main-iconfont{font-family:be-main-iconfont!important}.be-icon.be-extended-iconfont{font-family:be-extended-iconfont!important}.be-icon.be-home-iconfont{font-family:be-home-iconfont!important}.be-icon.be-iconfont-logo::before{content:""}.be-icon.be-iconfont-lv0::before{content:"";color:#9a9a9a}.be-icon.be-iconfont-lv1::before{content:"";color:#646464}body.dark .be-icon.be-iconfont-lv0::before{color:#777}body.dark .be-icon.be-iconfont-lv1::before{color:#ddd}.be-icon.be-iconfont-lv2::before{content:"";color:#1bc861}.be-icon.be-iconfont-lv3::before{content:"";color:#22baea}.be-icon.be-iconfont-lv4::before{content:"";color:#eaa722}.be-icon.be-iconfont-lv5::before{content:"";color:#ff7631}.be-icon.be-iconfont-lv6::before{content:"";color:#ff3131}.be-icon.be-iconfont-profile::before{content:""}.be-icon.be-iconfont-posts::before{content:""}.be-icon.be-iconfont-wallet::before{content:""}.be-icon.be-iconfont-live-center::before{content:""}.be-icon.be-iconfont-order-center::before{content:""}.be-icon.be-iconfont-logout::before{content:""}.be-icon.be-iconfont-ok::before{content:""}.be-icon.be-iconfont-cancel::before{content:""}.be-icon.be-iconfont-bind-phone::before{content:""}.be-icon.be-iconfont-bind-email::before{content:""}.be-icon.be-iconfont-coin-outline::before{content:""}.be-icon.be-iconfont-coin::before{content:""}.be-icon.be-iconfont-b-coin::before{content:""}.be-icon.be-iconfont-activity::before{content:""}.be-icon.be-iconfont-message::before{content:""}.be-icon.be-iconfont-favorites-outline::before{content:""}.be-icon.be-iconfont-favorites::before{content:""}.be-icon.be-iconfont-history::before{content:""}.be-icon.be-iconfont-vip::before{content:""}.be-icon.be-iconfont-play::before{content:""}.be-icon.be-iconfont-danmaku::before{content:""}.be-icon.be-iconfont-like::before{content:""}.be-icon.be-iconfont-like-outline::before{content:""}.be-icon.be-iconfont-up::before{content:""}.be-icon.be-iconfont-up-outline::before{content:""}.be-icon.be-iconfont-left-arrow::before{content:""}.be-icon.be-iconfont-right-arrow::before{content:""}.be-icon.be-iconfont-up-arrow::before{content:""}.be-icon.be-iconfont-down-arrow::before{content:""}.be-icon.be-iconfont-play-triangle::before{content:""}.be-icon.be-iconfont-refresh::before{content:""}`,"icon-style");return{export:Object.assign({template:n},{props:{icon:String,type:String},computed:{classes(){if(this.icon===""||this.type===""){return[]}if(this.type==="mdi"){return["mdi",`mdi-${this.icon}`]}return[`be-iconfont-${this.icon}`,`be-${this.type}-iconfont`]}}})}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/icons.min.css"] = `.icons-enabled [class^=icon-]{width:24px;height:24px;display:inline-block;background-image:none;font-size:12px}.icons-enabled [class^=icon-]::after{content:"";width:24px;height:24px;display:inline-block}.icons-enabled [class^=icon-]::before{content:none!important}.icons-enabled .icon-view::after{background-image:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="24" height="24" viewBox="0 0 24 24"><path fill="black" d="M8.5,13.5L11,16.5L14.5,12L19,18H5M21,19V5C21,3.89 20.1,3 19,3H5A2,2 0 0,0 3,5V19A2,2 0 0,0 5,21H19A2,2 0 0,0 21,19Z" /></svg>')}.icons-enabled .icon-clear::after{background-image:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="24" height="24" viewBox="0 0 24 24"><path fill="black" d="M15,16H19V18H15V16M15,8H22V10H15V8M15,12H21V14H15V12M3,18A2,2 0 0,0 5,20H11A2,2 0 0,0 13,18V8H3V18M14,5H11L10,4H6L5,5H2V7H14V5Z" /></svg>')}.icons-enabled .icon-download::after{background-image:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="24" height="24" viewBox="0 0 24 24"><path fill="black" d="M5,20H19V18H5M19,9H15V3H9V9H5L12,16L19,9Z" /></svg>')}.icons-enabled .icon-update::after{background-image:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="24" height="24" viewBox="0 0 24 24"><path fill="black" d="M5.12,5L5.93,4H17.93L18.87,5M12,17.5L6.5,12H10V10H14V12H17.5L12,17.5M20.54,5.23L19.15,3.55C18.88,3.21 18.47,3 18,3H6C5.53,3 5.12,3.21 4.84,3.55L3.46,5.23C3.17,5.57 3,6 3,6.5V19A2,2 0 0,0 5,21H19A2,2 0 0,0 21,19V6.5C21,6 20.83,5.57 20.54,5.23Z" /></svg>')}.icons-enabled .icon-info::after{background-image:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="24" height="24" viewBox="0 0 24 24"><path fill="black" d="M11,9H13V7H11M12,20C7.59,20 4,16.41 4,12C4,7.59 7.59,4 12,4C16.41,4 20,7.59 20,12C20,16.41 16.41,20 12,20M12,2A10,10 0 0,0 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12A10,10 0 0,0 12,2M11,17H13V11H11V17Z" /></svg>')}.icons-enabled .icon-settings::after{background-image:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="24" height="24" viewBox="0 0 24 24"><path fill="black" d="M12,15.5A3.5,3.5 0 0,1 8.5,12A3.5,3.5 0 0,1 12,8.5A3.5,3.5 0 0,1 15.5,12A3.5,3.5 0 0,1 12,15.5M19.43,12.97C19.47,12.65 19.5,12.33 19.5,12C19.5,11.67 19.47,11.34 19.43,11L21.54,9.37C21.73,9.22 21.78,8.95 21.66,8.73L19.66,5.27C19.54,5.05 19.27,4.96 19.05,5.05L16.56,6.05C16.04,5.66 15.5,5.32 14.87,5.07L14.5,2.42C14.46,2.18 14.25,2 14,2H10C9.75,2 9.54,2.18 9.5,2.42L9.13,5.07C8.5,5.32 7.96,5.66 7.44,6.05L4.95,5.05C4.73,4.96 4.46,5.05 4.34,5.27L2.34,8.73C2.21,8.95 2.27,9.22 2.46,9.37L4.57,11C4.53,11.34 4.5,11.67 4.5,12C4.5,12.33 4.53,12.65 4.57,12.97L2.46,14.63C2.27,14.78 2.21,15.05 2.34,15.27L4.34,18.73C4.46,18.95 4.73,19.03 4.95,18.95L7.44,17.94C7.96,18.34 8.5,18.68 9.13,18.93L9.5,21.58C9.54,21.82 9.75,22 10,22H14C14.25,22 14.46,21.82 14.5,21.58L14.87,18.93C15.5,18.67 16.04,18.34 16.56,17.94L19.05,18.95C19.27,19.03 19.54,18.95 19.66,18.73L21.66,15.27C21.78,15.05 21.73,14.78 21.54,14.63L19.43,12.97Z" /></svg>')}.icons-enabled .icon-widgets::after{background-image:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="24" height="24" viewBox="0 0 24 24"><path fill="black" d="M3,3H11V7.34L16.66,1.69L22.31,7.34L16.66,13H21V21H13V13H16.66L11,7.34V11H3V3M3,13H11V21H3V13Z" /></svg>')}.icons-enabled .icon-cancel::after{background-image:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="24" height="24" viewBox="0 0 24 24"><path fill="black" d="M19,6.41L17.59,5L12,10.59L6.41,5L5,6.41L10.59,12L5,17.59L6.41,19L12,13.41L17.59,19L19,17.59L13.41,12L19,6.41Z" /></svg>')}.icons-enabled .icon-ok::after{background-image:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="24" height="24" viewBox="0 0 24 24"><path fill="black" d="M21,7L9,19L3.5,13.5L4.91,12.09L9,16.17L19.59,5.59L21,7Z" /></svg>')}.icons-enabled .icon-video::after{background-image:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="24" height="24" viewBox="0 0 24 24"><path fill="black" d="M17,10.5V7A1,1 0 0,0 16,6H4A1,1 0 0,0 3,7V17A1,1 0 0,0 4,18H16A1,1 0 0,0 17,17V13.5L21,17.5V6.5L17,10.5Z" /></svg>')}.icons-enabled .icon-video-outline::after{background-image:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="24" height="24" viewBox="0 0 24 24"><path fill="black" d="M15,8V16H5V8H15M16,6H4A1,1 0 0,0 3,7V17A1,1 0 0,0 4,18H16A1,1 0 0,0 17,17V13.5L21,17.5V6.5L17,10.5V7A1,1 0 0,0 16,6Z" /></svg>')}.icons-enabled .icon-style::after{background-image:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="24" height="24" viewBox="0 0 24 24">   <path fill="black" d="M17.5,12A1.5,1.5 0 0,1 16,10.5A1.5,1.5 0 0,1 17.5,9A1.5,1.5 0 0,1 19,10.5A1.5,1.5 0 0,1 17.5,12M14.5,8A1.5,1.5 0 0,1 13,6.5A1.5,1.5 0 0,1 14.5,5A1.5,1.5 0 0,1 16,6.5A1.5,1.5 0 0,1 14.5,8M9.5,8A1.5,1.5 0 0,1 8,6.5A1.5,1.5 0 0,1 9.5,5A1.5,1.5 0 0,1 11,6.5A1.5,1.5 0 0,1 9.5,8M6.5,12A1.5,1.5 0 0,1 5,10.5A1.5,1.5 0 0,1 6.5,9A1.5,1.5 0 0,1 8,10.5A1.5,1.5 0 0,1 6.5,12M12,3A9,9 0 0,0 3,12A9,9 0 0,0 12,21A1.5,1.5 0 0,0 13.5,19.5C13.5,19.11 13.35,18.76 13.11,18.5C12.88,18.23 12.73,17.88 12.73,17.5A1.5,1.5 0 0,1 14.23,16H16A5,5 0 0,0 21,11C21,6.58 16.97,3 12,3Z" /></svg>')}.icons-enabled .icon-tool::after{background-image:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="24" height="24" viewBox="0 0 24 24">   <path fill="black" d="M9,5V6H15V5H9M22,18C22,18.53 21.79,19 21.4,19.41C21,19.81 20.55,20 20,20H4C3.45,20 3,19.81 2.6,19.41C2.21,19 2,18.53 2,18V14H7V15H9V14H15V15H17V14H22V18M4.5,7.22C4.84,6.41 5.45,6 6.33,6H7V5C7,4.45 7.18,4 7.57,3.59C7.96,3.2 8.44,3 9,3H15C15.56,3 16.04,3.2 16.43,3.59C16.82,4 17,4.45 17,5V6H17.67C18.55,6 19.16,6.41 19.5,7.22L21.58,12H17V11H15V12H9V11H7V12H2.42L4.5,7.22Z" /></svg>')}.icons-enabled .icon-touch::after{background-image:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="24" height="24" viewBox="0 0 24 24">   <path fill="black" d="M10,9A1,1 0 0,1 11,8A1,1 0 0,1 12,9V13.47L13.21,13.6L18.15,15.79C18.68,16.03 19,16.56 19,17.14V21.5C18.97,22.32 18.32,22.97 17.5,23H11C10.62,23 10.26,22.85 10,22.57L5.1,18.37L5.84,17.6C6.03,17.39 6.3,17.28 6.58,17.28H6.8L10,19V9M11,5A4,4 0 0,1 15,9C15,10.5 14.2,11.77 13,12.46V11.24C13.61,10.69 14,9.89 14,9A3,3 0 0,0 11,6A3,3 0 0,0 8,9C8,9.89 8.39,10.69 9,11.24V12.46C7.8,11.77 7,10.5 7,9A4,4 0 0,1 11,5M11,3A6,6 0 0,1 17,9C17,10.7 16.29,12.23 15.16,13.33L14.16,12.88C15.28,11.96 16,10.56 16,9A5,5 0 0,0 11,4A5,5 0 0,0 6,9C6,11.05 7.23,12.81 9,13.58V14.66C6.67,13.83 5,11.61 5,9A6,6 0 0,1 11,3Z" /></svg>')}.icons-enabled .icon-other::after{background-image:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="24" height="24" viewBox="0 0 24 24">   <path fill="black" d="M11,13.5V21.5H3V13.5H11M9,15.5H5V19.5H9V15.5M12,2L17.5,11H6.5L12,2M12,5.86L10.08,9H13.92L12,5.86M17.5,13C20,13 22,15 22,17.5C22,20 20,22 17.5,22C15,22 13,20 13,17.5C13,15 15,13 17.5,13M17.5,15A2.5,2.5 0 0,0 15,17.5A2.5,2.5 0 0,0 17.5,20A2.5,2.5 0 0,0 20,17.5A2.5,2.5 0 0,0 17.5,15Z" /></svg>')}.icons-enabled .icon-arrow::after{background-image:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="24" height="24" viewBox="0 0 24 24"><path fill="black" d="M7.41,15.41L12,10.83L16.59,15.41L18,14L12,8L6,14L7.41,15.41Z" /></svg>')}.icons-enabled .icon-rank::after{background-image:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="24" height="24" viewBox="0 0 24 24">   <path fill="black" d="M3,22V8H7V22H3M10,22V2H14V22H10M17,22V14H21V22H17Z" /></svg>')}.icons-enabled .icon-like::after{background-image:url('data:image/svg+xml;utf-8,<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24" height="24" viewBox="0 0 24 24"><path fill="black" d="M20.9,11.2c0-0.9-0.7-1.6-1.6-1.6h-5.1l0.8-3.7c0-0.1,0-0.2,0-0.3c0-0.3-0.1-0.6-0.4-0.9l-0.9-0.9L8.4,9.2	c-0.3,0.3-0.5,0.7-0.5,1.2v8.1c0,0.9,0.7,1.6,1.6,1.6h7.3c0.7,0,1.2-0.4,1.5-1l2.4-5.7c0.1-0.2,0.1-0.4,0.1-0.6V11.2 M3.1,20.1h3.2v-9.7H3.1V20.1z"/></svg>')}.icons-enabled .icon-danmaku::after{background-image:url('data:image/svg+xml;utf-8,<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24" height="24" viewBox="0 0 24 24"><path fill="black" d="M20,4H4C2.9,4,2,4.9,2,6v12c0,1.1,0.9,2,2,2h4h5.9H20c1.1,0,2-0.9,2-2V6C22,4.9,21.1,4,20,4z M5,7h8v2H5V7z M7,17H5v-2h2V17z M6.3,13v-2H18v2H6.3z M19,17H9v-2h10V17z M19,9h-4.1V7H19V9z"/></svg>')}.icons-enabled .icon-search::after{background-image:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="24" height="24" viewBox="0 0 24 24">   <path fill="black" d="M9.5,3A6.5,6.5 0 0,1 16,9.5C16,11.11 15.41,12.59 14.44,13.73L14.71,14H15.5L20.5,19L19,20.5L14,15.5V14.71L13.73,14.44C12.59,15.41 11.11,16 9.5,16A6.5,6.5 0 0,1 3,9.5A6.5,6.5 0 0,1 9.5,3M9.5,5C7,5 5,7 5,9.5C5,12 7,14 9.5,14C12,14 14,12 14,9.5C14,7 12,5 9.5,5Z" /></svg>')}.compact .primary-menu .nav-menu>li.home>a,.icons-enabled .icon-home::after{background-image:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="24" height="24" viewBox="0 0 24 24"><path fill="black" d="M10,20V14H14V20H19V12H22L12,3L2,12H5V20H10Z" /></svg>')}.compact .primary-menu .nav-menu .side-nav .side-link i.zhuanlan,.icons-enabled .icon-read::after{background-image:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="24" height="24" viewBox="0 0 24 24"><path fill="black" d="M19,2L14,6.5V17.5L19,13V2M6.5,5C4.55,5 2.45,5.4 1,6.5V21.16C1,21.41 1.25,21.66 1.5,21.66C1.6,21.66 1.65,21.59 1.75,21.59C3.1,20.94 5.05,20.5 6.5,20.5C8.45,20.5 10.55,20.9 12,22C13.35,21.15 15.8,20.5 17.5,20.5C19.15,20.5 20.85,20.81 22.25,21.56C22.35,21.61 22.4,21.59 22.5,21.59C22.75,21.59 23,21.34 23,21.09V6.5C22.4,6.05 21.75,5.75 21,5.5V7.5L21,13V19C19.9,18.65 18.7,18.5 17.5,18.5C15.8,18.5 13.35,19.15 12,20V13L12,8.5V6.5C10.55,5.4 8.45,5 6.5,5V5Z" /></svg>')}.compact .primary-menu .nav-menu .side-nav .side-link i.square,.icons-enabled .icon-square::after{background-image:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="24" height="24" viewBox="0 0 24 24"><path fill="black" d="M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22A10,10 0 0,1 2,12A10,10 0 0,1 12,2M16.75,14.45C18.65,12.55 18.58,9.39 16.59,7.41C14.6,5.43 11.45,5.35 9.55,7.25C6.12,10.68 7.22,16.78 7.22,16.78C7.22,16.78 13.33,17.87 16.75,14.45M13.15,7.86L14.13,9.87L16.14,10.85L14.13,11.83L13.15,13.84L12.17,11.83L10.16,10.85L12.17,9.87L13.15,7.86Z" /></svg>')}.compact .primary-menu .nav-menu .side-nav .side-link i.live,.icons-enabled .icon-live::after{background-image:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="24" height="24" viewBox="0 0 24 24"><path fill="black" d="M18,16L14,12.8V16H6V8H14V11.2L18,8M20,4H4A2,2 0 0,0 2,6V18A2,2 0 0,0 4,20H20A2,2 0 0,0 22,18V6C22,4.89 21.1,4 20,4Z" /></svg>')}.compact .primary-menu .nav-menu .side-nav .side-link i.blackroom,.icons-enabled .icon-judge::after{background-image:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="24" height="24" viewBox="0 0 24 24"><path fill="black" d="M12,3C10.73,3 9.6,3.8 9.18,5H3V7H4.95L2,14C1.53,16 3,17 5.5,17C8,17 9.56,16 9,14L6.05,7H9.17C9.5,7.85 10.15,8.5 11,8.83V20H2V22H22V20H13V8.82C13.85,8.5 14.5,7.85 14.82,7H17.95L15,14C14.53,16 16,17 18.5,17C21,17 22.56,16 22,14L19.05,7H21V5H14.83C14.4,3.8 13.27,3 12,3M12,5A1,1 0 0,1 13,6A1,1 0 0,1 12,7A1,1 0 0,1 11,6A1,1 0 0,1 12,5M5.5,10.25L7,14H4L5.5,10.25M18.5,10.25L20,14H17L18.5,10.25Z" /></svg>')}.icons-enabled .icon-medal::after{background-image:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="24" height="24" viewBox="0 0 24 24">   <path fill="black" d="M20,2H4V4L9.81,8.36C6.14,9.57 4.14,13.53 5.35,17.2C6.56,20.87 10.5,22.87 14.19,21.66C17.86,20.45 19.86,16.5 18.65,12.82C17.95,10.71 16.3,9.05 14.19,8.36L20,4V2M14.94,19.5L12,17.78L9.06,19.5L9.84,16.17L7.25,13.93L10.66,13.64L12,10.5L13.34,13.64L16.75,13.93L14.16,16.17L14.94,19.5Z" /></svg>')}.icons-enabled .icon-live-title::after{background-image:url('data:image/svg+xml;utf-8,<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24" height="24" viewBox="0 0 24 24"><g fill="black"><polygon points="8.63,15.83 7,14.89 7,9.11 12,6.23 13.63,7.17 15.9,3.25 6.95,3.25 1.89,12 6.37,19.75"/><polygon points="6.95,20.75 6.95,20.75 6.95,20.75"/><polygon points="17.63,4.25 15.37,8.17 17,9.11 17,14.89 12,17.77 10.37,16.83 8.1,20.75 17.05,20.75 22.11,12"/></g></svg>')}.icons-enabled .icon-biliplus::after{background-image:url('data:image/svg+xml;utf-8,<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24" height="24" viewBox="0 0 24 24"><g fill="black"><path d="M3.46,7.35h4.08c1.91,0,3.29,0.29,4.14,0.86c0.85,0.57,1.28,1.47,1.28,2.68c0,0.84-0.23,1.54-0.7,2.09c-0.47,0.55-1.14,0.91-2.02,1.07v0.1c1.11,0.19,1.92,0.57,2.43,1.14s0.77,1.33,0.77,2.28c0,1.28-0.44,2.28-1.31,2.99c-0.87,0.71-2.09,1.07-3.65,1.07H3.46V7.35z M5.26,13.43H7.9c1.12,0,1.93-0.18,2.44-0.54s0.76-0.96,0.76-1.8c0-0.77-0.28-1.33-0.83-1.68C9.71,9.06,8.83,8.89,7.62,8.89H5.26V13.43z M5.26,14.93v5.18h2.88c1.15,0,2-0.22,2.55-0.67c0.55-0.45,0.83-1.12,0.83-2.01c0-0.85-0.29-1.48-0.88-1.89c-0.59-0.41-1.47-0.61-2.64-0.61H5.26z"/></g><g fill="black"><path d="M18.11,6.1h3.18v1.14h-3.18v3.3h-1.15v-3.3h-3.18V6.1h3.18V2.78h1.15V6.1z"/></g></svg>')}.icons-enabled .icon-time::after{background-image:url('data:image/svg+xml;utf-8,<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24" height="24" viewBox="0 0 24 24"><g fill="black"><path d="M11.99,2C6.47,2,2,6.48,2,12s4.47,10,9.99,10C17.52,22,22,17.52,22,12S17.52,2,11.99,2zM12,20c-4.42,0,-8,-3.58,-8,-8s3.58,-8,8,-8,8,3.58,8,8,-3.58,8,-8,8zm0.5,-13H11v6l5.25,3.15,0.75,-1.23,-4.5,-2.67z"/></g></svg>')}.icons-enabled .icon-activity::after{background-image:url('data:image/svg+xml;utf-8,<svg height="24" width="24" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><path d="M7.9,11.1c-0.7-0.8-1.2-1.8-1.3-2.8s0-2.1,0.4-3.1s1.1-1.8,2-2.4c0.9-0.6,1.9-0.9,3-0.9c0.3,0,0.5,0.1,0.7,0.3	c0.2,0.2,0.3,0.4,0.3,0.6v5.1c0.8-0.7,1.8-1.2,2.8-1.3s2.1,0,3.1,0.4s1.8,1.1,2.4,2c0.6,0.9,0.9,1.9,0.9,3c0,0.3-0.1,0.5-0.3,0.7	c-0.2,0.2-0.4,0.3-0.6,0.3h-5.1c0.7,0.8,1.2,1.8,1.3,2.8s0,2.1-0.4,3.1c-0.5,1-1.1,1.8-2,2.4c-0.9,0.6-1.9,0.9-3,0.9 c-0.3,0-0.5-0.1-0.7-0.3c-0.2-0.2-0.3-0.4-0.3-0.6v-5.1c-0.8,0.7-1.8,1.2-2.8,1.3s-2.1,0-3.1-0.4c-1-0.5-1.8-1.1-2.4-2	c-0.6-0.9-0.9-1.9-0.9-3c0-0.3,0.1-0.5,0.3-0.6c0.2-0.2,0.4-0.3,0.6-0.3H7.9z M8.3,7.4c0,0.9,0.3,1.6,0.8,2.2c0.5,0.6,1.1,1.1,2,1.3	V3.8c-0.8,0.2-1.5,0.7-2,1.3C8.6,5.8,8.4,6.5,8.3,7.4z M15.7,16.6c0-0.9-0.3-1.6-0.8-2.2c-0.5-0.6-1.1-1.1-2-1.3v7.1 c0.8-0.2,1.5-0.7,2-1.3C15.4,18.2,15.6,17.5,15.7,16.6z M16.6,8.3c-0.9,0-1.6,0.3-2.2,0.8c-0.6,0.5-1.1,1.1-1.3,2h7.1 c-0.2-0.8-0.7-1.5-1.3-2C18.2,8.6,17.4,8.4,16.6,8.3z M7.4,15.7c0.9,0,1.6-0.3,2.2-0.8c0.6-0.5,1.1-1.1,1.3-2H3.8 c0.2,0.8,0.7,1.5,1.3,2C5.8,15.4,6.5,15.6,7.4,15.7z" fill="black"></path></svg>')}.icons-enabled .icon-cc-subtitles::after{background-image:url('data:image/svg+xml,%3Csvg width="24" height="24" viewBox="0 0 22 22" xmlns="http://www.w3.org/2000/svg"%3E%3Cpath d="M4 4h14a2 2 0 012 2v10a2 2 0 01-2 2H4a2 2 0 01-2-2V6a2 2 0 012-2zm5 5.5a1 1 0 100-2H6a2 2 0 00-2 2v3a2 2 0 002 2h3a1 1 0 000-2H7a1 1 0 01-1-1v-1a1 1 0 011-1h2zm8 0a1 1 0 000-2h-3a2 2 0 00-2 2v3a2 2 0 002 2h3a1 1 0 000-2h-2a1 1 0 01-1-1v-1a1 1 0 011-1h2z" fill="black" fill-rule="evenodd"%3E%3C/path%3E%3C/svg%3E')}`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/image-resolution.min.js"] = (()=>{return(t,e)=>{const o=/@(\d+)[Ww]_(\d+)[Hh]/;const n=t.imageResolutionScale==="auto"?window.devicePixelRatio:parseFloat(t.imageResolutionScale);const r=["#certify-img1","#certify-img2"];const i=(t,e)=>{const o=document.createTreeWalker(t,NodeFilter.SHOW_ELEMENT,null,false);let n=o.nextNode();while(n){e(n);n=o.nextNode()}};async function a(t){const e=(e,i)=>{const a=e(t);if(a===null){return}if(r.some(e=>t.matches(e))){return}const s=a.match(o);if(!s){return}let[,c,u]=s;let l=parseInt(t.getAttribute("data-resolution-width")||"0");if(parseInt(c)>=l&&l!==0){return}if(t.getAttribute("width")===null&&t.getAttribute("height")===null){t.setAttribute("width",c)}c=Math.round(n*parseInt(c)).toString();u=Math.round(n*parseInt(u)).toString();t.setAttribute("data-resolution-width",c);i(t,a.replace(o,`@${c}w_${u}h`))};Observer.attributes(t,()=>{e(t=>t.getAttribute("src"),(t,e)=>t.setAttribute("src",e));e(t=>t.style.backgroundImage,(t,e)=>t.style.backgroundImage=e)})}const s=async()=>{i(document.body,t=>a(t));Observer.childListSubtree(document.body,t=>{for(const e of t){for(const t of e.addedNodes){if(t instanceof HTMLElement){a(t);if(t.nodeName.toUpperCase()!=="IMG"){i(t,t=>a(t))}}}}})};s();e.applyStyleFromText(`.favInfo-box .favInfo-cover img {width: 100% !important; object-position: left !important;}`,"image-resolution-fix");return{export:{imageResolution:a}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/image-viewer.min.css"] = `body.image-viewer-opened,html.image-viewer-opened{overflow:hidden!important}.image-viewer-container,.image-viewer-container *{transition:.2s ease-out}.image-viewer-container{background:rgba(0,0,0,.85);width:100%;height:100%;position:fixed;top:0;left:0;z-index:100002;display:flex;justify-content:center;align-items:center;opacity:0;pointer-events:none}.image-viewer-container.opened{opacity:1;pointer-events:initial}.image-viewer{width:90%;height:90%;display:grid;grid-template-columns:auto 48px;grid-template-rows:48px auto 48px 12px 48px 18px 48px;grid-template-areas:"image close" "image ." "image copy-link" "image ." "image new-tab" "image ." "image download";grid-column-gap:12px;column-gap:12px;justify-items:center;justify-content:stretch;align-items:center;align-content:stretch;transform:scale(.95)}.image-viewer-container.opened .image-viewer{transform:scale(1)}.image-viewer .image{grid-area:image;width:auto;height:auto;max-width:100%;max-height:100%}.image-viewer .close{grid-area:close}.image-viewer .download{grid-area:download}.image-viewer .copy-link{grid-area:copy-link;transform:scale(.95)}.image-viewer .new-tab{grid-area:new-tab;transform:scale(.85)}.image-viewer-icon{cursor:pointer;width:100%;height:100%}.image-viewer-icon svg{max-width:48px;max-height:48px}.image-viewer-icon path{fill:#eee;transition:.2s;transform-origin:center}.image-viewer-icon:hover path{fill:var(--theme-color);transform:scale(1.1)}`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/image-viewer.min.html"] = `<div class=image-viewer-container><div class=image-viewer><img class=image><a class="close image-viewer-icon"title=关闭><svg viewBox="0 0 24 24"><path d=M19,6.41L17.59,5L12,10.59L6.41,5L5,6.41L10.59,12L5,17.59L6.41,19L12,13.41L17.59,19L19,17.59L13.41,12L19,6.41Z /></svg></a><a target=_blank class="copy-link image-viewer-icon"title=复制原链接><svg viewBox="0 0 24 24"><path d="M3.9,12C3.9,10.29 5.29,8.9 7,8.9H11V7H7A5,5 0 0,0 2,12A5,5 0 0,0 7,17H11V15.1H7C5.29,15.1 3.9,13.71 3.9,12M8,13H16V11H8V13M17,7H13V8.9H17C18.71,8.9 20.1,10.29 20.1,12C20.1,13.71 18.71,15.1 17,15.1H13V17H17A5,5 0 0,0 22,12A5,5 0 0,0 17,7Z"/></svg></a><a target=_blank class="new-tab image-viewer-icon"title=在新标签页打开><svg viewBox="0 0 24 24"><path d="M14,3V5H17.59L7.76,14.83L9.17,16.24L19,6.41V10H21V3M19,19H5V5H12V3H5C3.89,3 3,3.9 3,5V19A2,2 0 0,0 5,21H19A2,2 0 0,0 21,19V12H19V19Z"/></svg></a><a target=_blank class="download image-viewer-icon"title=下载><svg viewBox="0 0 24 24"><path d=M5,20H19V18H5M19,9H15V3H9V9H5L12,16L19,9Z /></svg></a></div></div>`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/index.min.html"] = `<!doctypehtml><html lang=en><meta charset=UTF-8><meta name=viewport content="width=device-width,initial-scale=1"><meta http-equiv=X-UA-Compatible content="ie=edge"><title>Document</title><script src=index.js defer=defer type=module></script>`;
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/keymap.min.js"] = (()=>{return(e,i)=>{const t=["https://www.bilibili.com/bangumi/","https://www.bilibili.com/video/"];if(t.some(e=>document.URL.startsWith(e))){const t={f:".bilibili-player-video-fullscreen",w:".bilibili-player-video-web-fullscreen",t:".bilibili-player-video-btn-widescreen",r:".bilibili-player-video-btn-repeat",m:".bilibili-player-video-btn-volume .bilibili-player-iconfont-volume",c:".video-toolbar .coin,.tool-bar .coin-info",s:".video-toolbar .collect"," ":".bilibili-player-video-btn-start"};let n=true;let a;const o=e=>{let t=dq(".keymap-playback-tip");if(!t){const e=dq(".bilibili-player-video-wrap");if(!e){return}e.insertAdjacentHTML("afterbegin",`\n<div class="keymap-playback-tip-container">\n<i class="mdi mdi-fast-forward"></i>\n<div class="keymap-playback-tip"></div>x\n</div>\n`);i.applyStyleFromText(`\n        .keymap-playback-tip-container {\n          position: absolute;\n          left: 50%;\n          top: 50%;\n          transform: translate(-50%, -50%);\n          padding: 8px 16px;\n          background-color: #000A;\n          color: white;\n          pointer-events: none;\n          opacity: 0;\n          z-index: 100;\n          display: flex;\n          align-items: center;\n          font-size: 14pt;\n          border-radius: 4px;\n          transition: .2s ease-out;\n        }\n        .keymap-playback-tip-container.show {\n          opacity: 1;\n        }\n        .keymap-playback-tip-container i {\n          line-height: 1;\n          margin-right: 8px;\n          font-size: 18pt;\n        }\n`,"keymapStyle");t=dq(".keymap-playback-tip")}t.innerHTML=e.toString();if(a){clearTimeout(a)}dq(".keymap-playback-tip-container").classList.add("show");a=setTimeout(()=>{dq(".keymap-playback-tip-container").classList.remove("show")},2e3)};document.body.addEventListener("keydown",i=>{if(document.activeElement&&["input","textarea"].includes(document.activeElement.nodeName.toLowerCase())){return}const a=i.key.toLowerCase();const l=!i.shiftKey&&!i.altKey&&!i.ctrlKey&&!i.metaKey;if(a in t&&l){const e=dq(t[a]);if(!e){return}i.stopPropagation();i.preventDefault();e.click()}else if(a==="d"&&l){const e=dq(".bilibili-player-video-danmaku-switch input");if(!e){return}i.stopPropagation();i.preventDefault();e.checked=!e.checked;raiseEvent(e,"change")}else if(a==="j"&&l){const t=dq(".bilibili-player-video video");t.currentTime+=e.keymapJumpSeconds;i.stopPropagation();i.preventDefault()}else if(a==="l"&&l){const e=dq(".video-toolbar .like");i.preventDefault();const t=(i,t)=>{const n=new CustomEvent(i,t);e.dispatchEvent(n)};n=true;setTimeout(()=>n=false,200);t("mousedown",i);document.body.addEventListener("keyup",e=>{e.preventDefault();t("mouseup",e);if(n){t("click",e)}},{once:true})}else if(i.shiftKey){const t=dq(".bilibili-player-video video");if(t===null){return}const n=[.5,.75,1,1.25,1.5,2,2.5,3];let l=true;if(a===">"||a==="ArrowUp".toLowerCase()){t.playbackRate=n.find(e=>e>t.playbackRate)||n[n.length-1];o(t.playbackRate)}else if(a==="<"||a==="ArrowDown".toLowerCase()){t.playbackRate=[...n].reverse().find(e=>e<t.playbackRate)||n[0];o(t.playbackRate)}else if(a==="?"){t.playbackRate=1;o(t.playbackRate)}else if(a==="w"){const e=dq(".video-toolbar .ops .watchlater,.more-ops-list .ops-watch-later");if(e!==null){e.click()}}else if(a==="j"){t.currentTime-=e.keymapJumpSeconds}else{l=false}if(l){i.stopPropagation();i.preventDefault()}}})}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/live-socket.min.js"] = (()=>{return(e,t)=>{const s={json:0,heartBeatResponse:1,buffer:2};const r={heartBeat:2,heartBeatResponse:3,message:5,enterRoom:7,enterRoomResponse:8};class i{constructor(){this.textEncoder=new TextEncoder;this.textDecoder=new TextDecoder}readInt(e,t,s){let r=0;for(let i=s-1;i>=0;i--){r+=Math.pow(256,s-i-1)*e[t+i]}return r}writeInt(e,t,s,r){let i=0;while(i<s){e[t+i]=r/Math.pow(256,s-i-1);i++}}encode(e,t){const s=this.textEncoder.encode(e);const i=16+s.byteLength;const o=[0,0,0,0,0,16,0,1,0,0,0,r[t],0,0,0,1];this.writeInt(o,0,4,i);return new Uint8Array(o.concat(...s)).buffer}decode(e){const i=async e=>{const o={packetLength:this.readInt(e,0,4),headerLength:this.readInt(e,4,2),protocolVersion:this.readInt(e,6,2),operation:this.readInt(e,8,4),sequenceID:this.readInt(e,12,4)};const n=[o];if(o.packetLength<e.length){n.push(...await i(e.slice(o.packetLength)))}if(o.operation===r.message){const r=e.slice(o.headerLength,o.packetLength);if(o.protocolVersion===s.buffer){const{pako:e}=await t.importAsync("pako-inflate");o.messages=(await i(e.inflate(r))).map(e=>e.messages[0])}else if(o.protocolVersion===s.json){o.messages=[JSON.parse(this.textDecoder.decode(r))]}}else if(o.operation===r.heartBeatResponse){o.heartBeatResponse={count:this.readInt(e,16,4)}}return n};return new Promise(t=>{const s=new FileReader;s.onload=(async e=>{const s=new Uint8Array(e.target.result);t(await i(s))});s.readAsArrayBuffer(e)})}}class o{constructor(){this.startTime=0}getLiveTime(){return new Promise(e=>{if(this.startTime){e(this.startTime);return}const t=dq(".bilibili-live-player-video-controller-duration-btn span");const s=Observer.childList(t,t=>{const r=t.length>0&&t.some(e=>{return e.addedNodes.length>0&&[...e.addedNodes].every(e=>e.nodeType===Node.TEXT_NODE)});if(r){s.stop();const r=t[0].addedNodes[0].textContent;const[i,o,n=0]=r.split(":").reverse().map(_.unary(parseInt));const a=Number(new Date);this.startTime=a-n*1e3*3600-o*60*1e3-i*1e3;e(this.startTime)}})})}}class n extends EventTarget{constructor(e){super();this.roomID=e;this.retryInterval=200;this.autoRetry=true;this.servers=["broadcastlv.chat.bilibili.com"];this.selectedServer="";this.liveTime=new o;this.bufferHelper=new i;this.stopRequested=false;window.addEventListener("unload",()=>this.stop())}heartBeat(){if(this.webSocket.readyState===WebSocket.OPEN){this.webSocket.send(this.bufferHelper.encode("","heartBeat"))}else{this.stop();this.restart()}}restart(){this.dispatchEvent(new CustomEvent("restart"));if(!this.stopRequested&&this.autoRetry){console.log(`Live Socket: unexpected disconnect, retry in ${this.retryInterval}ms`);const e=this.servers.indexOf(this.selectedServer);if(e<this.servers.length-1){this.selectedServer=this.servers[e+1]}else{[this.selectedServer]=this.servers}console.log(`Live Socket: server changed to`,this.selectedServer);setTimeout(()=>this.start(),this.retryInterval)}}async start(){const e=await Ajax.getJson(`https://api.live.bilibili.com/room/v1/Danmu/getConf?room_id=${this.roomID}&platform=pc&player=web`);const t=_.get(e,"data.host_server_list",[]);this.servers=[...new Set([...this.servers,...t.map(e=>e.host)])];if(this.selectedServer===""){[this.selectedServer]=this.servers;console.log("Initial server:",this.selectedServer)}if(this.webSocket&&(this.webSocket.readyState===WebSocket.CONNECTING||this.webSocket.readyState===WebSocket.OPEN)){this.stop()}this.webSocket=new WebSocket(`wss://${this.selectedServer}/sub`);this.stopRequested=false;this.dispatchEvent(new CustomEvent("start",{detail:this.webSocket}));this.webSocket.addEventListener("open",()=>{const t={roomid:this.roomID,uid:parseInt(getUID()),protover:2,platform:"web",clientVer:"1.10.1",type:"2",key:_.get(e,"data.token")};this.webSocket.send(this.bufferHelper.encode(JSON.stringify(t),"enterRoom"));this.dispatchEvent(new CustomEvent("open",{detail:t}))});this.webSocket.addEventListener("message",async e=>{const[t]=await this.bufferHelper.decode(e.data);this.dispatchEvent(new CustomEvent("message",{detail:t}));switch(t.operation){case r.enterRoomResponse:{if(this.heartBeatTimer){clearInterval(this.heartBeatTimer)}this.heartBeatTimer=setInterval(()=>{this.heartBeat()},30*1e3);break}case r.heartBeatResponse:{this.dispatchEvent(new CustomEvent("heartBeatResponse",{detail:t.heartBeatResponse.count}));break}case r.message:{const e=await this.liveTime.getLiveTime();t.messages.forEach(t=>{if(t.cmd==="DANMU_MSG"){const s=t.info;const r={content:s[1],type:s[0][1],fontSize:s[0][2],color:s[0][3],sendTime:s[0][4],userHash:s[0][7],userID:s[2][0],userName:s[2][1],startTime:e,get time(){return this.sendTime-this.startTime}};this.dispatchEvent(new CustomEvent("danmaku",{detail:r}))}});break}default:break}});this.webSocket.addEventListener("close",e=>{if(!this.stopRequested){console.error("Live Socket: close",e);this.restart()}});this.webSocket.addEventListener("error",e=>{console.error("Live Socket: error",e);this.restart()})}stop(){this.stopRequested=true;if(this.heartBeatTimer){clearInterval(this.heartBeatTimer)}if(this.webSocket&&this.webSocket.readyState===WebSocket.OPEN){this.webSocket.close()}}}return{export:{LiveSocket:n}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/magic-grid.min.js"] = (()=>{return(t,e)=>{const i=function(t){const e=25;if(!t){throw new Error("No config object has been provided.")}if(typeof t.useTransform!=="boolean"){t.useTransform=true}if(typeof t.gutter!=="number"){t.gutter=e}if(!t.container){s("container")}if(!t.items&&!t.static){s("items or static")}};const s=function(t){throw new Error("Missing property '"+t+"' in MagicGrid config")};const n=function(t){let e=t[0];for(const i of t){if(i.height<e.height){e=i}}return e};class o{constructor(t){i(t);if(t.container instanceof HTMLElement){this.container=t.container;this.containerClass=t.container.className}else{this.containerClass=t.container;this.container=document.querySelector(t.container)}this.items=this.container.children;this.static=t.static||false;this.size=t.items;this.gutter=t.gutter;this.maxColumns=t.maxColumns||false;this.useMin=t.useMin||false;this.useTransform=t.useTransform;this.animate=t.animate||false;this.started=false;this.init()}init(){if(!this.ready()||this.started){return}this.container.style.position="relative";for(let t=0;t<this.items.length;t++){const e=this.items[t].style;e.position="absolute";if(this.animate){e.transition=(this.useTransform?"transform":"top, left")+" 0.2s ease"}}this.started=true}colWidth(){return this.items[0].getBoundingClientRect().width+this.gutter}setup(){const t=this.container.getBoundingClientRect().width;const e=this.colWidth();let i=Math.floor(t/e)||1;const s=[];if(this.maxColumns&&i>this.maxColumns){i=this.maxColumns}for(let t=0;t<i;t++){s[t]={height:0,index:t}}const n=t-i*e+this.gutter;return{cols:s,wSpace:n}}nextCol(t,e){if(this.useMin){return n(t)}return t[e%t.length]}positionItems(){const t=this.setup();const e=t.cols;let i=t.wSpace;let s=0;const n=this.colWidth();i=Math.floor(i/2);for(let t=0;t<this.items.length;t++){const o=this.nextCol(e,t);const h=this.items[t];const r=o.height?this.gutter:0;const a=o.index*n+i+"px";const l=o.height+r+"px";if(this.useTransform){h.style.transform="translate("+a+", "+l+")"}else{h.style.top=l;h.style.left=a}o.height+=h.getBoundingClientRect().height+r;if(o.height>s){s=o.height}}this.container.style.height=s+"px"}ready(){if(this.static){return true}return this.items.length>=this.size}getReady(){const t=setInterval(()=>{this.container=document.querySelector(this.containerClass);this.items=this.container.children;if(this.ready()){clearInterval(t);this.init();this.listen()}},100)}listen(){if(this.ready()){let t;window.addEventListener("resize",()=>{if(!t){t=setTimeout(()=>{this.positionItems();t=null},200)}});this.positionItems()}else{this.getReady()}}}const h={template:`\n<div :class="[wrapper]">\n<slot></slot>\n</div>\n`,name:"magic-grid",props:{wrapper:{type:String,default:"wrapper"},gap:{type:Number,default:32},maxCols:{type:Number,default:5},maxColWidth:{type:Number,default:280},animate:{type:Boolean,default:true},useMin:{type:Boolean,default:false}},data(){return{started:false,items:[]}},mounted(){this.waitUntilReady()},updated(){this.positionItems()},methods:{waitUntilReady(){if(this.isReady()){this.positionItems()}else this.getReady()},isReady(){return this.$el&&this.items.length>0},getReady(){let t=setInterval(()=>{this.items=this.$el.children;if(this.isReady()){clearInterval(t);this.init()}},100)},init(){if(!this.isReady()||this.started)return;this.$el.style.position="relative";Array.prototype.forEach.call(this.items,t=>{t.style.position="absolute";t.style.maxWidth=this.maxColWidth+"px";if(this.animate)t.style.transition="top, left 0.2s ease"});this.started=true;this.waitUntilReady()},colWidth(){return this.items[0].getBoundingClientRect().width+this.gap},setup(){let t=this.$el.getBoundingClientRect().width;let e=Math.floor(t/this.colWidth())||1;let i=[];if(this.maxCols&&e>this.maxCols){e=this.maxCols}for(let t=0;t<e;t++){i[t]={height:0,top:0,index:t}}let s=t-e*this.colWidth()+this.gap;return{cols:i,wSpace:s}},nextCol(t,e){if(this.useMin)return this.getMin(t);return t[e%t.length]},positionItems(){let{cols:t,wSpace:e}=this.setup();e=Math.floor(e/2);Array.prototype.forEach.call(this.items,(i,s)=>{i.style.position="absolute";i.style.maxWidth=this.maxColWidth+"px";if(this.animate)i.style.transition="top, left 0.2s ease";let n=this.nextCol(t,s);let o=n.index*this.colWidth()+e;i.style.left=o+"px";i.style.top=n.height+n.top+"px";n.height+=n.top+i.getBoundingClientRect().height;n.top=this.gap});this.$el.style.height=this.getMax(t).height+"px"},getMax(t){let e=t[0];for(let i of t){if(i.height>e.height)e=i}return e},getMin(t){let e=t[0];for(let i of t){if(i.height<e.height)e=i}return e}}};return{export:{MagicGrid:o,MagicGridComponent:h}}}})();
onlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/mdi.min.js"] = (() => { return (e, o) => { if (dq("style#mdi") === null) { const e = document.createElement("style"); e.id = "mdi"; e.innerHTML =`/* MaterialDesignIcons.com */@font-face{font-family:"Material Design Icons";src:url("data:font/woff2;base64,d09GMgABAAAAAvIwAAoAAAAIVvwAAvHfAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAABlYAgwIKm+RslrF7C/NEAAE2AiQD80AEIAWFMgeD1lFbD8OWR9GNduCq4oHXbQjATVOrPpcYOSFOWUcQflXH4ccS+O9V73eHsSuL2VDeYNtUhdffDCP7///////fmfyIftubgZ3Z77vlhDtQ8AAxM/tZWcE8Js8oVTQafCiib+AVo6iCyp1gltV9uyNKGzYyxpWKMklb37y2vRzlAff2II+IZi4cbi5P8nFRz+tpF9UMxUzYCmar5KLm9VzPJneGaxQ2b1NS7s1NyebumnfXNsj5SZas5ainLMxg7i7N3F2aubs0c3fNXbqZu7kwccN1kM+fllve4orWcewoSHMe54ap5MEMDTGKLv1FK65/ng43uX/dD5vnl92XzW4/o2HKSG9deHwd3aSNXzF4RYoiC0aRlW/qdC5tLNOEtlvsYCIapmEQKYksHW+xJ5Hq9rsS1dNm1urJlGf8WNcBppuaDSbnI0bwIixi9xNPSEPegyLhfEEWUT27Eo/Slb1pD6ud0mnp4hDeu2q/aq21jmjhPam8kSSJFt67yk6SJFp4v1V2kiTRwvujkiRJooX3ofIvSZJo4b2ovCNJEi28RWUnSRItvH8qO0mSaOF9qOwkSaKF918lSXGsKCGauuins7bgFshzgBZyt6rHwCLsYEoYhBEH9Ym4ENpN72SwBz3La1F/iP0fIt28DEIGI+vDWCHM3LOGCpIHwgpj/T9DmbKSoKKynHk3OFETBLSK7nzaaq2jFZVobW0VWwehy1g7rVjRLtva1ujMyGQwxjCz2UuqKEX/Zf/Dk27+u8y7SzZJgLCOENYdIxDGUo4MCNMASVgqYQUBK2NaB3HjRgUFXOgm2Iq7NVpxdUn70apt/cW1WhHHbs3/oan2KVtnqtHkCgPVszZNFv6n3ZkiF4zdSUqiy/xJOtN1GKR0KnX+VTnpcgDemVd0l47Be5dW5PewVzuwV+WUqt2rHVEA/esyRx/adyzNMIQ3gE/ydphG6CPAe7Elb1ohICwA3vK87d7fdlGEOUSYYP7Dpb53e1ts7J8BHMAAjQVCG88yasV6Pfd/U1fA99XxsCrWsoRFCVR/97gkHVnzMvcNreE2oCZCb2f+ojZwGWoWDHBQC3hz7Tfq4Byjk26T28TvHkKmdXQ43ZSUvBM6sgxXbW+u/UmFRmisgv4XsAhoZZpRcYcEUAkUgSIJ2raSeqQeo3FrnP+d84/v6/6vpro5pu2ZcQt8y+u0bLglbwq0BhzbYdmcLzu8BhxhnQ3J8A2oAI0BZcAVGRTADcMy3f//s9n+n5YLAdpuI2JVDklq4eD/Z05ffHf3zvyIfqpBzgkWxwTMvGezzutztmmnltpdBA6RBYcWJIcyhU7hqKb2XzX9T10zn0Owy5YTXo41CjwOGQok9UVSezOXq+c6c7UkWzIsyPYSvCQfCLzO/Nea/d8Lu3vpnSVIFClBIga0zHhkhO5cCalNoF+mN9uubff2SgmBvExVtRQJI1hgJvNkzM77yNn/o1T1f0a8zYA3FdtpxSwuKc8lvbtgF7J5Uayf6HLFXnevC4AAKVKSQYJFluIfkpJSqqS0xvJDqqt/z769Z91SmApDlSVKSKZQXGi7C0uz7FeS6BIiiC/X5GpfZSmFGX5J+sC2aW1rp0xfU//71ra7ZnegW4rj3HeFdmDAdujSUIZI8N54k4xnJputtJW23S0yBAQNAtuybEGDISAwyPaBDz/VZl/V7q1q5/ZevZbIlxZk8jU2vj5rUtUF6QvQmd+XK1zhSkPiXyBkYORLfGxFxMC18t/e2SLAPyfZIhi7qdzVJUeOAG+goPrzzfkfzBJmdiCoFBtKUdMoGkteIfp8pZ57j/lsjPf/YbPFLWynrH+rXZP/05lJKaVLN2A4oABgeYQ+77uOqkZqNe2H0cheBwSWvAFmg+//3trTuOWE1uTme2zmoNbR7oxFbyhdtYyj6NAUlg22q6ymuAx2/LOg6vsJbLMfBNuCfTCKGrBdZBYbotFoMmtHLFhmV7GtUbAMesa4iiXmrancWk+fpa4a/ZEh6aR7GVIaacQMpn1CSp2URkp9BLPLb4sg4WJOEnjmjwAYbiCsr/3//Wl9zWmDAgpEh6pOMxu/7m7+/BBwjdUWEk8SVaYQJrcdMIm4LYTAwoQC5wQhdbrz1E+1/rqQfm7KlLoWluAVnkcEPzW0VmdjrmGaeRQrH/JIqyBgMDhPaaBBBl9swwkXPRJQhWtG6OcHQwxAy9v+hBDCIA4CATQPSs5XzCYa4uHve0vti7/LV4UCAaoNIOp3gN/MgGPxPTVmT5kxXmPcZjcxq3rn3Ptuvnvfva/qvsysqpdZLrMKJrMAol5WgUAWQD6XpZeZBUahAP6A4e8AKakDhNRD2xOkTASQBVJiQbZISi1QUkdTre/8aqxcTFDsb9U9xpqdX89fbSZmt5nFejfQp1q96fIvxk7POHYU/yX1VBhxuhn7vlJnBtjUrEFp7fCe/0rV/7YFyVJA+cmB7J/3lfyh5e72aSV/Uv64ffPgHoZhOVXdW8WquoUqALeAAlAgSBAgZRCg5EKBpECQkjARBiHaBwRJPWqIvyznvPaUtCzb78jjKYCDQFJ2SFBSKCnxk+RZTpzJ7/1hkmQ7x3Fect53/KZp3PVi1b1Z9mL55133tnfbXm+7lyP8Vzegd98ClOt24dqCJs1OLJAWLAuAE5f8/8zU70d7AA1H4vfUGuuCaKi1JttskxDz7nt1MVVd3WIPCJIzACnCUCIJUhIAOYr//6qeNd090DkQ15Fax69IWmtCb6LNwg3S9b+WNRuiXCEplLyQyo/SbM/s/stRIzxq/n+vu7iZvjRz1ZAdLiSNcGSLdQgFyH+355ek1m2TPDD6FubB85+avi1A/KEcMhVqx6YXdfzrbxe9i17awdPVEhzAIfPsqnL1U9Hi4WFBzAyWDom75Pl1bJoi9hLLiKPOTmIJJppQSbhyrBlUU0Sx7TYUiCgqodAN733Fu/vFPfHjdWOFO97M7v6mb6qqoiKiL/Ki6ra1+q/CKvazP0lAREDFrS/3Oc9hm4VXwbNQ1IdgCaTyu/cNj5v5C9ajJ4MGCS2UiEKU2DPd12Vs31e9+F0KgyEMIy//1Au43u919n+cZEs/ebALWwglBuOElsSAy4w9RRpJY/j4efdecusf1iv1o4eVIixFxArKwpakzyQzyd0/Irf6fyAYbtfd81CBRSTNkMSQR5jJ3bmqu2v9/5Dc+v+L4nl69Xl+xAZbGkW0g1J2e5KdJDMJDDKnQ9vau2dtpD5OAkR8fT5uIPlE90z+JT2cv5x6mKempqaqKiIqImq+mTUdBcjpOUA+YIe5z04f35Xs/5vO78gEkuB8srG75EIrKWDA7pILTGaxvO/P1/n/PyKnAifc9rLBllsS0iihmGB3yVZZkqx5/9IbAIwCHuzNFoCc+/4/BSz++EzV+POGSyxI/EeD679FgwYQwhpJAADjb5I1S9+DsUpg2Uvzf0IKPhi8/WwUfvLAOHTk0rrVxG4Vg6QJqL7gaje4z25VYEuH36wjyffhU8P/qoRDrsQ//5gyFizBm7Rsxx0TbD8I/xla/xf9v6K3zEcOnHa76Ozy/T0u7olyDiz84H6yUz/NhBXedjoj8Jo0D0Vs6D4p8ik38MxDWEWIzqIWyWyiEmF2cxUM7SXYPgzJjPttYcEMhhQASXgygwkfo++9JV6XqlTSAmSB9o2211zI9I4ruOHCEUQrL01RGyvWsaJIraU1fEtUMjrf/4LrB4Fc4lYgAP3gGxRMnA/EYOq3YN8iQyUDlXmirgJOMe2Uh0h4UXaiFnim0wVUJe3vNlSemNnRqsR0MFDAsFr6Ec7get5MzIG0AgqkvJsqAC55yL3EEBY8yMl+MnKq03kV/AN5r7RUxYFCYp6sL4G6HMi+IygV7Vl8q4RGuuzeHbxZbR0tuSz1uhxry+jX4K5PNRnmxmWrTDSpTnM8bsbXxkXnpv0haW54uMKCzqMYWpAofgIICG98GuLyoT6i4LwGgDxzqKHFbrWC2CZPPBttn0+DAFyyQ8xGmEQTa8VeckQ2Ty1DfT6r1LxZN1LKyLsC819rCFGgoZHOMusM9CpAnDR0atVMS+Q8l1kb9oYGYXkg7DJQke/2A23hkA+gQDblF9bPmls1GPce4kzW8dVDQSb7zDPl/wIPeiLrC7weFkWyl/YQ5l3u2kAK6PJM6M19O+fwczlUztYFEsQB5Cq1qwTtG85prVWa+XJSouof09srx+wqke1e34xTPos80Vwi0XY1YOY6uv7L8ZryZr8kpsMqqIlb3QFkCiOptHLJgtRDJhkGMuXEAQqDun/wgbDy08MA9CpVJ2E6ZgRvSi4FYIu3aPTN6hbycn6bLxTV22G2jHeUE9iqguxm8mgOVeqvIBZ8tr1AS3autoDS5eDY1a5p5i0J1QsU8RYHETSKuBytGiRNND894299YJmJpil3laLUe812y76yBEGPel08lrE/dWQHi3m1ILEzk9ZRV4MJLdtwyVQg3QZXNM1BJRNi1lucN8NO7JKEnmEsWmKEBeulNMFLVILyKRNmRlflRNvsiZLuYCnbRcQExlcEYqYKZIz5XEAgxVecosmmbe+ziqIAa10qGWlGcrmXRSu8MWyyqL3BS6z9ToGgQXloyymMrmqxqHXAukupqQJM5gDfUQRCyqTdEH9Rfp7RvhsaofmNLSPGC2IwEj0XPmzvAu99gyGl7xFmlTmgkyD6hdxJDaa5wS6YkCMqNAjg91LRNdO52do00NomD8rMidUzESTz6X6Xku3c49Z6H9l2eWs0I0mILuqa2sOOcsmpsCNKbNF8wG90Ov4nXWMW9ezILvVY3UttAK1s/yuP16lARCpSYCigazYfjfmKUFMyp3Q5XCIGnU2F6P726PaYAbBAaRfnJGNo0wrYS4qSVVaQxguPMD+xJAhkd71q++xYj6NNrp0M1z9lR3asojz5BKtLIPbRG5eoH5ffs+204tBCNGdmnowK8G5CdsZ0LPWmh9YUjRSlogDxHZA9lmUsZcerCW5fExawM+sPBcuTHsmqSg+wp5C28NEfrsRztxeECuf3mFeCHSpvfWmIkRPgxraaV6wd5i/KStnUy2Pz+sYr3yMK8VB/6TVp2s5B7q3Xp7dfyYJL995Z0YYOoYKadoGYn+2f+ZlgiYKI6FApll4TBSYMk8ajx9MQeYwxa+xyc7jOuNG2x8BkhfEAnd0ZZR2GKM7Z+8dhRptjXIms5UqJEGbAtnhEepRlhirbU5Hf5Cd4NTRP5A1lFo+I7axMw1Di7tiEngaFyZcjhAOFRsE74+fmAAZxRQJzq9j8bFC7ZNEV5IgKZ1vdBHJoNhcYjjasCPTQ0ficQ45eCgZOaBdU+e12EFCFZIMZrXfDyEmnKsJolfOUtP3vvpMc3e+f7+o5Djx6c7AtSVIH+pYoXow8ePcjdFqGSd/ZsTF83nyPdYG3xHh+ZcUDUe2o93BTiDj8nEfvnr/sjbaPZFhbTjQ9iJFw3AB8MnYec+CrnWCdtWHSKFETNhmWefdj5TkbfqKtQ9NWjOgR7InvRrau9xKC2LSODks5ea4LmUFGSXFV26bBqMcxvxmHYSdF3p5D16/s5bP2Pv//aO2ozVzzrw6LQ16tNE8KHLkPTTore9/Y8+H1UYOXkl2X2CmOfkgU2qTHD2SEa14KoGipcuTmXVM0r0o90+g59nS90Nn9JlEzgb5rZxVDGofrJ/nLhrm182jK/pdM7PBsj9RRZAjTloaGCJwbCnpgTdA0qpYchmRQDKhYpcRBmZoCgGpKVKLjWDlpAaHBoCMIM1NrhIN5JI8LLTqUQ1fVK5N6Adjeys440vkFcI9ZlR8KUNKS82TZraoBCDpgUuiRBphGHaSVnaWeFCjOAXvXoVR81sGOBGddQVTiX9eZpq7byYGPwse8j48cK4bOg+YM4wu8h0WQ/EAIK1di4IlR+a61oE7VxTOLmS4Jo/Dl7VTETwJzglgrL0twH4GqR3rwJup/17IOq5tIUxyAdtRMUltaCCCQggh0kA3kGbQpZrSbPxee61zJ+wORw545kmJzidJiUJ4gMiMqG6Zmk1InehNqh4w8JgV+EyixQKsYwXcD7+seq7qYc2Xx0sMEwexkC1BwjJjwfoaSyadFEF5WFIKb68nLvDpZtSJw1vJxmpAtk7HhQb3lHHLxGZfpjiGNlHxKWrXrWri+gUeKj9GZNwV37Ahkih6tphakFo1qYi4xVeCzw9hsmSPO+1Ir23JUXY/WEVrFCmsI+axYiX0NsZoU5EHqM4xsYr5Tk6bCrmK9RMS1EsWTKlJroyXqialpY0oRAvKoULhyx0iy6jd5Jk+EH9lLwbw3extgSmXciaC7ivhx7JS8x79ohKLCFaxg1aPWjS6HMKYVmPMAEVUz7aL3AYHCEw3Bgq5hnGMIo9HoCLFa2UhhMNCRPFLohZ9LlAXzhmgRgbrCzF7nyyOpGpgjeh0kGQM67slq6IRKgbuo2FnX1cYwjhrHNoruc+vCopO7sIlcLgynxActBkTHSD2Rqt1D8AvgLPPACqpXbJtwi/KNwBa5YClGkFS83oEMnNIV0VmLK1CCqjAwGC6kAAeh96lfhTNYlt4MUDi1RMEnGkHDN+I9+m12f4eNYNJk9B6GmZ5VqZ0xnRJFAmWAT8EpP4i8209HB4dZDs973ddDVkW2BM01t9PRx64jUhoJ45ThWDNroDkCTwbegd2LBCsKLCBDmZVVan+6Oyw1WAaDFXKhUaw16GNC5M92Xy3lklJWk5yTUCfATBT7ystxz6pduEwOQYLESHLJqOb8sjISysRL1G7TGDtV0umKH2TNaYnGlVQu8ULWc1nc2QwCUP6H36Y/HNfdNql1lsRjbNb62dVnfnAO5ShE/a25wiDJwAVDDESmaSVQ1Kno5SKPrnhupLR3nMwsoBw6HAHBUGwq5qoJXRudK1K6W4TtG8IZBnh7V1MPN7egszYQpzQu5/bDd9s3/uEtUzoCSU4N7hSdxPDpRDImADHkAW/SVAy8GitS4McwCIches8NEg8akI6jWceBAK/cHkX9BfVQbDr2+Gr5DKrhDlCyqyfn7FlnPWp2etENGhSOcBREh0yKEsuygI4hEgPtrkliFAGunXrdLddYW9C7Rpm8uNLFO1YqR4lkhdlyISgNN4+b7r1LP3zwaj/y2b6mhROv/MxCvkLuhW/+6mfngEXNegs524upBRGZLkfC0TPrSuU+Yg1fvM7hy2tM4HRsG3myH4Hwvll0yGnbW/d2gmwmGWWAsc7SBtfbwzcVhJCt43h82nDLMRabSBwPtlx1XV9b881aM2g3NawL9OcheBqGvPQc135Zq6oN+iSnCJMl/W0jisebJ4t5F1nyUAojKo02gZhtRBxjqimEyKj78ofmGdeYDjBgYidlVK7PMTB1j6R0XfdmOHYcB85klA7qMmzip+MmRHBRcPeMcCjljWZ5kPnmQ+mrrz/1NYRvJEFvsMB4P8LMo15VihE6f9pwnHKwcOXX/z7HEIrnJ8VPi8rc/3agIlHrLKbGKU2pDugN//xYe9ARtJEoL9x4IUgltgkH1lIU5RBWg+JqmDmS3uXbGKmq5HFd7ZUz8zTQGCp0CZM98T3jM291P1GAxdt9IR67VFQQPlopXR9kM+0M6BAfaOKTfpr4hgJ+mtH9ewESFt7KdxbuAxmf/GPvgdRtgw3FiqFomUaGMm49R16C4slnG0w6YCHM56nfPB9gP3vr2BCvjlL0YfNtk71pgANPU68FItnhJ0ExbjM8v62wZMzEdYMNhBfW2vnWAByLxciTC3aGoXMaQOR5QZNlbTFEx5XqGVKHvKXmfA96au0H++Ea1z0V6scjPxV89CjS2eXJAjpseNm0NbaGeHEIIXLQ0NsW9KrkuXhTXUXWrX8z5NT4VvIFKMORISHt1HX1yZt4YNPC7HPSWZmVw+V8di7cPz6InM+UmbIW+dzkYeDjD+h6RcBsM3klc85FTXO1+qvfkOJgzqmqc0ByAVAR1iiAfuxVV7IjXsY1XHa667qfIpLjnkSOMNq9Azf1EGbM5MQcCkuDAR+1tiSdkG85ofZcy+efDiu9iNA6/HuHvPn7FzS11n4ku0t3g1HYUOad3GBZpnCV1COlR77CCR+hkLpihyy3L0OBmX2isZ9xeiZtOLzs6ZRAE+iK17V8SSm8URbiH72fFR5qMr1gCI+wNoASd6UOka7W1Ci9k9q4v8iRZxFprfDi7SbyTML4MaQ/gTmtI14KPTJoFFI/Zp20zUrdPurpASEOH8tlC+HfyLrww+JPHArA5xHM+gFO4v5Vj+5WEoGycEgBzl+oK43KySflf/d7hstO1vSUUurigmUnhRe0I100BiWIThjnGvayqZeoz65rcP87b+/fbxM1kFKShMfqNhOSwdn99Qcqnu8bljqlcTmenFuVNnMmyaHbYI7jwcdH/PsAHojsz0ulqVXmxYIT60Ec1DefFLA0Mrz2xZaShpRoxVMhJQmrhL99fjzly0G28nfZ8GOW40s0c63nHZYfrhU9XG0LFjrb83FD2xPrIvQwZDAfS76Pwh0J4HMoHiAOLnGIjQxqbSo+IFTc8pWHOo1X0zSjgYXc9HUmUqecc3Sxs/7UIwTER2cZKYnzeixDgRwPY8MajakD65pOJ1keeIyqWcf7tek78Ts/lG58Tt7rMDdpXAvx/uMIjp5jhFjH43zryo1Sf1w6Rl9YWdsxgICR3fy+HLO79Rsg1RsgD8C1DcXMQb7q4/DUT6pJgE92u6mAabuSXHWJSz+TNje/mslzaxFfDCPxtbHA95+6E/weRwZhrlejkieeNjliy+/CzMt0YyO/FsAQyu1Fze0S0iuYaSaJYRFlEFPucvZ1P9iv7Ef6o6xncu1iCCG6XqN7GBbuYBbOE1NZ3Z+iZzJu7oPXnhs3NerZnvw6HtFH1a9TyzdjSlM+lJqPjJ3/m3/7a9d9faf01VE1nGDj9Ot+67JMbZEgPmygA8eHC7FftXe1fpMmm2utBCFDw3fdpF2kDz+g0lHKVIHJxg/vIwkIQLZ1XJlsGN6s3w5rQ0XFbRptZQjhTJqWrO4q95wMfRrpQ30TR5LTftgDTFwIdX4hS2bzENkrqOQu1WGJASttAm6TzsBi0Kyl3FSbCncM5FFe/+130PjqPJMWWyZpoevm7NQZxjz18GuketRcPjC8bQcRYTdv+6EdXmNUsp7JN3kTXcm1FOfCIQ/wHgxQ8ubq770j2CKt2Ox5/JpFCJVNc34n+ASXXCMX6SGw/AVwAMHCL37tweqw7beFZjmwXXUqSOAT9+BBtvtUx8ulYSI5k+Jkt7jvn8aqn4TxTgOcRPnx4aGi6AJKEG+lVzpIQWw3GmatA95moaOqk8ewhnG0Pt3xTSph4A1a7v5JnM65UI0cyMw6LzmGAQuAorXoUdQUxzLpOYqRJnFWSI8kOm8T2k7oO+ibhtuSnTNT3MC7Svlu3jw2xUxja/Lo3q9+JMtx3+H2oGK8YXy9F9nuV1QsSPgac37/SSs5Oe9mDqikshbMUU2pflyxGXx6TgPLQjq5cbM/kcP6kh/fXtKID/401S5n9scKIUErtGxaYymWxSE5+cAPI0tdykVMO+OGdYZAj3gOX16EPozb47iU5L3T3NtEH8Oy3jNEJ2Yyg++dl1DmaZqDhTSLp/P4BzhSMO77Dze1ImJIaaYINwAMCaAfWrJNkmZPQc9+alKxnR+/9dOTirlCkBdQhwXf+YRRN7Z29gekpkmHGx7Yse3kC65yccimBGfLKZUX8mEmZmonoddw0N68fAeG+z3eN9xjz1dp8MDaa03jXCiVLGb5WWMWEOmGj3NDJfmL8FUsZTVlSzf35GlOINKO8aTFF/TTtJGd3p767dCzUgmAhpAvO02ncOX4250qH34E2QrSwGmbZ0SsECiYQzRpSsLxZTUlV4Trsq9xv9lyPl3Pt/tNLXVA0HrjEDpS03vkYfcjccu3dqm4oqjNeirkCmNH15XBthVtWHOo9KojHfoqOJHsKP2GLO5ca61KnbZIhth1c2yEnGZudERNLFHR5AlRmlrXtVqPAymfLayrKYVJ/MM7AcW2ytB1IY1+eCC4q2qhyH1aLLXWwkHfELQubC3Q7+1OBSaVaRjK46w40z0pAMTh6MxXSAYHDew6A1DyafjUfMWFmAQ29sJ884zNmGau0IYH9p3U2pXhCMv6eLmMASvDxtsGUaNzpRTLB+1HVAEgWYtPqrIJvFeelxgNmoYJ8miqP2RXg4PNvKb0U4h5my6zzyLy/a5tjCAxo6h9p7VS9QDpRBoNkiPciQ7xjHZIoylx0ypi6hG5ObWgGKZz32NBFADA9qZyjH7X8vNZwuHF7Goor4ID08QUOmLXO1kp5Bvy9oG04bGUbEFLWc7kkNJF7PoqSJ7TkZLJ+hnqAB/pmUKUJmZMDdumBsQKPsS4P87L1WSVbcWIwpjkQaggYMs0F1iG2brAR1869l0Zu9oJT5oY26s3GoZpRAqe0zLwD5tQPqvsePxIMak7+MPIaFQrBaSnE73saX3rugEkcsMDRc4wmstYdBcalJ04iuEPN1yPx7W57x4dGMe6Ze1rEs4DuEIiuQEKm9S9SifpdZ5PnJ+pO2OFvsHkk2wzy0x2G2XeQQI/B4/nZa+Qwpx67xd0qfJKbgfMd1lPojHgA48Aira9uykFbkDH2LjkR6h6BcOXGE0TMqGUFIFdu1JaJ1lpXYXdFH12PF8VuLUWI8co52v71SiomQcq7+41pR5vE6s/Kprlo5BDD1is4M5dfKI2ZXVKAhRu5Nl1u9v6IH6mhDsFO+a0gUoRA343KFgj8XMyG40pbeXpetDbrWGm/klqp2AQv/bozZDfPsepd1318fEMjoFKUbtFHMchII0jPDdhi82Db9E2uBAox5a7oW/zK26rx8ha+P9a/j4Gl/cGruDpTlwxSK+Jk5MqZR9bzsLimLM0oWR5KfmgXBE7xnF43QhsXEGlzqRYXVqVBcxyNw48aOFdDNF5oT4VKgBFFToKShp3/IkFg/V2Us5OLn8njNnfC6nBr1LSdSdUtAiO9lIjc0qpqHQgUSwv1hGgxrYkudbkGVjnBDBWl/NCKZsTyEBVfDsh48yMNE+p6iykPAFb3u5V7ljpnM8xRwE4XPbyDZQw0J3m58DRdxVotAu49iKCuHsfAznLLStPuq4D11kK9LuEqqBY1yWg99xx5rUkpoMsHLi3X8aYJeeoPuVzYKcA98qDq+w7My3RlRApoXIhfId9/XvzLEI+3ng/FOe0qTbE26MDEBXm3yE/sfg2JnUuOKcoMn/B25adGmadUY0jR608kIZPWgfYJ6mifRA8MQ5TgeMo50KZh3YEN9SnlSU44eOO6KexG7zjPOfNorQwx2t18UvizkeywXkKnWVNqn0R0q2PY6n1mMDzybsqzh+nVNoDtP9xQyvnFI0bbiQXhgr08BCwPVXGLOLGxmhkQOY6JQci4CsKs1H6vYuZZzToQaW4iz7/KwasVEuN0OPmw/T+AmfH6I1KRlxoPTT5IASzlGrpgBa0OVGIVwJM8R7zjgit8TCbndC0dH08kmqQoCewC1ugzsUvCH45P28ewxbob5Bbw+2kTRQqvno6KdOi3UjTUYSwLRZsaCiFkxHWPvkqO5SQYBIqCg1Hi9I1FhAesPqi7EKDwdli4/hj6yzyiMApIbP6T+w6RV/Px5ODZQ0X6MetK694BcIPA/BZAc9+wwqwUZeXR3hP0EsfMGK9MLdkPlSer/VewIV14D+yJL3TQK8z2uNYZNRRKg+CqbA2FnWVE2ZhP3zC93FecduwPzqkNA3WK0DHOMvJLe6BBQbFPVDKDDdzBfBSTn+9qlYpAskpInKb6D+mJODM6sQSYZFDYxqanLQUVQZLpkOVCTgstEapao9vDI9Ppbyd8pSf2eQLrzj2Hzf9TuaBHM0iY1X/Tc44R8Pc93bZhyk06kyaCDWgzboi+WdVBXsGU4Rhe68Tg5PZW+EZSGSeTW0aXwelF1CnjMnvn0Mecq664Csye37eIuaz0+PxpQV/pLkr6zSgrg5ygzDbvi1uXDWEvKo4rFOMQ4zrNKQtbTgQT2ALjkQA6xwRj8AU+KE4WSjvKNoC/C74ioCX04tc3fgVpyXFsLi3qMbd14AUWr5pENAD4ZjzJv8m7XXtt0rk1VPllPs1Lz4XRvT/ptO1Sj2kqOKgoY1Q9GneAcJGr6nj/GRj9w0faMtTzmxtO0K1jF2vR026djQTapxOfkDQOcR4RZQOxR2AwMUR3P/LE7/vptKv5+TEFVhypb/vVzWfu5u+af7MpW8RJOt4gEowZ0AuerS/OFg8Q2SOnZx9TT3tENAQdMwLr1iCccERMXarOq3+uNKLZH08/6LZ9rfsYpxVhzFZ0o9P8cRhnbAI3ZuliRJiBjMSBmNOsHVOAstn7sx7zdwOGcOB5LtsGkd7szMpjjN+sRhUXafZDY3UxvUABvGfi2h+at7FaGVXFZU0NASsYKQmgtHAseE0qZizENcAdLl+3jiFviwsThO0w33CIWjVYz354LxofuR6ZT30XELrg3N1NMM6ATR9o/ig3/VUpZPH/Sx0OiXTlJ62zKWFjMguOOXpni5gjc7hh2PtFimgVplhGhNNUJeurdejdVZ2PTGui+D56hPmRGJlxJHBS39dZQDYY9Bj9DzgDdwq/agXFP+CfPMOr30xZLS1gK/HlBYgrmOK6t7HQJApSHNKSkHN0MxryAzpO9goumDTA4YCLUuuk4Tj6PRqg/FVV9KafCYSkrHMh+yUdqVkjMMjC2ILo+wqxci7cs4FnC/5AcqDDll3JyUDiPwCj9Cv5o1RKJlaVlLYrPhaFVM1iUFUit9dNBfzMbBi2fNRSJvhc0q1sghAEhxQaytcgGl9MPkjLljOnMDHWXWCd+vqd2tqD14oYWz6vatCN2MO0TNfmSOUWvGBPMfvlIsN0zjCHTWCuVZOdkscZvi0nfDcrtXwT3QAluuwH72DJGVrXhIq7PBM3jEAecZ1qmMjb9nFKJvm99SzmnvNbLGLSsfA1+6qq51I100W3/TD9Ke8aCtM1JKuNPSQH7z5Ew6PptF1nDtui1joEG/2XRjIewHUp90jIMbFQ4iRr877d2xWYMiA7zKPH7g2YlR1lbtDz6LcuIqtT+Q49OSwOpKkIHX3gPdX2KO63UXX38cDjhd7wt26CX3H/tUNH6QjAM6BCwFew4ksNrHJuslnf4dWD5w8S7N+E/Qlss5IHAemgiENliBefVHqwQvmMon7eMbvkK8pzQut6SOX+TxxdyubBvtI8jdnybygzeBzPXXojCvyxa7oujtihn/6Qu9VMCZLygNemz84BkY9EaMCKAF+QP84habkg8HbYf1lRZUzOyja1GUjk7kDh1u+qFJdMOKGFZ9PegHQec8zjrI7B2rNimzjNgqAV2bC5nhnFgKvdL9Db9jI27sxHPPz7crS9zZHSL85sbocjOTKDEuaOyaD1D0eVN/BPkHQnA2YoPsH2Ok0czqH9VsPcQ0qycqpruRKjrKERNkLsVPmcGPeqt/42AfZxrAGNceev9eSLzCF+ai25uNJht1MOp2S0+fOx3Sg0K1zgkAKx5/x8spfkqLFubNBR6vbdn79276TeSTQxNpxYagnhlmohTonHWqwMMlbzas0Gj7huwlajQ8CeJMLnjaCyMcKbOvq7nj8ID7dnk6usj6J0edtEPyKfQ/SM+507gO5a9Nxm5d5rogWIf9ck0nXI8onghun72b4PuqEzPxZh8M6YE6P5D+fOD6vAqRvzekAxhCnuMWC2MOmaSJsy6kJpSon3QmdMhydsK0d0uCEvpcu3S5aMX8RYeabEVc/TrlXw9b3iN/qIwfuR+z4ccnHS/UR40GWi7aVlrty2YA3fIpRyohsAxzxSdHfnkHrPP6ZK4qblkoDspn10CMKK2dOvBPGmy4Kp976KewAJN1wgXLSnc86M8469/JJi3NjR0sIB04ue4z+PmY2502wSc5nmM9+mmslfgYAcQE6gSBCzno4yDzLEyno1RLIXVBg3ri/y8Ij1uS3olBcKPo5bKufhUFiPjzZSqM+b3LJTDmU6dNvW+dd2Qfm4SGEgc4ljZSpnXDTuuJDff/doa5KsBYpqJ4NVzx1kn4CQcZzkogRTBPa3mSHGPWBbizQ2+8ehsOM65KTq7EzvMAWl7M3hZjtpJpaDSkErOdhkMqRFFi9Ojw8cDpO0qJTEpPg9KbsNRI2YQfcmUPJvxri4wAeHt6w6HHDruHC1KKGhAfLXA3tFmgdL+IIxDUgEt5RH7k3dfPQq02AHtXkxFYyM/xLIzrOAMlxVv0rhr7LJU0zBvW9CCIEdtFWnucUNk0Q/AOJ+or4FsKYfMH3LuHA4MMNXI/YIa+qa7iIlJzzMz98yLmj3YigRWd2A5xDdyLKXtg0GMEMccfmWFpREQMEIBDRKKrKEqJHqmW7bqUIOMolduHArl7xgCYSurLFqLD7SNJmwqg5eYLsQqEe6ZrontR/G2RZBpS29Q22fIxIwLHz6EU6KmtC+FEIUx5QYyMHYC6xNMeAKjHNWA6dMC8UzMCghL4aVmgSVif2ue9EOo3AFpOhNUoXa5GNwLlnUVpspmLV6wprWb11l2sB6wRuFJfPHpSN2Hzb8iCG1tozAocK3zwPfvbatEMlej4gY1I2DKXI1OmsaJ95dAC34weOz5S4qp5Y2CUZnXL/sPNFtW7sHbQ/LZkp32jVabUf5zy5Kjd8Vn3U63ae6NRoP+zNOtMaK3REA9ZVCOuvaYh1kX/K+FJXCIZP3fbz7svOKzOhDgZ3eaKDIYHDCXSDFyyDsdWihfZeJHNrpszXNs+VlnAqI3Nchr6QZSXXEpZDBSoAAOSRsqKwuMmqhLscL9hAITtibtftHfKYSZ7A+0eACcnMOBUpa/alKH9Mk4IV9H7pE/b4aLCFGe/wG0aQnB9OGtNFQm0XvWFn0DSYOE5GadC5lINsY3G+TahNu33cnXaeGge7TV5tEQ0s7rBNS5TP/c7L7vP2i04MiNsuoJaEXNc0y5GMx1Z0ou2OBxr1t04OIb1QRwz/PvtyC23l3tJ/AGDZiXYoc5be4oSR7lKFGD6jsIcSGvSyJZmmQtURgUNtPzLWVEBK54RUFglDb4EfOls4AunQnQ/JAQt9I5ph7W8P8lzGj4B8eoWVdYWN6k1zSWb3fn2Sl+rFklEuWpWyXd+51asyNSwSR3eb1sKTDN1cMB7Fx1OgWoG4piosT7RIU+BHpd852v7g2tR7pSPOnjQhGQOmomq5F/GEAhJPdThIGjP/Jp6Z4a1eX/ijO6N5j2sL4KQTMYQrtCQ/IZ2/gjQ7qYWOX3bUBrVJtJA98emXtG6grqr1+eQOiX0g67R3cHufNUIkSvhsMt3hc4VVA7YP67xnMv0PFqilvQQw2pnJQMT8K8uDoW3aFkeCYASP25Ee5US0gxeFs8AbjFfcy1IbZFDjG1UOble370dVkrH8BWOoOKNeLgAHCvtAFT9AR69iaLxEcVQ2YHhFCTStHd/+zoBvSkbvssQDa9sfDCx7rMZtPj9ifYM8VvcZgcC/YSwSM2Oh8haOJpJkjQm2dyTyldBseUU/j81MDlHbpKc/ubnFgMEfMvKEe9tCONQ8s77+61ScKikdN5ejiXCshur5zKgbpm1299lKYubeC7bDQmW/Z92X57cCU9HBi/nO1hgcki8TT950W43E9BYcQHrw3aT4mf1IIDCcWz8SB900qE1ma4ZwKovnStugB7cxPGOa5yUP9M6wV7T7KTF4NgyzQXeuZkBkIMZc1L9DX7wZ3PGKi2bowstMPjSlwWy9I3SLqS2z7iJvmy7AvsWxtCVgB/Y2zCDAImLDgxoFMTz8+Dfp/1YRqfHVKLm9EN+Jqycdn93OkUjGDohviPjJRVBdCuvjjheliKLvt59qUS2rLmfm6lTQ8ykxXpudmkXE6NNFIF1dKvZKQMQja+Tozpq55k72FbfcSHBY1O2ee4+DIbDqyiJIvtkSsHcVzARgdoje8UBwascZIL3zMBi41phP/JraHXAn2VFZ1GCROw90IkDQ/H00tabhT5z2i96rzsskIj7VjtNshzl6hzNX9gXi17TwHnz5Ni5bj+l+0OWJd11mQPkronAWi0ukgJHkA0upOLKC2/LQzB5nbtIUwlfIKyramqCyjK9JXos4vCfVRY5p7G9JeEdjX4qWknxQM5rdUw6L5flqsFtwKDxVHJqM8tW0y3mL2GLsEtvP3yR3DvM8ujZhslWIr4m8Gp/vo6xqdI+6o6Dlea/YUW0sW33U47DdLwtn7tmVaLc3ojH528cXUbCX8rerpifjeMh20ql3z6Fh+5gtDeDT1GLt85KKPAkhxfFG1W8RldeWfpp8dv+vAsgwwMjEIp5AutyHAU0tAiLN1ifERE0SxsXHzvLQ7shDqqfPuw1Df+0HckdbbjrxgZewflDmfH+2PE2IjcMKIXtTXBRO9r6/J+tZDgmEkHgsKhAADFsmkwFgdCJNfTyW2clQGg1BBsTR8u63tj4CADeyuLKzavCKJlnBJhAlqFIIwMwFA6nlQHhHyDkcKB8NIVeBZPOAm8k+4N5QlgCINnQMgw0UWTDoluMiN2JK8AAENtYJOwCiuZDxAzB8M+K00rCkJJUQK+woF3U5/2bwoRWhgTWtGP2uc8qJ5ZXXbQ9okuuFW1OfeaWtwow3XbSdGVyiYf8mSA6IyCumENSY6wJSCRkB75jfJSAc5XUBf+Xl3ak7ZSdWMzDSaHPbA+nkEshMUae3ElOybA6cSjgQPPZUGpauvJH8rqauZtm6UP9THCzXnYXbHnKS64BD6+QwkOQlMnCyHOhgKTBXGpay8yL5XUI8y9aF+Kus1VzrqiPkOHLz29QJuetZpTO8x1yA6QUlZyOB4Fl1pmFr65cukupqlKLbLuhv0cK/U4irPT54uGvmrupDenbGUA7dEHqly/BnRYcAMxexHBnFYb5iGxMSginbFSixOrMYAzK8KvnA5kYBpPdZweBWrbK8wRC3TZy9hXLBHfCMhCwc5fi9GXQ3356Zvvdg6jxF+/7h8NPKe6TX6vBklK21X1O5zR8d66kJX+AxZnOM/jEjqXAANVgCbD6xg8BtTgprwguJkRVfGLcysLap2/8yEOkGHlf8mZ5R28BrQlZyEQ3JVBK7mLeozNHN0GrJROfnB85ISz4fmkhlaXRkZ4OfgRLEAMb4xNpMJnQtwhqdUjASOYuVAFOvRuJEv2AVGssKvanoVCCxOkSkaLIJiL0AqQvhwVIuSeOmCq48ARAVPNksAD2u0qJljn0y9J0ShLa+68eum4PJ6Mnl16iEQdDt+X7bbcqF0I/97UcXAbjYaD+WMRgUIzgZ1dvfb7q9V/46K1mCyRDUajBNXs2zlBhebbJ2SqR2x20i6oZi+bIoeVQDDniRLBE1cVOYIZ5nwEMk5gjIE6tpciv5PHmQnSnZasboW1hB2PRKE2tXQTBeNbO3H3Rd5LlSz8jRhaD/+8O/PpjcImp7WvKke17DfJwg63IMneUcDSo9UMmT4iLWYoOEyfBhzvbBdNpYTuSBFjergiqd5zhnn8DNq1DQe9SgLnsGkiLNWEguZswjs55c3K5bZAJ8avaKbQ3zEqBw1daEdauDNvzei/lmUmyX2HuvOmuCGXPEmRyMuhfO5/vKcbFXMJZZv7t9EGVrCx/pwPNczGGl8xSEn/iqVQF+JGRH3FrWMKOLHcWWTPKM4KSNFHd5/0+BHlwe8y+5jBXZ5VG227Hrt8Hevdm4Cwdx2OH9p/lICDa2zLcpzHF3p1/u8Y5XX++y7XEpIz8iC6Qx9uLdjdY1r+4ZsFP8twqpKAL6SCfNdfO0TZFklHWEcSLI0T9OjbMgQJwh7/qBwRa6PMLQ5tA2nVAOt2p0p95KLfDwM2Y/Yt8yC/GBW4BBeLlj+8g3M8JdFDku4CcFyqc3xqQGNWbHtzmR2lBIL5t/RLyT8vEnO8Ye5XzJVviJcq/0DSkK2u7naqEB4ysSbL4JB7jyvvjKyQnAxGVahDqDBz5XQvFnefH95Xa1icKFwOsXa9vwfsrkLAeTwUJ7nQCOq1o0FP0yC/wI/Vwx7y0nYgLEPumcOKrekirQlzyNZiBn2Dn01iYdHOkcSSDzb2wgQTKwqEiFSmEqA967pydB/PoUo5fBv1VxGazfhRZIuHbqr98GFrVmbmciWLR3Y47OjQgrtL3Q2OxtzHu5X3fSltNsY/q83UfdlTW9cnyWTfmB61Yh7ucNk/xv/dcCLxKCXJs6TsfnayMhzuaiU6HHbAUvcxLGSVNHnB342fKJMCAxGoj70Cztg4LPoUEojn+kj5XaxyoZ1LYK5CQvbfeIgyxboH+2K/x1NaqqIBisMJUaJqS5vwfdtdbx9OBwRunLaPDhi96rj69S9OiunLZeCZkKCBQmY/PzrgpANNIVhHY5VHUWNrYWOd9f6zMGcLli7v/1KKMIIZlIjlpQtq/AQq6NC0bPCVDieTD065dzWSdZ/jWZPY+w2eCMQEIldQc0u/8cHj7NXje//vFF8upGzqteqVkhCUYoT+YbCW6u3fp6PImtKTFHOcdkGrKkEBVCMg6GXKMBESg0r5qKbUtpLlJV2rNaSCX+Jxib7XUSv0570117P5VYJkeFBYTlbLnbrmeFA14rEzJg3FZeELrG+zmXsqg45kRzwfd6Cyy2PaUTsmmq7IDnmlhl6SxP6STY0J3GNdV2jfQebkJVK4iJzy/BFaqKUvthb0JVJd6Xqb3U9Exa0tjHdiZNGEiEOThcnYsYeTNVVoZBHWHSImJGDIED5qXmK4o3GNTjp7UKvWyYR3WuQkEA7B1xdwproQ8wyb6gGVbZzTcFtcsFwZmb6KW4Y6vEQO06eJHILb0fwLpGSaC5cjlMi3kzo9+9ie+YrnEBYLVZbk7+CQfUyFHx2ewXu/fNAqXRf2nnu5h9dTJevLUCmmk0+X1xnLTw1iLurTsYztycnpECdE6PnDGtljuUa0QlaFtKkM+phd+iDJ+9lVhHmGk8y/ktmyacZyAQS+EcImgm4tcv6dR71bj7MOrUyFwjkXr+bTlwqREMoiVJsnvHUN9QcA1hTtz5CxZlTtVUHorUMALM4IKhyvK7N8BUhsyAB5rqJDUBshnRgGxXvg1ZZQiysmBS6ljCrwcWEl2ZBBu2Z5VdVH3QmSVxyL4+vxesmUQ7VkHuGzB6rnOxa/Xy8jc1l60GLu1XP6FbcVrWJPt7zjPFz1iN2ZzUOcuqeLFfDSrkMuzQJKaJN4v4KMD0RcenxCcRPEOvzM65wLfMzvfiWTt7gks3YkWA9+oJIrfUdufh+exgepIp637zW2sLvz3yvEGwe2fQ9a+M4FUsHrrhON65hTj9moEgIESN3nnr+NuogMLvvhMsFvj2u2Ux4o28xXNAeZlTlsrDI6DmpWBdpOSRRSPtcCqSUf3RRgTM5sdQDqOpyLKNn85hjjzSNccn+sVrmsESQchw7IRDnNbPTVBH9y42r8JMkpn8SIhehcApUJzR1FqXomcR57eqnwoqB6WzJRX5SWZv0yhxlqDtLrD269L76LDOV8d9wwyPymcs7egRUlVvK9fQjuMZIh7KPX/R9RjvI5NoxSo23KxslCIZAa4LuL0Q4MrPr4rvHkM/ho7vAJYINzrMlcypsqZqseQECQ6iIVMxVQJ9yiluiSRVWW0FMG5nDmYsuIIN8yaTOJEMFR40wzf+ZQi+YDBFbY3wRyTWUeP1X8+MnH7K5yZiH7yRXC1NR+39UfdI9XpytRUAg/sdz/CI/mlyQ5vz5ltBOOsRHzvnmiUGyATL0IMGAit8BGCxW+buQM4Lb7Lp1yJTCrv5ivXDSbSiufw4x1nkZNL3cxwQzFOqlGRheeLJjOPESzvJUoxQ5ZwkN9UXtJGnkGsUfRLNyAUDoyCY4yrpb65ny+a0znD6kPEacBLoRvmkD9nDYZJ8ly8O3Ockbs9cjxc6xjCFlNOKy/DDfScAs295g7hPSLFOdNKNm/xJ3BNjNU0CQztF37OMclPXStUwbS1MljJIn7YFEOpfMCC6nALp7VMwxmYYhmgckgKF0WPi+hVRoPk3gt5DW4GoGY504VQqGx8LBClGITxXWgee8J4w0zmdBdANm6IU0K8UPx4ShmkHPmK6kKAi6pjaVZJvM0nKLS5p3VAxSpTF4f5xx6KJ7s+PDC+ftUwQkZXCZsdPP7g/PXX3XspgL6MqcXdwUWdUMq/X8iU8ENrdNOCzc6H1IORhRcXyo5B7lOwPayZbkuGefPIhHXrMdgknBddJDjivHq6zY/eub4ua2IJvjzzc8X0XYSnUBW0N3cn0/WtCpALNe6ScitRpUoONbra6a6yVk+E7WS9bFT1ImXtL4V6Y02gMfypdRdWHc3aPcsjhIP/ERA7P7ekr5FiGKB9GSKsGtXROXCwR760Fg7ATzJ1FKuyKsouQ9RwDAifd7LIkAJLMDc5rOQBjdKbN/pgFSsLIKOFNZgJkgGOYXrjJsT93rSVm6hT6o+5FyUrnZPj9xFQerLRS71FIvBuxZsvPPihtnnSUaDnSNIuB5k5akZ0gkUVMjmJUZvRaGB7nFGIrdjyrqsMx5qArLHyFrWWz2Ia3YjPrneAHQJnKhZ74qqCvAgrP4XaTuA4oXQ3NzsVRmdXNig/4ciA1Jjl6gC6NNSUGLOajg9cZ6iTwrVdDlYpkoownVtKTyUOeuiBI6fliC66OjvVMdc/m8kZVZo+oAw4TFbl4osUl0qips5ZOV9kssZOm/TBnMj8qsRlCAFRunSybEmYN5kpLYG1zIdajZgH8PS10U15B/RMUzJ4D+j7wiMfxKqxdDU6bvScYLBhjuTgIVKixdQFIQWjLWDCHcAugjsqzWgwwudX5ha+z9HKnAuuJxjxJ32Uj3UswB77ygFczr7eM7M5cQRKBZsWLMt8UYq4yiKWePrrOQksObAlunL2du3PWNrt4W8WRhcLNkVuqor5mpQFR7TgsL6D55EiTuP+ma0bQaihRE22Ld0BigAxd4WzfgeGetyXdwznDMVzD117eEmEQk/OXVRR0dc3BylvuWvhLRlOGKIgyAZ9lTbVsWhLoNEjBr0KFIsgnnF/qrddGKRTPFyG8TsWppb+FQCT4c8lSnMK0WcedFXusZNcO6QEOgnaCFqov7969D6dvwoU7+Jvb1jwDnGL1FghdoWniNEJsqtSQYiNkYc2s7Pp4jVC0kwzueNpXyCtl5x3D+JRo1vf8YdiO0f0tr5I6Skz9ojBhC25wBJAzNWc16JkY7QUQu5BW5B8CxqG56TVRYR52ja0ecuGTUkNMeUPEumAtKD+JTT53fWDIaUe7YSAJyFq2kGXAgyZS2RWX4pbJWqle63qavYJefcNEDth9qV5wAoTQ2rKQVL4B80hYaDIbjvQZ0MG5utIkAB2I8XHO+9sWl/S8RW7TCEA3DzTZ9e/r0D19EsYfH/1mnfXxgQ/v+ttB9O21i5ZBOEzfjJmPAkvB+Aw6+YotC8TyTy46kBlOw3JE0OPv2IiExsZ+ZydWEjlH0wPBHOFUayIzb9jrbtiPBZLSe4c8HABQUMX3kNN/gTZjI6SHqBXJwz6jd448/RVcjdRzL7itGi53sGoZC8o5lj6yYIfMrHFdSd0w8JKcqpiGJlnSPKR3iGNZz7SRE8/IkrQJ2FA0kjbe26ljVTPSZLTazeC2SoaYnGr6eC75LOPIUt+A9ZTDTgIo2hG7L0Vwf5H/MmJs8uMThZjGrfQ51C2+HJgkjH60BYY1xmqZXES500ZsTyISDLDoXA+DkWf2tvntbXrg3/gpFDBgQZFOT2kaWm6GXYPKOmFfYd4eyScH1Q/5huwYWmS4oE/5NBdNMb2EJEY7Jb2XgbjUwGARidD/sjQ24JSpmW90p8EnOi5j0TA82lWh/NbEASEH/olKLrP9L+V2oKmsvqnNqFMxRtUqFaNlYPcvxgKOFC2UjZpijwdSOrWg4KrEYtBgdg/HsivyT0uzLTYbkG6bOnnV3vOQcZObP/HVjObweIxDLO+48zqsqFUt0Zn00lS7nWd91vDGTXTEOhAc9Eoe6glKUmDVP3Vuxp+tvM+/MDtSKpgXw6eRLm8sJTpjDSzSVoTjkOgDqcujQMiPEMyjcKmZMMH4IONmjoBBYdH4LhcNxMbUMIGB7CC6oB69cjoJ+mDctqzIVm2RtkOgCuirRi0lmm6DaaY5mD0Ro5lQBpjF4sLxp7YECvAPcDSTXHhaYM5NG4Nyk6sbB4h0RYdIbIBaTZwc4a3JEI6TGLDkMPDinfaq8P2GSwmIq+BK91mBpzRD99l/9FJ25fw/h7nu5Vds404seWSYpRH32mmR034heWhKgAoKEZXDSmToThjqC2YC4lipooHBqlNZIE7PvckRYir1gaCJocAFURBzcHbrDmeYEpX1FB64KzI9658oVX+MWY5nj7Yh9DBjc+LTc99ZRrveAnTMNsXy1bNZ5iACdql5rU/9hr8rEVSMxZr70RHnou/DPZzM8g8qKHeVMpEGHSsPN8LpvPhYlgxbytjUPr7dwrC3UyZBrVBbeegoEKVIi1878CIX9BI0YQpCzvz8rExe7VU4LPRKX38Jt72qm0zyQoRhzaSzCv+LSDNiJUjoOZwbDFxMyMxCpLL9QNI2VyN9dljqH7akV+9Uw+5S1Kv99Rm/CRZ7QMytHIBhPU4gYKLAPEHNWR1egs5HcTccxvSbBz2Xa1epjJaB5O5WgBH7hizWVcVY0J7PFRX44B6cRwKohl5ohW5BQeuVtbhE0mB9MXJZIU2HXOR6bd22fFvj2v0o0AC8Ll1p4+pSIboD6osuekgpf2jlw4LFk5ChSa16MCXZ5kKAwnmgu/EYgQocaNIW3KUz3aerCvQQUJYV5tu5mODEZNvCk2AjVgjArLt4nILZ9QnNWmPhYWz76fjRzPV6B/MyslKHVULQKmWTnkIKxvSoAUMWbFXUwfinjOkazB5L81ZSi5rwR9RJ1Q8FshIsYZDX22JMNI+i3GKgWQerQn8dVhSX3REEdGbt0hDQBrIf4G5/iT1YGAy7J8aGPxPMYJozI9t0+tNufvmK+EqIBXbdYiRg4FYmzJaVujZT21xRdQnx6knUHmyu+xevti97zzpXd82ayVt/g7loQ1WNzKzVMEsw3lBzJMcUboGXbFU7zNzkP8qAiRPazg5apSqRgFxb3KS6285u2P0sDsBTnoO7hKMNQoVrBq1qE8O0aGTkmjUnSizWpGrZVZqj6C7FfSDmDhwih8z4ELZ7WPanvc6AT0wdOQteNQ/JWMShC/2MADwSqsqMKni2OmUQpbq6ILP4UHV9/iyC1S9Ifd5mC4r6ABlSAdSXJ0bG1Aq1L8e/aH8NFV+BXmVT2WyyiUu6uahpMJgb7bsmZ+Kztweet8GVgOpVZ2Ouckxh9cmZ7m8He06tLfyqnV9wnTuAY5dstAU/8xqeppdUNHMPnoewLTqkOR5+w77FX/O5oc6Z/kzQpMvTDP/bJYJ05HmrzlhBnQGGZMwg5kvkrwOfpyqkaIQ3WSMYCTJCM909GOyGUp/6DF+BKQgq9HqG4VJHn95mP/z3Ib872mjBS1fDX+H9wV9LoOC2/uymhzeHvWeHV//7zaj5azvuuy6Cjgb3Lv/7q151dv70Z17T6op9lANbt+ghpKNyHwgdqcDNTz9si6aKVPiQwUFNpRo0y4NkY6v/EW+ajderAFyumrUgZpcSC1bFt2PEz6Gt08JmgwGMOZ7ekb+gata6L6if9uUmh7knQa8VIICjm9k0S05DJVy7CjDeas4TVjg688ml9ujdLG8rN8AVlkEHwnJcOFWxhGEcipd7ryVzzZ8xYYzaxVPjEXte1ZJb06Hr4uUAz+YtCaMuMfW62szBr2xO2qXyNvsPyQjHCCq9kf3hOTXIIGBXT/K5tJjN1d3P+fjjOQ6zSFBS11RrR/cg2HFkjshpnaHZ2+cSVjEsoBTmyrtfE12tlu0yGJhtLk29frYzrUxoFJntf98Jcb5DytepxteIy1xq/amb987PPLgvIqruppPx28xCAeJm/uQPtTLjdKt1SdK1vya2/N/u+tFOVzzLNAeRlVNoCaiLGo66MjL7cSxnVZ0Ico2+oY/oD5jr8mcPA4NmsbybZZv+uQWEdKzTkUjmDFe+h6WeuYs3zg+vLxswmv0nhO9RMV/0j3cdKgewfbHdxQ1FjkNU9hSTmRe3gBnzemZzplp3y2IisyNTCegotQWSWSHNbs7FDXvDuidjZf2LSQnp+l3rAeJiEWcrf6VOno0fybilfDacLAq/Z70el2X8bM0OYbOAgfW8F2TfHcNn/8u39TstYb2+dgrHyyJ79iz+MpWmkWoenYwGF8fQP7RBe2mbCLR7gWbqfPWi31Gd1J0fdkWswgr9Vnxii+1/geuNh1PtiNfSekWvajt+thSl8djwe2dh24F+JjDd6EjQ1Lcm0V17FdSp7lIiajC8l9YcfEZXmsHXSlVDuX4cm2FGaqx1ZkU6uaDxtYT67zQAXzp4YhnrgW0GzPv5kI6J4jI4w/er1FVUTMxN3SRbLm31ReipiPjthko+v4p3rqzo5vmzSbsRKUt5JRA1iPar8axa2vs7t7rfCuKv1sFYSQK0zmjzvnIsJejTZsDKEWEehVYRLWbRXJ9TqcdmpbtVqauGQn49UF5DzS36p7Re3ycy4BDV1NI8JK1p4RdCvHj994Wo8eigt7j+lEgBDusaK3Qn3jQlQItcVeCCecLrE6PPeOdHInUKSWb2nzhaRVhqX1WRbcvBJ0jcAOmhz1IU18WhBkQYbRNw/xpYwyZWSKG0UJQE1Dwv7B8bOsInjgo3BdX+OeI0xumWtt9qvFqSIVtfXUZbBrMmgrnqxbQE71sRDJa246gBuTBA3X2YNTcmPbuikGJlxqnwuMtZddC98tBPKXRhXirItkk3/4qRINR8u3q8Leu9CZmNXyTt/l2fF3R+m15tlf6d5gnre51muCmBEgj51fle1myWJkp0Vb7bRtpxdJV0vBMqVDPYzf/2B8AgsM4fObadCxg7VoIQAACDfUxlPbMuLaIXF0q2rGgtKXaKSp513PWISkVuYExYnPrw4uzJJzNR1B89Cvz8+sdP40+SAGC7mAx3BiaBrWI83B2InpFF0ZvEzIgW4Gr3SpEj3j3WGWT7WTfX3PXUgrtkY3bjtgAUaKIj8YjXiKGDCOQsTGktQA6l0gLYn9exyTRU8GjL/OhzgrgEKik2IDQ37zc2OU/NCuBCc1ggqajVk/OsT0xeVRVDuIfyIKjWLob95gzJcGk32Fu/naYlb4kEIrmzvHwZOkcL/kOvsXci+EMBzRosiB3PRhGkABeD/HGJup/5sS4WFqbIquP7HCuIAEDkj9su9vmKNDO5MIOdT7l4PwJ4mO6rhBcz3op0mlEVLEDiov4/zghrXFsu0XURxE2UWPTW48j72NnpozHy8VR4WurIOhNuvTOU0qeH2vBa3M/DUgpEWD0kmjRWbNdiu3i9B4cHhFzvShANsBY3LXCwRg088csEvRO7ZFOEZRgCFTltt0aBEy8ipVwobtjGpQj3Wq+lXxn/22JtXgubQDVclat/zRd+aV4rdbaej4hXczttnhZetEtF9mjqNo+87CXHZt9LyqH53Vs9LnOdywHrJdZCuuyuv1Z/XdukynGAPmCLFSGMZX4oOMJPFy+viSfuZaXdUDqa7VUF5wedBVSZuc2EA1sCCX9jfYw+7ekOvyTxVKOoSgr9rMbMvaCOGn/F0zlbcDvcS3+FBIXLtpPlzdaoWpZhWkFvmuZBRLge+/5wCNTZB3U1CQOM5U0cUMlVXGm92l/uJxLw+evXhWdbxzCiLGL4fZax4S2M3QJ8s5RBwgIEAifM2jTxotbAiVqO74Yd5oTFcOY+783WunnI55cVUwkW+Vij29BqvtXIJnOCytVm75/CjpL9GwtLiO7qrUNFzBB1aj1fc4nvFxnUfK/CrLtWYJP2cj6P3FLMk26f+4OkDWh15/FL3T3URDGhgBuR5xxuPvNaEfxA7J4KwASABMf1IEaURWiGjN/MX04T7F8Xl+V4/Lb+HgW0WmOS9jzN2+nHpaZZHo/CumuiPopj/eCTDG0b7pLcNs16YjmHvx0DPyNQgZ6oc1O7mQga46AfQemlWdEzAAa2OH0YrqiG0AmVN1bHSrRF0x4PeJJ/pCVDKVziQc2RVIDgDj7BKpHJ2JuE/LhwqmplDlYvxV2xqtQQOKPQJedmXeNss0NtCyrqXKeCTViWKDdpeJa4ED8ybF7R9d0xk3ViCxeS3ODxGbdfAxsykKtdVVYYQi2qoe+5bV5PDBa+ewWmUEee9bqxK8G1bA9E0UfT5QEtpYICEeOXs3BvrcrHgv4OHL2QzCMHBfyTKNJnDr0o/N21LQjq9MHryfrVzfB3aq7xTvtI/JtDopbf5wst2pLW+OAbWUo2luc5G5aeCovQaE5H4idqX6805wOpeIoz1yfmGt/nsh4MXczVsh93zyzmmhMLC4H2/X+96FwZ6xBtRopK1cyr+fqb0wP0IlCkmhP+eKpHMm3Xr3aX3mRhKFI9AMhLVU2IVcd1UWLtohdZ+D92yp2ukLo+3459FQekFAgBAiyGHngtEB4AGJaDWe/W7NYL3uw/eimpBKxRooRjAAMGQiTi669BJaRIKVIhv1CIFOWwtlQd0lqzNlonWrPPLNYCKUV+lzXlIEAQickCv3rMKiDsxciMOgdRdclFmb2J+tUjq6jdS6/KdhrbMUBek3iVm/z+Iyp3rl4w4HxRspq+Yx62IGLLoUVUX773y+xDS2qGjMMdTxukX+ToJN5xwz2fQ3CWd71o22HAlUUD8/OolX2vTlVBUQsSPUkYKy5cMAsog6cpWd/ViO3DW61MtWZkBH4x1IV9NHYWsNcwM3Ux7Ip1flRNSBeUGSJzaNXqDczVpCsLlIY6R230PUnbIoMpDqID4U0W7tPE6DfNFJPpEMg+1x0YzouS84ooSPi+s2JQUrUECOAyeYaOUJYUlwlrIVRpILhxrxosi92BsalMD8t0bIZtzMPCh3jFWwYVpasUWFEEII0x391XGI4soyjVNXUGb1QZLsyu0dF7OUt5Cqjwo52yQkktHr8aGQup0k3OyaxflUw/f+tpT9cGoAbHU7e47quB5DQEq6x8SpEcvMT8zRuryjFRjdeRbVGax2RBCWccNW6z3q0QWLtn/HNdLn2BNzVCSUx65AdRapiVkl2uWMXyTgpZqY8GXdYPFLcXQ6AbrvSNT4rez59mMxYa9Afsxt/KXeK3LSWMYJcdfcuHePTr/yZI8I4yvMGtsF0U3KMd3px54r/pn+ImTfr88tt3T+5/9J/tH9vtd++dOvj4/5ekGJu2VRn4tmUYM2hiko9EM0JdHfbHwqaan28W2K3BJRkxCDl4em8Xf3C+RzzyFhDJVYXsMxz+/Ess+UIh0ulXXgJvphkwwgD+ANMdMEibGJLlWxVNlfizCoiWfj1/FQ2gNF5r0EmhyWebHGP6phI2jTNxqp5IL56crz29bEZiNgU1PKtPBpMGyr64Tw+ex6ZlkU3KcjuB1M14HpkbOGWewAnBLJ7RADziQiCD7AntEsGPqsBkIMjtqCAoEST4ormYHwpmuFSQM8M0FWyi2ZGmRQUqE54I/rBnJClsIyKpdBSXSGSqYGjwj37jKtMVva3xK3xhsBfg7D0X6TIItxzEZ/k8qRO0iOBqgCkKfo/MEu3RqEoFyENWUKltZxvQwDKzIqg9p+MoX5LdbxuoO8ycghXyQlYgDk+fg67JNhK/mRJH0nPmWubn385GWgHFaotgYf+TDpjcyECqEDmvgMUrMAfg5GMFEhaHJr+klSVLDJiQ25+CwQxEsvuAr40x/0Yr4p9TJfhu1qxoCEYaH3778MpAYa4gxXDGFJX4+ecI5w9sHumqBbLDuinF9y7JAi6xU3eIn8Z2UI8XlaMjsQe6GO+irpv7tImvaqMtmOR1K+ZKzCQCwRTccnBtlOEcLJehHpbI+eUjeMJzlnWnkhkbXQmYuq69UcLiD5LtBFmY2LgZq5olMG9FQ6qlnvopH4LFkVyFQIzAUAOxDVN5hfMiPi1kfL4DUtMRN19FMwMHmloxJF4oJT6oEj8dXatIALZXLNeYeSt04TXjc4sUkWMXDJb2g2+OX6WEmWnBDhQlmdnCCKHR0iLoZ4onggNgX0Np9ieKvvO8PCv3Qw+SeYM6aINUTbcN51R80/z4MmyPlC3rGNs+R0j25CZoDdFQjexKwkCiWy8bAVccPTRTljKr6plLTnHwSGSv1ofMpaV+Pg4Ja/YlJEENm8Jg4ksVwMSPopQwxFp7CiNx0HXf7A5FB8LNpwn1lkSTWP7DG9WJ3ZsJ4xU9ZtyBA7BPJHvl04mvK8qQkiTIoeT4tPteNCbyKm9JDGJOZiFr7tCwk4VJSR4bLVhhWImsPAXsiHAOVtY3SvFnB0zdCUmessOEgKB+uiQSF31E5h+fuCfoNDs/N1Y8aStxN0r1d7+0Bg192S6DR8ebsTmuSwsrwSHyoZ3c2/i1SkYlx25GvQK9FZSm/MhxvyMfhLlJqJsyyMEG1LoLMrXhbjyEHjrgcmssG2/aJuZNCSBFDyxrw0Gwz/AFX2+wXbaIP9gdwdFNSBF6QHN9ZsLbOiAi36krb5rxRs68OBd+/aabktkUx97xVwG0IPFiUgRo0IV6zUOA9jgtCv2RuX/xNDkSxNIW8e0xlOnLrxvxJnJ+XJQrE04qllqovWMvfUyZJ6QX/qLjwvpUtSvLd3ZWTotxAQHxZOJni4o77bl5NGzX3IvDZQcQNYB1FRMMziMrKlT4pgY+uoW+K4Rn6knrJdenanXAO0lOOZYb5fm2vcqNpoyDQGXgMIhUegKmgHX1a58bCRfwotQkbc/Xhcuqc/elYEaRUM8ah/I6nkPkdlpH3jWVhyveYJW9VNYHiyCgxq11d3lxhkLddIxgj4MWB9TK/G8DooNQs3r3rBN9wupvvUHJ3r2ZEDWuRW94MxlZf2ofEeHYbXDt0Vf5JdefcDBBjaGyFjYYiAt5aig1TjU8v0qOZ6yHU6juKuyD2b6b5jPqD6XB5Efx1ftD2rPlPoGl/MQ/NM11zHkxDHXGhHvlRGaslxkrCulyZTaVt4kxNYb88NbWuYmUsTX7/WvWpmOi6q517FuJY6EzS3QAvuZzBOUmxzoMJBPrTYP3rXQwsduZK3kt1BWo9/7Ore6Wu+RI1cSYWVmlbo9DU9HWskLr8Vavrlho+No+5hJ8RrP/YXbVRQJ73ZD4s+t3hngCQZE4tC/L/944WV/DGnhfLnC6afSPVqPTGA/HE3KDopEYmkFQVDNgHaChXddMnZf67MNlMBq44YiWrmQbfQIVmNyQHPK72O5WBQD2Up/YpbTHvVkV/6DsQeWEa3xmv2RpTUxN34c2Gv1DfpsvvYomeD83jVGyDXk1E427tZ4pjcJ6kQMD4IazLDm+NGrVsfLmjWvb/F5+cQV5G8Ir5dRfN4KCCxXnl7L7G9uL7GfRMhVqoBswPnn9g2jkXjWJnCEKTo4Ym/jMsZFQhzccw+xlNMxyuxSkfFVQa9quFrpbyw4rrqYFPNkMk3meR5gNASxyBQFR1EooRNlxPwMGx2NpoD7hPBsGNewJRPGANrdSE5ReidvhxpfLj4zW33GDqDSYw9hswwdkfTNtbthiaBE2vsHYicMb7sEMYHvLCHYGNw/kXIidy+EGdqFO4+jdNixJ4Q0kPr8j/zqfFAz/Hbnf31DHgqov0iDeJbtdr3tmZRfeLjebbH4Vtontga22QHVegX591g8/VTsxfRLLdw/rSu9D1lX3zohhR1gwR3vip50oXlM4LHf+vwdVJcgHVb9tyz++PicgmRprxEgO5dYZmiNI/IuCdj2GD/Hh9qTA1c8VVZqSgtFpj8+DhZ0xz1RZ3LbaHRw0ReitrSgHnvOBa6Wk8xlEOyMg2ScDhNgSDmcVyrdpSHAMsKV5BDa3i099Br1J8VShp/OvM/J5QLacZVY5v6MRWQQaakh+QpMfM6G5KqwJrei3WoqX+CfELqZzMVfflwGVpRlLTGn0MlinaKaLLr9BAMASXPr+vpp4whvNGw3Haf7txMt/d1dRZ4gq82TeYnwzy6GlgYzLey5Cid+dXDBuOyfZ/ESWG5nrQxeH43f1NZLoia6Jb1GNFONT3KxmYAraHtjB8RZz5d7sGX3HZtpx0OecIfQjMYe77yK1USKidm11vminiPcQEiJmmrsqILm+I0lE9eADfMWkkOyHn2iDkwmluvPtUUWJ0vL3z0YpDoIaVTHQ1tEevMOzNSzU7gV9+MsGF3NGI7qaWR4D/YPy80X+q9HvGZ909XW/tuf3prB9uR9nbN+PdPAks5XNvXjHTVwl7DAmnBrvjindGAyfKdTak2c7PRX1ass7ger94mNIIaO3ObecKtoVOoPjXTU0g1rGqPO6U7Fh34qRdjLrQXAqjXNTrBMrsulVeERr9pfj9EGc2vYTCO9uUTZ7Y6QINHGt9Vt14R1+3ta76jrPxBYnt/TiIlDpqnEwObJ5mDKDe9pmVR9TyziRofiQ+WISYni/v4CWGKXijOmrT3TxkqvQAdsYr0GQ8yaYRrkmWAGzj/XdMYyAMlB35cDvqoGtV5AoS5Sb3T0i5ZmaxQgfw4yi415ovM7C/lhSClemDthmbZCsDruM0MzR+IK7esFIsKPbsr9HfPaKgtXu0heZ4kHPR2tpEzZs0C81oZ/Wlp9lSj8E3n3HR+sKT9N/Jpi8ZPCwo/h1Rvn7MkOkcXrB95htgQ6oc7dzyglm7tcntn/mBNC8/La/1IuwEEzagQpJ2ONeN3as2Iko1tTcLR1gw/aMR5QABu4g1AAKcVTav0e8p5URviMgDnBxJGnKLLgEDjYIsoNhII/y4GTgzJHowEpbMmUNFQ7QdScdUYxjpUgOWeBT/6+gcZGvnfiaO/HHuZfCWe2ZG3bGPv6CxHpjn7g9fn3316nIKZ2apM4cXvds768Onmz8d/A96p0b2x+sHlXe/M7tVjk1+VfZ250Wn73/8mEkTIGAtTIyZF1pXOUdkpsfJ/2lhTh8eBswsGD3W9vKP2K1QimXiMjawJw92T8qylWuz/6mKG9M9DLQft9pManehV0uGhpbgQ0+BABOR9KGfGSw3znbuA6P6cm9GzMG2vzQdXEELe0EiqR7tYuiWrPpokExZNNmsk2X/oYRNtKnYRQ2P07qCx9En2+K3GyTvsyWYoWv12985pKm5K9HXY0c4zkmkCAyxlRz+2cxqSsny415gqDl5HThOBxbOOzDKHeMUK9FJRi6UMcxAsxtEeo0nMr7YDs0RgHEgtaiWQD5DnsSiDNs1W8zIHt2GlJoCxoP1eDxuGTLdACWsrmwCARhxlwHtkL7yRQN/N2vGoe6Ft+GU9DZZo9VINapp98norRc9SDE60/Zxaal85ceidY3VceWgWn4DgkmQrxXOJFxcc2sBz/kWyGPDUYClk78mjZDL5m37onhiGvr2ZKzmhx2M6uHOWDv5Edi2pZsEU0fL0wqkVB2kzPxdPlvHl3g83gPZ957lkb3EDLbk1+ZI8HZGglY7DAR9dTd6bzYnPLFd2+dQ3Q+aItJDBVGZqPWD4J6NFBUDnvPNgWIeoGoiXZ/rRtYCHNlqKe4PqpxotP1o0bbGgl6RfAFq9BhXaXQinOWs79GgwuYn/+CLsELKBo4IaFSCcs0i9jYtA0eyE1tOORJWnscS19yFY2LRBzWwgWvTxUdhvh1vzxWNmesbxIKFxx+Pm+ffkJLzoe5gu9DP1J6WAVK418KOuZ/eqDdoYMvfnPDAldQVappMqnMepzZSP0bhVPRU7NcCYZwuZWA34Zf8R6PIMh8yasb/GzksWAkOtrHAjP2x2zWN5ybK1345umscxTVoUP+RZ+MB6I1wK+HOyaTk8vU9WgLzWzL/LKRi8ouKL+UGkq0XSf/jGtsyTv7SJM4MhpHgAszEp7+q3QIjKGvu3jqpCkkKoxltNE7XgcbXGYfdzVMbF0odWs4OSO/bXhFt+B86jg0damgy/C5NfeOM7WzLhap8LN/wwT4yMm3fI4Vib6VhNdjrvaQTDFDsRlxt3vLplb0WT7A63HMP3MgSFcaF2o5ger9tH9qI88f8sU5f5v/g/WCp+J94qxPUfti5FhgC9Bz+plbed+zaibRD+3AE60QH5AluF4rMDs9LrYFavKqbp5yGa70Qj8u6e8AJV7iZyJS0TonOizceJm9boTBQtrs4262MzZXL1si+/mbr3Jv256S7Tb/0TRXUTljXLGl2fLDck5f9K6PLb1r/eiUg3e2awI+EUdwb2wS5Fd2tj2SEdSHP0HAZrcaQAQk4bG4ewiZVnMwDoyqPKliv20NUtO+XlChxeCrN4dzLLjggb9Xe6lgyU08jhMfRRDZPM1lxnWKiHdmnYCPoEA4ZQ3S1Zf2fH/+KMAeES1TulxEru2t6HLUety4NCv8zJ++sEaEjlHZ6ElCABMWjQW9TgnhDThh6TCr7JpI0RS89l+QX8hfoQoft6SMz6EQ21AHbAAiGgWOFhTB8Fnaggd9mOMRCe2hlHMXTBj0yH/ZlpPDNDR4fHMgnEdoV/Q2vxaNPDZFriEbd1CSJM2LOvFeR/zIE/Rbh8mVe77P4mEZ6sjBF/Ktpvzhnxjsk4O79Fa2E+wz+oNxxgf/4HZnVsEN0Ezid/axSf5dDGEbc+plIEf/gqCgAyaUI47pBHNUmPI3aWfun4eaDS8TmQ937E265xR+v4moQ5i0UIWwUjYXe8Keb5t7QMNeINHIxIaISSDEXYmU0cU1Pz67LfvmdtVkYyR2c9jwsNy35pJGj5A4ncTVTxwXTtJI4i3MDdE3tcXoWysAuNgF5eBYi/usOdMsZjNC+U5IdKYvBkURnsNoxzDlarBB5SScUn4CnLqhFPIHwgmsQV0wNlhRCGg4rn3ftd4RoMUL3coj3FYTq3WIrIMbwUg4oovQzb+J1LmbRqgMsThDLYcggyUAbPn2vUwam9723SuR8oeQx3e58J4S+rtOhrHDgDK9Y/95dqsQAfLUTL3PQVZ051PqZh3Lbjbn+9FiglbCkgRkNrfmkZiHMbk9peYsVDNSHHEpI91kLiwAEgZdbG40A+AKhOQzhlllyvn9MvhlPhjsQRIYD210xY6U9BswGyQGcAo5zCd72mozboWB140r7gT2NLQovDBARRMrZ4uVx7JjkpOUURPxn92UnjNBdD9+1aJKMHNH+m5GHzXd1VDAq54dpoAHEDl4BG10BZdcsBAoUcZGXXWv33e6LxdwwNNB7BmRsd3D10CbOFsjvvJxtbJp5lsNLIdSze++YLQx1r4mDbbEJgME33yeDtnUHFOYoggnUP+M2MuMEWerrIOwfzQYtX1ZLTTvMNKzB9gM+g3FQ6mhjfWETmuXiqx40RDmEewuxl2yGHE6kzweVBNtujGfE8JSSjdCVxgBMemEtokI+CYNmxvLLSZSeUZ4JWai7sQPt6dIObkhDqAHcwI9OWZhXyoIn55B8yICjwSAkIcMf30lq0UAF+AhXhPy0NMH3FZ8bwqtgxQIcz5kV/usm/mhoz590xpEnMYQ3/IdPiP0tAEgn3V2TplfgowPz9379Cw0/xUunL770Zn7dYJAc0h8vaOPxOXEgeK7DD10xTTiRIcyzZs56mADawgswR0hdhTPuzKGfkbJscNWpxDkv64Xyj/7wk6BfJaxDKTOzt+GecKgbIPLL+++Kr5PTa7334ksEJZ6DUmp71rc3dBMWAOJoeMzmCKPb/oly+NOJ92KTXtQrZFEyFBmdJgakVEa1wtfczytovDEt1Fvmb14sOwGKy8F7SfmZTEBannlojO0A+mqMWRPHquIjrB0k48E8RPiSqK2MyTnhVkPp63VuGev7B+esFIsHrf3tvrqkz8Hher+Vn+64NoYUzn6/PmuvUulgOz76lFn+P8mvmD/y5NC35kx0N3d+2KgwzzsmQTFOIVLHS4p/uAMp0b/UqsXqQAjmUQxKPS0vlKSNSPf708tIKKlD+elRm3bVm6gYKhFCyqAnsYapFJgSc6jG0D1ay0V7zmvyyEYGGNaBu3LlZ06+IHPkLEqZPdb0jT1/z2XhzExBrsyzhZViz2vxKQTHFGXR4+zsnXxZbjtESxvM1r2ufis0shGga0M+08xz9rwppAse+TogCJE543JIksSzskayXWdA5Vo78oPCifUU3PkP9LdR4MZ0uFjgPKuhNRngvdiaLPMixRGtmu+X3rzaOqx2GmDx/Vni41+yOZLrFfiNpaJLuKPy2UkXegRo8RDuQvNDQ/cp/9zHFlqdzrW29e31tK3h+a+uCf2zSiu/buA7v2TcDH/co0YsrmnomTs/ULC/K/3W4RKitF5vCzDCalzH4Eu/rw/j08tSAndLvcuinFHubCEb9mHZ6jg788EvD8aDW4rL38ks12p0vqvSpvt54e/8Wy8s3DaLMHmLAfmMGeeVev2Je2j4ED/Aw1snj3x7Qek9X9/CVBcdWo+7EYLRakg8XgHkTZTqYvaZTV8XkqIiOplnhzLzMtbfhewhs46JI8qrm4gTj52G7FoBN0v+Tu3XQNRDuM+4rCM3OjDquWFaJ8P0Sdxp5oA2wi/KmpIWz3y0CqqXlXJRmflhfO8drGmtHAAsOBcNsrvqwVSKDvVBKS7QCh3TSKr4GpFsQ+jJmvAQFeuoc8JVpxiwL7mw5w2dzEVoKiBaJ0cTLPp32l3KHFmzGhtbG1IAZwA06MCtJ6WFONQStmfaHa9M01rCzksoXAd8KJd3eU/eKogQx+lwYKckhwR9bkS4RPQubweeMrQ1bHYdZkZ8ZXkrNd5GgtfmkivTi9zpVMLqJEYOD0VM7FdFkeZ4i7T2pyrxc3KkaxVeY6HqJJvke+nMIncoezCV5nk0INhz0+f79AMftpIyQblcU9YdaHHkpbL01F5Q3UNuanJR+gWA5SHWv8eTeuJzf0ZcL6WkiROzfW0YJWduUe96eo0fYihdEIFxV7HMO0rum5ZeVsSuvPEmGnUsVXuQ2w3Uix3MisxVpaxzk0SfjcYFICeVUz5iPrH1cUWfJdfkVxJvlFbGVUmGs8FsXrwH/34zwXmLLM+87MhAxeDafHkvd6vcvRJplGjb9+hQqfriJtnuCpVGAdQnCmRAam7558joP664HRm7ugiLQUjS2UAXhofzYklREEHMkl1pzMje/Xyqc4dzHoSRC/TYUCvmiW6E5X7DC1206OlUdOiXfSFHnfzIca9Ynt1HQ//iaVnmyTeHk0PDicPdc0e7+8dHx0YAw0HEKDdod+WWZGf8h0tYH6pzBjapSMGSMKxIOSAcRGm6yEgqMFRlULxBW+BbXxax0ACK77G32ClCvgTcZYTH5bxnZe5iAJvTnMTHpfBCn33LHY3NfEfPVM89eSJHVo4Oj1C/jE5dXKXjQ0NNrOvbZNc4VbuzT2eoNWjjQuDtFfIABERv8/O37lgiC9dZ0h2pQEM3e3YyY0nzmDUXZguKWgbQVydHLiMiEKdKO4iMTHjAQfHsN1Gy3wV6YRJ5qtOxTEsU/FvOadHsex0ntKy/k+rHfejRycvP35qW+0Pn589+eSVzoaf7Z1cfX6YtXY+vTg7+OKZDgyIWHswaYcdPxxX04tO68zpurlV+wVKrd8HYrkVssL7IlWZbXgqFDPx+k+AZo13sESWAkapfO/d0uRPDlu2hqZMenWOuBQkEAfbgcHR4ZSM8v7YvvYcovJsPJlbpj/pvy3oB5CvfoSo9x82+6uAI6nHUZfTV0f2U6mBF7Co7k/p8CUNd8Q34PQgPDE31pIE9daGAsUD1i+X0Hq7HE5BYgQeL4Zw+fOEPASutNo1BK2xZGlp4aFzzrDBGshAFL/0gVP/csE7QRaWzr/e96MKwd0t3rkLoXANH4nCR5IcO9LvXUW6mkBv/Wt5KTmAijjhQaKSazt47Xr9vbNDI4sHDkoe+zF2+9WoNf5DOW7bLCoR/dOYxnCvsAJyGCc0i2U61xIe9QLWxva73IMYIJHSb6Xc6AW0jcNFv6W79JrO+FokvFYSwqp8wD05IhLGpyHYghx0/l8OY5A8h8A14iZwsPgjYetN6DfpFRfKMe3RctwKegdl9kivKp+PH/IgGGJJVEsGC9Xi9MciuaNheNzs1c9Jj6wdoOxPqvZkkvG+L9z5NnubfJO/+yZnq9sup36Q+1c+pd5NkjUvEBOgOA1bSJsARSOZBG73dyv1ApykJk3uFr5YtqQoE9tZhLvEWxUV2rEsb+05wpRe2TlvdXtxYSutZ5oo6XDF0T/1SBLrhrogSpD/ShpX6bKsyz0Tlx6DJWLbEo9opCpc3UdDd37tVNAWhXudHeV4RsIcGSSqwczzFGIC/AFqMr7hfMeSOeuY/gJrUEexOAeWnqUV6+MUXnvC+i8yTdtXlUutsf1mk5DqGbEjGmj3tM5gUeT6klgaGa4RIis9O4CRZlth66s1dP/zwSLo6oM+M3XfEZL4N4fAN8qT3757dguyhG1XZsSB24SySbdB+XflXmrPe2R+ZMezqSfzR+it8BH+jIwL/DPGXoRIP5up7PPhtWTj1RSsTl8YYYJbP/OKx5/1i4YaUuBfr8B/H9Lhwuv1uBAX9l4XDrl5D3STSlejMpsgBd/F1qOCXTAePoloTu27w2VG1onF3wMenP86rhKNscScTskyRiva5sTKISS9Qeu699j7jkPjMYP/NvpVVT0WTCs8wiN/GRO26H35XcS8xUdKmOULPIp7zxO/5zyN7h1lYnO9UIR7Z1wI1FJ14ZX2ifaW5BsfGit57eFRy60k48gQnTN1RFgt6qWs/ODrUxbSjZxAT+mUd2XORZV4WCFAlAMyVwnwh76gjmMFv4aw9PIezIFHq4opAJbU8xPt+qZ3796Xu/hI8QGklFB/5SegB91yYdnzpR/XqfyJSjqccCSE3n8Q8eZpcT259hxf2wnM2MTbbLUf9552npRKlxN3Oru5jiMLKGtew7+tCwAr9V9I3l+kGeoB2bDIqaAN1QHB1Z8XerMvEWpHB3ps6sqA2i5QdNxSxhBMfkfuDdsXAfqdcdrtPXYBPIMVNKsWiMLs4resD/DBEN5ZygagoyGWIRQbnQJJWQ+8BcQeUtgEIfUZBf48W72MEREk4qo5XFi/GAcAzgZ01ADrdySyIRZSkwrlUXYtLhKQp+YjNrQuUmooVbVx93TKazwWeWlb1bFJoQ9UYRJOTejiEKdy4wCPMzJer92rFZjFwOXA65WplWLv84RQ+wIODvbosTGwvx1mNGXOMhZUU914bIJVCo0vAuKot6lqYjUFGm6uhoHGXVpg9qckxRKMu2njqlPJFrLPLxppGgxkX0YG8fx/n1hy5gxZODfL6Uj+A9pPzp31OuCl7pAohg4JduiQaWJU+FqV6mPQVmQatVRtOGYzBhPNRROlbgw4bTygIm63LHKzt7eduSa88upho+HXH1+L2eAk18vg3XvAg4qhfdcO7k+5KZfz65fRf+9tFWL686GZb4nNFvNlJ+K/kNQ7qeZlIdIrBJTxwYtSd2CA91Dw6FFMnRK6Sd8JPHRIYwewjyvjwHCGgN00+6aZsgL/8Ggmh5CliQwwGi/GqeTiHx7PxEUVHNrYtPmW5aHPypai5gVmqTqlr3syrmWU0JWalZVV2XV1Kyh3JVRknOq1exBkWsGLvHgbqjTKSa5hU/1uuX7/IYNGlF2BTzixnsC3rTN1w1NQZmUGzZ7lEgZEJLbTTmBUpnnJaypGG9gJeYtd7U5mFgm5PE2Yl3ZNFlWaW6D00hQGWG/0qT4L/VnYRs1DMyowhXWyTeyQBaxeRiG8bsrypkK62ogOyJc26Zf8XTssouz3zklrb3jrSSiq98avaGQlF/crVmb0AZkOX4gQp7EbKvuzcEeX/+QmrREfVcqHq/DYf+gWS0XwIRrlCNfKIlWtJV8KtEfKEh5mAVVzFWqhmInxQ7P6ugQMRFb1N1d2Km/yt7/J3unRUfFnTf/N/f/Vvd2DVBO7KHL7dst9BsVy3LtEuz/LPzDbk3DQexDrKNCmu6P9ETGPslfuNc0DIkDom4KXzVSGCAOXP5U8g/49IPj08ICRrV06+2DWeE2vhrvYAN2GZvF6t3rInS6xOwNRyJEy96u7fTw6Oau8L8ezQ9JNctO0Edk0C2d5ZJgISEcROwqPEleRevWQGR/mJAPwfYKvrgKG8ttnc9C0ylXODAlHia3ogAmP+q35tBcC6fsHZdhumH28XztwaVFE0UW6HOV39JEQE5xlHFXM/xvjvZ+8sugTeLDDBvp0wO+tLyG0Ex0or4U1vk4noL6+pcPldUZBvHIk+krr/oNnlKBI/0ChjdcBbfudPViHyQpD20/sIFP6+AEO5frVA/wKx1LvGzxBI//HZiCe1X+2jLwkLL62upnGU6OnMAbFuRmfsY0j4Eup/gNqJ+WcumGO9iaQl1LkxayvXUzHvUu2P+6egMSEpNKkEVKGFc5gyD6jvL10vg7YbKAhVLfTpS0D5ADNYZNy4DLxus/AQ9aLBVaRYp2XMr044rl6sqrdtZODFf1HHz64Zc1rAjE/1puKWM0q50JChRoQUHtX2Ju9FU4SBncVcIORTlV8fEas0zWmBOaxyyaSy/rXtBcJYO0dXMTn9yY/J5Q3nKAOK9i2aLSMqjGu60hUhfJGzWgWWaVpGxZ4wbq22G7RNWcZUqt8CIB/ac94ezVAcxhAxQzc/kLRG9l5mt5rH2xUfvuCgpCeFDFeHjBAmFfxpasYVq4thvODXqbBn5TOX07S5UtGzXU+EH/H04piv7y8tXltlPDhQ2CujXMhk52rcwjWu2GTMN+XKKXfzk++KajPpv5Wd11VZfWgRMpZuQTnDFHlHVbs9UivtCDIAMgHT6BNM+9orScmRfqZlPuSP2t/fnWP2b0j9z8+evv+sTufvJMBg/TUbVzD4asffHr5m0/Ov/g9u3eR66cHLQEjcvh4xE738z/98MrNS8kI0hqGq9gDBDHDgB/XDBswziwXCyD+3BOpl9WFDD9p93+0zxYRnIMmk94VAVwbua63MvRPw93Z+cP945M6VSORBZjZj5Nufe1g9K39bG9NfmS4nBhHWeJU1SCuXr1/5TUl4edTC1szV5KYXPMZblyND3EDZlpikFtI0c3u92esgVzhMRncPBvmYHRvXl7Z8OhcY/PLcti3cyV8PPIQ6/QSQbzEboMRaWvA+5jr1rgoqe3wXbDeDTAwK/JcltERU+zCLHJ4ucpIta5zAYO/K/DvjERqtTIAvj8fxd1qY19sQyf0CkweoECdqnVWnHRbRHVdU0MJZDuB4iLcWqCtFISjAF3Z5OvJe2BIddgr+QjLMsTmAYny6mcaQwohBqYk+PAQq5fqGFIC8UItK2x4xygDeZxTNJXHi5sn0DL6/IGCAjNAoxEymF43xLXl/xSiISnW5/kClW3hnOC66UQQ6ji61A6I7DjHLzHd+BDeLY86lyLIXoETEJwRQPGPYZs69Gq8AVO4T/wRM5DfhNAOeeLuC1tRXvG4q4O7KnpJDt0AFyJw3zuvURJZLDrp1R7IyMUQgvXLHXxPfnuVehOYElwR6JYAo+LJVuicQjcEuqawrXJk6SFH4E03el6zETg2jd7W5rLAkLKoKNMuJzaaq5sWCIsPJvTbGw1afzSBZDPMNOkCsiVsOE1IkobdfEyF0L4LlSOkgVpH09m/7png0zyO7gzTSKCgkHPnQt+QwUAXeljgwPSkOPCMbo7UukC+Sj/eoicIejdm4ApugFGqFyS0cHC+9NDslzBAL2EzWlD5w/t78BXol9tNDP1e5C8Np7TUaKEGiTAYNMMsBNuOcoxR3AbdBz0EZdh04Tqnme3nqpSG3h1zwedqWoutfSElhw6rmGIeIlhYl/oEZEZePUqelDfsRdhuTrLqk9UbQhVDZEf3iGD4voQWdSlMHDanccmmwergNK5HTZX8oqImzpoSwfaoV6SXmAdr3c2r1B8svqVaLFQZzMg289pMasj/S5aJ7NHlns9VZ/WWauxM5NDEdpEnM2E00armyvtSYzKC3U7UUll2s9HId4sky2G7yZWuPkgsCsfSDN2mKsJKFMmyjjdjk8mx99UHtNMur9E/d9EmekZlg/114fcylsMenmkpC3DCnX645eyj1QRftfz4EA7lFdIRKIeFQzgUt0w8CGnGQh2x5LuSY74k+ErrcL7AVQOGTeO4oROSeBE+7ADVC2FMITIdrMeFc4hxy/HdJUIzSE62I54gLzN3ZaZzAzQDK5QVs4KiD01NwZDn1ZDSxQgpaW9VV3mkp95CnbQUNCnI0dbcyqa9IOvIOrWhVEHU+tgsY2+9DcRaS51RN4KOkzW63mitS0EAH03cGP5gYWT+3NTF3MdhTFWi3v9lLkGsfFo4NjG6ePbOzTMfZO+AIMs2HN/M0dJ59NNbqdfO3B3/PsUydYOZys31wO1fV3yhPkZsRrBcEdO7pzfF42Xneb3ZG3EeIwvNiT6KoqGoZT7a+J0Jg4tFC9zJBcaTxKd7w6YUXCtsRheJs5Dy+bfhqJq6XuWAEPvBtzjQYW2c0Fy24yh8eqb5p/mrzeuJ3m7vSwPO69MbpUftSXmRv/Jcf+38NC63HHEUcDlEXvsaV5Vk2WBmW0Ow6OQFpj/1g6nQYJuof1J7tN3rb/yR+L8r57eB6hrIpardkt/iCIw2GQZ8Fpno3Tr9e6+PaQcc1wq8eHdBWcDpakat9O/ADyYdK514ewa35uchWnOMssHCn92X0BHd5p0oEYA3w3yixF0pIoJYIrtYdiHohUDjXayQbc9zQ1ZXFDezakUZuxASK5som24eME3Y+74VcZIbG0dLLyciNUkHumKCuDB/PnB7nzAsl/QW3eDcSzYL2110Ve5Sm29y/S+KrT4Y0m+8Y9bw4GtCVQf9uUVeD95JOBo5jSoiK/zaE7GbLRMn4P18qT6gB7nK8pDtFaqMfCtbRb+sRtdfooJLtbWtC2ZB8sbTYM91BzyHh+ezeoOh/zWtgC8Ll1lSok7krdnM/yPrc89J7PyTGrnP+RO+EcDYTGA4OpiZ8rM36GHMJtO2blVv3B/6u+rnPuCGhjumI4ap62Edte6srYYJqJ/KFBLGgn3Zb2puTaKSmTRsz1XRfdp4kXq3SYRXzW39mHzN+FV0PNOz+WLN9FerQM4VicAccFQBFpRfJGju7qjJTn9/7+RMcU4Mjn7xdPfYYQJwJLZkeIk/YTlqTHHf85CHA8WUOymd884n2ucj1BVNjQiqOWGoixMq80wVCFmHW/CABi8RJL7csXmlpuyboWdM3fP2uFmZo65QJYxYO2DvVyVRQ8FuXcRhxe8URHdQuoPO1mV3alDthgymFTsPYZHJFMDN4gTjJepyFP4xwNBEpkiAhHWbOn7rQloFsrK+iuElCyLmOhm50T+dogZ9VxbAYuNt+Fl4wRA+kqLJlEUU3Z7YvzkSKe+k61/zaEiDvahhXOPNhxAYeFGYW9g24BE0XDK7AnuRcUc1YFJQ1XwwJHLoIy9BZUCoxtIdvoFTJYnV7MJnS5Hiq0Xi+hIdZa2KcjZkbT5S86CGIsflvmxu/Xgi9+5qY6/NpGWgMfEOK/xRVi4flJcwLux3mNJVvkdaAGfJr/9ds1r9+NGzo5YQFQCMYlUattebhU39HpAJjDUJ8ykFTVKrfcolsoCR20gJE4oynP3hy/UIalHjo6xZ1V3aU0EAV3KiQotr3qiiXB11zNLRpH0aLJeHskEWMm4ERZSp8WpYlx3zIdpu1W749m8cQW3BYYaBHIrRWCcXd0X18mBVd9KBX/eJiWOKdb8l8xzoYLbeQrSgyHpoRZE4sKgPEISfCLM61ITo67fslUGIXBaubi4FzloxmPNg4b/yUHvKJTf5jx4fyUXyzxQQ8fm4KQtDcQRnc2Zd4Wv9+IeZM4vHu7oZwt5NpsmNCdKU79rbygo+J5vBjobbCYjHy5DaMJgXWe6Mf2AW2pQfyzI3uQv2c7bhI1LwATUC9FvVDMW3+JpNPL3VO2CxqBE0DQ9Bv3uPPZqW0Y9JTcXqJ9aeMMpDQ173CPtxAXUvdSCsKMZ1rTmPvCgr5qr/p6noCdopUqsPXGdo8AgleLbR3kIxfHml79PZ2Fu9ur+mX2T8RtylRyVzRTeGzmjwnMyxT9qAWHqz1NknGYcdksv9km903OfEJ3aPbex16eocb9cSfwdVhUGxXUMKc2WzZOAyJyg46PvWq5OQz1Vm8LPg91VOnEYyqo7YbJn2LlsTHF3p+H551q79gmWJjfWijzy/Wd5amUH14UjDRpBpibBiU8TppQ8GR1WsEKgkPqykj86Gr01p5zR76azV2z8vPrRSKzxv3T4/dtMgk+GINTVydsKgyIVfaoX3ku+Jz1xl0/rk1p3GiBPXe5eCop3AwOBIcq1rRbAhA/yFOq0AZbA4OXSEdFv+JQjcEFxzl3vMyDIRgrtFgJcFQdO1DzaPvZRoK+gBYhUBtGP0CGxpSkEMZP6SKwTZSkAhy4lQmsjNOrAiMqhWvJPJc+GcORJoyKnAXrSB3iTb3GnN0GfI7xcUKTwxY/QNR/PcLxBMHCiGqm22/7M5w9fBtitrJ03sW9nOoAIx8DlTiw3f7arZfnfk8apSLQ68ZqHel5YGyffQGwlw3xbufZdjc1ZLygXCZ2c2C+qQCB2EdwW3DMDSFlV3DX+bdWZRNz3eY4Sdh+PeZHaYr+6asNGmBVUNTnK4YL6sbCFqQaC9PR6j7MyqJnR5hBPATE2T3U4LzvJcsGb82zh4gAK6k7ae8uqmMa0ebzF/30ukMZ2mGszVq+uyjugyx2e7/DZWWpqe0f3/LCQVl6XmddU21nzMQuBD55YUD59DdfCtOkuT7WTAqWBqsZoA1cXCQQa1Fvcwst+dfHHAMPpJ9SFXn5wEJDb7szjeXUXU0sGhG4KPFcgoY4btXLGd9xyx0eek/h9cE/0CYStRWQEy7oQHyC2BerKkr3ppQE+xRjcyshtPKuB+jQjFn1EWwyeEEy3H1Jqp0yIk49Ua5xULB4MgGd2Oh2FnHMdnenXf8YikK7x5uLq9P98siZBVkkNv4wL1APyvCmoBxyFj2zu+sbBFtE2q3Jx40pV1eetG7LScdC7uE2lBQH+d1+Fg/Z/2ImRzurFu+3FoQloAEtLVuhZg0w3PZI5LCONNFqq4I1Uxq/LOKhDCgnZMEbg+nhFbF/dUjqonB0QTQqvibE+gTld/ikUUjb59SciiMW9vOPLCraQqjOvi6O7Ck82Vhm7YiI0RoFVDdAhMbuM0DQJ2u3bTMwlXUuxB3JGRNNnskjqE4S9kXYLe4M09D0hZiODBbfdbMDbc3U7AWoU/PR8tYkDTM25rfa6WjXOEjVA9zQnwl3ZKa+7yedfInC70ne5Ln1QtTvWhm+7KpXu+v8S1hwJljwy7Np90uFy4G1+Zi14hfDMFUXygYAP0/Dww9Nv6wFMRCk/zHQrs4F67QAM1y4id0EWY9DE1dL+tBTLVyhx0RT1SxLxfIer6sPhzWjsopz1+/JBdJ0i8SgcAHN5oWTIc+8MrExE+7/kY0ByILX9xW0DUKghA2avOtEgY8nB5mhC0Wa0CDxeb4XSZeV9j0OrDHzWtZh+HhPH0mcWO8Ijvht2JJ7DGGy8eALEfHxVJhHWI/920T/TRtVvdQYV8MxTo2bo4iuJ+fGo2PgovwYXFAmxtSHxtz+cnHSQ2zQWhxoqj0da21sgIZxi0MV1GnqMEuXO8viIspUQdNnVS2WTtP5BZ8NuhrSxjS9vj2ULB7poe/x/qdKkz3/fWeFRS2x51z1Sf48MxD0mEEiS23rNR6oU4hJZfZ3fHrEg1sSWgomYfPXjrRKkbl4/0HJnEIebLYOUZIU9k87CXR1Yi9XQJ4pMmoOelPg6hpu2sHer4ZpxDn7ZbjDRsqv2iD1c2gSgBORpgj692KlJV0r9WdrLBzrDQxdOz3plgm/ErV9CwnS2Koh4YFyeKnQwKKyrPzVEd6XGB3pTAYQYpQH1yOdLjqlEsxtDD92MUBgLfi/BhYlCWDCpSxtUPD5MrPYkmha2o7D2i8DBdAUUXB7g/HtAYhEPtF8cF5t7ag3/65BR+9QIiePs0Xfw2+fHH3kH6gc2MzLwjhlYpfUwwDG36iq1mZKUUWmHosHIZH5tYUzh8ky1Ecl9z8TGYGRC77ix3CRdoeIXvLRIppCgw3x3k/eCGvxYnuAqoKBhsaaHHaRAiQiRvb8LLVCMAcN3BGUOwUzIPIlaImcVaZXXr/vAFd71aji5DrN7oSq8Fh45agTdIu0QYCd/YD1yqq/cI4gv2iCNPwytg0502RohTIbDdrHbi3Mo8wxWgowG7ah2V8U3md7aHmknhKA2E0QIS03fRxz3DQlm/JCk9I6BGRFoclBLKheogfWNZijV4EP1aseE8kHOj417ux2XThSkzK4RfY0/A0eXvuqzsZ/o1ETcHyq6LKYyBy8r7uwBiM/7w2aZSsUT2h6l4HIb4B1Zm0J1hh+X4RtWCeUQ3TThCWv8de9XLYum8c00HZWdUts2HFD10yCLZIiCSnWXXMiBmOxTJ9mLWRULOSS1moFFYBi4dvAy2TFgF0jE5VH2iDKhteZ6GAckpWn1lHD34o5FvJMcNnZYvGzpupavfxX6Kk6GTyQGvNkUNTuPk+B3hAKCuz/2Mm6qiGgJy3bQGZ0tg+N7KQQAC0fXUs4V5v+q6BGF29dRMd1Hn3rhcv5YzHWoUfYTBcPh/B7j/Mhs5PIXI3CcaUGg8T4YmZzjrEAXc/U+2KLBORZCojUT9PnoRiOS5e/o8EesSP3xzKSeiR9mgT596vfpR8d3r71RvqpMx9CDF1ZypvkkEbUSQxRwjpm6N+PWmkGpcAEeaB9cTKF2GbxJ5sdP6FKw03yaoTgRG3RZQquznnq4P1enzZIVtBFug7IbB4uuSzeiyPMMWuU5hQu/P2twsN3lR8q2wp2zT/3qnCvnBCgBzOGyslwGpcrpMZjdc0my5amSfhq5HW8C4sTyLjVale0wYuFEGLOgYnDP6fYTwzFqRbl90evkatvvu3vU+nDM0DoTYKGTzp5drQoTNTY3GxzBFwJhQRUnvYMJYXLg5uBQirhuYD90E0iRFQl7w7QRtF4XdZfEAbWWGT9B6ktcpUOqctcJmvb8UOqd5Wzn4F95odZ9Y/upFmOHvvkKswVyJmJ5Wi8B2wBkvs8FSvWQlrh6+tPN3HpyM9jPHYByObMUaVoFjkdotdpFOxK8zz/iMr06BbEBWet42gMHnH8dV205UKnTjVG9aAkLM4d1VpCjWs2xdhJE29ArfIkvw5rgqWRJ+DwrBHgdHcTPW8dSyyHDMqQcLrUCEVjleKNof8IxMKGvD0mavXYvWlEaUW+Lz9BrZV0ozc5rycLmezV8POvhwEu4bJ7KY5UdXwjVhO2Vw4SYDq7YIL8T3Cy50f8TZqbij9+74PZ85T++8tXDn/MLt82OkbYIAR1Wa5iLC2mSV7nb6iF1cGN/x6h9MD6jWPWDMe2RIwWDty+2z6i4/aE/U6g6m846JBB3bjj7Yva6kBZffj1JJ8F5x422s3K+sviMkAIGQvIFC+f6BDTTw1aNBaLS1mRvZxcdRd5omQoW1VLRc2VMHsq4LQh/sUiX30Y6e6WHVKIla9wjReAWdnhJZlFp0/9VejHepxfizT+m8Lo4LGL2tqQN5N0oqeq88+rie7/kbQt8Zplb932witvMB4Zsth/C1drlO1jsRJTtdn7CtQszNwsgaOTCUNetYtrnRCw8A0+XzwoUkzdrzWhH9iKtOxmGpFogB86pM5RH6FEdqS5ImNhB6lrwuDMGttlx2SWR9IlicJz9+Ch5ldAW88iySb/7Ck5tnvnJCSxOq3XRftMyPUyry9hr8rF9JVst52M86ZGsZe05Ck5wfb0PvPMRraZr68WaSt58kXjLqR/SyLn+5hDZStPM0dinChEPp9bxDlBXqkWUX84gbWsimPqYtw2WPnknqo33NjA1xba/iSaCZscyqFIH9mD2HOm/XpYuI91ZWo3M7caT1t0bCNlYPzv936XCXNNQs+2MSECwBlh156MAco4gs9N7CNtd/+Tt/4GWbT648eP3XDPb8XhmMouDXYIlKyTaoMk8EiICpcey6PjDTYIVznOSa/B2CULppFwPRSYTl+FVTAN8Nf1OcbfCEGC1jXzAXosDeAubKtINrWTMuB1dahh6en3KufsXzFTHow1pvW5xGi4OU+56WwxIZiRsHqFWGSqdZgyIRVoRw2+bWEce6JVlLwrZ3fxwz/Kv8utMi41cOecHha28YaDJ4JZ0XH53XDlhSqAvwdidWisJvp7Hqdpxyjedbf3v1c6mgD+hOIcxVoLCsaiM7zI1XSJiXS0FSIdZ7S7D4RrM3dmndrnwso5MUWgpimK2hT8tewEphA37m1CNwjIdrR0tWAyKfXOUjWygMZFJX8B2soBmcsaMVhn2p1CDOWRtDK9A479lQhHOcnNhi8GXUQ6ukRnqfoUHOfesKkoGgrSzTA8ZsybnCpkpdjQvxYq7iBCU3OUVyqU8dapUgDfqUtRjfFHXUeWlL/wRvI8gyAIkkcqHGafmggs5jLd+HzZw5pTo40GHd84rQ4pq9B8ILoHoUva7QnOY1CSfaE+Z+wQZiyT6mvS6NBLYGr/LwRtqzJb6YfU9s3L47TiP8V9P83cII9on056KwBisKKSAG6/K2d4dqGFKvHXq/WKRLVP3p/S3uhVaUT6JChS7B0vi3DPfUbkUFeXRqDxjymXLucDqVT+JjhL3ztgxDSQoob+zB1qed1FFz4tll5Rd1mDIjQsLgF9Gh1gfyKIb0LgjSBHRkDm3zgNeLr4uVmKcVkmvHI6zQsS2QnMu1KaqqoNERmFyNXiXy+i2d+LVGRnyxnTO52c+fX5i95QxFcODgFBJDsJmFkQA9zXZD3JwQl1BGWC3GtWjt/3LIFEqXgVAHigUx/f1sQWN5LS4QU9Uk2QupBE0VSBRUKT+6u6Iw13XWDSq09UzD3pIEnJuPPrKw/MALCyL8b7CRBNUnfmplOYxpLl4arsfWSOSEdnoAZEGcK6K3WchTipu5SSkTu0qbUkdX7NylmFHequRONdSzYDCwja/rIhkIW1PIXi/SlYPOpQo2BjzHD/eh7uR/C5uN5u9+23mKvvxZV1An5puc8lVGM6MaMm8a72Svl8Ocx4/L8OJv87o1k9399mf//LH4/Pfb+fNG+KgVe232sABeAwGQTb2MXaLpR2JgyJ/1mH/DoBgrWb6dVaM60c5YshQQgr45KH2TYSYdK4S4WKCT/m/FyuWL9ErO19ikw6qySEBCgjX9zNVh75nH8GYEJ37sIDT4IPqJdT32Y1VQVAMi2J5BBzvZpgWV6iUlpWj9alXSlCoDHyO6C7XUa2HsfZDpk2Dwi8aiAYS9q+TScVovqzaCUhoKRCp5GM8CmokumndRa5wx5Is4IWyKRFPgnX+NgC5us5sfMMb3A8XZ6MDumrxyrv9t6oidz3RogEyJ8fcVuZCNNhZdTV3VukigPJwqBZso19F4Q9GUzA7D4C9ocElMw8Yw5yx9M8DC0PpdmIYZVeMGl09rXllkMj7agOmcc0CEn46wJIYoqPQjgl/UGcQVLTAUdbN6tw8DPDtwAj/Zy6CMjV+kMh9Z3b9uBaZ5ICz28xN0HEzIAHhWPV7xcvmRuRqdKuIvmh4Jhb8tZXmXkH6dGgak2tA8FgSSI1SFIZ4cyscmFYIhPzHc3Bhwfm3TEjez3XI4+bYOZNfvcoJpBaO7Ukbg7GD7m44ycALXSojTeDVpdEfOOB/CKW8h+d/w043T26DUqgo5uoDLstTKZio+KukW/EkL3WasTdcbKCFKEPJrxPN96MROanIiHIZWdE90EuRrHZuuQDj8MXnoV2aivNI0Snv4BGpYYxlpNsKG2u/Tfm/d6kf8d/8R66WC3iDAQFlN7xr+knWOM2rO0Ut+zRgMK8VY5vP7tJlwXfPRpWvWF8R3tz4XY4scSoXR75hkE94dFK2rhIWhMVhZ1Quq8z8+LZ5OYP576w1B9NOhM3MEcEuM6sftR+Evsp+BsjyFYhXdFGJeNpGOlBhrsXSWTtRkBlH70H6Ppkdx+FreUCxUgENglojZ8K7s1CRhb9BLBe8GcivjzwOW/PWNpn9HbDsdTCQ3o8UMNJEG4W2QURvJhmKOMGjJVEe6gMKqCUvwT3rgqDwEoxLnNZ2P5ZbTm48Ab5LNnlZqxa/EwyVhoBbqLFDpz8DAoL8Q1VelrXsqHWScF53Emmo9BDyqTWpR5R6hlKwpHZqM6EdH6wWPgfEXgqsnx1H2ZsbqBqBkpP6kIoQTsWPG4NW6M75MD0l3G/WnADJSA4ufsFJNRskWe+eNbOZMyjmkMdoZoingUxjgn2SAxhVIYh7aXfh8I+j/AVizycWQSM3wcCCQC2YL198B0VBeXNZZGujgHfSnv9ukflDUlNqz2dyCjaZHhwYM1o1rAYxuOobY5N6fazG13D0ummljyUbrVFl4JEr0D3EJWfHojiGAa7amgR8wIJ2+9Std1FzEeu6d366iUdyKOIOfhSkOGz8EmqMQmKEkQYoSVAowQM5BflyuIMl1McSzGRSd4G5zch5xih6OiDNz08JyQBwVzTQ9bpIwBt01eNoh8R1P4zeia9gd/EPyXKkY7hLyDHMG4XE9mWWUAEGsqeEbtY/Cjoi9LapKF8sYW0tFF+7hfXU1qrVbzhFaxOSVBzE//I8g7TBgu8kPyTHWT01s/hyb3e4M3i/B6lxR9hc1acXVfYerNXvplXfPKHkpnPMUgAMcPQkDfxuD2NgP/CnzfClJPagFBEZFcJJcbyFauRX8lWfYyTxouB8FJQGaLjArdZ5OXp4lMepN9dWTAMUq6YtIqAJ2pXjk1HZK/HaIBfPswwnpoDZzFGz6MO54GAbA5YGTcQDvapy+s2L1HcfMNPyYj8kbDFCDMiw4tXHx/jULiBYasA4+yARxrunrydICAcm5wnzzdhfd2fcZHBI1vEfxETjsjyHU95QMCNFNshE0yC+XVhJBLe/uA7btKBzxGU0aZcu2Jk9fjj+GHIG+lCPeRLZu3JgNL2XAe868W4HdQQRMlTmPwb7GaZit/93Fx2DCVs7S6kO4jKGxrYj/vCxS/kD1OszpoleRXvVhW+32o+6TztOy5OU59nY7O9YM3CT9ZFnrD9Tjp8P1N/FbD0aFm3qLdPZUdPw9Kv+E17WKr7KVe0sVhwW+zF4Xf68v94Q5D2TlPE3lFoKmC3Cs5IF6eG3gxFD4i5q4esjjtutQo3e9MGNIejlkKPRUBnxOyRLqwwfuewMSoROe8MKMwRZnZP5E8bG734AyPPfUK4+x78galz6DBY4Z1Oy4ig6gEk92Ihfmnejjp+yF5RIpk1aSxT0iJwrY379F9jE5/oLt1cbxWVED7+Pl770IQz5ZNh9uH4+OFPIyw7Mt55RWb8pfj8efvIzgM94CtG8dzk4fsgRoJ93gl7tevO1MhsFg9sMbQ/1IjuQy8OJT0e15uEprMkr/ZHhC5iUdHJGHWb45mfmPlYoZzQMOBM0VQIyNYy9fqMgGYu7hUmAXDeKOQj0mKoIk9ulHm/uVWXxjiUQfakMi8eAWTrkhuicx9wrvNNlfrUjX4Ac+6lecBC0rDTGqo9dHtUoughoBGBVRMij3JL223erfSQYTUmCFiylbIkbF0mE9PM3dqQQ5co0GVSLZM/t6YovPly/qhSLQXXIl0fteYj+u6p0bCquAuisLkv+eMFn6hRAhT2gCl/DD6gZWkhRx5F58GlA3kBalcuhZN0GHOkG/PvW1ziK16583TRhDuQNmytzwWGDwhSImPQXhmu0EA7R1rQyDn6fyRLGHzPWRIiFvwNR4VYx3c7H6w/PU7JS86JZsG+sKH96bhg88Bq0ebfjrP+IQ5PVR7L+UmoHLhWF8NKtiiOe7kL67wB26QVeIs2ZQk84k3B2LfmyCpAv3wdI0UAJJd3xTFkr/j5viHHeIBkBESXFHwOwJFELMCqHPKnBcI/NI9008U2JTYmWZDm/P/TnnqUGvuGgamgOhPIm2mZL/tB2PNJpKCdRP6FON8kqcr74eWua6At4N1hc/0B+9895F/kT87R9f8jCP8H5KMTTi/Sa3n41cDV5Hn+D5JldM+L4olSt5FXHRu6k+o95HP/mp6C9YPCx98pRM33kdcHaQnezdZVmsUY0T7EUtS0eFxdmYGoZQ+33wcIozOv0gEEqGY9O1U4Cw/5Bqm1jH/chhIXJ7G7DZOXEWOLaDQ4DS9YwEp6BOcaw7pOEC95JdlGywebOs0owuN/evEIAliU8WgRsJIIEzL7xO02HrIR1vtLVxfckjOpOPnBYyp3SpEJLaavQuWMELAhGKnUBADMD3cTcADuS9ruzoJ6j5I/VX7CUXn04sSCwERaL3OTSIsZ2QJLtAT4cGIPFuiyEfdw1+IHQEXjBpruf7S6EmYlHF5qYsnfkuQtXVQWDpHC55VhjsSKTtqHACQJFlIX1ppOHm8Pmg0FF0+1boBqgM5b69VbOm4iI/fjLJDvI/LhY3B/AFkbt9GkksJafB3lyxRnBWnlQ1OwxHUbbdD91ZaymO49/hwXWFZSUzeUdzCcG5jbHcYayNxW/vkRk5dBkuUyLXMj7GxiVnlxfUVE/ok5rh53ClFC1rtWFKnDLHWm2T6Ou8iaphwzU7tBFo7XKb75VzKwFRKpyZCWQRFK6dsG6qNF3KDmYKNafL61h7OCmIRzaptnttKMzpHx+LWqDc2OuMvdGiYewOwPaQfB2/WQ381YjrfeZLQ9fon+9PT/cEjwsYPXa+IvhNGWC2KOyIWYbAETuKWq9QGxwuS27ywgslOEuCQPCrn4t1WCTLkbNPllZolyvivTrvb6jbHfv/5/nlV58HZXZdaDd+WofOG3mTnHX/B2vgxJ0uKle7M65Dj6NLIuJih6h5IITIpYHQLvde3qE4eNJCHcP9/ed/8f4nVxgflPHeq7/D4c+vc/fLc+9gPrHcm1f6rxiGMuXfwgKsX7xI8bERRBpfwTkAWiB+1ZWgUmuYOc3NdnppwqkCmw2110UH9qAn4DhEUL5RIWfdXJzu2XIQRCD4FWQM6chixOrgAHnB9jhA5pYxDimTQQEjqnt0bFYtG0NAykDWFKMFHVOanuHm+vn/nPOVOkM/SYO/9zu/GxKYXQtDpVc00eNdvtjySGf9HneuEODlpzBqKTXAfwb/HOSNt+HDsb77aR62N3S3B2113CYkdD0XpKFE3i8IfIjkcHuRh0nN2Y8wsz8xix+nGucMJ/cglqoMEIh3wfH7KcmQI2SE+A9oOZZor+k0ZfVPHDe4nHT0tUHhmKGvTNdpAJ+08RzGBAwyb/SCMwDURn9US/riXZnYuBOTGQhvFq4vbeFMPihcdYjdMyN4VQUg5I0gTvc0C5OscZuu2ouQmvTNoVomtEbiMPmYnKXSMgLRPWGQ35u2iX3yaTJo61Lj9etpOC08WiZYKZqUpm73lB2g0GaDs656x3o2q1j2H/f3dzh1fxjuXNngtfaESoTBq5HX7E3robW6e+113K8f3LgRzUuyk0ilJHO7r0Qp8F43X7vqap5yEehUplxnXTQHIWxtHlSBWEfHhbSOSMBMlPev3zuEzQHOEi82PsCSDyWGKuZI0rHwj+hp7u0kNulC+pw0gSQBzKb8SBPaz6siNVYJShLMsNocFqewHKMiBaHG1DgH9Ajohg8P3kkyjyfbCdHnrdN7/NjSsoNyq9YsASj1nTZin6LlhzDYUSAP6FQ9bIkcgJ+uIFPxfSaAEdenztfZ255kftR4HTvt2f/LxepbCxnXx7FqM7a2BcYCz5F1o+W7uMPiY2gl6LdgAM6zybCxY28cUM5SV/JRxgsmQYc0trfZJVTCbuVWT7UHY9h1GoVd+iIrpZYyo4NgduY+WAIKaY2sBiKuArp7bDpcm7DsX+oZrXzHQKLBzfq0AK8R+++qDynauy7pfXiGWiUOmxlP71cv75sko4UHmCgXDnRk6lr+IxHpo5KN+3RGllYy1yNi6pLoMF6fI3WhsfLIWShUUpaasLf/F4rgDKVHEVVAE46xOYgjwTrlDToXnSt3s/i1CXY7V4mQQQ9yblb/6B4E1sOed6GNBA3LIjIJR+uqQ0TbZo6js2swRXCqOwkpcTi1MKS/YDEYAOl++yy/+r1TXLTesGy5rRkTT79+Wj7/jVsyzG/XS076AhFe4zSZm41N8sFwIFGZeKyKwsfEEWUjTJp/eQtvvDvKUkag3x2w+HWYEbWvZJ991z5XhgYYhOlWtpIcfXVQh+p4NctC4jUKGi7vSjFqZ61xXO0vBiMRFz5+GRHItlFOZ1tRCMGHrAxD6qMFNDucDlTmIQUzcNlOhixOPeqewyEAwWzJInaNroXUzRDsg3qvybhikhLo68EWDn1gYuHTWYgAmj/3y65NL87plJ6VQRIxSsLmJBI0XzRpsMJzaC0+xDWAovHifBcLUWMoWyBhBIStNah52TfhPipyQI+uRkZbyIE63qeaJmHODEgiLdKVd2nho/9nOary0B6Zp5//Sg04BjITHaWvi0cEHV44bLyxaGK1xPJYd+uDO0b7vGKLul8QDvlc8nNbfnWHn7Tzy4c8OD/vDdK5cdQcRd3UDBHXyJu1iUy8iRvSX0Zrl4I+Vg8RNPam4k/LhZ1i5hxRCUtTjH4Oh+Jar2zCkUZZTtzOHRrxrtcHa9RtmDE3Owv6206f8uyUGM6TxqxMFBVTaPrFllN0yMlFubfgHq3vruHWB8es7uA3j46JE+NWcmxfy1Ot5vNwuspzQq1xcOOW/P4RD9ikLRAedP3GwQlxOwQ0iukkSgKoo+Y6vOm/fQClPQlNEc+rkkkZjA4EI5SSKMZJAYUbrYEDhnkz8e6yxIoQ0yqlczf9IU2w3J9lMhLaMSOaDKS5MYL6plleRlsQo4H3iFT9Q+F6+5i0tuwEgf09SiH/AR3tqo2b4imxjs8Kddy7uPht+4UeDzX/j6jLxyQcnfPTTGr8yPt3+eiX2lI+EM4tf4R/rj4sx/p6d//LJ+WL3+KVZO/75/nl79g+ufkF63cjv3j0p6Zh8PhkmlBe0HiD9ScEK/zR0s4X5VI7bGYkk0wQQyGK1D+HKVZrIYbXn1HOJz8DSPGz7dEAsvCVEfPqU2qG5ZVKvVgfPAs2j6PXGR74qUNoN9QQnOk5AcghD4J6gnoSJb7yDXQ5+FJv7Jvs